/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Decal;
import com.zarkonnen.airships.DecalType;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.airships.Tile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public strictfp class MovingModule {
    public final int x;
    public final int y;
    public final ModuleType type;
    public final PaintType externalPaint;
    public final ArmourType[][] armour;
    public final PaintType[][] paint;
    public final ArrayList<DecalInfo> decals = new ArrayList();

    public MovingModule(Airship ship, int x, int y) {
        Module m = ship.moduleAt(x, y);
        this.type = m.type;
        this.externalPaint = m.externalPaint;
        x = m.x;
        y = m.y;
        this.x = x;
        this.y = y;
        this.armour = new ArmourType[this.type.getH()][this.type.getW()];
        this.paint = new PaintType[this.type.getH()][this.type.getW()];
        for (int ay = 0; ay < this.armour.length; ++ay) {
            for (int ax = 0; ax < this.armour[ay].length; ++ax) {
                Tile t = ship.tileAt(x + ax, y + ay);
                this.armour[ay][ax] = t.armour.type;
                this.paint[ay][ax] = t.armour.paint;
            }
        }
        for (Decal d : ship.decals) {
            if (d.x < x || d.x >= x + this.type.getW() || d.y < y || d.y >= y + this.type.getH()) continue;
            this.decals.add(new DecalInfo(d.type, d.x - x, d.y - y, d.layer, d.paint));
        }
    }

    public Module add(Airship ship, int x, int y, Collection<Module> ignore, int[] shift) {
        if (!ship.noModuleOverlapsOrObstructions(this.type, x, y, true, ignore)) {
            return null;
        }
        Module anchor = null;
        for (Module m : ship.modules) {
            if (ignore.contains(m)) continue;
            anchor = m;
            break;
        }
        if (anchor == null) {
            System.out.println("no anchor found");
            return null;
        }
        int anchorX = anchor.x;
        int anchorY = anchor.y;
        Module m = ship.quickAddModule(this.type, x, y);
        int xShift = anchor.x - anchorX;
        int yShift = anchor.y - anchorY;
        for (int ay = 0; ay < this.armour.length; ++ay) {
            for (int ax = 0; ax < this.armour[ay].length; ++ax) {
                Tile t = ship.tileAt(x + ax + xShift, y + ay + yShift);
                t.armour.setType(this.armour[ay][ax]);
                t.armour.paint = this.paint[ay][ax];
            }
        }
        for (DecalInfo di : this.decals) {
            if (!ship.canAddDecal(di.type, x + di.x + xShift, y + di.y + yShift, di.layer, Collections.EMPTY_LIST)) continue;
            Decal d = ship.addDecal(di.type, x + di.x + xShift, y + di.y + yShift, di.layer);
            d.paint = di.paint;
        }
        shift[0] = xShift;
        shift[1] = yShift;
        m.externalPaint = this.externalPaint;
        return m;
    }

    public boolean canAdd(Airship ship, int x, int y, Collection<Module> ignore) {
        return ship.noModuleOverlapsOrObstructions(this.type, x, y, true, ignore);
    }

    public strictfp static final class DecalInfo {
        public DecalType type;
        public int x;
        public int y;
        public int layer;
        public PaintType paint;

        public DecalInfo(DecalType type, int x, int y, int layer, PaintType paint) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.layer = layer;
            this.paint = paint;
        }
    }
}

