/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.CommandButtonsPanel;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.SelectionVisualLayer;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import org.json.JSONObject;

public strictfp class MoveTroopsTool
extends UniScreen.Tool {
    @Override
    public String getLabel() {
        return Lang._t("Move_troops_", new Object[0]);
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        d.state.setCursor("GOTO", null);
        if (us.combat.physics == null) {
            return;
        }
        GridBody moveTo = this.hoverBody(us, cursor);
        if (moveTo == null) {
            return;
        }
        d.scale(us.zoom, us.zoom);
        d.shift(us.adjScrollX, us.adjScrollY);
        boolean doBoard = us.combat.otherSide((Combat.Side)us.mySide).ships.contains(moveTo);
        SelectionVisualLayer.drawGridBodyOutline(d, us.zoom, moveTo, doBoard ? SelectionVisualLayer.TROOPS_BOARD : SelectionVisualLayer.TROOPS_MOVE, doBoard ? SelectionVisualLayer.TROOPS_BOARD2 : SelectionVisualLayer.TROOPS_MOVE2);
        d.resetTransforms();
    }

    public GridBody hoverBody(UniScreen us, Pt pt) {
        if (pt == null) {
            return null;
        }
        double mx = us.screenToWorldX(pt.x);
        double my = us.screenToWorldY(pt.y);
        for (Body b : us.combat.physics.bodies) {
            if (b == us.selectedLF || !(b instanceof GridBody) || !Rect2D.contains(b.getX(), b.getY(), b.getBBWidth(), b.getBBHeight(), mx, my)) continue;
            return (GridBody)b;
        }
        return null;
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        CommandButtonsPanel cbp = us.panel(CommandButtonsPanel.class);
        if (us.intent instanceof CombatIntent && click.x > (double)cbp.panelX && click.x < (double)(cbp.panelX + cbp.panelW) && click.y > (double)(sm.height - cbp.panelH)) {
            return false;
        }
        if (us.combat.physics == null) {
            return false;
        }
        GridBody moveTo = this.hoverBody(us, click);
        if (moveTo == null) {
            return false;
        }
        JSONObject msg = Client.msg("moveTroops").put("side", us.combat.sides.indexOf(us.mySide));
        if (us.selectedLF != null) {
            msg.put("sourceLF", us.combat.landFormations.indexOf(us.selectedLF));
        } else if (us.selectedShip != null) {
            msg.put("sourceShip", us.combat.getShipID(us.selectedShip));
        } else {
            us.tool = UniScreen.NAVIGATE;
            return false;
        }
        if (moveTo instanceof Airship) {
            msg.put("targetShip", us.combat.getShipID((Airship)moveTo));
        } else {
            msg.put("targetLF", us.combat.landFormations.indexOf((LandFormation)moveTo));
        }
        us.combat.giveCommand(msg);
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        return false;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }
}

