/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.CommandButtonsPanel;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public strictfp class MoveCommandTool
extends UniScreen.Tool {
    public boolean flipFromCurrent;
    public boolean ramming;
    public Airship.MoveMode mode = Airship.MoveMode.DEFAULT;

    public MoveCommandTool(UniScreen us, boolean ramming) {
        this.ramming = ramming;
    }

    @Override
    public String getLabel() {
        return Lang._t("Move_", new Object[0]);
    }

    private List<Airship> ships(UniScreen us) {
        if (us.selectedShip != null) {
            if (us.selectedShip.readyForCommand() && us.selectedShip.type.mobile) {
                return Collections.singletonList(us.selectedShip);
            }
            return Collections.emptyList();
        }
        ArrayList<Airship> ships = new ArrayList<Airship>();
        for (Airship s : us.selectedShips) {
            if (!s.readyForCommand() || !s.type.mobile) continue;
            ships.add(s);
        }
        return ships;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        List<Airship> ships = this.ships(us);
        if (ships.isEmpty()) {
            us.tool = UniScreen.NAVIGATE;
            return;
        }
        d.state.setCursor(this.ramming ? "RAM" : "GOTO", null);
        double top = 100000.0;
        double left = 100000.0;
        for (Airship s : ships) {
            top = StrictMath.min(s.getY(), top);
            left = StrictMath.min(s.getX(), left);
        }
        d.scale(us.zoom, us.zoom);
        d.shift(us.adjScrollX, us.adjScrollY);
        for (Airship s : ships) {
            double x = us.screenToWorldX(cursor.x) - left + s.getX();
            double y = s.type.onGround ? this.getYCoord(cursor.y, x, us, s) : StrictMath.max((double)(512 - s.serviceCeiling()), us.screenToWorldY(cursor.y) - top + s.getY());
            s.drawOutline(d, x, y, s.flipped ^ this.flipFromCurrent, this.ramming || PlaceShipTool.canPlace(s, x, y, s.flipped ^ this.flipFromCurrent, -1, us, false, null, -1) ? Clr.WHITE : Clr.RED);
        }
        d.state.cursorText = "[333333]" + Lang._t("F_to_flip", new Object[0]);
        d.resetTransforms();
        for (Airship s : ships) {
            double sx = s.getX();
            double sy = s.getY();
            boolean sf = s.flipped;
            double x = us.screenToWorldX(cursor.x) - left + s.getX();
            double y = s.type.onGround ? this.getYCoord(cursor.y, x, us, s) : StrictMath.max((double)(512 - s.serviceCeiling()), us.screenToWorldY(cursor.y) - top + s.getY());
            s.setX(x);
            s.setY(y);
            s.setFlipped(sf ^ this.flipFromCurrent, null);
            s.drawFireArcs(d, us.adjScrollX, us.adjScrollY, us.zoom, true);
            s.setX(sx);
            s.setY(sy);
            s.setFlipped(sf, null);
        }
        if (us.selectedShip != null && us.selectedShip.canFly()) {
            int sc = (int)us.worldToScreenY(512 - us.selectedShip.serviceCeiling());
            d.rect(Clr.WHITE, 0.0, sc, sm.width, 2.0);
            d.rect(Clr.WHITE, 0.0, sc + 4, sm.width, 1.0);
            d.text(Lang._t("Service_Ceiling", new Object[0]), AGame.BIG_FOUNT, 5.0, sc - 20);
        }
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        CommandButtonsPanel cbp = us.panel(CommandButtonsPanel.class);
        if (us.intent instanceof CombatIntent && click.x > (double)cbp.panelX && click.x < (double)(cbp.panelX + cbp.panelW) && click.y > (double)(sm.height - cbp.panelH)) {
            return false;
        }
        List<Airship> ships = this.ships(us);
        if (ships.isEmpty()) {
            us.tool = UniScreen.NAVIGATE;
            return false;
        }
        double top = 100000.0;
        double left = 100000.0;
        for (Airship s : ships) {
            top = StrictMath.min(s.getY(), top);
            left = StrictMath.min(s.getX(), left);
        }
        for (Airship s : ships) {
            double mx = us.screenToWorldX(click.x) - left + s.getX();
            double my = s.type.onGround ? this.getYCoord(click.y, mx, us, s) : StrictMath.max((double)(512 - s.serviceCeiling()), us.screenToWorldY(click.y) - top + s.getY());
            us.combat.giveCommand(Client.msg(this.ramming ? "ram" : "moveTo").put("id", us.combat.getShipID(s)).put("x", mx).put("y", my).put("flipTo", s.flipped ^ this.flipFromCurrent).put("moveMode", this.mode.name()));
        }
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    public double getYCoord(double screenY, double worldX, UniScreen us, Airship ship) {
        double y = us.screenToWorldY(screenY);
        if (ship.type.onGround) {
            y = (double)us.combat.landFormations.get(0).getVerticalPosition(ship, (int)worldX, ship.flipped ^ this.flipFromCurrent, true) - ship.groundOffset();
        }
        return y;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (in.keyPressed(Keys.get("move_tool_flip", "F"))) {
            boolean bl = this.flipFromCurrent = !this.flipFromCurrent;
        }
        if (in.keyPressed("ESCAPE")) {
            us.tool = UniScreen.NAVIGATE;
        }
    }
}

