/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.EmpireStat;
import com.zarkonnen.airships.HeraldicStyle;
import com.zarkonnen.airships.LandscapeType;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class MonsterNestType
extends Loadable {
    public final boolean needsRoad;
    public final Img mapImage;
    public final Img mapFleetImage;
    public final Img mapBackground;
    public final Img mapFleetBackground;
    public final int income;
    public final ArrayList<Airship> baseConstructions;
    public final ArrayList<String> baseConstructionNames;
    public final ArrayList<Airship> additionalConstructions;
    public final ArrayList<String> additionalConstructionNames;
    public final int spawnWeight;
    public final int incomeModifierPercentage;
    public final int incomeModifier;
    public final ArrayList<Reward> rewards;
    public final Img img;
    public final AIQuality aiQuality;
    public final ArrayList<String> homeFleet;
    public final int minAttackFleetStrength;
    public final int attackRadius;
    public final HeraldicStyle heraldicStyle;
    public final boolean isBiological;
    public final int msUntilUpgrade;
    public final int upgradeMsPerRaidSuccess;
    public final int msForUpgrade;
    public final boolean upgradeNearingCompletionMessage;
    public final String upgradeToName;
    public final boolean oneOnly;
    public final boolean respawns;
    public final int minTimeBetweenRaids;
    public final int minTimeBetweenCityRaids;
    public final ArrayList<Utils.Pair<Integer, LandscapeType>> landscapeTypes;
    public ArrayList<Bonus> specialTextWithBonuses = new ArrayList();

    public String bonusSuffix(Empire viewer) {
        if (viewer == null) {
            return "";
        }
        for (int i = 0; i < this.specialTextWithBonuses.size(); ++i) {
            Bonus b = this.specialTextWithBonuses.get(i);
            if (!viewer.bonuses.contains[b.ordinal()]) continue;
            return "_" + b.name;
        }
        return "";
    }

    public MonsterNestType(JSONObject o) {
        super(o.getString("name"));
        int i;
        this.img = new Img(o.optString("img", o.getString("name")));
        this.needsRoad = o.getBoolean("needsRoad");
        this.mapImage = o.has("mapImage") ? MonsterNestType.img(o.getJSONObject("mapImage")) : null;
        this.mapFleetImage = o.has("mapFleetImage") ? MonsterNestType.img(o.getJSONObject("mapFleetImage")) : null;
        this.mapBackground = o.has("mapImage") ? MonsterNestType.img(o.getJSONObject("mapBackground")) : null;
        this.mapFleetBackground = o.has("mapFleetImage") ? MonsterNestType.img(o.getJSONObject("mapFleetBackground")) : null;
        this.income = o.getInt("income");
        this.spawnWeight = o.optInt("spawnWeight", 1);
        this.incomeModifierPercentage = o.optInt("incomeModifierPercentage", 0);
        this.incomeModifier = o.optInt("incomeModifier", 0);
        this.aiQuality = AIQuality.valueOf(o.optString("aiQuality", AIQuality.NORMAL.name()));
        this.minAttackFleetStrength = o.optInt("minAttackFleetStrength", 0);
        this.attackRadius = o.optInt("attackRadius", 0);
        this.oneOnly = o.optBoolean("oneOnly", false);
        this.respawns = o.optBoolean("respawns", true);
        this.isBiological = o.optBoolean("isBiological", false);
        this.heraldicStyle = o.has("heraldicStyle") ? HeraldicStyle.ofName(o.getString("heraldicStyle")) : null;
        this.baseConstructions = new ArrayList();
        this.baseConstructionNames = new ArrayList();
        JSONArray a = o.getJSONArray("baseConstructions");
        for (i = 0; i < a.length(); ++i) {
            this.baseConstructionNames.add(a.getString(i));
        }
        this.additionalConstructions = new ArrayList();
        this.additionalConstructionNames = new ArrayList();
        a = o.getJSONArray("additionalConstructions");
        for (i = 0; i < a.length(); ++i) {
            this.additionalConstructionNames.add(a.getString(i));
        }
        a = o.getJSONArray("rewards");
        this.rewards = new ArrayList();
        for (i = 0; i < a.length(); ++i) {
            this.rewards.add(new Reward(a.getJSONObject(i), this.img, this));
        }
        this.homeFleet = new ArrayList();
        if (o.has("homeFleet")) {
            a = o.getJSONArray("homeFleet");
            for (i = 0; i < a.length(); ++i) {
                this.homeFleet.add(a.getString(i));
            }
        }
        if (o.has("specialTextWithBonuses")) {
            a = o.getJSONArray("specialTextWithBonuses");
            for (i = 0; i < a.length(); ++i) {
                this.specialTextWithBonuses.add(Bonus.ofName(a.getString(i)));
            }
        }
        this.msUntilUpgrade = o.optInt("msUntilUpgrade", 240000);
        this.upgradeMsPerRaidSuccess = o.optInt("upgradeMsPerRaidSuccess", 30000);
        this.msForUpgrade = o.optInt("msForUpgrade", 60000);
        this.upgradeToName = o.optString("upgradeTo", null);
        this.upgradeNearingCompletionMessage = o.optBoolean("upgradeNearingCompletionMessage", false);
        this.minTimeBetweenRaids = o.optInt("minTimeBetweenRaids", 120000);
        this.minTimeBetweenCityRaids = o.optInt("minTimeBetweenCityRaids", 240000);
        if (o.has("landscapeTypes")) {
            this.landscapeTypes = new ArrayList();
            a = o.getJSONArray("landscapeTypes");
            for (i = 0; i < a.length(); ++i) {
                this.landscapeTypes.add((Utils.Pair<Integer, LandscapeType>)new Utils.Pair((Object)a.getJSONObject(i).getInt("spawnWeight"), (Object)LandscapeType.ofName(a.getJSONObject(i).getString("name"))));
            }
        } else {
            this.landscapeTypes = null;
        }
    }

    public LandscapeType getLandscapeType(Random r) {
        int total = 0;
        for (Utils.Pair<Integer, LandscapeType> p : this.landscapeTypes) {
            total += ((Integer)p.a).intValue();
        }
        int roll = r.nextInt(total);
        for (Utils.Pair<Integer, LandscapeType> p : this.landscapeTypes) {
            if ((roll -= ((Integer)p.a).intValue()) > 0) continue;
            return (LandscapeType)p.b;
        }
        return (LandscapeType)this.landscapeTypes.get((int)0).b;
    }

    public static void postLoad() {
        block4: for (MonsterNestType mnt : Loadable.all(MonsterNestType.class)) {
            for (String n : mnt.baseConstructionNames) {
                try {
                    mnt.baseConstructions.add(mnt.getShip(n));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Loadable.remove(mnt);
                    continue block4;
                }
            }
            for (String n : mnt.additionalConstructionNames) {
                try {
                    mnt.additionalConstructions.add(mnt.getShip(n));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Loadable.remove(mnt);
                    continue block4;
                }
            }
        }
    }

    public MonsterNestType upgradeTo() {
        return Loadable.hasOfName(MonsterNestType.class, this.upgradeToName) ? Loadable.ofName(MonsterNestType.class, this.upgradeToName) : null;
    }

    public final Airship getShip(String name) {
        ArrayList<Mod> ms = Mod.getEnabledMods();
        Collections.reverse(ms);
        for (Mod m : ms) {
            File shipF = new File(new File(m.dir, "monsters"), name + ".json");
            if (!shipF.exists()) continue;
            try {
                return new Airship(new JSONObject(FileUtils.readFileToString((File)shipF, (String)"UTF-8")));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot load monster " + name + " from mod " + m.getName() + ".", e);
            }
        }
        File shipF = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "monsters"), name + ".json");
        try {
            return new Airship(new JSONObject(FileUtils.readFileToString((File)shipF, (String)"UTF-8")));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot load monster " + name + ".", e);
        }
    }

    public void giveRewardTo(Empire e, WorldMap wm) {
        int totalWeight = 0;
        ArrayList<Reward> available = new ArrayList<Reward>();
        for (Reward r : this.rewards) {
            if (r.bonus != null && e.hasBonus(r.bonus) || r.tech != null && e.techs.contains(r.tech)) continue;
            available.add(r);
            totalWeight += r.spawnWeight;
        }
        if (totalWeight == 0) {
            return;
        }
        int typeIndex = 0;
        for (int roll = wm.r.nextInt(totalWeight); roll >= ((Reward)available.get((int)typeIndex)).spawnWeight; roll -= ((Reward)available.get((int)typeIndex++)).spawnWeight) {
        }
        Reward reward = (Reward)available.get(typeIndex);
        e.money += reward.getMoney(e);
        e.researchPoints += reward.getResearch(e);
        if (reward.bonus != null) {
            e.bonuses.add(reward.bonus);
        }
        if (reward.tech != null) {
            e.techs.add(reward.tech);
            e.bonuses.addAll(reward.tech.bonuses);
            if (e.research == reward.tech) {
                e.research = null;
                e.researchPoints = 0;
            }
        }
        e.rewardGiven = reward;
    }

    public static MonsterNestType ofName(String name) {
        return Loadable.ofName(MonsterNestType.class, name);
    }

    public strictfp static class Reward {
        public final String name;
        public final int spawnWeight;
        private final int money;
        private final int research;
        public final Bonus bonus;
        public final Tech.Choice tech;
        public final int rep;
        public final Img img;
        public final MonsterNestType nestType;

        public Reward(JSONObject o, Img img, MonsterNestType nestType) {
            this.name = o.getString("name");
            this.spawnWeight = o.optInt("spawnWeight", 1);
            this.money = o.optInt("money", 0);
            this.bonus = o.has("bonus") ? Bonus.ofNameOrNull(o.getString("bonus")) : null;
            this.tech = o.has("tech") ? Tech.choiceOfName(o.getString("tech")) : null;
            this.rep = o.optInt("rep", 0);
            this.research = o.optInt("research", 0);
            this.nestType = nestType;
            this.img = img;
        }

        public int getMoney(Empire e) {
            if (this.nestType.isBiological) {
                return (int)((double)this.money * EmpireStat.BIO_MONSTER_MONEY_MULT.get(e.bonuses()));
            }
            return this.money;
        }

        public int getResearch(Empire e) {
            if (this.nestType.isBiological) {
                return (int)((double)this.research * EmpireStat.BIO_MONSTER_RESEARCH_MULT.get(e.bonuses()));
            }
            return this.research;
        }
    }
}

