/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.EmptyShipList;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.MonsterBackend;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;

public strictfp class MonsterHelperWidget
implements FileScreen.HelperWidget {
    private static final HashMap<String, Airship> monsters = new HashMap();
    private Airship ship = null;
    private int time = 0;
    private MonsterBackend backend;

    public MonsterHelperWidget(MonsterBackend backend) {
        this.backend = backend;
    }

    public static final void clearAllCaches() {
        monsters.clear();
    }

    @Override
    public void setSelectedFile(List<String> path) {
        File f;
        String pathS = FileScreen.joinPath(path);
        if (!monsters.containsKey(pathS) && (f = this.backend.getFile(path)) != null) {
            try {
                Airship s = new Airship(new JSONObject(FileUtils.readFileToString((File)f, (String)"UTF-8")));
                s.initWheelsLegsAndTentacles(null, new ArrayList<LandFormation>(), EmptyShipList.INSTANCE);
                monsters.put(pathS, s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ship = monsters.get(pathS);
    }

    @Override
    public void clearCacheFor(List<String> path) {
        monsters.remove(FileScreen.joinPath(path));
    }

    @Override
    public void tick(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms, ArrayList<String> dirPath) {
        this.time += ms;
        if (this.ship != null) {
            for (Module m : this.ship.modules) {
                m.time += ms;
            }
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor, int x, int y, int w, int h) {
        if (this.ship == null) {
            return;
        }
        d.rect(AGame.SKY, x + 2, y + 2, w - 4, h - 4);
        Graphics g = (Graphics)d.frame().nativeRenderer();
        g.setClip(x + 2, y + 2, w - 4, h - 4);
        int smallerDimension = StrictMath.min(w - 4, h - 4);
        int largerDimension = StrictMath.max(w - 4, h - 4);
        double shipW = (double)smallerDimension * 0.6;
        double scale = StrictMath.min(shipW / (double)this.ship.getWidth() / 16.0, shipW / (double)this.ship.getHeight() / 16.0);
        d.shift((double)(x + 2) + (double)smallerDimension * 0.2, (double)(y + 2) + (double)largerDimension * 0.5 - (double)smallerDimension * 0.3);
        d.scale(scale, scale);
        this.ship.setX(shipW / scale / 2.0 - (double)(this.ship.getWidth() * 16 / 2));
        this.ship.setY(shipW / scale / 2.0 - (double)(this.ship.getHeight() * 16 / 2));
        this.ship.initWheelsLegsAndTentacles(null, new ArrayList<LandFormation>(), EmptyShipList.INSTANCE);
        this.ship.draw(d, shipW / scale / 2.0 - (double)(this.ship.getWidth() * 16 / 2), shipW / scale / 2.0 - (double)(this.ship.getHeight() * 16 / 2), this.time, true, false, true, AirshipGame.instance.getBestCOA(), true, null, 1.0f, Color.white, 1.0f, Clr.WHITE);
        d.resetTransforms();
        g.clearClip();
        d.drawPanelBorder(x, y, w, h);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean blocking() {
        return false;
    }

    @Override
    public boolean popUpdateNeeded() {
        return false;
    }
}

