/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.NameSorter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MonsterBackend
implements FileScreen.Backend {
    private final ArrayList<FileScreen.Sorter> sorters = new ArrayList();
    private final File baseDir = new File(new File(AGame.getStaticGameDirectory(), "data"), "monsters");

    public MonsterBackend() {
        this.sorters.add(new NameSorter(this));
    }

    @Override
    public File getFile(List<String> path) {
        if (path == null) {
            return null;
        }
        if (path.size() != 1) {
            return null;
        }
        File f = new File(this.baseDir, path.get(0));
        if (f.exists()) {
            return f;
        }
        for (Mod m : Mod.getEnabledMods()) {
            f = new File(new File(m.dir, "monsters"), path.get(0));
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    @Override
    public boolean canCreateDirs() {
        return false;
    }

    @Override
    public String saveSuffix() {
        return ".json";
    }

    @Override
    public List<String> list(List<String> dirPath) {
        ArrayList<String> l = new ArrayList<String>();
        File[] fs = this.baseDir.listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (f.getName().startsWith(".") || !f.getName().endsWith(".json") || f.isDirectory()) continue;
                l.add(f.getName());
            }
        }
        for (Mod m : Mod.getEnabledMods()) {
            fs = new File(m.dir, "monsters").listFiles();
            if (fs == null) continue;
            for (File f : fs) {
                if (f.getName().startsWith(".") || !f.getName().endsWith(".json") || f.isDirectory()) continue;
                l.add(f.getName());
            }
        }
        return l;
    }

    @Override
    public File getRawFile(List<String> path) {
        return this.getFile(path);
    }

    @Override
    public boolean isLocked(List<String> path) {
        return true;
    }

    @Override
    public void delete(List<String> path) {
    }

    @Override
    public boolean isDirectory(List<String> path) {
        if (path.isEmpty()) {
            return true;
        }
        File f = this.getFile(path);
        return f != null && f.isDirectory();
    }

    @Override
    public boolean isValidName(String name) {
        return !name.isEmpty() && AGame.makeFileSafe(name).equals(name);
    }

    @Override
    public ArrayList<FileScreen.Sorter> sorters() {
        return this.sorters;
    }

    @Override
    public ArrayList<FileScreen.SettableFilter> filters() {
        return new ArrayList<FileScreen.SettableFilter>();
    }
}

