/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Arc;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.BeamSpec;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.BonusableValue;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.ExternalApp;
import com.zarkonnen.airships.HasName;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.ModuleCategory;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.SoundEffect;
import com.zarkonnen.airships.Spring;
import com.zarkonnen.airships.SpriteUtils;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.TentacleSpec;
import com.zarkonnen.airships.Tether;
import com.zarkonnen.airships.TileMask;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.airships.Wheel;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Utils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;

public strictfp class ModuleType
extends Loadable
implements HasName {
    public static final int COST_PER_TILE = 5;
    private static final HashMap<String, BufferedImage> MASKCACHE = new HashMap();
    private String flippedFrom;
    private boolean flipped;
    private ModuleType flippedVersion;
    private ModuleType verticallyFlippedVersion;
    private String verticallyFlippedVersionName;
    private final ArrayList<ModuleCategory> categories = new ArrayList();
    private EnumSet<ShipType> availableFor = EnumSet.allOf(ShipType.class);
    private int w;
    private int h;
    private BonusableValue<Integer> hp;
    private BonusableValue<Integer> destroyedHP;
    private BonusableValue<Integer> destructionLength;
    private boolean instantlyDestroyed;
    private boolean destroyEntireShipOnDestruction;
    private boolean hasGenericDestructionFragments;
    private double fragmentsSpeedMult;
    private double fragmentsFireMult;
    private double fragmentsDensity;
    private BonusableValue<Double> destructionParticleDensity;
    private BonusableValue<ParticleType> destructionParticle = BonusableValue.of(null);
    private BonusableValue<SoundEffect> destructionSound = BonusableValue.of(null);
    private BonusableValue<ParticleType> hitParticle;
    private BonusableValue<SoundEffect> runningLoop;
    private BonusableValue<Integer> msUntilPlayLoop;
    private BonusableValue<Integer> fireHP = BonusableValue.of(0);
    private BonusableValue<Integer> explodeHP = BonusableValue.of(0);
    private BonusableValue<Integer> explodeDmg;
    private BonusableValue<Integer> explodeRadius;
    private BonusableValue<Integer> explodeFuzeLength;
    private BonusableValue<Integer> moveDelay;
    private BonusableValue<Integer> weight;
    private BonusableValue<Integer> coal = BonusableValue.of(0);
    private BonusableValue<Integer> ammo = BonusableValue.of(0);
    private BonusableValue<Integer> sickbay = BonusableValue.of(0);
    private BonusableValue<Boolean> necromancy = BonusableValue.of(Boolean.FALSE);
    private BonusableValue<Integer> repair = BonusableValue.of(0);
    private BonusableValue<Integer> water = BonusableValue.of(0);
    private BonusableValue<Integer> quarters = BonusableValue.of(0);
    private BonusableValue<CrewType> quartersType = BonusableValue.of(null);
    private BonusableValue<Integer> command = BonusableValue.of(0);
    private BonusableValue<Integer> lift = BonusableValue.of(0);
    private BonusableValue<Double> propulsion = BonusableValue.of(0.0);
    private BonusableValue<Integer> coalReload;
    private BonusableValue<Integer> reload = BonusableValue.of(0);
    private boolean obeysFireMode = true;
    private BonusableValue<Integer> ammoPerClip = BonusableValue.of(0);
    private BonusableValue<Integer> clip = BonusableValue.of(0);
    private BonusableValue<Integer> clipReloadTime = BonusableValue.of(0);
    private BonusableValue<Double> inaccuracy = BonusableValue.of(0.0);
    private BonusableValue<Double> fixedInaccuracyVsTroops;
    private BonusableValue<Integer> blastDmg;
    private BonusableValue<Integer> blastSplashRadius;
    private BonusableValue<Integer> penDmg;
    private BonusableValue<Integer> directDmg;
    private BonusableValue<Integer> numShots;
    private BonusableValue<Integer> shootTroopsRange;
    private BonusableValue<Double> multiShotJitter;
    private BonusableValue<Double> shotSpeedVariation;
    private BonusableValue<Double> recoilForce;
    private boolean[] frontOnly;
    private boolean[] backOnly;
    private boolean[] bottomOnly;
    private boolean[] topOnly;
    private boolean countsAsActiveCrew;
    private boolean preventsBoarding;
    private boolean preventsSurrender;
    private BonusableValue<Integer> crew;
    private BonusableValue<Integer> optionalCrew;
    private BonusableValue<Integer> recommendedCrew;
    private BonusableValue<Integer> recommendedGuards;
    private BonusableValue<Integer> fixedGuards;
    private BonusableValue<Integer> cost = BonusableValue.of(0);
    private BonusableValue<Integer> maintenanceCost = BonusableValue.of(0);
    private BonusableValue<Integer> shipHPBonus = BonusableValue.of(0);
    private BonusableValue<Double> accuracyBonus = BonusableValue.of(0.0);
    private BonusableValue<Appearance> app;
    private boolean isRam;
    private boolean isSail;
    private BonusableValue<Arc> fireArc = BonusableValue.of(null);
    private BonusableValue<Arc> innerTwoThirdsFireArc = BonusableValue.of(null);
    private BonusableValue<Double> muzzleCenterX;
    private BonusableValue<Double> muzzleCenterY;
    private BonusableValue<Double> muzzleLength;
    private BonusableValue<Boolean> muzzleFlash;
    private BonusableValue<WeaponAppearance> weaponAppearance = BonusableValue.of(null);
    private BonusableValue<BeamSpec> beamSpec = BonusableValue.of(null);
    private boolean isWeapon;
    private BonusableValue<Tether.Spec> tetherSpec = BonusableValue.of(null);
    private BonusableValue<Integer> maxXRange = BonusableValue.of(0);
    private BonusableValue<Integer> minXRange = BonusableValue.of(0);
    private BonusableValue<Integer> maxUpRange = BonusableValue.of(0);
    private BonusableValue<Integer> maxRange = BonusableValue.of(0);
    private BonusableValue<SoundEffect> fireSound = BonusableValue.of(null);
    private BonusableValue<SoundEffect> hitSound = BonusableValue.of(null);
    private BonusableValue<Integer> optimumRange = BonusableValue.of(500);
    private BonusableValue<Integer> soundEvery = BonusableValue.of(1);
    private final ArrayList<Utils.Pair<Integer, Integer>> windows = new ArrayList();
    private final ArrayList<Utils.Pair<Integer, Integer>> canOccupy = new ArrayList();
    private final ArrayList<Utils.Pair<Integer, Integer>> hangarPositions = new ArrayList();
    private BonusableValue<ArrayList<ModuleParticleEmitter>> emitters;
    private BonusableValue<ArrayList<ModuleParticleEmitter>> damagedEmitters;
    private BonusableValue<ArrayList<ModuleParticleEmitter>> destroyedEmitters;
    private BonusableValue<ArrayList<ExternalApp>> externalApps;
    private BonusableValue<ArrayList<ExternalApp>> damagedExternalApps;
    private BonusableValue<ArrayList<ExternalApp>> destroyedExternalApps;
    private double extraVerticalAirFriction = 0.0;
    private boolean[] leftDoors;
    private boolean[] rightDoors;
    private boolean[] upDoors;
    private Bonus required;
    private BonusableValue<Double> jitterMerge;
    private BonusableValue<Double> shotSpeed;
    private boolean external = false;
    private ArmourType armourType = null;
    private boolean drawDoors = true;
    private boolean framesAreVariants = false;
    private int externalDrawPriority = 1;
    private boolean drawExternalsWhenInside = false;
    private BonusableValue<Integer> supplyProvided;
    private boolean doesCreak = true;
    private BonusableValue<Double> adjacencyBonusStrength;
    private BonusableValue<Integer> structuralStressAmount;
    private BonusableValue<Double> hardness;
    private BonusableValue<Double> collisionDamageReceivedMult;
    private boolean canParticlesStick;
    private ArrayList<Spring> springs = new ArrayList();
    private ArrayList<Wheel.Spec> wheelSpecs = new ArrayList();
    private ArrayList<Leg.Spec> legSpecs = new ArrayList();
    private BonusableValue<ArrayList<ModuleLightSource>> lights;
    private ArrayList<TentacleSpec> tentacleSpecs = new ArrayList();
    private boolean tentacleDeathSpasms = false;
    private int createsExceptionalCombatEventAfterMs = 0;
    private int aiMaxY = 10000;
    private BonusableValue<TileMask[][]> tileMasks;
    private BonusableValue<Img> armourMask;
    public Clr externalSubColor;
    public Clr externalSubBaseColor;
    public Clr[] externalSubColorByPaintIndex;
    private boolean drawAppearanceInside;
    private boolean producesHorizontalDrag;
    private boolean playDestructionSoundAtStartOfDestruction;
    private boolean runsWhenDestroyed;
    public boolean isTargetComp;
    private BonusableValue<ArrayList<ArrayList<FragmentImg>>> appFragments;
    private BonusableValue<ArrayList<ArrayList<FragmentImg>>> appWreckage;
    private BonusableValue<ArrayList<ArrayList<ArrayList<FragmentImg>>>> externalFragments;
    public static ArrayList<ModuleType> tracks = new ArrayList();
    public static ArrayList<ModuleType> interesting = new ArrayList();
    public static ArrayList<ModuleType> keelsAndRams = new ArrayList();
    private static final ArrayList<String> WHEEL_AND_LEG_PREFIXES = new ArrayList<String>(Arrays.asList("wheel", "lowerLink", "upperLink", "foot", "lowerLeg", "upperLeg"));

    public void draw(Draw d, double x, double y, int ms, boolean flipped, int variant, BonusSet bonuses) {
        if (this.framesAreVariants) {
            ms = variant * this.app.get(bonuses).getInterval();
        }
        this.getApp(bonuses).draw(d, x, y, ms, flipped);
    }

    public void drawAsBlueprint(Draw d, double x, double y, int ms, boolean flipped, int variant, BonusSet bonuses, float intensity) {
        if (this.framesAreVariants) {
            ms = variant * this.app.get(bonuses).getInterval();
        }
        this.getApp(bonuses).drawAsBlueprint(d, x, y, ms, flipped, intensity);
    }

    public void drawAsRedOutline(Draw d, double x, double y, int ms, boolean flipped, int variant, BonusSet bonuses) {
        if (this.framesAreVariants) {
            ms = variant * this.app.get(bonuses).getInterval();
        }
        this.getApp(bonuses).drawAsRedSolid(d, x, y, ms, flipped);
    }

    public void draw(Draw d, double x, double y, int ms, boolean flipped, int variant, BonusSet bonuses, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        if (this.framesAreVariants) {
            ms = variant * this.app.get(bonuses).getInterval();
        }
        this.getApp(bonuses).draw(d, x, y, ms, flipped, light, lightStrength, ambient, ambientSaturation);
    }

    public void draw(Draw d, double x, double y, int ms, Clr clr, boolean flipped, int variant, BonusSet bonuses, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        if (this.framesAreVariants) {
            ms = variant * this.app.get(bonuses).getInterval();
        }
        this.getApp(bonuses).draw(d, x, y, ms, clr, flipped, light, lightStrength, ambient, ambientSaturation);
    }

    public void drawBack(Draw d, double x, double y, int ms, Clr clr, boolean flipped, int variant, BonusSet bonuses, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        if (this.framesAreVariants) {
            ms = variant * this.app.get(bonuses).getInterval();
        }
        this.getBack(bonuses).draw(d, x, y, ms, clr, flipped, light, lightStrength, ambient, ambientSaturation);
    }

    public void drawExternal(Draw d, double x, double y, int ms, boolean flipped, int variant, BonusSet bonuses, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, boolean damaged, boolean destroyed, PaintType subPaintType) {
        if (this.framesAreVariants) {
            ms = variant * this.app.get(bonuses).getInterval();
        }
        ArrayList<ExternalApp> eas = this.getExternalApps(bonuses, damaged, destroyed);
        int easz = eas.size();
        for (int eai = 0; eai < easz; ++eai) {
            float shiny;
            ExternalApp ea = eas.get(eai);
            if (ea.app.spritesheetBundle != ssb) {
                if (additionalSSBs == null) continue;
                additionalSSBs.add(ea.app.spritesheetBundle);
                continue;
            }
            Clr subTrg = null;
            if (this.externalSubColor != null) {
                subTrg = subPaintType == null ? this.externalSubColor : this.externalSubColorByPaintIndex[subPaintType.ordinal()];
            }
            float f = shiny = subPaintType == null ? 0.36f : subPaintType.shinyOrPassthrough();
            if (flipped) {
                int newDx = this.w - ea.dx - ea.app.width();
                ea.app.drawSub(d, x + (double)(newDx * 16), y + (double)(ea.dy * 16), 0.0, 0.0, ms, null, flipped, light, lightStrength, ambient, ambientSaturation, this.externalSubColor, subTrg, shiny);
                continue;
            }
            ea.app.drawSub(d, x + (double)(ea.dx * 16), y + (double)(ea.dy * 16), 0.0, 0.0, ms, null, flipped, light, lightStrength, ambient, ambientSaturation, this.externalSubColor, subTrg, shiny);
        }
    }

    public boolean hasColoration() {
        return this.externalSubColor != null;
    }

    public Clr colorationDefault() {
        return this.externalSubColor;
    }

    public boolean canOccupy(int x, int y) {
        for (Utils.Pair<Integer, Integer> p : this.canOccupy) {
            if ((Integer)p.a != x || (Integer)p.b != y) continue;
            return true;
        }
        return false;
    }

    public int getResourceCapacity(Resource r, BonusSet bonuses) {
        switch (r) {
            case AMMO: {
                return this.ammo.get(bonuses);
            }
            case COAL: {
                return this.coal.get(bonuses);
            }
            case REPAIR: {
                return this.repair.get(bonuses);
            }
            case WATER: {
                return this.water.get(bonuses);
            }
        }
        return 0;
    }

    public final boolean isOccupable() {
        return !this.canOccupy.isEmpty();
    }

    public boolean isWeapon() {
        return this.isWeapon;
    }

    public boolean isRam() {
        return this.isRam;
    }

    public double DPS(BonusSet bonuses) {
        return (double)(this.blastDmg.get(bonuses) * (this.blastSplashRadius.get(bonuses) > 0 ? 3 : 1) + this.penDmg.get(bonuses) + this.directDmg.get(bonuses)) * 1000.0 / (double)this.reload.get(bonuses).intValue();
    }

    public int getOccupableTileCount() {
        return this.canOccupy.size();
    }

    public boolean in(ModuleCategory mc) {
        return this.categories.contains(mc);
    }

    public boolean hidden() {
        return this.categories.isEmpty();
    }

    boolean drawAppearanceInside() {
        return this.drawAppearanceInside;
    }

    boolean producesHorizontalDrag() {
        return this.producesHorizontalDrag;
    }

    public boolean playDestructionSoundAtStartOfDestruction() {
        return this.playDestructionSoundAtStartOfDestruction;
    }

    public boolean runsWhenDestroyed() {
        return this.runsWhenDestroyed;
    }

    public ModuleType(JSONObject o) {
        super(o.getString("name"), o.optInt("sort", 0));
        int i;
        int i2;
        this.isTargetComp = o.getString("name").equals("TARGETING_COMPUTER");
        if (o.has("flippedFrom")) {
            this.flippedFrom = o.getString("flippedFrom");
            return;
        }
        this.verticallyFlippedVersionName = o.optString("verticallyFlippedVersion", null);
        this.w = o.getInt("w");
        this.h = o.getInt("h");
        this.app = BonusableValue.objectFromJSONRequired(o, "appearance", new Appearance.FromJSON());
        this.appFragments = BonusableValue.derive(this.app, new BonusableValue.Derive<Appearance, ArrayList<ArrayList<FragmentImg>>>(){

            @Override
            public ArrayList<ArrayList<FragmentImg>> derive(Appearance from) {
                return new ArrayList<ArrayList<FragmentImg>>();
            }
        });
        this.appWreckage = BonusableValue.derive(this.app, new BonusableValue.Derive<Appearance, ArrayList<ArrayList<FragmentImg>>>(){

            @Override
            public ArrayList<ArrayList<FragmentImg>> derive(Appearance from) {
                return new ArrayList<ArrayList<FragmentImg>>();
            }
        });
        TileMask[][] defaultTMs = new TileMask[this.h][this.w];
        for (int y = 0; y < this.h; ++y) {
            for (int x = 0; x < this.w; ++x) {
                defaultTMs[y][x] = TileMask.FULL;
            }
        }
        this.tileMasks = BonusableValue.objectFromJSON(o, "mask", defaultTMs, new BonusableValue.FromJSON<TileMask[][]>(){

            @Override
            public TileMask[][] construct(JSONObject o, BonusSet b) {
                TileMask[][] tms = new TileMask[ModuleType.this.h][ModuleType.this.w];
                String src = ((Appearance)((ModuleType)ModuleType.this).app.get((BonusSet)b)).spritesheetBundle.name;
                int mx = o.getInt("x");
                int my = o.getInt("y");
                if (!MASKCACHE.containsKey(src)) {
                    MASKCACHE.put(src, SpriteUtils.loadBufferedImage(src));
                }
                BufferedImage img = (BufferedImage)MASKCACHE.get(src);
                for (int y = 0; y < ModuleType.this.h; ++y) {
                    for (int x = 0; x < ModuleType.this.w; ++x) {
                        tms[y][x] = TileMask.fromImage(img, (mx + x) * 16, (my + y) * 16);
                    }
                }
                return tms;
            }
        });
        this.armourMask = !o.optBoolean("external", false) ? BonusableValue.objectFromJSON(o, "mask", null, new BonusableValue.FromJSON<Img>(){

            @Override
            public Img construct(JSONObject o, BonusSet b) {
                String src = ((Appearance)((ModuleType)ModuleType.this).app.get((BonusSet)b)).spritesheetBundle.name;
                int mx = o.getInt("x");
                int my = o.getInt("y");
                return new Img(src, mx * 16, my * 16, ModuleType.this.w * 16, ModuleType.this.h * 16, false);
            }
        }) : BonusableValue.of(null);
        this.drawAppearanceInside = o.optBoolean("drawAppearanceInside", true);
        for (int x = 0; x < this.w; ++x) {
            this.canOccupy.add((Utils.Pair<Integer, Integer>)Utils.p((Object)x, (Object)(this.h - 1)));
        }
        if (o.has("canOccupy")) {
            this.canOccupy.clear();
            JSONArray ws = o.getJSONArray("canOccupy");
            for (i2 = 0; i2 < ws.length(); ++i2) {
                this.canOccupy.add((Utils.Pair<Integer, Integer>)new Utils.Pair((Object)ws.getJSONObject(i2).getInt("x"), (Object)ws.getJSONObject(i2).getInt("y")));
            }
        }
        this.leftDoors = new boolean[this.h];
        this.leftDoors[this.h - 1] = true;
        this.rightDoors = new boolean[this.h];
        this.rightDoors[this.h - 1] = true;
        this.upDoors = new boolean[this.w];
        this.frontOnly = new boolean[this.h];
        this.backOnly = new boolean[this.h];
        this.topOnly = new boolean[this.w];
        this.bottomOnly = new boolean[this.w];
        JSONArray cats = o.getJSONArray("categories");
        for (i2 = 0; i2 < cats.length(); ++i2) {
            this.categories.add(ModuleCategory.ofName(cats.getString(i2)));
        }
        this.hp = BonusableValue.intFromJSON(o, "hp", 100);
        this.destroyedHP = BonusableValue.intFromJSON(o, "destroyedHP", -this.hp.get(BonusSet.empty()).intValue() / 2);
        this.destructionLength = BonusableValue.intFromJSON(o, "destructionLength", 0);
        this.instantlyDestroyed = o.optBoolean("instantlyDestroyed", false);
        this.destroyEntireShipOnDestruction = o.optBoolean("destroyEntireShipOnDestruction", false);
        this.fireHP = BonusableValue.intFromJSON(o, "fireHP", 0);
        this.explodeHP = BonusableValue.intFromJSON(o, "explodeHP", -1);
        this.explodeDmg = BonusableValue.intFromJSON(o, "explodeDmg", 0);
        this.explodeRadius = BonusableValue.derive(this.explodeDmg, new BonusableValue.Derive<Integer, Integer>(){

            @Override
            public Integer derive(Integer from) {
                return from == 0 ? 0 : (int)StrictMath.floor(20.0 + StrictMath.sqrt(from * 4));
            }
        });
        this.explodeFuzeLength = BonusableValue.intFromJSON(o, "explodeFuzeLength", 1500);
        this.hasGenericDestructionFragments = o.optBoolean("hasGenericDestructionFragments", true);
        this.destructionParticle = BonusableValue.loadableFromJSON(o, "destructionParticle", ParticleType.ofName("big_smoke"), ParticleType.class);
        this.destructionParticleDensity = BonusableValue.doubleFromJSON(o, "destructionParticleDensity", 0.3);
        this.aiMaxY = o.optInt("aiMaxY", 10000);
        if (o.has("destructionSound")) {
            try {
                this.destructionSound = BonusableValue.of(new SoundEffect(o.getString("destructionSound"), o.optInt("numDestructionSounds", 1), o.optDouble("destructionSoundVolume", 1.0)));
            }
            catch (Exception e) {
                this.destructionSound = BonusableValue.objectFromJSON(o, "destructionSound", null, new SoundEffect.FromJSON(false));
            }
        }
        this.hitParticle = BonusableValue.loadableFromJSON(o, "hitParticle", null, ParticleType.class);
        this.fragmentsSpeedMult = o.optDouble("fragmentsSpeedMult", 1.0);
        this.fragmentsFireMult = o.optDouble("fragmentsFireMult", 1.0);
        this.fragmentsDensity = o.optDouble("fragmentsDensity", 0.5);
        this.runningLoop = BonusableValue.objectFromJSON(o, "runningLoop", null, new SoundEffect.FromJSON(true));
        this.msUntilPlayLoop = BonusableValue.intFromJSON(o, "msUntilPlayLoop", 80);
        this.moveDelay = BonusableValue.intFromJSONWithDivAndMinAndMax(o, "moveDelay", 800, 1, 10, 10000);
        this.weight = BonusableValue.intFromJSON(o, "weight", 100);
        this.coal = BonusableValue.intFromJSON(o, "coal", 0);
        this.ammo = BonusableValue.intFromJSON(o, "ammo", 0);
        this.sickbay = BonusableValue.intFromJSON(o, "sickbay", 0);
        this.necromancy = BonusableValue.booleanFromJSON(o, "necromancy", false);
        this.repair = BonusableValue.intFromJSON(o, "repair", 0);
        this.water = BonusableValue.intFromJSON(o, "water", 0);
        this.quarters = this.isOccupable() ? BonusableValue.intFromJSON(o, "quarters", 0) : BonusableValue.of(0);
        this.countsAsActiveCrew = o.optBoolean("countsAsActiveCrew", false);
        this.preventsBoarding = o.optBoolean("preventsBoarding", false);
        this.preventsSurrender = o.optBoolean("preventsSurrender", false);
        if (this.isOccupable()) {
            this.quartersType = BonusableValue.loadableFromJSON(o, "quartersType", null, CrewType.class);
        } else {
            this.quartersType = BonusableValue.of(null);
            this.quarters = BonusableValue.of(0);
        }
        this.command = BonusableValue.intFromJSON(o, "command", 0);
        this.lift = BonusableValue.intFromJSON(o, "lift", 0);
        this.propulsion = BonusableValue.doubleFromJSON(o, "propulsion", 0.0);
        this.coalReload = BonusableValue.intFromJSON(o, "coalReload", 0);
        this.crew = this.isOccupable() ? BonusableValue.intFromJSON(o, "crew", 0) : BonusableValue.of(0);
        this.optionalCrew = this.isOccupable() ? BonusableValue.intFromJSON(o, "optionalCrew", 0) : BonusableValue.of(0);
        this.recommendedCrew = this.isOccupable() ? BonusableValue.intFromJSON(o, "recommendedCrew", 0) : BonusableValue.of(0);
        this.recommendedGuards = this.isOccupable() ? BonusableValue.intFromJSON(o, "recommendedGuards", 0) : BonusableValue.of(0);
        this.fixedGuards = this.isOccupable() ? BonusableValue.intFromJSON(o, "fixedGuards", 0) : BonusableValue.of(0);
        this.cost = BonusableValue.intFromJSON(o, "cost", 0);
        this.maintenanceCost = BonusableValue.intFromJSON(o, "maintenanceCost", 0);
        this.shipHPBonus = BonusableValue.intFromJSON(o, "shipHPBonus", 0);
        this.accuracyBonus = BonusableValue.doubleFromJSON(o, "accuracyBonus", 0.0);
        this.isWeapon = o.optBoolean("isWeapon", false);
        this.isRam = o.optBoolean("isRam", false);
        this.isSail = o.optBoolean("isSail", false);
        this.framesAreVariants = o.optBoolean("framesAreVariants", false);
        this.doesCreak = o.optBoolean("doesCreak", true);
        this.adjacencyBonusStrength = BonusableValue.doubleFromJSON(o, "adjacencyBonusStrength", 1.0);
        this.structuralStressAmount = o.has("structuralStressAmount") ? BonusableValue.intFromJSON(o, "structuralStressAmount", 0) : this.weight;
        this.hardness = BonusableValue.doubleFromJSON(o, "hardness", 1.0);
        this.collisionDamageReceivedMult = BonusableValue.doubleFromJSON(o, "collisionDamageReceivedMult", 1.0);
        this.canParticlesStick = o.optBoolean("canParticlesStick", true);
        this.createsExceptionalCombatEventAfterMs = o.optInt("createsExceptionalCombatEventAfterMs", 0);
        this.producesHorizontalDrag = o.optBoolean("producesHorizontalDrag", true);
        this.playDestructionSoundAtStartOfDestruction = o.optBoolean("playDestructionSoundAtStartOfDestruction", false);
        this.runsWhenDestroyed = o.optBoolean("runsWhenDestroyed", false);
        this.extraVerticalAirFriction = o.optDouble("extraVerticalAirFriction", 0.0);
        if (o.has("availableFor")) {
            this.availableFor.clear();
            JSONArray af = o.getJSONArray("availableFor");
            for (i = 0; i < af.length(); ++i) {
                this.availableFor.add(ShipType.valueOf(af.getString(i)));
            }
        }
        if (o.has("windows")) {
            JSONArray ws = o.getJSONArray("windows");
            for (i = 0; i < ws.length(); ++i) {
                this.windows.add((Utils.Pair<Integer, Integer>)new Utils.Pair((Object)ws.getJSONObject(i).getInt("x"), (Object)ws.getJSONObject(i).getInt("y")));
            }
        }
        if (o.has("hangarPositions")) {
            JSONArray ws = o.getJSONArray("hangarPositions");
            for (i = 0; i < ws.length(); ++i) {
                this.hangarPositions.add((Utils.Pair<Integer, Integer>)new Utils.Pair((Object)ws.getJSONObject(i).getInt("x"), (Object)ws.getJSONObject(i).getInt("y")));
            }
        }
        this.emitters = BonusableValue.listFromJSON(o, "emitters", new ArrayList(), new ModuleParticleEmitter.FromJSON());
        this.damagedEmitters = BonusableValue.listFromJSON(o, "damagedEmitters", new ArrayList(), new ModuleParticleEmitter.FromJSON());
        this.destroyedEmitters = BonusableValue.listFromJSON(o, "destroyedEmitters", new ArrayList(), new ModuleParticleEmitter.FromJSON());
        this.externalApps = BonusableValue.listFromJSON(o, "externalAppearances", new ArrayList(), new ExternalApp.FromJSON());
        this.damagedExternalApps = o.has("damagedExternalAppearances") ? BonusableValue.listFromJSON(o, "damagedExternalAppearances", new ArrayList(), new ExternalApp.FromJSON()) : null;
        this.destroyedExternalApps = o.has("destroyedExternalAppearances") ? BonusableValue.listFromJSON(o, "destroyedExternalAppearances", new ArrayList(), new ExternalApp.FromJSON()) : null;
        this.externalFragments = BonusableValue.derive(this.externalApps, new BonusableValue.Derive<ArrayList<ExternalApp>, ArrayList<ArrayList<ArrayList<FragmentImg>>>>(){

            @Override
            public ArrayList<ArrayList<ArrayList<FragmentImg>>> derive(ArrayList<ExternalApp> from) {
                return new ArrayList<ArrayList<ArrayList<FragmentImg>>>();
            }
        });
        if (o.has("externalSubColor")) {
            JSONObject co = o.getJSONObject("externalSubColor");
            this.externalSubColor = new Clr(co.getInt("r"), co.getInt("g"), co.getInt("b"));
            if (o.has("externalSubBaseColor")) {
                JSONObject bco = o.getJSONObject("externalSubBaseColor");
                this.externalSubBaseColor = new Clr(bco.getInt("r"), bco.getInt("g"), bco.getInt("b"));
            } else {
                this.externalSubBaseColor = this.externalSubColor;
            }
            ArrayList<PaintType> ps = PaintType.values();
            this.externalSubColorByPaintIndex = new Clr[ps.size()];
            for (int i3 = 0; i3 < ps.size(); ++i3) {
                Clr tc = ps.get(i3).getBaseTint();
                this.externalSubColorByPaintIndex[i3] = new Clr(this.externalSubBaseColor.r * (255 - tc.a) / 255 + tc.r * tc.a / 255, this.externalSubBaseColor.g * (255 - tc.a) / 255 + tc.g * tc.a / 255, this.externalSubBaseColor.b * (255 - tc.a) / 255 + tc.b * tc.a / 255);
            }
        }
        if (o.has("leftDoors")) {
            JSONArray ds = o.getJSONArray("leftDoors");
            this.leftDoors[this.h - 1] = false;
            for (int i4 = 0; i4 < ds.length(); ++i4) {
                this.leftDoors[ds.getInt((int)i4)] = true;
            }
        }
        if (o.has("rightDoors")) {
            JSONArray ds = o.getJSONArray("rightDoors");
            this.rightDoors[this.h - 1] = false;
            for (int i5 = 0; i5 < ds.length(); ++i5) {
                this.rightDoors[ds.getInt((int)i5)] = true;
            }
        }
        if (o.has("upDoors")) {
            JSONArray ds = o.getJSONArray("upDoors");
            for (int i6 = 0; i6 < ds.length(); ++i6) {
                this.upDoors[ds.getInt((int)i6)] = true;
            }
        }
        if (o.optBoolean("frontOnly", false)) {
            for (int i7 = 0; i7 < this.rightDoors.length; ++i7) {
                this.rightDoors[i7] = false;
                this.frontOnly[i7] = true;
            }
        }
        if (o.optBoolean("backOnly", false)) {
            for (int i8 = 0; i8 < this.leftDoors.length; ++i8) {
                this.leftDoors[i8] = false;
                this.backOnly[i8] = true;
            }
        }
        if (o.optBoolean("bottomOnly", false)) {
            for (int i9 = 0; i9 < this.bottomOnly.length; ++i9) {
                this.bottomOnly[i9] = true;
            }
        }
        if (o.optBoolean("topOnly", false)) {
            for (int i10 = 0; i10 < this.upDoors.length; ++i10) {
                this.upDoors[i10] = false;
                this.topOnly[i10] = true;
            }
        }
        if (o.has("frontOnlyList")) {
            JSONArray l = o.getJSONArray("frontOnlyList");
            for (int i11 = 0; i11 < l.length(); ++i11) {
                this.frontOnly[l.getInt((int)i11)] = true;
            }
        }
        if (o.has("backOnlyList")) {
            JSONArray l = o.getJSONArray("backOnlyList");
            for (int i12 = 0; i12 < l.length(); ++i12) {
                this.backOnly[l.getInt((int)i12)] = true;
            }
        }
        if (o.has("bottomOnlyList")) {
            JSONArray l = o.getJSONArray("bottomOnlyList");
            for (int i13 = 0; i13 < l.length(); ++i13) {
                this.bottomOnly[l.getInt((int)i13)] = true;
            }
        }
        if (o.has("topOnlyList")) {
            JSONArray l = o.getJSONArray("topOnlyList");
            for (int i14 = 0; i14 < l.length(); ++i14) {
                this.topOnly[l.getInt((int)i14)] = true;
            }
        }
        if (o.has("required")) {
            this.required = Bonus.ofNameOrNull(o.getString("required"));
        }
        this.external = o.optBoolean("external", false);
        if (o.has("armourType")) {
            this.armourType = ArmourType.ofName(o.getString("armourType"));
        }
        this.drawDoors = o.optBoolean("drawDoors", true);
        if (o.optBoolean("externalDrawPriority", false)) {
            this.externalDrawPriority = 2;
        }
        if (o.optBoolean("drawExternalsBelowDecals", false)) {
            this.externalDrawPriority = 0;
        }
        this.drawExternalsWhenInside = o.optBoolean("drawExternalsWhenInside", false);
        this.supplyProvided = BonusableValue.intFromJSON(o, "supplyProvided", 0);
        if (o.has("springs")) {
            JSONArray ss = o.getJSONArray("springs");
            for (int i15 = 0; i15 < ss.length(); ++i15) {
                JSONObject s = ss.getJSONObject(i15);
                this.springs.add(new Spring(s.getDouble("xOffset"), s.getInt("length"), s.getInt("minCompressedLength"), s.getDouble("k"), s.optDouble("xFriction", 0.002), s.optDouble("yFriction", 0.003)));
            }
        }
        if (o.has("wheels")) {
            JSONArray ws = o.getJSONArray("wheels");
            for (int i16 = 0; i16 < ws.length(); ++i16) {
                JSONObject wh = ws.getJSONObject(i16);
                this.wheelSpecs.add(new Wheel.Spec(wh.getDouble("xOffset"), wh.getDouble("maxYOffset"), wh.getDouble("radius"), ModuleType.img(wh.getJSONObject("wheel")), ModuleType.img(wh.getJSONObject("lowerLink")), ModuleType.img(wh.getJSONObject("upperLink")), wh.getDouble("segmentStride")));
            }
        }
        if (o.has("legs")) {
            JSONArray ls = o.getJSONArray("legs");
            for (int i17 = 0; i17 < ls.length(); ++i17) {
                JSONObject l = ls.getJSONObject(i17);
                JSONObject s = l.getJSONObject("spring");
                Spring spr = new Spring(s.getDouble("xOffset"), s.getInt("length"), s.getInt("minCompressedLength"), s.getDouble("k"), s.optDouble("xFriction", 0.004), s.optDouble("yFriction", 0.005));
                SoundEffect beginStepSoundEffect = null;
                if (l.has("beginStepSound")) {
                    try {
                        beginStepSoundEffect = new SoundEffect(l.getString("beginStepSound"), l.optInt("numBeginStepSounds", 1), l.optDouble("beginStepSoundVolume", 1.0));
                    }
                    catch (Exception e) {
                        beginStepSoundEffect = new SoundEffect(l.getJSONObject("beginStepSound"));
                    }
                }
                SoundEffect footDownSoundEffect = null;
                if (l.has("footDownSound")) {
                    footDownSoundEffect = new SoundEffect(l.getJSONObject("footDownSound"));
                }
                this.legSpecs.add(new Leg.Spec(l.getBoolean("back"), l.getDouble("xOffset"), l.getDouble("yOffset"), l.optDouble("upperLimbLength", l.optDouble("limbLength", 0.0)), l.optDouble("middleLimbLength", 0.0), l.optDouble("lowerLimbLength", l.optDouble("limbLength", 0.0)), l.getDouble("footWidth"), l.getDouble("footHeight"), l.getInt("stepLength"), l.getInt("maxStepTime"), l.getBoolean("bendForwards"), spr, ModuleType.img(l.getJSONObject("upperLeg")), l.has("middleLeg") ? ModuleType.img(l.getJSONObject("middleLeg")) : null, ModuleType.img(l.getJSONObject("lowerLeg")), ModuleType.img(l.getJSONObject("foot")), beginStepSoundEffect, footDownSoundEffect, l.optDouble("minFootY", -10000.0)));
            }
        }
        if (o.has("tentacles")) {
            JSONArray ts = o.getJSONArray("tentacles");
            for (int i18 = 0; i18 < ts.length(); ++i18) {
                this.tentacleSpecs.add(new TentacleSpec(ts.getJSONObject(i18)));
            }
            this.tentacleDeathSpasms = o.optBoolean("tentacleDeathSpasms", false);
        }
        this.lights = BonusableValue.listFromJSON(o, "lights", new ArrayList(), new BonusableValue.FromJSON<ModuleLightSource>(){

            @Override
            public ModuleLightSource construct(JSONObject l, BonusSet bs) {
                return new ModuleLightSource(new Clr(l.getInt("r"), l.getInt("g"), l.getInt("b")), l.getInt("radius"), l.getDouble("x"), l.getDouble("y"), l.optBoolean("outside"));
            }
        });
        this.soundEvery = BonusableValue.intFromJSON(o, "soundEvery", 1);
        if (this.isWeapon) {
            this.reload = BonusableValue.intFromJSONWithDivAndMinAndMax(o, "reload", 1000, 1, 1, 100000);
            this.obeysFireMode = o.optBoolean("obeysFireMode", true);
            this.clip = BonusableValue.intFromJSON(o, "clip", 1);
            this.ammoPerClip = BonusableValue.intFromJSON(o, "ammoPerClip", 1);
            this.clipReloadTime = BonusableValue.intFromJSON(o, "clipReloadTime", 0);
            this.inaccuracy = BonusableValue.doubleFromJSON(o, "inaccuracy", 0.0);
            this.fixedInaccuracyVsTroops = BonusableValue.doubleFromJSON(o, "fixedInaccuracyVsTroops", 5.0);
            if (o.has("blastSplashRadius")) {
                this.blastDmg = BonusableValue.intFromJSON(o, "blastDmg", 0);
                this.blastSplashRadius = BonusableValue.intFromJSON(o, "blastSplashRadius", 0);
            } else {
                this.blastDmg = BonusableValue.intFromJSON(o, "blastDmg", 0);
                this.blastSplashRadius = BonusableValue.of(this.blastDmg.get(BonusSet.empty()) > 9 ? (int)StrictMath.floor(13.0 + StrictMath.sqrt(this.blastDmg.get(BonusSet.empty()) * 5)) : 0);
                if (this.blastDmg.get(BonusSet.empty()) > 9) {
                    this.blastDmg = BonusableValue.intFromJSONWithDivAndMinAndMax(o, "blastDmg", 0, 4, 0, 100000);
                }
            }
            this.penDmg = BonusableValue.intFromJSON(o, "penDmg", 0);
            this.directDmg = BonusableValue.intFromJSON(o, "directDmg", 0);
            this.numShots = BonusableValue.intFromJSON(o, "numShots", 1);
            this.multiShotJitter = BonusableValue.doubleFromJSON(o, "multiShotJitter", 0.0);
            this.shotSpeedVariation = BonusableValue.doubleFromJSON(o, "shotSpeedVariation", 0.25);
            this.recoilForce = BonusableValue.doubleFromJSON(o, "recoilForce", 0.0);
            this.fireArc = BonusableValue.objectFromJSONRequired(o, "fireArc", new Arc.FromJSON());
            this.innerTwoThirdsFireArc = BonusableValue.derive(this.fireArc, new Arc.InnerTwoThirds());
            this.muzzleCenterX = BonusableValue.doubleFromJSON(o, "muzzleCenterX", (double)this.w * 0.5);
            this.muzzleCenterY = BonusableValue.doubleFromJSON(o, "muzzleCenterY", (double)this.h * 0.5);
            this.muzzleLength = BonusableValue.doubleFromJSON(o, "muzzleLength", 1.0);
            this.muzzleFlash = BonusableValue.booleanFromJSON(o, "muzzleFlash", true);
            this.weaponAppearance = BonusableValue.objectFromJSONRequired(o, "weaponAppearance", new WeaponAppearance.FromJSON(this.w));
            this.beamSpec = BonusableValue.objectFromJSON(o, "beamSpec", null, new BeamSpec.FromJSON());
            this.maxRange = BonusableValue.intFromJSON(o, "maxRange", 0);
            this.maxXRange = BonusableValue.intFromJSON(o, "maxXRange", 0);
            this.minXRange = BonusableValue.intFromJSON(o, "minXRange", 0);
            this.maxUpRange = BonusableValue.intFromJSON(o, "maxUpRange", 0);
            if (o.has("fireSound")) {
                try {
                    this.fireSound = BonusableValue.of(new SoundEffect(o.getString("fireSound"), o.optInt("fireSoundCount", 1)));
                }
                catch (Exception e) {
                    this.fireSound = BonusableValue.objectFromJSON(o, "fireSound", null, new SoundEffect.FromJSON(false));
                }
            }
            if (o.has("hitSound")) {
                try {
                    this.hitSound = BonusableValue.of(new SoundEffect(o.getString("hitSound")));
                }
                catch (Exception e) {
                    this.hitSound = BonusableValue.objectFromJSON(o, "hitSound", null, new SoundEffect.FromJSON(false));
                }
            }
            this.optimumRange = BonusableValue.intFromJSON(o, "optimumRange", 500);
            this.jitterMerge = BonusableValue.doubleFromJSON(o, "jitterMerge", 0.0);
            this.shotSpeed = BonusableValue.doubleFromJSON(o, "shotSpeed", 1.6);
            this.tetherSpec = BonusableValue.objectFromJSON(o, "tetherSpec", null, new Tether.Spec.FromJSON());
            int defaultSTR = 0;
            if (this.penDmg.get(BonusSet.empty()) + this.blastDmg.get(BonusSet.empty()) + this.directDmg.get(BonusSet.empty()) <= 20 && this.fireArc.get((BonusSet)BonusSet.empty()).sizeRadians >= 1.5707963267948966 && this.reload.get(BonusSet.empty()) <= 2000 && this.minXRange.get(BonusSet.empty()) == 0) {
                defaultSTR = 400;
                if (this.maxRange.get(BonusSet.empty()) > 0) {
                    defaultSTR = StrictMath.min(defaultSTR, this.maxRange.get(BonusSet.empty()) / 2);
                }
                if (this.maxXRange.get(BonusSet.empty()) > 0) {
                    defaultSTR = StrictMath.min(defaultSTR, this.maxXRange.get(BonusSet.empty()) / 2);
                }
            }
            this.shootTroopsRange = BonusableValue.intFromJSON(o, "shootTroopsRange", defaultSTR);
        }
    }

    public static ArrayList<String> checkForRefProblems() {
        ArrayList<String> errs = new ArrayList<String>();
        for (ModuleType mt : Loadable.all(ModuleType.class)) {
            if (mt.flippedFrom == null) continue;
            try {
                ModuleType.ofName(mt.flippedFrom);
            }
            catch (Exception e) {
                errs.add("Cannot create " + mt.name + " because " + mt.flippedFrom + " is missing.");
            }
        }
        return errs;
    }

    public static void postLoad() {
        MASKCACHE.clear();
        for (ModuleType mt : Loadable.all(ModuleType.class)) {
            ModuleType mt2;
            if (mt.verticallyFlippedVersionName == null || !Loadable.hasOfName(ModuleType.class, mt.verticallyFlippedVersionName)) continue;
            mt.verticallyFlippedVersion = mt2 = Loadable.ofName(ModuleType.class, mt.verticallyFlippedVersionName);
            mt2.verticallyFlippedVersion = mt;
        }
        for (ModuleType mt : Loadable.all(ModuleType.class)) {
            if (mt.flippedFrom == null) continue;
            mt.deriveFlipped(ModuleType.ofName(mt.flippedFrom));
        }
        for (ModuleType mt : Loadable.all(ModuleType.class)) {
            if (mt.flippedVersion == null || mt.flippedVersion.verticallyFlippedVersion == null || mt.flippedVersion.verticallyFlippedVersion.flippedVersion == null) continue;
            mt.verticallyFlippedVersion = mt.flippedVersion.verticallyFlippedVersion.flippedVersion;
        }
        tracks.clear();
        interesting.clear();
        keelsAndRams.clear();
        for (ModuleType mt : Loadable.all(ModuleType.class)) {
            if (!mt.wheelSpecs.isEmpty()) {
                tracks.add(mt);
            }
            if (mt.getCommand(BonusSet.empty()) > 0 || mt.isWeapon() || mt.getLift(BonusSet.empty()) > 0 || mt.getPropulsion(BonusSet.empty()) > 0.0 || mt.getAccuracyBonus(BonusSet.empty()) > 0.0) {
                interesting.add(mt);
            }
            if (mt.getShipHPBonus(BonusSet.empty()) <= 0 && !mt.isRam()) continue;
            keelsAndRams.add(mt);
        }
        try {
            ModuleType.loadBasicFragments();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load base game fragments.", e);
        }
        for (Mod m : Mod.getEnabledMods()) {
            File fragmentsF = new File(new File(m.dir, "generated"), "fragments.txt");
            if (!fragmentsF.exists()) continue;
            try {
                ModuleType.loadFragments(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fragmentsF), "UTF-8")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void deriveFlipped(ModuleType b) {
        this.flippedVersion = b;
        b.flippedVersion = this;
        this.flipped = !b.flipped;
        this.availableFor = b.availableFor;
        for (ModuleCategory moduleCategory : b.categories) {
            if (moduleCategory == ModuleCategory.ofName("BASIC")) continue;
            this.categories.add(moduleCategory);
        }
        this.w = b.w;
        this.h = b.h;
        this.drawAppearanceInside = b.drawAppearanceInside;
        this.hp = b.hp;
        this.fireHP = b.fireHP;
        this.destroyedHP = b.destroyedHP;
        this.instantlyDestroyed = b.instantlyDestroyed;
        this.destroyEntireShipOnDestruction = b.destroyEntireShipOnDestruction;
        this.explodeHP = b.explodeHP;
        this.explodeDmg = b.explodeDmg;
        this.explodeFuzeLength = b.explodeFuzeLength;
        this.explodeRadius = b.explodeRadius;
        this.hasGenericDestructionFragments = b.hasGenericDestructionFragments;
        this.fragmentsSpeedMult = b.fragmentsSpeedMult;
        this.fragmentsFireMult = b.fragmentsFireMult;
        this.fragmentsDensity = b.fragmentsDensity;
        this.destructionParticle = b.destructionParticle;
        this.destructionLength = b.destructionLength;
        this.destructionParticleDensity = b.destructionParticleDensity;
        this.aiMaxY = b.aiMaxY;
        this.destructionSound = b.destructionSound;
        this.hitParticle = b.hitParticle;
        this.runningLoop = b.runningLoop;
        this.msUntilPlayLoop = b.msUntilPlayLoop;
        this.moveDelay = b.moveDelay;
        this.weight = b.weight;
        this.coal = b.coal;
        this.ammo = b.ammo;
        this.sickbay = b.sickbay;
        this.necromancy = b.necromancy;
        this.repair = b.repair;
        this.water = b.water;
        this.quarters = b.quarters;
        this.quartersType = b.quartersType;
        this.countsAsActiveCrew = b.countsAsActiveCrew;
        this.preventsBoarding = b.preventsBoarding;
        this.preventsSurrender = b.preventsSurrender;
        this.command = b.command;
        this.lift = b.lift;
        this.propulsion = b.propulsion;
        this.coalReload = b.coalReload;
        this.reload = b.reload;
        this.ammoPerClip = b.ammoPerClip;
        this.clip = b.clip;
        this.clipReloadTime = b.clipReloadTime;
        this.inaccuracy = b.inaccuracy;
        this.fixedInaccuracyVsTroops = b.fixedInaccuracyVsTroops;
        this.isWeapon = b.isWeapon;
        this.blastDmg = b.blastDmg;
        this.penDmg = b.penDmg;
        this.directDmg = b.directDmg;
        this.blastSplashRadius = b.blastSplashRadius;
        this.numShots = b.numShots;
        this.multiShotJitter = b.multiShotJitter;
        this.shootTroopsRange = b.shootTroopsRange;
        this.shotSpeedVariation = b.shotSpeedVariation;
        this.recoilForce = b.recoilForce;
        this.frontOnly = b.backOnly;
        this.backOnly = b.frontOnly;
        this.bottomOnly = b.bottomOnly;
        this.topOnly = b.topOnly;
        this.crew = b.crew;
        this.optionalCrew = b.optionalCrew;
        this.recommendedCrew = b.recommendedCrew;
        this.recommendedGuards = b.recommendedGuards;
        this.fixedGuards = b.fixedGuards;
        this.cost = b.cost;
        this.maintenanceCost = b.maintenanceCost;
        this.extraVerticalAirFriction = b.extraVerticalAirFriction;
        this.app = BonusableValue.derive(b.app, new BonusableValue.Derive<Appearance, Appearance>(){

            @Override
            public Appearance derive(Appearance from) {
                return from.flip();
            }
        });
        this.weaponAppearance = b.weaponAppearance == null ? null : BonusableValue.derive(b.weaponAppearance, new BonusableValue.Derive<WeaponAppearance, WeaponAppearance>(){

            @Override
            public WeaponAppearance derive(WeaponAppearance from) {
                return from == null ? null : from.flipped(ModuleType.this.w);
            }
        });
        this.beamSpec = b.beamSpec;
        this.tetherSpec = b.tetherSpec == null ? null : BonusableValue.derive(b.tetherSpec, new BonusableValue.Derive<Tether.Spec, Tether.Spec>(){

            @Override
            public Tether.Spec derive(Tether.Spec from) {
                return from == null ? null : from.flipped(ModuleType.this.w);
            }
        });
        this.fireArc = b.fireArc == null ? null : BonusableValue.derive(b.fireArc, new BonusableValue.Derive<Arc, Arc>(){

            @Override
            public Arc derive(Arc from) {
                return from == null ? null : from.flipHorizontal();
            }
        });
        this.innerTwoThirdsFireArc = b.innerTwoThirdsFireArc == null ? null : BonusableValue.derive(b.innerTwoThirdsFireArc, new BonusableValue.Derive<Arc, Arc>(){

            @Override
            public Arc derive(Arc from) {
                return from == null ? null : from.flipHorizontal();
            }
        });
        this.muzzleCenterX = b.muzzleCenterX == null ? null : BonusableValue.derive(b.muzzleCenterX, new BonusableValue.Derive<Double, Double>(){

            @Override
            public Double derive(Double from) {
                return (double)ModuleType.this.w - from;
            }
        });
        this.muzzleCenterY = b.muzzleCenterY;
        this.muzzleLength = b.muzzleLength;
        this.muzzleFlash = b.muzzleFlash;
        this.maxRange = b.maxRange;
        this.minXRange = b.minXRange;
        this.maxXRange = b.maxXRange;
        this.maxUpRange = b.maxUpRange;
        this.isRam = b.isRam;
        this.isSail = b.isSail;
        this.fireSound = b.fireSound;
        this.hitSound = b.hitSound;
        this.optimumRange = b.optimumRange;
        this.soundEvery = b.soundEvery;
        this.shipHPBonus = b.shipHPBonus;
        this.accuracyBonus = b.accuracyBonus;
        this.jitterMerge = b.jitterMerge;
        this.shotSpeed = b.shotSpeed;
        this.drawDoors = b.drawDoors;
        this.framesAreVariants = b.framesAreVariants;
        this.externalDrawPriority = b.externalDrawPriority;
        this.drawExternalsWhenInside = b.drawExternalsWhenInside;
        this.supplyProvided = b.supplyProvided;
        this.adjacencyBonusStrength = b.adjacencyBonusStrength;
        this.structuralStressAmount = b.structuralStressAmount;
        this.hardness = b.hardness;
        this.collisionDamageReceivedMult = b.collisionDamageReceivedMult;
        this.canParticlesStick = b.canParticlesStick;
        this.createsExceptionalCombatEventAfterMs = b.createsExceptionalCombatEventAfterMs;
        this.producesHorizontalDrag = b.producesHorizontalDrag;
        this.playDestructionSoundAtStartOfDestruction = b.playDestructionSoundAtStartOfDestruction;
        this.runsWhenDestroyed = b.runsWhenDestroyed;
        this.obeysFireMode = b.obeysFireMode;
        this.springs = b.springs;
        this.wheelSpecs = b.wheelSpecs;
        this.legSpecs = b.legSpecs;
        this.lights = BonusableValue.derive(b.lights, BonusableValue.list(new BonusableValue.Derive<ModuleLightSource, ModuleLightSource>(){

            @Override
            public ModuleLightSource derive(ModuleLightSource from) {
                return from.flipped(ModuleType.this.w);
            }
        }));
        for (Utils.Pair pair : b.windows) {
            this.windows.add((Utils.Pair<Integer, Integer>)new Utils.Pair((Object)(this.w - 1 - (Integer)pair.a), pair.b));
        }
        for (Utils.Pair pair : b.hangarPositions) {
            this.hangarPositions.add((Utils.Pair<Integer, Integer>)new Utils.Pair((Object)(this.w - 1 - (Integer)pair.a), pair.b));
        }
        for (Utils.Pair pair : b.canOccupy) {
            this.canOccupy.add((Utils.Pair<Integer, Integer>)new Utils.Pair((Object)(this.w - 1 - (Integer)pair.a), pair.b));
        }
        this.emitters = BonusableValue.derive(b.emitters, BonusableValue.list(new ModuleParticleEmitter.Flip(this.w)));
        if (b.damagedEmitters != null) {
            this.damagedEmitters = BonusableValue.derive(b.damagedEmitters, BonusableValue.list(new ModuleParticleEmitter.Flip(this.w)));
        }
        if (b.destroyedEmitters != null) {
            this.destroyedEmitters = BonusableValue.derive(b.destroyedEmitters, BonusableValue.list(new ModuleParticleEmitter.Flip(this.w)));
        }
        this.externalApps = BonusableValue.derive(b.externalApps, BonusableValue.list(new ExternalApp.Flip(this.w)));
        if (b.damagedExternalApps != null) {
            this.damagedExternalApps = BonusableValue.derive(b.damagedExternalApps, BonusableValue.list(new ExternalApp.Flip(this.w)));
        }
        if (b.destroyedExternalApps != null) {
            this.destroyedExternalApps = BonusableValue.derive(b.destroyedExternalApps, BonusableValue.list(new ExternalApp.Flip(this.w)));
        }
        this.appFragments = BonusableValue.derive(b.appFragments, new BonusableValue.Derive<ArrayList<ArrayList<FragmentImg>>, ArrayList<ArrayList<FragmentImg>>>(){

            @Override
            public ArrayList<ArrayList<FragmentImg>> derive(ArrayList<ArrayList<FragmentImg>> from) {
                return new ArrayList<ArrayList<FragmentImg>>();
            }
        });
        this.appWreckage = BonusableValue.derive(b.appWreckage, new BonusableValue.Derive<ArrayList<ArrayList<FragmentImg>>, ArrayList<ArrayList<FragmentImg>>>(){

            @Override
            public ArrayList<ArrayList<FragmentImg>> derive(ArrayList<ArrayList<FragmentImg>> from) {
                return new ArrayList<ArrayList<FragmentImg>>();
            }
        });
        this.externalFragments = BonusableValue.derive(b.externalFragments, new BonusableValue.Derive<ArrayList<ArrayList<ArrayList<FragmentImg>>>, ArrayList<ArrayList<ArrayList<FragmentImg>>>>(){

            @Override
            public ArrayList<ArrayList<ArrayList<FragmentImg>>> derive(ArrayList<ArrayList<ArrayList<FragmentImg>>> from) {
                return new ArrayList<ArrayList<ArrayList<FragmentImg>>>();
            }
        });
        this.externalSubColor = b.externalSubColor;
        this.externalSubColorByPaintIndex = b.externalSubColorByPaintIndex;
        this.leftDoors = b.rightDoors;
        this.rightDoors = b.leftDoors;
        this.upDoors = new boolean[b.upDoors.length];
        for (int i = 0; i < b.upDoors.length; ++i) {
            this.upDoors[this.upDoors.length - 1 - i] = b.upDoors[i];
        }
        this.required = b.required;
        this.external = b.external;
        this.armourType = b.armourType;
        for (TentacleSpec tentacleSpec : b.tentacleSpecs) {
            this.tentacleSpecs.add(new TentacleSpec(tentacleSpec, this.w));
        }
        this.tentacleDeathSpasms = b.tentacleDeathSpasms;
        this.tileMasks = BonusableValue.derive(b.tileMasks, new BonusableValue.Derive<TileMask[][], TileMask[][]>(){

            @Override
            public TileMask[][] derive(TileMask[][] from) {
                TileMask[][] to = new TileMask[ModuleType.this.h][ModuleType.this.w];
                for (int y = 0; y < ModuleType.this.h; ++y) {
                    for (int x = 0; x < ModuleType.this.w; ++x) {
                        if (from[y][ModuleType.this.w - x - 1] == null) continue;
                        to[y][x] = from[y][((ModuleType)ModuleType.this).w - x - 1].flipped;
                    }
                }
                return to;
            }
        });
        if (b.armourMask != null) {
            this.armourMask = BonusableValue.derive(b.armourMask, new BonusableValue.Derive<Img, Img>(){

                @Override
                public Img derive(Img from) {
                    return from == null ? null : from.flip();
                }
            });
        }
    }

    public double getShotSpeed(BonusSet bonuses) {
        return this.shotSpeed.get(bonuses);
    }

    @Override
    public String getName() {
        return Lang._t("mod_" + this.name, new Object[0]);
    }

    public EnumSet<ShipType> availableFor() {
        return this.availableFor;
    }

    public boolean availableFor(ShipType t) {
        return this.availableFor.contains((Object)t);
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public int getHp(BonusSet bonuses) {
        return this.hp.get(bonuses);
    }

    public int getDestroyedHP(BonusSet bonuses) {
        return this.destroyedHP.get(bonuses);
    }

    public int getDestructionLength(BonusSet bonuses) {
        return this.destructionLength.get(bonuses);
    }

    public boolean getInstantlyDestroyed() {
        return this.instantlyDestroyed;
    }

    public boolean getDestroyEntireShipOnDestruction() {
        return this.destroyEntireShipOnDestruction;
    }

    public boolean hasGenericDestructionFragments() {
        return this.hasGenericDestructionFragments;
    }

    public double getFragmentsSpeedMult() {
        return this.fragmentsSpeedMult;
    }

    public double getFragmentsFireMult() {
        return this.fragmentsFireMult;
    }

    public double getFragmentsDensity() {
        return this.fragmentsDensity;
    }

    public ParticleType destructionParticle(BonusSet bonuses) {
        return this.destructionParticle.get(bonuses);
    }

    public double destructionParticleDensity(BonusSet bonuses) {
        return this.destructionParticleDensity.get(bonuses);
    }

    public SoundEffect destructionSound(BonusSet bonuses) {
        return this.destructionSound.get(bonuses);
    }

    public ParticleType hitParticle(BonusSet bonuses) {
        return this.hitParticle.get(bonuses);
    }

    public SoundEffect runningLoop(BonusSet bonuses) {
        return this.runningLoop.get(bonuses);
    }

    public int msUntilPlayLoop(BonusSet bonuses) {
        return this.msUntilPlayLoop.get(bonuses);
    }

    public Arc getFireArc(BonusSet bonuses) {
        return this.fireArc.get(bonuses);
    }

    public Arc getInnerTwoThirdsFireArc(BonusSet bonuses) {
        return this.innerTwoThirdsFireArc.get(bonuses);
    }

    public double muzzleCenterX(BonusSet bonuses) {
        return this.muzzleCenterX.get(bonuses);
    }

    public double muzzleCenterY(BonusSet bonuses) {
        return this.muzzleCenterY.get(bonuses);
    }

    public double muzzleLength(BonusSet bonuses) {
        return this.muzzleLength.get(bonuses);
    }

    public WeaponAppearance weaponAppearance(BonusSet bonuses) {
        return this.weaponAppearance.get(bonuses);
    }

    public BeamSpec beamSpec(BonusSet bonuses) {
        return this.beamSpec.get(bonuses);
    }

    public Appearance getBack(BonusSet bonuses) {
        return this.weaponAppearance.get(bonuses) != null ? this.weaponAppearance.get((BonusSet)bonuses).back : null;
    }

    public int getFireHP(BonusSet bonuses) {
        return this.fireHP.get(bonuses);
    }

    public int getExplodeHP(BonusSet bonuses) {
        return this.explodeHP.get(bonuses);
    }

    public int getExplodeDmg(BonusSet bonuses) {
        return this.explodeDmg.get(bonuses);
    }

    public int getExplodeRadius(BonusSet bonuses) {
        return this.explodeRadius.get(bonuses);
    }

    public int explodeFuzeLength(BonusSet bonuses) {
        return this.explodeFuzeLength.get(bonuses);
    }

    public int getMoveDelay(BonusSet bonuses) {
        return this.moveDelay.get(bonuses);
    }

    public int getWeight(BonusSet bonuses) {
        return this.weight.get(bonuses);
    }

    public int getCoal(BonusSet bonuses) {
        return this.coal.get(bonuses);
    }

    public int maintenanceCost(BonusSet bonuses) {
        return this.maintenanceCost.get(bonuses);
    }

    public int getAmmo(BonusSet bonuses) {
        return this.ammo.get(bonuses);
    }

    public int getSickbay(BonusSet bonuses) {
        return this.sickbay.get(bonuses);
    }

    public boolean necromancy(BonusSet bonuses) {
        return this.necromancy.get(bonuses);
    }

    public int getRepair(BonusSet bonuses) {
        return this.repair.get(bonuses);
    }

    public int getWater(BonusSet bonuses) {
        return this.water.get(bonuses);
    }

    public int getQuarters(BonusSet bonuses) {
        return this.quartersType.get(bonuses) == null ? 0 : this.quarters.get(bonuses);
    }

    public CrewType getQuartersType(BonusSet bonuses) {
        return this.quartersType.get(bonuses);
    }

    public boolean getCountsAsActiveCrew() {
        return this.countsAsActiveCrew;
    }

    public boolean getPreventsBoarding() {
        return this.preventsBoarding;
    }

    public boolean getPreventsSurrender() {
        return this.preventsSurrender;
    }

    public int getCommand(BonusSet bonuses) {
        return this.command.get(bonuses);
    }

    public int getLift(BonusSet bonuses) {
        return this.lift.get(bonuses);
    }

    public boolean hasLift() {
        return this.lift.get(BonusSet.empty()) > 0;
    }

    public double getPropulsion(BonusSet bonuses) {
        return this.propulsion.get(bonuses);
    }

    public int getCoalReload(BonusSet bonuses) {
        return this.coalReload.get(bonuses);
    }

    public int getReload(BonusSet bonuses) {
        return this.reload.get(bonuses);
    }

    public boolean getObeysFireMode() {
        return this.obeysFireMode;
    }

    public int getAmmoPerClip(BonusSet bonuses) {
        return this.ammoPerClip.get(bonuses);
    }

    public int getClip(BonusSet bonuses) {
        return this.clip.get(bonuses);
    }

    public int getClipReloadTime(BonusSet bonuses) {
        return this.clipReloadTime.get(bonuses);
    }

    public double getInaccuracy(BonusSet bonuses) {
        return this.inaccuracy.get(bonuses);
    }

    public double getFixedInaccuracyVsTroops(BonusSet bonuses) {
        return this.fixedInaccuracyVsTroops.get(bonuses);
    }

    public int getBlastDmg(BonusSet bonuses) {
        return this.blastDmg.get(bonuses);
    }

    public int getBlastSplashRadius(BonusSet bonuses) {
        return this.blastSplashRadius.get(bonuses);
    }

    public int getNumShots(BonusSet bonuses) {
        return this.numShots.get(bonuses);
    }

    public int getShootTroopsRange(BonusSet bonuses) {
        return this.shootTroopsRange.get(bonuses);
    }

    public double getMultiShotJitter(BonusSet bonuses) {
        return this.multiShotJitter.get(bonuses);
    }

    public double getShotSpeedVariation(BonusSet bonuses) {
        return this.shotSpeedVariation.get(bonuses);
    }

    public int getPenDmg(BonusSet bonuses) {
        return this.penDmg.get(bonuses);
    }

    public int getDirectDmg(BonusSet bonuses) {
        return this.directDmg.get(bonuses);
    }

    public double getRecoilForce(BonusSet bonuses) {
        return this.recoilForce.get(bonuses);
    }

    public boolean[] isFrontOnly() {
        return this.frontOnly;
    }

    public boolean[] isBackOnly() {
        return this.backOnly;
    }

    public boolean[] isBottomOnly() {
        return this.bottomOnly;
    }

    public boolean[] isTopOnly() {
        return this.topOnly;
    }

    public int getCrew(BonusSet bonuses) {
        return this.crew.get(bonuses);
    }

    public int getOptionalCrew(BonusSet bonuses) {
        return this.optionalCrew.get(bonuses);
    }

    public int getRecommendedCrew(BonusSet bonuses) {
        return Math.max(this.recommendedCrew.get(bonuses), this.crew.get(bonuses));
    }

    public int getRecommendedGuards(BonusSet bonuses) {
        return this.recommendedGuards.get(bonuses);
    }

    public int getFixedGuards(BonusSet bonuses) {
        return this.fixedGuards.get(bonuses);
    }

    public int getSoundEvery(BonusSet bonuses) {
        return this.soundEvery.get(bonuses);
    }

    public int getCost(BonusSet bonuses) {
        return this.cost.get(bonuses);
    }

    public int getMinXRange(BonusSet bonuses) {
        return this.minXRange.get(bonuses);
    }

    public int getMaxXRange(BonusSet bonuses) {
        return this.maxXRange.get(bonuses);
    }

    public int getMaxRange(BonusSet bonuses) {
        return this.maxRange.get(bonuses);
    }

    public int getMaxAccurateRange(BonusSet bonuses) {
        return 16 + (int)(9.411764705882353 / (this.inaccuracy.get(bonuses) + this.multiShotJitter.get(bonuses) * 2.0 + 1.0E-6));
    }

    public int getMaxUpRange(BonusSet bonuses) {
        return this.maxUpRange.get(bonuses);
    }

    public boolean doesCreak() {
        return this.doesCreak;
    }

    public double getAdjacencyBonusStrength(BonusSet bonuses) {
        return this.adjacencyBonusStrength.get(bonuses);
    }

    public int getStructuralStressAmount(BonusSet bonuses) {
        return this.structuralStressAmount.get(bonuses);
    }

    public double getHardness(BonusSet bonuses) {
        return this.hardness.get(bonuses);
    }

    public double getCollisionDamageReceivedMult(BonusSet bonuses) {
        return this.collisionDamageReceivedMult.get(bonuses);
    }

    public boolean canParticlesStick() {
        return this.canParticlesStick;
    }

    public int createsExceptionalCombatEventAfterMs() {
        return this.createsExceptionalCombatEventAfterMs;
    }

    public boolean[] getLeftDoors() {
        return this.leftDoors;
    }

    public boolean[] getRightDoors() {
        return this.rightDoors;
    }

    public boolean[] getUpDoors() {
        return this.upDoors;
    }

    public Appearance getApp(BonusSet bonuses) {
        return this.app.get(bonuses);
    }

    public List<BonusSet> getAppBonuses() {
        return this.app.getBonusesIfAvailable();
    }

    public List<BonusSet> getExternalAppBonuses(boolean damaged, boolean destroyed) {
        if (destroyed) {
            return this.destroyedExternalApps != null ? this.destroyedExternalApps.getBonusesIfAvailable() : (this.damagedExternalApps != null ? this.damagedExternalApps.getBonusesIfAvailable() : this.externalApps.getBonusesIfAvailable());
        }
        if (damaged) {
            return this.damagedExternalApps != null ? this.damagedExternalApps.getBonusesIfAvailable() : this.externalApps.getBonusesIfAvailable();
        }
        return this.externalApps.getBonusesIfAvailable();
    }

    public ArrayList<ExternalApp> getExternalApps(BonusSet bonuses, boolean damaged, boolean destroyed) {
        if (destroyed) {
            return this.destroyedExternalApps != null ? this.destroyedExternalApps.get(bonuses) : (this.damagedExternalApps != null ? this.damagedExternalApps.get(bonuses) : this.externalApps.get(bonuses));
        }
        if (damaged) {
            return this.damagedExternalApps != null ? this.damagedExternalApps.get(bonuses) : this.externalApps.get(bonuses);
        }
        return this.externalApps.get(bonuses);
    }

    public ArrayList<Utils.Pair<Integer, Integer>> getWindows() {
        return this.windows;
    }

    public ArrayList<Utils.Pair<Integer, Integer>> getHangarPositions() {
        return this.hangarPositions;
    }

    public ArrayList<ModuleParticleEmitter> getEmitters(BonusSet bonuses) {
        return this.emitters.get(bonuses);
    }

    public ArrayList<ModuleParticleEmitter> getDamagedOrDestroyedEmitters(BonusSet bonuses, boolean damaged, boolean destroyed) {
        if (destroyed) {
            return this.destroyedEmitters != null ? this.destroyedEmitters.get(bonuses) : (this.damagedEmitters != null ? this.damagedEmitters.get(bonuses) : null);
        }
        if (damaged) {
            return this.damagedEmitters != null ? this.damagedEmitters.get(bonuses) : null;
        }
        return null;
    }

    public ArrayList<Utils.Pair<Integer, Integer>> getCanOccupy() {
        return this.canOccupy;
    }

    public Bonus getRequired() {
        return this.required;
    }

    public boolean isSail() {
        return this.isSail;
    }

    public SoundEffect getFireSound(BonusSet bonuses) {
        return this.fireSound.get(bonuses);
    }

    public SoundEffect getHitSound(BonusSet bonuses) {
        return this.hitSound.get(bonuses);
    }

    public int getShipHPBonus(BonusSet bonuses) {
        return this.shipHPBonus.get(bonuses);
    }

    public double getAccuracyBonus(BonusSet bonuses) {
        return this.accuracyBonus.get(bonuses);
    }

    public double getJitterMerge(BonusSet bonuses) {
        return this.jitterMerge.get(bonuses);
    }

    public boolean isExternal() {
        return this.external;
    }

    public ArmourType getArmourType() {
        return this.armourType;
    }

    public boolean drawDoors() {
        return this.drawDoors;
    }

    public boolean areFramesVariants() {
        return this.framesAreVariants;
    }

    public int getExternalDrawPriority() {
        return this.externalDrawPriority;
    }

    public boolean drawExternalsWhenInside() {
        return this.drawExternalsWhenInside;
    }

    public boolean hasSpecificDestroyedExternalAppearances() {
        return this.destroyedExternalApps != null;
    }

    public int getSupplyProvided(BonusSet bonuses) {
        return this.supplyProvided.get(bonuses);
    }

    public int getOptimumRange(BonusSet bonuses) {
        return this.optimumRange.get(bonuses);
    }

    public Tether.Spec getTetherSpec(BonusSet bonuses) {
        return this.tetherSpec.get(bonuses);
    }

    public ArrayList<ModuleLightSource> getLights(BonusSet bonuses) {
        return this.lights.get(bonuses);
    }

    public ArrayList<Spring> getSprings() {
        return this.springs;
    }

    public ArrayList<Wheel.Spec> getWheelSpecs() {
        return this.wheelSpecs;
    }

    public ArrayList<Leg.Spec> getLegSpecs() {
        return this.legSpecs;
    }

    public ArrayList<TentacleSpec> getTentacleSpecs() {
        return this.tentacleSpecs;
    }

    public boolean tentacleDeathSpasms() {
        return this.tentacleDeathSpasms;
    }

    public int getSupplyRequired(BonusSet bonuses) {
        return (int)StrictMath.ceil((double)this.quarters.get(bonuses).intValue() * (this.quartersType.get(bonuses) != null ? this.quartersType.get((BonusSet)bonuses).supplyCost : 0.0) + (double)this.coal.get(bonuses).intValue() * 0.01 + (double)this.water.get(bonuses).intValue() * 0.01 + (double)this.ammo.get(bonuses).intValue() * 0.0075 + (double)this.sickbay.get(bonuses).intValue() * 0.2);
    }

    public boolean isHatch(BonusSet bonuses) {
        return this.supplyProvided.get(bonuses) > 0;
    }

    public ModuleType getFlippedIfAvailable() {
        return this.flippedVersion;
    }

    public ModuleType getVerticalFlippedIfAvailable() {
        return this.verticallyFlippedVersion;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public boolean isSymmetryGroupHead() {
        return this.isSymmetryGroupMember() && !this.flipped && (this.verticallyFlippedVersion == null || this.verticallyFlippedVersionName != null);
    }

    public boolean isSymmetryGroupMember() {
        return this.flippedVersion != null || this.verticallyFlippedVersion != null;
    }

    public ModuleType getSymmetryGroupHead() {
        if (this.isSymmetryGroupHead()) {
            return this;
        }
        if (this.flippedVersion != null) {
            if (this.flippedVersion.isSymmetryGroupHead()) {
                return this.flippedVersion;
            }
            if (this.flippedVersion.verticallyFlippedVersion != null && this.flippedVersion.verticallyFlippedVersion.isSymmetryGroupHead()) {
                return this.flippedVersion.verticallyFlippedVersion;
            }
        }
        if (this.verticallyFlippedVersion != null && this.verticallyFlippedVersion.isSymmetryGroupHead()) {
            return this.verticallyFlippedVersion;
        }
        return this;
    }

    public boolean muzzleFlash(BonusSet bonuses) {
        return this.muzzleFlash.get(bonuses);
    }

    public int aiMaxY() {
        return this.aiMaxY;
    }

    public TileMask[][] getTileMasks(BonusSet bonuses) {
        return this.tileMasks.get(bonuses);
    }

    public Img getArmourMask(BonusSet bonuses) {
        return this.armourMask.get(bonuses);
    }

    public double getExtraVerticalAirFriction() {
        return this.extraVerticalAirFriction;
    }

    public ArrayList<ArrayList<FragmentImg>> getAppFragments(BonusSet bonuses) {
        return this.appFragments.get(bonuses);
    }

    public ArrayList<ArrayList<FragmentImg>> getAppWreckage(BonusSet bonuses) {
        return this.appWreckage.get(bonuses);
    }

    public ArrayList<ArrayList<ArrayList<FragmentImg>>> getExternalFragments(BonusSet bonuses) {
        return this.externalFragments.get(bonuses);
    }

    private static int twoDigitsAccuracy(int x) {
        int multAgain = 0;
        while (x >= 100) {
            x /= 10;
            ++multAgain;
        }
        while (multAgain > 0) {
            x *= 10;
            --multAgain;
        }
        return x;
    }

    public String getDescription(BonusSet bonuses) {
        int explodeHP;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toUpperCase());
        if (this.getRequired() != null && this.getRequired() != Bonus.ofName("NO_BONUS")) {
            Tech.Choice providingTech = Tech.findProvider(this.getRequired());
            if (providingTech != null) {
                sb.append("\n").append(Lang._t("Requires_tech", Lang._t("tech_" + providingTech.name, new Object[0]), providingTech.tech.tier + 1));
            } else {
                sb.append("\n").append(Lang._t("Requires_bonus_x", this.getRequired().getName()));
            }
        }
        sb.append("\n\n");
        sb.append(Lang._t("mod_desc_" + this.name, new Object[0]));
        String nameAndDesc = sb.toString();
        sb = new StringBuilder();
        if (this.maintenanceCost(bonuses) > 0) {
            sb.append(Lang._t("Maintenance_cost_x", this.maintenanceCost(bonuses))).append("\n");
        }
        if (this.isWeapon()) {
            String dmg;
            if (this.getBlastDmg(bonuses) > 0) {
                dmg = "" + this.getBlastDmg(bonuses);
                if (this.getNumShots(bonuses) > 1) {
                    dmg = this.getNumShots(bonuses) + "x" + dmg;
                }
                sb.append(Lang._t("Blast_damage_x", dmg)).append("\n");
            }
            if (this.getBlastSplashRadius(bonuses) > 0) {
                sb.append(Lang._t("Splash_distance_x", this.getBlastSplashRadius(bonuses) / 7)).append("\n");
            }
            if (this.getPenDmg(bonuses) > 0) {
                dmg = "" + this.getPenDmg(bonuses);
                if (this.getNumShots(bonuses) > 1) {
                    dmg = this.getNumShots(bonuses) + "x" + dmg;
                }
                sb.append(Lang._t("Penetration_damage_x", dmg)).append("\n");
            }
            if (this.getDirectDmg(bonuses) > 0) {
                dmg = "" + this.getDirectDmg(bonuses);
                if (this.getNumShots(bonuses) > 1) {
                    dmg = this.getNumShots(bonuses) + "x" + dmg;
                }
                sb.append(Lang._t("Direct_damage_x", dmg)).append("\n");
            }
            if (this.getReload(bonuses) < 1000) {
                sb.append(Lang._t("Rate_of_fire_x_per_second", 1000 / this.getReload(bonuses))).append("\n");
            } else {
                sb.append(Lang._t("Reload_time_x_seconds", (double)(this.getReload(bonuses) / 100) / 10.0)).append("\n");
            }
            if (this.getClip(bonuses) > 1) {
                sb.append(Lang._t("Clip_size_x_rounds", this.getClip(bonuses))).append("\n");
            }
            if (this.getAmmoPerClip(bonuses) > 1 && this.getClip(bonuses) == 1) {
                if (this.getClip(bonuses) == 1) {
                    sb.append(Lang._t("x_ammo_per_shot", this.getAmmoPerClip(bonuses))).append("\n");
                } else {
                    sb.append(Lang._t("x_ammo_per_clip", this.getAmmoPerClip(bonuses))).append("\n");
                }
            }
            sb.append(Lang._t("Fire_arc_x_degrees", (int)StrictMath.ceil(this.getFireArc((BonusSet)bonuses).sizeRadians * 180.0 / Math.PI))).append("\n");
            if (this.getMinXRange(bonuses) != 0) {
                sb.append(Lang._t("Minimum_range_x_metres", this.getMinXRange(bonuses) / 7)).append("\n");
            }
            if (this.getMaxRange(bonuses) != 0) {
                sb.append(Lang._t("Maximum_range_x_metres", this.getMaxRange(bonuses) / 7)).append("\n");
            } else if (this.getMaxXRange(bonuses) != 0) {
                sb.append(Lang._t("Maximum_range_x_metres", this.getMaxXRange(bonuses) / 7)).append("\n");
            } else {
                sb.append(Lang._t("Maximum_accurate_range_x_metres", ModuleType.twoDigitsAccuracy(this.getMaxAccurateRange(bonuses) / 7))).append("\n");
            }
            if (this.getShootTroopsRange(bonuses) > 0) {
                sb.append(Lang._t("Shoots_troops_within_x_metres", ModuleType.twoDigitsAccuracy(this.getShootTroopsRange(bonuses) / 7))).append("\n");
            }
        }
        sb.append(Lang._t("Weight_x", this.getWeight(bonuses))).append("\n");
        sb.append(Lang._t("HP_x", this.getHp(bonuses))).append("\n");
        if (this.getCoal(bonuses) > 0) {
            sb.append(Lang._t("Coal_capacity_x", this.getCoal(bonuses))).append("\n");
        }
        if (this.getWater(bonuses) > 0) {
            sb.append(Lang._t("Water_capacity_x", this.getWater(bonuses))).append("\n");
        }
        if (this.getRepair(bonuses) > 0) {
            sb.append(Lang._t("Repair_supplies_x", this.getRepair(bonuses))).append("\n");
        }
        if (this.getAmmo(bonuses) > 0) {
            sb.append(Lang._t("Ammo_storage_x", this.getAmmo(bonuses))).append("\n");
        }
        if (this.getCommand(bonuses) > 0) {
            sb.append(Lang._t("Provides_x_command", this.getCommand(bonuses))).append("\n");
        }
        if (this.getSupplyProvided(bonuses) > 0) {
            sb.append(Lang._t("Provides_x_supply", this.getSupplyProvided(bonuses))).append("\n");
        }
        if (this.getSupplyRequired(bonuses) > 0) {
            sb.append(Lang._t("Requires_x_supply", this.getSupplyRequired(bonuses))).append("\n");
        }
        if (this.getQuarters(bonuses) > 0) {
            if (this.getQuartersType((BonusSet)bonuses).isMachine) {
                sb.append(Lang._t("Contains_and_supports_x_y", this.getQuarters(bonuses), this.getQuartersType(bonuses).getPlural())).append("\n");
            } else {
                sb.append(Lang._t("Provides_quarters_for_x_y", this.getQuarters(bonuses), this.getQuartersType(bonuses).getPlural())).append("\n");
            }
        }
        if (this.getSickbay(bonuses) > 0) {
            sb.append(Lang._t("Provides_healing_for_up_to_x_crew", this.getSickbay(bonuses))).append("\n");
            if (this.necromancy(bonuses)) {
                sb.append(Lang._t("Can_resurrect_dead_crew", new Object[0])).append("\n");
            }
        }
        if (this.getLift(bonuses) > 0) {
            sb.append(Lang._t("Generates_x_lift", this.getLift(bonuses))).append("\n");
        }
        if (this.getPropulsion(bonuses) > 0.0) {
            sb.append(Lang._t("Generates_x_propulsion", (int)(this.getPropulsion(bonuses) * 1000.0))).append("\n");
        }
        if (this.getCoalReload(bonuses) > 0) {
            sb.append(Lang._t("Requires_a_unit_of_coal_every_x_seconds", this.getCoalReload(bonuses) / 1000)).append("\n");
        }
        if (this.getShipHPBonus(bonuses) > 0) {
            sb.append(Lang._t("Increases_ship_hit_points_by_x", this.getShipHPBonus(bonuses))).append("\n");
        }
        if (this.getAccuracyBonus(bonuses) > 0.0) {
            sb.append(Lang._t("Increases_weapon_accuracy_by_x_percent", (int)(this.getAccuracyBonus(bonuses) * 100.0))).append("\n");
        }
        if (this.getCrew(bonuses) == 1) {
            sb.append(Lang._t("Operators_one_crew_member", new Object[0])).append("\n");
        } else if (this.getCrew(bonuses) > 1) {
            sb.append(Lang._t("Operators_x_crew_members", this.getCrew(bonuses))).append("\n");
        }
        if (this.getRecommendedCrew(bonuses) > 0) {
            sb.append(Lang._t("Recommended_crew_x", this.getRecommendedCrew(bonuses))).append("\n");
        }
        if (this.getFixedGuards(bonuses) > 0) {
            sb.append(Lang._t("Guards_stationed_x", this.getFixedGuards(bonuses))).append("\n");
        }
        int fireHP = this.getFireHP(bonuses);
        int hp = this.getHp(bonuses);
        if (fireHP > 0) {
            if (fireHP >= hp) {
                sb.append(Lang._t("very_flammable", new Object[0])).append("\n");
            } else if (fireHP >= hp / 2) {
                sb.append(Lang._t("flammable", new Object[0])).append("\n");
            } else {
                sb.append(Lang._t("slightly_flammable", new Object[0])).append("\n");
            }
        }
        if ((explodeHP = this.getExplodeHP(bonuses)) > 0) {
            if (explodeHP >= hp / 3) {
                sb.append(Lang._t("explodes_easily", new Object[0])).append("\n");
            } else {
                sb.append(Lang._t("may_explode", new Object[0])).append("\n");
            }
        }
        if (sb.length() == 0) {
            return nameAndDesc;
        }
        String info = sb.toString();
        info = info.substring(0, info.length() - 1);
        return nameAndDesc + "\n\n" + info;
    }

    public static ModuleType ofName(String name) {
        return Loadable.ofName(ModuleType.class, name);
    }

    public static void loadBasicFragments() throws Exception {
        File fragsF = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "images"), "fragments.txt");
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fragsF), "UTF-8"));
        ModuleType.loadFragments(r);
    }

    public static void loadFragments(BufferedReader br) throws Exception {
        String l;
        while ((l = br.readLine()) != null) {
            int frameIndex;
            ModuleType mt;
            BonusSet bs;
            String[] idBits = l.split(" ");
            String imgSrc = br.readLine();
            String[] imgBits = br.readLine().split(" ");
            Img img = new Img(imgSrc, Integer.parseInt(imgBits[0]), Integer.parseInt(imgBits[1]), Integer.parseInt(imgBits[2]), Integer.parseInt(imgBits[3]), false);
            int xOffset = Integer.parseInt(imgBits[4]);
            int yOffset = Integer.parseInt(imgBits[5]);
            if (idBits[0].equals("arm")) {
                ArmourType at = null;
                try {
                    at = ArmourType.ofName(idBits[1]);
                }
                catch (Exception e) {
                    continue;
                }
                int prevIndex = Integer.parseInt(idBits[2]);
                int newIndex = Integer.parseInt(idBits[3]);
                bs = idBits.length > 4 ? ModuleType.fromToken(idBits[4]) : BonusSet.empty();
                if (prevIndex >= at.fragments.get(bs).length || newIndex >= at.fragments.get(bs)[prevIndex].length) continue;
                if (at.fragments.get(bs)[prevIndex][newIndex] == null) {
                    at.fragments.get((BonusSet)bs)[prevIndex][newIndex] = new ArrayList();
                }
                at.fragments.get(bs)[prevIndex][newIndex].add(new FragmentImg(xOffset, yOffset, img));
                continue;
            }
            if (WHEEL_AND_LEG_PREFIXES.contains(idBits[0])) {
                mt = null;
                try {
                    mt = ModuleType.ofName(idBits[1]);
                }
                catch (Exception e) {
                    continue;
                }
                if (idBits[0].equals("wheel")) {
                    mt.getWheelSpecs().get((int)0).wheelFrag.add(new FragmentImg(xOffset, yOffset, img));
                    continue;
                }
                if (idBits[0].equals("lowerLink")) {
                    mt.getWheelSpecs().get((int)0).lowerLinkFrag.add(new FragmentImg(xOffset, yOffset, img));
                    continue;
                }
                if (idBits[0].equals("upperLink")) {
                    mt.getWheelSpecs().get((int)0).upperLinkFrag.add(new FragmentImg(xOffset, yOffset, img));
                    continue;
                }
                if (idBits[0].equals("foot")) {
                    mt.getLegSpecs().get((int)0).footFrag.add(new FragmentImg(xOffset, yOffset, img));
                    continue;
                }
                if (idBits[0].equals("upperLeg")) {
                    mt.getLegSpecs().get((int)0).upperLegFrag.add(new FragmentImg(xOffset, yOffset, img));
                    continue;
                }
                if (!idBits[0].equals("lowerLeg")) continue;
                mt.getLegSpecs().get((int)0).lowerLegFrag.add(new FragmentImg(xOffset, yOffset, img));
                continue;
            }
            mt = null;
            try {
                mt = ModuleType.ofName(idBits[0]);
            }
            catch (Exception e) {
                continue;
            }
            if (idBits[1].equals("ex")) {
                int exIndex = Integer.parseInt(idBits[2]);
                frameIndex = Integer.parseInt(idBits[3]);
                BonusSet bonusSet = bs = idBits.length > 4 ? ModuleType.fromToken(idBits[4]) : BonusSet.empty();
                while (mt.externalFragments.get(bs).size() <= exIndex) {
                    mt.externalFragments.get(bs).add(new ArrayList());
                }
                while (mt.externalFragments.get(bs).get(exIndex).size() <= frameIndex) {
                    mt.externalFragments.get(bs).get(exIndex).add(new ArrayList());
                }
                mt.externalFragments.get(bs).get(exIndex).get(frameIndex).add(new FragmentImg(xOffset, yOffset, img));
                continue;
            }
            boolean wreckageFragment = idBits.length > 2 && idBits[2].equals("wreckage");
            frameIndex = Integer.parseInt(idBits[1]);
            BonusSet bonusSet = bs = idBits.length > 3 ? ModuleType.fromToken(idBits[3]) : BonusSet.empty();
            if (wreckageFragment) {
                while (mt.appWreckage.get(bs).size() <= frameIndex) {
                    mt.appWreckage.get(bs).add(new ArrayList());
                }
                mt.appWreckage.get(bs).get(frameIndex).add(new FragmentImg(xOffset, yOffset, img));
                continue;
            }
            while (mt.appFragments.get(bs).size() <= frameIndex) {
                mt.appFragments.get(bs).add(new ArrayList());
            }
            mt.appFragments.get(bs).get(frameIndex).add(new FragmentImg(xOffset, yOffset, img));
        }
        br.close();
    }

    private static BonusSet fromToken(String tok) {
        BonusSet bs = new BonusSet();
        for (String name : tok.split(",")) {
            if (!Loadable.hasOfName(Bonus.class, name)) continue;
            bs.add(Bonus.ofName(name));
        }
        return bs;
    }

    public strictfp static class ModuleParticleEmitter
    extends Particle.Emitter {
        public double x;
        public double y;
        public boolean inside;

        public ModuleParticleEmitter(double x, double y, boolean inside, ParticleType t, double emitProbability, int numParticles, SoundEffect soundEffect) {
            super(t, emitProbability, numParticles, soundEffect);
            this.x = x;
            this.y = y;
            this.inside = inside;
        }

        public strictfp static class FromJSON
        implements BonusableValue.FromJSON<ModuleParticleEmitter> {
            @Override
            public ModuleParticleEmitter construct(JSONObject o, BonusSet b) {
                SoundEffect ef = null;
                if (o.has("sound")) {
                    try {
                        String sound = o.getString("sound");
                        ef = new SoundEffect(sound, o.optDouble("volume"));
                    }
                    catch (Exception e) {
                        ef = new SoundEffect(o.getJSONObject("sound"));
                    }
                }
                return new ModuleParticleEmitter(o.getDouble("x"), o.getDouble("y"), o.optBoolean("inside", false), ParticleType.ofName(o.getString("type")), o.getDouble("emitProbability"), o.optInt("numParticles", 1), ef);
            }
        }

        public strictfp static class Flip
        implements BonusableValue.Derive<ModuleParticleEmitter, ModuleParticleEmitter> {
            private final int w;

            public Flip(int w) {
                this.w = w;
            }

            @Override
            public ModuleParticleEmitter derive(ModuleParticleEmitter mpe) {
                return new ModuleParticleEmitter((double)this.w - mpe.x, mpe.y, mpe.inside, mpe.t, mpe.emitProbability, mpe.numParticles, mpe.soundEffect);
            }
        }
    }

    public strictfp static class ModuleLightSource {
        public final Clr clr;
        public final int radius;
        public final double xOffset;
        public final double yOffset;
        public final boolean outside;

        public ModuleLightSource(Clr lightClr, int lightRadius, double lightX, double lightY, boolean outside) {
            this.clr = lightClr;
            this.radius = lightRadius;
            this.xOffset = lightX;
            this.yOffset = lightY;
            this.outside = outside;
        }

        public ModuleLightSource flipped(int w) {
            return new ModuleLightSource(this.clr, this.radius, (double)w - this.xOffset, this.yOffset, this.outside);
        }
    }

    public strictfp static class FragmentImg {
        int dx;
        int dy;
        Img img;
        Img flipped;
        SpritesheetBundle ssb;

        public FragmentImg(int dx, int dy, Img img) {
            this.dx = dx;
            this.dy = dy;
            this.img = img;
            this.flipped = img.flip();
            this.ssb = img.src.endsWith("FRAGMENTS") ? SpritesheetBundle.ofName(img.src.replace("FRAGMENTS", "")).getFragmentsSheet() : SpritesheetBundle.ofName(img.src);
        }
    }
}

