/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.BeamSpec;
import com.zarkonnen.airships.Blast;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.EmpireStat;
import com.zarkonnen.airships.ExceptionalCombatEvent;
import com.zarkonnen.airships.ExternalApp;
import com.zarkonnen.airships.FireMode;
import com.zarkonnen.airships.Fragment;
import com.zarkonnen.airships.GenericFragment;
import com.zarkonnen.airships.Job;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MiscCombatSound;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.PhysicsRect;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.ShipLayers;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.Spring;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Substitution;
import com.zarkonnen.airships.Tentacle;
import com.zarkonnen.airships.TentacleSpec;
import com.zarkonnen.airships.Tether;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.Trail;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.airships.WeatherEffect;
import com.zarkonnen.airships.Wheel;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public strictfp class Module {
    public static final double ADJACENCY_BONUS = 0.4;
    public static final double ADJ_BASE = 0.7;
    public static final int INITIAL_FIRE = 6;
    public static final int INITIAL_SPREAD_FIRE = 3;
    public static final double FIRE_INCREASE_RATIO = 5.0E-5;
    public static final double FIRE_DAMAGE_RATIO = 2.0E-4;
    public static final double FIRE_WALL_DMG_RATIO = 1.0E-4;
    public static final double FIRE_WALL_DMG_RATIO_REDUCE_PER_BLAST_ARMOUR = 1.0E-5;
    public static final double FIRE_SPREAD_RATIO = 3.0E-6;
    public static final double FIRE_SPREAD_RATIO_DOORS = 3.0E-5;
    public static final double EXPLODE_P = 0.2;
    public static final int BREAK_APART_HP = -16;
    public ModuleType type;
    public Airship ship;
    public int x;
    public int y;
    public PaintType externalPaint;
    public transient int animOffset = AGame.ANIM_R.nextInt(10000);
    public transient int variant = AGame.ANIM_R.nextInt(100);
    public transient ArrayList<Wheel> wheels = new ArrayList();
    public transient ArrayList<Leg> legs = new ArrayList();
    public transient int legIndex = 0;
    public transient int altLegIndex;
    public transient ArrayList<Tentacle> tentacles = new ArrayList();
    public transient Tether tether = null;
    public transient double glowAmt;
    public static final double GLOW_PER_MS = 0.0025;
    public transient int numCrewTmp = 0;
    public transient int numGuardsTmp = 0;
    public transient boolean touchingGround;
    public transient double prevShipXForWheels;
    public int ammoForClip;
    public int ammoLeft;
    public int clipReloadCooldown;
    public int shootAccumulator;
    public int reTargetAccumulator;
    public int retryFindingTargetCooldown;
    public int msUntilCoal;
    public int fire = 0;
    public int explodeFuze = 0;
    public boolean burntOut = false;
    public transient int maxHP;
    public int hp;
    public int lowestHP;
    public int destructionTime = 0;
    public transient int time;
    public boolean fired = false;
    public transient boolean damageReported = false;
    public transient boolean armourDamageReported = false;
    public transient boolean hidden = false;
    public transient boolean noValidTarget;
    public transient int fireSoundCounter = 0;
    public transient int lift = -1;
    public boolean firingBeam;
    public int beamAge;
    public transient double[] subBeamFlickers;
    public int beamStartPositionX;
    public int beamStartPositionY;
    public int beamEndPositionX;
    public int beamEndPositionY;
    public int beamShotsFired;
    public int msSinceFired = 100000;
    public static long LOOP_SOUND_COUNTER = 1L;
    public transient int runningConsecutiveMs = 0;
    public transient String runningLoopKey;
    public transient String fireLoopKey;
    public transient int msRunning = 0;
    public double weaponAngle = 0.0;
    public transient double recoil = 0.0;
    public transient int barrelAnimationOffset = 0;
    public transient int barrelAnimationCooldown = 0;
    private EnumMap<Resource, Integer> resources = new EnumMap(Resource.class);
    private ArrayList<Job> jobs = new ArrayList();
    private final Module self = this;
    public Airship prevTargetShip;
    public Tile prevTarget;
    public double prevXJitter;
    public double prevYJitter;
    public boolean hasPrevJitter;
    public int msAccum = 0;
    public transient boolean[] shellOpen;
    static boolean reportedBothSidesError = false;

    public ArrayList<Job> jobs() {
        return this.jobs;
    }

    public int getLift() {
        if (this.lift == -1) {
            this.lift = this.type.getLift(this.ship.constructionBonuses);
        }
        return this.lift;
    }

    public void calcMaxHP() {
        this.calcMaxHP(this.ship.getBonusHPPerTile(), this.ship.getStructuralStressHPMultiplier());
    }

    public void calcMaxHP(int bonusHPPerTile, double structuralStressHPMultiplier) {
        Tile t;
        int i;
        this.maxHP = this.type.getHp(this.ship.currentBonuses);
        double adjacents = 0.0;
        int maxAdjacents = this.type.getW() + this.type.getH();
        for (i = 0; i < this.type.getW(); ++i) {
            t = this.ship.tileAt(this.x + i, this.y - 1);
            if (t != null) {
                adjacents += t.module.type.getAdjacencyBonusStrength(this.ship.currentBonuses);
            }
            if ((t = this.ship.tileAt(this.x + i, this.y + this.type.getH())) == null) continue;
            adjacents += t.module.type.getAdjacencyBonusStrength(this.ship.currentBonuses);
        }
        for (i = 0; i < this.type.getH(); ++i) {
            t = this.ship.tileAt(this.x - 1, this.y + i);
            if (t != null) {
                adjacents += t.module.type.getAdjacencyBonusStrength(this.ship.currentBonuses);
            }
            if ((t = this.ship.tileAt(this.x + this.type.getW(), this.y + i)) == null) continue;
            adjacents += t.module.type.getAdjacencyBonusStrength(this.ship.currentBonuses);
        }
        if (this.ship.type == ShipType.BUILDING && this.y + this.type.getH() == this.ship.getHeight()) {
            adjacents += (double)this.type.getW();
        }
        adjacents = StrictMath.min(adjacents, (double)maxAdjacents);
        this.maxHP = (int)StrictMath.ceil((double)this.maxHP * (0.29999999999999993 + 0.8 * adjacents / (double)maxAdjacents));
        this.maxHP += bonusHPPerTile * this.type.getW() * this.type.getH();
        this.maxHP = (int)((double)this.maxHP * structuralStressHPMultiplier);
    }

    public int getMaxHP() {
        return this.maxHP;
    }

    public int getMaxRepairToHP() {
        return this.maxHP - (this.maxHP - this.lowestHP) / 2;
    }

    public ArrayList<ModuleType.ModuleParticleEmitter> getEmitters() {
        return this.type.getEmitters(this.ship.currentBonuses);
    }

    public ArrayList<ModuleType.ModuleParticleEmitter> getDamagedOrDestroyedEmitters() {
        return this.type.getDamagedOrDestroyedEmitters(this.ship.currentBonuses, this.hp < this.maxHP / 2, this.hp <= 0);
    }

    public ArrayList<ExternalApp> getExternalApps() {
        return this.type.getExternalApps(this.ship.currentBonuses, (double)this.hp < (double)this.maxHP * 0.75, this.hp <= 0);
    }

    public Crewman findOperator() {
        int csz = this.ship.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = this.ship.crew.get(ci);
            if (!(cm.job instanceof StaffJob) || !this.jobs.contains(cm.job)) continue;
            return cm;
        }
        return null;
    }

    public void resetWeaponBarrels() {
        this.recoil = 0.0;
        if (this.type.getFireArc(this.ship.currentBonuses) != null) {
            this.weaponAngle = this.ship.flipped ? this.type.getFireArc((BonusSet)this.ship.currentBonuses).getMiddle().flipHorizontal().radians : this.type.getFireArc((BonusSet)this.ship.currentBonuses).getMiddle().radians;
        }
    }

    public void repairFully() {
        this.resetWeaponBarrels();
        this.destructionTime = 0;
        this.msSinceFired = 100000;
        this.lift = -1;
        this.prevTarget = null;
        this.prevTargetShip = null;
        this.hasPrevJitter = false;
        this.damageReported = false;
        this.armourDamageReported = false;
        this.msUntilCoal = this.type.getCoalReload(this.ship.currentBonuses);
        this.shootAccumulator = 0;
        this.reTargetAccumulator = 0;
        this.clipReloadCooldown = 0;
        this.retryFindingTargetCooldown = 0;
        this.lowestHP = this.hp = this.getMaxHP();
        this.ammoLeft = this.type.getClip(this.ship.currentBonuses);
        this.fire = 0;
        this.fired = false;
        this.burntOut = false;
        this.tether = null;
        if (this.type.getWater(this.ship.currentBonuses) > 0) {
            this.resources.put(Resource.WATER, this.type.getWater(this.ship.currentBonuses));
        }
        if (this.type.getRepair(this.ship.currentBonuses) > 0) {
            this.resources.put(Resource.REPAIR, this.type.getRepair(this.ship.currentBonuses));
        }
        if (this.type.getAmmo(this.ship.currentBonuses) > 0) {
            this.resources.put(Resource.AMMO, this.type.getAmmo(this.ship.currentBonuses));
        }
        if (this.type.getCoal(this.ship.currentBonuses) > 0) {
            this.resources.put(Resource.COAL, this.type.getCoal(this.ship.currentBonuses));
        }
    }

    public void dealDestructionDamage() {
        Tile t;
        int i;
        for (i = 0; i < this.type.getW(); ++i) {
            t = this.ship.tileAt(this.x + i, this.y - 1);
            if (t != null) {
                t.module.hp = (int)((double)t.module.hp - StrictMath.ceil((double)t.module.type.getHp(this.ship.currentBonuses) * (0.8 / (double)(t.module.type.getW() * 2 + t.module.type.getH() * 2))));
            }
            if ((t = this.ship.tileAt(this.x + i, this.y + this.type.getH())) == null) continue;
            t.module.hp = (int)((double)t.module.hp - StrictMath.ceil((double)t.module.type.getHp(this.ship.currentBonuses) * (0.8 / (double)(t.module.type.getW() * 2 + t.module.type.getH() * 2))));
        }
        for (i = 0; i < this.type.getH(); ++i) {
            t = this.ship.tileAt(this.x - 1, this.y + i);
            if (t != null) {
                t.module.hp = (int)((double)t.module.hp - StrictMath.ceil((double)t.module.type.getHp(this.ship.currentBonuses) * (0.8 / (double)(t.module.type.getW() * 2 + t.module.type.getH() * 2))));
            }
            if ((t = this.ship.tileAt(this.x + this.type.getW(), this.y + i)) == null) continue;
            t.module.hp = (int)((double)t.module.hp - StrictMath.ceil((double)t.module.type.getHp(this.ship.currentBonuses) * (0.8 / (double)(t.module.type.getW() * 2 + t.module.type.getH() * 2))));
        }
    }

    public int getResource(Resource r) {
        if (this.hp <= 0) {
            return 0;
        }
        return this.resources.containsKey((Object)r) ? this.resources.get((Object)r) : 0;
    }

    public boolean takeResource(Resource r) {
        if (this.getResource(r) > 0) {
            this.resources.put(r, this.getResource(r) - 1);
            return true;
        }
        return false;
    }

    public boolean fullyStaffed() {
        int jsz = this.jobs.size();
        block0: for (int ji = 0; ji < jsz; ++ji) {
            Job job = this.jobs.get(ji);
            if (!(job instanceof StaffJob)) continue;
            int csz = this.ship.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman c = this.ship.crew.get(ci);
                if (c.job == job && c.currentTile.module == this) continue block0;
            }
            return false;
        }
        return true;
    }

    public boolean somewhatStaffed() {
        if (this.type.getCrew(this.ship.currentBonuses) == 0) {
            return true;
        }
        int jsz = this.jobs.size();
        for (int j = 0; j < jsz; ++j) {
            Job job = this.jobs.get(j);
            if (!(job instanceof StaffJob)) continue;
            int sz = this.ship.crew.size();
            for (int i = 0; i < sz; ++i) {
                Crewman c = this.ship.crew.get(i);
                if (c.job != job || c.currentTile.module != this) continue;
                return true;
            }
        }
        return false;
    }

    public double staffProportion() {
        int staffJobs = 0;
        int staff = 0;
        int jsz = this.jobs.size();
        block0: for (int ji = 0; ji < jsz; ++ji) {
            Job job = this.jobs.get(ji);
            if (!(job instanceof StaffJob)) continue;
            ++staffJobs;
            int csz = this.ship.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman c = this.ship.crew.get(ci);
                if (c.job != job || c.currentTile.module != this) continue;
                ++staff;
                continue block0;
            }
        }
        return staffJobs == 0 ? 1.0 : 1.0 * (double)staff / (double)staffJobs;
    }

    public boolean canRun() {
        return !(!this.somewhatStaffed() || this.hp <= 0 && !this.type.runsWhenDestroyed() || this.type.getCoalReload(this.ship.currentBonuses) != 0 && this.msUntilCoal <= 0);
    }

    public boolean running() {
        if (!this.canRun()) {
            return false;
        }
        if (this.type.getCommand(this.ship.currentBonuses) > 0) {
            return true;
        }
        if (this.type.getPropulsion(this.ship.currentBonuses) > 0.0 && !this.ship.enginesRunning) {
            return false;
        }
        if (!(!(this.type.getPropulsion(this.ship.currentBonuses) > 0.0) || this.type.getSprings().isEmpty() && this.type.getLegSpecs().isEmpty() || this.touchingGround)) {
            return false;
        }
        return !this.type.hasLift() || this.ship.suspendiumRunning;
    }

    public void resetTentacles() {
        double mx = this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16);
        if (this.ship.flipped) {
            mx += (double)(this.type.getW() * 16);
        }
        double my = this.ship.getY() + (double)(this.y * 16 * 16);
        for (Tentacle t : this.tentacles) {
            t.reset(mx, my, this.ship.flipped);
        }
    }

    public void setTentaclesFlipped(boolean flipped) {
        double mx = this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW(), flipped) * 16);
        double my = this.ship.getY() + (double)(this.y * 16 * 16);
        for (Tentacle t : this.tentacles) {
            t.setFlipped(mx, my, flipped);
        }
    }

    public void initWheels(LandFormation ground, ArrayList<LandFormation> floaters, ShipList ships, boolean force) {
        double mx = this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16);
        double my = this.ship.getY() + (double)(this.y * 16) + (double)(this.type.getH() * 16);
        int wsz = this.wheels.size();
        for (int wi = 0; wi < wsz; ++wi) {
            Wheel w = this.wheels.get(wi);
            w.setBodyPosition(mx, my);
        }
    }

    public void resetLegs(LandFormation ground, ArrayList<LandFormation> floaters) {
        for (Leg l : this.legs) {
            l.reset(ground, floaters);
        }
    }

    public boolean moving() {
        return this.ship.timeMovingInSameXDirection > 150;
    }

    public void tick(int ms, Combat c, boolean onViewingSide) {
        double my;
        WeaponAppearance wa;
        this.touchingGround = false;
        if (this.hp <= 0 || this.tether != null && this.tether.tick(ms, c, onViewingSide)) {
            this.tether = null;
        }
        if (this.hp > 0) {
            wa = this.type.weaponAppearance(this.ship.currentBonuses);
            if (wa != null) {
                this.msSinceFired += ms;
                if (this.shellOpen == null) {
                    this.shellOpen = new boolean[wa.shells.size()];
                }
                for (int si = 0; si < wa.shells.size(); ++si) {
                    WeaponAppearance.Shell shell = wa.shells.get(si);
                    double openness = shell.getOpenness(this);
                    if (openness > 0.0 && !this.shellOpen[si]) {
                        for (WeaponAppearance.ShellEmitter se : shell.openEmitters) {
                            se.emit(c, this);
                        }
                        if (shell.openSound != null) {
                            c.play(shell.openSound, this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16) + (double)(this.type.getW() * 16 / 2), this.ship.getY() + (double)(this.y * 16) + (double)(this.type.getH() * 16 / 2), this.ship.getxSpeed(), this.ship.getySpeed(), onViewingSide);
                        }
                        this.shellOpen[si] = true;
                    }
                    if (openness != 0.0 || !this.shellOpen[si]) continue;
                    for (WeaponAppearance.ShellEmitter se : shell.closeEmitters) {
                        se.emit(c, this);
                    }
                    if (shell.closeSound != null) {
                        c.play(shell.closeSound, this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16) + (double)(this.type.getW() * 16 / 2), this.ship.getY() + (double)(this.y * 16) + (double)(this.type.getH() * 16 / 2), this.ship.getxSpeed(), this.ship.getySpeed(), onViewingSide);
                    }
                    this.shellOpen[si] = false;
                }
            }
            ArrayList<Spring> springs = this.type.getSprings();
            int ssz = springs.size();
            for (int si = 0; si < ssz; ++si) {
                Spring spring = springs.get(si);
                double l = spring.getLength(this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16), this.ship.getY() + (double)(this.y * 16) + (double)(this.type.getH() * 16), c, this.ship);
                if (!(l < (double)spring.baseLength)) continue;
                if (!this.ship.sitting) {
                    this.ship.setyForce(this.ship.getyForce() - spring.getForce(l));
                }
                double fMult = this.ship.hasHadSpringFriction ? 0.1 : 1.0;
                this.ship.hasHadSpringFriction = true;
                double xFriction = StrictMath.pow(1.0 - spring.xFriction * fMult, ms);
                this.ship.setxSpeed(this.ship.getxSpeed() * xFriction);
                double yFriction = StrictMath.pow(1.0 - spring.yFriction * fMult, ms);
                this.ship.setySpeed(this.ship.getySpeed() * yFriction);
                this.touchingGround = true;
            }
            this.initWheels(null, c.landFormations, c, false);
            double mx = this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16);
            double my2 = this.ship.getY() + (double)(this.y * 16) + (double)(this.type.getH() * 16);
            int wsz = this.wheels.size();
            for (int wi = 0; wi < wsz; ++wi) {
                Wheel w = this.wheels.get(wi);
                w.calcYOffset(this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16), this.ship.getY() + (double)(this.y * 16) + (double)(this.type.getH() * 16), c);
                if (this.touchingGround) {
                    w.phase += (this.ship.getX() - this.prevShipXForWheels) / w.spec.radius;
                }
                w.setBodyPosition(mx, my2);
            }
            this.prevShipXForWheels = this.ship.getX();
            int lsz = this.legs.size();
            boolean stepped = false;
            boolean altStepped = false;
            for (int li = 0; li < lsz; ++li) {
                if (li == this.legIndex) {
                    stepped = this.legs.get(li).tick(ms, null, c.landFormations, true, c, true, onViewingSide);
                } else if (lsz > 4 && li == this.altLegIndex) {
                    altStepped = this.legs.get(li).tick(ms, null, c.landFormations, true, c, true, onViewingSide);
                } else {
                    this.legs.get(li).tick(ms, null, c.landFormations, false, c, true, onViewingSide);
                }
                this.touchingGround |= this.legs.get((int)li).isDown;
            }
            if (stepped) {
                this.legIndex = (this.legIndex + 1) % this.legs.size();
            }
            if (altStepped) {
                this.altLegIndex = (this.altLegIndex + 1) % this.legs.size();
            }
            mx = this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16);
            if (this.ship.flipped) {
                mx += (double)(this.type.getW() * 16);
            }
            my2 = this.ship.getY() + (double)(this.y * 16);
            int tsz = this.tentacles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                this.tentacles.get(ti).tick(c, this.ship, c.sideOf(this.ship), this, ms, mx, my2, onViewingSide);
            }
        } else {
            int lsz = this.legs.size();
            for (int li = 0; li < lsz; ++li) {
                this.legs.get(li).tick(ms, null, c.landFormations, false, c, false, onViewingSide);
            }
            if (this.type.tentacleDeathSpasms()) {
                double mx = this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16);
                if (this.ship.flipped) {
                    mx += (double)(this.type.getW() * 16);
                }
                my = this.ship.getY() + (double)(this.y * 16);
                int tsz = this.tentacles.size();
                for (int ti = 0; ti < tsz; ++ti) {
                    this.tentacles.get(ti).deathSpasm(c, this.ship, ms, mx, my);
                }
            }
        }
        if ((wa = this.type.weaponAppearance(this.ship.currentBonuses)) != null && this.recoil > 0.0) {
            this.recoil -= wa.recoil * (double)ms / (double)StrictMath.min(500, this.type.getReload(this.ship.currentBonuses) / 2);
            if (this.recoil < 0.0) {
                this.recoil = 0.0;
            }
        }
        if (wa != null && wa.barrelAnimation != null && wa.barrelAnimation.loopConstantly) {
            this.barrelAnimationOffset += ms;
        } else if (this.barrelAnimationCooldown > 0) {
            this.barrelAnimationCooldown -= ms;
            this.barrelAnimationOffset += ms;
        } else if (wa != null && wa.barrelAnimation != null && !wa.barrelAnimation.loop) {
            this.barrelAnimationOffset = 0;
        }
        if (this.prevTargetShip != null && c.sideOf(this.prevTargetShip) == c.sideOf(this.ship)) {
            this.prevTarget = null;
            this.prevTargetShip = null;
        }
        if (this.hp <= 0 && this.lowestHP > 0) {
            double mx = this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16);
            my = this.ship.getY() + (double)(this.y * 16) + (double)(this.type.getH() * 16);
            if (!this.wheels.isEmpty()) {
                Wheel.Spec ws = this.wheels.get((int)0).spec;
                for (Wheel w : this.wheels) {
                    double wheelCX = mx + w.spec.xOffset * 16.0;
                    double wheelCY = my + w.yOffset;
                    for (ModuleType.FragmentImg fi : ws.wheelFrag) {
                        double speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * 0.5;
                        double angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                        double dx = speed * StrictMath.cos(angle);
                        double dy = speed * StrictMath.sin(angle);
                        double fragX = wheelCX + StrictMath.cos(w.phase) * (double)(fi.dx + fi.img.srcWidth / 2 - ws.wheel.srcWidth / 2) - StrictMath.sin(w.phase) * (double)(fi.dy + fi.img.srcHeight / 2 - ws.wheel.srcWidth / 2) - (double)(fi.img.srcWidth / 2);
                        double fragY = wheelCY + StrictMath.sin(w.phase) * (double)(fi.dx + fi.img.srcWidth / 2 - ws.wheel.srcWidth / 2) + StrictMath.cos(w.phase) * (double)(fi.dy + fi.img.srcHeight / 2 - ws.wheel.srcWidth / 2) - (double)(fi.img.srcWidth / 2);
                        c.fragments.add(new Fragment(fi.ssb, fi.img, fragX, fragY, dx, dy, w.phase, AGame.ANIM_R.nextDouble() * 0.02 - 0.01, 500 + AGame.ANIM_R.nextInt(1200), 0));
                    }
                }
                double segmentStride = ws.segmentStride;
                double strideRadians = segmentStride / this.wheels.get((int)0).spec.radius;
                ArrayList<?> segs = ShipLayers.getTrackSegments(this.ship, this);
                for (int pass = 0; pass < 2; ++pass) {
                    double value = this.wheels.get((int)0).phase * segmentStride / strideRadians;
                    if (value < 0.0) {
                        value += StrictMath.ceil(-value / segmentStride / 2.0) * segmentStride * 2.0;
                    }
                    boolean flipAlt = (value %= segmentStride * 2.0) >= segmentStride;
                    value %= segmentStride;
                    boolean second = pass == 1;
                    boolean alternation = second ^ flipAlt;
                    for (Object seg : segs) {
                        if (seg instanceof ShipLayers.StraightSegment) {
                            ShipLayers.StraightSegment ss = (ShipLayers.StraightSegment)seg;
                            double dist = StrictMath.sqrt((ss.startX - ss.endX) * (ss.startX - ss.endX) + (ss.startY - ss.endY) * (ss.startY - ss.endY));
                            double angle = Direction.radiansFromTo(ss.startX, ss.startY, ss.endX, ss.endY);
                            while (value < dist) {
                                boolean bl = alternation = !alternation;
                                if (!alternation && AGame.ANIM_R.nextInt(4) == 1) {
                                    double speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * 0.4;
                                    double sangle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                                    double dx = speed * StrictMath.cos(sangle);
                                    double dy = speed * StrictMath.sin(sangle);
                                    if (!(second && ws.upperLinkFrag.isEmpty() || !second && ws.lowerLinkFrag.isEmpty())) {
                                        ModuleType.FragmentImg lnk = second ? ws.upperLinkFrag.get(0) : ws.lowerLinkFrag.get(0);
                                        double fx = mx + ss.startX + (ss.endX - ss.startX) * value / dist - (double)(lnk.img.srcWidth / 2);
                                        double fy = my + ss.startY + (ss.endY - ss.startY) * value / dist - (double)(lnk.img.srcHeight / 2);
                                        double fangle = angle + Math.PI;
                                        c.fragments.add(new Fragment(lnk.ssb, lnk.img, fx, fy, dx, dy, fangle, AGame.ANIM_R.nextDouble() * 0.02 - 0.01, 500 + AGame.ANIM_R.nextInt(1200), 0));
                                    }
                                }
                                value += segmentStride;
                            }
                            value -= dist;
                        }
                        if (!(seg instanceof ShipLayers.CurvedSegment)) continue;
                        ShipLayers.CurvedSegment cs = (ShipLayers.CurvedSegment)seg;
                        if (cs.startAngle >= cs.endAngle) continue;
                        Wheel w = cs.w;
                        for (value = cs.startAngle + value * strideRadians / segmentStride; value < cs.endAngle; value += strideRadians) {
                            boolean bl = alternation = !alternation;
                            if (alternation || AGame.ANIM_R.nextInt(4) != 1) continue;
                            double speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * 0.4;
                            double sangle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                            double dx = speed * StrictMath.cos(sangle);
                            double dy = speed * StrictMath.sin(sangle);
                            if (second && ws.upperLinkFrag.isEmpty() || !second && ws.lowerLinkFrag.isEmpty()) continue;
                            ModuleType.FragmentImg lnk = second ? ws.upperLinkFrag.get(0) : ws.lowerLinkFrag.get(0);
                            double fx = mx + w.spec.xOffset * 16.0 + StrictMath.cos(value) * w.spec.radius - (double)(lnk.img.srcWidth / 2);
                            double fy = my + w.yOffset + StrictMath.sin(value) * w.spec.radius - (double)(lnk.img.srcHeight / 2);
                            double fangle = value + 4.71238898038469;
                            c.fragments.add(new Fragment(lnk.ssb, lnk.img, fx, fy, dx, dy, fangle, AGame.ANIM_R.nextDouble() * 0.02 - 0.01, 500 + AGame.ANIM_R.nextInt(1200), 0));
                        }
                        value = (value - cs.endAngle) * segmentStride / strideRadians;
                    }
                }
            }
        }
        this.lowestHP = StrictMath.min(this.hp, this.lowestHP);
        this.fired = false;
        int soundX = this.ship.getIntX() + this.ship.gridXToWorldX(this.x, this.type.getW()) * 16 + this.type.getW() * 16 / 2;
        int soundY = this.ship.getIntY() + this.y * 16 + this.type.getH() * 16 / 2;
        if (this.type.runningLoop(this.ship.currentBonuses) != null && this.running()) {
            if (this.msRunning > this.type.msUntilPlayLoop(this.ship.currentBonuses)) {
                c.loop(this.runningLoopKey, this.type.runningLoop(this.ship.currentBonuses), soundX, soundY, this.ship.getxSpeed(), this.ship.getySpeed(), onViewingSide);
            } else {
                this.msRunning += ms;
            }
        } else {
            this.msRunning = 0;
        }
        if (!this.type.getLights(this.ship.currentBonuses).isEmpty()) {
            this.glowAmt = this.running() ? StrictMath.min(1.0, this.glowAmt + (double)ms * 0.0025) : StrictMath.max(0.0, this.glowAmt - (double)ms * 0.0025);
        }
        if (this.type.isSail()) {
            if (this.running()) {
                if (this.ship.msUntilNextSailFlap > 0) {
                    this.ship.msUntilNextSailFlap -= ms;
                    if (this.ship.msUntilNextSailFlap <= 0) {
                        c.play(MiscCombatSound.SAIL, soundX, soundY, this.ship.getxSpeed(), this.ship.getySpeed(), onViewingSide);
                    }
                }
            } else {
                this.ship.msUntilNextSailFlap = 300;
            }
        }
        if (this.fire > 0 && c.timeOfDay.effect.fireExtinguishChance > 0.0 && c.r.nextDouble() < c.timeOfDay.effect.fireExtinguishChance * (double)ms) {
            --this.fire;
            if (this.fire == 0) {
                c.play(MiscCombatSound.QUENCH, soundX, soundY, this.ship.getxSpeed(), this.ship.getySpeed(), onViewingSide);
            }
        }
        if (this.fire > 0) {
            c.loop(this.fireLoopKey, MiscCombatSound.FIRE_LOOP, soundX, soundY, this.ship.getxSpeed(), this.ship.getySpeed(), onViewingSide);
            if (c.r.nextDouble() < 2.0E-4 * (double)this.fire * (double)ms) {
                --this.hp;
            }
            int tsz = this.ship.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = this.ship.tiles.get(ti);
                if (!(c.r.nextDouble() < (1.0E-4 - 1.0E-5 * (double)t.armour.type.getBlastDmgAbsorb(this.ship.currentBonuses)) * (double)this.fire * (double)ms) || t.module != this) continue;
                t.armour.hp = StrictMath.max(0, t.armour.hp - 1);
            }
            for (int xx = 0; xx < this.type.getW(); ++xx) {
                Tile downT;
                Tile upT = this.ship.tileAt(this.x + xx, this.y - 1);
                if (upT != null && upT.module.fire == 0 && upT.module.hp > 0 && upT.module.type.getFireHP(this.ship.currentBonuses) > 0) {
                    boolean door = this.type.getUpDoors()[xx];
                    double fireSpreadRollVs = (door ? 3.0E-5 : 3.0E-6) * (double)this.fire * (double)ms * (double)upT.module.type.getFireHP(this.ship.currentBonuses) / (double)upT.module.type.getHp(this.ship.currentBonuses) / (double)upT.module.type.getW() / (double)upT.module.type.getH();
                    if (c.r.nextDouble() < fireSpreadRollVs) {
                        upT.module.fire = 3;
                    }
                }
                if ((downT = this.ship.tileAt(this.x + xx, this.y + this.type.getH())) == null || downT.module.fire != 0 || downT.module.hp <= 0 || downT.module.type.getFireHP(this.ship.currentBonuses) <= 0) continue;
                boolean door = downT.module.type.getUpDoors()[this.x + xx - downT.module.x];
                double fireSpreadRollVs = (door ? 3.0E-5 : 3.0E-6) * (double)this.fire * (double)ms * (double)downT.module.type.getFireHP(this.ship.currentBonuses) / (double)downT.module.type.getHp(this.ship.currentBonuses) / (double)downT.module.type.getW() / (double)downT.module.type.getH();
                if (!(c.r.nextDouble() < fireSpreadRollVs)) continue;
                downT.module.fire = 3;
            }
            for (int yy = 0; yy < this.type.getH(); ++yy) {
                Tile rightT;
                Tile leftT = this.ship.tileAt(this.x - 1, this.y + yy);
                if (leftT != null && leftT.module.fire == 0 && leftT.module.hp > 0 && leftT.module.type.getFireHP(this.ship.currentBonuses) > 0) {
                    boolean door = this.type.getLeftDoors()[yy] && leftT.module.type.getRightDoors()[this.y + yy - leftT.module.y];
                    double fireSpreadRollVs = (door ? 3.0E-5 : 3.0E-6) * (double)this.fire * (double)ms * (double)leftT.module.type.getFireHP(this.ship.currentBonuses) / (double)leftT.module.type.getHp(this.ship.currentBonuses) / (double)leftT.module.type.getW() / (double)leftT.module.type.getH();
                    if (c.r.nextDouble() < fireSpreadRollVs) {
                        leftT.module.fire = 3;
                    }
                }
                if ((rightT = this.ship.tileAt(this.x + this.type.getW(), this.y + yy)) == null || rightT.module.fire != 0 || rightT.module.hp <= 0 || rightT.module.type.getFireHP(this.ship.currentBonuses) <= 0) continue;
                boolean door = this.type.getRightDoors()[yy] && rightT.module.type.getLeftDoors()[this.y + yy - rightT.module.y];
                double fireSpreadRollVs = (door ? 3.0E-5 : 3.0E-6) * (double)this.fire * (double)ms * (double)rightT.module.type.getFireHP(this.ship.currentBonuses) / (double)rightT.module.type.getHp(this.ship.currentBonuses) / (double)rightT.module.type.getW() / (double)rightT.module.type.getH();
                if (!(c.r.nextDouble() < fireSpreadRollVs)) continue;
                rightT.module.fire = 3;
            }
            if (c.r.nextDouble() < 5.0E-5 * (double)this.fire * (double)ms) {
                ++this.fire;
            }
        }
        if (this.hp <= 0) {
            this.fire = 0;
            this.burntOut = true;
        }
        int adjExplodeHP = this.type.getExplodeHP(this.ship.currentBonuses) * this.maxHP / this.type.getHp(this.ship.currentBonuses);
        if (this.explodeFuze == 0 && this.hp > 0 && this.type.getExplodeDmg(this.ship.currentBonuses) > 0 && this.hp < adjExplodeHP && (double)(adjExplodeHP * ms) * 0.2 * c.r.nextDouble() > (double)this.hp) {
            this.explodeFuze = this.type.explodeFuzeLength(this.ship.currentBonuses);
            c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("explode " + this.type.name, c.sideOf(this.ship), this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16) + (double)(this.type.getW() * 16 / 2), this.ship.getY() + (double)(this.y * 16) + (double)(this.type.getH() * 16 / 2), null, this.ship));
        }
        if (this.explodeFuze > 0) {
            if (!SimplePref.REDUCED_FLASHING.get() && AGame.ANIM_R.nextDouble() < (double)(ms * this.type.getW() * this.type.getH()) * 0.01) {
                double px = this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16) + AGame.ANIM_R.nextDouble() * (double)this.type.getW() * 16.0;
                double py = this.ship.getY() + (double)(this.y * 16) + AGame.ANIM_R.nextDouble() * (double)this.type.getH() * 16.0;
                c.particles.add(new Particle(ParticleType.ofName("exploding_spark"), px, py));
            }
            this.explodeFuze -= ms;
            if (this.explodeFuze <= 0) {
                this.hp -= this.type.getExplodeDmg(this.ship.currentBonuses) * 2;
                this.ship.explosionAmount += (double)this.type.getExplodeDmg(this.ship.currentBonuses);
                this.explode(c, onViewingSide);
                c.doSplashDmg(this.ship.getX() + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16) + (double)(this.type.getW() * 16 / 2), this.ship.getY() + (double)(this.y * 16) + (double)(this.type.getH() * 16 / 2), this.type.getExplodeDmg(this.ship.currentBonuses), this.type.getExplodeRadius(this.ship.currentBonuses), null, this.ship, null);
            }
        }
        if (this.firingBeam) {
            this.updateBeam(c, ms);
        }
        if (this.running()) {
            this.time += ms;
            this.retryFindingTargetCooldown -= ms;
            if (!(this.firingBeam || this.type.getReload(this.ship.currentBonuses) <= 0 || this.ammoLeft <= 0 && this.type.getClip(this.ship.currentBonuses) != 0)) {
                if (this.clipReloadCooldown > 0) {
                    this.clipReloadCooldown = (int)((double)this.clipReloadCooldown - (double)ms * this.staffProportion());
                } else {
                    double reloadFactor = this.type.getObeysFireMode() ? this.ship.fireMode.reloadFactor : 1.0;
                    this.shootAccumulator = StrictMath.min((int)((double)this.shootAccumulator + (double)ms * this.staffProportion()), (int)((double)this.type.getReload(this.ship.currentBonuses) * reloadFactor * 1.5));
                    this.reTargetAccumulator += ms;
                    if (this.ship.fireMode != FireMode.HOLD && this.retryFindingTargetCooldown <= 0 && (double)this.shootAccumulator >= (double)this.type.getReload(this.ship.currentBonuses) * reloadFactor) {
                        if (this.fire(c)) {
                            if (this.type.getClip(this.ship.currentBonuses) != 0) {
                                --this.ammoLeft;
                            }
                            this.shootAccumulator = (int)((double)this.shootAccumulator - (double)this.type.getReload(this.ship.currentBonuses) * reloadFactor);
                            this.fired = true;
                            if (this.type.getFireSound(this.ship.currentBonuses) != null && this.fireSoundCounter++ % this.type.getSoundEvery(this.ship.currentBonuses) == 0) {
                                Pt mz = this.currentMuzzle();
                                c.play(this.type.getFireSound(this.ship.currentBonuses), mz.x, mz.y, this.ship.getxSpeed(), this.ship.getySpeed(), onViewingSide);
                            }
                            this.noValidTarget = false;
                        } else {
                            this.noValidTarget = true;
                            this.retryFindingTargetCooldown = 150 + StrictMath.min(150, this.type.getReload(this.ship.currentBonuses) / 10);
                        }
                    }
                }
            } else {
                this.noValidTarget = false;
            }
            if (this.type.getCoalReload(this.ship.currentBonuses) > 0) {
                this.msUntilCoal = StrictMath.max(this.msUntilCoal - ms, 0);
            }
        } else if (this.type.hasSpecificDestroyedExternalAppearances() && this.hp <= 0 && this.type.getDestructionLength(this.ship.currentBonuses) != 0) {
            this.time += ms;
        }
    }

    public void throwFragments(Combat c, boolean explosively) {
        ArrayList<ModuleType.FragmentImg> frags;
        boolean withFuze;
        int frameIndex = (this.time + this.animOffset) / this.type.getApp((BonusSet)this.ship.currentBonuses).interval % this.type.getApp((BonusSet)this.ship.currentBonuses).frames.size();
        int mx = this.ship.getIntX() + this.ship.gridXToWorldX(this.x, this.type.getW()) * 16;
        int my = this.ship.getIntY() + this.y * 16;
        double speedM = (explosively ? 1.0 : 0.35) * this.type.getFragmentsSpeedMult();
        int burnAmt = (int)((double)(explosively ? 11 : 6) * this.type.getFragmentsFireMult());
        boolean bl = withFuze = this.type.isWeapon() || this.type.getAmmo(this.ship.currentBonuses) > 0 || this.type.getExplodeDmg(this.ship.currentBonuses) > 0;
        if (frameIndex < this.type.getAppWreckage(this.ship.currentBonuses).size() && !(frags = this.type.getAppWreckage(this.ship.currentBonuses).get(frameIndex)).isEmpty()) {
            ModuleType.FragmentImg fi = frags.get(AGame.ANIM_R.nextInt(frags.size()));
            if (this.type.isFlipped() ^ this.ship.flipped) {
                c.fragments.add(new Fragment(fi.ssb, fi.flipped, (double)(mx + this.type.getW() * 16 - fi.dx - fi.flipped.srcWidth), (double)(my + fi.dy), 0.0, 0.0, 0.0, 100000 + AGame.ANIM_R.nextInt(300000), burnAmt * 8, withFuze ? 100 + AGame.ANIM_R.nextInt(3000) : -1));
            } else {
                c.fragments.add(new Fragment(fi.ssb, fi.img, (double)(mx + fi.dx), (double)(my + fi.dy), 0.0, 0.0, 0.0, 100000 + AGame.ANIM_R.nextInt(300000), burnAmt * 8, withFuze ? 100 + AGame.ANIM_R.nextInt(3000) : -1));
            }
        }
        SpritesheetBundle gssb = SpritesheetBundle.ofName("general_fragments");
        ArrayList<GenericFragment> genFrags = Loadable.all(GenericFragment.class);
        for (int ty = 0; ty < this.type.getH(); ++ty) {
            for (int tx = 0; tx < this.type.getW(); ++tx) {
                List<ModuleType.FragmentImg> frags2;
                Tile t2 = this.ship.tileAt(this.x + (this.ship.flipped ? this.type.getW() - tx - 1 : tx), this.y + ty);
                if (t2 == null || t2.isMaskedEmpty()) continue;
                ParticleType dp = this.type.destructionParticle(this.ship.currentBonuses);
                if (this.type.getH() == 1 && this.type.getW() == 1) {
                    c.particles.add(new Particle(dp, mx + tx * 16 + 8, my + ty * 16 + 8));
                }
                double numDestructionParticles = this.type.destructionParticleDensity(this.ship.currentBonuses);
                while (true) {
                    double d = numDestructionParticles;
                    numDestructionParticles = d - 1.0;
                    if (!(d >= 1.0)) break;
                    c.particles.add(new Particle(dp, mx + tx * 16 + 8, my + ty * 16 + 8));
                }
                if (AGame.ANIM_R.nextDouble() < numDestructionParticles) {
                    c.particles.add(new Particle(dp, mx + tx * 16 + 8, my + ty * 16 + 8));
                }
                if (this.type.hasGenericDestructionFragments()) {
                    Img rndFragImg = genFrags.get((int)AGame.ANIM_R.nextInt((int)genFrags.size())).img;
                    double speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * speedM;
                    double angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                    double dx = speed * StrictMath.cos(angle);
                    double dy = speed * StrictMath.sin(angle) - 0.3 * speed;
                    c.fragments.add(new Fragment(gssb, rndFragImg, (double)(mx + tx * 16) + AGame.ANIM_R.nextDouble() * (double)(16 - rndFragImg.srcWidth), (double)(my + ty * 16) + AGame.ANIM_R.nextDouble() * (double)(16 - rndFragImg.srcHeight), dx, dy, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200), burnAmt));
                    rndFragImg = genFrags.get((int)AGame.ANIM_R.nextInt((int)genFrags.size())).img;
                    speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * speedM * 0.5;
                    angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                    dx = speed * StrictMath.cos(angle);
                    dy = speed * StrictMath.sin(angle);
                    c.fragments.add(new Fragment(gssb, rndFragImg, (double)(mx + tx * 16) + AGame.ANIM_R.nextDouble() * (double)(16 - rndFragImg.srcWidth), (double)(my + ty * 16) + AGame.ANIM_R.nextDouble() * (double)(16 - rndFragImg.srcHeight), dx, dy, 0.0, 100000 + AGame.ANIM_R.nextInt(300000), burnAmt * 3, withFuze ? 100 + AGame.ANIM_R.nextInt(3000) : -1));
                }
                if ((frags2 = t2.armour.getFragments(t2.armour.getMaxHP(), 0)).isEmpty()) continue;
                ModuleType.FragmentImg fi = frags2.get(AGame.ANIM_R.nextInt(frags2.size()));
                double speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * speedM;
                double angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                double dx = speed * StrictMath.cos(angle);
                double dy = speed * StrictMath.sin(angle) - 0.3 * speed;
                if (this.type.isFlipped() ^ this.ship.flipped) {
                    c.fragments.add(new Fragment(fi.ssb, fi.flipped, (double)(mx + tx * 16 - fi.dx - fi.flipped.srcWidth), (double)(my + ty * 16 + fi.dy), dx, dy, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200), burnAmt));
                    continue;
                }
                c.fragments.add(new Fragment(fi.ssb, fi.img, (double)(mx + tx * 16 + fi.dx), (double)(my + ty * 16 + fi.dy), dx, dy, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200), burnAmt));
            }
        }
        if (frameIndex < this.type.getAppFragments(this.ship.currentBonuses).size()) {
            ArrayList<ModuleType.FragmentImg> frags3 = this.type.getAppFragments(this.ship.currentBonuses).get(frameIndex);
            for (ModuleType.FragmentImg fi : frags3) {
                if (frags3.size() > 4 && AGame.ANIM_R.nextDouble() > this.type.getFragmentsDensity()) continue;
                double speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * speedM;
                double angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                double dx = speed * StrictMath.cos(angle);
                double dy = speed * StrictMath.sin(angle) - 0.3 * speed;
                if (this.type.isFlipped() ^ this.ship.flipped) {
                    c.fragments.add(new Fragment(fi.ssb, fi.flipped, (double)(mx + this.type.getW() * 16 - fi.dx - fi.flipped.srcWidth), (double)(my + fi.dy), dx, dy, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200), burnAmt));
                    continue;
                }
                c.fragments.add(new Fragment(fi.ssb, fi.img, (double)(mx + fi.dx), (double)(my + fi.dy), dx, dy, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200), burnAmt));
            }
        }
        ArrayList<ExternalApp> externalApps = this.type.getExternalApps(this.ship.currentBonuses, false, false);
        ArrayList<ArrayList<ArrayList<ModuleType.FragmentImg>>> externalFragments = this.type.getExternalFragments(this.ship.currentBonuses);
        int numExternalApps = externalApps.size();
        for (int externalAppIndex = 0; externalAppIndex < numExternalApps; ++externalAppIndex) {
            ExternalApp ea = externalApps.get(externalAppIndex);
            if (externalAppIndex >= externalFragments.size()) continue;
            ArrayList<ArrayList<ModuleType.FragmentImg>> fragmentsForApp = externalFragments.get(externalAppIndex);
            int eFrameIndex = (this.time + this.animOffset) / ea.app.interval % ea.app.frames.size();
            if (eFrameIndex >= fragmentsForApp.size()) continue;
            ArrayList<ModuleType.FragmentImg> frags4 = fragmentsForApp.get(eFrameIndex);
            for (ModuleType.FragmentImg fi : frags4) {
                if (frags4.size() > 4 && AGame.ANIM_R.nextDouble() > this.type.getFragmentsDensity()) continue;
                double speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * speedM;
                double angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                double dx = speed * StrictMath.cos(angle);
                double dy = speed * StrictMath.sin(angle) - 0.3 * speed;
                if (this.type.isFlipped() ^ this.ship.flipped) {
                    c.fragments.add(new Fragment(fi.ssb, fi.flipped, (double)(mx + this.type.getW() * 16 - ea.dx * 16 - fi.dx - fi.flipped.srcWidth), (double)(my + ea.dy * 16 + fi.dy), dx, dy, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200), burnAmt));
                    continue;
                }
                c.fragments.add(new Fragment(fi.ssb, fi.img, (double)(mx + ea.dx * 16 + fi.dx), (double)(my + ea.dy * 16 + fi.dy), dx, dy, 0.0, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200), burnAmt));
            }
        }
        if (!this.legs.isEmpty()) {
            Leg.Spec ls = this.legs.get((int)0).spec;
            for (Leg l : this.legs) {
                double rotatedOffsetY;
                double rotatedOffsetX;
                double dy;
                double dx;
                double angle;
                double speed;
                double hipX = this.ship.flipped ? (double)mx + ((double)this.type.getW() - l.spec.xOffset) * 16.0 : (double)mx + l.spec.xOffset * 16.0;
                double hipY = (double)my + l.spec.yOffset * 16.0;
                for (ModuleType.FragmentImg fi : ls.upperLegFrag) {
                    speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * 0.5;
                    angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                    dx = speed * StrictMath.cos(angle);
                    dy = speed * StrictMath.sin(angle);
                    double xOffsetVsHip = fi.dx - ls.upperLeg.srcWidth / 2 + fi.img.srcWidth / 2;
                    double yOffsetVsHip = fi.dy - ls.upperLeg.srcHeight / 2 + fi.img.srcHeight / 2;
                    rotatedOffsetX = StrictMath.cos(l.upperRotation) * xOffsetVsHip - StrictMath.sin(l.upperRotation) * yOffsetVsHip;
                    rotatedOffsetY = StrictMath.sin(l.upperRotation) * xOffsetVsHip + StrictMath.cos(l.upperRotation) * yOffsetVsHip;
                    c.fragments.add(new Fragment(fi.ssb, fi.img, hipX + rotatedOffsetX - (double)(fi.img.srcWidth / 2), hipY + rotatedOffsetY - (double)(fi.img.srcHeight / 2), dx, dy, l.upperRotation, AGame.ANIM_R.nextDouble() * 0.006 - 0.003, 500 + AGame.ANIM_R.nextInt(1200), AGame.ANIM_R.nextBoolean() ? 10 : 0));
                }
                for (ModuleType.FragmentImg fi : ls.lowerLegFrag) {
                    speed = AGame.rnd(0.1, 0.25, 0.2, 0.4, 0.8) * 0.7;
                    angle = AGame.ANIM_R.nextDouble() * 2.0 * Math.PI;
                    dx = speed * StrictMath.cos(angle);
                    dy = speed * StrictMath.sin(angle);
                    double xOffsetVsKnee = fi.dx - ls.lowerLeg.srcWidth / 2 + fi.img.srcWidth / 2;
                    double yOffsetVsKnee = fi.dy - ls.lowerLeg.srcHeight / 2 + fi.img.srcHeight / 2;
                    rotatedOffsetX = StrictMath.cos(l.lowerRotation) * xOffsetVsKnee - StrictMath.sin(l.lowerRotation) * yOffsetVsKnee;
                    rotatedOffsetY = StrictMath.sin(l.lowerRotation) * xOffsetVsKnee + StrictMath.cos(l.lowerRotation) * yOffsetVsKnee;
                    c.fragments.add(new Fragment(fi.ssb, fi.img, hipX + StrictMath.cos(l.upperRotation) * ls.upperLimbLength + rotatedOffsetX - (double)(fi.img.srcWidth / 2), hipY + StrictMath.sin(l.upperRotation) * ls.upperLimbLength + rotatedOffsetY - (double)(fi.img.srcHeight / 2), dx, dy, l.lowerRotation, AGame.ANIM_R.nextDouble() * 0.01 - 0.005, 500 + AGame.ANIM_R.nextInt(1200), AGame.ANIM_R.nextBoolean() ? 10 : 0));
                }
            }
        }
    }

    void explode(Combat c, boolean onViewingSide) {
        int i;
        double scale = (double)StrictMath.max(this.type.getW(), this.type.getH()) / 1.5;
        int n = (int)(12.0 * scale);
        int explodeX = this.ship.getIntX() + this.ship.gridXToWorldX(this.x, this.type.getW()) * 16 + this.type.getW() * 16 / 2;
        int explodeY = this.ship.getIntY() + this.y * 16 + this.type.getH() * 16 / 2;
        c.blasts.add(new Blast(explodeX, explodeY, scale * 15.0, scale * 10.0));
        this.throwFragments(c, true);
        int parts = 8;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("explode_backs"), explodeX, explodeY, scale));
        }
        parts = 1;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("shockwave"), explodeX, explodeY, scale));
        }
        parts = n;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("small_soot"), explodeX, explodeY));
            c.particles.add(new Particle(ParticleType.ofName("large_soot"), explodeX, explodeY));
        }
        if (!SimplePref.REDUCED_FLASHING.get()) {
            parts = 1;
            for (i = 0; i < parts; ++i) {
                c.particles.add(new Particle(ParticleType.ofName("explode"), explodeX, explodeY, scale));
            }
        }
        parts = 12;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("explode_bits"), explodeX, explodeY, scale));
        }
        c.play(MiscCombatSound.MODULE_EXPLOSION, explodeX, explodeY, this.ship.getxSpeed(), this.ship.getySpeed(), onViewingSide);
    }

    private Combat.Side enemy(Combat c) {
        int ssz = c.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Combat.Side s = c.sides.get(si);
            if (s.ships.contains(this.ship)) continue;
            return s;
        }
        return null;
    }

    private int quality(Tile t) {
        int q = 1000 / (StrictMath.max(0, t.armour.hp) + 2);
        if (t.module.type.getCoalReload(this.ship.currentBonuses) > 0 && t.module.running()) {
            q *= 10;
        } else if (ModuleType.interesting.contains(t.module.type)) {
            q *= 10;
        }
        if (t.module.type.isExternal()) {
            q /= 8;
        }
        if (t.module.fire > 0) {
            q /= 8;
        }
        if (t.module.hp <= 0) {
            q /= 20;
        }
        return q + 1;
    }

    private Airship targetShip(Combat c) {
        if (this.ship.fireAt != null && this.ship.fireAt.dangerCache > 0.0) {
            return this.ship.fireAt;
        }
        Airship s = null;
        double best = 0.0;
        Combat.Side enemy = this.enemy(c);
        if (enemy == null) {
            if (!reportedBothSidesError) {
                AirshipGame.instance.reportError("Still have that problem with being on both sides!", null, null, false, true);
                reportedBothSidesError = true;
            }
            return null;
        }
        ArrayList<Airship> enemyShips = enemy.ships;
        int assz = enemyShips.size();
        for (int asi = 0; asi < assz; ++asi) {
            Airship as = enemyShips.get(asi);
            double dist = StrictMath.sqrt((this.ship.getIntX() - as.getIntX()) * (this.ship.getIntX() - as.getIntX()) + (this.ship.getIntY() - as.getIntY()) * (this.ship.getIntY() - as.getIntY()));
            double quality = as.dangerCache / (dist + 100.0);
            if (s != null && !(best < quality)) continue;
            s = as;
            best = quality;
        }
        return s;
    }

    public boolean canHit(Airship ts, double shipX, double shipY, double tX, double tY, boolean flipped, int inset) {
        double sX = flipped ? shipX + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0 : shipX + ((double)this.x + this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0;
        double sY = shipY + ((double)this.y + this.type.muzzleCenterY(this.ship.currentBonuses)) * 16.0;
        double tW = ts.getBBWidth();
        double tH = ts.getBBHeight();
        if (this.type.getFireArc(this.ship.currentBonuses) == null) {
            System.out.println("fan");
            return false;
        }
        if (this.type.getFireArc(this.ship.currentBonuses).contains(Direction.DOWN) && sX > tX && sX < tX + tW && sY < tY) {
            return true;
        }
        return this.canHit(sX, sY, tX + tW / 2.0, tY + tH / 2.0, flipped, inset) || this.canHit(sX, sY, tX, tY, flipped, inset) || this.canHit(sX, sY, tX + tW, tY, flipped, inset) || this.canHit(sX, sY, tX, tY + tH, flipped, inset) || this.canHit(sX, sY, tX + tW, tY + tH, flipped, inset);
    }

    public boolean canHit(double sX, double sY, double tX, double tY, boolean flipped, int inset) {
        if (this.type.getMaxXRange(this.ship.currentBonuses) > 0 && StrictMath.abs(tX - sX) + (double)inset > (double)this.type.getMaxXRange(this.ship.currentBonuses)) {
            return false;
        }
        if (this.type.getMinXRange(this.ship.currentBonuses) > 0 && StrictMath.abs(tX - sX) - (double)inset < (double)this.type.getMinXRange(this.ship.currentBonuses)) {
            return false;
        }
        if (this.type.getMaxUpRange(this.ship.currentBonuses) > 0 && sY - tY + (double)inset > (double)this.type.getMaxUpRange(this.ship.currentBonuses)) {
            return false;
        }
        if (this.type.getMaxRange(this.ship.currentBonuses) > 0 && (tX - sX) * (tX - sX) + (tY - sY) * (tY - sY) + (double)(inset * inset) > (double)(this.type.getMaxRange(this.ship.currentBonuses) * this.type.getMaxRange(this.ship.currentBonuses))) {
            return false;
        }
        if (flipped) {
            return this.type.getFireArc(this.ship.currentBonuses).containsVector(sX - tX, tY - sY);
        }
        return this.type.getFireArc(this.ship.currentBonuses).containsVector(tX - sX, tY - sY);
    }

    public boolean canHitCloseUp(Airship ts, double shipX, double shipY, double tX, double tY, boolean flipped, int inset) {
        double sX = flipped ? shipX + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0 : shipX + ((double)this.x + this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0;
        double sY = shipY + ((double)this.y + this.type.muzzleCenterY(this.ship.currentBonuses)) * 16.0;
        double tW = ts.getBBWidth();
        double tH = ts.getBBHeight();
        if (this.type.getFireArc(this.ship.currentBonuses).contains(Direction.DOWN) && sX > tX && sX < tX + tW && sY < tY) {
            return true;
        }
        return this.canHitCloseUp(sX, sY, tX + 8.0, tY + tH / 2.0, flipped, inset) || this.canHitCloseUp(sX, sY, tX + tW - 8.0, tY + tH / 2.0, flipped, inset);
    }

    public boolean canHitCloseUp(double sX, double sY, double tX, double tY, boolean flipped, int inset) {
        if (this.type.getMaxXRange(this.ship.currentBonuses) > 0 && StrictMath.abs(tX - sX) + (double)inset > (double)this.type.getMaxXRange(this.ship.currentBonuses)) {
            return false;
        }
        if (this.type.getMinXRange(this.ship.currentBonuses) > 0 && StrictMath.abs(tX - sX) - (double)inset < (double)this.type.getMinXRange(this.ship.currentBonuses)) {
            return false;
        }
        if (this.type.getMaxUpRange(this.ship.currentBonuses) > 0 && sY - tY + (double)inset > (double)this.type.getMaxUpRange(this.ship.currentBonuses)) {
            return false;
        }
        if (this.type.getMaxRange(this.ship.currentBonuses) > 0 && (tX - sX) * (tX - sX) + (tY - sY) * (tY - sY) + (double)(inset * inset) > (double)(this.type.getMaxRange(this.ship.currentBonuses) * this.type.getMaxRange(this.ship.currentBonuses))) {
            return false;
        }
        if (flipped) {
            return this.type.getInnerTwoThirdsFireArc(this.ship.currentBonuses).containsVector(sX - tX, tY - sY);
        }
        return this.type.getInnerTwoThirdsFireArc(this.ship.currentBonuses).containsVector(tX - sX, tY - sY);
    }

    private boolean canHit(Combat c, Airship ts, Tile t, double sx, double sy) {
        int tX = ts.getIntX() + ts.gridXToWorldX(t.x, 1) * 16 + 8;
        int tY = ts.getIntY() + t.y * 16 + 8;
        return this.canHit(sx, sy, tX, tY);
    }

    private boolean canHit(double sx, double sy, int tX, int tY) {
        if (this.type.getMaxXRange(this.ship.currentBonuses) > 0 && StrictMath.abs((double)tX - sx) > (double)this.type.getMaxXRange(this.ship.currentBonuses)) {
            return false;
        }
        if (this.type.getMaxRange(this.ship.currentBonuses) > 0 && ((double)tX - sx) * ((double)tX - sx) + ((double)tY - sy) * ((double)tY - sy) > (double)(this.type.getMaxRange(this.ship.currentBonuses) * this.type.getMaxRange(this.ship.currentBonuses))) {
            return false;
        }
        if (this.type.getMinXRange(this.ship.currentBonuses) > 0 && StrictMath.abs((double)tX - sx) < (double)this.type.getMinXRange(this.ship.currentBonuses)) {
            return false;
        }
        if (this.type.getMaxUpRange(this.ship.currentBonuses) > 0 && sy - (double)tY > (double)this.type.getMaxUpRange(this.ship.currentBonuses)) {
            return false;
        }
        double dir = Direction.radiansFromTo(sx, sy, tX, tY);
        if (this.ship.flipped) {
            dir = Direction.flipHorizontal(dir);
        }
        return this.type.getFireArc(this.ship.currentBonuses).contains(dir);
    }

    private Tile target(Combat c, Airship ts, double sx, double sy) {
        int qSum = 0;
        ArrayList<Tile> options = new ArrayList<Tile>();
        int tsz = ts.tiles.size();
        int maxXRange = this.type.getMaxXRange(this.ship.currentBonuses);
        int maxUpRange = this.type.getMaxUpRange(this.ship.currentBonuses);
        int maxRange = this.type.getMaxRange(this.ship.currentBonuses);
        for (int ti = 0; ti < tsz; ++ti) {
            double d2;
            Tether.Spec tetherSpec;
            Tile t = ts.tiles.get(ti);
            if (t.isMaskedEmpty()) continue;
            int tX = ts.getIntX() + ts.gridXToWorldX(t.x, 1) * 16 + 8;
            int tY = ts.getIntY() + t.y * 16 + 8;
            if (maxXRange > 0 && StrictMath.abs((double)tX - sx) > (double)maxXRange || maxUpRange > 0 && sy - (double)tY > (double)maxUpRange || maxRange > 0 && ((double)tX - sx) * ((double)tX - sx) + ((double)tY - sy) * ((double)tY - sy) > (double)(maxRange * maxRange) || (tetherSpec = this.type.getTetherSpec(this.ship.currentBonuses)) != null && (d2 = ((double)tX - sx) * ((double)tX - sx) + ((double)tY - sy) * ((double)tY - sy)) > tetherSpec.maxRange * tetherSpec.maxRange || (this.ship.flipped ? !this.type.getFireArc(this.ship.currentBonuses).containsVector(sx - (double)tX, (double)tY - sy) : !this.type.getFireArc(this.ship.currentBonuses).containsVector((double)tX - sx, (double)tY - sy))) continue;
            qSum += this.quality(t);
            options.add(t);
        }
        if (options.isEmpty()) {
            return null;
        }
        int roll = c.r.nextInt(qSum);
        int osz = options.size();
        for (int oi = 0; oi < osz; ++oi) {
            Tile t = (Tile)options.get(oi);
            if ((roll -= this.quality(t)) > 0) continue;
            return t;
        }
        return null;
    }

    private Utils.Pair<Airship, Pt> target(Combat c, double sx, double sy) {
        Airship as;
        int asi;
        int assz;
        ArrayList<Airship> enemyShips;
        double sX = this.ship.flipped ? (double)this.ship.getIntX() + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0 : (double)this.ship.getIntX() + ((double)this.x + this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0;
        double sY = (double)this.ship.getIntY() + ((double)this.y + this.type.muzzleCenterY(this.ship.currentBonuses)) * 16.0;
        Airship ts = null;
        if (this.type.getTetherSpec(this.ship.currentBonuses) != null) {
            if (this.tether == null || this.tether.tb.ship != this.ship.tetherAt) {
                ts = this.ship.tetherAt;
            }
        } else {
            if (this.reTargetAccumulator >= 2000 && this.prevTargetShip != null && (sX - this.prevTargetShip.getX() - this.prevTargetShip.getBBWidth() / 2.0) * (sX - this.prevTargetShip.getX() - this.prevTargetShip.getBBWidth() / 2.0) + (sY - this.prevTargetShip.getY() - this.prevTargetShip.getBBHeight() / 2.0) * (sY - this.prevTargetShip.getY() - this.prevTargetShip.getBBHeight() / 2.0) > (double)(this.type.getOptimumRange(this.ship.currentBonuses) * this.type.getOptimumRange(this.ship.currentBonuses) * 4)) {
                this.reTargetAccumulator = 0;
                this.prevTargetShip = null;
            }
            if ((this.ship.fireAt == null || this.ship.fireAt == this.prevTargetShip) && this.prevTargetShip != null && this.prevTarget.module.hp > 0 && this.prevTargetShip.tiles.contains(this.prevTarget) && this.prevTargetShip.dangerCache > 0.0) {
                Pt mz = this.fireFrom();
                if (this.canHit(c, this.prevTargetShip, this.prevTarget, mz.x, mz.y)) {
                    return new Utils.Pair((Object)this.prevTargetShip, (Object)new Pt((double)(this.prevTargetShip.getIntX() + this.prevTargetShip.gridXToWorldX(this.prevTarget.x, 1) * 16 + 8), (double)(this.prevTargetShip.getIntY() + this.prevTarget.y * 16 + 8)));
                }
            }
            this.prevTargetShip = null;
            this.prevTarget = null;
            this.hasPrevJitter = false;
            ts = this.targetShip(c);
        }
        if (ts == null) {
            return null;
        }
        Tile tt = this.target(c, ts, sx, sy);
        if (tt == null) {
            enemyShips = this.enemy((Combat)c).ships;
            assz = enemyShips.size();
            for (asi = 0; asi < assz; ++asi) {
                as = enemyShips.get(asi);
                if (as.dangerCache <= 0.0 || (tt = this.target(c, as, sx, sy)) == null) continue;
                ts = as;
                break;
            }
        }
        if (tt == null) {
            enemyShips = this.enemy((Combat)c).ships;
            assz = enemyShips.size();
            for (asi = 0; asi < assz; ++asi) {
                as = enemyShips.get(asi);
                if (as.dangerCache > 0.0 || (tt = this.target(c, as, sx, sy)) == null) continue;
                ts = as;
                break;
            }
        }
        if (tt == null) {
            return null;
        }
        this.prevTarget = tt;
        this.prevTargetShip = ts;
        return new Utils.Pair((Object)ts, (Object)new Pt((double)(ts.getIntX() + ts.gridXToWorldX(tt.x, 1) * 16 + 8), (double)(ts.getIntY() + tt.y * 16 + 8)));
    }

    private double jitter(Combat c, double value, double dist, boolean yJitter, double mult, double fixedInaccuracy) {
        double inaccuracy = this.type.getInaccuracy(this.ship.currentBonuses) * this.ship.getInaccuracyMultiplier() * c.getInaccuracyMultiplier();
        double inaccuracyFactor = this.type.getObeysFireMode() ? this.ship.fireMode.inaccuracyFactor : 1.0;
        double jitter = (dist * inaccuracy * 16.0 * inaccuracyFactor + fixedInaccuracy) * c.r.nextGaussian();
        if (this.hasPrevJitter) {
            jitter = (1.0 - this.type.getJitterMerge(this.ship.currentBonuses)) * jitter + this.type.getJitterMerge(this.ship.currentBonuses) * (yJitter ? this.prevYJitter : this.prevXJitter);
        }
        if (yJitter) {
            this.prevYJitter = jitter;
        } else {
            this.prevXJitter = jitter;
        }
        return value + jitter * mult;
    }

    private double multiShotJitter(Combat c, double value, double dist) {
        double inaccuracy = this.type.getMultiShotJitter(this.ship.currentBonuses);
        double jitter = dist * inaccuracy * c.r.nextGaussian() * 16.0;
        return value + jitter;
    }

    public Pt currentMuzzle(double muzzleLengthFactor) {
        double sX = (this.ship.flipped ? (double)this.ship.getIntX() + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0 : (double)this.ship.getIntX() + ((double)this.x + this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0) + StrictMath.cos(this.weaponAngle) * this.type.muzzleLength(this.ship.currentBonuses) * 16.0 * muzzleLengthFactor;
        double sY = (double)this.ship.getIntY() + ((double)this.y + this.type.muzzleCenterY(this.ship.currentBonuses)) * 16.0 + StrictMath.sin(this.weaponAngle) * this.type.muzzleLength(this.ship.currentBonuses) * 16.0 * muzzleLengthFactor;
        return new Pt(sX, sY);
    }

    public Pt currentMuzzle() {
        double sX = (this.ship.flipped ? (double)this.ship.getIntX() + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0 : (double)this.ship.getIntX() + ((double)this.x + this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0) + StrictMath.cos(this.weaponAngle) * this.type.muzzleLength(this.ship.currentBonuses) * 16.0;
        double sY = (double)this.ship.getIntY() + ((double)this.y + this.type.muzzleCenterY(this.ship.currentBonuses)) * 16.0 + StrictMath.sin(this.weaponAngle) * this.type.muzzleLength(this.ship.currentBonuses) * 16.0;
        return new Pt(sX, sY);
    }

    public Pt fireFrom() {
        double sX = this.ship.flipped ? (double)this.ship.getIntX() + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0 : (double)this.ship.getIntX() + ((double)this.x + this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0;
        double sY = (double)this.ship.getIntY() + ((double)this.y + this.type.muzzleCenterY(this.ship.currentBonuses)) * 16.0;
        return new Pt(sX, sY);
    }

    public void updateBeam(Combat c, int ms) {
        if (!this.running()) {
            this.firingBeam = false;
            return;
        }
        BeamSpec bs = this.type.beamSpec(this.ship.currentBonuses);
        double prevSteadyBeamTimeProportion = (double)StrictMath.max(bs.fadeInTime, this.beamAge) * 1.0 / (double)(bs.fadeInTime + bs.steadyTime + bs.fadeOutTime);
        double prevSteadyBeamX = (double)this.beamStartPositionX * (1.0 - prevSteadyBeamTimeProportion) + (double)this.beamEndPositionX * prevSteadyBeamTimeProportion;
        double prevSteadyBeamY = (double)this.beamStartPositionY * (1.0 - prevSteadyBeamTimeProportion) + (double)this.beamEndPositionY * prevSteadyBeamTimeProportion;
        this.beamAge += ms;
        if (this.subBeamFlickers == null || this.subBeamFlickers.length != bs.subBeams.size()) {
            this.subBeamFlickers = new double[bs.subBeams.size()];
        }
        for (int i = 0; i < this.subBeamFlickers.length; ++i) {
            BeamSpec.SubBeam sb = bs.subBeams.get(i);
            double flicker = (AGame.ANIM_R.nextDouble() * 2.0 - 1.0) * sb.flickerAmount;
            this.subBeamFlickers[i] = this.subBeamFlickers[i] * sb.prevFlickerProportion + flicker * (1.0 - sb.prevFlickerProportion);
            this.subBeamFlickers[i] = this.subBeamFlickers[0] * sb.firstBeamFlickerProportion + this.subBeamFlickers[i] * (1.0 - sb.firstBeamFlickerProportion);
        }
        double beamTimeProportion = (double)this.beamAge * 1.0 / (double)(bs.fadeInTime + bs.steadyTime + bs.fadeOutTime);
        double beamX = (double)this.beamStartPositionX * (1.0 - beamTimeProportion) + (double)this.beamEndPositionX * beamTimeProportion;
        double beamY = (double)this.beamStartPositionY * (1.0 - beamTimeProportion) + (double)this.beamEndPositionY * beamTimeProportion;
        double muzzleCenterX = this.ship.flipped ? (double)this.ship.getIntX() + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0 : (double)this.ship.getIntX() + ((double)this.x + this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0;
        double muzzleCenterY = (double)this.ship.getIntY() + ((double)this.y + this.type.muzzleCenterY(this.ship.currentBonuses)) * 16.0;
        this.weaponAngle = Direction.radiansFromTo(muzzleCenterX, muzzleCenterY, beamX, beamY);
        if (bs.emitParticle != null && AGame.ANIM_R.nextDouble() < bs.emitParticleProbability * (double)ms) {
            Pt muz = this.currentMuzzle();
            c.particles.add(new Particle(bs.emitParticle, muz.x, muz.y));
        }
        double steadyBeamTimeProportion = StrictMath.min(1.0, (double)(this.beamAge - bs.fadeInTime) * 1.0 / (double)bs.steadyTime);
        int expectedShotsFired = (int)StrictMath.ceil((double)this.type.getNumShots(this.ship.currentBonuses) * steadyBeamTimeProportion);
        if (this.beamShotsFired < expectedShotsFired) {
            boolean beamDidHit = false;
            int shots = expectedShotsFired - this.beamShotsFired;
            this.beamShotsFired = expectedShotsFired;
            Combat.Side mySide = c.sideOf(this.ship);
            Combat.Side enemySide = c.otherSide(mySide);
            for (int shotI = 0; shotI < shots; ++shotI) {
                double shotX = prevSteadyBeamX + (beamX - prevSteadyBeamX) / (double)shots * (double)shotI;
                double shotY = prevSteadyBeamY + (beamY - prevSteadyBeamY) / (double)shots * (double)shotI;
                Shot shot = new Shot((Airship)null, shotX, shotY, this.ship, beamX, beamY, this, 1.0);
                if (shot.getBlastSplashRadius() > 0) {
                    c.doSplashDmg(shot.tX, shot.tY, shot.getBlastDmg(), shot.getBlastSplashRadius(), shot, null, mySide);
                }
                if (bs.hitTroops) {
                    for (int ti = 0; ti < enemySide.troops.size(); ++ti) {
                        Crewman troop = enemySide.troops.get(ti);
                        if (troop.hit(shot, c, false) == null) continue;
                        beamDidHit = true;
                        if (!bs.pierceTroops) break;
                    }
                }
                if (!beamDidHit || bs.pierceTroops) {
                    for (int si = 0; si < enemySide.ships.size(); ++si) {
                        Airship s = enemySide.ships.get(si);
                        if (s.hit(shot, c, false) == null) continue;
                        beamDidHit = true;
                        break;
                    }
                }
                if (!beamDidHit || bs.hitParticle == null || !(AGame.ANIM_R.nextDouble() < bs.hitParticleProbability * (double)ms)) continue;
                c.particles.add(new Particle(bs.hitParticle, shotX, shotY));
            }
        }
        if (beamTimeProportion >= 1.0) {
            this.firingBeam = false;
        }
    }

    public boolean fire(Combat c) {
        Utils.Pair<Airship, Pt> target;
        double muzzleCenterX = this.ship.flipped ? (double)this.ship.getIntX() + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0 : (double)this.ship.getIntX() + ((double)this.x + this.type.muzzleCenterX(this.ship.currentBonuses)) * 16.0;
        double muzzleCenterY = (double)this.ship.getIntY() + ((double)this.y + this.type.muzzleCenterY(this.ship.currentBonuses)) * 16.0;
        Airship targetShip = null;
        PhysicsRect targetTroop = null;
        Pt targetPt = null;
        double str = this.type.getShootTroopsRange(this.ship.currentBonuses);
        if (str > 0.0) {
            ArrayList<Crewman> enemyTroops = c.otherSide((Combat.Side)c.sideOf((Airship)this.ship)).troops;
            int tsz = enemyTroops.size();
            double minDsq = str * str;
            for (int ti = 0; ti < tsz; ++ti) {
                double dSq;
                double ty;
                Crewman t = enemyTroops.get(ti);
                double tx = t.getX() + t.getBBWidth() / 2.0;
                if (!this.canHit(muzzleCenterX, muzzleCenterY, (int)tx, (int)(ty = t.getY() + t.getBBHeight() / 2.0)) || !((dSq = (muzzleCenterX - tx) * (muzzleCenterX - tx) + (muzzleCenterY - ty) * (muzzleCenterY - ty)) < minDsq)) continue;
                minDsq = dSq;
                targetTroop = t;
            }
            if (targetTroop != null) {
                targetPt = new Pt(targetTroop.getX() + ((Crewman)targetTroop).getBBWidth() / 2.0, targetTroop.getY() + ((Crewman)targetTroop).getBBHeight() / 2.0);
            }
        }
        if (targetPt == null && (target = this.target(c, muzzleCenterX, muzzleCenterY)) != null) {
            targetShip = (Airship)target.a;
            targetPt = (Pt)target.b;
        }
        if (targetPt == null) {
            this.noValidTarget = true;
            return false;
        }
        double approximateDist = StrictMath.sqrt((muzzleCenterX - targetPt.x) * (muzzleCenterX - targetPt.x) + (muzzleCenterY - targetPt.y) * (muzzleCenterY - targetPt.y));
        TimeOfDay tod = c.timeOfDay;
        WeatherEffect we = tod.effect;
        double jitterMult = we.shootJitterMult;
        if (targetPt.x > muzzleCenterX) {
            jitterMult *= we.shootToRightJitterMult;
            if (we.shootToRightJitterMult > 1.0) {
                c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("shootIntoLight " + this.type.name, c.sideOf(this.ship), muzzleCenterX, muzzleCenterY, null, this.ship));
            }
        } else {
            jitterMult *= we.shootToLeftJitterMult;
            if (we.shootToLeftJitterMult > 1.0) {
                c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("shootIntoLight " + this.type.name, c.sideOf(this.ship), muzzleCenterX, muzzleCenterY, null, this.ship));
            }
        }
        if (we.fog && targetPt.y > 112.0) {
            jitterMult *= 3.0;
        }
        BeamSpec bs = this.type.beamSpec(this.ship.currentBonuses);
        WeaponAppearance wa = this.type.weaponAppearance(this.ship.currentBonuses);
        if (bs != null) {
            Pt muz = this.currentMuzzle();
            double sX = muz.x;
            double sY = muz.y;
            double dist = StrictMath.sqrt((sX - targetPt.x) * (sX - targetPt.x) + (sY - targetPt.y) * (sY - targetPt.y));
            double tX = this.jitter(c, targetPt.x, dist, false, jitterMult, targetTroop != null ? this.type.getFixedInaccuracyVsTroops(this.ship.currentBonuses) : 0.0);
            double tY = this.jitter(c, targetPt.y, dist, true, jitterMult, targetTroop != null ? this.type.getFixedInaccuracyVsTroops(this.ship.currentBonuses) : 0.0);
            this.hasPrevJitter = true;
            c.msSinceShotFired = 0;
            this.firingBeam = true;
            this.beamAge = 0;
            this.beamShotsFired = 0;
            if (this.subBeamFlickers == null || this.subBeamFlickers.length != bs.subBeams.size()) {
                this.subBeamFlickers = new double[bs.subBeams.size()];
            }
            double moveAngle = c.r.nextDouble() * Math.PI * 2.0;
            double preSteadyDist = (double)bs.fadeInTime * 1.0 / (double)(bs.fadeInTime + bs.steadyTime + bs.fadeOutTime) * (double)bs.moveDistance;
            double postSteadyDist = (double)(bs.steadyTime + bs.fadeOutTime) * 1.0 / (double)(bs.fadeInTime + bs.steadyTime + bs.fadeOutTime) * (double)bs.moveDistance;
            this.beamStartPositionX = (int)(tX - StrictMath.cos(moveAngle) * preSteadyDist / 2.0);
            this.beamStartPositionY = (int)(tY - StrictMath.sin(moveAngle) * preSteadyDist / 2.0);
            this.beamEndPositionX = (int)(tX + StrictMath.cos(moveAngle) * postSteadyDist / 2.0);
            this.beamEndPositionY = (int)(tY + StrictMath.sin(moveAngle) * postSteadyDist / 2.0);
            this.weaponAngle = Direction.radiansFromTo(muzzleCenterX, muzzleCenterY, this.beamStartPositionX, this.beamStartPositionY);
        } else {
            double shotSpeed = this.type.getShotSpeed(this.ship.currentBonuses);
            if (targetShip != null && shotSpeed < 0.3 && approximateDist / (shotSpeed + 0.001) > 3000.0 && targetShip.readyForCommand()) {
                c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("dodgableShot " + this.type.name, c.sideOf(targetShip), muzzleCenterX, muzzleCenterY, null, targetShip));
            }
            double approximateTravelTime = approximateDist / shotSpeed;
            double targetXSpeed = targetShip != null ? targetShip.getxSpeed() : 0.0;
            double tXLead = targetXSpeed * approximateTravelTime;
            double tXLeadMult = 0.85;
            this.weaponAngle = Direction.radiansFromTo(muzzleCenterX, muzzleCenterY, targetPt.x + tXLead * tXLeadMult, targetPt.y);
            if (!this.type.getFireArc(this.ship.currentBonuses).contains(this.weaponAngle)) {
                tXLeadMult = 0.0;
                this.weaponAngle = Direction.radiansFromTo(muzzleCenterX, muzzleCenterY, targetPt.x, targetPt.y);
            }
            Pt muz = this.currentMuzzle();
            double sX = muz.x;
            double sY = muz.y;
            double dist = StrictMath.sqrt((sX - targetPt.x) * (sX - targetPt.x) + (sY - targetPt.y) * (sY - targetPt.y));
            double tX = this.jitter(c, targetPt.x + tXLead * tXLeadMult, dist, false, jitterMult, targetTroop != null ? this.type.getFixedInaccuracyVsTroops(this.ship.currentBonuses) : 0.0);
            double tY = this.jitter(c, targetPt.y, dist, true, jitterMult, targetTroop != null ? this.type.getFixedInaccuracyVsTroops(this.ship.currentBonuses) : 0.0);
            this.hasPrevJitter = true;
            c.msSinceShotFired = 0;
            int numShots = this.type.getNumShots(this.ship.currentBonuses);
            double ssv = this.type.getShotSpeedVariation(this.ship.currentBonuses);
            if (numShots > 1) {
                for (int shotN = 0; shotN < numShots; ++shotN) {
                    double tX2 = this.multiShotJitter(c, tX, dist);
                    double tY2 = this.multiShotJitter(c, tY, dist);
                    Shot shot = targetShip != null ? new Shot(targetShip, tX2, tY2, this.ship, sX, sY, this.self, StrictMath.max(0.1, 1.0 + (c.r.nextDouble() - 0.5) * ssv)) : new Shot((Crewman)targetTroop, tX2, tY2, this.ship, sX, sY, this.self, StrictMath.max(0.1, 1.0 + (c.r.nextDouble() - 0.5) * ssv));
                    c.shots.add(shot);
                    if (!(shotSpeed >= 0.5) || wa.shot == null) continue;
                    c.trails.add(new Trail(shot, (double)wa.shot[0].srcHeight * 0.5 + 1.0));
                }
            } else {
                Shot shot = targetShip != null ? new Shot(targetShip, tX, tY, this.ship, sX, sY, this.self, StrictMath.max(0.1, 1.0 + (c.r.nextDouble() - 0.5) * ssv)) : new Shot((Crewman)targetTroop, tX, tY, this.ship, sX, sY, this.self, StrictMath.max(0.1, 1.0 + (c.r.nextDouble() - 0.5) * ssv));
                c.shots.add(shot);
                if (shotSpeed >= 0.5 && wa.shot != null) {
                    c.trails.add(new Trail(shot, (double)wa.shot[0].srcHeight * 0.5 + 1.0));
                }
            }
        }
        this.recoil = wa.recoil;
        if (wa.barrelAnimation != null) {
            WeaponAppearance.BarrelAnimation ba = wa.barrelAnimation;
            if (!ba.loopConstantly) {
                if (ba.loop) {
                    this.barrelAnimationCooldown = ba.finishLoopCycle ? (int)StrictMath.ceil((double)(this.barrelAnimationOffset + ba.msPerShot) * 1.0 / (double)ba.totalLength) * ba.totalLength - this.barrelAnimationOffset : (this.barrelAnimationCooldown += ba.msPerShot);
                } else {
                    this.barrelAnimationOffset = 0;
                    this.barrelAnimationCooldown = ba.totalLength;
                }
            }
        }
        if (this.ship.type.mobile) {
            double forceAmt = this.type.getRecoilForce(this.ship.currentBonuses);
            this.ship.setxForce(this.ship.getxForce() - StrictMath.cos(this.weaponAngle) * forceAmt);
            this.ship.setyForce(this.ship.getyForce() - StrictMath.sin(this.weaponAngle) * forceAmt);
        }
        this.msSinceFired = 0;
        return true;
    }

    public void giveResource(Resource r, Combat c, boolean onViewingSide) {
        int soundX = this.ship.getIntX() + this.ship.gridXToWorldX(this.x, this.type.getW()) * 16 + this.type.getW() * 16 / 2;
        int soundY = this.ship.getIntY() + this.y * 16 + this.type.getH() * 16 / 2;
        switch (r) {
            case AMMO: {
                ++this.ammoForClip;
                if (this.ammoForClip >= this.type.getAmmoPerClip(this.ship.currentBonuses)) {
                    this.ammoForClip -= this.type.getAmmoPerClip(this.ship.currentBonuses);
                    this.ammoLeft += this.type.getClip(this.ship.currentBonuses);
                }
                this.clipReloadCooldown = this.type.getClipReloadTime(this.ship.currentBonuses);
                break;
            }
            case COAL: {
                this.msUntilCoal += this.type.getCoalReload(this.ship.currentBonuses);
                break;
            }
            case REPAIR: {
                c.play(MiscCombatSound.REPAIR, soundX, soundY, this.ship.getxSpeed(), this.ship.getySpeed(), onViewingSide);
                this.hp = StrictMath.min(this.getMaxRepairToHP(), this.hp + EmpireStat.REPAIR_AMOUNT.get(this.ship.currentBonuses));
                if (this.hp != this.getMaxRepairToHP()) break;
                this.damageReported = false;
                break;
            }
            case WATER: {
                c.play(MiscCombatSound.QUENCH, soundX, soundY, this.ship.getxSpeed(), this.ship.getySpeed(), onViewingSide);
                this.fire = StrictMath.max(0, this.fire - EmpireStat.FIRE_QUENCH_AMOUNT.get(this.ship.currentBonuses));
            }
        }
    }

    public int getShellPenAbsorb() {
        WeaponAppearance wa = this.type.weaponAppearance(this.ship.currentBonuses);
        if (wa == null) {
            return 0;
        }
        int absorb = 0;
        for (int i = 0; i < wa.shells.size(); ++i) {
            WeaponAppearance.Shell shell = wa.shells.get(i);
            double o = shell.getOpenness(this);
            absorb = StrictMath.max(absorb, (int)((1.0 - o) * (double)shell.shellClosedPenAbsorb));
        }
        return absorb;
    }

    public int getShellBlastAbsorb() {
        WeaponAppearance wa = this.type.weaponAppearance(this.ship.currentBonuses);
        if (wa == null) {
            return 0;
        }
        int absorb = 0;
        for (int i = 0; i < wa.shells.size(); ++i) {
            WeaponAppearance.Shell shell = wa.shells.get(i);
            double o = shell.getOpenness(this);
            absorb = StrictMath.max(absorb, (int)((1.0 - o) * (double)shell.shellClosedBlastAbsorb));
        }
        return absorb;
    }

    public int cheapHash() {
        int h = 7;
        h = h * 31 + this.x;
        h = h * 31 + this.y;
        h = h * 31 + this.type.name.hashCode();
        h = h * 31 + this.hp;
        h = h * 31 + this.fire;
        h = h * 31 + this.shootAccumulator;
        h = h * 31 + this.reTargetAccumulator;
        h = h * 31 + this.retryFindingTargetCooldown;
        h = h * 31 + this.msUntilCoal;
        return h;
    }

    public Module(Airship ship, ModuleType type, int x, int y) {
        this.ship = ship;
        this.type = type;
        this.x = x;
        this.y = y;
        this.fireSoundCounter = AGame.ANIM_R.nextInt(type.getSoundEvery(ship.currentBonuses));
        this.repairFully();
        this.setupJobs();
        this.fireLoopKey = type.name + " f" + LOOP_SOUND_COUNTER;
        this.runningLoopKey = type.name + " r" + LOOP_SOUND_COUNTER;
        ++LOOP_SOUND_COUNTER;
        for (Wheel.Spec ws : type.getWheelSpecs()) {
            this.wheels.add(new Wheel(ws, ship));
        }
        for (Leg.Spec ls : type.getLegSpecs()) {
            this.legs.add(new Leg(ls, ship, this));
        }
        for (TentacleSpec ts : type.getTentacleSpecs()) {
            this.tentacles.add(new Tentacle(ts));
        }
        this.altLegIndex = this.legs.size() / 2;
    }

    public JSONObject toJSON(Combat c) {
        JSONObject o = new JSONObject().put("type", this.type.name).put("x", this.x).put("y", this.y).put("ammoForClip", this.ammoForClip).put("ammoLeft", this.ammoLeft).put("shootAccumulator", this.shootAccumulator).put("reTargetAccumulator", this.reTargetAccumulator).put("msUntilCoal", this.msUntilCoal).put("fire", this.fire).put("explodeFuze", this.explodeFuze).put("burntOut", this.burntOut).put("hp", this.hp).put("lowestHP", this.hp).put("clipReloadCooldown", this.clipReloadCooldown).put("retryFindingTargetCooldown", this.retryFindingTargetCooldown).put("fired", this.fired).put("destructionTime", this.destructionTime).put("msSinceFired", this.msSinceFired);
        for (Map.Entry<Resource, Integer> r : this.resources.entrySet()) {
            o.put(r.getKey().name(), r.getValue());
        }
        if (this.externalPaint != null) {
            o.put("externalPaint", this.externalPaint.name);
        }
        if (c != null && this.prevTarget != null && this.prevTargetShip != null && this.prevTargetShip.tiles.contains(this.prevTarget)) {
            block1: for (Combat.Side s : c.sides) {
                for (Airship as : s.ships) {
                    if (as != this.prevTargetShip) continue;
                    o.put("prevTargetShipSide", c.sides.indexOf(s));
                    o.put("prevTargetShipIndex", s.ships.indexOf(as));
                    o.put("prevTargetTileIndex", as.tiles.indexOf(this.prevTarget));
                    break block1;
                }
            }
        }
        if (this.hasPrevJitter) {
            o.put("hasPrevJitter", true);
            o.put("prevXJitter", this.prevXJitter);
            o.put("prevYJitter", this.prevYJitter);
        }
        if (this.firingBeam) {
            o.put("firingBeam", true);
            o.put("beamAge", this.beamAge);
            o.put("beamStartPositionX", this.beamStartPositionX);
            o.put("beamStartPositionY", this.beamStartPositionY);
            o.put("beamEndPositionX", this.beamEndPositionX);
            o.put("beamEndPositionY", this.beamEndPositionY);
            o.put("beamShotsFired", this.beamShotsFired);
        }
        return o;
    }

    public Module(JSONObject o, Airship ship) {
        this.ship = ship;
        String typeName = o.getString("type");
        for (Substitution sub : Loadable.all(Substitution.class)) {
            if (!typeName.equals(sub.fromModule) || !sub.forTypes.contains((Object)ship.type)) continue;
            typeName = sub.toModule;
        }
        this.type = ModuleType.ofName(typeName);
        this.x = o.getInt("x");
        this.y = o.getInt("y");
        this.ammoLeft = o.getInt("ammoLeft");
        this.shootAccumulator = o.optInt("shootAccumulator", 0);
        this.reTargetAccumulator = o.optInt("reTargetAccumulator", 0);
        this.msUntilCoal = o.getInt("msUntilCoal");
        this.fire = o.getInt("fire");
        this.explodeFuze = o.optInt("explodeFuze", this.explodeFuze);
        this.burntOut = o.optBoolean("burntOut", false);
        this.hp = o.getInt("hp");
        this.lowestHP = o.optInt("lowestHP", this.hp);
        this.clipReloadCooldown = o.optInt("clipReloadCooldown", 0);
        this.retryFindingTargetCooldown = o.optInt("retryFindingTargetCooldown", 0);
        this.fired = o.optBoolean("fired", false);
        this.fireSoundCounter = AGame.ANIM_R.nextInt(this.type.getSoundEvery(BonusSet.empty()));
        this.destructionTime = o.optInt("destructionTime", 0);
        this.ammoForClip = o.optInt("ammoForClip", 0);
        this.msSinceFired = o.optInt("msSinceFired", 100000);
        if (o.has("externalPaint")) {
            this.externalPaint = PaintType.valueOf(o.getString("externalPaint"));
        }
        for (Resource r : Resource.values()) {
            if (!o.has(r.name())) continue;
            this.resources.put(r, o.getInt(r.name()));
        }
        this.setupJobs();
        for (Wheel.Spec ws : this.type.getWheelSpecs()) {
            this.wheels.add(new Wheel(ws, ship));
        }
        for (Leg.Spec ls : this.type.getLegSpecs()) {
            this.legs.add(new Leg(ls, ship, this));
        }
        for (TentacleSpec ts : this.type.getTentacleSpecs()) {
            this.tentacles.add(new Tentacle(ts));
        }
        this.resetWeaponBarrels();
        this.fireLoopKey = this.type.name + " f" + LOOP_SOUND_COUNTER;
        this.runningLoopKey = this.type.name + " r" + LOOP_SOUND_COUNTER;
        ++LOOP_SOUND_COUNTER;
        if (o.optBoolean("firingBeam", false)) {
            this.firingBeam = true;
            this.beamAge = o.getInt("beamAge");
            this.beamStartPositionX = o.getInt("beamStartPositionX");
            this.beamStartPositionY = o.getInt("beamStartPositionY");
            this.beamEndPositionX = o.getInt("beamEndPositionX");
            this.beamEndPositionY = o.getInt("beamEndPositionY");
            this.beamShotsFired = o.getInt("beamShotsFired");
        }
    }

    public void finish(JSONObject o, Combat c) {
        if (o.has("prevTargetShipSide")) {
            this.prevTargetShip = c.sides.get((int)o.getInt((String)"prevTargetShipSide")).ships.get(o.getInt("prevTargetShipIndex"));
            this.prevTarget = this.prevTargetShip.tiles.get(o.getInt("prevTargetTileIndex"));
        }
        if (o.optBoolean("hasPrevJitter", false)) {
            this.hasPrevJitter = true;
            this.prevXJitter = o.getDouble("prevXJitter");
            this.prevYJitter = o.getDouble("prevYJitter");
        }
    }

    private void setupJobs() {
        int i;
        for (i = 0; i < StrictMath.min(3, this.type.getOccupableTileCount()); ++i) {
            this.jobs.add(new RepairJob(i + 1));
            this.jobs.add(new WaterJob(i + 1));
        }
        for (i = 0; i < this.type.getCrew(this.ship.currentBonuses); ++i) {
            this.jobs.add(new StaffJob(i));
        }
        for (i = 0; i < this.type.getOptionalCrew(this.ship.currentBonuses); ++i) {
            this.jobs.add(new ReadyJob(i + 1));
        }
        if (this.type.getClip(this.ship.currentBonuses) > 0) {
            for (i = 0; i < this.type.getAmmoPerClip(this.ship.currentBonuses); ++i) {
                this.jobs.add(new AmmoJob(i + 1));
            }
        }
        if (this.type.getCoalReload(this.ship.currentBonuses) > 0) {
            this.jobs.add(new CoalJob());
        }
        for (i = 0; i < this.type.getSickbay(this.ship.currentBonuses); ++i) {
            this.jobs.add(new InjuryJob(i));
        }
        for (i = 0; i < this.type.getRecommendedGuards(this.ship.currentBonuses); ++i) {
            this.jobs.add(new GuardJob(i + 1));
        }
        for (i = 0; i < this.type.getFixedGuards(this.ship.currentBonuses); ++i) {
            this.jobs.add(new FixedGuardJob());
        }
    }

    public static double staffJobPriority(Airship ship, Module self, ModuleType type, int n) {
        if (type.getLift(ship.constructionBonuses) > 0) {
            return ship.grounded() ? 0.001 : 20.0;
        }
        if (!ship.type.onGround && type.getPropulsion(ship.currentBonuses) > 0.0 && ship.grounded()) {
            return 0.001;
        }
        if (type.getPropulsion(ship.currentBonuses) > 0.0 && ship.focusOnMoving) {
            return 8.9 - (double)n * 0.01;
        }
        if (type.isWeapon() && ship.focusOnShooting && (self.ammoLeft > 0 || self.type.getClip(ship.currentBonuses) == 0) && !self.noValidTarget) {
            return 2.8 - (double)n * 0.01;
        }
        if (type.getCommand(ship.currentBonuses) > 0 && n == 0) {
            return 40.0;
        }
        return 0.7 - (double)n * 0.01;
    }

    private strictfp class InjuryJob
    implements Job {
        private int index;

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return Resource.INJURED;
        }

        @Override
        public double priority() {
            return 1.2;
        }

        public InjuryJob(int index) {
            this.index = index;
        }

        @Override
        public boolean active() {
            if (Module.this.hp < 0 || !Module.this.fullyStaffed()) {
                return false;
            }
            int patients = 0;
            int csz = Module.this.ship.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman c = Module.this.ship.crew.get(ci);
                if (c.currentTile.module != Module.this.self || c.hp >= c.type.maxHP || !Module.this.type.necromancy(Module.this.ship.currentBonuses) && !c.alive()) continue;
                ++patients;
            }
            return patients + this.index < Module.this.type.getSickbay(Module.this.ship.currentBonuses);
        }

        public String toString() {
            return "Fetch injured for " + Module.this.type.getName();
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct.crewEffectiveness > 0.0;
        }

        @Override
        public boolean requiredUnoccupied() {
            return false;
        }
    }

    public strictfp class CoalJob
    implements Job {
        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return Resource.COAL;
        }

        @Override
        public double priority() {
            if (Module.this.msUntilCoal <= 0) {
                return Module.staffJobPriority(Module.this.ship, Module.this.self, Module.this.type, 1) * 3.0;
            }
            return 0.1 + (Module.this.fullyStaffed() ? (Module.this.type.getLift(Module.this.ship.constructionBonuses) > 0 ? 10000.0 : 1000.0) : (Module.this.ship.focusOnMoving ? 600.0 : 12.0)) / ((double)Module.this.msUntilCoal + 250.0);
        }

        @Override
        public boolean active() {
            int cr = Module.this.type.getCoalReload(Module.this.ship.currentBonuses);
            return cr > 0 && Module.this.msUntilCoal < cr && Module.this.hp > 0;
        }

        public String toString() {
            return "Fetch coal for " + Module.this.type.getName();
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct.crewEffectiveness > 0.0;
        }

        @Override
        public boolean requiredUnoccupied() {
            return Module.this.type.getLift(BonusSet.empty()) == 0;
        }
    }

    public strictfp class GuardJob
    implements Job {
        int mul;

        public GuardJob(int mul) {
            this.mul = mul;
        }

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return null;
        }

        @Override
        public double priority() {
            return 0.7 * (double)this.mul;
        }

        @Override
        public boolean active() {
            return Module.this.hp > 0 && Module.this.fire == 0;
        }

        public String toString() {
            return "Guard " + Module.this.type.getName();
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct.doesGuard;
        }

        @Override
        public boolean requiredUnoccupied() {
            return true;
        }
    }

    public strictfp class FixedGuardJob
    implements Job {
        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return null;
        }

        @Override
        public double priority() {
            return 1000000.0;
        }

        @Override
        public boolean active() {
            return Module.this.hp > 0 && Module.this.fire == 0;
        }

        public String toString() {
            return "Guard " + Module.this.type.getName();
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct.doesGuard;
        }

        @Override
        public boolean requiredUnoccupied() {
            return true;
        }
    }

    public strictfp class ReadyJob
    implements Job {
        int div;

        public ReadyJob(int div) {
            this.div = div;
        }

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return null;
        }

        @Override
        public double priority() {
            return 1.0E-6 / (double)this.div;
        }

        @Override
        public boolean active() {
            return Module.this.hp > 0 && Module.this.fire == 0;
        }

        public String toString() {
            return "Be ready at " + Module.this.type.getName();
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct.crewEffectiveness > 0.0;
        }

        @Override
        public boolean requiredUnoccupied() {
            return Module.this.type.getCoal(Module.this.ship.currentBonuses) == 0 && Module.this.type.getWater(Module.this.ship.currentBonuses) == 0;
        }
    }

    public strictfp class StaffJob
    implements Job {
        int n;

        public StaffJob(int n) {
            this.n = n;
        }

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return null;
        }

        @Override
        public double priority() {
            return Module.staffJobPriority(Module.this.ship, Module.this.self, Module.this.type, this.n);
        }

        @Override
        public boolean active() {
            return Module.this.type.getCrew(Module.this.ship.currentBonuses) > 0 && Module.this.hp > 0 && Module.this.hp > Module.this.fire * 3;
        }

        public String toString() {
            return "Man " + Module.this.type.getName();
        }

        @Override
        public boolean isCaptain() {
            return ((Module)Module.this).self.type.getCommand(BonusSet.empty()) > 0 && this.n == 0;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct.doesWork;
        }

        @Override
        public boolean requiredUnoccupied() {
            return Module.this.type.getLift(BonusSet.empty()) == 0;
        }
    }

    private strictfp class WaterJob
    implements Job {
        int div;

        @Override
        public Module module() {
            return Module.this.self;
        }

        public WaterJob(int div) {
            this.div = div;
        }

        @Override
        public Resource resource() {
            return Resource.WATER;
        }

        @Override
        public double priority() {
            return ((double)(Module.this.getMaxHP() - Module.this.hp) * 3.0 / (double)Module.this.getMaxHP() + (double)Module.this.fire) / (double)this.div * (double)(Module.this.ship.focusOnFirefighting ? 4 : 1);
        }

        @Override
        public boolean active() {
            return Module.this.fire > 0;
        }

        public String toString() {
            return "Put out fire at " + Module.this.type.getName();
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct.crewEffectiveness > 0.0;
        }

        @Override
        public boolean requiredUnoccupied() {
            return false;
        }
    }

    public strictfp class AmmoJob
    implements Job {
        private final int n;

        public AmmoJob(int n) {
            this.n = n;
        }

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return Resource.AMMO;
        }

        @Override
        public double priority() {
            if (Module.this.ammoLeft <= 0) {
                return Module.staffJobPriority(Module.this.ship, Module.this.self, Module.this.type, this.n) * 1.5 / (double)this.n;
            }
            return (Module.this.fullyStaffed() ? 0.5 : 0.2) / (double)(StrictMath.max(0, Module.this.ammoLeft) + 1) * (double)(Module.this.ship.focusOnShooting ? 4 : 1) / (double)this.n;
        }

        @Override
        public boolean active() {
            return Module.this.type.getClip(Module.this.ship.currentBonuses) > 0 && Module.this.ammoLeft < Module.this.type.getClip(Module.this.ship.currentBonuses) && Module.this.hp > 0 && Module.this.hp > Module.this.fire * 3;
        }

        public String toString() {
            return "Fetch ammo for " + Module.this.type.getName();
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct.crewEffectiveness > 0.0;
        }

        @Override
        public boolean requiredUnoccupied() {
            return true;
        }
    }

    private strictfp class RepairJob
    implements Job {
        int div;

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return Resource.REPAIR;
        }

        public RepairJob(int div) {
            this.div = div;
        }

        @Override
        public double priority() {
            return ((double)((Module.this.getMaxHP() - Module.this.hp) * 2 / Module.this.getMaxHP()) + 0.05) / (double)this.div * (double)(Module.this.ship.focusOnRepair ? 4 : 1);
        }

        @Override
        public boolean active() {
            return Module.this.hp > 0 && Module.this.hp < Module.this.getMaxRepairToHP() - 20 && Module.this.fire == 0;
        }

        public String toString() {
            return "Repair " + Module.this.type.getName();
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct.doesWork;
        }

        @Override
        public boolean requiredUnoccupied() {
            return Module.this.type.getWater(Module.this.ship.currentBonuses) == 0 && Module.this.type.getCoal(Module.this.ship.currentBonuses) == 0 && Module.this.type.getLift(Module.this.ship.currentBonuses) == 0;
        }
    }
}

