/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.DamagedAppGen;
import com.zarkonnen.airships.ExternalApp;
import com.zarkonnen.airships.FragmentGen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.LightmapBakery;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MonsterHelperWidget;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.SpriteUtils;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.SlickEngine;
import com.zarkonnen.catengine.util.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.newdawn.slick.Image;

public strictfp class Mod {
    public static final ArrayList<Mod> mods = new ArrayList();
    public static ArrayList<String> overriddenEnabledModIds;
    public final boolean isLocal;
    public final File dir;
    public final HashMap<Locale, String> name = new HashMap();
    public final HashMap<Locale, String> description = new HashMap();
    public final ArrayList<String> tags = new ArrayList();
    public String id;
    public Image logo;
    public boolean loadInfoFailed = false;
    public boolean loadFailed = false;
    public String infoLog;
    public String loadLog;
    public String buildLog;
    public boolean buildFailed = false;
    public Mod preemptedBy = null;
    private static final Comparator<Mod> modSorter;
    public static final int GENERATED_DATA_VERSION = 1;
    private long lastChecksumCache;
    private boolean checksumCalculated = false;

    public boolean isPermanentlyEnabled() {
        return AirshipGame.PREFS.getBoolean("mod_enabled_" + this.id.substring(0, StrictMath.min(this.id.length(), 20)), true);
    }

    public void setPermanentlyEnabled(boolean enabled) {
        AirshipGame.PREFS.putBoolean("mod_enabled_" + this.id.substring(0, StrictMath.min(this.id.length(), 20)), enabled);
    }

    public boolean isCurrentlyEnabled() {
        if (this.loadInfoFailed || this.loadFailed || this.preemptedBy != null) {
            return false;
        }
        if (overriddenEnabledModIds != null) {
            return overriddenEnabledModIds.contains(this.id);
        }
        return this.isPermanentlyEnabled();
    }

    public boolean isAvailable() {
        return !this.loadInfoFailed && !this.loadFailed && this.preemptedBy == null;
    }

    public String getWarnings() {
        if (!this.isAvailable()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (TimeOfDay tod : Loadable.all(TimeOfDay.class)) {
            if (tod.sourceMod != this) continue;
            sb.append("Warning: TimeOfDay ").append(tod.name).append(" should specify an appearancePostfix for simple graphics mode. One of ");
            for (String s : TimeOfDay.ORIGINAL_APPEARANCE_POSTFIXES) {
                if (!s.equals(TimeOfDay.ORIGINAL_APPEARANCE_POSTFIXES.get(0))) {
                    sb.append(", ");
                }
                sb.append(s);
            }
            sb.append("\n");
        }
        HashSet<SpritesheetBundle> ssbsToExamine = new HashSet<SpritesheetBundle>();
        for (ModuleType m : Loadable.all(ModuleType.class)) {
            if (m.sourceMod != this) continue;
            ssbsToExamine.add(m.getApp((BonusSet)BonusSet.empty()).spritesheetBundle);
            for (BonusSet b : m.getAppBonuses()) {
                ssbsToExamine.add(m.getApp((BonusSet)b).spritesheetBundle);
            }
            if (m.getExternalApps(BonusSet.empty(), false, false) != null) {
                for (ExternalApp ea : m.getExternalApps(BonusSet.empty(), false, false)) {
                    ssbsToExamine.add(ea.app.spritesheetBundle);
                }
            }
            for (BonusSet b : m.getExternalAppBonuses(false, false)) {
                if (m.getExternalApps(b, false, false) == null) continue;
                for (ExternalApp ea : m.getExternalApps(b, false, false)) {
                    ssbsToExamine.add(ea.app.spritesheetBundle);
                }
            }
            if (m.getExternalApps(BonusSet.empty(), true, false) != null) {
                for (ExternalApp ea : m.getExternalApps(BonusSet.empty(), true, false)) {
                    ssbsToExamine.add(ea.app.spritesheetBundle);
                }
            }
            for (BonusSet b : m.getExternalAppBonuses(true, false)) {
                if (m.getExternalApps(b, true, false) == null) continue;
                for (ExternalApp ea : m.getExternalApps(b, true, false)) {
                    ssbsToExamine.add(ea.app.spritesheetBundle);
                }
            }
            if (m.getExternalApps(BonusSet.empty(), true, true) != null) {
                for (ExternalApp ea : m.getExternalApps(BonusSet.empty(), true, true)) {
                    ssbsToExamine.add(ea.app.spritesheetBundle);
                }
            }
            for (BonusSet b : m.getExternalAppBonuses(true, true)) {
                if (m.getExternalApps(b, true, true) == null) continue;
                for (ExternalApp ea : m.getExternalApps(b, true, true)) {
                    ssbsToExamine.add(ea.app.spritesheetBundle);
                }
            }
        }
        for (ArmourType at : Loadable.all(ArmourType.class)) {
            if (at.sourceMod != this) continue;
            if (at.damagedApps.get(BonusSet.empty()) != null && !at.damagedApps.get(BonusSet.empty()).isEmpty()) {
                ssbsToExamine.add(at.damagedApps.get((BonusSet)BonusSet.empty()).get((int)0).spritesheetBundle);
            }
            for (BonusSet b : at.getAppBonuses()) {
                if (at.damagedApps.get(b) == null || at.damagedApps.get(b).isEmpty()) continue;
                ssbsToExamine.add(at.damagedApps.get((BonusSet)b).get((int)0).spritesheetBundle);
            }
        }
        for (SpritesheetBundle ssb : ssbsToExamine) {
            if (ssb.getDamagedVersion() == null) {
                sb.append("Warning: SpriteSheetBundle ").append(ssb.name).append(" has no damaged sheet.\n");
            }
            if (ssb.getFragmentsSheet() != null) continue;
            sb.append("Warning: SpriteSheetBundle ").append(ssb.name).append(" has no fragments sheet.\n");
        }
        return sb.toString();
    }

    private Mod(File dir, boolean isLocal) {
        this.dir = dir;
        this.isLocal = isLocal;
        this.id = "_" + dir.getName() + "_" + AGame.ANIM_R.nextInt();
        SpriteUtils.ensureTexFilesInGeneratedDirectory(new File(dir, "images"));
    }

    public String getName() {
        return this.name.containsKey(Lang.currentLocale) ? this.name.get(Lang.currentLocale) : (this.name.containsKey(Locale.ENGLISH) ? this.name.get(Locale.ENGLISH) : this.dir.getName());
    }

    public static boolean isLocalPresentWithName(String name) {
        for (Mod m : mods) {
            if (!m.isLocal || !m.getIdeallyEnglishName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getIdeallyEnglishDescription() {
        if (this.description.containsKey(Locale.ENGLISH)) {
            return this.description.get(Locale.ENGLISH);
        }
        if (!this.description.keySet().isEmpty()) {
            return this.description.get(this.description.keySet().iterator().next());
        }
        return "(No description provided.)";
    }

    public String getIdeallyEnglishName() {
        if (this.name.containsKey(Locale.ENGLISH)) {
            return this.name.get(Locale.ENGLISH);
        }
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInfo() {
        StringBuilder log = new StringBuilder();
        log.append("Loading mod from ").append(this.dir.getAbsolutePath()).append("\n");
        try {
            JSONObject info = new JSONObject(FileUtils.readFileToString((File)new File(this.dir, "info.json"), (String)"UTF-8"));
            this.id = info.getString("id");
            if (this.logo == null) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(new File(this.dir, "logo.png"));
                    this.logo = new Image((InputStream)fis, this.id + "-logo", false);
                }
                catch (Exception e) {
                    log.append("Unable to load logo: ").append(e.getMessage()).append("\n");
                    this.logo = null;
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {}
                }
            }
            JSONObject nameO = info.getJSONObject("name");
            for (String k : nameO.keySet()) {
                try {
                    Locale l = Locale.forLanguageTag(k);
                    this.name.put(l, nameO.getString(k));
                }
                catch (Exception e) {
                    log.append("Unknown locale: ").append(k).append("\n");
                }
            }
            JSONObject descO = info.getJSONObject("description");
            for (String k : descO.keySet()) {
                try {
                    Locale l = Locale.forLanguageTag(k);
                    this.description.put(l, descO.getString(k));
                }
                catch (Exception e) {
                    log.append("Unknown locale: ").append(k).append("\n");
                }
            }
            if (info.has("tags")) {
                JSONArray ta = info.getJSONArray("tags");
                for (int i = 0; i < ta.length(); ++i) {
                    this.tags.add(ta.getString(i));
                }
            }
        }
        catch (Exception e) {
            log.append("Unable to read info.json: ").append(e.getMessage()).append("\n");
            this.infoLog = log.toString();
            this.loadInfoFailed = true;
            return;
        }
        this.infoLog = log.toString();
        this.loadInfoFailed = false;
    }

    private void addLoadBases(SlickEngine.MyInput in) {
        in.addLoadBase(new File(this.dir, "images"));
        in.addLoadBase(new File(this.dir, "generated"));
        in.addSoundLoadBase(new File(this.dir, "sounds"));
    }

    private static void refreshMods() {
        ArrayList<Mod> local = new ArrayList<Mod>();
        new File(AGame.getGameDirectory(), "mods").mkdirs();
        File[] fss = new File(AGame.getGameDirectory(), "mods").listFiles();
        if (fss != null) {
            List<File> fs = Arrays.asList(fss);
            Collections.sort(fs);
            block0: for (File f : fs) {
                if (!f.isDirectory() || !new File(f, "info.json").exists()) continue;
                for (Mod m : mods) {
                    if (!m.dir.equals(f)) continue;
                    local.add(m);
                    continue block0;
                }
                local.add(new Mod(f, true));
            }
        }
        Collections.sort(local, modSorter);
        ArrayList<Mod> steam = new ArrayList<Mod>();
        new File(new File(AGame.getGameDirectory(), "steam"), "mods").mkdirs();
        fss = new File(new File(AGame.getGameDirectory(), "steam"), "mods").listFiles();
        if (fss != null) {
            List<File> fs = Arrays.asList(fss);
            Collections.sort(fs);
            block2: for (File outerF : fs) {
                File[] innerFs;
                if (!outerF.isDirectory() || (innerFs = outerF.listFiles()) == null) continue;
                List<File> innerFsA = Arrays.asList(innerFs);
                Collections.sort(innerFsA);
                for (File f : innerFsA) {
                    if (!f.isDirectory() || !new File(f, "info.json").exists()) continue;
                    for (Mod m : mods) {
                        if (!m.dir.equals(f)) continue;
                        steam.add(m);
                        continue block2;
                    }
                    steam.add(new Mod(f, false));
                }
            }
        }
        Collections.sort(steam, modSorter);
        mods.clear();
        mods.addAll(local);
        mods.addAll(steam);
        for (Mod m : mods) {
            m.preemptedBy = null;
            m.loadInfo();
        }
        block6: for (int i = 0; i < mods.size(); ++i) {
            Mod m;
            m = mods.get(i);
            for (int j = 0; j < i; ++j) {
                Mod m2 = mods.get(j);
                if (!m.id.equals(m2.id)) continue;
                m.preemptedBy = m2;
                continue block6;
            }
        }
    }

    public static boolean isAvailable(String id, long checksum) {
        for (Mod m : mods) {
            if (!m.id.equals(id)) continue;
            return m.isAvailable() && m.getCachedChecksum() == checksum;
        }
        return false;
    }

    public static Mod getById(String id) {
        for (Mod m : mods) {
            if (!m.id.equals(id)) continue;
            return m;
        }
        return null;
    }

    public static ArrayList<Mod> getEnabledMods() {
        ArrayList<Mod> l = new ArrayList<Mod>();
        for (Mod m : mods) {
            if (!m.isCurrentlyEnabled()) continue;
            l.add(m);
        }
        return l;
    }

    public static ArrayList<Mod> getAvailableMods() {
        ArrayList<Mod> l = new ArrayList<Mod>();
        for (Mod m : mods) {
            if (!m.isAvailable()) continue;
            l.add(m);
        }
        return l;
    }

    public static void resetLoadBases(SlickEngine.MyInput in) {
        in.clearLoadBases();
        in.clearSoundLoadBases();
        in.addLoadBase(new File(new File(AGame.getStaticGameDirectory(), "data"), "images"));
        in.addSoundLoadBase(new File(new File(AGame.getStaticGameDirectory(), "data"), "sounds"));
    }

    private static boolean doLoadMods(Input in) {
        Mod.resetLoadBases((SlickEngine.MyInput)in);
        for (Mod m : Mod.getEnabledMods()) {
            m.addLoadBases((SlickEngine.MyInput)in);
        }
        boolean success = false;
        while (!Mod.getEnabledMods().isEmpty() && !(success = Loadable.load())) {
            System.out.println(".");
            Mod.resetLoadBases((SlickEngine.MyInput)in);
            for (Mod m : Mod.getEnabledMods()) {
                m.addLoadBases((SlickEngine.MyInput)in);
            }
        }
        if (!success) {
            Mod.resetLoadBases((SlickEngine.MyInput)in);
            for (Mod m : Mod.getEnabledMods()) {
                m.addLoadBases((SlickEngine.MyInput)in);
            }
            success = Loadable.load();
        }
        return success;
    }

    public boolean needsGenerateDerivedData() throws IOException {
        System.out.println(this.id);
        File csF = new File(new File(this.dir, "generated"), "checksum.txt");
        File ssbCSF = new File(new File(this.dir, "generated"), "ssb_checksum.txt");
        if (ssbCSF.exists()) {
            try {
                boolean wrong = Long.parseLong(FileUtils.readFileToString((File)ssbCSF, (String)"UTF-8")) != this.getSSBChecksum2();
                System.out.println("SSB Checksum wrong: " + wrong);
                return wrong;
            }
            catch (Exception e) {
                System.out.println("SSB checksumming failed");
                System.err.println("SSB checksumming failed");
                e.printStackTrace();
                return true;
            }
        }
        if (csF.exists()) {
            try {
                boolean wrong = Long.parseLong(FileUtils.readFileToString((File)csF, (String)"UTF-8")) != this.getChecksum();
                System.out.println("Old Checksum wrong: " + wrong);
                return wrong;
            }
            catch (Exception e) {
                System.out.println("Old checksumming failed");
                System.err.println("Old checksumming failed");
                e.printStackTrace();
                return true;
            }
        }
        System.out.println("No checksum files exist");
        return true;
    }

    public long getCachedChecksum() {
        if (!this.checksumCalculated) {
            try {
                return this.getChecksum();
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return this.lastChecksumCache;
    }

    private long getChecksum() throws IOException {
        long cs = 1L;
        for (File f : this.dir.listFiles()) {
            if (f.getName().startsWith(".") || f.getName().equals("generated")) continue;
            cs += Mod.checksum(f);
        }
        this.lastChecksumCache = cs;
        this.checksumCalculated = true;
        return cs;
    }

    private long getSSBChecksum2() throws IOException {
        File[] fs = new File(this.dir, "SpritesheetBundle").listFiles();
        HashMap<String, R_SpritesheetBundle> ssbsH = new HashMap<String, R_SpritesheetBundle>();
        if (fs != null) {
            List<File> fsL = Arrays.asList(fs);
            Collections.sort(fsL);
            for (File f : fsL) {
                if (!f.getName().endsWith(".json")) continue;
                JSONArray a = new JSONArray(FileUtils.readFileToString((File)f, (String)"UTF-8"));
                for (int i = 0; i < a.length(); ++i) {
                    if (a.getJSONObject(i).optBoolean("remove", false)) continue;
                    ssbsH.put(a.getJSONObject(i).getString("name"), new R_SpritesheetBundle(a.getJSONObject(i)));
                }
            }
        }
        ArrayList ssbsL = new ArrayList();
        ssbsL.addAll(ssbsH.values());
        Collections.sort(ssbsL);
        HashMap<String, R_ModuleType> mtsH = new HashMap<String, R_ModuleType>();
        fs = new File(this.dir, "ModuleType").listFiles();
        if (fs != null) {
            List<File> fsL = Arrays.asList(fs);
            Collections.sort(fsL);
            for (File f : fsL) {
                if (!f.getName().endsWith(".json")) continue;
                JSONArray a = new JSONArray(FileUtils.readFileToString((File)f, (String)"UTF-8"));
                for (int i = 0; i < a.length(); ++i) {
                    if (a.getJSONObject(i).optBoolean("remove", false)) continue;
                    mtsH.put(a.getJSONObject(i).getString("name"), new R_ModuleType(a.getJSONObject(i)));
                }
            }
        }
        ArrayList mtsL = new ArrayList();
        mtsL.addAll(mtsH.values());
        for (R_ModuleType mt : mtsL) {
            if (mt.flippedFrom == null) continue;
            for (R_ModuleType mt2 : mtsL) {
                if (!mt2.name.equals(mt.flippedFrom)) continue;
                mt.deriveFlipped(mt2);
            }
        }
        Collections.sort(mtsL);
        HashMap<String, R_ArmourType> atsH = new HashMap<String, R_ArmourType>();
        fs = new File(this.dir, "ArmourType").listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (!f.getName().endsWith(".json")) continue;
                JSONArray a = new JSONArray(FileUtils.readFileToString((File)f, (String)"UTF-8"));
                for (int i = 0; i < a.length(); ++i) {
                    if (a.getJSONObject(i).optBoolean("remove", false)) continue;
                    atsH.put(a.getJSONObject(i).getString("name"), new R_ArmourType(a.getJSONObject(i)));
                }
            }
        }
        ArrayList atsL = new ArrayList();
        atsL.addAll(atsH.values());
        Collections.sort(atsL);
        long cs = 0L;
        for (R_SpritesheetBundle ssb : ssbsL) {
            cs *= 677L;
            cs += Mod.checksum(new File(new File(this.dir, "images"), ssb.name + ".png"));
            if (ssb.bump != null) {
                cs *= 73L;
                cs += Mod.checksum(new File(new File(this.dir, "images"), ssb.bump + ".png"));
            }
            if (ssb.fragments == null) continue;
            cs *= 73L;
            cs += Mod.checksum(new File(new File(this.dir, "images"), ssb.fragments + ".png"));
            for (R_ModuleType mt : mtsL) {
                if (mt.app.spritesheetBundle.equals(ssb.name)) {
                    cs += mt.app.checksum();
                }
                for (D_ExternalApp ea : mt.externalApps) {
                    if (!ea.app.spritesheetBundle.equals(ssb.name)) continue;
                    cs *= 41L;
                    cs += ea.app.checksum();
                }
                for (D_LegSpec ls : mt.legSpecs) {
                    if (ls.upperLeg.src.equals(ssb.name)) {
                        cs *= 31L;
                        cs += Mod.checksum(ls.upperLeg);
                    }
                    if (ls.lowerLeg.src.equals(ssb.name)) {
                        cs *= 31L;
                        cs += Mod.checksum(ls.lowerLeg);
                    }
                    if (ls.foot == null || !ls.foot.src.equals(ssb.name)) continue;
                    cs *= 31L;
                    cs += Mod.checksum(ls.foot);
                }
                for (D_WheelSpec ws : mt.wheelSpecs) {
                    if (ws.wheel.src.equals(ssb.name)) {
                        cs *= 19L;
                        cs += Mod.checksum(ws.wheel);
                    }
                    if (ws.upperLink.src.equals(ssb.name)) {
                        cs *= 19L;
                        cs += Mod.checksum(ws.upperLink);
                    }
                    if (!ws.lowerLink.src.equals(ssb.name)) continue;
                    cs *= 19L;
                    cs += Mod.checksum(ws.lowerLink);
                }
            }
            for (R_ArmourType at : atsL) {
                cs *= 73L;
                for (D_App app : at.damagedApps) {
                    if (!app.spritesheetBundle.equals(ssb.name)) continue;
                    cs *= 17L;
                    cs += app.checksum();
                }
            }
        }
        return cs;
    }

    public static long checksum(Img img) {
        return img.srcX + 41 * img.srcY + 199 * img.srcWidth + 701 * img.srcHeight;
    }

    public static long checksum(File f) throws IOException {
        if (f.isDirectory()) {
            long cs = 0L;
            for (File child : f.listFiles()) {
                if (child.getName().startsWith(".")) continue;
                cs += Mod.checksum(child);
            }
            System.out.println(f.getPath() + " " + cs);
            return cs;
        }
        System.out.println(f.getPath() + " " + FileUtils.checksumCRC32((File)f));
        return FileUtils.checksumCRC32((File)f);
    }

    public void regenerateDerivedData(Input in) {
        this.generateDerivedData(in);
        Mod.resetLoadBases((SlickEngine.MyInput)in);
        for (Mod m : Mod.getEnabledMods()) {
            m.addLoadBases((SlickEngine.MyInput)in);
        }
        Loadable.load();
        Lang.reloadBundle();
        ShipHelperWidget.clearAllCaches();
        MonsterHelperWidget.clearAllCaches();
        Appearance.reloadSpritesheets();
    }

    private void generateDerivedData(Input in) {
        ArrayList<String> originalOEMIs = overriddenEnabledModIds;
        overriddenEnabledModIds = new ArrayList();
        overriddenEnabledModIds.add(this.id);
        Mod.resetLoadBases((SlickEngine.MyInput)in);
        Loadable.load();
        this.addLoadBases((SlickEngine.MyInput)in);
        ArrayList<String> log = this.doGenerateDerivedData();
        StringBuilder sb = new StringBuilder();
        for (String s : log) {
            sb.append(s).append("\n");
        }
        this.buildLog = sb.toString();
        overriddenEnabledModIds = originalOEMIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> doGenerateDerivedData() {
        this.buildFailed = false;
        ArrayList<String> log = new ArrayList<String>();
        try {
            log.add("Generating derived data for mod " + this.id + ".");
            String mapping = "";
            File genF = new File(this.dir, "generated");
            genF.mkdirs();
            for (SpritesheetBundle ssb : Loadable.all(SpritesheetBundle.class)) {
                if (ssb.sourceMod != this) continue;
                AirshipGame.instance.tickClients();
                log.add("Spritesheet Bundle " + ssb.name + ".");
                if (ssb.bump != null) {
                    log.add("Baking light maps.");
                    for (TimeOfDay tod : Loadable.all(TimeOfDay.class)) {
                        ImageIO.write((RenderedImage)LightmapBakery.bake(ssb.name, ssb.bump, tod), "PNG", new File(genF, ssb.name + tod.name + ".png"));
                    }
                    ImageIO.write((RenderedImage)LightmapBakery.bakeBlueprint(ssb.name), "PNG", new File(genF, ssb.name + "BLUEPRINT" + ".png"));
                }
                if (ssb.bump == null || ssb.fragments == null) continue;
                log.add("Generating fragments.");
                FragmentGen.FragmentInfo fi = FragmentGen.generate(ssb);
                ImageIO.write((RenderedImage)fi.sheet, "PNG", new File(genF, ssb.name + "FRAGMENTS.png"));
                ImageIO.write((RenderedImage)fi.bump, "PNG", new File(genF, ssb.bump + "FRAGMENTS.png"));
                mapping = mapping + fi.mapping;
                log.add("Generating damaged variant.");
                Utils.Pair<BufferedImage, BufferedImage> p = DamagedAppGen.generate(ssb.name, ssb.bump, ssb.fragments);
                ImageIO.write((RenderedImage)p.a, "PNG", new File(genF, ssb.name + "DAMAGED.png"));
                ImageIO.write((RenderedImage)p.b, "PNG", new File(genF, ssb.bump + "DAMAGED.png"));
                log.add("Baking damaged variants.");
                for (TimeOfDay tod : Loadable.all(TimeOfDay.class)) {
                    ImageIO.write((RenderedImage)LightmapBakery.bake((BufferedImage)p.a, (BufferedImage)p.b, tod), "PNG", new File(genF, ssb.name + "DAMAGED" + tod.name + ".png"));
                }
            }
            log.add("Writing out fragment mapping.");
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(genF, "fragments.txt")), "UTF-8"));){
                bw.write(mapping);
            }
            log.add("Writing out SSB checksum.");
            FileUtils.write((File)new File(genF, "ssb_checksum.txt"), (CharSequence)("" + this.getSSBChecksum2()), (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loadFailed = true;
            this.buildFailed = true;
            log.add("Failure: " + e.getMessage());
        }
        return log;
    }

    static {
        modSorter = new Comparator<Mod>(){

            @Override
            public int compare(Mod t, Mod t1) {
                return t.dir.getName().compareTo(t1.dir.getName());
            }
        };
    }

    private strictfp static class R_ArmourType
    extends R_ {
        public final ArrayList<D_App> damagedApps = new ArrayList();

        public R_ArmourType(JSONObject o) {
            super(o.getString("name"), o.optInt("sort", 0));
            JSONArray a = o.getJSONArray("damagedApps");
            for (int i = 0; i < a.length(); ++i) {
                this.damagedApps.add(new D_App(a.getJSONObject(i)));
            }
        }
    }

    private strictfp static class R_ModuleType
    extends R_ {
        public String flippedFrom;
        public D_App app;
        public int w;
        public ArrayList<D_ExternalApp> externalApps = new ArrayList();
        public ArrayList<D_LegSpec> legSpecs = new ArrayList();
        public ArrayList<D_WheelSpec> wheelSpecs = new ArrayList();

        public void deriveFlipped(R_ModuleType b) {
            this.app = b.app.flip();
            for (D_ExternalApp ea : b.externalApps) {
                int fromRight = b.w - ea.app.w - ea.dx;
                this.externalApps.add(new D_ExternalApp(ea.app.flip(), fromRight, ea.dy));
            }
        }

        public R_ModuleType(JSONObject o) {
            super(o.getString("name"), o.optInt("sort", 0));
            int i;
            if (o.has("flippedFrom")) {
                this.flippedFrom = o.getString("flippedFrom");
                return;
            }
            this.w = o.getInt("w");
            this.app = new D_App(o.getJSONObject("appearance"));
            if (o.has("externalAppearances")) {
                JSONArray eas = o.getJSONArray("externalAppearances");
                for (i = 0; i < eas.length(); ++i) {
                    JSONObject ea = eas.getJSONObject(i);
                    this.externalApps.add(new D_ExternalApp(new D_App(ea.getJSONObject("appearance")), ea.getInt("x"), ea.getInt("y")));
                }
            }
            if (o.has("wheels")) {
                JSONArray ws = o.getJSONArray("wheels");
                for (i = 0; i < ws.length(); ++i) {
                    JSONObject wh = ws.getJSONObject(i);
                    this.wheelSpecs.add(new D_WheelSpec(wh));
                }
            }
            if (o.has("legs")) {
                JSONArray ls = o.getJSONArray("legs");
                for (i = 0; i < ls.length(); ++i) {
                    JSONObject l = ls.getJSONObject(i);
                    this.legSpecs.add(new D_LegSpec(l));
                }
            }
        }
    }

    private strictfp static class R_SpritesheetBundle
    extends R_ {
        public final String bump;
        public final String fragments;

        public R_SpritesheetBundle(JSONObject o) {
            super(o.getString("name"), o.optInt("sort", 0));
            this.bump = o.optString("bump", null);
            this.fragments = o.optString("fragments", null);
        }
    }

    private strictfp static class R_
    implements Comparable<R_> {
        public final String name;
        public final int sort;

        public R_(String name, int sort) {
            this.name = name;
            this.sort = sort;
        }

        @Override
        public int compareTo(R_ l2) {
            if (this.sort == l2.sort) {
                return this.name.compareTo(l2.name);
            }
            return this.sort - l2.sort;
        }
    }

    private strictfp static class D_LegSpec {
        public final Img upperLeg;
        public final Img lowerLeg;
        public final Img foot;

        public D_LegSpec(JSONObject o) {
            this.upperLeg = Loadable.img(o.getJSONObject("upperLeg"));
            this.lowerLeg = Loadable.img(o.getJSONObject("lowerLeg"));
            this.foot = Loadable.img(o.getJSONObject("foot"));
        }
    }

    private strictfp static class D_WheelSpec {
        public final Img wheel;
        public final Img upperLink;
        public final Img lowerLink;

        public D_WheelSpec(JSONObject o) {
            this.wheel = Loadable.img(o.getJSONObject("wheel"));
            this.upperLink = Loadable.img(o.getJSONObject("upperLink"));
            this.lowerLink = Loadable.img(o.getJSONObject("lowerLink"));
        }
    }

    private strictfp static class D_ExternalApp {
        public final D_App app;
        public final int dx;
        public final int dy;

        public D_ExternalApp(D_App app, int dx, int dy) {
            this.app = app;
            this.dx = dx;
            this.dy = dy;
        }
    }

    private strictfp static class D_App {
        public final String spritesheetBundle;
        public final ArrayList<Img> frames = new ArrayList();
        public final int interval;
        public int w;
        public int h;

        public D_App(JSONObject o) {
            this.spritesheetBundle = o.getString("src");
            if (o.has("x")) {
                this.frame(o.getInt("x"), o.getInt("y"), o.optInt("w", 1), o.optInt("h", 1), o.optBoolean("flipped", false));
            } else {
                JSONArray framesA = o.getJSONArray("frames");
                for (int i = 0; i < framesA.length(); ++i) {
                    JSONObject f = framesA.getJSONObject(i);
                    this.frame(f.getInt("x"), f.getInt("y"), f.optInt("w", 1), f.optInt("h", 1), f.optBoolean("flipped", false));
                }
            }
            this.interval = o.optInt("interval", 300) <= 0 ? 300 : o.optInt("interval", 300);
        }

        private D_App flip() {
            return this;
        }

        private void frame(int x, int y, int w, int h, boolean flipped) {
            Img f = new Img(this.spritesheetBundle, x * 16, y * 16, w * 16, h * 16, flipped);
            this.frames.add(f);
            this.w = StrictMath.max(this.w, w);
            this.h = StrictMath.max(this.h, h);
        }

        private long checksum() {
            int cs = this.spritesheetBundle.hashCode();
            for (Img img : this.frames) {
                cs += img.src.hashCode() * 7 + img.srcX * 37 + img.srcY * 193 + img.srcWidth * 401 + img.srcHeight * 1299;
                cs *= 19;
            }
            return cs += this.interval;
        }
    }

    public strictfp static class LoadProcess {
        private boolean inited = false;
        private boolean initialLoadComplete = false;
        private boolean toGenerateFound = false;
        private final ArrayList<Mod> toGenerate = new ArrayList();
        private int generateIndex = 0;
        private boolean needReload = false;
        public boolean disableAllMods = false;

        public LoadProgress doLoad(Input in) {
            if (!this.inited) {
                this.inited = true;
                return new LoadProgress(false, false, 0, 100, Lang._t("Loading_game_data_", new Object[0]));
            }
            if (!this.initialLoadComplete) {
                this.initialLoadComplete = true;
                Mod.refreshMods();
                if (this.disableAllMods) {
                    for (Mod mod : mods) {
                        mod.setPermanentlyEnabled(false);
                    }
                }
                for (Mod m : mods) {
                    m.loadFailed = false;
                }
                if (Mod.doLoadMods(in)) {
                    Lang.reloadBundle();
                    ShipHelperWidget.clearAllCaches();
                    MonsterHelperWidget.clearAllCaches();
                    Appearance.reloadSpritesheets();
                    return new LoadProgress(false, false, 1, 2 + mods.size(), Lang._t("Checking_mods", new Object[0]));
                }
                AirshipGame.instance.doLowMemoryCheck();
                return new LoadProgress(true, true, 1, 1, Lang._t("Loading_game_data_failed", new Object[0]));
            }
            if (!this.toGenerateFound) {
                this.toGenerateFound = true;
                for (Mod m : Mod.getEnabledMods()) {
                    try {
                        if (!m.needsGenerateDerivedData()) continue;
                        this.toGenerate.add(m);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        m.loadFailed = true;
                        this.needReload = true;
                    }
                }
                if (!this.toGenerate.isEmpty()) {
                    this.needReload = true;
                    return new LoadProgress(false, false, 2, 3 + this.toGenerate.size(), Lang._t("Generating_graphics_for_x", this.toGenerate.get((int)0).id));
                }
                if (this.needReload) {
                    return new LoadProgress(false, false, 2, 3, Lang._t("Loading_game_data_", new Object[0]));
                }
                Lang.reloadBundle();
                ShipHelperWidget.clearAllCaches();
                MonsterHelperWidget.clearAllCaches();
                Appearance.reloadSpritesheets();
                AirshipGame.instance.doLowMemoryCheck();
                return new LoadProgress(true, false, 2, 2, Lang._t("Loading_game_data_complete", new Object[0]));
            }
            if (this.generateIndex < this.toGenerate.size()) {
                this.toGenerate.get(this.generateIndex).generateDerivedData(in);
                ++this.generateIndex;
                if (this.generateIndex >= this.toGenerate.size()) {
                    return new LoadProgress(false, false, 2 + this.toGenerate.size(), 4 + this.toGenerate.size(), Lang._t("Loading_game_data_", new Object[0]));
                }
                return new LoadProgress(false, false, 2 + this.generateIndex, 4 + this.toGenerate.size(), Lang._t("Generating_graphics_for_x", this.toGenerate.get((int)this.generateIndex).id));
            }
            if (this.needReload) {
                this.needReload = false;
                if (Mod.doLoadMods(in)) {
                    return new LoadProgress(false, false, 3 + this.toGenerate.size(), 4 + this.toGenerate.size(), Lang._t("Loading_game_data_", new Object[0]));
                }
                AirshipGame.instance.doLowMemoryCheck();
                return new LoadProgress(true, true, 1, 1, Lang._t("Loading_game_data_failed", new Object[0]));
            }
            Lang.reloadBundle();
            ShipHelperWidget.clearAllCaches();
            MonsterHelperWidget.clearAllCaches();
            Appearance.reloadSpritesheets();
            AirshipGame.instance.doLowMemoryCheck();
            return new LoadProgress(true, false, 4 + this.toGenerate.size(), 4 + this.toGenerate.size(), Lang._t("Loading_game_data_complete", new Object[0]));
        }
    }

    public strictfp static class LoadProgress {
        public final boolean complete;
        public final boolean failed;
        public final int progress;
        public final int totalSteps;
        public final String desc;

        public LoadProgress(boolean complete, boolean failed, int progress, int totalSteps, String desc) {
            this.complete = complete;
            this.failed = failed;
            this.progress = progress;
            this.totalSteps = totalSteps;
            this.desc = desc;
        }

        public String toString() {
            return (this.complete ? "C" : "") + (this.failed ? "F" : "") + " " + this.progress + "/" + this.totalSteps + " " + this.desc;
        }
    }
}

