/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.HeraldicStyle;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.MyDraw;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class MissionSequence {
    public static final String UGC_PREFIX = "MISSIONSEQ";
    public static final String HEADER_FILE = "missions_info.json";
    public boolean isLocal;
    public File dir;
    public boolean playableHeader = true;
    public final HashMap<Locale, String> name = new HashMap();
    public final HashMap<Locale, String> description = new HashMap();
    public final ArrayList<String> tags = new ArrayList();
    public final ArrayList<String> modIDs = new ArrayList();
    public final ArrayList<Mission> missions = new ArrayList();
    public boolean loaded;
    public Exception loadError;

    public MissionSequence(boolean isLocal, File dir) {
        this.isLocal = isLocal;
        this.dir = dir;
    }

    public void saveTo(File dir) throws IOException {
        this.isLocal = true;
        this.dir = dir;
        this.save();
    }

    public boolean requiresModReload() {
        ArrayList<String> enabledModIDs = new ArrayList<String>();
        for (Mod m : Mod.getEnabledMods()) {
            enabledModIDs.add(m.id);
        }
        return !this.modIDs.containsAll(enabledModIDs) || !enabledModIDs.containsAll(this.modIDs);
    }

    public boolean modsAreAvailable() {
        for (String id : this.modIDs) {
            Mod m = Mod.getById(id);
            if (m != null && m.isAvailable()) continue;
            return false;
        }
        return true;
    }

    public void save() throws IOException {
        JSONObject o = new JSONObject();
        JSONObject nameO = new JSONObject();
        o.put("playableHeader", this.playableHeader);
        o.put("name", nameO);
        for (Locale l : this.name.keySet()) {
            nameO.put(l.toLanguageTag(), this.name.get(l));
        }
        JSONObject descO = new JSONObject();
        o.put("description", descO);
        for (Locale l : this.description.keySet()) {
            descO.put(l.toLanguageTag(), this.description.get(l));
        }
        JSONArray a = new JSONArray();
        for (String t : this.tags) {
            a.put(t);
        }
        o.put("tags", a);
        a = new JSONArray();
        for (String id : this.modIDs) {
            a.put(id);
        }
        o.put("modIDs", a);
        o.put("numMissions", this.missions.size());
        FileUtils.writeStringToFile((File)new File(this.dir, HEADER_FILE), (String)o.toString(4), (String)"UTF-8");
        int i = 0;
        for (Mission m : this.missions) {
            m.saveTo(new File(this.dir, "mission_" + i + "_meta.json"), new File(this.dir, "mission_" + i + "_combat.json"));
            ++i;
        }
    }

    public boolean loadMetadata() {
        try {
            JSONObject o = new JSONObject(FileUtils.readFileToString((File)new File(this.dir, HEADER_FILE), (String)"UTF-8"));
            this.playableHeader = o.optBoolean("playableHeader", true);
            this.name.clear();
            JSONObject nameO = o.getJSONObject("name");
            for (String k : nameO.keySet()) {
                try {
                    Locale l = Locale.forLanguageTag(k);
                    this.name.put(l, nameO.getString(k));
                }
                catch (Exception l) {}
            }
            this.description.clear();
            JSONObject descriptionO = o.getJSONObject("description");
            for (String k : descriptionO.keySet()) {
                try {
                    Locale l = Locale.forLanguageTag(k);
                    this.description.put(l, descriptionO.getString(k));
                }
                catch (Exception l) {}
            }
            this.tags.clear();
            JSONArray tagsA = o.getJSONArray("tags");
            for (int i = 0; i < tagsA.length(); ++i) {
                this.tags.add(tagsA.getString(i));
            }
            this.modIDs.clear();
            JSONArray modsIDsA = o.getJSONArray("modIDs");
            for (int i = 0; i < modsIDsA.length(); ++i) {
                this.modIDs.add(modsIDsA.getString(i));
            }
            int numMissions = o.getInt("numMissions");
            this.missions.clear();
            for (int i = 0; i < numMissions; ++i) {
                this.missions.add(new Mission(new File(this.dir, "mission_" + i + "_meta.json"), new File(this.dir, "mission_" + i + "_combat.json")));
            }
            this.loaded = true;
            this.loadError = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loadError = e;
            this.loaded = false;
        }
        return this.loaded;
    }

    public String getIdeallyEnglishName() {
        if (this.name.containsKey(Locale.ENGLISH)) {
            return this.name.get(Locale.ENGLISH);
        }
        if (!this.name.isEmpty()) {
            ArrayList<Locale> ls = new ArrayList<Locale>(this.name.keySet());
            Collections.sort(ls, new Comparator<Locale>(){

                @Override
                public int compare(Locale t, Locale t1) {
                    return t.toLanguageTag().compareTo(t1.toLanguageTag());
                }
            });
            return this.name.get(ls.get(0));
        }
        return this.dir.getName();
    }

    public String getIdeallyEnglishDescription() {
        if (this.description.containsKey(Locale.ENGLISH)) {
            return this.description.get(Locale.ENGLISH);
        }
        if (!this.description.isEmpty()) {
            ArrayList<Locale> ls = new ArrayList<Locale>(this.description.keySet());
            Collections.sort(ls, new Comparator<Locale>(){

                @Override
                public int compare(Locale t, Locale t1) {
                    return t.toLanguageTag().compareTo(t1.toLanguageTag());
                }
            });
            return this.description.get(ls.get(0));
        }
        return "";
    }

    public String getIdeallyEnglishDescriptionAndMods() {
        StringBuilder sb = new StringBuilder(this.getIdeallyEnglishDescription());
        if (!this.modIDs.isEmpty()) {
            sb.append("\n\n").append(Lang._t("Mods", new Object[0])).append(": ");
            boolean first = true;
            for (String id : this.modIDs) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                Mod m = Mod.getById(id);
                if (m == null) {
                    sb.append(MyDraw.ERROR_C).append(id).append("[]");
                    continue;
                }
                sb.append(m.getName());
            }
        }
        return sb.toString();
    }

    public String getName() {
        return this.name.containsKey(Lang.currentLocale) ? this.name.get(Lang.currentLocale) : (this.name.containsKey(Locale.ENGLISH) ? this.name.get(Locale.ENGLISH) : this.dir.getName());
    }

    public String getDescription() {
        return this.description.containsKey(Lang.currentLocale) ? this.description.get(Lang.currentLocale) : (this.description.containsKey(Locale.ENGLISH) ? this.description.get(Locale.ENGLISH) : "");
    }

    public String getDescriptionAndMods() {
        StringBuilder sb = new StringBuilder(this.getDescription());
        if (!this.modIDs.isEmpty()) {
            sb.append("\n\n").append(Lang._t("Mods", new Object[0])).append(": ");
            boolean first = true;
            for (String id : this.modIDs) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                Mod m = Mod.getById(id);
                if (m == null) {
                    sb.append(MyDraw.ERROR_C).append(id).append("[]");
                    continue;
                }
                sb.append(m.getName());
            }
        }
        if (!this.playableHeader) {
            sb.append("\t\t").append(MyDraw.ERROR_C).append(Lang._t("Mission_not_playable_incomplete", new Object[0])).append("[]");
        }
        return sb.toString();
    }

    public static class Mission {
        public File metaF;
        public File combatF;
        public Combat combat;
        public final EnumMap<TextSlot, HashMap<Locale, String>> texts = new EnumMap(TextSlot.class);
        public int playerSideIndex = 0;
        public int playerBudget = 0;
        public AIQuality enemyAIQuality = AIQuality.NORMAL;
        public CoatOfArms[] sideArms = new CoatOfArms[]{CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("city")), CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("city"))};
        public boolean metaLoaded;
        public Exception metaLoadError;
        public boolean combatLoaded;
        public Exception combatLoadError;

        public String getText(TextSlot textSlot) {
            HashMap<Locale, String> m = this.texts.get((Object)textSlot);
            return m.containsKey(Lang.currentLocale) ? m.get(Lang.currentLocale) : (m.containsKey(Locale.ENGLISH) ? m.get(Locale.ENGLISH) : "");
        }

        public Mission() {
            for (TextSlot ts : TextSlot.values()) {
                this.texts.put(ts, new HashMap());
            }
        }

        public Mission(File metaF, File combatF) {
            this();
            this.metaF = metaF;
            this.combatF = combatF;
        }

        public void saveTo(File metaF, File combatF) throws IOException {
            this.metaF = metaF;
            this.combatF = combatF;
            this.save();
        }

        public void save() throws IOException {
            JSONObject o = new JSONObject();
            o.put("playerSideIndex", this.playerSideIndex);
            o.put("playerBudget", this.playerBudget);
            o.put("enemyAIQuality", this.enemyAIQuality.name());
            JSONArray sideAs = new JSONArray();
            o.put("sideArms", sideAs);
            for (CoatOfArms coatOfArms : this.sideArms) {
                sideAs.put(coatOfArms.toJSON());
            }
            for (TextSlot textSlot : TextSlot.values()) {
                HashMap<Locale, String> mapping = this.texts.get((Object)textSlot);
                JSONObject to = new JSONObject();
                o.put(textSlot.name(), to);
                for (Locale l : mapping.keySet()) {
                    to.put(l.toLanguageTag(), mapping.get(l));
                }
            }
            FileUtils.writeStringToFile((File)this.metaF, (String)o.toString(4), (String)"UTF-8");
            FileUtils.writeStringToFile((File)this.combatF, (String)this.combat.toJSON().toString(), (String)"UTF-8");
        }

        public boolean loadMetadata() {
            try {
                JSONObject o = new JSONObject(FileUtils.readFileToString((File)this.metaF, (String)"UTF-8"));
                this.playerSideIndex = o.getInt("playerSideIndex");
                this.playerBudget = o.getInt("playerBudget");
                this.enemyAIQuality = AIQuality.valueOf(o.getString("enemyAIQuality"));
                JSONArray sideAs = o.getJSONArray("sideArms");
                this.sideArms = new CoatOfArms[sideAs.length()];
                for (int i = 0; i < sideAs.length(); ++i) {
                    this.sideArms[i] = new CoatOfArms(sideAs.getJSONObject(i));
                }
                for (TextSlot ts : TextSlot.values()) {
                    this.texts.get((Object)ts).clear();
                    JSONObject to = o.getJSONObject(ts.name());
                    for (String k : to.keySet()) {
                        try {
                            Locale l = Locale.forLanguageTag(k);
                            this.texts.get((Object)ts).put(l, to.getString(k));
                        }
                        catch (Exception exception) {}
                    }
                }
                this.metaLoaded = true;
                this.metaLoadError = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.metaLoaded = false;
                this.metaLoadError = e;
            }
            return this.metaLoaded;
        }

        public boolean loadCombat(AirshipGame g) {
            try {
                this.combat = new Combat(g, new JSONObject(FileUtils.readFileToString((File)this.combatF, (String)"UTF-8")));
                this.combatLoaded = true;
                this.combatLoadError = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.combatLoaded = false;
                this.combatLoadError = e;
            }
            return this.combatLoaded;
        }

        public static enum TextSlot {
            intro,
            victory,
            defeat;

        }
    }
}

