/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Mod;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public strictfp class MissionBackend
implements FileScreen.Backend {
    private final AirshipGame g;
    private final File staticF;
    private final File normalF;
    private final File ugcF;
    private final ArrayList<FileScreen.Sorter> sorters = new ArrayList();
    public final boolean localOnly;

    public MissionBackend(AirshipGame g, boolean localOnly) {
        this.g = g;
        this.staticF = new File(new File(AGame.getStaticGameDirectory(), "data"), "missions");
        this.normalF = new File(AGame.getGameDirectory(), "missions");
        this.ugcF = new File(new File(AGame.getGameDirectory(), "steam"), "missions");
        this.sorters.add(new NameSorter());
        this.localOnly = localOnly;
    }

    @Override
    public String saveSuffix() {
        return "";
    }

    @Override
    public boolean canCreateDirs() {
        return false;
    }

    public boolean isLocal(List<String> path) {
        return path.isEmpty() || !path.get(0).contains(":");
    }

    public static boolean isMission(File f, boolean expectedToBeWrapped) {
        if (expectedToBeWrapped) {
            return MissionBackend.findWrappedMissionDir(f) != null;
        }
        return new File(f, "missions_info.json").exists();
    }

    public static File findWrappedMissionDir(File outerDir) {
        File[] fs = outerDir.listFiles();
        if (fs != null) {
            for (File sub : fs) {
                if (!new File(sub, "missions_info.json").exists()) continue;
                return sub;
            }
        }
        return null;
    }

    @Override
    public boolean isValidName(String name) {
        return !name.isEmpty() && AGame.makeFileSafe(name).equals(name);
    }

    @Override
    public ArrayList<FileScreen.Sorter> sorters() {
        return this.sorters;
    }

    @Override
    public ArrayList<FileScreen.SettableFilter> filters() {
        return new ArrayList<FileScreen.SettableFilter>();
    }

    @Override
    public File getRawFile(List<String> path) {
        File f;
        if (path.isEmpty()) {
            return null;
        }
        if (path.get(0).equals("Steam:")) {
            f = this.ugcF;
        } else if (path.get(0).equals("Static:")) {
            f = this.staticF;
        } else if (path.get(0).endsWith(":")) {
            String modID = path.get(0).substring(0, path.get(0).length() - 1);
            Mod inMod = null;
            for (Mod m : Mod.getEnabledMods()) {
                if (!m.id.equals(modID)) continue;
                inMod = m;
                break;
            }
            if (inMod == null) {
                return null;
            }
            f = new File(inMod.dir, "missions");
        } else {
            f = new File(this.normalF, path.get(0));
        }
        for (int i = 1; i < path.size(); ++i) {
            f = new File(f, path.get(i));
        }
        return f;
    }

    @Override
    public File getFile(List<String> path) {
        File f = this.getRawFile(path);
        if (f == null) {
            return null;
        }
        if (new File(f, "missions_info.json").exists()) {
            return f;
        }
        return MissionBackend.findWrappedMissionDir(f);
    }

    @Override
    public List<String> list(List<String> dirPath) {
        ArrayList<String> l = new ArrayList<String>();
        File[] fs = this.staticF.listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (!MissionBackend.isMission(f, false)) continue;
                l.add("Static:/" + f.getName());
            }
        }
        if ((fs = this.normalF.listFiles()) != null) {
            for (File f : fs) {
                if (!MissionBackend.isMission(f, false)) continue;
                l.add(f.getName());
            }
        }
        if (!this.localOnly) {
            fs = this.ugcF.listFiles();
            if (fs != null) {
                for (File f : fs) {
                    if (!MissionBackend.isMission(f, true)) continue;
                    l.add("Steam:/" + f.getName());
                }
            }
            for (Mod m : Mod.getEnabledMods()) {
                File missionsDir = new File(m.dir, "missions");
                fs = missionsDir.listFiles();
                if (fs == null) continue;
                for (File f : fs) {
                    if (!MissionBackend.isMission(f, false)) continue;
                    l.add(m.id + ":/" + f.getName());
                }
            }
        }
        return l;
    }

    @Override
    public boolean isLocked(List<String> path) {
        return !path.isEmpty() && path.get(0).endsWith(":");
    }

    @Override
    public void delete(List<String> path) {
        if (this.isLocked(path)) {
            return;
        }
        File f = this.getRawFile(path);
        if (f == null || !f.exists()) {
            return;
        }
        AGame.deleteDir(f);
    }

    @Override
    public boolean isDirectory(List<String> path) {
        return path.isEmpty();
    }

    private strictfp class NameSorter
    implements FileScreen.Sorter {
        private final Comparator<String> asc = new Comparator<String>(){

            @Override
            public int compare(String t, String t1) {
                return NameSorter.this.normalizeName(t).compareToIgnoreCase(NameSorter.this.normalizeName(t1));
            }
        };
        private final Comparator<String> desc = new Comparator<String>(){

            @Override
            public int compare(String t, String t1) {
                return NameSorter.this.normalizeName(t1).compareToIgnoreCase(NameSorter.this.normalizeName(t));
            }
        };

        private NameSorter() {
        }

        @Override
        public String getNameKey() {
            return "Name";
        }

        private String normalizeName(String filename) {
            return filename;
        }

        @Override
        public Comparator<String> ascending() {
            return this.asc;
        }

        @Override
        public Comparator<String> descending() {
            return this.desc;
        }

        @Override
        public boolean popUpdateNeeded() {
            return false;
        }
    }
}

