/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.ChannelInfo;
import com.zarkonnen.airships.ChatAdapter;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.DateInfo;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.HostOrJoinGameScreen;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.ModReloadProgressDialog;
import com.zarkonnen.airships.ModsAdapter;
import com.zarkonnen.airships.MultiplayerSetupIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlayerAdapter;
import com.zarkonnen.airships.PlayerInfo;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.ResumeConquestMission;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.Server;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.StrategicLobbyScreen;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class MetaLobbyScreen
implements Screen {
    public static final Clr ALT = new Clr(44, 44, 44);
    private final AirshipGame g;
    private final Server server;
    private int joining = 0;
    private JSONObject joiningData;
    private final TextField chatField = new TextField();
    private String error;
    private boolean leaveAfterErrorDismiss;
    private boolean setupDialog;
    private boolean conquestSetupDialog;
    private final TextField gameNameField = new TextField();
    private static int gameLimit = 2000;
    private static boolean oneShipOnly = false;
    private static boolean instantCommandRegeneration = false;
    private static final EnumSet<ShipType> allowedTypes = EnumSet.of(ShipType.AIRSHIP, ShipType.LANDSHIP);
    private static int techTier = 100000;
    private ArrayList<Mod> availableMods;
    private static final ArrayList<Mod> enabledMods = new ArrayList();
    private final ModsAdapter modsAdapter = new ModsAdapter(enabledMods);
    private final ScrollBar modsSB = new ScrollBar();
    private Rect2D modsSBRect = null;
    private int gameRefreshTimer = 0;
    public static final int GAME_REFRESH_INTERVAL = 3000;
    private final ScrollBar channelScrollBar = new ScrollBar();
    private final ScrollBar chatScrollBar = new ScrollBar();
    private final ScrollBar playerScrollBar = new ScrollBar();
    private ModReloadProgressDialog mrpd;
    private String gameName;
    private int gameCostLimit;
    private boolean gameOneShipOnly;
    private boolean unableToLoadCorrectMods;
    private EnumSet<ShipType> gameAllowedTypes;
    private int gameTechTier;
    private boolean gameInstantCommandRegeneration;
    private final ChannelAdapter channelAdapter = new ChannelAdapter();
    private final ChatAdapter chatAdapter = new ChatAdapter();
    private final PlayerAdapter playerAdapter = new PlayerAdapter();

    public MetaLobbyScreen(AirshipGame g, Server server) {
        this.g = g;
        this.server = server;
        this.resetMods();
        this.chatScrollBar.offset = 100000;
        this.availableMods = Mod.getAvailableMods();
        Iterator<Mod> it = enabledMods.iterator();
        while (it.hasNext()) {
            if (this.availableMods.contains(it.next())) continue;
            it.remove();
        }
    }

    private void resetMods() {
        if (Mod.overriddenEnabledModIds != null) {
            Mod.overriddenEnabledModIds = null;
            this.mrpd = new ModReloadProgressDialog(null, new Runnable(){

                @Override
                public void run() {
                    MetaLobbyScreen.this.g.showError(Lang._t("Unable_to_reset_mods", new Object[0]));
                    MetaLobbyScreen.this.leave();
                }
            });
        }
    }

    private void refreshChannels() {
        this.g.sendMessage(Client.msg("listChannels"));
    }

    private boolean pollMessageAndProcess(Input in) {
        JSONObject msg = this.g.pollMessage();
        if (msg != null) {
            if (msg.get("type").equals("welcome") && msg.getInt("channelID") != 0) {
                String mode = msg.getJSONObject("info").optString("mode", "combat");
                if (mode.equals("combat")) {
                    EnumSet<ShipType> shipTypes = EnumSet.allOf(ShipType.class);
                    if (msg.getJSONObject("info").has("shipTypes")) {
                        JSONArray a = msg.getJSONObject("info").getJSONArray("shipTypes");
                        shipTypes = EnumSet.noneOf(ShipType.class);
                        for (int i = 0; i < a.length(); ++i) {
                            shipTypes.add(ShipType.valueOf(a.getString(i)));
                        }
                    }
                    MultiplayerSetupIntent mpsi = new MultiplayerSetupIntent(msg.getBoolean("flipped"), this.g, this.server, msg.getJSONObject("info").getInt("costLimit"), msg.getJSONObject("info").optBoolean("oneShipOnly", false), shipTypes, msg.getJSONObject("info").getInt("techTier"), msg.getJSONObject("info").getBoolean("instantCommandRegeneration"), true);
                    mpsi.seed = msg.getLong("seed");
                    mpsi.channelID = msg.getInt("channelID");
                    mpsi.leaveToMetaLobby = true;
                    mpsi.welcomeReceived = true;
                    UniScreen us = new UniScreen(this.g, mpsi);
                    us.setupFleet = new ArrayList();
                    mpsi.genGround(us);
                    this.g.s = us;
                }
                if (mode.equals("conquest")) {
                    StrategicLobbyScreen sls = new StrategicLobbyScreen(this.g, this.g.client, null, this.joiningData);
                    this.joiningData = null;
                    if (sls.processWelcome(msg)) {
                        this.g.s = sls;
                    }
                }
                return false;
            }
            if (msg.get("type").equals("reject")) {
                this.error = Lang._t("Unable_to_join", new Object[0]);
                this.joining = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.error != null) {
            return;
        }
        if (this.joining > 0) {
            this.joining = StrictMath.max(0, this.joining - ms);
        }
        ScreenMode sm = in.mode();
        int w = (int)StrictMath.max(500.0, (double)sm.width * 0.4);
        int playersWidth = (int)StrictMath.max(200.0, (double)sm.width * 0.2);
        boolean showPlayers = sm.width > 1000;
        this.chatScrollBar.stickToBottom = true;
        if (!this.setupDialog && !this.conquestSetupDialog) {
            this.channelScrollBar.tick(in, MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING, w, sm.height - MyDraw.TOP_BAR_H - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE);
            this.chatScrollBar.tick(in, MyDraw.SIDE_CLEARANCE + w + MyDraw.UI_SPACING, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING, sm.width - w - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE * 2 - (showPlayers ? playersWidth + MyDraw.UI_SPACING : 0), sm.height - MyDraw.TOP_BAR_H - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING);
            if (showPlayers) {
                this.playerScrollBar.tick(in, sm.width - playersWidth - MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING, playersWidth, sm.height - MyDraw.TOP_BAR_H - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING);
            }
        }
        if (this.g.client == null || this.g.client.connectionFailed() || this.g.client.isDisconnected()) {
            this.error = Lang._t("mp_server_conn_failed", new Object[0]);
            this.leaveAfterErrorDismiss = true;
        }
        if (this.mrpd != null) {
            ModReloadProgressDialog myMrpd = this.mrpd;
            if (this.mrpd.tick(in) && myMrpd == this.mrpd) {
                this.mrpd = null;
            }
        }
        if (this.g.isConnected()) {
            this.gameRefreshTimer += ms;
            if (!this.g.channelsLoaded || this.gameRefreshTimer >= 3000) {
                this.refreshChannels();
                this.g.channelsLoaded = true;
                this.gameRefreshTimer = 0;
            }
            while (this.pollMessageAndProcess(in)) {
            }
            if (this.mrpd == null && !this.unableToLoadCorrectMods) {
                if (this.conquestSetupDialog) {
                    this.gameNameField.input(in, drawState, cursor, click, ms);
                    if (this.modsSBRect != null) {
                        this.modsSB.tick(in, (int)this.modsSBRect.x, (int)this.modsSBRect.y, (int)this.modsSBRect.w, (int)this.modsSBRect.h);
                    }
                    if (in.keyPressed("ENTER") && drawState.canClick() && !this.gameNameField.getText().isEmpty()) {
                        this.prepareForCreatingConquestGame(this.gameNameField.getText(), enabledMods);
                        drawState.hasClicked();
                        this.conquestSetupDialog = false;
                    }
                } else if (this.setupDialog) {
                    this.gameNameField.input(in, drawState, cursor, click, ms);
                    if (this.modsSBRect != null) {
                        this.modsSB.tick(in, (int)this.modsSBRect.x, (int)this.modsSBRect.y, (int)this.modsSBRect.w, (int)this.modsSBRect.h);
                    }
                    if (in.keyPressed("ENTER") && drawState.canClick() && !this.gameNameField.getText().isEmpty()) {
                        this.prepareForCreatingGame(this.gameNameField.getText(), gameLimit, oneShipOnly, enabledMods, allowedTypes, techTier, instantCommandRegeneration);
                        drawState.hasClicked();
                        this.setupDialog = false;
                    }
                } else {
                    this.chatField.input(in, drawState, cursor, click, ms);
                    if (in.keyDown("ENTER") && drawState.canClick() && !this.chatField.getText().isEmpty()) {
                        this.sendChat();
                    }
                }
            }
        }
        if (this.unableToLoadCorrectMods) {
            if (in.keyPressed("ENTER") || in.keyPressed("ESCAPE")) {
                this.unableToLoadCorrectMods = false;
                this.resetMods();
            }
            return;
        }
        if (in.keyPressed("ESCAPE") && this.mrpd == null) {
            if (this.conquestSetupDialog) {
                this.conquestSetupDialog = false;
            } else if (this.setupDialog) {
                this.setupDialog = false;
            } else {
                this.leave();
                return;
            }
        }
    }

    private void leave() {
        if (!AirshipGame.multiplayerChatOverlay) {
            this.g.disconnectClient();
        }
        if (this.server != null) {
            this.server.close();
            this.g.lanServer = null;
        }
        this.g.s = new MainMenu(this.g, MainMenu.Submenu.MULTIPLAYER);
    }

    private void sendChat() {
        this.g.sendMessage(Client.gmsg("globalChat").put("id", this.g.myID).put("text", this.chatField.getText()));
        this.chatField.setText("");
    }

    private void showGameSetupDialog() {
        this.setupDialog = true;
        this.availableMods = Mod.getAvailableMods();
        this.gameNameField.focus = true;
        this.gameNameField.reset();
        this.gameNameField.setText(AirshipGame.PREFS.get("multiplayerGameName", ""));
    }

    private void showGameConquestSetupDialog() {
        this.conquestSetupDialog = true;
        this.availableMods = Mod.getAvailableMods();
        this.gameNameField.focus = true;
        this.gameNameField.reset();
        this.gameNameField.setText(AirshipGame.PREFS.get("multiplayerGameName", ""));
    }

    private void resumeConquestGame() {
        FileScreen.Backend b = StrategicScreen.savesList();
        this.g.s = new FileScreen(b, new ResumeConquestMission(this.g, b, this), null, new DateInfo(b), "saves");
    }

    private void prepareForCreatingGame(String name, int costLimit, boolean oneShipOnly, final ArrayList<Mod> enabledMods, EnumSet<ShipType> allowedTypes, int techTier, boolean instantCommandRegeneration) {
        AirshipGame.PREFS.put("multiplayerGameName", name);
        try {
            AirshipGame.PREFS.sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Mod.overriddenEnabledModIds = new ArrayList();
        for (Mod m : enabledMods) {
            Mod.overriddenEnabledModIds.add(m.id);
        }
        this.gameName = name;
        this.gameCostLimit = costLimit;
        this.gameOneShipOnly = oneShipOnly;
        this.gameAllowedTypes = EnumSet.copyOf(allowedTypes);
        this.gameTechTier = techTier;
        this.gameInstantCommandRegeneration = instantCommandRegeneration;
        this.mrpd = new ModReloadProgressDialog(new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.doCreateGame(enabledMods);
            }
        }, new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.unableToLoadCorrectMods = true;
            }
        });
    }

    private void prepareForCreatingConquestGame(String name, final ArrayList<Mod> enabledMods) {
        AirshipGame.PREFS.put("multiplayerGameName", name);
        try {
            AirshipGame.PREFS.sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Mod.overriddenEnabledModIds = new ArrayList();
        for (Mod m : enabledMods) {
            Mod.overriddenEnabledModIds.add(m.id);
        }
        this.gameName = name;
        this.mrpd = new ModReloadProgressDialog(new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.doCreateConquestGame(enabledMods);
            }
        }, new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.unableToLoadCorrectMods = true;
            }
        });
    }

    public void prepareForResumingConquestGame(final JSONObject data) {
        boolean modsFailed = false;
        final ArrayList<Mod> loadGameMods = new ArrayList<Mod>();
        if (data.has("mods")) {
            JSONArray mods = data.getJSONArray("mods");
            for (int i = 0; i < mods.length(); ++i) {
                Mod m = Mod.getById(mods.getJSONObject(i).getString("id"));
                if (m == null) {
                    modsFailed = true;
                    break;
                }
                loadGameMods.add(m);
            }
        }
        StringBuilder modsList = new StringBuilder();
        JSONArray mods = data.getJSONArray("mods");
        for (int i = 0; i < mods.length(); ++i) {
            modsList.append(mods.getJSONObject(i).getString("id"));
            if (i == mods.length() - 1) continue;
            modsList.append(", ");
        }
        if (modsFailed) {
            this.g.showError(Lang._t("unable_to_load_mp_mods", new Object[0]) + "\n" + modsList.toString());
            return;
        }
        Mod.overriddenEnabledModIds = new ArrayList();
        for (Mod m : loadGameMods) {
            Mod.overriddenEnabledModIds.add(m.id);
        }
        this.gameName = "Resumed game by " + this.g.playerName();
        this.mrpd = new ModReloadProgressDialog(new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.doResumeConquestGame(data, loadGameMods);
            }
        }, new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.unableToLoadCorrectMods = true;
            }
        });
    }

    private static JSONObject modNames(Mod m) {
        JSONObject o = new JSONObject();
        for (Locale l : m.name.keySet()) {
            o.put(l.toLanguageTag(), m.name.get(l));
        }
        return o;
    }

    private void doCreateGame(ArrayList<Mod> modsThatShouldBeEnabled) {
        for (Mod m : modsThatShouldBeEnabled) {
            if (m.isCurrentlyEnabled()) continue;
            this.unableToLoadCorrectMods = true;
            return;
        }
        JSONArray modsA = new JSONArray();
        for (Mod m : Mod.getEnabledMods()) {
            modsA.put(new JSONObject().put("id", m.id).put("checksum", m.getCachedChecksum()).put("name", MetaLobbyScreen.modNames(m)));
        }
        JSONArray typesA = new JSONArray();
        for (ShipType t : this.gameAllowedTypes) {
            typesA.put(t.name());
        }
        this.joining = 10000;
        this.joiningData = null;
        this.g.sendMessage(Client.gmsg("createGame").put("id", this.g.myID).put("name", this.gameName));
        this.g.sendMessage(Client.msg("createChannel").put("info", new JSONObject().put("name", this.gameName).put("mode", "combat").put("costLimit", this.gameCostLimit).put("oneShipOnly", this.gameOneShipOnly).put("instantCommandRegeneration", this.gameInstantCommandRegeneration).put("techTier", this.gameTechTier).put("mods", modsA).put("shipTypes", typesA).put("version", 101301)));
    }

    private void doCreateConquestGame(ArrayList<Mod> modsThatShouldBeEnabled) {
        for (Mod m : modsThatShouldBeEnabled) {
            if (m.isCurrentlyEnabled()) continue;
            this.unableToLoadCorrectMods = true;
            return;
        }
        JSONArray modsA = new JSONArray();
        for (Mod m : Mod.getEnabledMods()) {
            modsA.put(new JSONObject().put("id", m.id).put("checksum", m.getCachedChecksum()).put("name", MetaLobbyScreen.modNames(m)));
        }
        this.joining = 10000;
        this.joiningData = null;
        this.g.sendMessage(Client.gmsg("createGame").put("id", this.g.myID).put("name", this.gameName));
        this.g.sendMessage(Client.msg("createChannel").put("numPlayers", 0).put("info", new JSONObject().put("name", this.gameName).put("mode", "conquest").put("lang", Lang.currentLocale).put("initiatorID", this.g.myID).put("isResumeFromLoaded", false).put("mods", modsA).put("version", 101301)));
    }

    private void doResumeConquestGame(JSONObject data, ArrayList<Mod> modsThatShouldBeEnabled) {
        for (Mod m : modsThatShouldBeEnabled) {
            if (m.isCurrentlyEnabled()) continue;
            this.unableToLoadCorrectMods = true;
            return;
        }
        JSONArray modsA = new JSONArray();
        for (Mod m : Mod.getEnabledMods()) {
            modsA.put(new JSONObject().put("id", m.id).put("checksum", m.getCachedChecksum()).put("name", MetaLobbyScreen.modNames(m)));
        }
        this.joining = 10000;
        this.joiningData = data;
        this.g.sendMessage(Client.gmsg("createGame").put("id", this.g.myID).put("name", this.gameName));
        this.g.sendMessage(Client.msg("createChannel").put("numPlayers", 0).put("info", new JSONObject().put("name", this.gameName).put("mode", "conquest").put("lang", Lang.currentLocale).put("initiatorID", this.g.myID).put("isResumeFromLoaded", true).put("mods", modsA).put("version", 101301)));
    }

    public void renderConquestSetupDialog(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        this.gameNameField.help = Lang._t("Name", new Object[0]);
        int w = d.bw(Lang._t("Create_Game", new Object[0])) + MyDraw.BUTTON_SPACING + d.bw(Lang._t("Cancel", new Object[0]));
        w = StrictMath.max(w, AGame.FOUNT.displayWidth * 40);
        for (Mod m : this.availableMods) {
            w = StrictMath.max(w, (int)d.textSize((String)m.getName(), (Fount)AGame.FOUNT).x + MyDraw.UI_SPACING + d.tw(Lang._t("Enabled", new Object[0])));
        }
        w += MyDraw.PANEL_INSET * 2 + ScrollBar.SCROLL_BAR_W;
        w = StrictMath.min(w, sm.width - MyDraw.SIDE_CLEARANCE * 2);
        int h = sm.height / 2;
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - h / 2;
        d.drawShadowedWindow(x, y, w, h);
        h -= MyDraw.WINDOW_INSET * 2;
        d.text(Lang._t("Create_Game", new Object[0]), AGame.BIG_FOUNT, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET);
        h -= AGame.BIG_FOUNT.lineHeight + MyDraw.UI_SPACING;
        this.gameNameField.render(x, y += AGame.BIG_FOUNT.lineHeight + MyDraw.UI_SPACING, w -= MyDraw.WINDOW_INSET * 2, d, sm, hs, cursor);
        int sbH = (h -= MyDraw.textFieldH() + MyDraw.UI_SPACING) - MyDraw.BUTTON_H - MyDraw.UI_SPACING;
        this.modsSB.draw(d, x, y += MyDraw.textFieldH() + MyDraw.UI_SPACING, w, sbH, this.availableMods, this.modsAdapter);
        this.modsSBRect = new Rect2D(x, y, w, sbH);
        int bw = (w - MyDraw.BUTTON_SPACING) / 2;
        d.button(x, y += sbH + MyDraw.UI_SPACING, bw, Lang._t("Cancel", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.conquestSetupDialog = false;
            }
        });
        d.button(x + bw + MyDraw.BUTTON_SPACING, y, bw, Lang._t("Create_Game", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.prepareForCreatingConquestGame(MetaLobbyScreen.this.gameNameField.getText(), enabledMods);
                MetaLobbyScreen.this.conquestSetupDialog = false;
            }
        }, !this.gameNameField.getText().isEmpty());
    }

    public void renderSetupDialog(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int n;
        this.gameNameField.help = Lang._t("Name", new Object[0]);
        int col1W = 100;
        for (int l : HostOrJoinGameScreen.COST_LIMITS) {
            col1W = StrictMath.max(col1W, d.tw("" + l));
        }
        col1W = StrictMath.max(col1W, d.tw(Lang._t("One_Ship_Only", new Object[0])));
        for (ShipType t : ShipType.values()) {
            col1W = StrictMath.max(col1W, d.tw(Lang._t(t.name() + "_plural", new Object[0])));
        }
        col1W = StrictMath.max(col1W, d.bw(Lang._t("Create_Game", new Object[0])));
        col1W = StrictMath.max(col1W, d.bw(Lang._t("Cancel", new Object[0])));
        int n2 = 100;
        for (Mod m : this.availableMods) {
            n = StrictMath.max(n, (int)d.textSize((String)m.getName(), (Fount)AGame.FOUNT).x + MyDraw.UI_SPACING + d.tw(Lang._t("Enabled", new Object[0])));
        }
        int n4 = StrictMath.min(n, sm.width - col1W - MyDraw.UI_SPACING - MyDraw.WINDOW_INSET * 2 - MyDraw.PANEL_INSET * 2 - ScrollBar.SCROLL_BAR_W - MyDraw.SIDE_CLEARANCE * 2);
        n4 = n4 + (MyDraw.PANEL_INSET * 2 + ScrollBar.SCROLL_BAR_W);
        int w = col1W + MyDraw.UI_SPACING + n4 + MyDraw.WINDOW_INSET * 2;
        int h = MyDraw.WINDOW_INSET + AGame.BIG_FOUNT.height + MyDraw.UI_SPACING + MyDraw.textFieldH() + MyDraw.UI_SPACING + HostOrJoinGameScreen.COST_LIMITS.length * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) + MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING + MyDraw.BUTTON_H + MyDraw.UI_SPACING + MyDraw.BUTTON_H + MyDraw.UI_SPACING + ShipType.values().length * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) + MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING + (Tech.getMaxTier() + 2 - Tech.getMinTier()) * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) + MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING + MyDraw.BUTTON_H * 2 + MyDraw.BUTTON_SPACING * 2 + MyDraw.BUTTON_H + MyDraw.WINDOW_INSET;
        if (gameLimit >= 20000) {
            h += (int)d.textSize((String)Lang._t((String)"dangerous_cost_warning", (Object[])new Object[0]), (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)col1W).height;
            h += MyDraw.UI_SPACING;
        }
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - h / 2;
        d.drawShadowedWindow(x, y, w, h);
        d.text(Lang._t("Create_Game", new Object[0]), AGame.BIG_FOUNT, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET);
        int y2 = y += AGame.BIG_FOUNT.lineHeight + MyDraw.UI_SPACING;
        this.gameNameField.render(x, y, col1W, d, sm, hs, cursor);
        y += MyDraw.textFieldH() + MyDraw.UI_SPACING;
        for (int i = 0; i < HostOrJoinGameScreen.COST_LIMITS.length; ++i) {
            final int ii = i;
            d.toggle(x, y, col1W, "" + HostOrJoinGameScreen.COST_LIMITS[i], null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    gameLimit = HostOrJoinGameScreen.COST_LIMITS[ii];
                }
            }, gameLimit == HostOrJoinGameScreen.COST_LIMITS[i], true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        y += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING;
        if (gameLimit >= 20000) {
            d.text(Lang._t("dangerous_cost_warning", new Object[0]), AGame.FOUNT, x, y, col1W);
            y += (int)d.textSize((String)Lang._t((String)"dangerous_cost_warning", (Object[])new Object[0]), (Fount)AGame.FOUNT, (double)((double)x), (double)((double)y), (int)col1W).height;
            y += MyDraw.UI_SPACING;
        }
        d.toggle(x, y, col1W, Lang._t("One_Ship_Only", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                oneShipOnly = !oneShipOnly;
            }
        }, oneShipOnly, true);
        d.toggle(x, y += MyDraw.BUTTON_H + MyDraw.UI_SPACING, col1W, Lang._t("Rapid_Commands", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                instantCommandRegeneration = !instantCommandRegeneration;
            }
        }, instantCommandRegeneration, true);
        d.tooltip((double)x, (double)y, (double)col1W, (double)MyDraw.BUTTON_H, Lang._t("Rapid_Commands_tooltip", new Object[0]));
        y += MyDraw.BUTTON_H + MyDraw.UI_SPACING;
        for (final ShipType t : ShipType.values()) {
            d.toggle(x, y, col1W, Lang._t(t.name() + "_plural", new Object[0]), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    if (allowedTypes.contains((Object)t)) {
                        allowedTypes.remove((Object)t);
                    } else {
                        allowedTypes.add(t);
                    }
                }
            }, allowedTypes.contains((Object)t), true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        y += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING;
        int maxTier = Tech.getMaxTier();
        for (int tier = Tech.getMinTier() - 1; tier <= maxTier; ++tier) {
            final int myTier = tier;
            d.toggle(x, y, col1W, Lang._t("tier_x", "" + (myTier + 1)), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    techTier = myTier;
                }
            }, techTier == myTier, true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        d.toggle(x, y, col1W, Lang._t("all_technology", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                techTier = 100000;
            }
        }, techTier == 100000, true);
        this.modsSB.draw(d, x + col1W + MyDraw.UI_SPACING, y2, n4, h - MyDraw.BUTTON_H - MyDraw.UI_SPACING - AGame.BIG_FOUNT.lineHeight, this.availableMods, this.modsAdapter);
        this.modsSBRect = new Rect2D(x + col1W + MyDraw.UI_SPACING, y2, n4, h - MyDraw.BUTTON_H - MyDraw.UI_SPACING - AGame.BIG_FOUNT.lineHeight);
        d.button(x, y += MyDraw.BUTTON_H + MyDraw.UI_SPACING, col1W, Lang._t("Create_Game", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.prepareForCreatingGame(MetaLobbyScreen.this.gameNameField.getText(), gameLimit, oneShipOnly, enabledMods, allowedTypes, techTier, instantCommandRegeneration);
                MetaLobbyScreen.this.setupDialog = false;
            }
        }, !this.gameNameField.getText().isEmpty() && !allowedTypes.isEmpty());
        d.button(x, y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, col1W, Lang._t("Cancel", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.setupDialog = false;
            }
        });
    }

    private void doJoin(final ChannelInfo ci) {
        this.joining = 10000;
        JSONArray mods = new JSONArray();
        if (ci.info.has("mods")) {
            mods = ci.info.getJSONArray("mods");
        }
        Mod.overriddenEnabledModIds = new ArrayList();
        for (int i = 0; i < mods.length(); ++i) {
            Mod.overriddenEnabledModIds.add(mods.getJSONObject(i).getString("id"));
        }
        this.mrpd = new ModReloadProgressDialog(new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.doJoinGame(ci);
            }
        }, new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.unableToLoadCorrectMods = true;
            }
        });
    }

    private void doJoinGame(ChannelInfo ci) {
        if (ci.info.has("mods")) {
            JSONArray mods = ci.info.getJSONArray("mods");
            for (int i = 0; i < mods.length(); ++i) {
                Mod m = Mod.getById(mods.getJSONObject(i).getString("id"));
                if (m != null && m.isCurrentlyEnabled()) continue;
                this.unableToLoadCorrectMods = true;
                this.joining = 0;
                return;
            }
        }
        this.g.sendMessage(Client.msg("changeChannel").put("id", ci.id));
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.rect(AGame.SKY, 0.0, 0.0, sm.width, sm.height);
        d.drawBG(MyDraw.SCREEN_BG, sm);
        d.drawTopBar(sm);
        int bw = d.bw(Lang._t("Leave", new Object[0]));
        int x2 = sm.width - bw - MyDraw.SIDE_CLEARANCE;
        d.button(x2, MyDraw.TOP_BAR_INSET, bw, Lang._t("Leave", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyScreen.this.leave();
            }
        }, !this.isJoining());
        bw = d.bw(Lang._t("Create_Game", new Object[0]));
        d.button(x2 -= bw + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, bw, Lang._t("Create_Game", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyScreen.this.showGameSetupDialog();
            }
        }, this.g.isConnected() && !this.isJoining());
        bw = d.bw(Lang._t("Create_Conquest_Game", new Object[0]));
        d.button(x2 -= bw + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, bw, Lang._t("Create_Conquest_Game", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyScreen.this.showGameConquestSetupDialog();
            }
        }, this.g.isConnected() && !this.isJoining());
        bw = d.bw(Lang._t("Resume_Conquest_Game", new Object[0]));
        d.button(x2 -= bw + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, bw, Lang._t("Resume_Conquest_Game", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyScreen.this.resumeConquestGame();
            }
        }, this.g.isConnected() && !this.isJoining());
        bw = d.bw(Lang._t("Refresh_List", new Object[0]));
        d.button(x2 -= bw + MyDraw.BUTTON_SPACING, MyDraw.TOP_BAR_INSET, bw, Lang._t("Refresh_List", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyScreen.this.refreshChannels();
            }
        }, this.g.isConnected() && !this.isJoining());
        d.text(Lang._t("Online_Multiplayer_Games", new Object[0]) + " (" + (this.g.isReconnecting() ? Lang._t("Reconnecting_", new Object[0]) : this.g.ping() + " ping") + ")", AGame.BIG_FOUNT, MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_INSET);
        int x = MyDraw.SIDE_CLEARANCE;
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int w = (int)StrictMath.max(500.0, (double)sm.width * 0.4);
        int h = sm.height - MyDraw.TOP_BAR_H - MyDraw.SIDE_CLEARANCE - MyDraw.UI_SPACING;
        this.channelScrollBar.draw(d, x, y, w, h, this.g.channels, this.channelAdapter);
        if (this.g.channels.isEmpty()) {
            d.text(this.g.channelsLoaded ? Lang._t("No_games_available_Create_one_", new Object[0]) : Lang._t("Loading_games_", new Object[0]), AGame.FOUNT, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET);
        }
        x = w + MyDraw.SIDE_CLEARANCE + MyDraw.UI_SPACING;
        w = sm.width - x - MyDraw.SIDE_CLEARANCE;
        h = h - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING;
        boolean showPlayers = sm.width > 1000;
        int playersWidth = (int)StrictMath.max(200.0, (double)sm.width * 0.2);
        this.chatScrollBar.draw(d, x, y, w - (showPlayers ? playersWidth + MyDraw.UI_SPACING : 0), h, this.g.chat, this.chatAdapter);
        if (showPlayers) {
            this.playerScrollBar.draw(d, x + w - playersWidth, y, playersWidth, h, new ArrayList<PlayerInfo>(this.g.players.values()), this.playerAdapter);
        }
        this.chatField.render(x, sm.height - MyDraw.BUTTON_H - MyDraw.SIDE_CLEARANCE, w - 80 - MyDraw.BUTTON_SPACING, d, sm, hs, cursor);
        d.button(sm.width - 80 - MyDraw.SIDE_CLEARANCE, sm.height - MyDraw.BUTTON_H - MyDraw.SIDE_CLEARANCE, 80, Lang._t("Send", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyScreen.this.sendChat();
            }
        }, this.g.isConnected() && !this.isJoining());
        if (this.setupDialog) {
            d.getHooks().list.clear();
            this.renderSetupDialog(d, sm, hs, cursor);
        }
        if (this.conquestSetupDialog) {
            d.getHooks().list.clear();
            this.renderConquestSetupDialog(d, sm, hs, cursor);
        }
        if (this.mrpd != null) {
            d.getHooks().list.clear();
            this.mrpd.render(d, sm, hs, cursor);
        }
        if (this.unableToLoadCorrectMods) {
            d.getHooks().list.clear();
            d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 200, 400, Lang._t("unable_to_load_mp_mods", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    MetaLobbyScreen.this.unableToLoadCorrectMods = false;
                    MetaLobbyScreen.this.resetMods();
                }
            });
        }
        if (this.error != null) {
            d.getHooks().list.clear();
            d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 200, 400, this.error, new Runnable(){

                @Override
                public void run() {
                    MetaLobbyScreen.this.error = null;
                    if (MetaLobbyScreen.this.leaveAfterErrorDismiss) {
                        MetaLobbyScreen.this.leave();
                    }
                }
            });
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    private boolean isJoining() {
        return this.joining > 0;
    }

    private strictfp class ChannelAdapter
    implements ScrollBar.ScrollElementAdapter<ChannelInfo> {
        private ChannelAdapter() {
        }

        @Override
        public int getHeight(ChannelInfo ci, MyDraw d, int availableWidth) {
            return StrictMath.max((int)d.textSize((String)ci.name, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(availableWidth - MyDraw.PANEL_INSET * 3 - d.bw((String)Lang._t((String)"Join", (Object[])new Object[0])))).height, MyDraw.BUTTON_H) + MyDraw.PANEL_INSET * 2 - AGame.FOUNT.lineHeight + AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void draw(final ChannelInfo ci, MyDraw d, int x, int y, int width) {
            int bw = d.bw(Lang._t("Join", new Object[0]));
            int height = StrictMath.max((int)d.textSize((String)ci.name, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(width - MyDraw.PANEL_INSET * 3 - bw)).height, MyDraw.BUTTON_H) + MyDraw.PANEL_INSET * 2 - AGame.FOUNT.lineHeight + AGame.FOUNT.height;
            d.drawPanel(x, y, width, height);
            d.text(ci.name, AGame.FOUNT, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET, width - MyDraw.PANEL_INSET * 3 - bw);
            d.button(x + width - MyDraw.PANEL_INSET - bw, y + MyDraw.PANEL_INSET, bw, Lang._t("Join", new Object[0]), null, new Runnable(){

                @Override
                public void run() {
                    MetaLobbyScreen.this.doJoin(ci);
                }
            }, !MetaLobbyScreen.this.isJoining() && ci.canJoin());
        }
    }
}

