/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.ChannelInfo;
import com.zarkonnen.airships.ChatAdapter;
import com.zarkonnen.airships.ChatMsg;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MetaLobbyScreen;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlayerAdapter;
import com.zarkonnen.airships.PlayerInfo;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.StrategicLobbyScreen;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.TechScreen;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WorldGenScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public strictfp class MetaLobbyOverlay
implements Screen {
    private String error;
    private final AirshipGame g;
    private boolean channelsLoaded = false;
    private final TextField chatField = new TextField();
    private int numUnseenChatMessages = 0;
    private int time = 0;
    public static final int GAME_REFRESH_INTERVAL = 3000;
    private int gameRefreshTimer = 2700;
    private final ScrollBar channelScrollBar = new ScrollBar();
    private final ScrollBar chatScrollBar = new ScrollBar();
    private final ScrollBar playerScrollBar = new ScrollBar();
    private ChatMsg mostRecentMessage;
    private int timeSinceMostRecentMessage;
    public static final int SHOW_MESSAGE_TIME = 20000;
    private final ChannelAdapter channelAdapter = new ChannelAdapter();
    private final ChatAdapter chatAdapter = new ChatAdapter();
    private final PlayerAdapter playerAdapter = new PlayerAdapter();

    public MetaLobbyOverlay(AirshipGame g) {
        this.g = g;
        this.chatScrollBar.stickToBottom = true;
        this.chatScrollBar.offset = 100000;
    }

    private void refreshChannels() {
        this.g.client.sendMessageRaw(Client.msg("listChannels"));
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.g.client == null || this.g.client.connectionFailed() || this.g.client.isDisconnected()) {
            return;
        }
        ScreenMode sm = in.mode();
        int w = (int)StrictMath.max(500.0, (double)sm.width * 0.4);
        int playersWidth = (int)StrictMath.max(200.0, (double)sm.width * 0.2);
        boolean showPlayers = sm.width > 1000;
        this.time += ms;
        if (!this.g.chat.isEmpty() && this.g.chat.get(this.g.chat.size() - 1) != this.mostRecentMessage) {
            this.mostRecentMessage = this.g.chat.get(this.g.chat.size() - 1);
            this.timeSinceMostRecentMessage = 0;
        } else {
            this.timeSinceMostRecentMessage += ms;
        }
        if (this.g.mpChatOverlayActive) {
            this.channelScrollBar.tick(in, MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING, w, sm.height - MyDraw.TOP_BAR_H - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE);
            this.chatScrollBar.tick(in, MyDraw.SIDE_CLEARANCE + w + MyDraw.UI_SPACING, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING, sm.width - w - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE * 2 - (showPlayers ? playersWidth + MyDraw.UI_SPACING : 0), sm.height - MyDraw.TOP_BAR_H - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING);
            if (showPlayers) {
                this.playerScrollBar.tick(in, sm.width - playersWidth - MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING, playersWidth, sm.height - MyDraw.TOP_BAR_H - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING);
            }
        }
        if (this.g.client.isConnectedRaw()) {
            this.gameRefreshTimer += ms;
            if (!this.channelsLoaded || this.gameRefreshTimer >= 3000) {
                this.refreshChannels();
                this.channelsLoaded = true;
                this.gameRefreshTimer = 0;
            }
            if (this.g.mpChatOverlayActive) {
                this.chatField.input(in, drawState, cursor, click, ms);
                if (in.keyDown("ENTER") && drawState.canClick() && !this.chatField.getText().isEmpty()) {
                    this.sendChat();
                }
            }
        }
        if (this.g.mpChatOverlayActive) {
            this.numUnseenChatMessages = 0;
            if (in.keyPressed("ESCAPE")) {
                this.g.mpChatOverlayActive = false;
            }
        }
    }

    private void sendChat() {
        this.g.client.sendMessageRaw(Client.gmsg("globalChat").put("id", this.g.myID).put("text", this.chatField.getText()));
        this.chatField.setText("");
    }

    private boolean canSafelySwitchToMP() {
        return !(this.g.s instanceof UniScreen) && !(this.g.s instanceof StrategicScreen) && !(this.g.s instanceof WorldGenScreen) && !(this.g.s instanceof FileScreen) && !(this.g.s instanceof TechScreen) && !(this.g.s instanceof StrategicLobbyScreen);
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        if (this.g.client == null || this.g.client.connectionFailed() || this.g.client.isDisconnected()) {
            return;
        }
        if (this.g.s instanceof UniScreen && ((UniScreen)this.g.s).hideUI) {
            return;
        }
        int toggleX = sm.width - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H;
        if (this.g.s instanceof StrategicScreen) {
            toggleX = MyDraw.SIDE_CLEARANCE;
        }
        int toggleY = sm.height - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H;
        boolean toggleActive = this.g.mpChatOverlayActive || this.numUnseenChatMessages > 0 && this.time / 800 % 2 == 0;
        d.iconToggle(toggleX, toggleY, null, new InputRunnable(){

            @Override
            public void run(Input in) {
                ((MetaLobbyOverlay)MetaLobbyOverlay.this).g.mpChatOverlayActive = !((MetaLobbyOverlay)MetaLobbyOverlay.this).g.mpChatOverlayActive;
            }
        }, toggleActive, true);
        d.text("" + this.g.players.size(), AGame.FOUNT, toggleX + MyDraw.BUTTON_H / 2 - AGame.FOUNT.height / 2 + 1, toggleY + 4);
        d.tooltip((double)toggleX, (double)toggleY, (double)MyDraw.BUTTON_H, (double)MyDraw.BUTTON_H, Lang._t("x_players_in_multiplayer_chat", this.g.players.size()));
        if (!this.g.mpChatOverlayActive) {
            if (this.mostRecentMessage != null && this.timeSinceMostRecentMessage <= 20000) {
                String t = "[bg=000000] " + this.mostRecentMessage.msg + " ";
                Rect sz = d.textSize(t, AGame.FOUNT, 0.0, 0.0, toggleX - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE);
                d.text(t, AGame.FOUNT, (double)toggleX - sz.width - (double)MyDraw.UI_SPACING, toggleY, toggleX - MyDraw.UI_SPACING - MyDraw.SIDE_CLEARANCE);
            }
            return;
        }
        this.mostRecentMessage = null;
        int x = MyDraw.SIDE_CLEARANCE;
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int w = (int)StrictMath.max(500.0, (double)sm.width * 0.4);
        int h = sm.height - MyDraw.TOP_BAR_H - MyDraw.SIDE_CLEARANCE - MyDraw.UI_SPACING;
        h = h - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING;
        ArrayList<ChannelInfo> cs = new ArrayList<ChannelInfo>();
        cs.add(null);
        cs.addAll(this.g.channels);
        this.channelScrollBar.draw(d, x, y, w, h, cs, this.channelAdapter);
        x = w + MyDraw.SIDE_CLEARANCE + MyDraw.UI_SPACING;
        w = sm.width - x - MyDraw.SIDE_CLEARANCE;
        boolean showPlayers = sm.width > 1000;
        int playersWidth = (int)StrictMath.max(200.0, (double)sm.width * 0.2);
        this.chatScrollBar.draw(d, x, y, w - (showPlayers ? playersWidth + MyDraw.UI_SPACING : 0), h, this.g.chat, this.chatAdapter);
        if (showPlayers) {
            this.playerScrollBar.draw(d, x + w - playersWidth, y, playersWidth, h, new ArrayList<PlayerInfo>(this.g.players.values()), this.playerAdapter);
        }
        int bw = d.bw(Lang._t("Send", new Object[0]));
        this.chatField.render(x, sm.height - MyDraw.BUTTON_H - MyDraw.SIDE_CLEARANCE, w - bw - MyDraw.BUTTON_SPACING - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING, d, sm, hs, cursor);
        d.button(sm.width - bw - MyDraw.SIDE_CLEARANCE - MyDraw.BUTTON_H - MyDraw.BUTTON_SPACING, sm.height - MyDraw.BUTTON_H - MyDraw.SIDE_CLEARANCE, bw, Lang._t("Send", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyOverlay.this.sendChat();
            }
        }, this.g.client.isConnectedRaw());
        if (this.error != null) {
            d.getHooks().list.clear();
            d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 200, 400, this.error, new Runnable(){

                @Override
                public void run() {
                    MetaLobbyOverlay.this.error = null;
                }
            });
        }
    }

    @Override
    public ArrayList<String> music() {
        return null;
    }

    @Override
    public String appearancePostfix() {
        return "";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    private strictfp class ChannelAdapter
    implements ScrollBar.ScrollElementAdapter<ChannelInfo> {
        private ChannelAdapter() {
        }

        @Override
        public int getHeight(ChannelInfo ci, MyDraw d, int availableWidth) {
            if (ci == null) {
                return AGame.FOUNT.height + MyDraw.UI_SPACING + (MetaLobbyOverlay.this.canSafelySwitchToMP() ? MyDraw.BUTTON_H + MyDraw.UI_SPACING : 0);
            }
            return (int)d.textSize((String)ci.name, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(availableWidth - MyDraw.PANEL_INSET * 2)).height + MyDraw.PANEL_INSET * 2 - AGame.FOUNT.lineHeight + AGame.FOUNT.height + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void draw(ChannelInfo ci, MyDraw d, int x, int y, int width) {
            if (ci == null) {
                d.text(Lang._t("Can_create_game_from_lobby", new Object[0]), AGame.FOUNT, x, y);
                y += AGame.FOUNT.height + MyDraw.UI_SPACING;
                if (MetaLobbyOverlay.this.canSafelySwitchToMP()) {
                    d.button(x, y, d.bw(Lang._t("Join_multiplayer_lobby", new Object[0])), Lang._t("Join_multiplayer_lobby", new Object[0]), new Runnable(){

                        @Override
                        public void run() {
                            ((MetaLobbyOverlay)MetaLobbyOverlay.this).g.s = new MetaLobbyScreen(MetaLobbyOverlay.this.g, null);
                            ((MetaLobbyOverlay)MetaLobbyOverlay.this).g.mpChatOverlayActive = false;
                        }
                    });
                }
                return;
            }
            int height = StrictMath.max((int)d.textSize((String)ci.name, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(width - MyDraw.PANEL_INSET * 2)).height, MyDraw.BUTTON_H) + MyDraw.PANEL_INSET * 2 - AGame.FOUNT.lineHeight + AGame.FOUNT.height;
            d.drawPanel(x, y, width, height);
            d.text(ci.name, AGame.FOUNT, x + MyDraw.PANEL_INSET, y + MyDraw.PANEL_INSET, width - MyDraw.PANEL_INSET * 2);
        }
    }
}

