/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Analytics;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.DownloadSteamSubsProcess;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.SpriteUtils;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import com.zarkonnen.catengine.util.Utils;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;

public strictfp class LoadingScreen
implements Screen {
    public static Img LOADING_LOGO = new Img("newest_logo", 0, 0, 300, 339, false);
    public static final Img glow = new Img("light_b");
    public static final Img softGlow = new Img("light_soft");
    public static final String[] STATIC_DIRS = new String[]{"ships", "buildings", "landships"};
    private boolean waitOnce = true;
    private int staticsCopied = 0;
    private String loadingStatus = "...";
    private boolean modsLoaded = false;
    private boolean loadSuccess = false;
    private int musicLoadingIndex = 0;
    private int soundLoadingIndex;
    private String[] musics = null;
    private final Mod.LoadProcess modLoadProcess = new Mod.LoadProcess();
    private Mod.LoadProgress modLoadProgress = null;
    private DownloadSteamSubsProcess dssp = null;
    private DownloadSteamSubsProcess.Progress dsspp = null;
    private String doEnableModID = null;
    private final String[] sounds = new String[]{"hookimpact0", "throw0", "throw1", "throw2", "place_wood", "place_metal", "place_stone", "computer0", "computer1", "computer2", "motor", "hiss0", "hiss1", "hiss2", "step0", "step1", "step", "sail", "ready", "flak0", "flak1", "flak2", "flak3", "creak0", "creak1", "creak2", "creak3", "creak4", "creak5", "creak6", "creak7", "creak8", "cannon0", "cannon1", "cannon2", "cannon3", "cannon4", "cannon5", "cough0", "cough1", "cough2", "cough3", "death0", "death1", "death2", "death3", "death4", "bell", "paper_lift", "engine_1600", "explosion_0", "explosion_1", "explosion_2", "explosion_3", "fire_2000", "gatling0", "gatling1", "gatling2", "gatling3", "gatling4", "gatling5", "gatling6", "gatling7", "gatling8", "hit0", "hit1", "hit2", "hit3", "hv_cannon0", "hv_cannon1", "hv_cannon2", "large_crash", "quench0", "quench1", "quench2", "repair0", "repair1", "repair2", "repair3", "repair4", "repair5", "rifle0", "rifle1", "rocket0", "rocket1", "rocket2", "rocket3", "rocket4", "rocket5", "small_crash", "smexplosion", "suspendium_3200", "place", "remove", "spin_up", "branchcrack0", "branchcrack1", "branchcrack2", "trunkcrack0", "leaves0", "leaves1", "leaves2", "rock0", "rock1", "thunder0", "thunder1", "thunder2", "thunder3", "thunder4", "thunder5", "thunder6", "lightning0"};
    private AirshipGame g;

    public LoadingScreen(AirshipGame g) {
        this.g = g;
        Keys.loadKeyInfo();
    }

    public LoadingScreen(AirshipGame g, String doEnableModID) {
        this.g = g;
        Keys.loadKeyInfo();
        this.doEnableModID = doEnableModID;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        try {
            Mod m;
            if (SteamBackend.isEnabled() && this.dssp == null) {
                System.err.println("DownloadSteamSubsProcess init");
                this.dssp = new DownloadSteamSubsProcess();
            }
            if (this.musics == null) {
                System.err.println("musics init");
                this.musics = this.g.musicVolume == 0.0 ? new String[0] : AGame.COMBAT_MUSIC.toArray(new String[0]);
            }
            if (this.waitOnce) {
                System.err.println("waitOnce");
                this.waitOnce = false;
                return;
            }
            if (this.g.dataChecksum == 0L) {
                File checksumF = new File(new File(AGame.getStaticGameDirectory(), "data"), "checksum");
                try {
                    this.g.expectedDataChecksum = Long.parseLong(FileUtils.readFileToString((File)checksumF).trim());
                }
                catch (Exception e) {
                    System.err.println("Unable to load expected data checksum.");
                    e.printStackTrace();
                }
                this.g.dataChecksum = Loadable.getDataChecksum();
                if (!this.g.hasCorrectChecksum()) {
                    if (AGame.doWritechecksum()) {
                        System.out.println("replacing old checksum");
                        FileUtils.writeStringToFile((File)checksumF, (String)("" + this.g.dataChecksum));
                        this.g.expectedDataChecksum = this.g.dataChecksum;
                    } else {
                        System.out.println("INCORRECT DATA CHECKSUM GOT " + this.g.dataChecksum + " EXPECTED " + this.g.expectedDataChecksum);
                        System.err.println("INCORRECT DATA CHECKSUM GOT " + this.g.dataChecksum + " EXPECTED " + this.g.expectedDataChecksum);
                        this.g.reportError("Altered data", null, this.g.dataChecksum + " vs " + this.g.expectedDataChecksum, false, true);
                    }
                } else {
                    System.out.println("data checksum OK");
                }
                return;
            }
            if (this.staticsCopied == 0) {
                System.err.println("Ensuring .tex file locations");
                SpriteUtils.ensureTexFilesInGeneratedDirectory(new File(new File(AGame.getStaticGameDirectory(), "data"), "images"));
            }
            if (this.staticsCopied < STATIC_DIRS.length) {
                System.err.println("about to copy");
                System.err.println("copying " + STATIC_DIRS[this.staticsCopied]);
                this.loadingStatus = this.staticsCopied == STATIC_DIRS.length - 1 ? Lang._t("Loading_x", this.musics.length == 0 ? "..." : this.musics[0]) : Lang._t("Installing_x", STATIC_DIRS[this.staticsCopied + 1]);
                try {
                    if (this.g.prevUserFirstTimev5) {
                        AGame.overlayStatic("default_" + STATIC_DIRS[this.staticsCopied], STATIC_DIRS[this.staticsCopied]);
                    } else {
                        AGame.copyStatic("default_" + STATIC_DIRS[this.staticsCopied], STATIC_DIRS[this.staticsCopied]);
                    }
                }
                catch (Exception e) {
                    this.g.reportError(Lang._t("Unable_to_copy_game_files", new Object[0]), e, null, false);
                }
                ++this.staticsCopied;
                return;
            }
            if (!(this.dssp == null || this.dsspp != null && this.dsspp.done)) {
                this.dsspp = this.dssp.tick();
                this.loadingStatus = this.dsspp.desc;
                return;
            }
            if (!this.modsLoaded) {
                System.err.println("loading mods");
                if (this.doEnableModID != null) {
                    this.g.disableAllModsOnStartup = false;
                    Mod m2 = Mod.getById(this.doEnableModID);
                    if (m2 != null) {
                        m2.setPermanentlyEnabled(true);
                    }
                }
                if (this.g.disableAllModsOnStartup) {
                    this.modLoadProcess.disableAllMods = true;
                }
                this.modLoadProgress = this.modLoadProcess.doLoad(in);
                System.err.println(this.modLoadProgress.desc);
                this.loadSuccess = !this.modLoadProgress.failed;
                this.modsLoaded = this.modLoadProgress.complete;
                this.loadingStatus = this.modLoadProgress.desc;
                return;
            }
            if (this.modsLoaded && !this.loadSuccess) {
                System.err.println("mod load error");
                if (in.keyDown("ESCAPE") || in.keyDown("Q")) {
                    in.quit();
                }
                return;
            }
            if (this.musicLoadingIndex < this.musics.length) {
                System.err.println("preloading " + this.musics[this.musicLoadingIndex]);
                in.preloadMusic(this.musics[this.musicLoadingIndex]);
                this.loadingStatus = this.musicLoadingIndex == this.musics.length - 1 ? Lang._t("Loading_x", this.sounds[0]) : Lang._t("Loading_x", this.musics[this.musicLoadingIndex + 1]);
                ++this.musicLoadingIndex;
                return;
            }
            if (this.soundLoadingIndex != this.sounds.length) {
                System.err.println("preloading " + this.sounds[this.soundLoadingIndex]);
                this.g.swallowExceptions = true;
                int n = 0;
                while (n++ < 10 && this.soundLoadingIndex < this.sounds.length) {
                    in.preloadSounds(Utils.l((Object[])new String[]{this.sounds[this.soundLoadingIndex++]}));
                }
                if (this.soundLoadingIndex < this.sounds.length) {
                    this.loadingStatus = Lang._t("Loading_x", this.sounds[this.soundLoadingIndex]);
                }
                return;
            }
            System.err.println("done");
            this.g.swallowExceptions = false;
            this.g.saveSettings();
            this.g.doLowMemoryCheck();
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.MAIN);
            Analytics.modsLoadedAtLaunch(Mod.getEnabledMods());
            ((MainMenu)this.g.s).afterBoot = true;
            if (this.doEnableModID != null && (m = Mod.getById(this.doEnableModID)) == null) {
                this.g.reportError("Internal install fail.", null, null, false, true);
                this.g.showError(Lang._t("Unable_to_install_mod_instructions", new Object[0]));
            }
            System.err.println("main menu inited");
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.flush();
            this.g.reportError("Loading tick crash", new RuntimeException(t), null, true, true);
            JOptionPane.showMessageDialog(null, "Unable to launch. Please contact the developer.");
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        try {
            Appearance.init();
            d.drawBG(MyDraw.SCREEN_BG, sm);
            if (this.modsLoaded && !this.loadSuccess) {
                StringBuilder globalLog = new StringBuilder("");
                boolean bad = false;
                for (Class c : Loadable.LOADABLES) {
                    ArrayList<String> l = Loadable.errorLogs.get(c);
                    if (l == null) {
                        globalLog.append(c.getSimpleName()).append(": NOT LOADED\n");
                        continue;
                    }
                    if (l.isEmpty()) {
                        globalLog.append(c.getSimpleName()).append(": SUCCESS\n");
                        continue;
                    }
                    globalLog.append(c.getSimpleName()).append(": FAILURE\n");
                    bad = true;
                    for (String s : l) {
                        globalLog.append("  ").append(s).append("\n");
                    }
                }
                if (bad) {
                    d.text("Data corruption! Try reinstalling the game.\nIf that doesn't work, please report this error to david.stark@zarkonnen.com.\n\n" + globalLog.toString(), AGame.FOUNT, 10.0, 10.0, sm.width - 20, 10000, 0, false);
                } else {
                    d.text(globalLog.toString(), AGame.FOUNT, 10.0, 10.0, sm.width - 20, 10000, 0, false);
                }
                System.err.println("corrupt end");
                Runtime.getRuntime().exit(1);
                return;
            }
            int x = (sm.width - 200) / 2;
            int y = sm.height / 2 - (64 + AGame.BIG_FOUNT.height + MyDraw.UI_SPACING * 3 + LoadingScreen.LOADING_LOGO.srcHeight + MyDraw.PROGRESS_BAR_H + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING + AGame.BIG_FOUNT.height) / 2;
            int glowSize = 500;
            d.blit(glow, MyDraw.TITLE, sm.width / 2 - glowSize / 2, y - glowSize / 2 + LoadingScreen.LOADING_LOGO.srcHeight / 2 + 64 + MyDraw.UI_SPACING + AGame.BIG_FOUNT.height, glowSize, glowSize);
            Pt sz = d.textSize("AIRSHIPS", AGame.HUGE_FOUNT);
            d.text(MyDraw.TITLE_C + "AIRSHIPS", AGame.HUGE_FOUNT, sm.width / 2 - (int)(sz.x / 2.0), y);
            sz = d.textSize("Conquer the Skies", AGame.BIG_FOUNT);
            d.text(MyDraw.TITLE_C + "Conquer the Skies", AGame.BIG_FOUNT, sm.width / 2 - (int)(sz.x / 2.0), y += 64);
            d.blit(LOADING_LOGO, sm.width / 2 - LoadingScreen.LOADING_LOGO.srcWidth / 2, y += AGame.BIG_FOUNT.height + MyDraw.UI_SPACING, LoadingScreen.LOADING_LOGO.srcWidth, LoadingScreen.LOADING_LOGO.srcHeight);
            y += LoadingScreen.LOADING_LOGO.srcHeight + MyDraw.UI_SPACING * 2;
            int loadAmt = this.staticsCopied + this.musicLoadingIndex + this.soundLoadingIndex;
            int loadSteps = STATIC_DIRS.length + (this.musics != null ? this.musics.length : 0) + this.sounds.length;
            if (this.modLoadProgress != null) {
                loadAmt += this.modLoadProgress.progress;
                loadSteps += this.modLoadProgress.totalSteps;
            } else {
                loadSteps += 20;
            }
            if (this.dsspp != null) {
                loadAmt += this.dsspp.progress;
                loadSteps += this.dsspp.total;
            } else {
                loadSteps += 20;
            }
            d.progressBar(x, y, 200, 1.0 * (double)loadAmt / (double)loadSteps);
            sz = d.textSize(this.loadingStatus, AGame.BIG_FOUNT);
            d.text(MyDraw.TITLE_C + this.loadingStatus, AGame.BIG_FOUNT, sm.width / 2 - (int)(sz.x / 2.0), y + MyDraw.PROGRESS_BAR_H + MyDraw.BUTTON_SPACING);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.flush();
            this.g.reportError("Loading render crash", new RuntimeException(t), null, true, true);
            JOptionPane.showMessageDialog(null, "Unable to launch. Please contact the developer.");
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.LOADING_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }
}

