/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.AnimationAppearance;
import com.zarkonnen.airships.AnimationBundle;
import com.zarkonnen.airships.ArmourPlate;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Backdrop;
import com.zarkonnen.airships.BackdropType;
import com.zarkonnen.airships.BackgroundFloatieType;
import com.zarkonnen.airships.BirdType;
import com.zarkonnen.airships.BodyPlan;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Challenge;
import com.zarkonnen.airships.Charge;
import com.zarkonnen.airships.CityName;
import com.zarkonnen.airships.CloudType;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.ConstructionStrategy;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Cursor;
import com.zarkonnen.airships.DecalType;
import com.zarkonnen.airships.DifficultyLevel;
import com.zarkonnen.airships.EmpireStat;
import com.zarkonnen.airships.GUISetting;
import com.zarkonnen.airships.GameSetting;
import com.zarkonnen.airships.GenericFragment;
import com.zarkonnen.airships.HeraldicStyle;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandscapeType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.LoadingQuote;
import com.zarkonnen.airships.MapSize;
import com.zarkonnen.airships.MiscCombatSound;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.ModuleCategory;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MonsterNestType;
import com.zarkonnen.airships.MonsterSetting;
import com.zarkonnen.airships.MusicAffinity;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.PortraitMessageType;
import com.zarkonnen.airships.ResearchSpeed;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.SeaLevelSetting;
import com.zarkonnen.airships.SettingsScreen;
import com.zarkonnen.airships.Splinter;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Substitution;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.TechSpeedSetting;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.Tincture;
import com.zarkonnen.airships.UnableToLoadException;
import com.zarkonnen.airships.WeatherEffect;
import com.zarkonnen.catengine.Img;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp abstract class Loadable
implements Comparable<Loadable> {
    public final String name;
    public final int sort;
    public Mod sourceMod;
    public static final Class[] LOADABLES = new Class[]{LoadingQuote.class, GenericFragment.class, CityName.class, Tincture.class, PaintType.class, GameSetting.class, DifficultyLevel.class, MapSize.class, Bonus.class, EmpireStat.class, SpritesheetBundle.class, Cursor.class, CloudType.class, Backdrop.class, BackdropType.class, BackgroundFloatieType.class, BirdType.class, CombatBackgroundFlavor.class, ParticleType.class, WeatherEffect.class, TimeOfDay.class, LandBlockType.class, LandscapeType.class, BodyPlan.class, AnimationBundle.class, AnimationAppearance.class, CrewType.class, DecalType.class, ArmourType.class, ModuleCategory.class, ModuleType.class, Substitution.class, Tech.class, ResearchSpeed.class, Charge.class, HeraldicStyle.class, ConstructionStrategy.class, PortraitMessageType.class, MonsterNestType.class, MusicAffinity.class, MiscCombatSound.class, GUISetting.class, Splinter.class, MonsterSetting.class, SeaLevelSetting.class, TechSpeedSetting.class};
    public static HashMap<Class, HashMap<String, Object>> map = new HashMap();
    public static HashMap<Class, ArrayList<String>> errorLogs = new HashMap();

    public Loadable(String name) {
        this.name = name;
        this.sort = 0;
    }

    public Loadable(String name, int sort) {
        this.name = name;
        this.sort = sort;
    }

    public void close() {
    }

    @Override
    public int compareTo(Loadable l2) {
        if (this.sort == l2.sort) {
            return this.name.compareTo(l2.name);
        }
        return this.sort - l2.sort;
    }

    public static <T extends Loadable> T ofName(Class<T> clazz, String name) {
        if (!map.containsKey(clazz)) {
            throw new NotFoundException(clazz, name, Lang._t("no_loadables", clazz.getSimpleName()));
        }
        if (!map.get(clazz).containsKey(name)) {
            throw new NotFoundException(clazz, name, Lang._t("no_loadable_of_name", clazz.getSimpleName(), name));
        }
        return (T)((Loadable)map.get(clazz).get(name));
    }

    public static <T extends Loadable> boolean hasOfName(Class<T> clazz, String name) {
        return map.containsKey(clazz) && map.get(clazz).containsKey(name);
    }

    public static <T extends Loadable> ArrayList<T> all(Class<T> clazz) {
        if (!map.containsKey(clazz)) {
            return new ArrayList();
        }
        ArrayList<Object> l = new ArrayList<Object>(map.get(clazz).values());
        Collections.sort(l);
        return l;
    }

    public static ArrayList<String> getErrors(Class clazz) {
        return errorLogs.containsKey(clazz) ? new ArrayList() : errorLogs.get(clazz);
    }

    public static void remove(MonsterNestType mnt) {
        map.get(mnt.getClass()).remove(mnt.name);
    }

    public static boolean load() {
        try {
            for (HashMap<String, Object> os : map.values()) {
                for (Object o : os.values()) {
                    ((Loadable)o).close();
                }
            }
            map.clear();
            errorLogs.clear();
            ArrayList<Mod> mods = Mod.getEnabledMods();
            for (Class clazz : LOADABLES) {
                if (AirshipGame.instance != null) {
                    AirshipGame.instance.tickClients();
                }
                Loadable.loadBase(clazz);
                if (!errorLogs.get(clazz).isEmpty()) {
                    for (Mod mod : mods) {
                        mod.loadFailed = true;
                    }
                    return false;
                }
                for (Mod mod : mods) {
                    ArrayList<String> refProblemLog;
                    LoadResult p = Loadable.loadDir(clazz, new File(mod.dir, clazz.getSimpleName()));
                    if (!p.log.isEmpty()) {
                        mod.loadLog = Loadable.join(p.log);
                        mod.loadFailed = true;
                        return false;
                    }
                    for (Object o : p.loaded.values()) {
                        ((Loadable)o).sourceMod = mod;
                    }
                    for (String k : p.removed) {
                        if (!map.get(clazz).containsKey(k)) continue;
                        ((Loadable)map.get(clazz).get(k)).close();
                        map.get(clazz).remove(k);
                    }
                    for (String k : p.loaded.keySet()) {
                        if (!map.get(clazz).containsKey(k)) continue;
                        ((Loadable)map.get(clazz).get(k)).close();
                        map.get(clazz).remove(k);
                    }
                    map.get(clazz).putAll(p.loaded);
                    if (clazz != ModuleType.class || (refProblemLog = ModuleType.checkForRefProblems()).isEmpty()) continue;
                    mod.loadLog = Loadable.join(refProblemLog);
                    mod.loadFailed = true;
                    return false;
                }
            }
            CrewType.postLoad();
            ArmourPlate.updateAppearances();
            CoatOfArms.updateAppearances();
            Charge.postLoad();
            TimeOfDay.postLoad();
            Resource.updateAppearances();
            ModuleType.postLoad();
            DecalType.postLoad();
            Challenge.updateTypes();
            SettingsScreen.postLoad();
            Bonus.postLoad2();
            LandBlockType.postLoad();
            if (!Tech.postLoad()) {
                return false;
            }
            MonsterNestType.postLoad();
            if (AirshipGame.instance != null) {
                AirshipGame.instance.currentGUIScale.activate();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            AirshipGame.instance.reportError("Mod load crash", e, null, false, true);
            for (Mod m : Mod.mods) {
                m.setPermanentlyEnabled(false);
            }
            AirshipGame.instance.showError(Lang._t("fatal_mod_load_error", new Object[0]));
            return false;
        }
    }

    public static String join(ArrayList<String> l) {
        StringBuilder sb = new StringBuilder();
        for (String s : l) {
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    public static <T extends Loadable> void loadBase(Class<T> clazz) {
        File dir = new File(new File(AGame.getStaticGameDirectory(), "data"), clazz.getSimpleName());
        LoadResult lr = Loadable.loadDir(clazz, dir);
        errorLogs.put(clazz, lr.log);
        map.put(clazz, lr.loaded);
        for (String k : lr.removed) {
            lr.loaded.remove(k);
        }
    }

    public static <T extends Loadable> LoadResult loadDir(Class<T> clazz, File dir) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        ArrayList<String> l = new ArrayList<String>();
        HashSet<String> rm = new HashSet<String>();
        File[] fs = dir.listFiles();
        if (fs != null) {
            List<File> fsL = Arrays.asList(fs);
            Collections.sort(fsL);
            for (File f : fsL) {
                if (f.getName().startsWith(".") || !f.getName().endsWith(".json")) continue;
                LoadResult p = Loadable.loadFile(clazz, f);
                l.addAll(p.log);
                m.putAll(p.loaded);
                rm.addAll(p.removed);
            }
        }
        return new LoadResult(l, m, rm);
    }

    public static <T extends Loadable> LoadResult loadFile(Class<T> clazz, File f) {
        Constructor<T> cons = null;
        try {
            cons = clazz.getDeclaredConstructor(JSONObject.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> loadErrors = new ArrayList<String>();
        HashSet<String> removed = new HashSet<String>();
        try {
            JSONArray a = new JSONArray(FileUtils.readFileToString((File)f, (String)"UTF-8"));
            for (int i = 0; i < a.length(); ++i) {
                JSONObject o = a.getJSONObject(i);
                if (o.optBoolean("remove")) {
                    removed.add(o.getString("name"));
                    continue;
                }
                Loadable t = (Loadable)cons.newInstance(o);
                map.put(t.name, t);
            }
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() != null) {
                if (!(ite.getCause() instanceof UnableToLoadException)) {
                    ite.getCause().printStackTrace();
                    loadErrors.add(f.getName() + ": " + ite.getCause().getMessage());
                }
            } else {
                loadErrors.add(f.getName() + ": " + ite.getMessage());
            }
        }
        catch (Exception e) {
            loadErrors.add(f.getName() + ": " + e.getMessage());
            System.err.println(f.getAbsolutePath());
            e.printStackTrace();
        }
        return new LoadResult(loadErrors, map, removed);
    }

    public static Img img(JSONObject o) {
        return new Img(o.getString("src"), o.getInt("x"), o.getInt("y"), o.getInt("w"), o.getInt("h"), o.optBoolean("flipped", false));
    }

    public static long getDataChecksum() {
        long t = System.currentTimeMillis();
        long sum = 0L;
        for (Class clazz : LOADABLES) {
            File dir = new File(new File(AGame.getStaticGameDirectory(), "data"), clazz.getSimpleName());
            try {
                sum += Mod.checksum(dir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (sum == 0L) {
            sum = 1L;
        }
        System.out.println("data checksum took " + (System.currentTimeMillis() - t) + " ms and is " + sum);
        return sum;
    }

    public strictfp static class LoadResult {
        public ArrayList<String> log;
        public HashMap<String, Object> loaded;
        public HashSet<String> removed;

        public LoadResult(ArrayList<String> log, HashMap<String, Object> loaded, HashSet<String> removed) {
            this.log = log;
            this.loaded = loaded;
            this.removed = removed;
        }
    }

    public strictfp static class NotFoundException
    extends RuntimeException {
        public final Class clazz;
        public final String name;

        public NotFoundException(Class clazz, String name, String message) {
            super(message);
            this.clazz = clazz;
            this.name = name;
        }
    }
}

