/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.BeamSpec;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Decal;
import com.zarkonnen.airships.DecalType;
import com.zarkonnen.airships.FBOGraphicsFactory;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.SpriteUtils;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.shader.ShaderProgram;

public strictfp class LightMapLayer
implements UniScreen.VisualLayer {
    public static Texture lightCones;
    public static Texture lightConesStrong;
    public static Texture ltrGradient;
    public static Texture bottomLeftRadialGradient;
    public static ShaderProgram shader;

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw __d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (!Appearance.useLighting || Appearance.useSimpleGraphics || Appearance.shaderLoadFailed) {
            return;
        }
        TimeOfDay tod = us.getTimeOfDay();
        try {
            if (lightCones == null) {
                lightCones = SpriteUtils.loadTexture("lightcones");
                lightConesStrong = SpriteUtils.loadTexture("lightconesStrong");
                ltrGradient = SpriteUtils.loadTexture("ltrGradient");
                bottomLeftRadialGradient = SpriteUtils.loadTexture("bottomLeftRadialGradient");
            }
            if (lightCones == null) {
                AirshipGame.instance.reportError("Unable to load lightCones.\n" + SpriteUtils.loadImageReport("lightcones"), null, null, false, true);
                Appearance.shaderLoadFailed = true;
            }
            if (lightConesStrong == null) {
                AirshipGame.instance.reportError("Unable to load lightConesStrong.\n" + SpriteUtils.loadImageReport("lightConesStrong"), null, null, false, true);
                Appearance.shaderLoadFailed = true;
            }
            if (ltrGradient == null) {
                AirshipGame.instance.reportError("Unable to load ltrGradient.\n" + SpriteUtils.loadImageReport("ltrGradient"), null, null, false, true);
                Appearance.shaderLoadFailed = true;
            }
            if (bottomLeftRadialGradient == null) {
                AirshipGame.instance.reportError("Unable to load bottomLeftRadialGradient.\n" + SpriteUtils.loadImageReport("bottomLeftRadialGradient"), null, null, false, true);
                Appearance.shaderLoadFailed = true;
            }
            if (Appearance.shaderLoadFailed) {
                return;
            }
            this.draw(us.lightingMap[0], 0.0f, 0.0f, __d, us, tod.light[0], 0, cropX, cropY, cropW, cropH, 0);
            this.draw(us.lightingMap[1], 0.5f, 0.0f, __d, us, tod.light[1], 1, cropX, cropY, cropW, cropH, 1);
            this.draw(us.lightingMap[2], 0.0f, 0.5f, __d, us, tod.light[2], 2, cropX, cropY, cropW, cropH, 2);
            this.draw(us.lightingMap[3], 0.5f, 0.5f, __d, us, tod.light[3], 3, cropX, cropY, cropW, cropH, 3);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void draw(Image img, float srcX, float srcY, MyDraw __d, UniScreen us, Color bg, int side, double cropX, double cropY, double cropW, double cropH, int dir) throws SlickException {
        Graphics g = FBOGraphicsFactory.getGraphicsForImage(img);
        g.setColor(bg);
        g.fillRect(0.0f, 0.0f, (float)__d.frame().mode().width, (float)__d.frame().mode().height);
        g.setColor(Color.white);
        g.scale(0.25f, 0.25f);
        g.scale((float)us.zoom, (float)us.zoom);
        g.translate((float)us.adjScrollX, (float)us.adjScrollY);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glEnable((int)3553);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)lightCones.getTextureID());
        GL11.glBegin((int)7);
        if (us.combat != null) {
            for (Combat.Side s : us.combat.sides) {
                for (Airship as : s.ships) {
                    this.draw(g, as, srcX, srcY, as.showingOutside);
                }
            }
            for (Particle p : us.combat.particles) {
                double r;
                if (p.type.lightClr == null || p.type.strongLight || !Rect2D.intersects(cropX, cropY, cropW, cropH, p.x - (r = (double)p.type.lightRadius * ((double)p.life * 1.0 / (double)p.lifespan) * p.scale), p.y - r, r * 2.0, r * 2.0)) continue;
                GL11.glColor3f((float)((float)p.type.lightClr.r / 255.0f), (float)((float)p.type.lightClr.g / 255.0f), (float)((float)p.type.lightClr.b / 255.0f));
                GL11.glTexCoord2d((double)srcX, (double)srcY);
                GL11.glVertex2d((double)((float)(p.x - r)), (double)((float)(p.y - r)));
                GL11.glTexCoord2d((double)srcX, (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(p.x - r)), (double)((float)(p.y + r)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(p.x + r)), (double)((float)(p.y + r)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)srcY);
                GL11.glVertex2d((double)((float)(p.x + r)), (double)((float)(p.y - r)));
            }
        }
        if (us.setupFleet != null) {
            for (Airship as : us.setupFleet) {
                this.draw(g, as, srcX, srcY, false);
            }
        }
        GL11.glEnd();
        if (us.combat != null) {
            GL11.glBindTexture((int)3553, (int)lightConesStrong.getTextureID());
            GL11.glBegin((int)7);
            for (Particle p : us.combat.particles) {
                double r;
                if (p.type.lightClr == null || !p.type.strongLight || !Rect2D.intersects(cropX, cropY, cropW, cropH, p.x - (r = (double)p.type.lightRadius * ((double)p.life * 1.0 / (double)p.lifespan) * p.scale), p.y - r, r * 2.0, r * 2.0)) continue;
                GL11.glColor3f((float)((float)p.type.lightClr.r / 255.0f), (float)((float)p.type.lightClr.g / 255.0f), (float)((float)p.type.lightClr.b / 255.0f));
                GL11.glTexCoord2d((double)srcX, (double)srcY);
                GL11.glVertex2d((double)((float)(p.x - r)), (double)((float)(p.y - r)));
                GL11.glTexCoord2d((double)srcX, (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(p.x - r)), (double)((float)(p.y + r)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(p.x + r)), (double)((float)(p.y + r)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)srcY);
                GL11.glVertex2d((double)((float)(p.x + r)), (double)((float)(p.y - r)));
            }
            GL11.glEnd();
        }
        GL11.glBindTexture((int)3553, (int)ltrGradient.getTextureID());
        GL11.glBegin((int)7);
        if (us.combat != null) {
            for (Combat.Side s : us.combat.sides) {
                for (Airship as : s.ships) {
                    this.drawBeams(g, as, dir);
                }
            }
        }
        GL11.glEnd();
        GL11.glBindTexture((int)3553, (int)bottomLeftRadialGradient.getTextureID());
        GL11.glBegin((int)7);
        if (us.combat != null) {
            for (Combat.Side s : us.combat.sides) {
                for (Airship as : s.ships) {
                    this.drawBeamEndcaps(g, as, dir);
                }
            }
        }
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBlendFunc((int)770, (int)771);
        g.resetTransform();
        TextureImpl.bindNone();
        GL11.glDisable((int)3553);
    }

    public void drawBeams(Graphics g, Airship sh, int dir) {
        int msz = sh.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            int side;
            Module m = sh.modules.get(mi);
            if (!m.firingBeam) continue;
            BeamSpec bs = m.type.beamSpec(sh.currentBonuses);
            if (bs.lightClr == null) continue;
            Pt mz = m.currentMuzzle();
            double startX = mz.x;
            double startY = mz.y;
            double beamTimeProportion = (double)m.beamAge * 1.0 / (double)(bs.fadeInTime + bs.steadyTime + bs.fadeOutTime);
            double endX = (double)m.beamStartPositionX * (1.0 - beamTimeProportion) + (double)m.beamEndPositionX * beamTimeProportion;
            double endY = (double)m.beamStartPositionY * (1.0 - beamTimeProportion) + (double)m.beamEndPositionY * beamTimeProportion;
            double intensity = 1.0;
            if (m.beamAge < bs.fadeInTime) {
                intensity = (double)m.beamAge * 1.0 / (double)bs.fadeInTime;
            } else if (m.beamAge > bs.fadeInTime + bs.steadyTime && bs.fadeOutTime > 0) {
                intensity = 1.0 - (double)(m.beamAge - bs.fadeInTime - bs.steadyTime) * 1.0 / (double)bs.fadeOutTime;
            }
            float r = (float)((double)bs.lightRadius * intensity);
            double beamAngle = Math.atan2(endY - startY, endX - startX);
            double horizontal = Math.sin(beamAngle);
            double vertical = Math.sin(beamAngle + 1.5707963267948966);
            GL11.glColor3f((float)((float)bs.lightClr.r / 255.0f), (float)((float)bs.lightClr.g / 255.0f), (float)((float)bs.lightClr.b / 255.0f));
            int n = side = dir > 0 && dir < 3 ? -1 : 1;
            if (dir % 2 == 0 && endY > startY != endX > startX) {
                side *= -1;
            }
            if (endX < startX) {
                side *= -1;
            }
            GL11.glTexCoord2d((double)0.01f, (double)0.01f);
            GL11.glVertex2d((double)((float)startX), (double)((float)startY));
            GL11.glTexCoord2d((double)0.01f, (double)0.99f);
            GL11.glVertex2d((double)((float)endX), (double)((float)endY));
            GL11.glTexCoord2d((double)0.99f, (double)0.99f);
            GL11.glVertex2d((double)((double)((float)endX) + (double)r * horizontal * (double)side), (double)((double)((float)endY) - (double)r * vertical * (double)side));
            GL11.glTexCoord2d((double)0.99f, (double)0.01f);
            GL11.glVertex2d((double)((double)((float)startX) + (double)r * horizontal * (double)side), (double)((double)((float)startY) - (double)r * vertical * (double)side));
        }
    }

    public void drawBeamEndcaps(Graphics g, Airship sh, int dir) {
        int msz = sh.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            int side;
            Module m = sh.modules.get(mi);
            if (!m.firingBeam) continue;
            BeamSpec bs = m.type.beamSpec(sh.currentBonuses);
            if (bs.lightClr == null) continue;
            Pt mz = m.currentMuzzle();
            double startX = mz.x;
            double startY = mz.y;
            double beamTimeProportion = (double)m.beamAge * 1.0 / (double)(bs.fadeInTime + bs.steadyTime + bs.fadeOutTime);
            double endX = (double)m.beamStartPositionX * (1.0 - beamTimeProportion) + (double)m.beamEndPositionX * beamTimeProportion;
            double endY = (double)m.beamStartPositionY * (1.0 - beamTimeProportion) + (double)m.beamEndPositionY * beamTimeProportion;
            double intensity = 1.0;
            if (m.beamAge < bs.fadeInTime) {
                intensity = (double)m.beamAge * 1.0 / (double)bs.fadeInTime;
            } else if (m.beamAge > bs.fadeInTime + bs.steadyTime && bs.fadeOutTime > 0) {
                intensity = 1.0 - (double)(m.beamAge - bs.fadeInTime - bs.steadyTime) * 1.0 / (double)bs.fadeOutTime;
            }
            float r = (float)((double)bs.lightRadius * intensity);
            double beamAngle = Math.atan2(endY - startY, endX - startX);
            double horizontal = Math.sin(beamAngle);
            double horizontalAlong = Math.cos(beamAngle);
            double vertical = Math.sin(beamAngle + 1.5707963267948966);
            double verticalAlong = Math.cos(beamAngle + 1.5707963267948966);
            GL11.glColor3f((float)((float)bs.lightClr.r / 255.0f), (float)((float)bs.lightClr.g / 255.0f), (float)((float)bs.lightClr.b / 255.0f));
            int n = side = dir > 0 && dir < 3 ? -1 : 1;
            if (dir % 2 == 0 && endY > startY != endX > startX) {
                side *= -1;
            }
            if (endX < startX) {
                side *= -1;
            }
            GL11.glTexCoord2d((double)0.01f, (double)0.99f);
            GL11.glVertex2d((double)((float)endX), (double)((float)endY));
            GL11.glTexCoord2d((double)0.01f, (double)0.01f);
            GL11.glVertex2d((double)((double)((float)endX) + (double)r * horizontalAlong), (double)((double)((float)endY) - (double)r * verticalAlong));
            GL11.glTexCoord2d((double)0.99f, (double)0.01f);
            GL11.glVertex2d((double)((double)((float)endX) + (double)r * horizontalAlong + (double)r * horizontal * (double)side), (double)((double)((float)endY) - (double)r * verticalAlong - (double)r * vertical * (double)side));
            GL11.glTexCoord2d((double)0.99f, (double)0.99f);
            GL11.glVertex2d((double)((double)((float)endX) + (double)r * horizontal * (double)side), (double)((double)((float)endY) - (double)r * vertical * (double)side));
        }
    }

    public void draw(Graphics g, Airship sh, float srcX, float srcY, boolean outsideOnly) {
        int msz = sh.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = sh.modules.get(mi);
            if (!(m.glowAmt > 0.0)) continue;
            ArrayList<ModuleType.ModuleLightSource> lights = m.type.getLights(sh.currentBonuses);
            int lsz = lights.size();
            for (int li = 0; li < lsz; ++li) {
                ModuleType.ModuleLightSource mls = lights.get(li);
                if (outsideOnly && !mls.outside) continue;
                double mx = sh.getX() + (double)(sh.gridXToWorldX(m.x, m.type.getW()) * 16);
                mx = sh.flipped ? (mx += ((double)m.type.getW() - mls.xOffset) * 16.0) : (mx += mls.xOffset * 16.0);
                double my = sh.getY() + (double)(m.y * 16) + mls.yOffset * 16.0;
                double r = (double)mls.radius * m.glowAmt;
                GL11.glColor3f((float)((float)mls.clr.r / 255.0f), (float)((float)mls.clr.g / 255.0f), (float)((float)mls.clr.b / 255.0f));
                GL11.glTexCoord2d((double)srcX, (double)srcY);
                GL11.glVertex2d((double)((float)(mx - r)), (double)((float)(my - r)));
                GL11.glTexCoord2d((double)srcX, (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(mx - r)), (double)((float)(my + r)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(mx + r)), (double)((float)(my + r)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)srcY);
                GL11.glVertex2d((double)((float)(mx + r)), (double)((float)(my - r)));
            }
        }
        int dsz = sh.decals.size();
        for (int di = 0; di < dsz; ++di) {
            Decal d = sh.decals.get(di);
            if (!d.enabled) continue;
            ArrayList<DecalType.DecalLightSource> lights = d.type.lights;
            int lsz = lights.size();
            for (int li = 0; li < lsz; ++li) {
                DecalType.DecalLightSource dls = lights.get(li);
                double mx = sh.getX() + (double)(sh.gridXToWorldX(d.x, d.type.imgW) * 16);
                mx = sh.flipped ? (mx += ((double)d.type.imgW - dls.xOffset) * 16.0) : (mx += dls.xOffset * 16.0);
                double my = sh.getY() + (double)(d.y * 16) + dls.yOffset * 16.0;
                double r = dls.radius;
                GL11.glColor3f((float)((float)dls.clr.r / 255.0f), (float)((float)dls.clr.g / 255.0f), (float)((float)dls.clr.b / 255.0f));
                GL11.glTexCoord2d((double)srcX, (double)srcY);
                GL11.glVertex2d((double)((float)(mx - r)), (double)((float)(my - r)));
                GL11.glTexCoord2d((double)srcX, (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(mx - r)), (double)((float)(my + r)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(mx + r)), (double)((float)(my + r)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)srcY);
                GL11.glVertex2d((double)((float)(mx + r)), (double)((float)(my - r)));
            }
        }
    }
}

