/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.ConfirmDialog;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MissionCombatIntent;
import com.zarkonnen.airships.MissionSetupIntent;
import com.zarkonnen.airships.MissionsScreen;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.PlaybackIntent;
import com.zarkonnen.airships.SingleCombatIntent;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.io.IOException;

public strictfp class LeaveToMainMenuButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof SingleCombatSetupIntent || us.intent instanceof SingleCombatIntent || us.intent instanceof EditMissionIntent || us.intent instanceof MissionCombatIntent || us.intent instanceof MissionSetupIntent || us.intent instanceof PlaybackIntent;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Leave", new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        if (us.combat != null) {
            try {
                us.combat.saveRecording();
            }
            catch (IOException e) {
                e.printStackTrace();
                us.g.showError(Lang._t("Unable_to_save_combat_recording.", new Object[0]));
            }
        }
        if (us.intent instanceof SingleCombatIntent) {
            ((SingleCombatIntent)us.intent).leave(us);
        } else if (us.intent instanceof EditMissionIntent) {
            ((EditMissionIntent)us.intent).leave(us);
        } else if (us.intent instanceof MissionCombatIntent) {
            ((MissionCombatIntent)us.intent).leave(us);
        } else {
            us.confirmDialog = new ConfirmDialog(){

                @Override
                public String text() {
                    return Lang._t("Exit_combat_", new Object[0]);
                }

                @Override
                public String okText() {
                    return Lang._t("OK", new Object[0]);
                }

                @Override
                public String cancelText() {
                    return Lang._t("Cancel", new Object[0]);
                }

                @Override
                public void ok(UniScreen us) {
                    us.g.s = us.intent instanceof MissionSetupIntent ? new MissionsScreen(us.g) : (us.intent instanceof PlaybackIntent ? new MainMenu(us.g, MainMenu.Submenu.REPLAY) : new MainMenu(us.g, MainMenu.Submenu.DESIGN_AND_FIGHT));
                }

                @Override
                public void cancel(UniScreen us) {
                    us.confirmDialog = null;
                }
            };
        }
    }

    @Override
    public void tick(Input in, UniScreen us) {
        if (us.tool instanceof PlaceShipTool && ((PlaceShipTool)us.tool).multiPlace) {
            return;
        }
        if (us.intent instanceof PlaybackIntent && ((PlaybackIntent)us.intent).takeGifUntil != -1) {
            return;
        }
        if (us.tool == UniScreen.NAVIGATE && in.keyPressed("ESCAPE")) {
            this.click(in, us);
        }
    }

    @Override
    public String hotkey(UniScreen us) {
        return "L";
    }
}

