/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class LandscapeType
extends Loadable {
    public final ArrayList<CombatBackgroundFlavor> backgroundFlavors = new ArrayList();
    public final double hills;
    public final double treeDensity;
    public final double largeTreeP;
    public final double bushDensity;
    public final double specialGrassDensity;
    public final ArrayList<LandBlockType> specialGrasses = new ArrayList();
    public final double specialFloaterTopDensity;
    public final ArrayList<LandBlockType> specialFloaterTops = new ArrayList();
    public final ArrayList<Utils.Pair<Integer, TimeOfDay>> timesOfDay = new ArrayList();
    public final LandBlockType soil;
    public final LandBlockType rock;
    public final LandBlockType suspendiumOre;
    public final LandBlockType grass;
    public final LandBlockType bush;
    public final LandBlockType smallTreeRoot;
    public final LandBlockType smallTreeTrunk;
    public final LandBlockType smallTreeCrown;
    public final LandBlockType largeTreeRoot;
    public final LandBlockType largeTreeTrunk;
    public final LandBlockType largeTreeCrown;
    public final LandBlockType floaterTop;
    public final LandBlockType floaterUp;
    public final LandBlockType floaterMiddle;
    public final LandBlockType floaterDown;
    public final LandBlockType floaterDowner;
    public final LandBlockType floaterDownerRock;
    public final LandBlockType floaterDownerSuspendium;
    public final LandBlockType floaterBottom;

    public LandscapeType(JSONObject o) {
        super(o.getString("name"));
        int i;
        this.soil = LandBlockType.ofName(o.optString("soil", "SOIL"));
        this.rock = LandBlockType.ofName(o.optString("rock", "ROCK"));
        this.suspendiumOre = LandBlockType.ofName(o.optString("suspendiumOre", "SUSPENDIUM_ORE"));
        this.grass = LandBlockType.ofName(o.optString("grass", "GRASS"));
        this.bush = LandBlockType.ofName(o.optString("bush", "BUSH"));
        this.smallTreeRoot = LandBlockType.ofName(o.optString("smallTreeRoot", "THIN_TRUNK"));
        this.smallTreeTrunk = LandBlockType.ofName(o.optString("smallTreeTrunk", "THIN_TRUNK"));
        this.smallTreeCrown = LandBlockType.ofName(o.optString("smallTreeCrown", "SMALL_CROWN"));
        this.largeTreeRoot = LandBlockType.ofName(o.optString("largeTreeRoot", "ROOTS"));
        this.largeTreeTrunk = LandBlockType.ofName(o.optString("largeTreeTrunk", "TRUNK"));
        this.largeTreeCrown = LandBlockType.ofName(o.optString("largeTreeCrown", "CROWN"));
        this.floaterTop = LandBlockType.ofName(o.optString("floaterTop", "FLOATER_TOP"));
        this.floaterUp = LandBlockType.ofName(o.optString("floaterUp", "FLOATER_UP"));
        this.floaterMiddle = LandBlockType.ofName(o.optString("floaterMiddle", "FLOATER_MIDDLE"));
        this.floaterDown = LandBlockType.ofName(o.optString("floaterDown", "FLOATER_DOWN"));
        this.floaterDowner = LandBlockType.ofName(o.optString("floaterDowner", "FLOATER_DOWNER"));
        this.floaterDownerRock = LandBlockType.ofName(o.optString("floaterDownerRock", "FLOATER_DOWNER_ROCK"));
        this.floaterDownerSuspendium = LandBlockType.ofName(o.optString("floaterDownerSuspendium", "FLOATER_DOWNER_SUSPENDIUM"));
        this.floaterBottom = LandBlockType.ofName(o.optString("floaterBottom", "FLOATER_BOTTOM"));
        JSONArray a = o.getJSONArray("backgroundFlavors");
        for (i = 0; i < a.length(); ++i) {
            this.backgroundFlavors.add(CombatBackgroundFlavor.ofName(a.getString(i)));
        }
        this.hills = o.getDouble("hills");
        this.treeDensity = o.getDouble("treeDensity");
        this.largeTreeP = o.optDouble("largeTreeP", 1.0);
        this.bushDensity = o.optDouble("bushDensity");
        if (o.has("specialGrasses")) {
            a = o.getJSONArray("specialGrasses");
            for (i = 0; i < a.length(); ++i) {
                this.specialGrasses.add(LandBlockType.ofName(a.getString(i)));
            }
        }
        this.specialGrassDensity = this.specialGrasses.isEmpty() ? 0.0 : o.getDouble("specialGrassDensity");
        if (o.has("specialFloaterTops")) {
            a = o.getJSONArray("specialFloaterTops");
            for (i = 0; i < a.length(); ++i) {
                this.specialFloaterTops.add(LandBlockType.ofName(a.getString(i)));
            }
        }
        this.specialFloaterTopDensity = this.specialFloaterTops.isEmpty() ? 0.0 : o.getDouble("specialFloaterTopDensity");
        if (o.has("timesOfDay")) {
            a = o.getJSONArray("timesOfDay");
            for (i = 0; i < a.length(); ++i) {
                this.timesOfDay.add((Utils.Pair<Integer, TimeOfDay>)new Utils.Pair((Object)a.getJSONObject(i).getInt("spawnWeight"), (Object)TimeOfDay.ofName(a.getJSONObject(i).getString("name"))));
            }
        } else {
            for (TimeOfDay tod : Loadable.all(TimeOfDay.class)) {
                this.timesOfDay.add((Utils.Pair<Integer, TimeOfDay>)new Utils.Pair((Object)1, (Object)tod));
            }
        }
    }

    public static LandscapeType ofName(String name) {
        return Loadable.ofName(LandscapeType.class, name);
    }
}

