/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.EditMissionIntent;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceLandBlockTool;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import org.newdawn.slick.Graphics;

public strictfp class LandscapeEditorPanel
implements UniScreen.InfoPanel,
ScrollBar.ScrollElementAdapter<LandBlockType> {
    public boolean enabled = false;
    public boolean doRemoveTool = false;
    public int height;
    public int width;
    public static final int[] SIZES = new int[]{1, 2, 3, 5, 7, 9, 15};
    private final ScrollBar lbtsb = new ScrollBar();
    private UniScreen us;

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, final UniScreen us) {
        int h;
        this.us = us;
        if (us.hideUI) {
            return;
        }
        if (!this.enabled || !(us.intent instanceof DefencesIntent) && !(us.intent instanceof SingleCombatSetupIntent) && !(us.intent instanceof EditMissionIntent)) {
            return;
        }
        int x = MyDraw.SIDE_CLEARANCE;
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int col1W = 100;
        for (LandBlockType lbt : Loadable.all(LandBlockType.class)) {
            if (!lbt.canPlace && (!lbt.canPlaceInMissionEditor || !(us.intent instanceof EditMissionIntent) && !(us.intent instanceof SingleCombatSetupIntent))) continue;
            col1W = StrictMath.max(col1W, 16 + MyDraw.SCROLL_EL_SPACING + (int)d.textSize((String)Lang._t((String)"Place_x", (Object[])new Object[]{lbt.getName()}), (Fount)AGame.FOUNT).x);
        }
        col1W += MyDraw.PANEL_INSET * 2 + ScrollBar.SCROLL_BAR_W;
        int col2W = 60;
        for (int sz : SIZES) {
            col2W = StrictMath.max(col2W, d.tw(sz + "x" + sz));
        }
        int w = col1W + MyDraw.WINDOW_INSET * 2;
        if (us.intent instanceof EditMissionIntent || us.intent instanceof SingleCombatSetupIntent) {
            w += col2W + MyDraw.UI_SPACING;
        }
        this.height = h = StrictMath.max(sm.height / 3, (us.intent instanceof EditMissionIntent ? SIZES.length : 1) * (MyDraw.BUTTON_H + MyDraw.UI_SPACING) - MyDraw.UI_SPACING) + MyDraw.WINDOW_INSET * 2;
        this.width = w;
        d.drawWindow(x, y, w, h);
        x += MyDraw.WINDOW_INSET;
        y += MyDraw.WINDOW_INSET;
        w -= MyDraw.WINDOW_INSET * 2;
        h -= MyDraw.WINDOW_INSET * 2;
        ArrayList<LandBlockType> l = new ArrayList<LandBlockType>();
        for (LandBlockType lbt : Loadable.all(LandBlockType.class)) {
            if (!lbt.canPlace && (!lbt.canPlaceInMissionEditor || !(us.intent instanceof EditMissionIntent) && !(us.intent instanceof SingleCombatSetupIntent))) continue;
            l.add(lbt);
        }
        this.lbtsb.draw(d, x, y, col1W, h, l, this);
        if (us.intent instanceof EditMissionIntent || us.intent instanceof SingleCombatSetupIntent) {
            x += col1W + MyDraw.UI_SPACING;
            y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING + MyDraw.WINDOW_INSET;
            for (final int sz : SIZES) {
                d.toggle(x, y, col2W, sz + "x" + sz, null, new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        if (us.tool instanceof PlaceLandBlockTool) {
                            ((PlaceLandBlockTool)us.tool).size = sz;
                        }
                    }
                }, us.tool instanceof PlaceLandBlockTool && ((PlaceLandBlockTool)us.tool).size == sz, true);
                y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            }
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (this.doRemoveTool) {
            us.tool = UniScreen.NAVIGATE;
            this.doRemoveTool = false;
        }
        if (us.tool != UniScreen.NAVIGATE && in.keyPressed("ESCAPE")) {
            this.doRemoveTool = true;
            this.enabled = false;
        }
        this.lbtsb.tick(in, MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING, this.width, this.height);
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return Rect2D.contains(MyDraw.SIDE_CLEARANCE, MyDraw.TOP_BAR_H + MyDraw.UI_SPACING, this.width, this.height, cursor.x, cursor.y);
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }

    @Override
    public int getHeight(LandBlockType t, MyDraw d, int availableWidth) {
        return 16 + MyDraw.UI_SPACING;
    }

    @Override
    public void draw(final LandBlockType lbt, MyDraw d, int x, int y, int w) {
        if (lbt.app != null) {
            lbt.app.draw(d, x, y + 16 - lbt.app.height() * 16, 0, false);
        } else if (lbt == LandBlockType.ofName("AIR")) {
            d.blit(EditPalettePanel.REMOVE, x, y);
        }
        if (lbt.externalApp != null) {
            Graphics g = (Graphics)d.frame().nativeRenderer();
            int clipX = StrictMath.max(this.lbtsb.clipX, x - 3);
            int clipY = StrictMath.max(this.lbtsb.clipY, y - MyDraw.UI_SPACING + 1);
            int clipX2 = StrictMath.min(this.lbtsb.clipX + this.lbtsb.clipW, x + 16 + 3);
            int clipY2 = StrictMath.min(this.lbtsb.clipY + this.lbtsb.clipH, y + 16 + MyDraw.UI_SPACING - 1);
            g.setClip(clipX, clipY, clipX2 - clipX, clipY2 - clipY);
            lbt.externalApp.app.draw(d, x + lbt.externalApp.dx * 16, y + lbt.externalApp.dy * 16, 0, false);
            g.clearClip();
            g.setClip(this.lbtsb.clipX, this.lbtsb.clipY, this.lbtsb.clipW, this.lbtsb.clipH);
        }
        if (lbt == LandBlockType.ofName("AIR")) {
            d.text((this.us.tool instanceof PlaceLandBlockTool && ((PlaceLandBlockTool)this.us.tool).type == lbt ? MyDraw.SELECTED_C : "") + Lang._t("Remove", new Object[0]), AGame.FOUNT, x + 16 + MyDraw.SCROLL_EL_SPACING, y);
        } else {
            d.text((this.us.tool instanceof PlaceLandBlockTool && ((PlaceLandBlockTool)this.us.tool).type == lbt ? MyDraw.SELECTED_C : "") + Lang._t("Place_x", lbt.getName()), AGame.FOUNT, x + 16 + MyDraw.SCROLL_EL_SPACING, y);
        }
        d.hook(x, y, w, 16.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

            public void run(Input in, Pt p, Hook.Type type) {
                int size = 1;
                if (((LandscapeEditorPanel)LandscapeEditorPanel.this).us.tool instanceof PlaceLandBlockTool) {
                    size = ((PlaceLandBlockTool)((LandscapeEditorPanel)LandscapeEditorPanel.this).us.tool).size;
                }
                PlaceLandBlockTool t = new PlaceLandBlockTool(lbt);
                t.size = size;
                ((LandscapeEditorPanel)LandscapeEditorPanel.this).us.tool = t;
            }
        });
    }
}

