/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public strictfp abstract class LandFormationTool
extends UniScreen.Tool {
    public int size = 1;

    public void createLandFormation(UniScreen us, LandFormation lf) {
        if (us.combat != null) {
            us.combat.landFormations.add(lf);
            if (us.combat.physics != null) {
                us.combat.physics.bodies.add(lf);
            }
        } else if (us.city != null) {
            us.city.floaters.add(lf);
        } else if (us.setupFloaters != null) {
            us.setupFloaters.add(lf);
        }
    }

    public void destroyLandFormation(UniScreen us, LandFormation lf) {
        if (us.combat != null) {
            us.combat.landFormations.remove(lf);
        } else if (us.city != null) {
            us.city.floaters.remove(lf);
        } else if (us.setupFloaters != null) {
            us.setupFloaters.remove(lf);
        }
    }

    public ArrayList<LFTarget> target(UniScreen us, Pt p) {
        ArrayList<LFTarget> l = new ArrayList<LFTarget>();
        for (int y = 0; y < this.size; ++y) {
            for (int x = 0; x < this.size; ++x) {
                int offset = -this.size / 2;
                LFTarget t = this.ptTarget(us, new Pt(p.x + (double)((x + offset) * 16) * us.zoom, p.y + (double)((y + offset) * 16) * us.zoom));
                if (t == null) continue;
                l.add(t);
            }
        }
        return l;
    }

    public LFTarget ptTarget(UniScreen us, Pt p) {
        ArrayList others;
        LandFormation ground;
        if (us.combat != null) {
            ground = null;
            others = us.combat.landFormations;
        } else if (us.city != null) {
            ground = us.city.ground;
            others = us.city.floaters;
        } else {
            ground = us.setupGround;
            others = us.setupFloaters;
        }
        if (others != null) {
            for (int i = others.size() - 1; i >= 0; --i) {
                LandFormation lf = (LandFormation)others.get(i);
                int x = (int)StrictMath.floor((us.screenToWorldX(p.x) - lf.getX()) / 16.0);
                int y = (int)StrictMath.floor((us.screenToWorldY(p.y) - lf.getY()) / 16.0);
                if (lf.immobile && (x < 0 || x >= lf.grid[0].length || y >= lf.grid.length) || !lf.hasNonAirAt(x, y) && !lf.hasNonAirAt(x + 1, y) && !lf.hasNonAirAt(x - 1, y) && !lf.hasNonAirAt(x, y + 1) && !lf.hasNonAirAt(x, y - 1)) continue;
                return new LFTarget(lf, x, y);
            }
        }
        if (ground != null) {
            int x = (int)((us.screenToWorldX(p.x) - ground.getX()) / 16.0);
            int y = (int)((us.screenToWorldY(p.y) - ground.getY()) / 16.0);
            if (x < 0 || x >= ground.grid[0].length || y >= ground.grid.length) {
                return null;
            }
            if (ground.hasNonAirAt(x, y) || ground.hasNonAirAt(x + 1, y) || ground.hasNonAirAt(x - 1, y) || ground.hasNonAirAt(x, y + 1) || ground.hasNonAirAt(x, y - 1)) {
                return new LFTarget(ground, x, y);
            }
        }
        return null;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        ArrayList<LFTarget> lfts = this.target(us, cursor);
        d.scale(us.zoom, us.zoom);
        d.shift(us.adjScrollX, us.adjScrollY);
        this.drawScaled(d, us, lfts, cursor);
        d.resetTransforms();
        this.drawUnscaled(d, us, lfts, cursor);
    }

    public abstract void drawScaled(MyDraw var1, UniScreen var2, ArrayList<LFTarget> var3, Pt var4);

    public abstract void drawUnscaled(MyDraw var1, UniScreen var2, ArrayList<LFTarget> var3, Pt var4);

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        return this.click(in, us, this.target(us, click), click);
    }

    public abstract boolean click(Input var1, UniScreen var2, ArrayList<LFTarget> var3, Pt var4);

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        return this.rightClick(in, us, this.target(us, click), click);
    }

    public abstract boolean rightClick(Input var1, UniScreen var2, ArrayList<LFTarget> var3, Pt var4);

    @Override
    public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
        return this.mouseDown(in, us, this.target(us, click), click);
    }

    public abstract boolean mouseDown(Input var1, UniScreen var2, ArrayList<LFTarget> var3, Pt var4);

    public strictfp static class LFTarget {
        public final LandFormation lf;
        public final int x;
        public final int y;

        public LFTarget(LandFormation lf, int x, int y) {
            this.lf = lf;
            this.x = x;
            this.y = y;
        }
    }
}

