/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.ExternalApp;
import com.zarkonnen.airships.Foot;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.GridLocation;
import com.zarkonnen.airships.GridRef;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandscapeType;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.Perlin;
import com.zarkonnen.airships.PhysicsRect;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.TileMask;
import com.zarkonnen.airships.WheelBody;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.json.JSONObject;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;

public strictfp class LandFormation
extends GridBody
implements JSONAble {
    public LandscapeType landscapeType;
    LandBlockType[][] grid;
    int[][] hp;
    boolean immobile;
    transient boolean[][] destroy;
    transient int[][] phase;
    transient boolean[][] edge;
    transient ArrayList<GridLocation>[][] reachable;
    transient boolean ascCalced = false;
    transient int availableServiceCeiling = 0;
    transient ArrayList<Rect2D> rects = new ArrayList();
    transient int[][] chunkID;
    transient int[] heightMap;
    transient int[] opaqueHeightMap;
    transient boolean dirty = true;
    public static final int GROUND_LF_Y_OFFSET = 15;
    public static final int DISALLOWED = 0;
    public static final int ALLOWED = 1;
    public static final int REQUIRED = 2;
    static Clr[] CLRS = new Clr[]{Clr.BLUE, Clr.RED, Clr.GREEN, Clr.MAGENTA, Clr.CYAN, Clr.GREY, Clr.ORANGE};
    private static final int[][] PATCH9_SOLID = new int[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}};

    public LandFormation faithfulClone() {
        LandFormation lf2 = new LandFormation(this.getX(), this.getY(), this.grid[0].length, this.grid.length, this.landscapeType);
        lf2.immobile = this.immobile;
        lf2.dirty = this.dirty;
        lf2.rects.addAll(this.rects);
        lf2.availableServiceCeiling = this.availableServiceCeiling;
        lf2.ascCalced = this.ascCalced;
        System.arraycopy(this.heightMap, 0, lf2.heightMap, 0, this.heightMap.length);
        System.arraycopy(this.opaqueHeightMap, 0, lf2.opaqueHeightMap, 0, this.opaqueHeightMap.length);
        for (int y = 0; y < this.grid.length; ++y) {
            System.arraycopy(this.grid[y], 0, lf2.grid[y], 0, this.grid[y].length);
            System.arraycopy(this.hp[y], 0, lf2.hp[y], 0, this.hp[y].length);
            System.arraycopy(this.phase[y], 0, lf2.phase[y], 0, this.phase[y].length);
            System.arraycopy(this.destroy[y], 0, lf2.destroy[y], 0, this.destroy[y].length);
            System.arraycopy(this.edge[y], 0, lf2.edge[y], 0, this.edge[y].length);
            System.arraycopy(this.chunkID[y], 0, lf2.chunkID[y], 0, this.chunkID[y].length);
        }
        return lf2;
    }

    public LandFormation(JSONObject o, HashMap<Integer, LandBlockType>[] mappingRef) {
        this.setX(o.getDouble("x"));
        this.setY(o.getDouble("y"));
        this.setxSpeed(o.optDouble("xSpeed", 0.0));
        this.setySpeed(o.optDouble("ySpeed", 0.0));
        this.landscapeType = LandscapeType.ofName(o.optString("landscapeType", "GRASSLAND"));
        this.immobile = o.getBoolean("immobile");
        this.grid = new LandBlockType[o.getInt("h")][o.getInt("w")];
        this.hp = new int[this.grid.length][this.grid[0].length];
        this.destroy = new boolean[this.grid.length][this.grid[0].length];
        this.phase = new int[this.grid.length][this.grid[0].length];
        this.edge = new boolean[this.grid.length][this.grid[0].length];
        this.reachable = new ArrayList[this.grid.length][this.grid[0].length];
        this.chunkID = new int[this.grid.length][this.grid[0].length];
        this.heightMap = new int[this.grid[0].length];
        this.opaqueHeightMap = new int[this.grid[0].length];
        if (!o.optString("storage", "?").equals("hexString") && !o.optString("storage", "?").equals("base36CSV")) {
            throw new RuntimeException("Unknown data format for land formations. This file may be too new.");
        }
        String data = o.getString("data");
        ArrayList<LandBlockType> lbts = Loadable.all(LandBlockType.class);
        if (mappingRef[0] == null) {
            if (o.getString("storage").equals("hexString")) {
                mappingRef[0] = LandBlockType.OLD_MAPPING;
                System.err.println("Detect old mapping.");
            } else if (!this.immobile) {
                boolean has18To22 = false;
                int has18To22V = 0;
                boolean has23To28 = false;
                int has23To28V = 0;
                String[] bits = data.split(",");
                int dIndex = 0;
                block0: for (int gy = 0; gy < this.grid.length; ++gy) {
                    for (int gx = 0; gx < this.grid[0].length; ++gx) {
                        int value = Integer.parseInt(bits[dIndex], 36);
                        if (value > 35) {
                            mappingRef[0] = LandBlockType.V_1_0_10_MAPPING;
                            System.err.println("Detect v1.0.10 mapping from ID " + value + " > 35");
                            break block0;
                        }
                        if (value >= 23 && value <= 28) {
                            has23To28 = true;
                            has23To28V = value;
                        }
                        if (value >= 18 && value <= 22) {
                            has18To22 = true;
                            has18To22V = value;
                        }
                        if (has23To28 && has18To22) {
                            mappingRef[0] = LandBlockType.V_1_0_10_MAPPING;
                            System.err.println("Detect v1.0.10 mapping from IDs " + has18To22V + " and " + has23To28V);
                            break block0;
                        }
                        ++dIndex;
                    }
                }
            }
        }
        if (o.getString("storage").equals("hexString")) {
            int dIndex = 0;
            for (int gy = 0; gy < this.grid.length; ++gy) {
                for (int gx = 0; gx < this.grid[0].length; ++gx) {
                    this.phase[gy][gx] = AGame.ANIM_R.nextInt(1000);
                    this.grid[gy][gx] = lbts.get(Integer.parseInt(data.substring(dIndex, dIndex + 1), 16));
                    ++dIndex;
                }
            }
        } else {
            HashMap<Integer, LandBlockType> mapping = mappingRef[0] == null ? LandBlockType.OLD_MAPPING : mappingRef[0];
            String[] bits = data.split(",");
            int dIndex = 0;
            for (int gy = 0; gy < this.grid.length; ++gy) {
                for (int gx = 0; gx < this.grid[0].length; ++gx) {
                    this.phase[gy][gx] = AGame.ANIM_R.nextInt(1000);
                    this.grid[gy][gx] = mapping.get(Integer.parseInt(bits[dIndex], 36));
                    ++dIndex;
                }
            }
        }
        if (o.has("hpData")) {
            int dIndex = 0;
            String hpData = o.getString("hpData");
            for (int gy = 0; gy < this.grid.length; ++gy) {
                for (int gx = 0; gx < this.grid[0].length; ++gx) {
                    this.hp[gy][gx] = Integer.parseInt(hpData.substring(dIndex, dIndex + 1), 36);
                    ++dIndex;
                }
            }
        } else {
            for (int gy = 0; gy < this.grid.length; ++gy) {
                for (int gx = 0; gx < this.grid[0].length; ++gx) {
                    this.hp[gy][gx] = this.grid[gy][gx].hp;
                }
            }
        }
        this.crop();
    }

    @Override
    public JSONObject toJSON() {
        ArrayList<LandBlockType> lbts = Loadable.all(LandBlockType.class);
        JSONObject o = new JSONObject().put("landscapeType", this.landscapeType.name).put("storage", "base36CSV").put("h", this.grid.length).put("w", this.grid[0].length).put("x", this.getX()).put("y", this.getY()).put("immobile", this.immobile).put("xSpeed", this.getxSpeed()).put("ySpeed", this.getySpeed());
        StringBuilder data = new StringBuilder();
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                data.append(Integer.toString(lbts.indexOf(this.grid[gy][gx]), 36)).append(",");
            }
        }
        o.put("data", data.toString());
        StringBuilder hpData = new StringBuilder();
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                hpData.append(Integer.toString(this.hp[gy][gx], 36));
            }
        }
        o.put("hpData", hpData.toString());
        return o;
    }

    public LandFormation(double x, double y, LandBlockType[][] grid, LandscapeType landscapeType) {
        this.setX(x);
        this.setY(y);
        this.landscapeType = landscapeType;
        this.grid = grid;
        this.hp = new int[grid.length][grid[0].length];
        this.destroy = new boolean[grid.length][grid[0].length];
        this.phase = new int[grid.length][grid[0].length];
        this.edge = new boolean[grid.length][grid[0].length];
        this.reachable = new ArrayList[grid.length][grid[0].length];
        this.chunkID = new int[grid.length][grid[0].length];
        this.heightMap = new int[grid[0].length];
        this.opaqueHeightMap = new int[grid[0].length];
        for (int gy = 0; gy < grid.length; ++gy) {
            for (int gx = 0; gx < grid[0].length; ++gx) {
                this.phase[gy][gx] = AGame.ANIM_R.nextInt(1000);
                this.hp[gy][gx] = grid[gy][gx].hp;
            }
        }
    }

    public LandFormation(double x, double y, int w, int h, LandscapeType landscapeType) {
        this.setX(x);
        this.setY(y);
        this.landscapeType = landscapeType;
        this.grid = new LandBlockType[h][w];
        this.hp = new int[h][w];
        this.destroy = new boolean[h][w];
        this.phase = new int[h][w];
        this.edge = new boolean[h][w];
        this.reachable = new ArrayList[h][w];
        this.chunkID = new int[h][w];
        this.heightMap = new int[this.grid[0].length];
        this.opaqueHeightMap = new int[this.grid[0].length];
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                this.grid[gy][gx] = LandBlockType.ofName("AIR");
                this.phase[gy][gx] = AGame.ANIM_R.nextInt(1000);
                this.hp[gy][gx] = this.grid[gy][gx].hp;
            }
        }
    }

    public ArrayList<BlockDelta> getDeltaTo(LandFormation lf2) {
        int gridXShift = (int)StrictMath.round((lf2.getX() - this.getX()) / 16.0);
        int gridYShift = (int)StrictMath.round((lf2.getY() - this.getY()) / 16.0);
        ArrayList<BlockDelta> ds = new ArrayList<BlockDelta>();
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                int lf2gx = gx - gridXShift;
                int lf2gy = gy - gridYShift;
                if (lf2gx < 0 || lf2gx >= lf2.grid[0].length || lf2gy < 0 || lf2gy >= lf2.grid.length || this.grid[gy][gx] == lf2.grid[lf2gy][lf2gx]) continue;
                ds.add(new BlockDelta(gx, gy, lf2.grid[lf2gy][lf2gx]));
            }
        }
        return ds;
    }

    public void applyDeltas(ArrayList<ArrayList<BlockDelta>> deltas) {
        for (ArrayList<BlockDelta> ds : deltas) {
            for (BlockDelta d : ds) {
                this.grid[d.gy][d.gx] = d.t;
                this.hp[d.gy][d.gx] = this.grid[d.gy][d.gx].hp;
            }
        }
        this.crop();
    }

    public int getVerticalPosition(Airship building, int tx, boolean flipped, boolean ignoreSoftThings) {
        if (this.getX() > (double)tx + building.getBBWidth() || (double)tx > this.getX() + this.getBBWidth()) {
            return (int)building.getY();
        }
        int[] hm = ignoreSoftThings ? this.opaqueHeightMap : this.heightMap;
        double targetY = this.getY() - building.getBBHeight() + this.getBBHeight();
        for (int shipGridX = 0; shipGridX < building.getWidth(); ++shipGridX) {
            int shipGridY;
            int sgx2 = flipped ? building.getWidth() - shipGridX - 1 : shipGridX;
            for (shipGridY = building.getHeight() - 1; shipGridY >= 0 && building.tileAt(sgx2, shipGridY) == null; --shipGridY) {
            }
            double leftX = tx + shipGridX * 16;
            targetY = StrictMath.min(targetY, this.yBoundaryAt(leftX, hm) - (double)(shipGridY * 16) - 16.0);
            double rightX = tx + shipGridX * 16 + 16;
            targetY = StrictMath.min(targetY, this.yBoundaryAt(rightX, hm) - (double)(shipGridY * 16) - 16.0);
        }
        return (int)StrictMath.ceil(targetY) - 1;
    }

    public Utils.Pair<Integer, Integer> getLandscapingPlacementGYandCost(Airship building, double tx, boolean flipped, ShipList otherShips, int sideToRestrictTo) {
        int minPlacementGridY = this.grid.length - 1;
        int maxPlacementGridY = 0;
        int minPlacementGridX = this.grid[0].length - 1;
        int maxPlacementGridX = 0;
        for (int bgx = 0; bgx < building.getWidth(); ++bgx) {
            Tile t = building.tileAt(flipped ? building.getWidth() - bgx - 1 : bgx, building.getHeight() - 1);
            if (t == null) continue;
            int lgx = (int)StrictMath.floor((tx + (double)(bgx * 16) - this.getX()) / 16.0);
            minPlacementGridX = StrictMath.min(minPlacementGridX, lgx);
            maxPlacementGridX = StrictMath.max(maxPlacementGridX, lgx + 1);
            int leftLevel = this.firstSolidBlockYAt(lgx);
            int rightLevel = this.firstSolidBlockYAt(lgx + 1);
            maxPlacementGridY = StrictMath.max(maxPlacementGridY, StrictMath.max(leftLevel, rightLevel));
            minPlacementGridY = StrictMath.min(minPlacementGridY, StrictMath.min(leftLevel, rightLevel));
        }
        maxPlacementGridY = StrictMath.min(this.grid.length - 1, maxPlacementGridY);
        maxPlacementGridX = StrictMath.min(this.grid[0].length - 1, maxPlacementGridX);
        int bestGridY = -1;
        int bestCost = 0;
        block1: for (int gy = StrictMath.max(0, minPlacementGridY); gy <= maxPlacementGridY; ++gy) {
            int cost = 0;
            for (int ngy = 0; ngy < gy; ++ngy) {
                for (int ngx = StrictMath.max(0, minPlacementGridX); ngx <= StrictMath.min(this.grid[0].length - 1, maxPlacementGridX); ++ngx) {
                    LandBlockType lbt = this.grid[ngy][ngx];
                    cost += lbt.removeCost;
                }
            }
            boolean canSkipSoilBelow = true;
            for (int pgx = StrictMath.max(0, minPlacementGridX); pgx <= StrictMath.min(this.grid[0].length - 1, maxPlacementGridX); ++pgx) {
                LandBlockType lbt = this.grid[gy][pgx];
                canSkipSoilBelow &= lbt.opaque;
            }
            if (!canSkipSoilBelow) {
                for (int pgy = gy; pgy < this.grid.length; ++pgy) {
                    int downPyramid = pgy - gy;
                    for (int pgx = StrictMath.max(0, minPlacementGridX - downPyramid); pgx <= StrictMath.min(this.grid[0].length - 1, maxPlacementGridX + downPyramid); ++pgx) {
                        LandBlockType lbt = this.grid[pgy][pgx];
                        if (lbt.solid) continue;
                        if (otherShips != null) {
                            for (int i = 0; i < otherShips.size(); ++i) {
                                int placeY0;
                                int placeX0;
                                Airship sh = otherShips.get(i);
                                if (sh != building && (sh.solidAt(placeX0 = (int)StrictMath.floor((this.getX() + (double)(pgx * 16) - sh.getX()) / 16.0), placeY0 = (int)StrictMath.floor((this.getY() + (double)(pgy * 16) - sh.getY()) / 16.0)) || sh.solidAt(placeX0 + 1, placeY0 + 1) || sh.solidAt(placeX0 + 1, placeY0) || sh.solidAt(placeX0, placeY0 + 1))) continue block1;
                            }
                        }
                        if (sideToRestrictTo != -1) {
                            double placeGlobalX0 = this.getX() + (double)(pgx * 16);
                            double placeGlobalX1 = placeGlobalX0 + 16.0;
                            if (sideToRestrictTo == 0 && (placeGlobalX0 < -3200.0 || placeGlobalX1 > -100.0) || sideToRestrictTo == 1 && (placeGlobalX0 < 100.0 || placeGlobalX1 > 3200.0)) continue block1;
                        }
                        cost += lbt.removeCost + LandBlockType.ofName((String)"SOIL").addCost;
                    }
                }
            }
            if (cost >= bestCost && bestGridY != -1) continue;
            bestGridY = gy;
            bestCost = cost;
        }
        if (bestGridY == -1) {
            return null;
        }
        return new Utils.Pair((Object)bestGridY, (Object)bestCost);
    }

    public void doLandscapingForBuilding(Airship building, double tx, int gy, boolean flipped) {
        int minPlacementGridX = this.grid[0].length - 1;
        int maxPlacementGridX = 0;
        for (int bgx = 0; bgx < building.getWidth(); ++bgx) {
            Tile t = building.tileAt(flipped ? building.getWidth() - bgx - 1 : bgx, building.getHeight() - 1);
            if (t == null) continue;
            int lgx = (int)StrictMath.floor((tx + (double)(bgx * 16) - this.getX()) / 16.0);
            minPlacementGridX = StrictMath.min(minPlacementGridX, lgx);
            maxPlacementGridX = StrictMath.max(maxPlacementGridX, lgx + 1);
        }
        maxPlacementGridX = StrictMath.min(this.grid[0].length - 1, maxPlacementGridX);
        for (int ngy = 0; ngy < gy; ++ngy) {
            for (int ngx = StrictMath.max(0, minPlacementGridX); ngx <= StrictMath.min(this.grid[0].length - 1, maxPlacementGridX); ++ngx) {
                this.grid[ngy][ngx] = LandBlockType.ofName("AIR");
            }
        }
        boolean canSkipSoilBelow = true;
        for (int pgx = StrictMath.max(0, minPlacementGridX); pgx <= StrictMath.min(this.grid[0].length - 1, maxPlacementGridX); ++pgx) {
            LandBlockType lbt = this.grid[gy][pgx];
            canSkipSoilBelow &= lbt.opaque;
        }
        if (!canSkipSoilBelow) {
            for (int pgy = gy; pgy < this.grid.length; ++pgy) {
                int downPyramid = pgy - gy;
                for (int pgx = StrictMath.max(0, minPlacementGridX - downPyramid); pgx <= StrictMath.min(this.grid[0].length - 1, maxPlacementGridX + downPyramid); ++pgx) {
                    LandBlockType lbt = this.grid[pgy][pgx];
                    if (lbt.opaque) continue;
                    this.grid[pgy][pgx] = LandBlockType.ofName("SOIL");
                }
            }
        }
        this.crop();
    }

    public static Utils.Pair<LandFormation, List<LandFormation>> generate(Random r, boolean forMultiplayer, LandscapeType type) {
        LandFormation ground = new LandFormation(-3200.0, 272.0, 400, 26, type);
        ground.generateGround(r, forMultiplayer, type);
        ArrayList<LandFormation> floaters = new ArrayList<LandFormation>();
        int nf = r.nextInt(forMultiplayer ? 10 : 6);
        block0: for (int i = 0; i < nf; ++i) {
            LandFormation f = new LandFormation(-3200 + r.nextInt(6192), 0.0, 5 + r.nextInt(16), 20, type);
            f.generateFloater(r, type);
            f.setY(512 - f.availableServiceCeiling());
            if (Rect2D.intersects(f.getX(), f.getY(), f.getBBWidth(), f.getBBHeight(), ground.getX(), ground.getY(), ground.getBBWidth(), 10000.0)) continue;
            for (LandFormation f2 : floaters) {
                if (!Rect2D.intersects(f.getX(), f.getY(), f.getBBWidth(), f.getBBHeight(), f2.getX(), f2.getY(), f2.getBBWidth(), f2.getBBHeight())) continue;
                continue block0;
            }
            if (forMultiplayer && (f.getX() < -132.0 || f.getX() + f.getBBWidth() > 232.0)) continue;
            floaters.add(f);
        }
        return new Utils.Pair((Object)ground, floaters);
    }

    public void generateGround(Random r, boolean forMultiplayer, LandscapeType type) {
        int gy;
        int gx;
        this.immobile = true;
        Perlin perlin = new Perlin(r);
        for (int gy2 = this.grid.length - 1; gy2 >= 10; --gy2) {
            for (int gx2 = 0; gx2 < this.grid[0].length; ++gx2) {
                if (gy2 == this.grid.length - 1) {
                    this.grid[gy2][gx2] = LandBlockType.ofName("BEDROCK");
                } else {
                    double amt = (double)(gy2 - 10) * 2.5 / (double)this.grid.length + perlin.pnoise((double)gx2 * (forMultiplayer ? 0.015 : 0.03), (double)gy2 * 0.05, (double)(gx2 * gy2) * 1.0E-5) * type.hills - 0.1 + type.hills * 0.1;
                    if (amt > 0.7) {
                        amt += perlin.pnoise((double)gy2 * 0.2 + 0.31, (double)gx2 * 0.35 + 0.22, 33.39) * 0.6;
                    }
                    this.grid[gy2][gx2] = amt > 2.5 ? type.suspendiumOre : (amt > 1.5 ? type.rock : (amt > 0.3 ? type.soil : LandBlockType.ofName("AIR")));
                    if (this.grid[gy2 + 1][gx2] == LandBlockType.ofName("AIR")) {
                        this.grid[gy2][gx2] = LandBlockType.ofName("AIR");
                    }
                    if (this.grid[gy2 + 1][gx2] == type.soil && this.grid[gy2][gx2] == LandBlockType.ofName("AIR")) {
                        this.grid[gy2 + 1][gx2] = type.grass;
                    }
                    if (this.grid[gy2][gx2] == type.soil && gy2 == 10) {
                        this.grid[gy2][gx2] = type.grass;
                    }
                }
                this.phase[gy2][gx2] = AGame.ANIM_R.nextInt(1000);
                this.hp[gy2][gx2] = this.grid[gy2][gx2].hp;
            }
        }
        for (gx = 0; gx < this.grid[0].length; ++gx) {
            for (gy = this.grid.length - 2; gy >= 2; --gy) {
                if (this.grid[gy][gx] != LandBlockType.ofName("AIR") || (gx <= 0 || this.grid[gy - 1][gx - 1] == LandBlockType.ofName("AIR")) && (gx >= this.grid[0].length - 1 || this.grid[gy - 1][gx + 1] == LandBlockType.ofName("AIR"))) continue;
                this.grid[gy][gx] = type.grass;
                this.grid[gy + 1][gx] = type.grass;
            }
        }
        block4: for (gx = 0; gx < this.grid[0].length; ++gx) {
            for (gy = 0; gy < this.grid.length; ++gy) {
                LandBlockType lbt;
                if (this.grid[gy][gx] != type.grass) continue;
                if (!(r.nextDouble() < type.specialGrassDensity)) continue block4;
                this.grid[gy][gx] = lbt = type.specialGrasses.get(r.nextInt(type.specialGrasses.size()));
                this.hp[gy][gx] = lbt.hp;
                continue block4;
            }
        }
        for (gx = 5; gx < this.grid[0].length - 5; ++gx) {
            int gy2;
            int h;
            if (!(r.nextDouble() < type.treeDensity)) continue;
            gy = 0;
            while (!this.grid[gy + 1][gx].solid) {
                ++gy;
            }
            if (gy > 13 && forMultiplayer || this.grid[gy + 1][gx] != type.grass) continue;
            if (r.nextDouble() < type.largeTreeP) {
                h = 2 + r.nextInt(2);
                for (gy2 = gy - h; gy2 <= gy; ++gy2) {
                    this.grid[gy2][gx] = gy2 == gy - h ? type.largeTreeCrown : (gy2 == gy ? type.largeTreeRoot : type.largeTreeTrunk);
                    this.phase[gy2][gx] = AGame.ANIM_R.nextInt(1000);
                    this.hp[gy2][gx] = this.grid[gy2][gx].hp;
                }
                gx += 7;
                continue;
            }
            h = 1 + r.nextInt(2);
            for (gy2 = gy - h; gy2 <= gy; ++gy2) {
                this.grid[gy2][gx] = gy2 == gy - h ? type.smallTreeCrown : (gy2 == gy ? type.smallTreeRoot : type.smallTreeTrunk);
                this.phase[gy2][gx] = AGame.ANIM_R.nextInt(1000);
                this.hp[gy2][gx] = this.grid[gy2][gx].hp;
            }
            gx += 3;
        }
        for (gx = 0; gx < this.grid[0].length; ++gx) {
            if (!(r.nextDouble() < type.bushDensity)) continue;
            gy = 0;
            while (!this.grid[gy + 1][gx].solid) {
                ++gy;
            }
            if (this.grid[gy + 1][gx] != type.grass || gy > 13 && forMultiplayer) continue;
            this.grid[gy][gx] = type.bush;
            this.phase[gy][gx] = AGame.ANIM_R.nextInt(1000);
            this.hp[gy][gx] = this.grid[gy][gx].hp;
        }
        this.crop();
    }

    public void generateFloater(Random r, LandscapeType type) {
        for (int gx = 0; gx < this.grid[0].length; ++gx) {
            int depth = 1 + (int)(StrictMath.sin((double)gx * Math.PI / (double)this.grid[0].length) * 2.0) + r.nextInt(2);
            for (int gy = 10; gy < 10 + depth; ++gy) {
                this.grid[gy][gx] = gy == 9 + depth ? type.floaterBottom : type.floaterDowner;
            }
        }
        LandBlockType[][] layers = new LandBlockType[][]{{type.floaterTop}, {type.floaterUp, type.floaterUp, type.floaterMiddle}, {type.floaterUp, type.floaterMiddle}, {type.floaterMiddle, type.floaterDown}, {type.floaterDowner, type.floaterDown}, {type.floaterDowner, type.floaterDowner, type.floaterDown}};
        LandBlockType[][] layersSpecials = new LandBlockType[][]{new LandBlockType[0], new LandBlockType[0], new LandBlockType[0], new LandBlockType[0], {type.floaterDownerRock, type.floaterDownerRock, type.floaterDownerSuspendium}, {type.floaterDownerRock, type.floaterDownerSuspendium}};
        double specialP = 0.12;
        for (int gx = 0; gx < this.grid[0].length; ++gx) {
            int height = 1 + (int)(StrictMath.sin((double)gx * Math.PI / (double)this.grid[0].length) * 5.0);
            for (int hi = 0; hi < height; ++hi) {
                int gy = 10 - height + hi;
                LandBlockType[] rainTypes = layers[hi * 6 / height];
                LandBlockType t = rainTypes[r.nextInt(rainTypes.length)];
                if (t == type.floaterTop && r.nextDouble() < type.specialFloaterTopDensity) {
                    t = type.specialFloaterTops.get(r.nextInt(type.specialFloaterTops.size()));
                } else {
                    LandBlockType[] layerSpecials = layersSpecials[hi * 6 / height];
                    if (layerSpecials.length != 0 && r.nextDouble() < specialP) {
                        t = layerSpecials[r.nextInt(layerSpecials.length)];
                    }
                }
                this.grid[gy][gx] = t;
            }
        }
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                this.phase[gy][gx] = AGame.ANIM_R.nextInt(1000);
                this.hp[gy][gx] = this.grid[gy][gx].hp;
            }
        }
        try {
            int h = this.grid.length;
            int w = this.grid[0].length;
            this.crop();
            if (this.grid.length == 0 || this.grid[0].length == 0) {
                this.grid = new LandBlockType[h][w];
                this.hp = new int[h][w];
                this.destroy = new boolean[h][w];
                this.phase = new int[h][w];
                this.edge = new boolean[h][w];
                this.reachable = new ArrayList[h][w];
                this.chunkID = new int[h][w];
                for (int gy = 0; gy < this.grid.length; ++gy) {
                    for (int gx = 0; gx < this.grid[0].length; ++gx) {
                        this.grid[gy][gx] = LandBlockType.ofName("AIR");
                        this.phase[gy][gx] = AGame.ANIM_R.nextInt(1000);
                    }
                }
                this.generateFloater(r, type);
            }
        }
        catch (NegativeArraySizeException e) {
            this.generateFloater(r, type);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.generateFloater(r, type);
        }
    }

    public void generateLowFloater(Random r, LandscapeType type) {
        for (int gx = 0; gx < this.grid[0].length; ++gx) {
            int depth = 1 + (int)(StrictMath.sin((double)gx * Math.PI / (double)this.grid[0].length) * 2.0) + r.nextInt(2);
            for (int gy = 10; gy < 9 + depth; ++gy) {
                this.grid[gy][gx] = gy == 8 + depth ? type.floaterBottom : type.floaterDowner;
            }
        }
        LandBlockType[][] layers = new LandBlockType[][]{{type.floaterTop}, {type.floaterUp, type.floaterUp, type.floaterMiddle}, {type.floaterUp, type.floaterUp}, {type.floaterUp, type.floaterUp, type.floaterMiddle}, {type.floaterDown, type.floaterMiddle, type.floaterMiddle}};
        LandBlockType[][] layersSpecials = new LandBlockType[][]{new LandBlockType[0], new LandBlockType[0], new LandBlockType[0], new LandBlockType[0], {type.floaterDownerRock, type.floaterDownerRock, type.floaterDownerSuspendium}, {type.floaterDownerRock, type.floaterDownerSuspendium}};
        double specialP = 0.12;
        for (int gx = 0; gx < this.grid[0].length; ++gx) {
            int height = 3 + (int)(StrictMath.sin((double)gx * Math.PI / (double)this.grid[0].length) * 3.0);
            for (int hi = 0; hi < height; ++hi) {
                int gy = 10 - height + hi;
                LandBlockType[] rainTypes = layers[hi * 6 / height];
                LandBlockType t = rainTypes[r.nextInt(rainTypes.length)];
                if (t == type.floaterTop && r.nextDouble() < type.specialFloaterTopDensity) {
                    t = type.specialFloaterTops.get(r.nextInt(type.specialFloaterTops.size()));
                } else {
                    LandBlockType[] layerSpecials = layersSpecials[hi * 6 / height];
                    if (layerSpecials.length != 0 && r.nextDouble() < specialP) {
                        t = layerSpecials[r.nextInt(layerSpecials.length)];
                    }
                }
                this.grid[gy][gx] = t;
            }
        }
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                this.phase[gy][gx] = AGame.ANIM_R.nextInt(1000);
                this.hp[gy][gx] = this.grid[gy][gx].hp;
            }
        }
        try {
            int h = this.grid.length;
            int w = this.grid[0].length;
            this.crop();
            if (this.grid.length == 0 || this.grid[0].length == 0) {
                this.grid = new LandBlockType[h][w];
                this.hp = new int[h][w];
                this.destroy = new boolean[h][w];
                this.phase = new int[h][w];
                this.edge = new boolean[h][w];
                this.reachable = new ArrayList[h][w];
                this.chunkID = new int[h][w];
                for (int gy = 0; gy < this.grid.length; ++gy) {
                    for (int gx = 0; gx < this.grid[0].length; ++gx) {
                        this.grid[gy][gx] = LandBlockType.ofName("AIR");
                        this.phase[gy][gx] = AGame.ANIM_R.nextInt(1000);
                    }
                }
                this.generateFloater(r, type);
            }
        }
        catch (NegativeArraySizeException e) {
            this.generateLowFloater(r, type);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.generateLowFloater(r, type);
        }
    }

    public void setTileType(LandBlockType lbt, int gx, int gy) {
        int addTop = StrictMath.max(0, -gy);
        int addBottom = StrictMath.max(0, gy - this.grid.length + 1);
        int addLeft = StrictMath.max(0, -gx);
        int addRight = StrictMath.max(0, gx - this.grid[0].length + 1);
        if (addTop != 0 || addBottom != 0) {
            LandBlockType[][] grid2 = new LandBlockType[this.grid.length + addTop + addBottom][this.grid[0].length];
            System.arraycopy(this.grid, 0, grid2, addTop, this.grid.length);
            for (int gy2 = 0; gy2 < grid2.length; ++gy2) {
                if (gy2 >= addTop && gy2 < this.grid.length + addTop) continue;
                for (int gx2 = 0; gx2 < this.grid[0].length; ++gx2) {
                    grid2[gy2][gx2] = LandBlockType.ofName("AIR");
                }
            }
            this.grid = grid2;
            int[][] hp2 = new int[this.hp.length + addTop + addBottom][this.hp[0].length];
            System.arraycopy(this.hp, 0, hp2, addTop, this.hp.length);
            this.hp = hp2;
            int[][] phase2 = new int[this.phase.length + addTop + addBottom][this.phase[0].length];
            System.arraycopy(this.phase, 0, phase2, addTop, this.phase.length);
            for (int gy2 = 0; gy2 < phase2.length; ++gy2) {
                if (gy2 >= addTop && gy2 < this.phase.length + addTop) continue;
                for (int gx2 = 0; gx2 < this.phase[0].length; ++gx2) {
                    phase2[gy2][gx2] = AGame.ANIM_R.nextInt(1000);
                }
            }
            this.phase = phase2;
        }
        if (addLeft != 0 || addRight != 0) {
            Object[] newRow;
            int gy2;
            for (gy2 = 0; gy2 < this.grid.length; ++gy2) {
                newRow = new LandBlockType[this.grid[gy2].length + addLeft + addRight];
                System.arraycopy(this.grid[gy2], 0, newRow, addLeft, this.grid[gy2].length);
                for (int gx2 = 0; gx2 < newRow.length; ++gx2) {
                    if (gx2 >= addLeft && gx2 < this.grid[gy2].length + addLeft) continue;
                    newRow[gx2] = LandBlockType.ofName("AIR");
                }
                this.grid[gy2] = newRow;
            }
            for (gy2 = 0; gy2 < this.hp.length; ++gy2) {
                newRow = new int[this.hp[gy2].length + addLeft + addRight];
                System.arraycopy(this.hp[gy2], 0, newRow, addLeft, this.hp[gy2].length);
                this.hp[gy2] = (int[])newRow;
            }
            for (gy2 = 0; gy2 < this.phase.length; ++gy2) {
                newRow = new int[this.phase[gy2].length + addLeft + addRight];
                System.arraycopy(this.phase[gy2], 0, newRow, addLeft, this.phase[gy2].length);
                for (int gx2 = 0; gx2 < newRow.length; ++gx2) {
                    if (gx2 >= addLeft && gx2 < this.phase[gy2].length + addLeft) continue;
                    newRow[gx2] = (LandBlockType)AGame.ANIM_R.nextInt(1000);
                }
                this.phase[gy2] = (int[])newRow;
            }
        }
        if (addTop != 0 || addBottom != 0 || addLeft != 0 || addRight != 0) {
            this.destroy = new boolean[this.destroy.length + addTop + addBottom][this.destroy[0].length + addLeft + addRight];
            this.edge = new boolean[this.edge.length + addTop + addBottom][this.edge[0].length + addLeft + addRight];
            this.reachable = new ArrayList[this.reachable.length + addTop + addBottom][this.reachable[0].length + addLeft + addRight];
            this.chunkID = new int[this.chunkID.length + addTop + addBottom][this.chunkID[0].length + addLeft + addRight];
        }
        this.grid[gy + addTop][gx + addLeft] = lbt;
        this.setY(this.getY() - (double)(addTop * 16));
        this.setX(this.getX() - (double)(addLeft * 16));
        this.crop();
    }

    public void crop() {
        int gy;
        int gx;
        this.ascCalced = false;
        block0: for (gx = 0; gx < this.grid[0].length; ++gx) {
            for (int gy2 = 0; gy2 < this.grid.length; ++gy2) {
                if (this.grid[gy2][gx] != LandBlockType.ofName("AIR")) break block0;
            }
        }
        int cropLeftAmt = gx;
        block2: for (gx = this.grid[0].length - 1; gx >= 0; --gx) {
            for (int gy3 = 0; gy3 < this.grid.length; ++gy3) {
                if (this.grid[gy3][gx] != LandBlockType.ofName("AIR")) break block2;
            }
        }
        int cropRightAmt = this.grid[0].length - 1 - gx;
        block4: for (gy = 0; gy < this.grid.length; ++gy) {
            for (gx = 0; gx < this.grid[0].length; ++gx) {
                if (this.grid[gy][gx] != LandBlockType.ofName("AIR")) break block4;
            }
        }
        int cropTopAmt = gy;
        block6: for (gy = this.grid.length - 1; gy >= 0; --gy) {
            for (gx = 0; gx < this.grid[0].length; ++gx) {
                if (this.grid[gy][gx] != LandBlockType.ofName("AIR")) break block6;
            }
        }
        int cropBottomAmt = this.grid.length - 1 - gy;
        this.setY(this.getY() + (double)(cropTopAmt * 16));
        if (this.grid.length - cropTopAmt - cropBottomAmt <= 0 || this.grid[0].length - cropLeftAmt - cropRightAmt <= 0) {
            this.grid = new LandBlockType[0][0];
            this.hp = new int[0][0];
            this.destroy = new boolean[0][0];
            this.phase = new int[0][0];
            this.edge = new boolean[0][0];
            this.reachable = new ArrayList[0][0];
            this.chunkID = new int[0][0];
            this.removeUnstuckParticles();
            return;
        }
        if (cropTopAmt > 0 || cropBottomAmt > 0) {
            LandBlockType[][] grid2 = new LandBlockType[this.grid.length - cropTopAmt - cropBottomAmt][0];
            System.arraycopy(this.grid, cropTopAmt, grid2, 0, grid2.length);
            int[][] hp2 = new int[this.grid.length - cropTopAmt - cropBottomAmt][0];
            System.arraycopy(this.hp, cropTopAmt, hp2, 0, hp2.length);
            boolean[][] destroy2 = new boolean[this.grid.length - cropTopAmt - cropBottomAmt][0];
            System.arraycopy(this.destroy, cropTopAmt, destroy2, 0, destroy2.length);
            int[][] phase2 = new int[this.grid.length - cropTopAmt - cropBottomAmt][0];
            System.arraycopy(this.phase, cropTopAmt, phase2, 0, phase2.length);
            boolean[][] edge2 = new boolean[this.grid.length - cropTopAmt - cropBottomAmt][0];
            System.arraycopy(this.edge, cropTopAmt, edge2, 0, edge2.length);
            ArrayList[][] reachable2 = new ArrayList[this.grid.length - cropTopAmt - cropBottomAmt][0];
            System.arraycopy(this.reachable, cropTopAmt, reachable2, 0, reachable2.length);
            this.grid = grid2;
            this.hp = hp2;
            this.destroy = destroy2;
            this.phase = phase2;
            this.edge = edge2;
            this.reachable = reachable2;
        }
        this.setX(this.getX() + (double)(cropLeftAmt * 16));
        if (cropLeftAmt > 0 || cropRightAmt > 0) {
            for (gy = 0; gy < this.grid.length; ++gy) {
                LandBlockType[] row2 = new LandBlockType[this.grid[gy].length - cropLeftAmt - cropRightAmt];
                System.arraycopy(this.grid[gy], cropLeftAmt, row2, 0, row2.length);
                this.grid[gy] = row2;
                int[] hpRow2 = new int[this.hp[gy].length - cropLeftAmt - cropRightAmt];
                System.arraycopy(this.hp[gy], cropLeftAmt, hpRow2, 0, hpRow2.length);
                this.hp[gy] = hpRow2;
                boolean[] dRow2 = new boolean[this.destroy[gy].length - cropLeftAmt - cropRightAmt];
                System.arraycopy(this.destroy[gy], cropLeftAmt, dRow2, 0, dRow2.length);
                this.destroy[gy] = dRow2;
                int[] pRow2 = new int[this.phase[gy].length - cropLeftAmt - cropRightAmt];
                System.arraycopy(this.phase[gy], cropLeftAmt, pRow2, 0, pRow2.length);
                this.phase[gy] = pRow2;
                boolean[] eRow2 = new boolean[this.edge[gy].length - cropLeftAmt - cropRightAmt];
                System.arraycopy(this.edge[gy], cropLeftAmt, eRow2, 0, eRow2.length);
                this.edge[gy] = eRow2;
                ArrayList[] rRow2 = new ArrayList[this.reachable[gy].length - cropLeftAmt - cropRightAmt];
                System.arraycopy(this.reachable[gy], cropLeftAmt, rRow2, 0, rRow2.length);
                this.reachable[gy] = rRow2;
            }
        }
        for (gy = 0; gy < this.grid.length; ++gy) {
            block10: for (gx = 0; gx < this.grid[0].length; ++gx) {
                if (gy == 0 || gy == this.grid.length - 1 || gx == 0 || gx == this.grid[0].length - 1) {
                    this.edge[gy][gx] = true;
                    continue;
                }
                this.edge[gy][gx] = false;
                for (int dy = -1; dy < 2; ++dy) {
                    for (int dx = -1; dx < 2; ++dx) {
                        if (this.grid[gy + dy][gx + dx].opaque) continue;
                        this.edge[gy][gx] = true;
                        continue block10;
                    }
                }
            }
        }
        if (this.immobile && this.grid.length > 1) {
            for (gx = 0; gx < this.grid[0].length; ++gx) {
                this.edge[this.grid.length - 1][gx] = this.grid[this.grid.length - 2][gx] == LandBlockType.ofName("AIR");
            }
            for (gy = 1; gy < this.grid.length; ++gy) {
                this.edge[gy][0] = this.grid[gy - 1][0] == LandBlockType.ofName("AIR");
                this.edge[gy][this.grid[0].length - 1] = this.grid[gy - 1][this.grid[0].length - 1] == LandBlockType.ofName("AIR");
            }
        }
        int[][] coverage = new int[this.grid.length][this.grid[0].length];
        for (gy = 0; gy < this.grid.length; ++gy) {
            for (gx = 0; gx < this.grid[0].length; ++gx) {
                if (this.grid[gy][gx] == LandBlockType.ofName("AIR")) continue;
                coverage[gy][gx] = this.edge[gy][gx] ? 1 : 2;
            }
        }
        if (this.grid[0].length != this.heightMap.length) {
            this.heightMap = new int[this.grid[0].length];
            this.opaqueHeightMap = new int[this.grid[0].length];
        }
        for (gx = 0; gx < this.heightMap.length; ++gx) {
            for (gy = 0; gy < this.grid.length && !this.grid[gy][gx].solid; ++gy) {
            }
            this.heightMap[gx] = gy;
            for (gy = 0; gy < this.grid.length && !this.grid[gy][gx].opaque; ++gy) {
            }
            this.opaqueHeightMap[gx] = gy;
        }
        for (Particle p : this.stuckParticles) {
            p.x -= (double)(cropLeftAmt * 16);
            p.y -= (double)(cropTopAmt * 16);
        }
        this.removeUnstuckParticles();
        this.chunkID = new int[this.grid.length][this.grid[0].length];
        if (!this.immobile) {
            this.calcConcavePoints();
        }
        this.rects.clear();
        int searchGy = 0;
        while (true) {
            int left = 0;
            int top = 0;
            boolean found = false;
            block22: while (searchGy < coverage.length) {
                for (gx = 0; gx < coverage[0].length; ++gx) {
                    if (coverage[searchGy][gx] != 2) continue;
                    left = gx;
                    top = searchGy;
                    found = true;
                    break block22;
                }
                ++searchGy;
            }
            if (!found) {
                return;
            }
            int w = 1;
            int h = 1;
            coverage[top][left] = 1;
            while (left + w < coverage[0].length && coverage[top][left + w] == 2) {
                coverage[top][left + w] = 1;
                ++w;
            }
            block25: while (top + h < coverage.length) {
                int xx;
                boolean req = false;
                for (xx = 0; xx < w; ++xx) {
                    if (coverage[top + h][left + xx] == 0) break block25;
                    if (coverage[top + h][left + xx] != 2) continue;
                    req = true;
                }
                if (!req) break;
                for (xx = 0; xx < w; ++xx) {
                    coverage[top + h][left + xx] = 1;
                }
                ++h;
            }
            this.rects.add(new Rect2D(left, top, w, h));
        }
    }

    public void drawSoil(MyDraw d, double cropX, double cropY, double cropW, double cropH, Clr soilTint) {
        if (!this.immobile) {
            return;
        }
        int rsz = this.rects.size();
        for (int i = 0; i < rsz; ++i) {
            Rect2D r = this.rects.get(i);
            if (!Rect2D.intersects(cropX, cropY, cropW, cropH, this.getX() + r.x * 16.0, this.getY() + r.y * 16.0, r.w * 16.0, r.h * 16.0)) continue;
            d.rect(soilTint, this.getX() + r.x * 16.0, this.getY() + r.y * 16.0, r.w * 16.0, r.h * 16.0);
        }
    }

    public void drawNonSoil(MyDraw d, double cropX, double cropY, double cropW, double cropH, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr soilTint, boolean snow, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                int rightAdj;
                Appearance app;
                LandBlockType lbt = this.grid[gy][gx];
                if (lbt.app == null || !this.edge[gy][gx] && this.immobile) continue;
                Appearance appearance = snow && (gy == 0 || !this.grid[gy - 1][gx].opaque) && lbt.topSnowApp != null ? lbt.topSnowApp : (app = snow && lbt.snowApp != null ? lbt.snowApp : lbt.app);
                if (app.spritesheetBundle != ssb) {
                    if (additionalSSBs == null) continue;
                    additionalSSBs.add(app.spritesheetBundle);
                    continue;
                }
                double left = this.getX() + (double)(gx * 16);
                double top = this.getY() + (double)((gy + 1 - lbt.app.height()) * 16);
                double right = left + 16.0;
                double bottom = top + (double)(lbt.app.height() * 16);
                if (left > cropX + cropW || right < cropX || top > cropY + cropH || bottom < cropY) continue;
                int leftAdj = gx == 0 || !this.grid[gy][gx - 1].solid ? 1 : 0;
                int n = rightAdj = gx == this.grid[0].length - 1 || !this.grid[gy][gx + 1].solid ? 1 : 0;
                if (app.frames.get((int)(this.phase[gy][gx] % app.frames.size())).flipped) {
                    int tmp = rightAdj;
                    rightAdj = leftAdj;
                    leftAdj = tmp;
                }
                app.drawBevelled(d, left, top, lbt.app.width() * 16, lbt.app.height() * 16, this.phase[gy][gx] * 300, null, false, light, lightStrength, ambient, ambientSaturation, gy == 0 || !this.grid[gy - 1][gx].solid ? 1 : 0, gy == this.grid.length - 1 || !this.grid[gy + 1][gx].solid ? 1 : 0, leftAdj, rightAdj, app.frames.get((int)(this.phase[gy][gx] % app.frames.size())).flipped, PATCH9_SOLID, null, 0.36f, false, 0, 0, null, ssb);
            }
        }
    }

    public void drawExternals(boolean priority, MyDraw d, double cropX, double cropY, double cropW, double cropH, Image[] light, float lightStrength, Color ambient, float ambientSaturation, boolean snow, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                ExternalApp ea;
                LandBlockType lbt = this.grid[gy][gx];
                if (lbt.externalDrawPriority != priority) continue;
                ExternalApp externalApp = ea = snow ? lbt.externalSnowApp : lbt.externalApp;
                if (ea == null) continue;
                Appearance app = ea.app;
                if (app.spritesheetBundle != ssb) {
                    if (additionalSSBs == null) continue;
                    additionalSSBs.add(app.spritesheetBundle);
                    continue;
                }
                double left = this.getX() + (double)((gx + ea.dx) * 16);
                double top = this.getY() + (double)((gy + ea.dy) * 16);
                double right = left + (double)(app.width() * 16);
                double bottom = top + (double)(app.height() * 16);
                if (left > cropX + cropW || right < cropX || top > cropY + cropH || bottom < cropY) continue;
                app.draw(d, left, top, this.phase[gy][gx] * 300, false, light, lightStrength, ambient, ambientSaturation);
            }
        }
    }

    public boolean tick(int ms, Combat c) {
        boolean doCrop = false;
        HashMap<LandBlockType, Pt> destroySounds = new HashMap<LandBlockType, Pt>();
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                if (!this.destroy[gy][gx]) continue;
                this.destroy[gy][gx] = false;
                if (this.grid[gy][gx].hp <= 0) continue;
                if (this.grid[gy][gx].destroySound != null) {
                    double sx = this.getX() + (double)(gx * 16);
                    double sy = this.getY() + (double)(gy * 16);
                    if (destroySounds.containsKey(this.grid[gy][gx])) {
                        Pt p = (Pt)destroySounds.get(this.grid[gy][gx]);
                        destroySounds.put(this.grid[gy][gx], new Pt(p.x / 2.0 + sx / 2.0, p.y / 2.0 + sy / 2.0));
                    } else {
                        destroySounds.put(this.grid[gy][gx], new Pt(sx, sy));
                    }
                }
                this.grid[gy][gx] = LandBlockType.ofName("AIR");
                doCrop = true;
                this.dirty = true;
            }
        }
        for (LandBlockType dest : destroySounds.keySet()) {
            Pt p = (Pt)destroySounds.get(dest);
            c.play(dest.destroySound, p.x, p.y, 0.0, 0.0, false);
        }
        if (doCrop) {
            this.crop();
        } else if (this.dirty) {
            this.removeUnstuckParticles();
        }
        if (!this.immobile) {
            this.setyForce(-this.availableSuspendiumForce());
        }
        return this.removeMe();
    }

    public int availableLift() {
        int lift = 0;
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                lift += this.grid[gy][gx].liftGenerated;
            }
        }
        return lift;
    }

    public double availableSuspendiumForce() {
        double distanceFromFloor = 512.0 - this.getY();
        return (double)(this.availableLift() * 400 * 2) / (400.0 + distanceFromFloor) * 0.001;
    }

    public int availableServiceCeiling() {
        if (this.immobile) {
            return 0;
        }
        if (this.ascCalced) {
            return this.availableServiceCeiling;
        }
        int mass = this.getMass();
        this.availableServiceCeiling = mass == 0 ? 0 : this.availableLift() * 400 * 2 / this.getMass() - 400;
        this.ascCalced = true;
        return this.availableServiceCeiling;
    }

    @Override
    public boolean canParticleStick(double px, double py) {
        if (this.grid.length == 0) {
            return false;
        }
        if (!Rect2D.contains(this.getX(), this.getY(), this.getBBWidth(), this.getBBHeight(), px, py)) {
            return false;
        }
        int gx = (int)StrictMath.floor((px - this.getX()) / 16.0);
        int gy = (int)StrictMath.floor((py - this.getY()) / 16.0);
        return this.grid[gy][gx].solid;
    }

    @Override
    public int getGridWidth() {
        return this.grid[0].length;
    }

    @Override
    public int getGridHeight() {
        return this.grid.length;
    }

    @Override
    public boolean solidAt(int x, int y) {
        return y >= 0 && x >= 0 && y < this.grid.length && x < this.grid[0].length && this.grid[y][x].opaque;
    }

    @Override
    public ArrayList<GridLocation> reachable(int x, int y) {
        if (y >= 0 && x >= 0 && y < this.grid.length && x < this.grid[0].length && this.grid[y][x] != null) {
            if (this.reachable[y][x] == null) {
                this.reachable[y][x] = new ArrayList();
            }
            return this.reachable[y][x];
        }
        return null;
    }

    @Override
    public void clearReachable(int x, int y) {
        if (y >= 0 && x >= 0 && y < this.grid.length && x < this.grid[0].length && this.reachable[y][x] != null) {
            this.reachable[y][x].clear();
        }
    }

    @Override
    public boolean concaveAt(int x, int y) {
        return this.solidAt(x, y) && (!this.solidAt(x - 1, y - 1) && this.solidAt(x, y - 1) && this.solidAt(x - 1, y) || !this.solidAt(x - 1, y) && this.solidAt(x - 1, y - 1) && this.solidAt(x - 1, y + 1) || !this.solidAt(x - 1, y + 1) && this.solidAt(x - 1, y) && this.solidAt(x, y + 1) || !this.solidAt(x, y + 1) && this.solidAt(x - 1, y + 1) && this.solidAt(x + 1, y + 1) || !this.solidAt(x + 1, y + 1) && this.solidAt(x, y + 1) && this.solidAt(x + 1, y) || !this.solidAt(x + 1, y) && this.solidAt(x + 1, y + 1) && this.solidAt(x + 1, y - 1) || !this.solidAt(x + 1, y - 1) && this.solidAt(x + 1, y) && this.solidAt(x, y - 1) || !this.solidAt(x, y - 1) && this.solidAt(x + 1, y - 1) && this.solidAt(x - 1, y - 1));
    }

    @Override
    public GridLocation locationAt(int x, int y) {
        return new GridRef(x, y, this);
    }

    public boolean hasNonAirAt(int x, int y) {
        return y >= 0 && x >= 0 && y < this.grid.length && x < this.grid[0].length && this.grid[y][x].solid;
    }

    public LandBlockType typeAt(int x, int y) {
        if (y >= 0 && x >= 0 && y < this.grid.length && x < this.grid[0].length) {
            return this.grid[y][x];
        }
        return null;
    }

    @Override
    public boolean enterableAt(int x, int y) {
        return false;
    }

    @Override
    public double yBoundaryAt(double probeX) {
        int gx = (int)StrictMath.floor((probeX - this.getX()) / 16.0);
        gx = StrictMath.max(0, StrictMath.min(this.opaqueHeightMap.length - 1, gx));
        return this.getY() + (double)(this.opaqueHeightMap[gx] * 16);
    }

    public double solidYBoundaryAt(double probeX) {
        int gx = (int)StrictMath.floor((probeX - this.getX()) / 16.0);
        gx = StrictMath.max(0, StrictMath.min(this.heightMap.length - 1, gx));
        return this.getY() + (double)(this.heightMap[gx] * 16);
    }

    private double yBoundaryAt(double probeX, int[] hm) {
        int gx = (int)StrictMath.floor((probeX - this.getX()) / 16.0);
        gx = StrictMath.max(0, StrictMath.min(hm.length - 1, gx));
        return this.getY() + (double)(hm[gx] * 16);
    }

    @Override
    public int firstSolidBlockYAt(int gx) {
        if (gx < 0 || gx >= this.opaqueHeightMap.length) {
            return -1;
        }
        return this.opaqueHeightMap[gx];
    }

    @Override
    public boolean isAtSpeed() {
        return false;
    }

    public ArrayList<LandFormation> splitIntoChunksIfNeeded() {
        if (!this.dirty) {
            return null;
        }
        this.dirty = false;
        int chunkCount = this.countChunks();
        if (chunkCount < 2) {
            return null;
        }
        ArrayList<LandFormation> newLandForms = new ArrayList<LandFormation>();
        for (int chunkNum = 2; chunkNum <= chunkCount; ++chunkNum) {
            LandFormation lf2 = new LandFormation(this.getX(), this.getY(), this.grid[0].length, this.grid.length, this.landscapeType);
            for (int gy = 0; gy < this.grid.length; ++gy) {
                for (int gx = 0; gx < this.grid[0].length; ++gx) {
                    if (this.chunkID[gy][gx] != chunkNum) continue;
                    lf2.grid[gy][gx] = this.grid[gy][gx];
                    lf2.phase[gy][gx] = this.phase[gy][gx];
                    this.grid[gy][gx] = LandBlockType.ofName("AIR");
                }
            }
            for (Particle p : this.stuckParticles) {
                Particle p2 = new Particle(p.type, p.x - this.getX() + lf2.getX(), p.y - this.getY() + lf2.getY(), p.dx, p.dy);
                p2.life = p.life;
                p2.lifespan = p.lifespan;
                lf2.stuckParticles.add(p2);
            }
            lf2.crop();
            newLandForms.add(lf2);
        }
        this.crop();
        return newLandForms;
    }

    public int countChunks() {
        int currentChunkID = 0;
        for (int y = 0; y < this.chunkID.length; ++y) {
            Arrays.fill(this.chunkID[y], 0);
        }
        LinkedList<XY> stack = new LinkedList<XY>();
        for (int allTypes = 0; allTypes <= 1; ++allTypes) {
            boolean bedrockOnly = allTypes == 0;
            for (int startY = 0; startY < this.chunkID.length; ++startY) {
                for (int startX = 0; startX < this.chunkID[0].length; ++startX) {
                    if (!(bedrockOnly ? this.grid[startY][startX] == LandBlockType.ofName("BEDROCK") : this.grid[startY][startX].solid) || this.chunkID[startY][startX] >= 1) continue;
                    currentChunkID = bedrockOnly ? 1 : ++currentChunkID;
                    stack.push(new XY(startX, startY));
                    while (!stack.isEmpty()) {
                        XY xy = (XY)stack.poll();
                        this.chunkID[xy.y][xy.x] = currentChunkID;
                        if (xy.y > 0 && this.chunkID[xy.y - 1][xy.x] == 0 && this.grid[xy.y - 1][xy.x].solid) {
                            stack.push(new XY(xy.x, xy.y - 1));
                            this.chunkID[xy.y - 1][xy.x] = -1;
                        }
                        if (xy.y < this.chunkID.length - 1 && this.chunkID[xy.y + 1][xy.x] == 0 && this.grid[xy.y + 1][xy.x].solid) {
                            stack.push(new XY(xy.x, xy.y + 1));
                            this.chunkID[xy.y + 1][xy.x] = -1;
                        }
                        if (xy.x > 0 && this.chunkID[xy.y][xy.x - 1] == 0 && this.grid[xy.y][xy.x - 1].solid) {
                            stack.push(new XY(xy.x - 1, xy.y));
                            this.chunkID[xy.y][xy.x - 1] = -1;
                        }
                        if (xy.x >= this.chunkID[0].length - 1 || this.chunkID[xy.y][xy.x + 1] != 0 || !this.grid[xy.y][xy.x + 1].solid) continue;
                        stack.push(new XY(xy.x + 1, xy.y));
                        this.chunkID[xy.y][xy.x + 1] = -1;
                    }
                }
            }
        }
        return currentChunkID;
    }

    @Override
    public int getCollisionMass() {
        return StrictMath.min(500, this.getMass() / 5);
    }

    @Override
    public int getMass() {
        int m = 10;
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                m += this.grid[gy][gx].weight;
            }
        }
        return StrictMath.max(10, m);
    }

    @Override
    public boolean isImmobile() {
        return this.immobile;
    }

    @Override
    public boolean removeMe() {
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                if (!this.grid[gy][gx].landFormationRemoveStopper) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public double elasticity() {
        return 0.0;
    }

    @Override
    public double horizontalAirFriction() {
        return 0.005 + (double)this.grid.length * 1.0 / (double)this.grid[0].length * 0.01;
    }

    @Override
    public double verticalAirFriction() {
        return 0.001 + (double)this.grid[0].length * 1.0 / (double)this.grid.length * 0.002;
    }

    @Override
    public double getBBWidth() {
        return this.grid.length == 0 ? 0.0 : (double)(16 * this.grid[0].length);
    }

    @Override
    public double getBBHeight() {
        return 16 * this.grid.length;
    }

    @Override
    public boolean collidesWith(PhysicsRect b2) {
        if (b2 instanceof Foot && !((Foot)b2).isDown) {
            return false;
        }
        if (b2 instanceof WheelBody) {
            return this.overlapsWith((WheelBody)b2);
        }
        if (b2 instanceof Airship) {
            return ((Airship)b2).collidesWith(this);
        }
        if (b2 instanceof LandFormation) {
            return this.overlapsWith((LandFormation)b2);
        }
        return this.collidesWithPR(b2);
    }

    private boolean overlapsWith(WheelBody wb) {
        double lf2x = wb.getX() - wb.r;
        double lf2y = wb.getY() - wb.r;
        int gyStart = StrictMath.max(0, (int)StrictMath.floor((lf2y - this.getY()) / 16.0) - 1);
        int gyEnd = StrictMath.min(this.grid.length, (int)StrictMath.ceil((lf2y + wb.r * 2.0 - this.getY()) / 16.0) + 2);
        int gxStart = StrictMath.max(0, (int)StrictMath.floor((lf2x - this.getX()) / 16.0) - 1);
        int gxEnd = StrictMath.min(this.grid[0].length, (int)StrictMath.ceil((lf2x + wb.r * 2.0 - this.getX()) / 16.0) + 2);
        for (int gy = gyStart; gy < gyEnd; ++gy) {
            for (int gx = gxStart; gx < gxEnd; ++gx) {
                double ty;
                double tx;
                if (!this.grid[gy][gx].solid || !wb.intersectsWithRect(tx = this.getX() + (double)(gx * 16), ty = this.getY() + (double)(gy * 16), 16.0, 16.0)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean overlapsWith(LandFormation lf2) {
        double lf2x = lf2.getX();
        double lf2y = lf2.getY();
        int lf2gw = lf2.grid[0].length;
        int lf2gh = lf2.grid.length;
        int gyStart = StrictMath.max(0, (int)StrictMath.floor((lf2.getY() - this.getY()) / 16.0) - 1);
        int gyEnd = StrictMath.min(this.grid.length, (int)StrictMath.ceil((lf2.getY() + (double)(lf2gh * 16) - this.getY()) / 16.0) + 2);
        int gxStart = StrictMath.max(0, (int)StrictMath.floor((lf2.getX() - this.getX()) / 16.0) - 1);
        int gxEnd = StrictMath.min(this.grid[0].length, (int)StrictMath.ceil((lf2.getX() + (double)(lf2gw * 16) - this.getX()) / 16.0) + 2);
        for (int gy = gyStart; gy < gyEnd; ++gy) {
            for (int gx = gxStart; gx < gxEnd; ++gx) {
                if (!this.grid[gy][gx].solid) continue;
                double tx = this.getX() + (double)(gx * 16);
                double ty = this.getY() + (double)(gy * 16);
                int lfgx = (int)StrictMath.floor((tx - lf2x) / 16.0);
                int lfgy = (int)StrictMath.floor((ty - lf2y) / 16.0);
                if (lfgy >= 0 && lfgy < lf2gh && lfgx >= 0 && lfgx < lf2gw && lf2.grid[lfgy][lfgx].solid) {
                    return true;
                }
                if (lfgy + 1 >= 0 && lfgy + 1 < lf2gh && lfgx + 1 >= 0 && lfgx + 1 < lf2gw && lf2.grid[lfgy + 1][lfgx + 1].solid) {
                    return true;
                }
                if (lfgy + 1 >= 0 && lfgy + 1 < lf2gh && lfgx >= 0 && lfgx < lf2gw && lf2.grid[lfgy + 1][lfgx].solid) {
                    return true;
                }
                if (lfgy < 0 || lfgy >= lf2gh || lfgx + 1 < 0 || lfgx + 1 >= lf2gw || !lf2.grid[lfgy][lfgx + 1].solid) continue;
                return true;
            }
        }
        return false;
    }

    private ArrayList<int[]> overlaps(WheelBody wb) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        double lf2x = wb.getX() - wb.r;
        double lf2y = wb.getY() - wb.r;
        int gyStart = StrictMath.max(0, (int)StrictMath.floor((lf2y - this.getY()) / 16.0) - 1);
        int gyEnd = StrictMath.min(this.grid.length, (int)StrictMath.ceil((lf2y + wb.r * 2.0 - this.getY()) / 16.0) + 2);
        int gxStart = StrictMath.max(0, (int)StrictMath.floor((lf2x - this.getX()) / 16.0) - 1);
        int gxEnd = StrictMath.min(this.grid[0].length, (int)StrictMath.ceil((lf2x + wb.r * 2.0 - this.getX()) / 16.0) + 2);
        for (int gy = gyStart; gy < gyEnd; ++gy) {
            for (int gx = gxStart; gx < gxEnd; ++gx) {
                double ty;
                double tx;
                if (!this.grid[gy][gx].solid || !wb.intersectsWithRect(tx = this.getX() + (double)(gx * 16), ty = this.getY() + (double)(gy * 16), 16.0, 16.0)) continue;
                l.add(new int[]{gx, gy});
            }
        }
        return l;
    }

    private ArrayList<int[]> overlaps(LandFormation lf2) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        double lf2x = lf2.getX();
        double lf2y = lf2.getY();
        int lf2gw = lf2.grid[0].length;
        int lf2gh = lf2.grid.length;
        int gyStart = StrictMath.max(0, (int)StrictMath.floor((lf2.getY() - this.getY()) / 16.0) - 1);
        int gyEnd = StrictMath.min(this.grid.length, (int)StrictMath.ceil((lf2.getY() + (double)(lf2gh * 16) - this.getY()) / 16.0) + 2);
        int gxStart = StrictMath.max(0, (int)StrictMath.floor((lf2.getX() - this.getX()) / 16.0) - 1);
        int gxEnd = StrictMath.min(this.grid[0].length, (int)StrictMath.ceil((lf2.getX() + (double)(lf2gw * 16) - this.getX()) / 16.0) + 2);
        for (int gy = gyStart; gy < gyEnd; ++gy) {
            for (int gx = gxStart; gx < gxEnd; ++gx) {
                if (!this.grid[gy][gx].solid) continue;
                double tx = this.getX() + (double)(gx * 16);
                double ty = this.getY() + (double)(gy * 16);
                int lfgx = (int)StrictMath.floor((tx - lf2x) / 16.0);
                int lfgy = (int)StrictMath.floor((ty - lf2y) / 16.0);
                if (!(lfgy >= 0 && lfgy < lf2gh && lfgx >= 0 && lfgx < lf2gw && lf2.grid[lfgy][lfgx].solid || lfgy + 1 >= 0 && lfgy + 1 < lf2gh && lfgx + 1 >= 0 && lfgx + 1 < lf2gw && lf2.grid[lfgy + 1][lfgx + 1].solid || lfgy + 1 >= 0 && lfgy + 1 < lf2gh && lfgx >= 0 && lfgx < lf2gw && lf2.grid[lfgy + 1][lfgx].solid) && (lfgy < 0 || lfgy >= lf2gh || lfgx + 1 < 0 || lfgx + 1 >= lf2gw || !lf2.grid[lfgy][lfgx + 1].solid)) continue;
                l.add(new int[]{gx, gy});
            }
        }
        return l;
    }

    private ArrayList<int[]> overlaps(Airship b) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        double bx = b.getX();
        double by = b.getY();
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                TileMask tm;
                int bty;
                if (!this.grid[gy][gx].solid) continue;
                int btx = b.gridXToWorldX((int)StrictMath.floor((this.getX() - bx) / 16.0) + gx, 1);
                Tile t = b.tileAt(btx, bty = (int)StrictMath.floor((this.getY() - by) / 16.0) + gy);
                if (t != null && (tm = t.module.type.getTileMasks(b.currentBonuses)[t.y - t.module.y][t.x - t.module.x]).intersectsBlock((int)b.getX() + b.gridXToWorldX(t.x, 1) * 16, (int)b.getY() + t.y * 16, b.flipped, (int)this.getX() + gx * 16, (int)this.getY() + gy * 16)) {
                    l.add(new int[]{gx, gy});
                    continue;
                }
                t = b.tileAt(btx + 1, bty + 1);
                if (t != null && (tm = t.module.type.getTileMasks(b.currentBonuses)[t.y - t.module.y][t.x - t.module.x]).intersectsBlock((int)b.getX() + b.gridXToWorldX(t.x, 1) * 16, (int)b.getY() + t.y * 16, b.flipped, (int)this.getX() + gx * 16, (int)this.getY() + gy * 16)) {
                    l.add(new int[]{gx, gy});
                    continue;
                }
                t = b.tileAt(btx, bty + 1);
                if (t != null && (tm = t.module.type.getTileMasks(b.currentBonuses)[t.y - t.module.y][t.x - t.module.x]).intersectsBlock((int)b.getX() + b.gridXToWorldX(t.x, 1) * 16, (int)b.getY() + t.y * 16, b.flipped, (int)this.getX() + gx * 16, (int)this.getY() + gy * 16)) {
                    l.add(new int[]{gx, gy});
                    continue;
                }
                t = b.tileAt(btx + 1, bty);
                if (t == null || !(tm = t.module.type.getTileMasks(b.currentBonuses)[t.y - t.module.y][t.x - t.module.x]).intersectsBlock((int)b.getX() + b.gridXToWorldX(t.x, 1) * 16, (int)b.getY() + t.y * 16, b.flipped, (int)this.getX() + gx * 16, (int)this.getY() + gy * 16)) continue;
                l.add(new int[]{gx, gy});
            }
        }
        return l;
    }

    private ArrayList<int[]> overlaps(Body b2) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        int left = StrictMath.max(0, (int)StrictMath.floor((b2.getX() - this.getX()) / 16.0));
        int top = StrictMath.max(0, (int)StrictMath.floor((b2.getY() - this.getY()) / 16.0));
        int right = StrictMath.min(this.grid[0].length - 1, (int)StrictMath.floor((b2.getX() + b2.getBBWidth() - this.getX()) / 16.0));
        int bottom = StrictMath.min(this.grid.length - 1, (int)StrictMath.floor((b2.getY() + b2.getBBHeight() - this.getY()) / 16.0));
        for (int yy = top; yy <= bottom; ++yy) {
            for (int xx = left; xx <= right; ++xx) {
                if (!this.grid[yy][xx].solid) continue;
                l.add(new int[]{xx, yy});
            }
        }
        return l;
    }

    private boolean collidesWithPR(PhysicsRect b2) {
        double b2W = b2.getBBWidth();
        double b2H = b2.getBBHeight();
        int gyStart = StrictMath.max(0, (int)StrictMath.floor((b2.getY() - this.getY()) / 16.0) - 1);
        int gyEnd = StrictMath.min(this.grid.length, (int)StrictMath.ceil((b2.getY() + b2H - this.getY()) / 16.0) + 2);
        int gxStart = StrictMath.max(0, (int)StrictMath.floor((b2.getX() - this.getX()) / 16.0) - 1);
        int gxEnd = StrictMath.min(this.grid[0].length, (int)StrictMath.ceil((b2.getX() + b2W - this.getX()) / 16.0) + 2);
        for (int gy = gyStart; gy < gyEnd; ++gy) {
            for (int gx = gxStart; gx < gxEnd; ++gx) {
                double gty;
                double gtx;
                if (!this.grid[gy][gx].solid || !Rect2D.intersects(gtx = this.getX() + (double)(gx * 16), gty = this.getY() + (double)(gy * 16), 16.0, 16.0, b2.getX(), b2.getY(), b2W, b2H)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void doCollision(Body b2, double hitEnergy, Combat combat, boolean atSpeed) {
        ArrayList<int[]> overlaps = b2 instanceof WheelBody ? this.overlaps((WheelBody)b2) : (b2 instanceof LandFormation ? this.overlaps((LandFormation)b2) : (b2 instanceof Airship ? this.overlaps((Airship)b2) : this.overlaps(b2)));
        this.collideWith(overlaps, hitEnergy, combat, atSpeed);
    }

    private void collideWith(ArrayList<int[]> overlaps, double hitEnergy, Combat combat, boolean atSpeed) {
        if (overlaps.isEmpty()) {
            return;
        }
        int dmg = (int)StrictMath.ceil(hitEnergy * 0.8 / (double)overlaps.size());
        boolean snow = combat.timeOfDay.effect.snow;
        int osz = overlaps.size();
        for (int oi = 0; oi < osz; ++oi) {
            ParticleType pt;
            int gx = overlaps.get(oi)[0];
            int gy = overlaps.get(oi)[1];
            LandBlockType lbt = this.grid[gy][gx];
            int blockDmg = dmg - lbt.armour;
            if (blockDmg <= 0) continue;
            if (!(blockDmg <= 3 || !atSpeed || !(hitEnergy / (double)overlaps.size() > 1.0) || lbt != this.landscapeType.grass && lbt != this.landscapeType.soil || gy != 0 && this.grid[gy - 1][gx].solid)) {
                ParticleType t = combat.timeOfDay.effect.groundImpactParticle;
                for (int n = 0; n < combat.timeOfDay.effect.numGroundImpactParticles; ++n) {
                    combat.particles.add(new Particle(t, this.getX() + (double)(gx * 16) + AGame.ANIM_R.nextDouble() * 16.0, this.getY() + (double)(gy * 16) - AGame.ANIM_R.nextDouble() * (double)t.startSize, t.minDx + AGame.ANIM_R.nextDouble() * (t.maxDx - t.minDx), t.minDy + AGame.ANIM_R.nextDouble() * (t.maxDy - t.minDy)));
                }
            }
            if (!lbt.solid || this.hp[gy][gx] <= 0 || this.destroy[gy][gx]) continue;
            this.hp[gy][gx] = StrictMath.max(0, this.hp[gy][gx] - blockDmg);
            if (this.hp[gy][gx] != 0) continue;
            this.destroy[gy][gx] = true;
            ParticleType particleType = pt = snow ? ParticleType.ofName("ground_snow") : this.grid[gy][gx].destroyparticle;
            if (pt == null) continue;
            for (int i = 0; i < 7; ++i) {
                combat.particles.add(new Particle(pt, this.getX() + (double)(gx * 16) + 8.0, this.getY() + (double)(gy * 16) + 8.0));
            }
        }
    }

    private strictfp static final class XY {
        public final int x;
        public final int y;

        public XY(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public strictfp static class BlockDelta {
        public final int gx;
        public final int gy;
        public final LandBlockType t;

        public BlockDelta(int gx, int gy, LandBlockType t) {
            this.gx = gx;
            this.gy = gy;
            this.t = t;
        }

        public BlockDelta(JSONObject o) {
            this.gx = o.getInt("gx");
            this.gy = o.getInt("gy");
            this.t = LandBlockType.ofName(o.getString("t"));
        }

        public JSONObject toJSON() {
            JSONObject o = new JSONObject();
            o.put("gx", this.gx);
            o.put("gy", this.gy);
            o.put("t", this.t.name);
            return o;
        }
    }
}

