/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Keys {
    public static HashMap<String, String> keyLookup = new HashMap();
    public static ArrayList<KeyGroup> groups = new ArrayList();
    public static HashMap<KeyInfo, ArrayList<KeyInfo>> connecteds = new HashMap();

    public static void loadKeyInfo() {
        try {
            HashMap<String, KeyGroup> lookup = new HashMap<String, KeyGroup>();
            File f = new File(new File(AGame.getStaticGameDirectory(), "data"), "keys.json");
            JSONObject o = new JSONObject(FileUtils.readFileToString((File)f, (String)"UTF-8"));
            JSONArray groupsA = o.getJSONArray("groups");
            for (int i = 0; i < groupsA.length(); ++i) {
                JSONObject groupO = groupsA.getJSONObject(i);
                KeyGroup group = new KeyGroup(groupO.getString("name"));
                lookup.put(group.name, group);
                groups.add(group);
                JSONArray keysA = groupO.getJSONArray("keys");
                for (int j = 0; j < keysA.length(); ++j) {
                    KeyInfo key = new KeyInfo(keysA.getJSONArray(j).getString(0), keysA.getJSONArray(j).getString(1), keysA.getJSONArray(j).getString(2), group.name);
                    group.items.add(key);
                    keyLookup.put(key.id, key.value);
                }
                for (KeyInfo ki : group.items) {
                    ArrayList<KeyInfo> cs = new ArrayList<KeyInfo>();
                    cs.addAll(group.items);
                    cs.remove(ki);
                    connecteds.put(ki, cs);
                }
            }
            JSONArray connectedA = o.getJSONArray("connected");
            for (int i = 0; i < connectedA.length(); ++i) {
                JSONArray csA = connectedA.getJSONArray(i);
                KeyGroup kg = (KeyGroup)lookup.get(csA.getString(0));
                for (KeyInfo ki : kg.items) {
                    for (int j = 1; j < csA.length(); ++j) {
                        connecteds.get(ki).addAll(((KeyGroup)lookup.get((Object)csA.getString((int)j))).items);
                    }
                }
                for (int j = 1; j < csA.length(); ++j) {
                    KeyGroup kg2 = (KeyGroup)lookup.get(csA.getString(j));
                    for (KeyInfo ki : kg2.items) {
                        connecteds.get(ki).addAll(kg.items);
                    }
                }
            }
            Keys.loadKeyPrefs();
        }
        catch (Exception e) {
            AirshipGame.instance.reportError("Unable to load keys.json.", e, null, true, false);
        }
    }

    public static void loadKeyPrefs() {
        for (KeyGroup g : groups) {
            for (KeyInfo ki : g.items) {
                ki.value = AirshipGame.PREFS.get("k_" + ki.id, ki.original);
                keyLookup.put(ki.id, ki.value);
            }
        }
    }

    public static void saveKeyPrefs() {
        for (KeyGroup g : groups) {
            for (KeyInfo ki : g.items) {
                AirshipGame.PREFS.put("k_" + ki.id, ki.value);
            }
        }
        try {
            AirshipGame.PREFS.sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reset() {
        for (KeyGroup g : groups) {
            for (KeyInfo ki : g.items) {
                ki.value = ki.original;
                keyLookup.put(ki.id, ki.value);
            }
        }
    }

    public static String get(String id, String original) {
        return keyLookup.containsKey(id) ? keyLookup.get(id) : original;
    }

    public strictfp static class KeyGroup {
        public final String name;
        public final ArrayList<KeyInfo> items = new ArrayList();

        public KeyGroup(String name) {
            this.name = name;
        }
    }

    public strictfp static class KeyInfo {
        public final String id;
        public final String original;
        public String value;
        public final String name;
        public final String groupName;

        public KeyInfo(String id, String original, String name, String groupName) {
            this.id = id;
            this.original = original;
            this.value = original;
            this.name = name;
            this.groupName = groupName;
        }

        public KeyInfo setCollidesWith(String newValue) {
            if (!connecteds.containsKey(this)) {
                return null;
            }
            for (KeyInfo ki : connecteds.get(this)) {
                if (!ki.value.equals(newValue)) continue;
                return ki;
            }
            return null;
        }

        public boolean set(String newValue) {
            if (this.setCollidesWith(newValue) != null) {
                return false;
            }
            this.value = newValue;
            keyLookup.put(this.id, this.value);
            return true;
        }
    }
}

