/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.DateSorter;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.NameSorter;
import com.zarkonnen.airships.UnknownDirectoryException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public strictfp class JSONFileBackend
implements FileScreen.Backend {
    public final File dir;
    public ArrayList<FileScreen.Sorter> sorters = new ArrayList();
    public ArrayList<FileScreen.SettableFilter> filters = new ArrayList();
    public final NameSorter nameSorter;
    public final DateSorter dateSorter;

    public JSONFileBackend(File dir) {
        this.dir = dir;
        dir.mkdirs();
        this.nameSorter = new NameSorter(this);
        this.sorters.add(this.nameSorter);
        this.dateSorter = new DateSorter(this);
        this.sorters.add(this.dateSorter);
    }

    @Override
    public String saveSuffix() {
        return ".json";
    }

    @Override
    public boolean canCreateDirs() {
        return true;
    }

    @Override
    public ArrayList<FileScreen.Sorter> sorters() {
        return this.sorters;
    }

    @Override
    public ArrayList<FileScreen.SettableFilter> filters() {
        return this.filters;
    }

    @Override
    public List<String> list(List<String> dirPath) {
        File[] fs;
        ArrayList<String> l = new ArrayList<String>();
        File listDir = this.dir;
        for (int i = 0; i < dirPath.size(); ++i) {
            listDir = new File(listDir, dirPath.get(i));
        }
        if (!listDir.exists()) {
            throw new UnknownDirectoryException(dirPath);
        }
        String namePrefix = FileScreen.joinPath(dirPath);
        if (!namePrefix.isEmpty()) {
            namePrefix = namePrefix + "/";
        }
        if ((fs = listDir.listFiles()) != null) {
            if (!dirPath.isEmpty()) {
                l.add("..");
            }
            for (File f : fs) {
                if (f.getName().startsWith(".") || !f.isDirectory()) continue;
                l.add(namePrefix + f.getName());
            }
            for (File f : fs) {
                if (f.getName().startsWith(".") || !f.getName().endsWith(".json")) continue;
                l.add(namePrefix + f.getName());
            }
        }
        return l;
    }

    @Override
    public boolean isValidName(String name) {
        return !name.isEmpty() && AGame.makeFileSafe(name).equals(name);
    }

    @Override
    public void delete(List<String> path) {
        if (this.isLocked(path)) {
            return;
        }
        File f = this.getFile(path);
        if (f == null || !f.exists()) {
            return;
        }
        AGame.deleteDir(f);
    }

    @Override
    public boolean isLocked(List<String> path) {
        return false;
    }

    @Override
    public File getFile(List<String> path) {
        if (path == null) {
            return null;
        }
        File f = this.dir;
        for (String s : path) {
            f = new File(f, s);
        }
        return f;
    }

    @Override
    public boolean isDirectory(List<String> path) {
        File f = this.getFile(path);
        return f != null && f.isDirectory();
    }

    @Override
    public File getRawFile(List<String> path) {
        return this.getFile(path);
    }
}

