/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.GridLocation;
import java.util.ArrayList;

public strictfp class GridRef
implements GridLocation {
    public final int gridX;
    public final int gridY;
    public final GridBody body;

    public GridRef(int x, int y, GridBody body) {
        this.gridX = x;
        this.gridY = y;
        this.body = body;
    }

    @Override
    public boolean enterable() {
        return this.body.enterableAt(this.gridX, this.gridY);
    }

    @Override
    public boolean solid() {
        return this.body.solidAt(this.gridX, this.gridY);
    }

    @Override
    public double worldX() {
        return this.body.getX() + (double)(this.gridX * 16);
    }

    @Override
    public double worldY() {
        return this.body.getY() + (double)(this.gridY * 16);
    }

    public String toString() {
        return this.gridX + ", " + this.gridY + " on " + this.body;
    }

    @Override
    public GridBody body() {
        return this.body;
    }

    @Override
    public int worldGridX() {
        return this.gridX;
    }

    @Override
    public int worldGridY() {
        return this.gridY;
    }

    @Override
    public ArrayList<GridLocation> reachable() {
        return this.body.reachable(this.gridX, this.gridY);
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof GridRef)) {
            return false;
        }
        GridRef gr2 = (GridRef)o2;
        return this.body == gr2.body && this.gridX == gr2.gridX && this.gridY == gr2.gridY;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.gridX;
        hash = 67 * hash + this.gridY;
        hash = 67 * hash + (this.body != null ? this.body.hashCode() : 0);
        return hash;
    }
}

