/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.GridLocation;
import com.zarkonnen.airships.GridRef;
import com.zarkonnen.airships.OutsideBodyPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public strictfp abstract class GridBody
extends Body {
    public transient ArrayList<GridLocation> concavePoints = new ArrayList();
    public GridRef jumpPointCache;
    public GridBody jumpPointCacheTarget;
    public GridRef fallPointCache;
    public GridBody fallPointCacheTarget;

    public abstract int getGridWidth();

    public abstract int getGridHeight();

    public abstract boolean solidAt(int var1, int var2);

    public abstract boolean enterableAt(int var1, int var2);

    public abstract double yBoundaryAt(double var1);

    public abstract int firstSolidBlockYAt(int var1);

    public abstract ArrayList<GridLocation> reachable(int var1, int var2);

    public abstract void clearReachable(int var1, int var2);

    public abstract boolean concaveAt(int var1, int var2);

    public abstract GridLocation locationAt(int var1, int var2);

    public GridLocation locationAtWorldCoords(double ptX, double ptY) {
        return this.locationAt((int)StrictMath.floor((ptX - this.getX()) / 16.0), (int)StrictMath.floor((ptY - this.getY()) / 16.0));
    }

    public void calcConcavePoints() {
        this.concavePoints.clear();
        int gh = this.getGridHeight();
        int gw = this.getGridWidth();
        for (int gy = 0; gy < gh; ++gy) {
            for (int gx = 0; gx < gw; ++gx) {
                this.clearReachable(gx, gy);
                if (!this.concaveAt(gx, gy)) continue;
                this.concavePoints.add(this.locationAt(gx, gy));
            }
        }
        int csz = this.concavePoints.size();
        for (int ci = 0; ci < csz; ++ci) {
            GridLocation t1 = this.concavePoints.get(ci);
            for (int ci2 = 0; ci2 < csz; ++ci2) {
                GridLocation t2;
                if (ci2 == ci || !this.reachable(t1, t2 = this.concavePoints.get(ci2))) continue;
                t1.reachable().add(t2);
            }
        }
    }

    public static double manhattan(GridLocation a, GridLocation b) {
        return StrictMath.abs(a.worldGridX() - b.worldGridX()) + StrictMath.abs(a.worldGridY() - b.worldGridY());
    }

    public static double heuristic(GridLocation a, GridLocation b) {
        return GridBody.manhattan(a, b);
    }

    public OutsideBodyPath getPath(GridLocation start, GridLocation goal) {
        for (GridLocation node : this.concavePoints) {
            if (start.worldGridX() == node.worldGridX() && start.worldGridY() == node.worldGridY()) {
                start = node;
            }
            if (goal.worldGridX() != node.worldGridX() || goal.worldGridY() != node.worldGridY()) continue;
            goal = node;
        }
        if (start.worldGridX() == goal.worldGridX() && start.worldGridY() == goal.worldGridY()) {
            start = goal;
        }
        if (start.reachable() == null) {
            return null;
        }
        if (start.reachable().isEmpty()) {
            for (GridLocation node : this.concavePoints) {
                if (start.worldGridX() == node.worldGridX() && start.worldGridY() == node.worldGridY() || !this.reachable(start, node)) continue;
                start.reachable().add(node);
            }
        }
        HashSet<GridLocation> closedSet = new HashSet<GridLocation>();
        ArrayList<GridLocation> openSet = new ArrayList<GridLocation>();
        openSet.add(start);
        HashMap<GridLocation, GridLocation> cameFrom = new HashMap<GridLocation, GridLocation>();
        HashMap<GridLocation, Double> gScore = new HashMap<GridLocation, Double>();
        gScore.put(start, 0.0);
        gScore.put(goal, Double.POSITIVE_INFINITY);
        for (GridLocation gl : this.concavePoints) {
            gScore.put(gl, Double.POSITIVE_INFINITY);
        }
        HashMap<GridLocation, Double> fScore = new HashMap<GridLocation, Double>();
        fScore.put(start, GridBody.heuristic(start, goal));
        fScore.put(goal, Double.POSITIVE_INFINITY);
        for (GridLocation gl : this.concavePoints) {
            fScore.put(gl, Double.POSITIVE_INFINITY);
        }
        while (!openSet.isEmpty()) {
            double lowestFScore = Double.MAX_VALUE;
            GridLocation current = null;
            for (GridLocation gl : openSet) {
                if (current != null && !((Double)fScore.get(gl) < lowestFScore)) continue;
                current = gl;
                lowestFScore = (Double)fScore.get(gl);
            }
            if (current == goal) {
                return this.reconstructPath(cameFrom, current);
            }
            openSet.remove(current);
            closedSet.add(current);
            if (this.reachable(current, goal) && !closedSet.contains(goal)) {
                GridLocation neighbor = goal;
                double tentativeGScore = (Double)gScore.get(current) + GridBody.manhattan(current, neighbor);
                if (!openSet.contains(neighbor)) {
                    openSet.add(neighbor);
                } else if (tentativeGScore >= (Double)gScore.get(neighbor)) continue;
                cameFrom.put(neighbor, current);
                gScore.put(neighbor, tentativeGScore);
                double newFScore = tentativeGScore + GridBody.heuristic(neighbor, goal);
                fScore.put(neighbor, newFScore);
            }
            for (GridLocation neighbor : current.reachable()) {
                if (closedSet.contains(neighbor)) continue;
                double tentativeGScore = (Double)gScore.get(current) + GridBody.manhattan(current, neighbor);
                if (!openSet.contains(neighbor)) {
                    openSet.add(neighbor);
                } else if (tentativeGScore >= (Double)gScore.get(neighbor)) continue;
                cameFrom.put(neighbor, current);
                gScore.put(neighbor, tentativeGScore);
                double newFScore = tentativeGScore + GridBody.heuristic(neighbor, goal);
                fScore.put(neighbor, newFScore);
            }
        }
        return null;
    }

    public OutsideBodyPath reconstructPath(HashMap<GridLocation, GridLocation> cameFrom, GridLocation current) {
        ArrayList<GridLocation> totalPath = new ArrayList<GridLocation>();
        totalPath.add(current);
        while (cameFrom.containsKey(current)) {
            current = cameFrom.get(current);
            totalPath.add(0, current);
        }
        return new OutsideBodyPath(totalPath);
    }

    private boolean reachable(GridLocation t1, GridLocation t2) {
        int ty;
        int dy;
        int dx;
        int tx = t1.worldGridX();
        int dstX = t2.worldGridX();
        int dstY = t2.worldGridY();
        for (ty = t1.worldGridY(); tx != dstX && ty != dstY; tx += dx, ty += dy) {
            if (!this.solidAt(tx, ty)) {
                return false;
            }
            dx = dstX > tx ? 1 : -1;
            int n = dy = dstY > ty ? 1 : -1;
            if (this.solidAt(tx + dx, ty) && this.solidAt(tx, ty + dy)) continue;
            return false;
        }
        while (tx != dstX) {
            if (!this.solidAt(tx, ty)) {
                return false;
            }
            tx += dstX > tx ? 1 : -1;
        }
        while (ty != dstY) {
            if (!this.solidAt(tx, ty)) {
                return false;
            }
            ty += dstY > ty ? 1 : -1;
        }
        return this.solidAt(tx, ty);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " @ " + this.getX() + ", " + this.getY() + ", " + this.getBBWidth() + ", " + this.getBBHeight();
    }
}

