/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.CityName;
import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.DifficultyLevel;
import com.zarkonnen.airships.HeraldicStyle;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.IntRect;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.LoadingScreen;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MapSize;
import com.zarkonnen.airships.MonsterSetting;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SeaLevelSetting;
import com.zarkonnen.airships.StrategicSetupInfo;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.TechSpeedSetting;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.WorldGenScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Collections;

public strictfp class GameSetupScreen
implements Screen,
ScrollBar.ScrollElementAdapter<Object> {
    private final AirshipGame g;
    public TextField empireNameField;
    public CoatOfArms empireCOA;
    public DifficultyLevel difficulty;
    public MapSize mapSize;
    public SeaLevelSetting seaLevelSetting;
    public MonsterSetting monsterity;
    public TechSpeedSetting techSpeed;
    public int startingTechTier;
    private final ScrollBar settingsScrollBar = new ScrollBar();
    private final ArrayList<Object> os;
    private final IntRect settingsScrollBarR = new IntRect();

    public GameSetupScreen(AirshipGame g) {
        this.g = g;
        this.empireCOA = CoatEditor.getMyStrategicArms();
        while (this.empireCOA.getBonus() == Bonus.ofName("NO_BONUS") && this.empireCOA.getTech() == null) {
            this.empireCOA = CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("player"));
        }
        this.difficulty = GameSetupScreen.getValidFromPref(DifficultyLevel.class, g.difficulty, "EASY");
        this.mapSize = GameSetupScreen.getValidFromPref(MapSize.class, g.wmSize, "MEDIUM");
        this.seaLevelSetting = GameSetupScreen.getValidFromPref(SeaLevelSetting.class, g.seaLevelSettingName, "MIXED");
        this.monsterity = GameSetupScreen.getValidFromPref(MonsterSetting.class, g.monsterityName, "DEFAULT");
        this.techSpeed = GameSetupScreen.getValidFromPref(TechSpeedSetting.class, g.techSpeedName, "NORMAL");
        this.startingTechTier = g.startingTechTier;
        this.os = new ArrayList();
        this.os.add(new Object());
    }

    private static <T extends Loadable> T getValidFromPref(Class<T> clazz, String fromPref, String deflt) {
        if (Loadable.hasOfName(clazz, fromPref)) {
            return Loadable.ofName(clazz, fromPref);
        }
        if (Loadable.hasOfName(clazz, deflt)) {
            return Loadable.ofName(clazz, deflt);
        }
        ArrayList<T> ls = Loadable.all(clazz);
        if (ls.isEmpty()) {
            throw new RuntimeException("No loadables of type " + clazz.getSimpleName() + " available.");
        }
        return (T)((Loadable)ls.get(0));
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.empireNameField == null) {
            this.empireNameField = new TextField(false, " qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890-=+_!?,.&()");
            ArrayList<CityName> names = Loadable.all(CityName.class);
            this.empireNameField.setText(names.get((int)AGame.ANIM_R.nextInt((int)names.size())).name);
        }
        this.empireNameField.input(in, drawState, cursor, click, ms);
        this.settingsScrollBar.tick(in, this.settingsScrollBarR.x, this.settingsScrollBarR.y, this.settingsScrollBarR.w, this.settingsScrollBarR.h);
        if (in.keyDown("ENTER") && drawState.canClick() && !this.empireNameField.getText().isEmpty() && this.difficulty != null && this.mapSize != null) {
            this.startGame();
            drawState.hasClicked();
            return;
        }
        if (in.keyDown("ESCAPE") && drawState.canClick()) {
            this.g.s = new MainMenu(this.g, MainMenu.Submenu.CONQUEST);
            drawState.hasClicked();
        }
    }

    private void startGame() {
        try {
            this.g.difficulty = this.difficulty.name;
            this.g.wmSize = this.mapSize.name;
            this.g.seaLevelSettingName = this.seaLevelSetting.name;
            this.g.monsterityName = this.monsterity.name;
            this.g.techSpeedName = this.techSpeed.name;
            this.g.startingTechTier = this.startingTechTier;
            AirshipGame.PREFS.put("strategicCoatOfArms", this.empireCOA.toJSON().toString());
            this.g.saveSettings();
            AirshipGame.PREFS.flush();
        }
        catch (Exception e) {
            this.g.reportError(Lang._t("Unable_to_store_prefs", new Object[0]), e, null, false);
        }
        CampaignWorld cw = new CampaignWorld(System.currentTimeMillis(), this.mapSize, this.difficulty, this.g, Collections.singletonList(new StrategicSetupInfo(this.empireNameField.getText(), this.empireCOA, null, null)), 0, Lang.currentLocale, this.seaLevelSetting, this.monsterity, this.techSpeed, this.startingTechTier, this.g.strategicRapidCommands);
        cw.speed = CampaignWorld.Speed.STOP;
        this.g.s = new WorldGenScreen(cw, this.g);
    }

    @Override
    public void render(final MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(MyDraw.SCREEN_BG, sm);
        if (this.empireNameField == null) {
            return;
        }
        int shieldW = StrictMath.min(sm.width, sm.height) / 2;
        int panelW = StrictMath.min((int)d.textSize((String)"Lorem ipsum sic dolor amet fruitbats", (Fount)AGame.FOUNT).x, (sm.width - shieldW) / 2 - MyDraw.SIDE_CLEARANCE - MyDraw.UI_SPACING);
        int x = sm.width / 2 - shieldW / 2;
        int y = sm.height / 2 - shieldW / 2;
        int glowSize = shieldW * 2;
        int coaX = sm.width / 2 - shieldW / 36 * 36 / 2;
        d.blit(LoadingScreen.glow, MyDraw.TITLE, sm.width / 2 - glowSize / 2, y - glowSize / 2 + shieldW / 2, glowSize, glowSize);
        this.empireCOA.layout.drawShield(this.empireCOA, d, coaX, y, shieldW / 36, MyDraw.TITLE);
        if (!this.empireNameField.getText().isEmpty()) {
            Pt sz = d.textSize(this.empireNameField.getText().toUpperCase(), AGame.HUGE_FOUNT);
            d.text(MyDraw.TITLE_C + this.empireNameField.getText().toUpperCase(), AGame.HUGE_FOUNT, sm.width / 2 - (int)sz.x / 2, y + shieldW * 10 / 9 + MyDraw.WINDOW_INSET);
        }
        int oldY = y;
        int titleW = (int)d.textSize((String)Lang._t((String)"Game_Setup", (Object[])new Object[0]), (Fount)AGame.HUGE_FOUNT).x;
        d.text(MyDraw.TITLE_C + Lang._t("Game_Setup", new Object[0]), AGame.HUGE_FOUNT, sm.width / 2 - titleW / 2, MyDraw.SIDE_CLEARANCE);
        d.button(x += shieldW + MyDraw.UI_SPACING, y, panelW, Lang._t("Start_Game", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                GameSetupScreen.this.startGame();
            }
        }, !this.empireNameField.getText().isEmpty() && this.difficulty != null && this.mapSize != null);
        d.button(x, y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, panelW, Lang._t("Cancel", new Object[0]), new Runnable(){

            @Override
            public void run() {
                ((GameSetupScreen)GameSetupScreen.this).g.s = new MainMenu(GameSetupScreen.this.g, MainMenu.Submenu.CONQUEST);
            }
        });
        d.toggle(x, y += MyDraw.BUTTON_H + MyDraw.UI_SPACING, panelW, Lang._t("Strategy_Tips", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                ((GameSetupScreen)GameSetupScreen.this).g.strategicHelp = !((GameSetupScreen)GameSetupScreen.this).g.strategicHelp;
            }
        }, this.g.strategicHelp, true);
        d.toggle(x, y += MyDraw.UI_SPACING + MyDraw.BUTTON_H, panelW, Lang._t("Rapid_Commands", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                ((GameSetupScreen)GameSetupScreen.this).g.strategicRapidCommands = !((GameSetupScreen)GameSetupScreen.this).g.strategicRapidCommands;
            }
        }, this.g.strategicRapidCommands, true);
        d.tooltip((double)x, (double)y, (double)panelW, (double)MyDraw.BUTTON_H, Lang._t("Rapid_Commands_tooltip", new Object[0]));
        this.settingsScrollBar.draw(d, x, y += MyDraw.UI_SPACING + MyDraw.BUTTON_H, panelW, sm.height - MyDraw.SIDE_CLEARANCE - y, this.os, this);
        this.settingsScrollBarR.x = x;
        this.settingsScrollBarR.y = y;
        this.settingsScrollBarR.w = panelW;
        this.settingsScrollBarR.h = sm.height - MyDraw.SIDE_CLEARANCE - y;
        y = oldY;
        this.empireNameField.render(x -= shieldW + panelW + MyDraw.UI_SPACING * 2, y, panelW, d, sm, hs, cursor);
        d.drawWindow(x, y += MyDraw.textFieldH() + MyDraw.UI_SPACING, panelW, panelW);
        d.text(this.empireCOA.blazon() + "\n\n" + this.empireCOA.getBonusOrTechDesc(), AGame.FOUNT, x + MyDraw.WINDOW_INSET, y + MyDraw.WINDOW_INSET, panelW - MyDraw.WINDOW_INSET * 2);
        final GameSetupScreen gss = this;
        d.button(x + MyDraw.WINDOW_INSET, y + panelW - MyDraw.WINDOW_INSET - MyDraw.BUTTON_SPACING - MyDraw.BUTTON_H * 2, panelW - MyDraw.WINDOW_INSET * 2, Lang._t("Edit_Arms", new Object[0]), new Runnable(){

            @Override
            public void run() {
                d.state.hasClicked();
                ((GameSetupScreen)GameSetupScreen.this).g.s = new CoatEditor(GameSetupScreen.this.g, gss);
            }
        });
        d.button(x + MyDraw.WINDOW_INSET, y + panelW - MyDraw.WINDOW_INSET - MyDraw.BUTTON_H, panelW - MyDraw.WINDOW_INSET * 2, Lang._t("Random_Arms", new Object[0]), new Runnable(){

            @Override
            public void run() {
                d.state.hasClicked();
                GameSetupScreen.this.empireCOA = CoatOfArms.getRandom(AGame.ANIM_R, HeraldicStyle.ofName("player"));
            }
        });
    }

    @Override
    public ArrayList<String> music() {
        return null;
    }

    @Override
    public String appearancePostfix() {
        return "DAY";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    @Override
    public int getHeight(Object t, MyDraw d, int availableWidth) {
        return (AGame.BIG_FOUNT.lineHeight + MyDraw.BUTTON_SPACING) * 6 + Loadable.all(MapSize.class).size() * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) - MyDraw.BUTTON_SPACING + MyDraw.UI_SPACING + Loadable.all(DifficultyLevel.class).size() * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) - MyDraw.BUTTON_SPACING + MyDraw.UI_SPACING + Loadable.all(SeaLevelSetting.class).size() * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) - MyDraw.BUTTON_SPACING + MyDraw.UI_SPACING + Loadable.all(MonsterSetting.class).size() * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) - MyDraw.BUTTON_SPACING + MyDraw.UI_SPACING + Loadable.all(TechSpeedSetting.class).size() * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) - MyDraw.BUTTON_SPACING + MyDraw.UI_SPACING + (Tech.getMaxTier() + 2 - Tech.getMinTier()) * (MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING) - MyDraw.BUTTON_SPACING;
    }

    private void toggle(MyDraw d, int x, int y, int w, String text, String hotkey, InputRunnable onClick, boolean selected, boolean enabled) {
        if (y + MyDraw.BUTTON_H < this.settingsScrollBarR.y) {
            return;
        }
        d.toggle(x, y, w, text, hotkey, onClick, selected, enabled);
    }

    @Override
    public void draw(Object t, MyDraw d, int x, int y, int panelW) {
        d.text(Lang._t("setup_mapsize", new Object[0]), AGame.BIG_FOUNT, x, y);
        y += AGame.BIG_FOUNT.lineHeight + MyDraw.BUTTON_SPACING;
        for (final MapSize sz : Loadable.all(MapSize.class)) {
            this.toggle(d, x, y, panelW, sz.getName(), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    GameSetupScreen.this.mapSize = sz;
                }
            }, this.mapSize == sz, true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        d.text(Lang._t("setup_difficulty", new Object[0]), AGame.BIG_FOUNT, x, y += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING);
        y += AGame.BIG_FOUNT.lineHeight + MyDraw.BUTTON_SPACING;
        for (final DifficultyLevel dl : Loadable.all(DifficultyLevel.class)) {
            this.toggle(d, x, y, panelW, dl.getName(), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    GameSetupScreen.this.difficulty = dl;
                }
            }, this.difficulty == dl, true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        d.text(Lang._t("setup_sealevel", new Object[0]), AGame.BIG_FOUNT, x, y += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING);
        y += AGame.BIG_FOUNT.lineHeight + MyDraw.BUTTON_SPACING;
        for (final SeaLevelSetting sl : Loadable.all(SeaLevelSetting.class)) {
            this.toggle(d, x, y, panelW, sl.getName(), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    GameSetupScreen.this.seaLevelSetting = sl;
                }
            }, this.seaLevelSetting == sl, true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        d.text(Lang._t("setup_monsterity", new Object[0]), AGame.BIG_FOUNT, x, y += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING);
        y += AGame.BIG_FOUNT.lineHeight + MyDraw.BUTTON_SPACING;
        for (final MonsterSetting ms : Loadable.all(MonsterSetting.class)) {
            this.toggle(d, x, y, panelW, ms.getName(), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    GameSetupScreen.this.monsterity = ms;
                }
            }, this.monsterity == ms, true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        d.text(Lang._t("setup_techspeed", new Object[0]), AGame.BIG_FOUNT, x, y += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING);
        y += AGame.BIG_FOUNT.lineHeight + MyDraw.BUTTON_SPACING;
        for (final TechSpeedSetting ts : Loadable.all(TechSpeedSetting.class)) {
            this.toggle(d, x, y, panelW, ts.getName(), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    GameSetupScreen.this.techSpeed = ts;
                }
            }, this.techSpeed == ts, true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        d.text(Lang._t("setup_starttier", new Object[0]), AGame.BIG_FOUNT, x, y += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING);
        y += AGame.BIG_FOUNT.lineHeight + MyDraw.BUTTON_SPACING;
        for (int tier = Tech.getMinTier() - 1; tier <= Tech.getMaxTier(); ++tier) {
            final int myTier = tier;
            this.toggle(d, x, y, panelW, Lang._t("tier_x", "" + (myTier + 1)), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    GameSetupScreen.this.startingTechTier = myTier;
                }
            }, this.startingTechTier == myTier, true);
            y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
        }
        y += MyDraw.UI_SPACING - MyDraw.BUTTON_SPACING;
    }
}

