/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Blast;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.MiscCombatSound;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.catengine.Img;

public strictfp class Fragment {
    public SpritesheetBundle ssb;
    public Img img;
    public double x;
    public double y;
    public double dx;
    public double dy;
    public double angle;
    public double dangle;
    public int age;
    public int life;
    public int fiery;
    public int smoky;
    public boolean wreckage = false;
    public int fuze = -1;
    public boolean landed = false;

    public Fragment(SpritesheetBundle ssb, Img img, double x, double y, double dx, double dy, double angle, double dangle, int life, int burnAmt) {
        this.ssb = ssb;
        this.img = img;
        this.x = x;
        this.y = y;
        this.dx = dx;
        this.dy = dy;
        this.angle = angle;
        this.dangle = dangle;
        this.life = life;
        if (burnAmt > 0) {
            this.fiery = StrictMath.max(0, AGame.ANIM_R.nextInt(2 * burnAmt) - 10);
            this.smoky = StrictMath.max(0, AGame.ANIM_R.nextInt(5 * burnAmt) - 15);
        }
    }

    public Fragment(SpritesheetBundle ssb, Img img, double x, double y, double dx, double dy, double angle, int life, int burnAmt, int fuze) {
        this.ssb = ssb;
        this.img = img;
        this.x = x;
        this.y = y;
        this.dx = dx;
        this.dy = dy;
        this.angle = angle;
        this.dangle = 0.0;
        this.life = life;
        this.wreckage = true;
        this.fuze = fuze;
        if (burnAmt > 0) {
            this.fiery = StrictMath.max(0, AGame.ANIM_R.nextInt(2 * burnAmt) - 10);
            this.smoky = StrictMath.max(0, AGame.ANIM_R.nextInt(5 * burnAmt) - 15);
        }
    }

    public boolean tick(int ms, Combat c) {
        this.age += ms;
        this.dy += 0.001 * (double)ms / 2.0;
        this.y += this.dy * (double)ms;
        this.x += this.dx * (double)ms;
        this.angle += this.dangle * (double)ms;
        this.life -= ms;
        if (this.fuze >= 0) {
            this.fuze -= ms;
            if (this.fuze <= 0) {
                this.explode(c);
                return true;
            }
        }
        if (this.fiery > 0 && AGame.ANIM_R.nextInt(this.wreckage ? 30 : 10) == 2) {
            c.particles.add(new Particle(ParticleType.ofName("fire"), this.x + AGame.ANIM_R.nextDouble() * (double)this.img.srcWidth, this.y));
            --this.fiery;
        }
        if (AGame.ANIM_R.nextInt(this.wreckage ? 30000 : 80) < this.smoky) {
            c.particles.add(new Particle(ParticleType.ofName("smoke"), this.x + AGame.ANIM_R.nextDouble() * (double)this.img.srcWidth, this.y));
            --this.smoky;
        }
        if (c.landFormations.get(0).canParticleStick(this.x, this.y + (double)this.img.srcHeight) || c.landFormations.get(0).canParticleStick(this.x + (double)this.img.srcWidth, this.y + (double)this.img.srcHeight)) {
            if (this.wreckage) {
                this.dx = 0.0;
                this.dy = 0.0;
                this.y = StrictMath.min(c.landFormations.get(0).yBoundaryAt(this.x), c.landFormations.get(0).yBoundaryAt(this.x + (double)this.img.srcWidth)) - (double)this.img.srcHeight;
                this.landed = true;
                if (this.fuze >= 0) {
                    this.explode(c);
                    return true;
                }
            } else {
                return true;
            }
        }
        return this.life <= 0;
    }

    public void explode(Combat c) {
        int i;
        double scale = 0.3 + AGame.ANIM_R.nextDouble() * 0.6;
        int n = (int)(12.0 * scale);
        int explodeX = (int)this.x;
        int explodeY = (int)this.y;
        c.blasts.add(new Blast(explodeX, explodeY, scale * 15.0, scale * 10.0));
        int parts = 8;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("explode_backs"), explodeX, explodeY, scale));
        }
        parts = scale > 0.8 ? 1 : 0;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("shockwave"), explodeX, explodeY, scale));
        }
        parts = n;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("small_soot"), explodeX, explodeY));
            c.particles.add(new Particle(ParticleType.ofName("large_soot"), explodeX, explodeY));
        }
        if (!SimplePref.REDUCED_FLASHING.get()) {
            parts = 1;
            for (i = 0; i < parts; ++i) {
                c.particles.add(new Particle(ParticleType.ofName("explode"), explodeX, explodeY, scale));
            }
        }
        parts = 12;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("explode_bits"), explodeX, explodeY, scale));
        }
        c.play(MiscCombatSound.FRAGMENT_EXPLOSION, explodeX, explodeY, this.dx, this.dy, false);
    }
}

