/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Compression;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.FleetOwner;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.MonsterNest;
import com.zarkonnen.airships.Road;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Fleet
implements ShipList {
    public static final double SPEED_TO_MAP_PX_PER_MS = 0.02;
    public MapLocation location;
    public double sx;
    public double sy;
    public MapLocation destination;
    public double progress;
    public boolean fleeDestinationNeeded;
    public Road usingRoad;
    public ArrayList<Airship> actives = new ArrayList();
    public ArrayList<Airship> reserve = new ArrayList();
    public Pt interceptPoint;
    public Itinerary interceptItinerary;
    public Fleet interceptTarget;
    public final int id;

    public static boolean canFly(ArrayList<Airship> ships) {
        for (Airship s : ships) {
            if (!s.type.onGround) continue;
            return false;
        }
        return true;
    }

    public boolean canFly() {
        return Fleet.canFly(this.actives) && Fleet.canFly(this.reserve);
    }

    public boolean groundOnly() {
        for (Airship s : this.actives) {
            if (s.type.onGround) continue;
            return false;
        }
        for (Airship s : this.reserve) {
            if (s.type.onGround) continue;
            return false;
        }
        return true;
    }

    public boolean inTransit() {
        return this.destination != null || this.interceptPoint != null || this.interceptItinerary != null;
    }

    public int roadIndex() {
        return (int)this.exactRoadIndex();
    }

    public double exactRoadIndex() {
        if (this.interceptItinerary != null) {
            double p = this.progress;
            for (Segment s : this.interceptItinerary.segments) {
                if (p < (double)s.length()) {
                    return (double)s.startIndex + (double)s.direction * p;
                }
                p -= (double)s.length();
            }
            return this.interceptItinerary.segments.get((int)(this.interceptItinerary.segments.size() - 1)).endIndex;
        }
        if (this.destination == this.usingRoad.src) {
            return StrictMath.max(0.0, StrictMath.min((double)(this.usingRoad.path.size() - 1), (double)this.usingRoad.path.size() - this.progress));
        }
        return StrictMath.max(0.0, StrictMath.min((double)(this.usingRoad.path.size() - 1), this.progress));
    }

    public static int roadIndex(Road usingRoad, MapLocation destination, double progress) {
        if (destination == usingRoad.src) {
            return (int)StrictMath.max(0.0, StrictMath.min((double)(usingRoad.path.size() - 1), StrictMath.floor((double)usingRoad.path.size() - progress)));
        }
        return (int)StrictMath.max(0.0, StrictMath.min((double)(usingRoad.path.size() - 1), StrictMath.floor(progress)));
    }

    public double transitDistance() {
        if (this.destination == null && this.interceptTarget == null) {
            return 0.0;
        }
        if (this.interceptPoint != null) {
            return StrictMath.sqrt((this.sx - this.interceptPoint.x) * (this.sx - this.interceptPoint.x) + (this.sy - this.interceptPoint.y) * (this.sy - this.interceptPoint.y));
        }
        if (this.interceptItinerary != null) {
            int sum = this.interceptItinerary.finalWait;
            for (Segment s : this.interceptItinerary.segments) {
                sum += s.length();
            }
            return sum;
        }
        if (this.usingRoad != null) {
            return this.usingRoad.path.size();
        }
        return StrictMath.sqrt((this.sx - (double)this.destination.x) * (this.sx - (double)this.destination.x) + (this.sy - (double)this.destination.y) * (this.sy - (double)this.destination.y));
    }

    public double realX() {
        if (this.inTransit()) {
            if (this.usingRoad != null) {
                double ri = this.exactRoadIndex();
                double mixture = ri % 1.0;
                double xa = this.usingRoad.path.get((int)((int)StrictMath.floor((double)ri))).x;
                double xb = this.usingRoad.path.get((int)StrictMath.min((int)(this.usingRoad.path.size() - 1), (int)((int)StrictMath.ceil((double)ri)))).x;
                return (1.0 - mixture) * xa + mixture * xb;
            }
            double result = this.interceptPoint != null ? this.sx + (this.interceptPoint.x - this.sx) * StrictMath.min(1.0, this.progress / this.transitDistance()) : this.sx + ((double)this.destination.x - this.sx) * StrictMath.min(1.0, this.progress / this.transitDistance());
            if (Double.isNaN(result) || Double.isNaN(result)) {
                return this.sx;
            }
            return result;
        }
        if (this.location == null) {
            return this.sx;
        }
        return this.location.x;
    }

    public double realY() {
        if (this.inTransit()) {
            if (this.usingRoad != null) {
                double ri = this.exactRoadIndex();
                double mixture = ri % 1.0;
                double ya = this.usingRoad.path.get((int)((int)StrictMath.floor((double)ri))).y;
                double yb = this.usingRoad.path.get((int)StrictMath.min((int)(this.usingRoad.path.size() - 1), (int)((int)StrictMath.ceil((double)ri)))).y;
                return (1.0 - mixture) * ya + mixture * yb;
            }
            double result = this.interceptPoint != null ? this.sy + (this.interceptPoint.y - this.sy) * StrictMath.min(1.0, this.progress / this.transitDistance()) : this.sy + ((double)this.destination.y - this.sy) * StrictMath.min(1.0, this.progress / this.transitDistance());
            if (Double.isNaN(result) || Double.isNaN(result)) {
                return this.sy;
            }
            return result;
        }
        if (this.location == null) {
            return this.sy;
        }
        return this.location.y;
    }

    public int maintenanceCost() {
        int c = 0;
        for (Airship ship : this.actives) {
            c += ship.maintenanceCost();
        }
        for (Airship ship : this.reserve) {
            c += ship.maintenanceCost();
        }
        return c;
    }

    public static double speed(ArrayList<Airship> ships) {
        double speed = 1.5;
        for (Airship s : ships) {
            speed = StrictMath.min(speed, s.getMainMapSpeed());
        }
        return speed;
    }

    public double speed() {
        return StrictMath.min(Fleet.speed(this.actives), Fleet.speed(this.reserve));
    }

    public Airship getShip(String networkID) {
        for (Airship s : this.actives) {
            if (!s.networkID.equals(networkID)) continue;
            return s;
        }
        for (Airship s : this.reserve) {
            if (!s.networkID.equals(networkID)) continue;
            return s;
        }
        return null;
    }

    public Fleet(MapLocation location, WorldMap wm) {
        this.location = location;
        this.sx = location.x;
        this.sy = location.y;
        this.id = wm.fleetIDCounter++;
    }

    public Fleet(Fleet original, WorldMap wm) {
        this.actives.addAll(original.actives);
        this.destination = original.destination;
        this.fleeDestinationNeeded = original.fleeDestinationNeeded;
        this.interceptPoint = original.interceptPoint;
        this.interceptItinerary = original.interceptItinerary;
        this.interceptTarget = original.interceptTarget;
        this.location = original.location;
        this.progress = original.progress;
        this.reserve.addAll(original.reserve);
        this.sx = original.sx;
        this.sy = original.sy;
        this.usingRoad = original.usingRoad;
        this.id = wm.fleetIDCounter++;
    }

    public Fleet(JSONObject o, WorldMap wm) {
        int i;
        JSONArray a;
        this.sx = o.getDouble("sx");
        this.sy = o.getDouble("sy");
        this.progress = o.optDouble("progress", 0.0);
        this.fleeDestinationNeeded = o.getBoolean("fleeDestinationNeeded");
        this.id = o.has("id") ? o.getInt("id") : wm.fleetIDCounter++;
        if (o.has("_ships")) {
            a = o.getJSONArray("_ships");
            for (i = 0; i < a.length(); ++i) {
                this.actives.add(new Airship(new JSONObject(Compression.decompressFromString(a.getString(i)))));
            }
        } else {
            a = o.getJSONArray("ships");
            for (i = 0; i < a.length(); ++i) {
                this.actives.add(new Airship(a.getJSONObject(i)));
            }
        }
        if (o.has("_reserve")) {
            a = o.getJSONArray("_reserve");
            for (i = 0; i < a.length(); ++i) {
                this.reserve.add(new Airship(new JSONObject(Compression.decompressFromString(a.getString(i)))));
            }
        } else if (o.has("reserve")) {
            a = o.getJSONArray("reserve");
            for (i = 0; i < a.length(); ++i) {
                this.reserve.add(new Airship(a.getJSONObject(i)));
            }
        }
        if (o.has("interceptPointX")) {
            this.interceptPoint = new Pt(o.getDouble("interceptPointX"), o.getDouble("interceptPointY"));
        }
    }

    public void finish(JSONObject o, WorldMap m, BonusSet bonuses) {
        if (o.has("locationEmpire")) {
            this.location = m.empires.get((int)o.getInt((String)"locationEmpire")).cities.get(o.getInt("locationCity"));
        }
        if (o.has("destinationEmpire")) {
            this.destination = m.empires.get((int)o.getInt((String)"destinationEmpire")).cities.get(o.getInt("destinationCity"));
        }
        if (o.has("locationNest")) {
            this.location = m.nests.get(o.getInt("locationNest"));
        }
        if (o.has("destinationNest")) {
            this.destination = m.nests.get(o.getInt("destinationNest"));
        }
        if (o.has("interceptTargetEmpireIndex")) {
            this.interceptTarget = m.empires.get(o.getInt("interceptTargetEmpireIndex")).getFleets().get(o.getInt("interceptTargetIndex"));
        }
        if (o.has("interceptTargetNestIndex")) {
            this.interceptTarget = m.nests.get(o.getInt("interceptTargetNestIndex")).getFleets().get(o.getInt("interceptTargetIndex"));
        }
        if (o.has("usingRoad")) {
            this.usingRoad = m.roads.get(o.getInt("usingRoad"));
        }
        if (o.has("interceptItinerary")) {
            this.interceptItinerary = new Itinerary(o.getJSONObject("interceptItinerary"), m);
        }
        for (Airship s : this.actives) {
            s.currentBonuses = bonuses;
        }
        for (Airship s : this.reserve) {
            s.currentBonuses = bonuses;
        }
    }

    private static double guardNaN(double v) {
        return Double.isNaN(v) || Double.isInfinite(v) ? 0.0 : v;
    }

    public JSONObject toJSON(WorldMap m) {
        Empire owner;
        JSONObject o = new JSONObject().put("sx", Fleet.guardNaN(this.sx)).put("sy", Fleet.guardNaN(this.sy)).put("fleeDestinationNeeded", this.fleeDestinationNeeded).put("progress", Fleet.guardNaN(this.progress));
        if (this.location != null) {
            if (this.location instanceof City) {
                owner = m.owner((City)this.location);
                o.put("locationEmpire", m.empires.indexOf(owner));
                o.put("locationCity", owner.cities.indexOf(this.location));
            } else if (this.location instanceof MonsterNest) {
                o.put("locationNest", m.nests.indexOf(this.location));
            }
        }
        if (this.destination != null) {
            if (this.destination instanceof City) {
                owner = m.owner((City)this.destination);
                o.put("destinationEmpire", m.empires.indexOf(owner));
                o.put("destinationCity", owner.cities.indexOf(this.destination));
            } else if (this.destination instanceof MonsterNest) {
                o.put("destinationNest", m.nests.indexOf(this.destination));
            }
        }
        if (this.usingRoad != null) {
            o.put("usingRoad", m.roads.indexOf(this.usingRoad));
        }
        if (this.interceptPoint != null) {
            o.put("interceptPointX", this.interceptPoint.x);
            o.put("interceptPointY", this.interceptPoint.y);
        }
        if (this.interceptItinerary != null) {
            o.put("interceptItinerary", this.interceptItinerary.toJSON(m));
        }
        if (this.interceptTarget != null) {
            FleetOwner fo = m.owner(this.interceptTarget);
            if (fo instanceof Empire) {
                o.put("interceptTargetEmpireIndex", m.empires.indexOf(fo));
            } else if (fo instanceof MonsterNest) {
                o.put("interceptTargetNestIndex", m.nests.indexOf(fo));
            }
            o.put("interceptTargetIndex", fo.getFleets().indexOf(this.interceptTarget));
        }
        JSONArray a = new JSONArray();
        o.put("_ships", a);
        for (Airship ship : this.actives) {
            a.put(Compression.compressToString(ship.toJSON(null).toString()));
        }
        a = new JSONArray();
        o.put("_reserve", a);
        for (Airship ship : this.reserve) {
            a.put(Compression.compressToString(ship.toJSON(null).toString()));
        }
        return o;
    }

    public boolean canTravelTo(MapLocation destination, WorldMap wm, FleetOwner owner) {
        if (this.destination == destination) {
            return true;
        }
        if (this.canFly()) {
            return true;
        }
        if (this.usingRoad != null) {
            return this.usingRoad.src == destination || this.usingRoad.dst == destination;
        }
        Road road = wm.getConnection(this.location, destination);
        return road != null && (!road.seaRoute || owner == wm.defender(destination));
    }

    public double distanceTo(City newDestination, WorldMap wm) {
        if (!this.canFly()) {
            Road road = wm.getConnection(this.location, newDestination);
            if (this.usingRoad != null) {
                if (this.usingRoad != road) {
                    return -1.0;
                }
                if (newDestination == this.destination) {
                    return (double)road.path.size() - this.progress;
                }
                return this.progress;
            }
            return road.path.size();
        }
        return StrictMath.sqrt((this.realX() - (double)newDestination.x) * (this.realX() - (double)newDestination.x) + (this.realY() - (double)newDestination.y) * (this.realY() - (double)newDestination.y));
    }

    public boolean travelTo(MapLocation destination, WorldMap wm) {
        if (this.destination == destination) {
            return true;
        }
        if (this.canFly()) {
            this.sx = this.realX();
            this.sy = this.realY();
            this.destination = destination;
            this.location = null;
            this.progress = 0.0;
            this.interceptPoint = null;
            this.interceptItinerary = null;
            this.interceptTarget = null;
            this.fleeDestinationNeeded = false;
            this.usingRoad = null;
            this.broadcastChangedDirection(wm);
            return true;
        }
        if (this.usingRoad != null) {
            if (this.usingRoad.src == destination || this.usingRoad.dst == destination) {
                this.progress = this.usingRoad.dst == destination ? (double)this.roadIndex() : (double)(this.usingRoad.path.size() - this.roadIndex());
                this.interceptTarget = null;
                this.interceptItinerary = null;
                this.destination = destination;
                this.fleeDestinationNeeded = false;
                this.broadcastChangedDirection(wm);
                return true;
            }
            return false;
        }
        Road road = wm.getConnection(this.location, destination);
        FleetOwner destinationDefender = wm.defender(destination);
        if (road != null && (!road.seaRoute || wm.owner(this) == destinationDefender || destinationDefender instanceof MonsterNest && ((MonsterNest)destinationDefender).type == null)) {
            this.usingRoad = road;
            this.location = null;
            this.destination = destination;
            this.progress = 0.0;
            this.interceptPoint = null;
            this.interceptItinerary = null;
            this.interceptTarget = null;
            this.fleeDestinationNeeded = false;
            this.broadcastChangedDirection(wm);
            return true;
        }
        return false;
    }

    public void stopAndAskForHelp(WorldMap wm) {
        if (this.realX() == 0.0 && this.realY() == 0.0) {
            AirshipGame.instance.reportError("StopAndAskForHelp with realx/y of 0", null, this.toJSON(wm).toString(), false, true);
        }
        if (this.location == null && this.usingRoad == null) {
            this.sx = this.realX();
            this.sy = this.realY();
            this.location = null;
            this.progress = 0.0;
        }
        if (this.usingRoad != null) {
            this.progress = this.roadIndex();
        }
        this.destination = null;
        this.interceptPoint = null;
        this.interceptItinerary = null;
        this.interceptTarget = null;
        this.fleeDestinationNeeded = true;
    }

    public boolean checkInterceptTargetValid(WorldMap map) {
        if (this.interceptTarget != null && map.owner(this.interceptTarget) == null) {
            this.stopAndAskForHelp(map);
            return true;
        }
        return false;
    }

    public boolean tick(int ms, FleetOwner owner, WorldMap map) {
        if (this.checkInterceptTargetValid(map)) {
            return false;
        }
        if (this.fleeDestinationNeeded && this.location != null) {
            boolean hasLandships = false;
            boolean hasAirships = false;
            for (Airship airship : this.actives) {
                if (airship.type == ShipType.LANDSHIP) {
                    hasLandships = true;
                    continue;
                }
                hasAirships = true;
            }
            for (Airship airship : this.reserve) {
                if (airship.type == ShipType.LANDSHIP) {
                    hasLandships = true;
                    continue;
                }
                hasAirships = true;
            }
            if (hasLandships) {
                boolean roadFound = false;
                for (Road r : map.roads) {
                    if (r.src == this.location) {
                        if (r.seaRoute) {
                            if (map.defender(r.src) == owner) {
                                roadFound = true;
                                break;
                            }
                        } else {
                            roadFound = true;
                            break;
                        }
                    }
                    if (r.dst != this.location) continue;
                    if (r.seaRoute) {
                        if (map.defender(r.src) != owner) continue;
                        roadFound = true;
                        break;
                    }
                    roadFound = true;
                    break;
                }
                if (!roadFound) {
                    if (hasAirships) {
                        Iterator<Airship> iterator = this.actives.iterator();
                        while (iterator.hasNext()) {
                            if (iterator.next().type != ShipType.LANDSHIP) continue;
                            iterator.remove();
                        }
                        Iterator<Airship> iterator2 = this.reserve.iterator();
                        while (iterator2.hasNext()) {
                            if (iterator2.next().type != ShipType.LANDSHIP) continue;
                            iterator2.remove();
                        }
                    } else {
                        this.broadcastDestroyed(map);
                        return true;
                    }
                }
            }
        }
        if (this.destination != null) {
            this.progress += (double)ms * this.speed() * 0.02;
            if (this.progress >= this.transitDistance()) {
                this.location = this.destination;
                this.destination = null;
                this.usingRoad = null;
                for (Fleet f : owner.getFleets()) {
                    if (f == this || f.location != this.location) continue;
                    f.actives.addAll(this.actives);
                    f.reserve.addAll(this.reserve);
                    this.location.layoutGarrison(map);
                    this.broadcastDestroyed(map);
                    return true;
                }
                this.broadcastArrived(map);
                this.location.layoutGarrison(map);
            }
        }
        if (!(this.interceptPoint == null && this.interceptItinerary == null || this.fleeDestinationNeeded)) {
            this.progress += (double)ms * this.speed() * 0.02;
            if (this.interceptItinerary != null) {
                this.usingRoad = null;
                double p = this.progress;
                for (Segment segment : this.interceptItinerary.segments) {
                    if (p <= (double)segment.length()) {
                        this.usingRoad = segment.road;
                        break;
                    }
                    p -= (double)segment.length();
                }
                if (this.usingRoad == null) {
                    this.usingRoad = this.interceptItinerary.segments.get((int)(this.interceptItinerary.segments.size() - 1)).road;
                }
            }
        }
        return false;
    }

    public boolean containsAny(Fleet oldF) {
        for (Airship s : this.actives) {
            if (!oldF.actives.contains(s) && !oldF.reserve.contains(s)) continue;
            return true;
        }
        for (Airship s : this.reserve) {
            if (!oldF.actives.contains(s) && !oldF.reserve.contains(s)) continue;
            return true;
        }
        return false;
    }

    public boolean doIntercept(Fleet target, WorldMap wm) {
        Intercept icept = this.getFlightIntercept(target, null, wm);
        if (icept == null) {
            return false;
        }
        this.sx = this.realX();
        this.sy = this.realY();
        this.progress = 0.0;
        this.location = null;
        this.destination = null;
        this.interceptPoint = icept.flyToPt;
        this.interceptItinerary = icept.itinerary;
        this.interceptTarget = target;
        this.fleeDestinationNeeded = false;
        if (this.interceptItinerary != null && !this.interceptItinerary.segments.isEmpty()) {
            this.usingRoad = this.interceptItinerary.segments.get((int)0).road;
        }
        return true;
    }

    public void broadcastChangedDirection(WorldMap wm) {
        for (Empire e : wm.empires) {
            for (Fleet f : e.getFleets()) {
                f.fleetChangedDirection(this, wm);
            }
        }
    }

    public void fleetChangedDirection(Fleet fl, WorldMap wm) {
        if (fl == this.interceptTarget) {
            if (!this.doIntercept(this.interceptTarget, wm)) {
                this.stopAndAskForHelp(wm);
            }
            this.broadcastStopped(wm);
        }
    }

    public void broadcastArrived(WorldMap wm) {
        for (Empire e : wm.empires) {
            for (Fleet f : e.getFleets()) {
                f.fleetArrived(this, wm);
            }
        }
    }

    public void fleetArrived(Fleet fl, WorldMap wm) {
        if (fl == this.interceptTarget) {
            this.stopAndAskForHelp(wm);
            this.broadcastStopped(wm);
        }
    }

    public void broadcastDestroyed(WorldMap wm) {
        for (Empire e : wm.empires) {
            for (Fleet f : e.getFleets()) {
                f.fleetDestroyed(this, wm);
            }
        }
    }

    public void fleetDestroyed(Fleet fl, WorldMap wm) {
        if (fl == this.interceptTarget) {
            this.stopAndAskForHelp(wm);
            this.broadcastStopped(wm);
        }
    }

    public void broadcastStopped(WorldMap wm) {
        for (Empire e : wm.empires) {
            for (Fleet f : e.getFleets()) {
                f.fleetStopped(this, wm);
            }
        }
    }

    public void fleetStopped(Fleet fl, WorldMap wm) {
        if (fl == this.interceptTarget) {
            this.stopAndAskForHelp(wm);
        }
    }

    public Intercept getFlightIntercept(Fleet target, ArrayList<Airship> shipsToSend, final WorldMap wm) {
        if (shipsToSend == null) {
            shipsToSend = new ArrayList();
            shipsToSend.addAll(this.actives);
            shipsToSend.addAll(this.reserve);
        }
        if (target.location != null) {
            return null;
        }
        if (target.destination == null) {
            return null;
        }
        if (!Fleet.canFly(shipsToSend)) {
            if (target.usingRoad == null) {
                return null;
            }
            ArrayList<Itinerary> its = new ArrayList<Itinerary>();
            if (this.usingRoad != null) {
                its.add(new Itinerary(new Segment(this.usingRoad, this.roadIndex(), this.roadIndex(), 1)));
                its.add(new Itinerary(new Segment(this.usingRoad, this.roadIndex(), this.roadIndex(), -1)));
            } else if (this.location != null) {
                for (Road r : wm.roads) {
                    if (r.seaRoute) continue;
                    if (r.src == this.location) {
                        its.add(new Itinerary(new Segment(r, 0, 0, 1)));
                    }
                    if (r.dst != this.location) continue;
                    its.add(new Itinerary(new Segment(r, r.path.size() - 1, r.path.size() - 1, -1)));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                for (Airship s : shipsToSend) {
                    sb.append(", actives: ").append(this.actives.indexOf(s)).append(" reserve: ").append(this.reserve.indexOf(s));
                }
                wm.g.reportError("Fleet cannot fly, is not using road, and has no location!", null, this.toJSON(wm).toString() + "\nshipsToSend: " + sb, false, true);
                return null;
            }
            double mySpeed = Fleet.speed(shipsToSend);
            double targetSpeed = target.speed();
            double targetProgress = target.progress;
            boolean targetMovingForwards = target.usingRoad.dst == target.destination;
            HashSet<UsedForkPoint> ufps = new HashSet<UsedForkPoint>();
            ArrayList<Itinerary> l2 = new ArrayList<Itinerary>();
            while (!its.isEmpty()) {
                int targetRI = Fleet.roadIndex(target.usingRoad, target.destination, targetProgress);
                l2.clear();
                l2.addAll(its);
                for (Itinerary it : l2) {
                    Itinerary it2;
                    UsedForkPoint ufp;
                    int otherIndex;
                    int direction;
                    Segment seg = it.segments.get(it.segments.size() - 1);
                    if (seg.road.overlaps.get(seg.endIndex).containsKey(target.usingRoad)) {
                        int overlapRI = seg.road.overlaps.get(seg.endIndex).get(target.usingRoad);
                        if (targetMovingForwards) {
                            if (overlapRI >= targetRI) {
                                it.finalWait = (int)((double)(overlapRI - targetRI) / targetSpeed * mySpeed);
                                return new Intercept(it);
                            }
                        } else if (overlapRI <= targetRI) {
                            it.finalWait = (int)((double)(targetRI - overlapRI) / targetSpeed * mySpeed);
                            return new Intercept(it);
                        }
                    }
                    seg.endIndex += seg.direction;
                    if (seg.endIndex <= 0 || seg.endIndex >= seg.road.path.size() - 1) {
                        its.remove(it);
                        continue;
                    }
                    if (it.segments.size() >= 4 || StrictMath.abs(seg.endIndex - seg.startIndex) <= 2 || seg.endIndex - seg.direction < 5 || seg.endIndex - seg.direction >= seg.road.path.size() - 5) continue;
                    HashSet<MapLocation> forkedToLocs = new HashSet<MapLocation>();
                    ArrayList<Road> coRoads = new ArrayList<Road>(seg.road.overlaps.get(seg.endIndex - seg.direction).keySet());
                    Collections.sort(coRoads, new Comparator<Road>(){

                        @Override
                        public int compare(Road o1, Road o2) {
                            return wm.roads.indexOf(o1) - wm.roads.indexOf(o2);
                        }
                    });
                    for (Road coRoad : coRoads) {
                        if (coRoad.seaRoute || it.usedRoad(coRoad) || forkedToLocs.contains(coRoad.src) || forkedToLocs.contains(coRoad.dst) || seg.road.overlaps.get(seg.endIndex).containsKey(coRoad) || seg.endIndex - seg.direction * 2 < 0 || seg.endIndex - seg.direction * 2 >= seg.road.path.size() || !seg.road.overlaps.get(seg.endIndex - seg.direction * 2).containsKey(coRoad) || (direction = (otherIndex = seg.road.overlaps.get(seg.endIndex - seg.direction).get(coRoad).intValue()) - seg.road.overlaps.get(seg.endIndex - seg.direction * 2).get(coRoad)) == 0 || ufps.contains(ufp = new UsedForkPoint(coRoad, otherIndex))) continue;
                        ufps.add(ufp);
                        it2 = it.dupe();
                        it2.segments.get((int)(it2.segments.size() - 1)).endIndex -= it2.segments.get((int)(it2.segments.size() - 1)).direction;
                        it2.segments.add(new Segment(coRoad, otherIndex, otherIndex, direction));
                        its.add(it2);
                        forkedToLocs.add(coRoad.src);
                        forkedToLocs.add(coRoad.dst);
                    }
                    coRoads = new ArrayList<Road>(seg.road.overlaps.get(seg.endIndex).keySet());
                    Collections.sort(coRoads, new Comparator<Road>(){

                        @Override
                        public int compare(Road o1, Road o2) {
                            return wm.roads.indexOf(o1) - wm.roads.indexOf(o2);
                        }
                    });
                    for (Road coRoad : coRoads) {
                        if (coRoad.seaRoute || it.usedRoad(coRoad) || forkedToLocs.contains(coRoad.src) || forkedToLocs.contains(coRoad.dst) || seg.road.overlaps.get(seg.endIndex - seg.direction).containsKey(coRoad) || seg.endIndex + seg.direction < 0 || seg.endIndex + seg.direction >= seg.road.path.size() || !seg.road.overlaps.get(seg.endIndex + seg.direction).containsKey(coRoad) || (direction = (otherIndex = seg.road.overlaps.get(seg.endIndex).get(coRoad).intValue()) - seg.road.overlaps.get(seg.endIndex + seg.direction).get(coRoad)) == 0 || ufps.contains(ufp = new UsedForkPoint(coRoad, otherIndex))) continue;
                        ufps.add(ufp);
                        it2 = it.dupe();
                        it2.segments.get((int)(it2.segments.size() - 1)).endIndex -= it2.segments.get((int)(it2.segments.size() - 1)).direction;
                        it2.segments.add(new Segment(coRoad, otherIndex, otherIndex, direction));
                        its.add(it2);
                        forkedToLocs.add(coRoad.src);
                        forkedToLocs.add(coRoad.dst);
                    }
                }
                if (!((targetProgress += targetSpeed / mySpeed) >= (double)target.usingRoad.path.size())) continue;
                break;
            }
            return null;
        }
        if (target.usingRoad == null) {
            double aStartX = this.realX();
            double aStartY = this.realY();
            double bStartX = target.realX();
            double bStartY = target.realY();
            double aSpeed = Fleet.speed(shipsToSend) * 0.02;
            double bSpeed = target.speed() * 0.02;
            double bDist = target.transitDistance() - target.progress;
            double bVelocityX = (double)target.destination.x - target.sx;
            double bVelocityY = (double)target.destination.y - target.sy;
            double vLength = StrictMath.sqrt(bVelocityX * bVelocityX + bVelocityY * bVelocityY);
            bVelocityX = bVelocityX / vLength * bSpeed;
            bVelocityY = bVelocityY / vLength * bSpeed;
            double dx = bStartX - aStartX;
            double dy = bStartY - aStartY;
            double t = -1.0;
            if (this.speed() == target.speed()) {
                double angle = StrictMath.atan2(bVelocityY, bVelocityX) - StrictMath.atan2(-dy, -dx);
                if (angle >= 0.0) {
                    double hyp = StrictMath.sqrt(dx * dx + dy * dy) / 2.0 / StrictMath.cos(angle);
                    t = hyp / StrictMath.sqrt(bVelocityX * bVelocityX + bVelocityY * bVelocityY);
                }
            } else {
                double tPlus = (-2.0 * (dx * bVelocityX + dy * bVelocityY) + StrictMath.sqrt(4.0 * (dx * bVelocityX + dy * bVelocityY) * (dx * bVelocityX + dy * bVelocityY) - 4.0 * (-aSpeed * aSpeed + bVelocityX * bVelocityX + bVelocityY * bVelocityY) * (dx * dx + dy * dy))) / (2.0 * (-aSpeed * aSpeed + bVelocityX * bVelocityX + bVelocityY * bVelocityY));
                double tMinus = (-2.0 * (dx * bVelocityX + dy * bVelocityY) - StrictMath.sqrt(4.0 * (dx * bVelocityX + dy * bVelocityY) * (dx * bVelocityX + dy * bVelocityY) - 4.0 * (-aSpeed * aSpeed + bVelocityX * bVelocityX + bVelocityY * bVelocityY) * (dx * dx + dy * dy))) / (2.0 * (-aSpeed * aSpeed + bVelocityX * bVelocityX + bVelocityY * bVelocityY));
                double d = t = Double.isNaN(tPlus) || Double.isInfinite(tPlus) || tPlus < 0.0 ? tMinus : StrictMath.min(tMinus, tPlus);
            }
            if (t >= 0.0 && t < bDist / bSpeed) {
                double interceptX = bStartX + t * bVelocityX;
                double interceptY = bStartY + t * bVelocityY;
                return new Intercept(new Pt(interceptX, interceptY));
            }
        } else {
            double tProgress = target.progress;
            double tDistance = target.transitDistance();
            double tSpeed = target.speed() * 0.02;
            double mySpeed = Fleet.speed(shipsToSend) * 0.02;
            double myX = this.realX();
            double myY = this.realY();
            double myRadius = 0.0;
            while (!((tProgress += tSpeed) >= tDistance)) {
                int tRoadIndex;
                myRadius += mySpeed;
                int n = tRoadIndex = target.destination == target.usingRoad.dst ? (int)StrictMath.max(0.0, StrictMath.min((double)(target.usingRoad.path.size() - 1), StrictMath.floor(tProgress))) : (int)StrictMath.max(0.0, StrictMath.min((double)(target.usingRoad.path.size() - 1), StrictMath.floor((double)target.usingRoad.path.size() - tProgress)));
                double tX = target.usingRoad.path.get((int)tRoadIndex).x;
                double tY = target.usingRoad.path.get((int)tRoadIndex).y;
                if (!((tX - myX) * (tX - myX) + (tY - myY) * (tY - myY) <= myRadius * myRadius)) continue;
                return new Intercept(new Pt(tX, tY));
            }
        }
        return null;
    }

    public boolean canIntercept(Fleet target, ArrayList<Airship> shipsToSend, WorldMap wm) {
        return this.getFlightIntercept(target, shipsToSend, wm) != null;
    }

    public ArrayList<Airship> getAllShips() {
        ArrayList<Airship> l = new ArrayList<Airship>();
        l.addAll(this.actives);
        l.addAll(this.reserve);
        return l;
    }

    public int totalCost() {
        int cost = 0;
        int asz = this.actives.size();
        for (int i = 0; i < asz; ++i) {
            cost += this.actives.get(i).getCost();
        }
        int rsz = this.reserve.size();
        for (int i = 0; i < rsz; ++i) {
            cost += this.reserve.get(i).getCost();
        }
        return cost;
    }

    @Override
    public int size() {
        return this.actives.size();
    }

    @Override
    public Airship get(int index) {
        return this.actives.get(index);
    }

    public strictfp class UsedForkPoint {
        public final Road r;
        public final int index;

        public UsedForkPoint(Road r, int index) {
            this.r = r;
            this.index = index;
        }

        public boolean equals(Object o2) {
            return o2 instanceof UsedForkPoint && ((UsedForkPoint)o2).index == this.index && ((UsedForkPoint)o2).r == this.r;
        }

        public int hashCode() {
            return this.r.hashCode() + this.index;
        }
    }

    public strictfp static class Intercept {
        public final Pt flyToPt;
        public final Itinerary itinerary;

        public Intercept(Itinerary itinerary) {
            this.flyToPt = null;
            this.itinerary = itinerary;
        }

        public Intercept(Pt flyToPt) {
            this.flyToPt = flyToPt;
            this.itinerary = null;
        }
    }

    public strictfp static class Itinerary {
        public ArrayList<Segment> segments = new ArrayList();
        public int finalWait = 0;

        public Itinerary(Segment s) {
            this.segments.add(s);
        }

        public Itinerary(JSONObject o, WorldMap wm) {
            this.finalWait = o.getInt("finalWait");
            JSONArray segA = o.getJSONArray("segments");
            for (int i = 0; i < segA.length(); ++i) {
                this.segments.add(new Segment(segA.getJSONObject(i), wm));
            }
        }

        public JSONObject toJSON(WorldMap wm) {
            JSONObject o = new JSONObject().put("finalWait", this.finalWait);
            JSONArray a = new JSONArray();
            o.put("segments", a);
            for (Segment s : this.segments) {
                a.put(s.toJSON(wm));
            }
            return o;
        }

        private Itinerary() {
        }

        public Itinerary dupe() {
            Itinerary i2 = new Itinerary();
            for (Segment seg : this.segments) {
                i2.segments.add(seg.dupe());
            }
            return i2;
        }

        public boolean usedRoad(Road r) {
            for (Segment s : this.segments) {
                if (s.road != r) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Segment s : this.segments) {
                sb.append(s.road).append(" ").append(s.startIndex).append("-").append(s.endIndex).append(", ");
            }
            sb.append(this.finalWait);
            return sb.toString();
        }
    }

    public strictfp static class Segment {
        public Road road;
        public int startIndex;
        public int endIndex;
        public int direction;

        public Segment(Road road, int startIndex, int endIndex, int direction) {
            this.road = road;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.direction = direction;
        }

        public Segment(JSONObject o, WorldMap wm) {
            this.road = wm.roads.get(o.getInt("road"));
            this.startIndex = o.getInt("startIndex");
            this.endIndex = o.getInt("endIndex");
            this.direction = o.getInt("direction");
        }

        public JSONObject toJSON(WorldMap wm) {
            return new JSONObject().put("road", wm.roads.indexOf(this.road)).put("startIndex", this.startIndex).put("endIndex", this.endIndex).put("direction", this.direction);
        }

        public Segment dupe() {
            return new Segment(this.road, this.startIndex, this.endIndex, this.direction);
        }

        public int length() {
            return StrictMath.abs(this.endIndex - this.startIndex);
        }
    }
}

