/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.StrategicLobbyScreen;
import com.zarkonnen.airships.StrategicPlayerInfo;

public strictfp class EmpiresAdapter
implements ScrollBar.ScrollElementAdapter<Empire> {
    private final StrategicLobbyScreen sls;

    public EmpiresAdapter(StrategicLobbyScreen sls) {
        this.sls = sls;
    }

    @Override
    public int getHeight(Empire t, MyDraw d, int availableWidth) {
        if (t == null) {
            int nSpectators = 0;
            for (StrategicPlayerInfo pi : this.sls.channelPlayers.values()) {
                if (pi.claimedEmpireIndex != -1) continue;
                ++nSpectators;
            }
            return StrictMath.max(MyDraw.BUTTON_H, (1 + nSpectators) * AGame.FOUNT.lineHeight) + MyDraw.SCROLL_EL_SPACING;
        }
        return StrictMath.max(MyDraw.BUTTON_H, StrictMath.max(68, AGame.FOUNT.lineHeight * 2)) + MyDraw.SCROLL_EL_SPACING;
    }

    @Override
    public void draw(final Empire e, MyDraw d, int x, int y, int width) {
        if (e == null) {
            boolean isSpectating = false;
            int y2 = y;
            d.text(Lang._t("Spectators_", new Object[0]), AGame.FOUNT, x, y2);
            for (StrategicPlayerInfo pi : this.sls.channelPlayers.values()) {
                if (pi.claimedEmpireIndex != -1) continue;
                y2 += AGame.FOUNT.lineHeight;
                if (pi.id == this.sls.g.playerID()) {
                    isSpectating = true;
                    d.text(MyDraw.SELECTED_C + AGame.makeFileSafe(pi.name), AGame.FOUNT, x, y2);
                    continue;
                }
                d.text(AGame.makeFileSafe(pi.name), AGame.FOUNT, x, y2);
            }
            if (!this.sls.readySent) {
                int bw = d.bw(Lang._t("Spectate", new Object[0]));
                d.button(x + width - bw, y, bw, Lang._t("Spectate", new Object[0]), null, new Runnable(){

                    @Override
                    public void run() {
                        EmpiresAdapter.this.sls.yieldEmpire();
                    }
                }, !isSpectating);
            }
            return;
        }
        e.arms.draw(d, x + 2, y + 2, 64);
        d.drawPanelBorder(x, y, 68, 68);
        String ownerName = null;
        boolean ownedByThisPlayer = false;
        for (StrategicPlayerInfo pi : this.sls.channelPlayers.values()) {
            if (pi.claimedEmpireIndex != this.sls.loadedGame.map.empires.indexOf(e)) continue;
            ownerName = pi.name;
            if (pi.id != this.sls.g.playerID()) break;
            ownedByThisPlayer = true;
            break;
        }
        d.text((ownedByThisPlayer ? MyDraw.SELECTED_C : "") + e.name + (ownerName == null ? "" : "\n" + ownerName), AGame.FOUNT, x + 64 + 4 + MyDraw.UI_SPACING, y);
        if (!this.sls.readySent) {
            if (ownedByThisPlayer) {
                int bw = d.bw(Lang._t("Yield_Empire", new Object[0]));
                d.button(x + width - bw, y, bw, Lang._t("Yield_Empire", new Object[0]), null, new Runnable(){

                    @Override
                    public void run() {
                        EmpiresAdapter.this.sls.yieldEmpire();
                    }
                });
            } else {
                int bw = d.bw(Lang._t("Claim_Empire", new Object[0]));
                d.button(x + width - bw, y, bw, Lang._t("Claim_Empire", new Object[0]), null, new Runnable(){

                    @Override
                    public void run() {
                        EmpiresAdapter.this.sls.claimLoadedEmpire(e);
                    }
                }, ownerName == null);
            }
        }
    }
}

