/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.StrategicLobbyScreen;
import com.zarkonnen.airships.StrategicPlayerInfo;
import org.json.JSONObject;

public strictfp class EmpireSlotsAdapter
implements ScrollBar.ScrollElementAdapter<Integer> {
    private final StrategicLobbyScreen sls;
    public JSONObject armsJSON;

    public EmpireSlotsAdapter(StrategicLobbyScreen sls) {
        this.sls = sls;
    }

    @Override
    public int getHeight(Integer t, MyDraw d, int availableWidth) {
        if (t == -1) {
            int nSpectators = 0;
            for (StrategicPlayerInfo pi : this.sls.channelPlayers.values()) {
                if (pi.claimedEmpireIndex != -1) continue;
                ++nSpectators;
            }
            return StrictMath.max(MyDraw.BUTTON_H, (1 + nSpectators) * AGame.FOUNT.lineHeight) + MyDraw.SCROLL_EL_SPACING;
        }
        return StrictMath.max(MyDraw.BUTTON_H, StrictMath.max(68, AGame.FOUNT.lineHeight * 2)) + MyDraw.SCROLL_EL_SPACING;
    }

    @Override
    public void draw(final Integer index, MyDraw d, int x, int y, int width) {
        if (index == -1) {
            boolean isSpectating = false;
            int y2 = y;
            d.text(Lang._t("Spectators_", new Object[0]), AGame.FOUNT, x, y2);
            for (StrategicPlayerInfo pi : this.sls.channelPlayers.values()) {
                if (pi.claimedEmpireIndex != -1) continue;
                y2 += AGame.FOUNT.lineHeight;
                if (pi.id == this.sls.g.playerID()) {
                    isSpectating = true;
                    d.text(MyDraw.SELECTED_C + AGame.makeFileSafe(pi.name), AGame.FOUNT, x, y2);
                    continue;
                }
                d.text(AGame.makeFileSafe(pi.name), AGame.FOUNT, x, y2);
            }
            if (!this.sls.readySent) {
                int bw = d.bw(Lang._t("Spectate", new Object[0]));
                d.button(x + width - bw, y, bw, Lang._t("Spectate", new Object[0]), null, new Runnable(){

                    @Override
                    public void run() {
                        EmpireSlotsAdapter.this.sls.yieldEmpire();
                    }
                }, !isSpectating);
            }
            return;
        }
        StrategicPlayerInfo owner = null;
        boolean ownedByThisPlayer = false;
        for (StrategicPlayerInfo pi : this.sls.channelPlayers.values()) {
            if (pi.claimedEmpireIndex != index) continue;
            owner = pi;
            if (pi.id != this.sls.g.playerID()) break;
            ownedByThisPlayer = true;
            break;
        }
        if (owner != null && owner.armsJSON != null) {
            new CoatOfArms(owner.armsJSON).draw(d, x + 2, y + 2, 64);
        }
        d.drawPanelBorder(x, y, 68, 68);
        if (owner != null && ownedByThisPlayer) {
            d.text(MyDraw.SELECTED_C + AGame.makeFileSafe(owner.name) + "\n" + this.sls.empireNameField.getText(), AGame.FOUNT, x + 64 + 4 + MyDraw.UI_SPACING, y);
        } else if (owner != null) {
            d.text(AGame.makeFileSafe(owner.name) + (owner.empireName == null ? "" : "\n" + AGame.makeFileSafe(owner.empireName)), AGame.FOUNT, x + 64 + 4 + MyDraw.UI_SPACING, y);
        }
        if (!this.sls.readySent) {
            if (ownedByThisPlayer) {
                int bw = d.bw(Lang._t("Yield_Empire", new Object[0]));
                d.button(x + width - bw, y, bw, Lang._t("Yield_Empire", new Object[0]), null, new Runnable(){

                    @Override
                    public void run() {
                        EmpireSlotsAdapter.this.sls.yieldEmpire();
                    }
                });
            } else {
                int bw = d.bw(Lang._t("Claim_Empire", new Object[0]));
                d.button(x + width - bw, y, bw, Lang._t("Claim_Empire", new Object[0]), null, new Runnable(){

                    @Override
                    public void run() {
                        EmpireSlotsAdapter.this.sls.claimEmpire(index, ((EmpireSlotsAdapter)EmpireSlotsAdapter.this).sls.armsJSON, ((EmpireSlotsAdapter)EmpireSlotsAdapter.this).sls.empireNameField.getText());
                    }
                }, owner == null);
            }
        }
    }
}

