/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AmmoDistOverlay;
import com.zarkonnen.airships.CoalDistOverlay;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.EditorOverlayType;
import com.zarkonnen.airships.ExplosionDamageOverlay;
import com.zarkonnen.airships.HPOverlay;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PathingOverlay;
import com.zarkonnen.airships.RepairDistOverlay;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WaterDistOverlay;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;

public strictfp class EditorOverlay
implements UniScreen.ShipOverlay {
    public EditorOverlayType eot = null;
    public boolean active = false;
    public boolean needForced = true;
    public ArrayList<EditorOverlayType> overlays = new ArrayList();

    public EditorOverlay() {
        this.overlays.add(new PathingOverlay());
        this.overlays.add(new HPOverlay());
        this.overlays.add(new WaterDistOverlay());
        this.overlays.add(new RepairDistOverlay());
        this.overlays.add(new AmmoDistOverlay());
        this.overlays.add(new CoalDistOverlay());
        this.overlays.add(new ExplosionDamageOverlay());
        this.eot = this.overlays.get(0);
    }

    @Override
    public void draw(MyDraw d, Airship ship, UniScreen us) {
        int ty;
        int tx;
        if (!this.active || !(us.intent instanceof EditShipIntent) || this.eot == null) {
            return;
        }
        this.eot.update(ship, this.needForced);
        this.needForced = false;
        for (Tile t : ship.tiles) {
            tx = ship.getIntX() + ship.gridXToWorldX(t.x, 1) * 16;
            ty = ship.getIntY() + t.y * 16;
            Clr c = this.eot.overlayColor(t);
            if (c != null) {
                d.rect(c, tx, ty, 16.0, 16.0);
            }
            this.eot.draw(d, t, ship, tx, ty, us.zoom, 0);
        }
        for (Tile t : ship.tiles) {
            tx = ship.getIntX() + ship.gridXToWorldX(t.x, 1) * 16;
            ty = ship.getIntY() + t.y * 16;
            this.eot.draw(d, t, ship, tx, ty, us.zoom, 1);
        }
        if (us.zoom >= 1.2) {
            d.resetTransforms();
            for (Tile t : ship.tiles) {
                tx = ship.getIntX() + ship.gridXToWorldX(t.x, 1) * 16;
                ty = ship.getIntY() + t.y * 16;
                String tt = this.eot.tooltip(t);
                if (tt == null) continue;
                d.text(tt, AGame.FOUNT, (int)(us.worldToScreenX(tx) + (16.0 * us.zoom - d.textSize((String)tt, (Fount)AGame.FOUNT).x) / 2.0), (int)(us.worldToScreenY(ty) + (16.0 * us.zoom - (double)AGame.FOUNT.height) / 2.0) + 1);
            }
            d.scale(us.zoom, us.zoom);
            d.shift(us.adjScrollX, us.adjScrollY);
        }
    }

    @Override
    public boolean drawIfOffScreen() {
        return false;
    }
}

