/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.Decal;
import com.zarkonnen.airships.EditMode;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Input;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;

public strictfp abstract class EditShipIntent
implements UniScreen.Intent,
SingleShipIntent {
    public boolean justSaved = true;
    public boolean lastModificationWasBig = true;
    public boolean pleaseZoomToShip;
    public EditMode mode = EditMode.MODULES;
    public boolean firstTick = true;
    public boolean prevErrorFree;
    private final ArrayList<Airship> undos = new ArrayList();
    private final ArrayList<Airship> redos = new ArrayList();
    private Airship currentShipCopy = null;
    private long lastAutosaved = System.currentTimeMillis();
    public static final int AUTOSAVE_INTERVAL = 20000;
    public static boolean autosaveFile2 = false;
    public HashSet<Module> selectedModules = new HashSet();
    public HashSet<Decal> selectedDecals = new HashSet();
    public boolean hasSelectedModule;
    public boolean hasPlacedModule;
    public boolean hasRemovedModule;
    public boolean hasSelectedArmour;
    public boolean hasPlacedArmour;
    public boolean hasSelectedDecal;
    public boolean hasPlacedDecal;
    public boolean hasRemovedDecal;
    public boolean hasSelectedPaint;
    public boolean hasPlacedPaint;
    public boolean hasFilledPaint;

    public abstract Empire getPlayerEmpire();

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        boolean errorFree;
        long t;
        if (this.pleaseZoomToShip && !this.firstTick) {
            ZoomToFitButton.zoomToEditShip(in, us);
            this.pleaseZoomToShip = false;
        }
        Airship ship = this.getShip(us);
        this.selectedDecals.retainAll(ship.decals);
        this.selectedModules.retainAll(ship.modules);
        if (this.currentShipCopy == null) {
            this.currentShipCopy = ship.clone();
        }
        if ((t = System.currentTimeMillis()) >= this.lastAutosaved + 20000L && ship.modules.size() > 5) {
            this.autosave(us);
            this.lastAutosaved = t;
        }
        if (ship.type.onGround && us.city != null) {
            ship.setY(PlaceShipTool.getPlacement((Airship)ship, (double)ship.getX(), (double)ship.getY(), (boolean)ship.flipped, (UniScreen)us, (boolean)true).y);
        }
        if ((errorFree = ShipEditorUtils.shipErrors(ship, false, false, 0, null, null, us).isEmpty()) && !this.prevErrorFree) {
            in.play("spin_up", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
        }
        this.prevErrorFree = errorFree;
        this.firstTick = false;
        this.mode.tick(us, in);
    }

    @Override
    public final void setShip(UniScreen us, Airship ship) {
        this.currentShipCopy = ship == null ? null : ship.clone();
        this.undos.clear();
        this.redos.clear();
        this.doSetShip(us, ship);
    }

    public abstract void doSetShip(UniScreen var1, Airship var2);

    public boolean canUndo() {
        return !this.undos.isEmpty();
    }

    public boolean canRedo() {
        return !this.redos.isEmpty();
    }

    public void undo(UniScreen us) {
        if (this.canUndo()) {
            this.redos.add(0, this.getShip(us));
            Airship ship = this.undos.get(this.undos.size() - 1);
            this.doSetShip(us, ship);
            this.undos.remove(this.undos.size() - 1);
            this.currentShipCopy = ship.clone();
        }
    }

    public void redo(UniScreen us) {
        if (this.canRedo()) {
            this.undos.add(this.getShip(us));
            Airship ship = this.redos.get(0);
            this.doSetShip(us, ship);
            this.redos.remove(0);
            this.currentShipCopy = ship.clone();
        }
    }

    public Airship getOriginal(UniScreen us) {
        return null;
    }

    @Override
    public ShipType type(UniScreen us) {
        return this.getShip((UniScreen)us).type;
    }

    public void centerShip(UniScreen us) {
        this.pleaseZoomToShip = true;
    }

    @Override
    public void justSaved(UniScreen us) {
        this.justSaved = true;
    }

    @Override
    public void modified(UniScreen us, boolean big) {
        this.justSaved = false;
        if (big || this.lastModificationWasBig || this.undos.isEmpty()) {
            this.undos.add(this.currentShipCopy);
        }
        if (this.undos.size() > 40) {
            this.undos.remove(0);
        }
        this.lastModificationWasBig = big;
        this.redos.clear();
        this.currentShipCopy = this.getShip(us).clone();
    }

    public CoatOfArms getArms(UniScreen us) {
        if (us.city != null) {
            return us.wm.owner((City)us.city).arms;
        }
        return us.g.getBestCOA();
    }

    public void autosave(UniScreen us) {
        try {
            Airship ship = this.getShip(us);
            if (ship == null) {
                return;
            }
            ConstructionBackend backend = ShipEditorUtils.shipsList(((SingleShipIntent)((Object)us.intent)).type(us), null);
            File f = backend.getFile(FileScreen.splitPath("AUTOSAVE" + (autosaveFile2 ? "_2" : "") + ".json"));
            if (f == null) {
                return;
            }
            FileUtils.write((File)f, (CharSequence)ship.toJSON(null).toString(4), (String)"UTF-8");
            autosaveFile2 = !autosaveFile2;
        }
        catch (OutOfMemoryError oome) {
            oome.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            us.g.reportError("NPE in autosave", e, null, false, true);
        }
    }

    @Override
    public boolean showOutside() {
        return this.mode != EditMode.MODULES;
    }

    @Override
    public boolean showDecals() {
        return true;
    }

    @Override
    public boolean drawAsBlueprint() {
        return true;
    }

    @Override
    public boolean allowMultiSelect() {
        return false;
    }
}

