/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.Challenge;
import com.zarkonnen.airships.ChallengeEditShipIntent;
import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.Decal;
import com.zarkonnen.airships.DecalType;
import com.zarkonnen.airships.EditInfoPanel;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.EditSelectionOverlay;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.ExternalApp;
import com.zarkonnen.airships.FlagSpec;
import com.zarkonnen.airships.GUIScale;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleCategory;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MovingModule;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PaintArmourTool;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.airships.PlaceArmourTool;
import com.zarkonnen.airships.PlaceDecalTool;
import com.zarkonnen.airships.PlaceModuleTool;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SearchMatcher;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.TileMask;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.geom.Polygon;
import org.newdawn.slick.geom.Shape;

public enum EditMode implements ScrollBar.ScrollElementAdapter<Object>
{
    MODULES("M", "edit_mode_MODULES", false){
        public final Img FIXER = new Img("ui", 480, 416, 16, 16, false);
        public final Img FIXER_BG = new Img("ui", 496, 416, 16, 16, false);
        public final Img FLIP = new Img("ui", 304, 512, 16, 16, false);
        public final Img FLIP_V = new Img("ui", 336, 512, 16, 16, false);

        @Override
        public boolean allowSelect() {
            return true;
        }

        @Override
        public void dragOngoing(UniScreen us, Input in, double startX, double startY, double endX, double endY) {
        }

        @Override
        public void dragComplete(UniScreen us, Input in, double startX, double startY, double endX, double endY) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            Airship ship = esi.getShip(us);
            EditSelectionOverlay eso = us.shipOverlay(EditSelectionOverlay.class);
            eso.shiftX = 0;
            eso.shiftY = 0;
            eso.fail = false;
            int sx = (int)Math.floor((startX - ship.getX()) / 16.0);
            int sy = (int)Math.floor((startY - ship.getY()) / 16.0);
            Module startM = ship.moduleAt(ship.gridXToWorldX(sx, 1), sy);
            if (startM == null || !esi.selectedModules.contains(startM) || esi.selectedModules.containsAll(ship.modules)) {
                double tmp;
                if (endX < startX) {
                    tmp = startX;
                    startX = endX;
                    endX = tmp;
                }
                if (endY < startY) {
                    tmp = startY;
                    startY = endY;
                    endY = tmp;
                }
                int smx = ship.gridXToWorldX((int)Math.floor((startX - ship.getX()) / 16.0), 1);
                int smy = (int)Math.floor((startY - ship.getY()) / 16.0);
                int emx = ship.gridXToWorldX((int)Math.floor((endX - ship.getX()) / 16.0), 1);
                int emy = (int)Math.floor((endY - ship.getY()) / 16.0);
                if (emx < smx) {
                    int tmp2 = smx;
                    smx = emx;
                    emx = tmp2;
                }
                HashSet<Module> modules = new HashSet<Module>();
                for (int y = smy; y <= emy; ++y) {
                    for (int x = smx; x <= emx; ++x) {
                        Module m = ship.moduleAt(x, y);
                        if (m == null) continue;
                        modules.add(m);
                    }
                }
                if (!in.keyDown("LSHIFT")) {
                    esi.selectedModules.clear();
                }
                esi.selectedModules.addAll(modules);
            } else {
                int ex = (int)Math.floor((endX - ship.getX()) / 16.0);
                int ey = (int)Math.floor((endY - ship.getY()) / 16.0);
                int dx = ship.flipped ? sx - ex : ex - sx;
                int dy = ey - sy;
                if (dx == 0 && dy == 0) {
                    return;
                }
                ArrayList<MovingModule> mms = new ArrayList<MovingModule>();
                for (Module m : esi.selectedModules) {
                    MovingModule mm = new MovingModule(ship, m.x, m.y);
                    if (!mm.canAdd(ship, mm.x + dx, mm.y + dy, esi.selectedModules)) {
                        return;
                    }
                    mms.add(mm);
                }
                Module anchor = null;
                for (Module m : ship.modules) {
                    if (esi.selectedModules.contains(m)) continue;
                    anchor = m;
                    break;
                }
                if (anchor == null) {
                    System.out.println("no anchor found");
                    return;
                }
                int anchorX = anchor.x;
                int anchorY = anchor.y;
                for (Module m : esi.selectedModules) {
                    ship.quickRemoveModule(m);
                }
                ship.repair();
                dx += anchor.x - anchorX;
                dy += anchor.y - anchorY;
                int[] shift = new int[]{0, 0};
                ArrayList<Module> newModules = new ArrayList<Module>();
                for (MovingModule mm : mms) {
                    newModules.add(mm.add(ship, mm.x + dx, mm.y + dy, esi.selectedModules, shift));
                    dx += shift[0];
                    dy += shift[1];
                }
                ship.repair();
                esi.selectedModules.clear();
                esi.selectedModules.addAll(newModules);
                esi.modified(us, true);
            }
        }

        @Override
        public boolean showDragRect(UniScreen us, double startX, double startY, double endX, double endY) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            Airship ship = esi.getShip(us);
            EditSelectionOverlay eso = us.shipOverlay(EditSelectionOverlay.class);
            int sx = (int)Math.floor((startX - ship.getX()) / 16.0);
            int sy = (int)Math.floor((startY - ship.getY()) / 16.0);
            Module m = ship.moduleAt(ship.gridXToWorldX(sx, 1), sy);
            if (m == null || !esi.selectedModules.contains(m) || esi.selectedModules.containsAll(ship.modules)) {
                eso.shiftX = 0;
                eso.shiftY = 0;
                eso.fail = false;
                return true;
            }
            int ex = (int)Math.floor((endX - ship.getX()) / 16.0);
            int ey = (int)Math.floor((endY - ship.getY()) / 16.0);
            eso.shiftX = ex - sx;
            eso.shiftY = ey - sy;
            eso.fail = false;
            int dx = ship.flipped ? sx - ex : ex - sx;
            int dy = ey - sy;
            for (Module sm : esi.selectedModules) {
                MovingModule mm = new MovingModule(ship, sm.x, sm.y);
                if (mm.canAdd(ship, mm.x + dx, mm.y + dy, esi.selectedModules)) continue;
                eso.fail = true;
                break;
            }
            return false;
        }

        @Override
        public void tick(UniScreen us, Input in) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            Airship ship = esi.getShip(us);
            if (!us.textInputOccurring() && us.tool == UniScreen.NAVIGATE && !esi.selectedModules.isEmpty()) {
                if (in.keyPressed("DELETE") || in.keyPressed("BACK")) {
                    for (Module m : esi.selectedModules) {
                        ship.removeModule(m);
                    }
                    esi.selectedModules.clear();
                    esi.modified(us, true);
                } else if (in.keyPressed(Keys.get("edit_duplicate", "H"))) {
                    int selXMin = 100000;
                    int selXMax = -100000;
                    int selYMin = 100000;
                    int selYMax = -100000;
                    for (Module m : esi.selectedModules) {
                        selXMin = Math.min(m.x, selXMin);
                        selXMax = Math.max(m.x + m.type.getW(), selXMax);
                        selYMin = Math.min(m.y, selYMin);
                        selYMax = Math.max(m.y + m.type.getH(), selYMax);
                    }
                    int selW = selXMax - selXMin;
                    int selH = selYMax - selYMin;
                    int[][] candidates = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {-1, 1}, {1, -1}, {-1, -1}};
                    ArrayList<MovingModule> mms = new ArrayList<MovingModule>();
                    for (Module sm : esi.selectedModules) {
                        mms.add(new MovingModule(ship, sm.x, sm.y));
                    }
                    int mmss = mms.size();
                    for (int extraD = 0; extraD < 40; ++extraD) {
                        block4: for (int ci = 0; ci < candidates.length; ++ci) {
                            int dx = candidates[ci][0] * (selW + extraD);
                            int dy = candidates[ci][1] * (selH + extraD);
                            for (int mmi = 0; mmi < mmss; ++mmi) {
                                MovingModule mm = (MovingModule)mms.get(mmi);
                                if (!mm.canAdd(ship, mm.x + dx, mm.y + dy, Collections.EMPTY_LIST)) continue block4;
                            }
                            esi.selectedModules.clear();
                            int[] shift = new int[]{0, 0};
                            for (int mmi = 0; mmi < mmss; ++mmi) {
                                MovingModule mm = (MovingModule)mms.get(mmi);
                                esi.selectedModules.add(mm.add(ship, mm.x + dx, mm.y + dy, Collections.EMPTY_LIST, shift));
                                dx += shift[0];
                                dy += shift[1];
                            }
                            ship.repair();
                            esi.modified(us, true);
                            return;
                        }
                    }
                }
            }
        }

        @Override
        public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            if (!us.textInputOccurring() && us.tool == UniScreen.NAVIGATE && !esi.selectedModules.isEmpty()) {
                Pt sz = d.textSize(Lang._t("Press_x_to_duplicate_and_backspace_or_delete_to_remove", Keys.get("edit_duplicate", "H")), AGame.FOUNT);
                d.text(Lang._t("Press_x_to_duplicate_and_backspace_or_delete_to_remove", Keys.get("edit_duplicate", "H")), AGame.FOUNT, (int)((double)sm.width - sz.x - 5.0), (double)sm.height - sz.y - 3.0);
            }
            EditSelectionOverlay eso = us.shipOverlay(EditSelectionOverlay.class);
            if (!(eso.shiftX == 0 && eso.shiftY == 0 || esi.selectedModules.isEmpty())) {
                d.state.setCursor("DRAG", null);
            } else if (us.tool == UniScreen.NAVIGATE && cursor.y > (double)MyDraw.TOP_BAR_H && cursor.x > (double)us.panel(EditInfoPanel.class).myWidth) {
                double cx = us.screenToWorldX(cursor.x);
                double cy = us.screenToWorldY(cursor.y);
                Airship ship = esi.getShip(us);
                for (Module m : esi.selectedModules) {
                    if (!ship.modules.contains(m)) continue;
                    double decX = ship.getX() + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16);
                    double decY = ship.getY() + (double)(m.y * 16);
                    if (!(cx > decX) || !(cy > decY) || !(cx < decX + (double)(m.type.getH() * 16)) || !(cy < decY + (double)(m.type.getH() * 16))) continue;
                    d.state.setCursor("DRAG", null);
                    break;
                }
            }
        }

        @Override
        public void click(UniScreen us, Input in, Pt p) {
            int my;
            int mx;
            EditShipIntent esi = (EditShipIntent)us.intent;
            Airship ship = esi.getShip(us);
            Module m = ship.moduleAt(mx = ship.gridXToWorldX((int)Math.floor((p.x - ship.getX()) / 16.0), 1), my = (int)Math.floor((p.y - ship.getY()) / 16.0));
            if (m != null) {
                if (in.keyDown("LSHIFT")) {
                    if (esi.selectedModules.contains(m)) {
                        esi.selectedModules.remove(m);
                    } else {
                        esi.selectedModules.add(m);
                    }
                } else {
                    esi.selectedModules.clear();
                    esi.selectedModules.add(m);
                }
            } else if (!in.keyDown("LSHIFT")) {
                esi.selectedModules.clear();
            }
        }

        @Override
        public int getHeight(Object t, MyDraw d, int availableWidth) {
            int scale;
            Entry e = (Entry)t;
            if (e.o == null || e.o instanceof ModuleCategory) {
                return 16 + MyDraw.SCROLL_EL_SPACING;
            }
            int n = scale = AirshipGame.instance.currentGUIScale == GUIScale.LARGE ? 2 : 1;
            if (e.o instanceof ModuleType && (this.canFlip(e) || this.canFlipVertically(e))) {
                return Math.max(((ModuleType)e.o).getH() * 16 * scale, MyDraw.ICON_BUTTON_SZ) + MyDraw.SCROLL_EL_SPACING;
            }
            return ((ModuleType)e.o).getH() * 16 * scale + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void stepSelect(int delta, UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            int currentIndex = -1;
            if (us.tool instanceof PlaceModuleTool) {
                for (int i = 0; i < l.size(); ++i) {
                    if (!(l.get(i) instanceof Entry)) continue;
                    Entry e = (Entry)l.get(i);
                    if (e.o != ((PlaceModuleTool)us.tool).mt) continue;
                    currentIndex = i;
                }
            }
            int newIndex = (currentIndex + delta + l.size()) % l.size();
            us.tool = new PlaceModuleTool((ModuleType)((Entry)l.get((int)newIndex)).o, false);
        }

        @Override
        public void selectFirst(UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            for (Object o : l) {
                if (!(o instanceof Entry) || !(((Entry)o).o instanceof ModuleType)) continue;
                us.tool = new PlaceModuleTool((ModuleType)((Entry)o).o, false);
                return;
            }
        }

        @Override
        public void draw(Object t, MyDraw d, int x, int y, int width) {
            boolean selected;
            int scale = AirshipGame.instance.currentGUIScale == GUIScale.LARGE ? 2 : 1;
            final Entry entry = (Entry)t;
            boolean bl = selected = entry.us.tool instanceof PlaceModuleTool && entry.p.modSel(entry.us) == entry.o;
            if (entry.o instanceof ModuleCategory) {
                final Entry e = (Entry)t;
                final boolean open = e.p.openCategories.contains(e.o);
                d.hook(x, y, width, 16 + MyDraw.SCROLL_EL_SPACING, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        if (open) {
                            e.p.openCategories.remove(e.o);
                        } else {
                            e.p.openCategories.add((ModuleCategory)e.o);
                        }
                    }
                });
                d.blit(open ? MyDraw.TRIANGLE_OPEN : MyDraw.TRIANGLE_CLOSED, x + 4, y);
                d.text(((ModuleCategory)e.o).getName(), AGame.FOUNT, x + 4 + MyDraw.TRIANGLE_OPEN.srcWidth + MyDraw.SCROLL_EL_SPACING, y);
            } else {
                d.shift(x, y);
                d.scale(scale, scale);
                final Entry e = (Entry)t;
                for (ExternalApp ea : ((ModuleType)e.o).getExternalApps(e.ship.currentBonuses, false, false)) {
                    ea.app.draw(d, ea.dx * 16, ea.dy * 16, 0, e.ship.flipped);
                }
                if (!((ModuleType)e.o).isExternal() && ((ModuleType)e.o).getArmourType() == null) {
                    ArmourType backArmour = e.p.armSel(e.us);
                    if (backArmour == null) {
                        backArmour = ArmourType.ofName("MED_WOOD");
                    }
                    if (((ModuleType)e.o).getArmourType() != null) {
                        backArmour = ((ModuleType)e.o).getArmourType();
                    }
                    if (backArmour != null && !backArmour.damagedApps.get(e.ship.currentBonuses).isEmpty()) {
                        int gx;
                        if (((ModuleType)e.o).getArmourMask(e.ship.currentBonuses) != null) {
                            for (int gy = 0; gy < ((ModuleType)e.o).getH(); ++gy) {
                                for (gx = 0; gx < ((ModuleType)e.o).getW(); ++gx) {
                                    TileMask tm = ((ModuleType)e.o).getTileMasks(e.ship.currentBonuses)[gy][e.ship.flipped ? ((ModuleType)e.o).getTileMasks(e.ship.currentBonuses)[0].length - gx - 1 : gx];
                                    if (e.ship.flipped) {
                                        tm = tm.flipped;
                                    }
                                    backArmour.damagedApps.get(e.ship.currentBonuses).get(0).maskedDrawFallback(d, gx * 16, gy * 16, 16.0, 16.0, 0, new Clr(91, 91, 91), false, tm);
                                }
                            }
                        } else {
                            for (int gy = 0; gy < ((ModuleType)e.o).getH(); ++gy) {
                                for (gx = 0; gx < ((ModuleType)e.o).getW(); ++gx) {
                                    backArmour.damagedApps.get(e.ship.currentBonuses).get(0).draw(d, gx * 16, gy * 16, 0, new Clr(91, 91, 91), false);
                                }
                            }
                        }
                    }
                }
                if (((ModuleType)e.o).weaponAppearance(e.ship.currentBonuses) != null && (((ModuleType)e.o).weaponAppearance((BonusSet)e.ship.currentBonuses).barrel != null || ((ModuleType)e.o).weaponAppearance((BonusSet)e.ship.currentBonuses).barrelAnimation != null)) {
                    Pt offset;
                    Img barrel;
                    double angle;
                    ModuleType mt = (ModuleType)e.o;
                    Airship ship = e.ship;
                    double d2 = angle = ship.flipped ? -mt.getFireArc((BonusSet)e.ship.currentBonuses).getMiddle().radians : mt.getFireArc((BonusSet)e.ship.currentBonuses).getMiddle().radians;
                    if (mt.isFlipped()) {
                        angle += Math.PI;
                    }
                    WeaponAppearance wa = mt.weaponAppearance(e.ship.currentBonuses);
                    Img img = barrel = ship.flipped ? wa.flippedbarrel : wa.barrel;
                    if (wa.barrelAnimation != null) {
                        barrel = ship.flipped ? wa.flippedBarrelAnimation.frames.get(0) : wa.barrelAnimation.frames.get(0);
                    }
                    Pt pt = offset = ship.flipped ? wa.flippedBarrelOffset : wa.barrelOffset;
                    if (barrel.machineImgCache != null) {
                        ((Image)barrel.machineImgCache).setFilter(9728);
                    }
                    d.blit(barrel, (int)offset.x, (int)offset.y, angle);
                }
                ((ModuleType)e.o).getApp(e.ship.currentBonuses).draw(d, 0.0, 0.0, 0, e.ship.flipped);
                d.resetTransforms();
                d.drawWoodGrain(6 + x + 48 * scale, y, width, ((ModuleType)e.o).getH() * 16 * scale + 12 + MyDraw.PROGRESS_BAR_H);
                int hookStart = Math.max(e.p.listTop, y);
                int hookEnd = Math.min(e.p.listBottom, y + ((ModuleType)e.o).getH() * 16 + MyDraw.SCROLL_EL_SPACING + 8);
                d.hook(x, y, width, hookEnd - hookStart, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        if (in.clicked() == null && e.us.tool instanceof PlaceModuleTool && ((PlaceModuleTool)e.us.tool).dragMode) {
                            return;
                        }
                        e.us.tool = new PlaceModuleTool((ModuleType)e.o, in.clicked() == null);
                        e.p.searchSelectionMade = true;
                    }
                });
                boolean fixer = e.ship.fixers.contains(e.o);
                String name = ((ModuleType)e.o).getName();
                int totalCost = ((ModuleType)e.o).getCost(e.ship.constructionBonuses);
                if (!((ModuleType)e.o).isExternal()) {
                    totalCost += ((ModuleType)e.o).getW() * ((ModuleType)e.o).getH() * e.p.lastArmourType.getCost(e.ship.constructionBonuses);
                }
                if (((ModuleType)e.o).getArmourType() != null) {
                    totalCost += ((ModuleType)e.o).getW() * ((ModuleType)e.o).getH() * ((ModuleType)e.o).getArmourType().getCost(e.ship.constructionBonuses);
                }
                String cost = "$" + totalCost;
                int textMaxW = width - 48 * scale - MyDraw.SCROLL_EL_SPACING - 4 - (int)d.textSize((String)cost, (Fount)AGame.FOUNT).x - MyDraw.UI_SPACING;
                if (d.textSize((String)name, (Fount)AGame.FOUNT).x > (double)textMaxW) {
                    String name2 = name.substring(0, name.length() - 4);
                    while (true) {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (!(d.textSize((String)stringBuilder.append((String)name2).append((String)"...").toString(), (Fount)AGame.FOUNT).x > (double)textMaxW)) break;
                        name2 = name2.substring(0, name2.length() - 1);
                    }
                    name = name2 + "...";
                }
                d.text((selected ? MyDraw.SELECTED_C : "") + name, AGame.FOUNT, x + 48 * scale + MyDraw.SCROLL_EL_SPACING + 4, y);
                if (fixer) {
                    int fixerX = x + 48 * scale + MyDraw.SCROLL_EL_SPACING + 4 + (int)d.textSize((String)name, (Fount)AGame.FOUNT).x + MyDraw.SCROLL_EL_SPACING;
                    d.blit(this.FIXER_BG, new Clr(187, 66, 29), fixerX, y);
                    d.blit(this.FIXER, fixerX, y);
                    d.tooltip((double)x, (double)y, (double)width, (double)(((ModuleType)e.o).getH() * 16 + MyDraw.SCROLL_EL_SPACING + 4), Lang._t("module_fixer_help", new Object[0]) + "\n\n" + ((ModuleType)e.o).getDescription(e.ship.constructionBonuses));
                } else {
                    d.tooltip((double)x, (double)y, (double)width, (double)(((ModuleType)e.o).getH() * 16 + MyDraw.SCROLL_EL_SPACING + 4), ((ModuleType)e.o).getDescription(e.ship.constructionBonuses));
                }
                d.text(cost, AGame.FOUNT, x + width - (int)d.textSize((String)cost, (Fount)AGame.FOUNT).x, y);
                int x2 = x + width - MyDraw.ICON_BUTTON_SZ - (int)d.textSize((String)"$1000", (Fount)AGame.FOUNT).x;
                if (this.canFlip(e)) {
                    d.iconButton(x2, y, this.FLIP, new Runnable(){

                        @Override
                        public void run() {
                            entry.us.tool = new PlaceModuleTool(((ModuleType)e.o).getFlippedIfAvailable(), false);
                            e.p.showFlippedModules = !e.p.showFlippedModules;
                        }
                    }, true);
                    x2 -= MyDraw.ICON_BUTTON_SZ + MyDraw.BUTTON_SPACING;
                }
                if (this.canFlipVertically(e)) {
                    d.iconButton(x2, y, this.FLIP_V, new Runnable(){

                        @Override
                        public void run() {
                            entry.us.tool = new PlaceModuleTool(((ModuleType)e.o).getVerticalFlippedIfAvailable(), false);
                            e.p.showVerticallyFlippedModules = !e.p.showVerticallyFlippedModules;
                        }
                    }, true);
                    x2 -= MyDraw.ICON_BUTTON_SZ + MyDraw.BUTTON_SPACING;
                }
            }
        }

        private boolean canFlip(Entry<ModuleType> e) {
            if (((ModuleType)e.o).getFlippedIfAvailable() == null) {
                return false;
            }
            if (e.us.intent instanceof ChallengeEditShipIntent) {
                ChallengeEditShipIntent cesi = (ChallengeEditShipIntent)e.us.intent;
                return cesi.challenge.editTypes.contains(((ModuleType)e.o).getFlippedIfAvailable());
            }
            return true;
        }

        private boolean canFlipVertically(Entry<ModuleType> e) {
            if (((ModuleType)e.o).getVerticalFlippedIfAvailable() == null) {
                return false;
            }
            if (e.us.intent instanceof ChallengeEditShipIntent) {
                ChallengeEditShipIntent cesi = (ChallengeEditShipIntent)e.us.intent;
                return cesi.challenge.editTypes.contains(((ModuleType)e.o).getVerticalFlippedIfAvailable());
            }
            return true;
        }

        @Override
        public boolean hasRemove() {
            return true;
        }

        @Override
        public void doToggleRemove(UniScreen us, EditPalettePanel p) {
            boolean selected = us.tool instanceof PlaceModuleTool && p.modSel(us) == null;
            us.tool = selected ? UniScreen.NAVIGATE : new PlaceModuleTool(null, false);
        }

        @Override
        public void drawRemove(MyDraw d, int x, int y, int width, final UniScreen us, EditPalettePanel p) {
            final boolean selected = us.tool instanceof PlaceModuleTool && p.modSel(us) == null;
            d.toggle(x, y, width, Lang._t("Remove_module", new Object[0]), Keys.get("edit_remove", "K"), new InputRunnable(){

                @Override
                public void run(Input in) {
                    us.tool = selected ? UniScreen.NAVIGATE : new PlaceModuleTool(null, false);
                }
            }, selected, true);
        }

        @Override
        public List<Object> getList(UniScreen us, EditPalettePanel p, Airship ship) {
            ArrayList<Object> l = new ArrayList<Object>();
            HashSet<Object> restrict = new HashSet<ModuleType>();
            if (us.intent instanceof ChallengeEditShipIntent) {
                Challenge c = ((ChallengeEditShipIntent)us.intent).challenge;
                restrict = c.editTypes;
            } else {
                restrict.addAll(Loadable.all(ModuleType.class));
            }
            Empire owner = p.owner(us);
            if (p.searching && !p.searchField.getText().isEmpty()) {
                ArrayList<ModuleType> mtl = SearchMatcher.match(Loadable.all(ModuleType.class), new ModuleComparator(), p.searchField.getText());
                ArrayList<ModuleType> mtl2 = new ArrayList<ModuleType>();
                for (ModuleType mt : mtl) {
                    if (mtl2.contains(mt = mt.getSymmetryGroupHead())) continue;
                    mtl2.add(mt);
                }
                for (ModuleType mt : mtl2) {
                    if (owner != null && mt.getRequired() != null && !owner.bonuses.contains[mt.getRequired().ordinal()]) continue;
                    if (p.showFlippedModules && mt.getFlippedIfAvailable() != null) {
                        mt = mt.getFlippedIfAvailable();
                    }
                    if (p.showVerticallyFlippedModules && mt.getVerticalFlippedIfAvailable() != null) {
                        mt = mt.getVerticalFlippedIfAvailable();
                    }
                    if (!mt.availableFor(ship.type) || !restrict.contains(mt) || mt.hidden()) continue;
                    l.add(new Entry<ModuleType>(mt, us, p, ship));
                }
            } else {
                for (ModuleCategory mc : Loadable.all(ModuleCategory.class)) {
                    boolean empty = true;
                    for (ModuleType mt : mc.getContents()) {
                        if (!mt.availableFor(ship.type) || !restrict.contains(mt) || owner != null && mt.getRequired() != null && !owner.bonuses.contains[mt.getRequired().ordinal()]) continue;
                        empty = false;
                        break;
                    }
                    if (empty) continue;
                    l.add(new Entry<ModuleCategory>(mc, us, p, ship));
                    if (!p.openCategories.contains(mc)) continue;
                    for (ModuleType mt : mc.getContents()) {
                        if (mt.isSymmetryGroupMember() && !mt.isSymmetryGroupHead() || owner != null && mt.getRequired() != null && !owner.bonuses.contains[mt.getRequired().ordinal()]) continue;
                        if (p.showFlippedModules && mt.getFlippedIfAvailable() != null) {
                            mt = mt.getFlippedIfAvailable();
                        }
                        if (p.showVerticallyFlippedModules && mt.getVerticalFlippedIfAvailable() != null) {
                            mt = mt.getVerticalFlippedIfAvailable();
                        }
                        if (!mt.availableFor(ship.type) || !restrict.contains(mt) || mt.hidden()) continue;
                        l.add(new Entry<ModuleType>(mt, us, p, ship));
                    }
                }
            }
            return l;
        }

        private ArrayList<Module> selectedPaintableModules(UniScreen us) {
            ArrayList<Module> l = new ArrayList<Module>();
            EditShipIntent esi = (EditShipIntent)us.intent;
            Airship ship = esi.getShip(us);
            for (Module m : esi.selectedModules) {
                if (!m.type.hasColoration() || !ship.modules.contains(m)) continue;
                l.add(m);
            }
            return l;
        }

        @Override
        public int bottomHeight(MyDraw d, int width, UniScreen us, EditPalettePanel p) {
            ModuleType t = p.modSel(us);
            if (us.tool instanceof PlaceModuleTool && !(us.intent instanceof ChallengeEditShipIntent) && t != null && t.hasColoration() || us.tool == UniScreen.NAVIGATE && !this.selectedPaintableModules(us).isEmpty()) {
                int rowCapacity = StrictMath.max(1, (width + MyDraw.BUTTON_SPACING) / (EditMode.swatchSize() + MyDraw.BUTTON_SPACING));
                int numRows = (int)StrictMath.ceil((double)(PaintType.values().size() + 1) * 1.0 / (double)rowCapacity);
                return MyDraw.BUTTON_SPACING + (EditMode.swatchSize() + MyDraw.BUTTON_SPACING) * numRows - MyDraw.BUTTON_SPACING;
            }
            return 0;
        }

        @Override
        public void drawBottom(MyDraw d, int x, int y, int width, final UniScreen us, final EditPalettePanel p) {
            int bh = this.bottomHeight(d, width, us, p);
            if (bh <= 0) {
                return;
            }
            d.hook(x, y, width, bh, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN}){

                public void run(Input input, Pt pt, Hook.Type type) {
                }
            });
            y += MyDraw.BUTTON_SPACING;
            ModuleType t = p.modSel(us);
            int x2 = x;
            HashSet<PaintType> selectedPaintTypes = new HashSet<PaintType>();
            if (us.tool instanceof PlaceModuleTool) {
                selectedPaintTypes.add(p.moduleAndDecalPaintSel);
            } else {
                for (Module m : this.selectedPaintableModules(us)) {
                    selectedPaintTypes.add(m.externalPaint);
                }
            }
            ArrayList<PaintType> pts = PaintType.values();
            for (int pti = -1; pti < pts.size(); ++pti) {
                Clr c;
                PaintType paintType;
                PaintType paintType2 = paintType = pti == -1 ? null : pts.get(pti);
                if (x2 + EditMode.swatchSize() > x + width) {
                    y += EditMode.swatchSize() + MyDraw.BUTTON_SPACING;
                    x2 = x;
                }
                if (us.tool instanceof PlaceModuleTool) {
                    c = paintType == null ? t.colorationDefault() : t.externalSubColorByPaintIndex[paintType.getPaintType(us.getBestOverallCOA()).ordinal()];
                } else {
                    Clr clr = c = paintType == null ? Clr.GREY : paintType.getTint(us.getBestOverallCOA());
                }
                if (selectedPaintTypes.contains(paintType)) {
                    d.rect(c, x2 - MyDraw.BUTTON_SPACING / 2, y - MyDraw.BUTTON_SPACING / 2, EditMode.swatchSize() + MyDraw.BUTTON_SPACING, EditMode.swatchSize() + MyDraw.BUTTON_SPACING);
                } else {
                    d.rect(c, x2, y, EditMode.swatchSize(), EditMode.swatchSize());
                }
                if (paintType != null && paintType.isArmsBased()) {
                    d.blit(SHIELD_ICON_OUTLINE, Clr.BLACK, x2 + EditMode.swatchSize() / 2 - 8, y + EditMode.swatchSize() / 2 - 8);
                    d.blit(SHIELD_ICON, x2 + EditMode.swatchSize() / 2 - 8, y + EditMode.swatchSize() / 2 - 8);
                }
                d.hook(x2, y, EditMode.swatchSize(), EditMode.swatchSize(), new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN}){

                    public void run(Input input, Pt pt, Hook.Type type) {
                        if (us.tool instanceof PlaceModuleTool) {
                            p.moduleAndDecalPaintSel = paintType;
                        } else {
                            for (Module m : this.selectedPaintableModules(us)) {
                                m.externalPaint = paintType;
                            }
                            ((EditShipIntent)us.intent).modified(us, true);
                        }
                    }
                });
                d.tooltip((double)x2, (double)y, (double)EditMode.swatchSize(), (double)EditMode.swatchSize(), paintType == null ? Lang._t("Base_Colour", new Object[0]) : paintType.getName());
                x2 += EditMode.swatchSize() + MyDraw.BUTTON_SPACING;
            }
        }

        class ModuleComparator
        implements Comparator<ModuleType> {
            ModuleComparator() {
            }

            @Override
            public int compare(ModuleType a, ModuleType b) {
                return a.getName().compareToIgnoreCase(b.getName());
            }
        }
    }
    ,
    ARMOUR("R", "edit_mode_ARMOUR", true){

        @Override
        public int getHeight(Object t, MyDraw d, int availableWidth) {
            int scale = AirshipGame.instance.currentGUIScale == GUIScale.LARGE ? 2 : 1;
            return 16 * scale + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void stepSelect(int delta, UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            int currentIndex = -1;
            if (us.tool instanceof PlaceArmourTool) {
                for (int i = 0; i < l.size(); ++i) {
                    if (!(l.get(i) instanceof Entry)) continue;
                    Entry e = (Entry)l.get(i);
                    if (e.o != ((PlaceArmourTool)us.tool).at) continue;
                    currentIndex = i;
                }
            }
            int newIndex = (currentIndex + delta + l.size()) % l.size();
            us.tool = new PlaceArmourTool((ArmourType)((Entry)l.get((int)newIndex)).o);
        }

        @Override
        public void selectFirst(UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            us.tool = new PlaceArmourTool((ArmourType)((Entry)l.get((int)0)).o);
        }

        @Override
        public void draw(Object t, MyDraw d, int x, int y, int width) {
            int scale = AirshipGame.instance.currentGUIScale == GUIScale.LARGE ? 2 : 1;
            d.drawWoodGrain(x, y, width, 20 + MyDraw.SCROLL_EL_SPACING);
            final Entry e = (Entry)t;
            if (!((ArmourType)e.o).damagedApps.get(e.ship.currentBonuses).isEmpty()) {
                ((ArmourType)e.o).damagedApps.get(e.ship.currentBonuses).get(0).draw(d, x, y, 16 * scale, 16 * scale, 0, null, false);
            }
            boolean selected = e.p.armSel(e.us) == e.o;
            String name = ((ArmourType)e.o).getName();
            d.text(selected ? MyDraw.SELECTED_C + name : name, AGame.FOUNT, x + 16 * scale + MyDraw.SCROLL_EL_SPACING + 4, y);
            String cost = "$" + ((ArmourType)e.o).getCost(e.ship.constructionBonuses);
            d.text(cost, AGame.FOUNT, x + width - (int)d.textSize((String)cost, (Fount)AGame.FOUNT).x, y);
            d.hook(x, y, width, 16 + MyDraw.UI_SPACING, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    e.us.tool = new PlaceArmourTool((ArmourType)e.o);
                    e.p.lastArmourType = (ArmourType)e.o;
                    e.p.searchSelectionMade = true;
                }
            });
            d.tooltip((double)x, (double)y, (double)width, (double)(16 * scale + MyDraw.UI_SPACING), ((ArmourType)e.o).getDescription(e.ship.constructionBonuses));
        }

        @Override
        public List<Object> getList(UniScreen us, EditPalettePanel p, Airship ship) {
            ArrayList<ArmourType> l = new ArrayList<ArmourType>();
            Empire owner = p.owner(us);
            for (ArmourType at : Loadable.all(ArmourType.class)) {
                if (at == ArmourType.ofName("NONE") || at.hidden || at.required != null && owner != null && !owner.bonuses.contains[at.required.ordinal()]) continue;
                l.add(at);
            }
            if (p.searching) {
                l = SearchMatcher.match(l, null, p.searchField.getText());
            }
            ArrayList<Object> l2 = new ArrayList<Object>();
            for (ArmourType at : l) {
                l2.add(new Entry<ArmourType>(at, us, p, ship));
            }
            return l2;
        }

        @Override
        public void fill(UniScreen us, EditPalettePanel p, Airship ship) {
            for (Tile t : ship.tiles) {
                if (t.module.type.isExternal() || t.module.type.getArmourType() != null) continue;
                t.armour.setType(p.armSel(us));
            }
        }

        @Override
        public boolean fillEnabled(UniScreen us, EditPalettePanel p, Airship ship) {
            return p.armSel(us) != null;
        }

        @Override
        public boolean hasRemove() {
            return false;
        }

        @Override
        public void doToggleRemove(UniScreen us, EditPalettePanel p) {
        }

        @Override
        public void drawRemove(MyDraw d, int x, int y, int width, UniScreen us, EditPalettePanel p) {
        }

        @Override
        public int bottomHeight(MyDraw d, int width, UniScreen us, EditPalettePanel p) {
            return 0;
        }

        @Override
        public void drawBottom(MyDraw d, int x, int y, int width, UniScreen us, EditPalettePanel p) {
        }
    }
    ,
    PAINT("P", "edit_mode_PAINT", true){

        @Override
        public int getHeight(Object t, MyDraw d, int availableWidth) {
            int scale = AirshipGame.instance.currentGUIScale == GUIScale.LARGE ? 2 : 1;
            return 16 * scale + MyDraw.SCROLL_EL_SPACING;
        }

        @Override
        public void stepSelect(int delta, UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            int currentIndex = -1;
            if (us.tool instanceof PaintArmourTool) {
                for (int i = 0; i < l.size(); ++i) {
                    if (!(l.get(i) instanceof Entry)) continue;
                    Entry e = (Entry)l.get(i);
                    if (e.o != ((PaintArmourTool)us.tool).pt) continue;
                    currentIndex = i;
                }
            }
            int newIndex = (currentIndex + delta + l.size()) % l.size();
            us.tool = new PaintArmourTool((PaintType)((Entry)l.get((int)newIndex)).o);
        }

        @Override
        public void selectFirst(UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            us.tool = new PaintArmourTool((PaintType)((Entry)l.get((int)0)).o);
        }

        @Override
        public void draw(Object t, MyDraw d, int x, int y, int width) {
            int scale = AirshipGame.instance.currentGUIScale == GUIScale.LARGE ? 2 : 1;
            d.drawWoodGrain(x, y, width, 16 * scale + MyDraw.SCROLL_EL_SPACING);
            final Entry e = (Entry)t;
            d.rect(((PaintType)e.o).getTint(e.us.getBestOverallCOA()), x + 2, y + 2, 16 * scale, 16 * scale);
            boolean selected = e.p.paintSel(e.us) == e.o;
            String name = ((PaintType)e.o).getName();
            d.text(selected ? MyDraw.SELECTED_C + name : name, AGame.FOUNT, x + 16 * scale + MyDraw.SCROLL_EL_SPACING + 4, y);
            d.hook(x, y, width, 16 * scale + MyDraw.UI_SPACING, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    e.us.tool = new PaintArmourTool((PaintType)e.o);
                    e.p.searchSelectionMade = true;
                }
            });
        }

        @Override
        public List<Object> getList(UniScreen us, EditPalettePanel p, Airship ship) {
            ArrayList<PaintType> l = new ArrayList<PaintType>();
            l.addAll(PaintType.values());
            if (p.searching) {
                l = SearchMatcher.match(l, null, p.searchField.getText());
            }
            ArrayList<Object> l2 = new ArrayList<Object>();
            for (PaintType t : l) {
                l2.add(new Entry<PaintType>(t, us, p, ship));
            }
            return l2;
        }

        @Override
        public void fill(UniScreen us, EditPalettePanel p, Airship ship) {
            for (Tile t : ship.tiles) {
                if (t.module.type.isExternal()) continue;
                t.armour.paint = p.paintSel(us);
            }
        }

        @Override
        public boolean fillEnabled(UniScreen us, EditPalettePanel p, Airship ship) {
            return true;
        }

        @Override
        public boolean hasRemove() {
            return true;
        }

        @Override
        public void doToggleRemove(UniScreen us, EditPalettePanel p) {
            boolean selected = us.tool instanceof PaintArmourTool && p.paintSel(us) == null;
            us.tool = selected ? UniScreen.NAVIGATE : new PaintArmourTool(null);
        }

        @Override
        public void drawRemove(MyDraw d, int x, int y, int width, final UniScreen us, EditPalettePanel p) {
            final boolean selected = us.tool instanceof PaintArmourTool && p.paintSel(us) == null;
            d.toggle(x, y, width, Lang._t("Remove_paint", new Object[0]), Keys.get("edit_remove", "K"), new InputRunnable(){

                @Override
                public void run(Input in) {
                    us.tool = selected ? UniScreen.NAVIGATE : new PaintArmourTool(null);
                }
            }, selected, true);
        }

        @Override
        public int bottomHeight(MyDraw d, int width, UniScreen us, EditPalettePanel p) {
            return 0;
        }

        @Override
        public void drawBottom(MyDraw d, int x, int y, int width, UniScreen us, EditPalettePanel p) {
        }
    }
    ,
    DECALS("E", "edit_mode_DECALS", false){
        public final Img FLIP = new Img("ui", 304, 512, 16, 16, false);
        public final Img FLIP_V = new Img("ui", 336, 512, 16, 16, false);

        @Override
        public boolean allowSelect() {
            return true;
        }

        @Override
        public void dragOngoing(UniScreen us, Input in, double startX, double startY, double endX, double endY) {
        }

        @Override
        public void dragComplete(UniScreen us, Input in, double startX, double startY, double endX, double endY) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            Airship ship = esi.getShip(us);
            EditSelectionOverlay eso = us.shipOverlay(EditSelectionOverlay.class);
            eso.shiftX = 0;
            eso.shiftY = 0;
            eso.fail = false;
            int sx = (int)Math.floor((startX - ship.getX()) / 16.0);
            int sy = (int)Math.floor((startY - ship.getY()) / 16.0);
            Decal startD = ship.decalAt(ship.gridXToWorldX(sx, 1), sy);
            if (startD == null || !esi.selectedDecals.contains(startD)) {
                double tmp;
                if (endX < startX) {
                    tmp = startX;
                    startX = endX;
                    endX = tmp;
                }
                if (endY < startY) {
                    tmp = startY;
                    startY = endY;
                    endY = tmp;
                }
                int smx = ship.gridXToWorldX((int)Math.floor((startX - ship.getX()) / 16.0), 1);
                int smy = (int)Math.floor((startY - ship.getY()) / 16.0);
                int emx = ship.gridXToWorldX((int)Math.floor((endX - ship.getX()) / 16.0), 1);
                int emy = (int)Math.floor((endY - ship.getY()) / 16.0);
                if (emx < smx) {
                    int tmp2 = smx;
                    smx = emx;
                    emx = tmp2;
                }
                HashSet<Decal> decals = new HashSet<Decal>();
                for (int y = smy; y <= emy; ++y) {
                    for (int x = smx; x <= emx; ++x) {
                        Decal m = ship.decalAt(x, y);
                        if (m == null) continue;
                        decals.add(m);
                    }
                }
                if (!in.keyDown("LSHIFT")) {
                    esi.selectedDecals.clear();
                }
                esi.selectedDecals.addAll(decals);
            } else {
                int ex = (int)Math.floor((endX - ship.getX()) / 16.0);
                int ey = (int)Math.floor((endY - ship.getY()) / 16.0);
                int dx = ship.flipped ? sx - ex : ex - sx;
                int dy = ey - sy;
                if (dx == 0 && dy == 0) {
                    return;
                }
                for (Decal dec : esi.selectedDecals) {
                    if (!ship.decals.contains(dec) || ship.canAddDecal(dec.type, dec.x + dx, dec.y + dy, dec.layer, esi.selectedDecals)) continue;
                    return;
                }
                ship.decals.removeAll(esi.selectedDecals);
                ArrayList<Decal> newDecs = new ArrayList<Decal>();
                for (Decal dec : esi.selectedDecals) {
                    Decal newDec = ship.addDecal(dec.type, dec.x + dx, dec.y + dy, dec.layer);
                    newDec.paint = dec.paint;
                    newDecs.add(newDec);
                }
                esi.selectedDecals.clear();
                esi.selectedDecals.addAll(newDecs);
                esi.modified(us, true);
            }
        }

        @Override
        public boolean showDragRect(UniScreen us, double startX, double startY, double endX, double endY) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            Airship ship = esi.getShip(us);
            EditSelectionOverlay eso = us.shipOverlay(EditSelectionOverlay.class);
            int sx = (int)Math.floor((startX - ship.getX()) / 16.0);
            int sy = (int)Math.floor((startY - ship.getY()) / 16.0);
            Decal d = ship.decalAt(ship.gridXToWorldX(sx, 1), sy);
            if (d == null || !esi.selectedDecals.contains(d)) {
                eso.shiftX = 0;
                eso.shiftY = 0;
                eso.fail = false;
                return true;
            }
            int ex = (int)Math.floor((endX - ship.getX()) / 16.0);
            int ey = (int)Math.floor((endY - ship.getY()) / 16.0);
            int dx = ship.flipped ? sx - ex : ex - sx;
            int dy = ey - sy;
            eso.shiftX = ex - sx;
            eso.shiftY = ey - sy;
            eso.fail = false;
            for (Decal dec : esi.selectedDecals) {
                if (!ship.decals.contains(dec) || ship.canAddDecal(dec.type, dec.x + dx, dec.y + dy, dec.layer, esi.selectedDecals)) continue;
                eso.fail = true;
                break;
            }
            return false;
        }

        @Override
        public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            Airship ship = esi.getShip(us);
            if (!us.textInputOccurring() && us.tool == UniScreen.NAVIGATE && !esi.selectedDecals.isEmpty()) {
                Pt sz;
                if (this.validShift(esi, ship) == null) {
                    sz = d.textSize(Lang._t("Press_backspace_or_delete_to_remove", new Object[0]), AGame.FOUNT);
                    d.text(Lang._t("Press_backspace_or_delete_to_remove", new Object[0]), AGame.FOUNT, (int)((double)sm.width - sz.x - 5.0), (double)sm.height - sz.y - 3.0);
                } else {
                    sz = d.textSize(Lang._t("Press_x_to_duplicate_and_backspace_or_delete_to_remove", Keys.get("edit_duplicate", "H")), AGame.FOUNT);
                    d.text(Lang._t("Press_x_to_duplicate_and_backspace_or_delete_to_remove", Keys.get("edit_duplicate", "H")), AGame.FOUNT, (int)((double)sm.width - sz.x - 5.0), (double)sm.height - sz.y - 3.0);
                }
            }
            EditSelectionOverlay eso = us.shipOverlay(EditSelectionOverlay.class);
            if (!(eso.shiftX == 0 && eso.shiftY == 0 || esi.selectedDecals.isEmpty())) {
                d.state.setCursor("DRAG", null);
            } else if (us.tool == UniScreen.NAVIGATE && cursor.y > (double)MyDraw.TOP_BAR_H && cursor.x > (double)us.panel(EditInfoPanel.class).myWidth) {
                double cx = us.screenToWorldX(cursor.x);
                double cy = us.screenToWorldY(cursor.y);
                for (Decal dec : esi.selectedDecals) {
                    if (!ship.decals.contains(dec)) continue;
                    double decX = ship.getX() + (double)(ship.gridXToWorldX(dec.x, dec.type.w) * 16);
                    double decY = ship.getY() + (double)(dec.y * 16);
                    if (!(cx > decX) || !(cy > decY) || !(cx < decX + (double)(dec.type.w * 16)) || !(cy < decY + (double)(dec.type.h * 16))) continue;
                    d.state.setCursor("DRAG", null);
                    break;
                }
            }
        }

        @Override
        public void tick(UniScreen us, Input in) {
            EditShipIntent esi = (EditShipIntent)us.intent;
            Airship ship = esi.getShip(us);
            if (!us.textInputOccurring() && us.tool == UniScreen.NAVIGATE && !esi.selectedDecals.isEmpty()) {
                if (in.keyPressed("DELETE") || in.keyPressed("BACK")) {
                    ship.decals.removeAll(esi.selectedDecals);
                    esi.selectedModules.clear();
                    esi.modified(us, true);
                } else if (in.keyPressed(Keys.get("edit_duplicate", "H"))) {
                    int[] shift = this.validShift(esi, ship);
                    if (shift != null) {
                        ArrayList<Decal> decs = new ArrayList<Decal>(esi.selectedDecals);
                        esi.selectedDecals.clear();
                        for (Decal dec : decs) {
                            esi.selectedDecals.add(ship.addDecal(dec.type, dec.x + shift[0], dec.y + shift[1], dec.layer));
                        }
                    }
                    esi.modified(us, true);
                }
            }
        }

        private int[] validShift(EditShipIntent esi, Airship ship) {
            if (esi.selectedDecals.isEmpty()) {
                return null;
            }
            int selXMin = 100000;
            int selXMax = -100000;
            int selYMin = 100000;
            int selYMax = -100000;
            for (Decal dec : esi.selectedDecals) {
                selXMin = Math.min(dec.x, selXMin);
                selXMax = Math.max(dec.x + dec.type.w, selXMax);
                selYMin = Math.min(dec.y, selYMin);
                selYMax = Math.max(dec.y + dec.type.h, selYMax);
            }
            int selW = selXMax - selXMin;
            int selH = selYMax - selYMin;
            int[][] candidates = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {-1, 1}, {1, -1}, {-1, -1}};
            for (int extraD = 0; extraD < 4; ++extraD) {
                block2: for (int ci = 0; ci < candidates.length; ++ci) {
                    int dx = candidates[ci][0] * (selW + extraD);
                    int dy = candidates[ci][1] * (selH + extraD);
                    for (Decal dec : esi.selectedDecals) {
                        if (ship.canAddDecal(dec.type, dec.x + dx, dec.y + dy, dec.layer, Collections.EMPTY_LIST)) continue;
                        continue block2;
                    }
                    return new int[]{dx, dy};
                }
            }
            return null;
        }

        @Override
        public void click(UniScreen us, Input in, Pt p) {
            int my;
            int mx;
            EditShipIntent esi = (EditShipIntent)us.intent;
            Airship ship = esi.getShip(us);
            Decal d = ship.decalAt(mx = ship.gridXToWorldX((int)Math.floor((p.x - ship.getX()) / 16.0), 1), my = (int)Math.floor((p.y - ship.getY()) / 16.0));
            if (d != null) {
                if (in.keyDown("LSHIFT")) {
                    if (esi.selectedDecals.contains(d)) {
                        esi.selectedDecals.remove(d);
                    } else {
                        esi.selectedDecals.add(d);
                    }
                } else {
                    esi.selectedDecals.clear();
                    esi.selectedDecals.add(d);
                }
            } else if (!in.keyDown("LSHIFT")) {
                esi.selectedDecals.clear();
            }
        }

        @Override
        public int getHeight(Object t, MyDraw d, int availableWidth) {
            int scale = AirshipGame.instance.currentGUIScale == GUIScale.LARGE ? 2 : 1;
            Entry e = (Entry)t;
            if (e.o == null) {
                return 16 + MyDraw.SCROLL_EL_SPACING + 8;
            }
            return StrictMath.max(StrictMath.max(16, this.bottom((DecalType)e.o) - this.top((DecalType)e.o)) * scale, MyDraw.ICON_BUTTON_SZ) + MyDraw.SCROLL_EL_SPACING;
        }

        private int top(DecalType t) {
            int top = 0;
            int asz = t.apps.size();
            for (int ai = 0; ai < asz; ++ai) {
                DecalType.TintedApp a = t.apps.get(ai);
                top = StrictMath.min(top, a.y);
            }
            if (t.armsDetails != null) {
                top = StrictMath.min(top, t.armsDetails.y);
            }
            return top;
        }

        private int bottom(DecalType t) {
            int bottom = t.h * 16;
            int asz = t.apps.size();
            for (int ai = 0; ai < asz; ++ai) {
                DecalType.TintedApp a = t.apps.get(ai);
                bottom = StrictMath.max(bottom, a.y + a.app.height() * 16);
            }
            if (t.armsDetails != null) {
                bottom = StrictMath.max(bottom, t.armsDetails.y + t.armsDetails.size);
            }
            return bottom;
        }

        @Override
        public void stepSelect(int delta, UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            int currentIndex = -1;
            if (us.tool instanceof PlaceDecalTool) {
                for (int i = 0; i < l.size(); ++i) {
                    if (!(l.get(i) instanceof Entry)) continue;
                    Entry e = (Entry)l.get(i);
                    if (e.o != ((PlaceDecalTool)us.tool).dt) continue;
                    currentIndex = i;
                }
            }
            int newIndex = (currentIndex + delta + l.size()) % l.size();
            us.tool = new PlaceDecalTool((DecalType)((Entry)l.get((int)newIndex)).o);
        }

        @Override
        public void selectFirst(UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            us.tool = new PlaceDecalTool((DecalType)((Entry)l.get((int)0)).o);
        }

        @Override
        public void draw(Object t, MyDraw d, int x, int y, int width) {
            int scale = AirshipGame.instance.currentGUIScale == GUIScale.LARGE ? 2 : 1;
            final Entry e = (Entry)t;
            int origY = y;
            int h = this.getHeight(t, d, width);
            boolean selected = e.us.tool instanceof PlaceDecalTool && e.p.decSel(e.us) == e.o;
            d.shift(x, y -= this.top((DecalType)e.o));
            d.scale(scale, scale);
            PaintType pt = e.p.moduleAndDecalPaintSel;
            ((DecalType)e.o).drawBase(d, 0.0, 0.0, 0, false, e.p.coa, "NAME", null, 1.0f, Color.white, 1.0f, null, null, pt == null ? null : pt.getPaintType(e.p.coa));
            ((DecalType)e.o).drawCharges(d, 0.0, 0.0, 0, false, e.p.coa, "NAME", null, 1.0f, Color.white, 1.0f, null, null);
            ((DecalType)e.o).drawUnlitCharges(d, 0.0, 0.0, 0, false, e.p.coa);
            ((DecalType)e.o).drawNonShader(d, 0.0, 0.0, 0, false, e.p.coa, "NAME", null);
            if (((DecalType)e.o).flag != null) {
                FlagSpec f = ((DecalType)e.o).flag;
                switch (f.type) {
                    case ARMS: {
                        e.p.coa.draw(d, f.x, f.y, f.size);
                        break;
                    }
                    case PENNANT: {
                        Graphics g = (Graphics)d.frame().nativeRenderer();
                        g.setColor(e.p.coa.getFirstColour().tintColor);
                        g.fill((Shape)new Polygon(new float[]{f.x, f.y, f.x, f.y + f.size, f.x + f.size * 5, f.y + f.size / 2}));
                        g.setColor(Color.white);
                    }
                }
            }
            d.resetTransforms();
            d.drawWoodGrain(4 + x + 48 * scale, y, width, h);
            int hookTop = Math.max(origY, e.p.listTop);
            int hookBottom = Math.min(origY + h, e.p.listBottom);
            d.hook(x, hookTop, width, hookBottom - hookTop, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    e.us.tool = new PlaceDecalTool((DecalType)e.o);
                    e.p.searchSelectionMade = true;
                }
            });
            d.text((selected ? MyDraw.SELECTED_C : "") + ((DecalType)e.o).getName(), AGame.FOUNT, x + 48 * scale + MyDraw.SCROLL_EL_SPACING + 6, y);
            int x2 = x + width - MyDraw.ICON_BUTTON_SZ;
            if (this.canFlip(e)) {
                d.iconButton(x2, y, this.FLIP, new Runnable(){

                    @Override
                    public void run() {
                        e.us.tool = new PlaceDecalTool(((DecalType)e.o).flipped);
                        e.p.showFlippedDecals = !e.p.showFlippedDecals;
                    }
                }, true);
                x2 -= MyDraw.ICON_BUTTON_SZ + MyDraw.BUTTON_SPACING;
            }
            if (this.canFlipVertically(e)) {
                d.iconButton(x2, y, this.FLIP_V, new Runnable(){

                    @Override
                    public void run() {
                        e.us.tool = new PlaceDecalTool(((DecalType)e.o).verticalFlipped);
                        e.p.showVerticallyFlippedDecals = !e.p.showVerticallyFlippedDecals;
                    }
                }, true);
                x2 -= MyDraw.ICON_BUTTON_SZ + MyDraw.BUTTON_SPACING;
            }
        }

        private boolean canFlip(Entry<DecalType> e) {
            return ((DecalType)e.o).flipped != null;
        }

        private boolean canFlipVertically(Entry<DecalType> e) {
            return ((DecalType)e.o).verticalFlipped != null;
        }

        @Override
        public List<Object> getList(UniScreen us, EditPalettePanel p, Airship ship) {
            ArrayList<DecalType> l = new ArrayList<DecalType>();
            l.addAll(Loadable.all(DecalType.class));
            if (p.searching) {
                l = SearchMatcher.match(l, null, p.searchField.getText());
            }
            ArrayList<Object> l2 = new ArrayList<Object>();
            for (DecalType t : l) {
                if (!l.contains(t.getSymmetryGroupHead())) {
                    t = t.getSymmetryGroupHead();
                }
                if (t.isSymmetryGroupMember() && !t.isSymmetryGroupHead()) continue;
                if (p.showFlippedDecals && t.flipped != null) {
                    t = t.flipped;
                }
                if (p.showVerticallyFlippedDecals && t.verticalFlipped != null) {
                    t = t.verticalFlipped;
                }
                l2.add(new Entry<DecalType>(t, us, p, ship));
            }
            return l2;
        }

        @Override
        public boolean hasRemove() {
            return true;
        }

        @Override
        public void doToggleRemove(UniScreen us, EditPalettePanel p) {
            boolean selected = us.tool instanceof PlaceDecalTool && p.decSel(us) == null;
            us.tool = selected ? UniScreen.NAVIGATE : new PlaceDecalTool(null);
        }

        @Override
        public void drawRemove(MyDraw d, int x, int y, int width, final UniScreen us, EditPalettePanel p) {
            final boolean selected = us.tool instanceof PlaceDecalTool && p.decSel(us) == null;
            d.toggle(x, y, width, Lang._t("Remove_decal", new Object[0]), Keys.get("edit_remove", "K"), new InputRunnable(){

                @Override
                public void run(Input in) {
                    us.tool = selected ? UniScreen.NAVIGATE : new PlaceDecalTool(null);
                }
            }, selected, true);
        }

        private ArrayList<Decal> selectedPaintableDecals(UniScreen us) {
            ArrayList<Decal> l = new ArrayList<Decal>();
            EditShipIntent esi = (EditShipIntent)us.intent;
            Airship ship = esi.getShip(us);
            for (Decal dec : esi.selectedDecals) {
                if (!dec.type.hasColoration() || !ship.decals.contains(dec)) continue;
                l.add(dec);
            }
            return l;
        }

        @Override
        public int bottomHeight(MyDraw d, int width, UniScreen us, EditPalettePanel p) {
            DecalType t = p.decSel(us);
            if (us.tool instanceof PlaceDecalTool && !(us.intent instanceof ChallengeEditShipIntent) && t != null && t.hasColoration() || us.tool == UniScreen.NAVIGATE && !this.selectedPaintableDecals(us).isEmpty()) {
                int rowCapacity = StrictMath.max(1, (width + MyDraw.BUTTON_SPACING) / (EditMode.swatchSize() + MyDraw.BUTTON_SPACING));
                int numRows = (int)StrictMath.ceil((double)(PaintType.values().size() + 1) * 1.0 / (double)rowCapacity);
                return MyDraw.BUTTON_SPACING + (EditMode.swatchSize() + MyDraw.BUTTON_SPACING) * numRows - MyDraw.BUTTON_SPACING;
            }
            return 0;
        }

        @Override
        public void drawBottom(MyDraw d, int x, int y, int width, final UniScreen us, final EditPalettePanel p) {
            int bh = this.bottomHeight(d, width, us, p);
            if (bh <= 0) {
                return;
            }
            d.hook(x, y, width, bh, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN}){

                public void run(Input input, Pt pt, Hook.Type type) {
                }
            });
            y += MyDraw.BUTTON_SPACING;
            DecalType t = p.decSel(us);
            int x2 = x;
            HashSet<PaintType> selectedPaintTypes = new HashSet<PaintType>();
            if (us.tool instanceof PlaceDecalTool) {
                selectedPaintTypes.add(p.moduleAndDecalPaintSel);
            } else {
                for (Decal dec : this.selectedPaintableDecals(us)) {
                    selectedPaintTypes.add(dec.paint);
                }
            }
            ArrayList<PaintType> pts = PaintType.values();
            for (int pti = -1; pti < pts.size(); ++pti) {
                Clr c;
                PaintType paintType;
                PaintType paintType2 = paintType = pti == -1 ? null : pts.get(pti);
                if (x2 + EditMode.swatchSize() > x + width) {
                    y += EditMode.swatchSize() + MyDraw.BUTTON_SPACING;
                    x2 = x;
                }
                if (us.tool instanceof PlaceModuleTool) {
                    c = paintType == null ? t.colorationDefault() : t.subColorByPaintTypeIndex[paintType.getPaintType(us.getBestOverallCOA()).ordinal()];
                } else {
                    Clr clr = c = paintType == null ? Clr.GREY : paintType.getTint(us.getBestOverallCOA());
                }
                if (selectedPaintTypes.contains(paintType)) {
                    d.rect(c, x2 - MyDraw.BUTTON_SPACING / 2, y - MyDraw.BUTTON_SPACING / 2, EditMode.swatchSize() + MyDraw.BUTTON_SPACING, EditMode.swatchSize() + MyDraw.BUTTON_SPACING);
                } else {
                    d.rect(c, x2, y, EditMode.swatchSize(), EditMode.swatchSize());
                }
                if (paintType != null && paintType.isArmsBased()) {
                    d.blit(SHIELD_ICON_OUTLINE, Clr.BLACK, x2 + EditMode.swatchSize() / 2 - 8, y + EditMode.swatchSize() / 2 - 8);
                    d.blit(SHIELD_ICON, x2 + EditMode.swatchSize() / 2 - 8, y + EditMode.swatchSize() / 2 - 8);
                }
                d.hook(x2, y, EditMode.swatchSize(), EditMode.swatchSize(), new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN}){

                    public void run(Input input, Pt pt, Hook.Type type) {
                        if (us.tool instanceof PlaceDecalTool) {
                            p.moduleAndDecalPaintSel = paintType;
                        } else {
                            for (Decal dec : this.selectedPaintableDecals(us)) {
                                dec.paint = paintType;
                            }
                            ((EditShipIntent)us.intent).modified(us, true);
                        }
                    }
                });
                d.tooltip((double)x2, (double)y, (double)EditMode.swatchSize(), (double)EditMode.swatchSize(), paintType == null ? Lang._t("Base_Colour", new Object[0]) : paintType.getName());
                x2 += EditMode.swatchSize() + MyDraw.BUTTON_SPACING;
            }
        }
    };

    public static final Clr ARMOUR_BACK_TINT;
    public static final Img SHIELD_ICON;
    public static final Img SHIELD_ICON_OUTLINE;
    private final String shortcut;
    private final String shortcutKey;
    public final boolean canFill;

    public String getName() {
        return Lang._t("editmode_" + this.name(), new Object[0]);
    }

    public String getShortcut() {
        return Keys.get(this.shortcutKey, this.shortcut);
    }

    private EditMode(String shortcut, String shortcutKey, boolean canFill) {
        this.shortcut = shortcut;
        this.shortcutKey = shortcutKey;
        this.canFill = canFill;
    }

    @Override
    public abstract int getHeight(Object var1, MyDraw var2, int var3);

    @Override
    public abstract void draw(Object var1, MyDraw var2, int var3, int var4, int var5);

    public boolean allowSelect() {
        return false;
    }

    public void dragOngoing(UniScreen us, Input in, double startX, double startY, double endX, double endY) {
    }

    public void dragComplete(UniScreen us, Input in, double startX, double startY, double endX, double endY) {
    }

    public boolean showDragRect(UniScreen us, double startX, double startY, double endX, double endY) {
        return false;
    }

    public void click(UniScreen us, Input in, Pt p) {
    }

    public void tick(UniScreen us, Input in) {
    }

    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
    }

    public abstract boolean hasRemove();

    public abstract void doToggleRemove(UniScreen var1, EditPalettePanel var2);

    public abstract void drawRemove(MyDraw var1, int var2, int var3, int var4, UniScreen var5, EditPalettePanel var6);

    public abstract int bottomHeight(MyDraw var1, int var2, UniScreen var3, EditPalettePanel var4);

    public abstract void drawBottom(MyDraw var1, int var2, int var3, int var4, UniScreen var5, EditPalettePanel var6);

    public void fill(UniScreen us, EditPalettePanel p, Airship ship) {
    }

    public boolean fillEnabled(UniScreen us, EditPalettePanel p, Airship ship) {
        return false;
    }

    public abstract void stepSelect(int var1, UniScreen var2, EditPalettePanel var3, Airship var4);

    public abstract void selectFirst(UniScreen var1, EditPalettePanel var2, Airship var3);

    public abstract List<Object> getList(UniScreen var1, EditPalettePanel var2, Airship var3);

    private static int swatchSize() {
        switch (AirshipGame.instance.currentGUIScale) {
            case SMALL: {
                return CoatEditor.SMALL_COLOR_SWATCH_SIZE;
            }
            case MEDIUM: {
                return CoatEditor.MEDIUM_COLOR_SWATCH_SIZE;
            }
            case LARGE: {
                return CoatEditor.LARGE_COLOR_SWATCH_SIZE;
            }
        }
        return CoatEditor.MEDIUM_COLOR_SWATCH_SIZE;
    }

    static {
        ARMOUR_BACK_TINT = new Clr(64, 64, 64);
        SHIELD_ICON = new Img("ui", 384, 432, 16, 16, false);
        SHIELD_ICON_OUTLINE = new Img("ui", 400, 432, 16, 16, false);
    }

    private strictfp static class Entry<T> {
        public final T o;
        public final UniScreen us;
        public final EditPalettePanel p;
        public final Airship ship;

        public Entry(T t, UniScreen us, EditPalettePanel p, Airship ship) {
            this.o = t;
            this.us = us;
            this.p = p;
            this.ship = ship;
        }
    }
}

