/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUGC;
import com.codedisaster.steamworks.SteamUGCCallback;
import com.codedisaster.steamworks.SteamUGCDetails;
import com.codedisaster.steamworks.SteamUGCQuery;
import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.PublishedItemsManager;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.ZipUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

public strictfp class DownloadPublishedZippedItemsProcess
implements SteamUGCCallback {
    private final ArrayList<PublishedItemsManager.Entry> entries;
    public String errors = "";
    private boolean inited = false;
    private int dlIndex = 0;
    private boolean downloadStarted;

    public void onUGCQueryCompleted(SteamUGCQuery sugcq, int i, int i1, boolean bln, SteamResult sr) {
    }

    public void onSubscribeItem(SteamPublishedFileID spfid, SteamResult sr) {
    }

    public void onUnsubscribeItem(SteamPublishedFileID spfid, SteamResult sr) {
    }

    public void onRequestUGCDetails(SteamUGCDetails sugcd, SteamResult sr) {
    }

    public void onCreateItem(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
    }

    public void onSubmitItemUpdate(boolean bln, SteamResult sr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDownloadItemResult(long l, SteamPublishedFileID spfid, SteamResult sr) {
        System.out.println("downloadItemResult " + sr.name());
        this.downloadStarted = false;
        PublishedItemsManager.Entry e = this.entries.get(this.dlIndex);
        File tmpDir = new File(new File(new File(AGame.getGameDirectory(), "steam"), "tmp"), e.fileName);
        System.out.println(e.fileName);
        SteamUGC.ItemInstallInfo iis = new SteamUGC.ItemInstallInfo();
        SteamBackend.ugc.getItemInstallInfo(spfid, iis);
        File f = new File(iis.getFolder());
        System.out.println(iis.getFolder() + " exists=" + f.exists());
        if (f.exists()) {
            try {
                byte[] data = FileUtils.readFileToByteArray((File)new File(iis.getFolder()));
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                AGame.deleteDir(tmpDir);
                System.out.println("data len=" + data.length);
                ZipUtils.unzip(bis, tmpDir);
                System.out.println("unzipped");
                boolean moved = false;
                for (File subDir : tmpDir.listFiles()) {
                    System.out.println("subDir " + subDir);
                    if (!subDir.isDirectory() || !new File(subDir, e.type.headerFileName).exists()) continue;
                    File target = new File(new File(AGame.getGameDirectory(), e.type.dirName), subDir.getName());
                    if (target.exists()) {
                        FileUtils.deleteDirectory((File)target);
                    }
                    FileUtils.moveDirectory((File)subDir, (File)target);
                    moved = true;
                    break;
                }
                System.out.println("moved=" + moved);
            }
            catch (Exception ex) {
                System.out.println("failed");
                ex.printStackTrace();
                this.errors = this.errors + Lang._t("Cannot_download_x", e.title) + ": " + ex.getMessage() + "\n";
            }
            finally {
                AGame.deleteDir(tmpDir);
            }
        } else {
            this.errors = this.errors + Lang._t("Cannot_download_x", e.title) + ": " + sr.name() + "\n";
        }
        ++this.dlIndex;
    }

    public void onUserFavoriteItemsListChanged(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
    }

    public void onSetUserItemVote(SteamPublishedFileID spfid, boolean bln, SteamResult sr) {
    }

    public void onGetUserItemVote(SteamPublishedFileID spfid, boolean bln, boolean bln1, boolean bln2, SteamResult sr) {
    }

    public DownloadPublishedZippedItemsProcess(ArrayList<PublishedItemsManager.Entry> entries) {
        this.entries = entries;
    }

    public Progress tick() {
        if (!this.inited) {
            this.inited = true;
            return new Progress(false, 0, this.entries.size(), Lang._t("Downloading_x", this.entries.get((int)this.dlIndex).title));
        }
        if (this.dlIndex < this.entries.size()) {
            PublishedItemsManager.Entry e = this.entries.get(this.dlIndex);
            if (!this.downloadStarted) {
                this.downloadStarted = true;
                SteamBackend.ugcCallback = this;
                SteamBackend.ugc.downloadItem(e.fileID, true);
            }
            return new Progress(false, this.dlIndex, this.entries.size(), Lang._t("Downloading_x", this.entries.get((int)this.dlIndex).title));
        }
        return new Progress(true, this.entries.size(), this.entries.size(), Lang._t("Done", new Object[0]));
    }

    public strictfp static class Progress {
        public final boolean done;
        public final int progress;
        public final int total;
        public final String desc;

        public Progress(boolean done, int progress, int total, String desc) {
            this.done = done;
            this.progress = progress;
            this.total = total;
            this.desc = desc;
        }
    }
}

