/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.FlagSpec;
import com.zarkonnen.airships.HasName;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PaintType;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Tincture;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;

public strictfp class DecalType
extends Loadable
implements HasName {
    public final int w;
    public final int h;
    public final int imgW;
    public final boolean flipWithShip;
    public final ArrayList<TintedApp> apps = new ArrayList();
    private final NameDetails nameDetails;
    public final ArmsDetails armsDetails;
    public final ChargeDetails chargeDetails;
    public final FlagSpec flag;
    public final boolean alwaysDrawAppearances;
    public Clr subColor;
    public Clr subBaseColor;
    public Clr[] subColorByPaintTypeIndex;
    public DecalType flipped;
    public DecalType verticalFlipped;
    public String flippedName;
    public String verticalFlippedName;
    public boolean isHead;
    public ArrayList<DecalLightSource> lights = new ArrayList();
    public static final Clr STENCIL = Clr.fromHex((String)"000000cc");

    public DecalType(JSONObject o) {
        super(o.getString("name"), o.optInt("sort", 0));
        int i;
        JSONArray a;
        this.w = o.getInt("w");
        this.h = o.getInt("h");
        this.flippedName = o.optString("flippedVersion", null);
        this.verticalFlippedName = o.optString("verticallyFlippedVersion", null);
        if (o.has("appearances")) {
            a = o.getJSONArray("appearances");
            for (i = 0; i < a.length(); ++i) {
                this.apps.add(new TintedApp(a.getJSONObject(i)));
            }
        }
        this.flipWithShip = o.optBoolean("flipWithShip", false);
        this.nameDetails = o.has("shipName") ? new NameDetails(o.getJSONObject("shipName")) : null;
        this.armsDetails = o.has("arms") ? new ArmsDetails(o.getJSONObject("arms")) : null;
        this.chargeDetails = o.has("charge") ? new ChargeDetails(o.getJSONObject("charge")) : null;
        this.flag = o.has("flag") ? new FlagSpec(o.getJSONObject("flag")) : null;
        this.alwaysDrawAppearances = o.optBoolean("alwaysDrawAppearances", false);
        if (o.has("subColor")) {
            JSONObject co = o.getJSONObject("subColor");
            this.subColor = new Clr(co.getInt("r"), co.getInt("g"), co.getInt("b"));
            if (o.has("subBaseColor")) {
                JSONObject bco = o.getJSONObject("subBaseColor");
                this.subBaseColor = new Clr(bco.getInt("r"), bco.getInt("g"), bco.getInt("b"));
            } else {
                this.subBaseColor = this.subColor;
            }
            ArrayList<PaintType> ps = PaintType.values();
            this.subColorByPaintTypeIndex = new Clr[ps.size()];
            for (int i2 = 0; i2 < ps.size(); ++i2) {
                Clr tc = ps.get(i2).getBaseTint();
                this.subColorByPaintTypeIndex[i2] = new Clr(this.subBaseColor.r * (255 - tc.a) / 255 + tc.r * tc.a / 255, this.subBaseColor.g * (255 - tc.a) / 255 + tc.g * tc.a / 255, this.subBaseColor.b * (255 - tc.a) / 255 + tc.b * tc.a / 255);
            }
        }
        this.imgW = !this.apps.isEmpty() && !this.apps.get((int)0).app.frames.isEmpty() ? this.apps.get((int)0).app.frames.get((int)0).srcWidth / 16 : this.w;
        if (o.has("lights")) {
            a = o.getJSONArray("lights");
            for (i = 0; i < a.length(); ++i) {
                JSONObject l = a.getJSONObject(i);
                this.lights.add(new DecalLightSource(new Clr(l.getInt("r"), l.getInt("g"), l.getInt("b")), l.getInt("radius"), l.getDouble("x"), l.getDouble("y")));
            }
        }
    }

    public static void postLoad() {
        for (DecalType dt : Loadable.all(DecalType.class)) {
            DecalType dt2;
            if (dt.flippedName != null && Loadable.hasOfName(DecalType.class, dt.flippedName)) {
                dt.flipped = dt2 = DecalType.ofName(dt.flippedName);
                dt2.flipped = dt;
            }
            if (dt.verticalFlippedName == null || !Loadable.hasOfName(DecalType.class, dt.verticalFlippedName)) continue;
            dt.verticalFlipped = dt2 = DecalType.ofName(dt.verticalFlippedName);
            dt2.verticalFlipped = dt;
        }
        for (DecalType dt : Loadable.all(DecalType.class)) {
            if (dt.flipped == null || dt.flipped.verticalFlipped == null || dt.flipped.verticalFlipped.flipped == null) continue;
            dt.verticalFlipped = dt.flipped.verticalFlipped.flipped;
        }
        for (DecalType dt : Loadable.all(DecalType.class)) {
            if (dt.flippedName != null) {
                dt.isHead = dt.verticalFlippedName != null || dt.verticalFlipped == null;
                continue;
            }
            dt.isHead = dt.flipped == null && dt.verticalFlippedName != null;
        }
    }

    public boolean isSymmetryGroupHead() {
        return this.isHead;
    }

    public boolean isSymmetryGroupMember() {
        return this.flipped != null || this.verticalFlipped != null;
    }

    public DecalType getSymmetryGroupHead() {
        if (this.isHead) {
            return this;
        }
        if (this.flipped != null) {
            if (this.flipped.isHead) {
                return this.flipped;
            }
            if (this.flipped.verticalFlipped != null && this.flipped.verticalFlipped.isHead) {
                return this.flipped.verticalFlipped;
            }
        }
        if (this.verticalFlipped != null && this.verticalFlipped.isHead) {
            return this.verticalFlipped;
        }
        return this;
    }

    public boolean hasColoration() {
        return this.subColor != null;
    }

    public Clr colorationDefault() {
        return this.subColor;
    }

    public boolean canPlaceBelow() {
        return this.nameDetails == null && this.armsDetails == null && this.chargeDetails == null && this.flag == null;
    }

    public static DecalType ofName(String name) {
        return Loadable.ofName(DecalType.class, name);
    }

    static void pixelateStencil() {
        for (Img img : AGame.STENCIL.imgs) {
            if (img == null || img.machineImgCache == null) continue;
            ((Image)img.machineImgCache).setFilter(9728);
        }
        for (Img img : AGame.STENCIL.extended.values()) {
            if (img == null || img.machineImgCache == null) continue;
            ((Image)img.machineImgCache).setFilter(9728);
        }
    }

    public void drawAsBlueprint(Draw d, double x, double y, int ms, boolean flipped, float intensity) {
        int appSz = this.apps.size();
        for (int appI = 0; appI < appSz; ++appI) {
            TintedApp ta = this.apps.get(appI);
            ta.app.drawAsBlueprint(d, x + (double)(ta.x * (flipped ? -1 : 1)), y + (double)ta.y, ms, flipped, intensity);
        }
        if (this.armsDetails != null) {
            d.rect(Clr.WHITE, x + (double)this.armsDetails.x, y + (double)this.armsDetails.y, (double)this.armsDetails.size, (double)this.armsDetails.size);
        }
        if (this.chargeDetails != null) {
            d.rect(Clr.WHITE, x + (double)this.chargeDetails.x, y + (double)this.chargeDetails.y, (double)this.chargeDetails.w, (double)this.chargeDetails.h);
        }
    }

    public void drawAsOutline(Draw d, double x, double y, int ms, boolean flipped, Clr c) {
        int appSz = this.apps.size();
        for (int appI = 0; appI < appSz; ++appI) {
            TintedApp ta = this.apps.get(appI);
            ta.app.drawAsOutline(d, x + (double)(ta.x * (flipped ? -1 : 1)), y + (double)ta.y, 0.0, 0.0, ms, flipped, c);
        }
        if (this.armsDetails != null) {
            d.rect(c, x + (double)this.armsDetails.x, y + (double)this.armsDetails.y, (double)this.armsDetails.size, 1.0);
            d.rect(c, x + (double)this.armsDetails.x, y + (double)this.armsDetails.y + (double)this.armsDetails.size - 1.0, (double)this.armsDetails.size, 1.0);
            d.rect(c, x + (double)this.armsDetails.x, y + (double)this.armsDetails.y, 1.0, (double)this.armsDetails.size);
            d.rect(c, x + (double)this.armsDetails.x + (double)this.armsDetails.size - 1.0, y + (double)this.armsDetails.y, 1.0, (double)this.armsDetails.size);
        }
        if (this.chargeDetails != null) {
            d.rect(c, x + (double)this.chargeDetails.x, y + (double)this.chargeDetails.y, (double)this.chargeDetails.w, 1.0);
            d.rect(c, x + (double)this.chargeDetails.x, y + (double)this.chargeDetails.y + (double)this.chargeDetails.h - 1.0, (double)this.chargeDetails.w, 1.0);
            d.rect(c, x + (double)this.chargeDetails.x, y + (double)this.chargeDetails.y, 1.0, (double)this.chargeDetails.h);
            d.rect(c, x + (double)this.chargeDetails.x + (double)this.chargeDetails.w - 1.0, y + (double)this.chargeDetails.y, 1.0, (double)this.chargeDetails.h);
        }
    }

    public void drawBase(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, PaintType subPaint) {
        int appSz = this.apps.size();
        for (int appI = 0; appI < appSz; ++appI) {
            TintedApp ta = this.apps.get(appI);
            Clr tint = null;
            float ls = lightStrength;
            if (ta.tint != null) {
                Tincture tinc = coa.getRoundelTinctures()[ta.tint.ordinal()];
                tint = tinc.tint;
                if (tinc.metal) {
                    ls *= 5.0f;
                }
            }
            if (ta.app.spritesheetBundle == ssb || ssb == null) {
                Clr subTrg = null;
                if (this.subColor != null) {
                    subTrg = subPaint == null ? this.subColor : this.subColorByPaintTypeIndex[subPaint.ordinal()];
                }
                float shiny = subPaint == null ? 0.36f : subPaint.shinyOrPassthrough();
                ta.app.drawSub(d, x + (double)(ta.x * (flipped ? -1 : 1)), y + (double)ta.y, 0.0, 0.0, 0, tint, this.flipWithShip ? flipped : false, light, ls, ambient, ambientSaturation, this.subColor, subTrg, shiny);
                continue;
            }
            if (additionalSSBs == null) continue;
            additionalSSBs.add(ta.app.spritesheetBundle);
        }
        if (this.armsDetails != null && (ssb == null || ssb.name.equals("spritesheet"))) {
            coa.drawBase(d, x + (double)this.armsDetails.x, y + (double)this.armsDetails.y, this.armsDetails.size, light, lightStrength, ambient, ambientSaturation);
        }
    }

    public void drawCharges(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
        if (this.armsDetails != null) {
            coa.drawCharges(d, x + (double)this.armsDetails.x, y + (double)this.armsDetails.y, this.armsDetails.size, light, lightStrength, ambient, ambientSaturation, ssb, additionalSSBs);
        }
        if (this.chargeDetails != null && coa.charge[0] != null) {
            Tincture tinc = this.chargeDetails.tint == null ? this.chargeDetails.tincture : coa.getRoundelTinctures()[this.chargeDetails.tint.ordinal()];
            float ls = lightStrength;
            if (tinc.metal) {
                ls *= 5.0f;
            }
            if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                coa.charge[0].app.draw(d, x + (double)this.chargeDetails.x, y + (double)this.chargeDetails.y, this.chargeDetails.w, this.chargeDetails.h, 0, tinc.tint, false, light, ls, ambient, ambientSaturation);
            } else if (additionalSSBs != null) {
                additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
            }
        }
    }

    public void drawUnlitCharges(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa) {
        if (this.armsDetails != null) {
            coa.drawUnlitCharges(d, x + (double)this.armsDetails.x, y + (double)this.armsDetails.y, this.armsDetails.size);
        }
    }

    public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
        name = name.toUpperCase().replaceAll("\\[|\\]|\\{|\\}", "");
        if (this.chargeDetails != null && coa.specialCharge[0] != null) {
            Tincture tinc = this.chargeDetails.tint == null ? this.chargeDetails.tincture : coa.getRoundelTinctures()[this.chargeDetails.tint.ordinal()];
            d.drawSpecialCharge(coa.specialCharge[0], tinc.tint.mult(tint), x + (double)this.chargeDetails.x, y + (double)this.chargeDetails.y, this.chargeDetails.w, this.chargeDetails.h);
        }
        if (this.nameDetails != null) {
            DecalType.pixelateStencil();
            double textX = x + (double)this.nameDetails.x;
            double textY = y + (double)this.nameDetails.y;
            if (this.nameDetails.align == NameAlign.CENTER) {
                textX -= (double)((int)d.textSize((String)name.toUpperCase(), (Fount)AGame.STENCIL).x / 2);
            }
            d.text("[000000f7]" + name.toUpperCase(), AGame.STENCIL, textX, textY);
        }
    }

    @Override
    public String getName() {
        return Lang._t("decal_" + this.name, new Object[0]);
    }

    public strictfp static class ChargeDetails {
        public final int x;
        public final int y;
        public final int w;
        public final int h;
        public final ArmsTint tint;
        public final Tincture tincture;

        public ChargeDetails(JSONObject o) {
            this.x = o.optInt("x", 0);
            this.y = o.optInt("y", 0);
            this.w = o.getInt("w");
            this.h = o.getInt("h");
            this.tint = o.has("tint") ? ArmsTint.valueOf(o.getString("tint")) : null;
            this.tincture = o.has("tincture") ? Tincture.valueOf(o.getString("tincture")) : null;
        }
    }

    public strictfp static class ArmsDetails {
        public final int x;
        public final int y;
        public final int size;

        public ArmsDetails(JSONObject o) {
            this.x = o.optInt("x", 0);
            this.y = o.optInt("y", 0);
            this.size = o.getInt("size");
        }
    }

    private strictfp static class NameDetails {
        public final int x;
        public final int y;
        public final NameAlign align;

        private NameDetails(JSONObject o) {
            this.x = o.optInt("x", 0);
            this.y = o.optInt("y", 0);
            this.align = o.has("align") ? NameAlign.valueOf(o.getString("align")) : NameAlign.LEFT;
        }
    }

    private strictfp static enum NameAlign {
        LEFT,
        CENTER;

    }

    public strictfp static class TintedApp {
        public final ArmsTint tint;
        public final int x;
        public final int y;
        public final Appearance app;

        private TintedApp(JSONObject o) {
            this.tint = o.has("tint") ? ArmsTint.valueOf(o.getString("tint")) : null;
            this.x = o.optInt("x", 0);
            this.y = o.optInt("y", 0);
            this.app = new Appearance(o.getJSONObject("appearance"));
        }
    }

    private strictfp static enum ArmsTint {
        ARMS0,
        ARMS1,
        ARMS2;

    }

    public strictfp static class DecalLightSource {
        public final Clr clr;
        public final int radius;
        public final double xOffset;
        public final double yOffset;

        public DecalLightSource(Clr lightClr, int lightRadius, double lightX, double lightY) {
            this.clr = lightClr;
            this.radius = lightRadius;
            this.xOffset = lightX;
            this.yOffset = lightY;
        }
    }
}

