/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.FileScreen;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;

public strictfp class DateSorter
implements FileScreen.Sorter {
    private final FileScreen.Backend backend;

    public DateSorter(FileScreen.Backend backend) {
        this.backend = backend;
    }

    @Override
    public String getNameKey() {
        return "Date";
    }

    @Override
    public Comparator<String> ascending() {
        return new Asc();
    }

    @Override
    public Comparator<String> descending() {
        return new Desc();
    }

    @Override
    public boolean popUpdateNeeded() {
        return false;
    }

    private strictfp class Desc
    implements Comparator<String> {
        private final HashMap<String, Long> nameToModified = new HashMap();

        private Desc() {
        }

        private long getModified(String name) {
            if (this.nameToModified.containsKey(name)) {
                return this.nameToModified.get(name);
            }
            File f = DateSorter.this.backend.getFile(FileScreen.splitPath(name));
            long modified = f != null && f.exists() ? f.lastModified() : -1L;
            this.nameToModified.put(name, modified);
            return modified;
        }

        @Override
        public int compare(String o1, String o2) {
            long m1 = this.getModified(o1);
            long m2 = this.getModified(o2);
            if (m1 != -1L) {
                if (m2 != -1L) {
                    return Long.compare(m2, m1);
                }
                return -1;
            }
            if (m2 != -1L) {
                return 1;
            }
            return 0;
        }
    }

    private strictfp class Asc
    implements Comparator<String> {
        private final HashMap<String, Long> nameToModified = new HashMap();

        private Asc() {
        }

        private long getModified(String name) {
            if (this.nameToModified.containsKey(name)) {
                return this.nameToModified.get(name);
            }
            File f = DateSorter.this.backend.getFile(FileScreen.splitPath(name));
            long modified = f != null && f.exists() ? f.lastModified() : -1L;
            this.nameToModified.put(name, modified);
            return modified;
        }

        @Override
        public int compare(String o1, String o2) {
            long m1 = this.getModified(o1);
            long m2 = this.getModified(o2);
            if (m1 != -1L) {
                if (m2 != -1L) {
                    return Long.compare(m1, m2);
                }
                return -1;
            }
            if (m2 != -1L) {
                return 1;
            }
            return 0;
        }
    }
}

