/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.AnimationType;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Blast;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.BonusSet;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CrewAnimator;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.ExceptionalCombatEvent;
import com.zarkonnen.airships.FireMode;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.GridLocation;
import com.zarkonnen.airships.GridRef;
import com.zarkonnen.airships.Job;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.MiscCombatSound;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.OutsideBodyPath;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.ParticleType;
import com.zarkonnen.airships.PhysicsRect;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.RotatingColoringShader;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Substitution;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.Trail;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;

public strictfp class Crewman
extends PhysicsRect {
    public static final int SHOUT_LENGTH = 1800;
    public static final int BIG_SHOUT_LENGTH = 1800;
    public static final int SHOUT_MIN_DELAY = 4000;
    public static final int SHOUT_MAX_DELAY = 9000;
    public static final int RECALC_JUMP_POINT_WAIT = 300;
    public static final int NEW_THROW_WAIT = 3000;
    public static final double MAX_JUMP_DOWN = 120.0;
    public static final double JUMP_STRAIGHT_DOWN = 128.0;
    public static final double ASSUMED_JUMP_DIST = 50.0;
    public CrewType type;
    public int hp = 5;
    public int repairMs = 0;
    public transient int oldHP = 5;
    public Airship ship;
    public Airship boardingShip;
    public boolean occupied = false;
    public Tile currentTile;
    public Tile movingTowards;
    public Module target;
    public Tile targetTile;
    public Tile meleeTargetTile;
    public Crewman headingFor;
    public int msSinceMoved;
    public int giveResourceWait;
    public int weaponReload;
    public int msUntilRecalcJumpPoint;
    public int msUntilRecalcWalkPoint;
    public Job job;
    public Resource carrying;
    public Crewman injuredCarried;
    public transient String shout;
    public transient int shoutOriginX;
    public transient int shoutOriginY;
    public transient int shoutX;
    public transient int shoutY;
    public transient int shoutW;
    public transient int shoutH;
    public transient int shoutMs;
    public transient int shoutCooldown;
    public transient int initialShoutCooldown;
    public transient boolean bigShout;
    public transient int fallingTime;
    public transient boolean standing;
    public transient CrewAnimator anim = new CrewAnimator(this);
    public Tile boardExitTarget;
    public double mvXOffset = 0.0;
    public double dx;
    public double dy;
    public double mvDx;
    public double mvDy;
    public double trackingDx;
    public Body attachedTo;
    public Body ignoring;
    public GridBody ultimateBoardTarget;
    public GridBody proximateBoardTarget;
    public GridRef walkToTargetGR;
    public GridRef walkToGR;
    public GridRef jumpSourceGR;
    public GridRef entryPoint;
    public Body dispersed;
    public boolean grabbed;
    public int timeSinceLaunch;
    public OutsideBodyPath outsideBodyPath;
    public Pt strafeTo;
    public Airship attackTarget;
    public Crewman interceptTarget;
    public Tile homeTile;
    public boolean hookLaunched;
    public GridRef hookedGR;
    public boolean winching;
    public Pt hookSource;
    public Pt hookTarget;
    public GridBody hookTargetBody;
    public double hookProgress;
    public double hookDist;
    public int newThrowWait = 0;
    public Crewman shootTarget;
    public int shootAccumulator;
    public int ammo;
    public int rearmAccumulator;
    public boolean isSmart = false;

    public int cheapHash() {
        int h = 7;
        h = h * 31 + this.shootAccumulator;
        h = h * 31 + this.hp;
        h = h * 31 + this.repairMs;
        h = h * 31 + this.weaponReload;
        if (this.ship == null && this.boardingShip == null) {
            h = h * 31 + new Double(this.getX()).hashCode();
            h = h * 31 + new Double(this.getY()).hashCode();
            h = h * 31 + new Double(this.dx).hashCode();
            h = h * 31 + new Double(this.dy).hashCode();
            h = h * 31 + new Double(this.mvDx).hashCode();
            h = h * 31 + new Double(this.mvDy).hashCode();
            h = h * 31 + new Double(this.trackingDx).hashCode();
            h = h * 31 + new Double(this.mvXOffset).hashCode();
        } else {
            h = h * 31 + this.msSinceMoved;
        }
        return h;
    }

    public Crewman(Airship ship, Tile tile, CrewType type) {
        this.type = type;
        this.ship = ship;
        this.currentTile = tile;
        this.hp = type.maxHP;
        this.oldHP = type.maxHP;
        this.shoutCooldown = AGame.ANIM_R.nextInt(5000) + 4000;
        this.initialShoutCooldown = 4000;
        this.ammo = type.ammoCapacity;
    }

    private static double guardNaN(double v) {
        return Double.isNaN(v) || Double.isInfinite(v) ? 0.0 : v;
    }

    private JSONObject toJSON(OutsideBodyPath obp, Combat c) {
        JSONObject o = new JSONObject().put("nextWaypointIndex", obp.nextWaypointIndex);
        JSONArray a = new JSONArray();
        o.put("waypoints", a);
        for (GridLocation gl : obp.waypoints) {
            if (!this.exists(gl.body(), c)) {
                return null;
            }
            JSONObject glO = new JSONObject();
            if (gl instanceof GridRef) {
                this.putGridRef(glO, "gridRef", (GridRef)gl, c);
            } else if (gl instanceof Tile) {
                Tile t = (Tile)gl;
                if (!t.solid()) {
                    return null;
                }
                this.putBody(glO, "tile", t.ship, c);
                glO.put("tileX", t.x);
                glO.put("tileY", t.y);
            }
            a.put(glO);
        }
        return o;
    }

    public JSONObject toJSON(Combat c) {
        Combat.Side s;
        JSONObject obp;
        JSONObject o = new JSONObject().put("msSinceMoved", this.msSinceMoved).put("giveResourceWait", this.giveResourceWait).put("weaponReload", this.weaponReload).put("hp", this.hp).put("type", this.type.name).put("occupied", this.occupied).put("msUntilRecalcJumpPoint", this.msUntilRecalcJumpPoint).put("msUntilRecalcWalkPoint", this.msUntilRecalcWalkPoint).put("mvXOffset", this.mvXOffset).put("shootAccumulator", this.shootAccumulator).put("timeSinceLaunch", this.timeSinceLaunch).put("repairMs", this.repairMs).put("ammo", this.ammo).put("rearmAccumulator", this.rearmAccumulator);
        if (this.outsideBodyPath != null && c != null && (obp = this.toJSON(this.outsideBodyPath, c)) != null) {
            o.put("outsideBodyPath", obp);
        }
        if (this.shootTarget != null) {
            if (this.boardingShip != null && this.boardingShip.crew.contains(this.shootTarget)) {
                o.put("boardingShipCrewShootTarget", this.boardingShip.crew.indexOf(this.shootTarget));
            }
            if (this.ship != null && this.ship.boarders.contains(this.shootTarget)) {
                o.put("shipBoardersShootTarget", this.ship.boarders.indexOf(this.shootTarget));
            }
        }
        if (this.strafeTo != null) {
            o.put("strafeToX", this.strafeTo.x);
            o.put("strafeToY", this.strafeTo.x);
        }
        if (this.attackTarget != null && c != null && (s = c.sideOf(this.attackTarget)) != null) {
            o.put("attackTargetSide", c.sides.indexOf(s));
            o.put("attackTargetIndex", s.ships.indexOf(this.attackTarget));
        }
        if (this.carrying != null) {
            o.put("carrying", this.carrying.name());
        }
        if (this.ship != null) {
            o.put("tile", this.ship.tiles.indexOf(this.currentTile));
            if (this.target != null) {
                o.put("target", this.ship.modules.indexOf(this.target));
            }
            if (this.targetTile != null) {
                o.put("targetTile", this.ship.tiles.indexOf(this.targetTile));
            }
            if (this.meleeTargetTile != null) {
                o.put("meleeTargetTile", this.ship.tiles.indexOf(this.meleeTargetTile));
            }
            if (this.job != null) {
                o.put("jobModule", this.ship.modules.indexOf(this.job.module()));
                o.put("jobIndex", this.job.module().jobs().indexOf(this.job));
            }
            if (this.injuredCarried != null && this.ship.crew.contains(this.injuredCarried)) {
                o.put("injuredCarried", this.ship.crew.indexOf(this.injuredCarried));
            }
            if (this.headingFor != null && this.ship.crew.contains(this.headingFor)) {
                o.put("headingFor", this.ship.crew.indexOf(this.headingFor));
            }
            if (this.movingTowards != null && this.ship.tiles.contains(this.movingTowards)) {
                o.put("movingTowards", this.ship.tiles.indexOf(this.movingTowards));
            }
            if (this.boardExitTarget != null && this.ship.tiles.contains(this.boardExitTarget)) {
                o.put("boardExitTarget", this.ship.tiles.indexOf(this.boardExitTarget));
            }
        }
        if (this.boardingShip != null) {
            o.put("tile", this.boardingShip.tiles.indexOf(this.currentTile));
            if (this.target != null) {
                o.put("target", this.boardingShip.modules.indexOf(this.target));
            }
            if (this.targetTile != null) {
                o.put("targetTile", this.boardingShip.tiles.indexOf(this.targetTile));
            }
            if (this.meleeTargetTile != null) {
                o.put("meleeTargetTile", this.boardingShip.tiles.indexOf(this.meleeTargetTile));
            }
            if (this.movingTowards != null && this.boardingShip.tiles.contains(this.movingTowards)) {
                o.put("movingTowards", this.boardingShip.tiles.indexOf(this.movingTowards));
            }
            if (this.boardExitTarget != null && this.boardingShip.tiles.contains(this.boardExitTarget)) {
                o.put("boardExitTarget", this.boardingShip.tiles.indexOf(this.boardExitTarget));
            }
        }
        if (c != null && this.isOutside()) {
            o.put("x", Crewman.guardNaN(this.getX())).put("y", Crewman.guardNaN(this.getY())).put("dx", Crewman.guardNaN(this.dx)).put("dy", Crewman.guardNaN(this.dy)).put("mvDx", Crewman.guardNaN(this.mvDx)).put("mvDy", Crewman.guardNaN(this.mvDy));
            if (this.attachedTo != null && c.physics.bodies.contains(this.attachedTo)) {
                o.put("attachedToIndex", c.physics.bodies.indexOf(this.attachedTo));
            }
            if (this.ignoring != null && c.physics.bodies.contains(this.ignoring)) {
                o.put("ignoringIndex", c.physics.bodies.indexOf(this.ignoring));
            }
            if (this.dispersed != null && c.physics.bodies.contains(this.dispersed)) {
                o.put("dispersedIndex", c.physics.bodies.indexOf(this.dispersed));
            }
            this.putBody(o, "proximateBoardTarget", this.proximateBoardTarget, c);
            this.putBody(o, "boardTarget", this.ultimateBoardTarget, c);
            this.putGridRef(o, "jumpSourceTile", this.jumpSourceGR, c);
            this.putGridRef(o, "entryPoint", this.entryPoint, c);
            this.putGridRef(o, "hookedTile", this.hookedGR, c);
            this.putGridRef(o, "walkToTargetGR", this.walkToTargetGR, c);
            this.putGridRef(o, "walkToGR", this.walkToGR, c);
            o.put("hookLaunched", this.hookLaunched);
            o.put("winching", this.winching);
            if (this.hookSource != null) {
                o.put("hookSourceX", this.hookSource.x);
                o.put("hookSourceY", this.hookSource.y);
            }
            if (this.hookTarget != null) {
                o.put("hookTargetX", this.hookTarget.x);
                o.put("hookTargetY", this.hookTarget.y);
            }
            this.putBody(o, "hookTarget", this.hookTargetBody, c);
            o.put("hookProgress", this.hookProgress);
            o.put("hookDist", this.hookDist);
            o.put("newThrowWait", this.newThrowWait);
            if (this.homeTile != null && this.homeTile.ship.tiles.contains(this.homeTile) && this.exists(this.homeTile.ship, c)) {
                this.putBody(o, "homeTile", this.homeTile.ship, c);
                o.put("homeTileIndex", this.homeTile.ship.tiles.indexOf(this.homeTile));
            }
            if (this.interceptTarget != null) {
                int ssz = c.sides.size();
                for (int si = 0; si < ssz; ++si) {
                    if (!c.sides.get((int)si).troops.contains(this.interceptTarget)) continue;
                    o.put("interceptTargetSideIndex", si);
                    o.put("interceptTargetIndex", c.sides.get((int)si).troops.indexOf(this.interceptTarget));
                }
            }
        }
        return o;
    }

    private void putBody(JSONObject o, String name, GridBody gb, Combat c) {
        if (gb != null && c != null) {
            Airship s;
            Combat.Side side;
            if (gb instanceof Airship && (side = c.sideOf(s = (Airship)gb)) != null) {
                o.put(name + "SideIndex", c.sides.indexOf(side));
                o.put(name + "ShipIndex", side.ships.indexOf(gb));
            }
            if (gb instanceof LandFormation && c.landFormations.indexOf(gb) != -1) {
                o.put(name + "LFIndex", c.landFormations.indexOf(gb));
            }
        }
    }

    private void putGridRef(JSONObject o, String name, GridRef gr, Combat c) {
        if (gr != null && c != null) {
            this.putBody(o, name, gr.body, c);
            o.put(name + "X", gr.gridX);
            o.put(name + "Y", gr.gridY);
        }
    }

    public Crewman(JSONObject o, Airship ship, Airship boardingShip) {
        String[] typeNames;
        this.ship = ship;
        this.boardingShip = boardingShip;
        if (ship != null) {
            this.currentTile = ship.tiles.get(o.getInt("tile"));
            if (o.has("target")) {
                this.target = ship.modules.get(o.getInt("target"));
            }
            if (o.has("targetTile")) {
                this.targetTile = ship.tiles.get(o.getInt("targetTile"));
            }
            if (o.has("meleeTargetTile")) {
                this.meleeTargetTile = ship.tiles.get(o.getInt("meleeTargetTile"));
            }
            if (o.has("jobModule") && ship.modules.size() > o.getInt("jobModule") && ship.modules.get(o.getInt("jobModule")).jobs().size() > o.getInt("jobIndex")) {
                this.job = ship.modules.get(o.getInt("jobModule")).jobs().get(o.getInt("jobIndex"));
            }
            if (o.has("movingTowards")) {
                this.movingTowards = ship.tiles.get(o.getInt("movingTowards"));
            }
            if (o.has("boardExitTarget")) {
                this.boardExitTarget = ship.tiles.get(o.getInt("boardExitTarget"));
            }
        }
        if (boardingShip != null) {
            this.currentTile = boardingShip.tiles.get(o.getInt("tile"));
            if (o.has("target")) {
                this.target = boardingShip.modules.get(o.getInt("target"));
            }
            if (o.has("targetTile")) {
                this.targetTile = boardingShip.tiles.get(o.getInt("targetTile"));
            }
            if (o.has("meleeTargetTile")) {
                this.meleeTargetTile = boardingShip.tiles.get(o.getInt("meleeTargetTile"));
            }
            if (o.has("movingTowards")) {
                this.movingTowards = boardingShip.tiles.get(o.getInt("movingTowards"));
            }
            if (o.has("boardExitTarget")) {
                this.boardExitTarget = boardingShip.tiles.get(o.getInt("boardExitTarget"));
            }
        }
        this.repairMs = o.optInt("repairMs", 0);
        this.mvXOffset = o.optDouble("mvXOffset", 0.0);
        this.msSinceMoved = o.getInt("msSinceMoved");
        this.weaponReload = o.optInt("weaponReload", 0);
        this.shootAccumulator = o.optInt("shootAccumulator", 0);
        this.msUntilRecalcJumpPoint = o.optInt("msUntilRecalcJumpPoint", 0);
        this.msUntilRecalcWalkPoint = o.optInt("msUntilRecalcWalkPoint", 0);
        this.timeSinceLaunch = o.optInt("timeSinceLaunch", 0);
        this.ammo = o.optInt("ammo", 0);
        this.rearmAccumulator = o.optInt("rearmAccumulator", 0);
        this.oldHP = this.hp = o.getInt("hp");
        if (o.has("giveResourceWait")) {
            this.giveResourceWait = o.getInt("giveResourceWait");
        }
        if (o.has("carrying")) {
            this.carrying = Resource.valueOf(o.getString("carrying"));
        }
        CrewType ct = null;
        for (String typeName : typeNames = new String[]{o.optString("type", "sailor").toLowerCase(Locale.ENGLISH), o.optString("type", "sailor")}) {
            if (ship != null) {
                for (Substitution sub : Loadable.all(Substitution.class)) {
                    if (!typeName.equals(sub.fromCrew) || !sub.forTypes.contains((Object)ship.type)) continue;
                    typeName = sub.toCrew;
                }
            }
            try {
                ct = CrewType.ofName(typeName);
                break;
            }
            catch (Loadable.NotFoundException e) {
                if (!typeName.equals(typeNames[typeNames.length - 1])) continue;
                throw e;
            }
        }
        this.type = ct;
        this.occupied = o.optBoolean("occupied", false);
        this.setX(o.optDouble("x", 0.0));
        this.setY(o.optDouble("y", 0.0));
        this.dx = o.optDouble("dx", 0.0);
        this.dy = o.optDouble("dy", 0.0);
        this.mvDx = o.optDouble("mvDx", 0.0);
        this.mvDy = o.optDouble("mvDy", 0.0);
    }

    public void finishLoading(JSONObject o, Combat c) {
        if (this.ship != null) {
            if (o.has("injuredCarried")) {
                this.injuredCarried = this.ship.crew.get(o.getInt("injuredCarried"));
            }
            if (o.has("headingFor")) {
                this.headingFor = this.ship.crew.get(o.getInt("headingFor"));
            }
        }
        if (c != null) {
            if (o.has("attachedToIndex")) {
                this.attachedTo = c.physics.bodies.get(o.getInt("attachedToIndex"));
            }
            if (o.has("ignoringIndex")) {
                this.ignoring = c.physics.bodies.get(o.getInt("ignoringIndex"));
            }
            if (o.has("attackTargetSide")) {
                this.attackTarget = c.sides.get((int)o.getInt((String)"attackTargetSide")).ships.get(o.getInt("attackTargetIndex"));
            }
            if (o.has("strafeToX")) {
                this.strafeTo = new Pt(o.getDouble("strafeToX"), o.getDouble("strafeToY"));
            }
            this.dispersed = this.getBody(o, "dispersed", c);
            this.proximateBoardTarget = this.getBody(o, "proximateBoardTarget", c);
            this.ultimateBoardTarget = this.getBody(o, "boardTarget", c);
            this.jumpSourceGR = this.getGridRef(o, "jumpSourceTile", c);
            this.walkToTargetGR = this.getGridRef(o, "walkToTargetGR", c);
            this.walkToGR = this.getGridRef(o, "walkToGR", c);
            this.entryPoint = this.getGridRef(o, "entryPoint", c);
            this.hookedGR = this.getGridRef(o, "hookedTile", c);
            this.hookLaunched = o.optBoolean("hookLaunched");
            this.winching = o.optBoolean("winching");
            if (o.has("hookSourceX")) {
                this.hookSource = new Pt(o.getDouble("hookSourceX"), o.getDouble("hookSourceY"));
            }
            if (o.has("hookTargetX")) {
                this.hookTarget = new Pt(o.getDouble("hookTargetX"), o.getDouble("hookTargetY"));
            }
            this.hookTargetBody = this.getBody(o, "hookTarget", c);
            this.hookProgress = o.optDouble("hookProgress", 0.0);
            this.hookDist = o.optDouble("hookDist", 0.0);
            this.newThrowWait = o.optInt("newThrowWait", 0);
            if (o.has("outsideBodyPath")) {
                JSONObject obpO = o.getJSONObject("outsideBodyPath");
                JSONArray wps = obpO.getJSONArray("waypoints");
                ArrayList<GridLocation> gls = new ArrayList<GridLocation>();
                for (int i = 0; i < wps.length(); ++i) {
                    JSONObject wpO = wps.getJSONObject(i);
                    if (wpO.has("gridRefX")) {
                        gls.add(this.getGridRef(wpO, "gridRef", c));
                        continue;
                    }
                    gls.add(((Airship)this.getBody(wpO, "tile", c)).tileAt(wpO.getInt("tileX"), wpO.getInt("tileY")));
                }
                this.outsideBodyPath = new OutsideBodyPath(gls);
                this.outsideBodyPath.nextWaypointIndex = obpO.getInt("nextWaypointIndex");
            }
            if (o.has("homeTileIndex")) {
                this.homeTile = ((Airship)this.getBody((JSONObject)o, (String)"homeTile", (Combat)c)).tiles.get(o.getInt("homeTileIndex"));
            }
            if (o.has("interceptTargetIndex")) {
                this.interceptTarget = c.sides.get((int)o.getInt((String)"interceptTargetSideIndex")).troops.get(o.getInt("interceptTargetIndex"));
            }
        }
        if (o.has("boardingShipCrewShootTarget") && this.boardingShip != null) {
            this.shootTarget = this.boardingShip.crew.get(o.getInt("boardingShipCrewShootTarget"));
        }
        if (o.has("shipBoardersShootTarget") && this.ship != null) {
            this.shootTarget = this.ship.boarders.get(o.getInt("shipBoardersShootTarget"));
        }
    }

    private GridBody getBody(JSONObject o, String name, Combat c) {
        if (c != null && o.has(name + "SideIndex")) {
            Combat.Side side = c.sides.get(o.getInt(name + "SideIndex"));
            return side.ships.get(o.getInt(name + "ShipIndex"));
        }
        if (c != null && o.has(name + "LFIndex")) {
            return c.landFormations.get(o.getInt(name + "LFIndex"));
        }
        return null;
    }

    private GridRef getGridRef(JSONObject o, String name, Combat c) {
        GridBody gb = this.getBody(o, name, c);
        if (gb != null) {
            return new GridRef(o.getInt(name + "X"), o.getInt(name + "Y"), gb);
        }
        return null;
    }

    public boolean ignores(Body b) {
        if (b.isImmobile()) {
            return false;
        }
        if (b == this.ignoring) {
            return true;
        }
        return this.attachedTo != null && this.attachedTo.isImmobile() && b != this.attachedTo && b != this.ultimateBoardTarget && b != this.proximateBoardTarget;
    }

    public Crewman carrier() {
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        int csz = sh.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = sh.crew.get(ci);
            if (cm.injuredCarried != this) continue;
            return cm;
        }
        return null;
    }

    public boolean beingCarried() {
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        int csz = sh.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = sh.crew.get(ci);
            if (cm.injuredCarried != this) continue;
            return true;
        }
        return false;
    }

    public boolean needsRescue(boolean canBeDead) {
        if (!canBeDead && !this.alive() || this.active() || this.currentTile.module.type.getSickbay(this.currentTile.module.ship.currentBonuses) > 0 && this.currentTile.module.hp > 0 && this.currentTile.module.somewhatStaffed()) {
            return false;
        }
        int csz = this.ship.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = this.ship.crew.get(ci);
            if (cm.headingFor != this && cm.injuredCarried != this) continue;
            return false;
        }
        return true;
    }

    public boolean active() {
        return this.hp >= this.type.minWorkingHP;
    }

    public boolean alive() {
        return this.hp > 0;
    }

    public double speed(Tile targetTile) {
        double s = 1.0 * (double)this.hp / (double)this.type.maxHP;
        if (this.carrying != null) {
            s *= this.type.carrySpeedMult;
        }
        if (targetTile.y < this.currentTile.y) {
            s *= this.type.goingUpSpeedMult;
        }
        if (targetTile.module.fire > 0) {
            s *= this.type.fireSpeedMult;
        }
        return s * this.type.insideSpeed;
    }

    public void sanityCheck(Combat c) {
    }

    private void dropCarried() {
        this.carrying = null;
        if (this.injuredCarried != null) {
            this.injuredCarried.currentTile = this.currentTile;
            this.injuredCarried.msSinceMoved = 0;
            this.injuredCarried = null;
        }
    }

    public void abandonJob(String cause) {
        this.target = null;
        this.headingFor = null;
        this.job = null;
        this.dropCarried();
    }

    private void animTick(int ms, Combat c) {
        double ty;
        double tx;
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        boolean flipped = false;
        if (sh != null) {
            tx = sh.getX() + (double)(sh.gridXToWorldX(this.currentTile.x, 1) * 16);
            ty = sh.getY() + (double)(this.currentTile.y * 16);
            Tile t2 = this.movingTowards;
            if (t2 != null) {
                tx = sh.flipped ? (tx -= (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0) : (tx += (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0);
                ty += (double)(t2.y - this.currentTile.y) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0;
            }
            tx += 8.0 - this.getBBWidth() / 2.0;
            ty += 15.0 - this.getBBHeight();
            flipped = sh.flipped;
        } else {
            tx = this.getX();
            ty = this.getY();
        }
        this.anim.tick(ms, c, tx, ty, flipped);
    }

    public void tick(int ms, Combat c, Combat.Side shipSide, boolean won, boolean lost, boolean onViewingSide, boolean canDoPathing) {
        this.animTick(ms, c);
        if (this.ship != null && this.crewTick(ms, c, shipSide, won, lost, onViewingSide, canDoPathing)) {
            return;
        }
        if (this.boardingShip != null && this.boarderTick(ms, c, shipSide, won, lost, canDoPathing)) {
            return;
        }
        this.shoot(c, ms, onViewingSide);
        if (this.oldHP >= this.type.minWorkingHP && this.hp < this.type.minWorkingHP) {
            this.anim.animate(AnimationType.COLLAPSE, null);
        } else if (this.active()) {
            if (!this.occupied && this.ship != null && this.anim.specialDuration <= 0 && won) {
                this.anim.animate(AnimationType.HAPPY, null);
            }
            if (!this.occupied && this.ship != null && this.anim.specialDuration <= 0 && lost) {
                this.anim.animate(AnimationType.SAD, null);
            }
        }
        this.oldHP = this.hp;
    }

    public void shoot(Combat c, int ms, boolean onViewingSide) {
        this.weaponReload -= ms;
        if (!this.active() || this.weaponReload > 0) {
            return;
        }
        if (!this.type.canBoard && this.ship == null) {
            return;
        }
        boolean interesting = this.interesting(this.currentTile.module);
        if (this.shootTarget != null) {
            if (this.ship != null) {
                if (!this.shootTarget.active() || this.shootTarget.currentTile == null || this.shootTarget.currentTile.module != this.currentTile.module || !this.ship.boarders.contains(this.shootTarget)) {
                    this.shootTarget = null;
                    this.shootAccumulator = 0;
                    this.anim.stopAnimating();
                }
            } else if (!(this.boardingShip == null || this.shootTarget.active() && this.shootTarget.currentTile != null && this.shootTarget.currentTile.module == this.currentTile.module && this.boardingShip.crew.contains(this.shootTarget))) {
                this.shootTarget = null;
                this.shootAccumulator = 0;
                this.anim.stopAnimating();
            }
        }
        if (this.shootTarget == null) {
            Crewman victim = null;
            if (this.ship != null) {
                int bsz = this.ship.boarders.size();
                for (int bi = 0; bi < bsz; ++bi) {
                    Crewman b = this.ship.boarders.get(bi);
                    if (!b.active() || b.currentTile.module != this.currentTile.module || !interesting && !b.type.canBoard && !b.type.doesGuard && b.hp >= this.type.maxHP || this.type.meleeAttack && !Crewman.meleeAdjacent(this.currentTile, b.currentTile)) continue;
                    victim = b;
                    break;
                }
            }
            if (this.boardingShip != null) {
                int csz = this.boardingShip.crew.size();
                for (int ci = 0; ci < csz; ++ci) {
                    Crewman cm = this.boardingShip.crew.get(ci);
                    if (!cm.active() || cm.currentTile.module != this.currentTile.module || (this.type.doesWork || this.boardingShip.captured) && !interesting && !cm.type.canBoard && !cm.type.doesGuard || this.type.meleeAttack && !Crewman.meleeAdjacent(this.currentTile, cm.currentTile)) continue;
                    victim = cm;
                    break;
                }
            }
            if (victim == null) {
                return;
            }
            this.shootTarget = victim;
            this.shootAccumulator = 0;
        }
        if (this.shootTarget == null) {
            this.shootAccumulator = 0;
            return;
        }
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        this.anim.continueAnimating(this.shootTarget.currentTile.x > this.currentTile.x != sh.flipped ? AnimationType.SHOOT_RIGHT : AnimationType.SHOOT_LEFT, null);
        this.shootAccumulator += ms;
        if (this.shootAccumulator >= this.type.aimTime) {
            Tile t2;
            double sx = sh.getX() + (double)(sh.gridXToWorldX(this.currentTile.x, 1) * 16) + this.getBBWidth() / 2.0;
            double sy = sh.getY() + (double)(this.currentTile.y * 16) + (double)this.type.barrelY;
            if (this.type.attackSnd != null) {
                c.play(this.type.attackSnd, sx, sy, 0.0, 0.0, onViewingSide);
            }
            if ((t2 = this.movingTowards) != null) {
                sx = sh.flipped ? (sx -= (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0) : (sx += (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0);
                sy += (double)(t2.y - this.currentTile.y) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0;
            }
            double tx = sh.getX() + (double)(sh.gridXToWorldX(this.shootTarget.currentTile.x, 1) * 16) + 8.0;
            double ty = sh.getY() + (double)(this.shootTarget.currentTile.y * 16) + 8.0;
            sx += tx < sx ? this.getBBWidth() - (double)this.type.barrelX : (double)this.type.barrelX;
            if (this.type.attackParticle != null) {
                c.particles.add(new Particle(this.type.attackParticle, sx, sy));
            }
            c.shots.add(new Shot(sh, tx, ty, this.type, sx, sy, true, this.ship != null));
            c.msSinceShotFired = 0;
            this.weaponReload = this.weaponReload(c);
            this.shootAccumulator = 0;
            this.anim.continueAnimating(this.shootTarget.currentTile.x > this.currentTile.x != sh.flipped ? AnimationType.SHOOT_RIGHT : AnimationType.SHOOT_LEFT, null);
        }
    }

    public int weaponReload(Combat c) {
        Combat.Side mySide = c.sideOf(this.boardingShip == null ? this.ship : this.boardingShip);
        int rel = this.type.weaponReload.get(mySide == null ? new BonusSet() : mySide.bonuses);
        if (this.ship != null) {
            rel = (int)((double)rel * 0.75);
        }
        return rel;
    }

    public boolean interesting(Module m) {
        Airship sh;
        if (m == null) {
            return false;
        }
        Airship airship = sh = this.ship == null ? this.boardingShip : this.ship;
        if (m.type.isWeapon() || m.type.getCommand(sh.currentBonuses) > 0 || m.type.getPropulsion(sh.currentBonuses) > 0.0) {
            int csz = sh.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = sh.crew.get(ci);
                if (!cm.active() || cm.currentTile.module != m) continue;
                return true;
            }
        } else {
            int csz = sh.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = sh.crew.get(ci);
                if (!cm.type.canBoard && !cm.type.doesGuard || !cm.active() || cm.currentTile.module != m) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean meleeAdjacent(Tile a, Tile b) {
        return a.module == b.module && a.y == b.y && StrictMath.abs(a.x - b.x) < 2;
    }

    private void planBoardingShipExit(Combat c, Combat.Side shipSide) {
        Airship closest = null;
        double bestd2 = 0.0;
        for (Airship s : shipSide.ships) {
            if (s == this.boardingShip || !s.inCombat(c)) continue;
            double d2 = (this.boardingShip.getX() + this.boardingShip.getBBWidth() / 2.0 - s.getX() - s.getBBWidth() / 2.0) * (this.boardingShip.getX() + this.boardingShip.getBBWidth() / 2.0 - s.getX() - s.getBBWidth() / 2.0) + (this.boardingShip.getY() + this.boardingShip.getBBHeight() / 2.0 - s.getY() - s.getBBHeight() / 2.0) * (this.boardingShip.getY() + this.boardingShip.getBBHeight() / 2.0 - s.getY() - s.getBBHeight() / 2.0);
            if (closest != null && !(d2 < bestd2)) continue;
            closest = s;
            bestd2 = d2;
        }
        if (closest != null) {
            this.ultimateBoardTarget = closest;
        }
    }

    public boolean boarderTick(int ms, Combat c, Combat.Side shipSide, boolean won, boolean lost, boolean canDoPathing) {
        if (!this.type.canBoard) {
            return false;
        }
        this.boarderShout(ms, c);
        if (!this.active()) {
            return false;
        }
        if (this.ultimateBoardTarget != null && this.ultimateBoardTarget != this.boardingShip) {
            ArrayList<Tile> path;
            if (this.currentTile.enterable()) {
                if (this.canPopOut()) {
                    this.popOut(c.otherSide(c.sideOf(this.boardingShip)), c);
                    return true;
                }
                return false;
            }
            if (!(this.boardExitTarget == null || this.boardExitTarget.enterable() && this.boardingShip.containsTile(this.boardExitTarget))) {
                this.boardExitTarget = null;
            }
            if (this.boardExitTarget == null) {
                int tsz = this.boardingShip.tiles.size();
                int closestDist = 0;
                for (int ti = 0; ti < tsz; ++ti) {
                    ArrayList<Tile> path2;
                    Tile t = this.boardingShip.tiles.get(ti);
                    if (!t.enterable() || (path2 = this.boardingShip.getPath(this.currentTile, t)) == null || this.boardExitTarget != null && path2.size() >= closestDist) continue;
                    this.boardExitTarget = t;
                    closestDist = path2.size();
                }
            }
            if (this.boardExitTarget != null && (path = this.boardingShip.getPath(this.currentTile, this.boardExitTarget)) != null) {
                this.targetTile = path.get(0);
                this.msSinceMoved += ms;
            }
        } else if (this.type.meleeAttack) {
            ArrayList<Tile> path;
            int best;
            Crewman cm;
            int ci;
            int csz;
            this.target = null;
            if (this.meleeTargetTile != null) {
                if (!this.interesting(this.meleeTargetTile.module)) {
                    this.meleeTargetTile = null;
                    this.targetTile = null;
                } else {
                    boolean found = false;
                    csz = this.boardingShip.crew.size();
                    for (ci = 0; ci < csz; ++ci) {
                        cm = this.boardingShip.crew.get(ci);
                        if (!cm.active() || this.type.doesWork && !cm.type.doesGuard && !cm.type.canBoard && cm.hp >= cm.type.maxHP || !Crewman.meleeAdjacent(cm.currentTile, this.meleeTargetTile)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.targetTile = null;
                        this.meleeTargetTile = null;
                    }
                }
            }
            if (this.meleeTargetTile == null) {
                best = 0;
                csz = this.boardingShip.crew.size();
                for (ci = 0; ci < csz; ++ci) {
                    cm = this.boardingShip.crew.get(ci);
                    if (!cm.active() || !this.interesting(cm.currentTile.module)) continue;
                    for (int xx = -1; xx < 2; ++xx) {
                        ArrayList<Tile> path3;
                        Tile tt = this.boardingShip.tileAt(cm.currentTile.x + xx, cm.currentTile.y);
                        if (tt == null || tt.module != cm.currentTile.module || (path3 = this.boardingShip.getPath(this.currentTile, tt)) == null) continue;
                        int dist = path3.size();
                        int bsz = this.boardingShip.boarders.size();
                        for (int bi = 0; bi < bsz; ++bi) {
                            Crewman b = this.boardingShip.boarders.get(bi);
                            if ((b == this || b.meleeTargetTile == null || b.meleeTargetTile.module != tt.module) && (b.target == null || b.target != tt.module)) continue;
                            dist *= 4;
                            break;
                        }
                        if (this.meleeTargetTile != null && dist >= best) continue;
                        this.meleeTargetTile = tt;
                        this.targetTile = path3.isEmpty() ? tt : path3.get(0);
                        best = dist;
                    }
                }
            }
            if (this.meleeTargetTile == null) {
                best = 0;
                int msz = this.boardingShip.modules.size();
                for (int mi = 0; mi < msz; ++mi) {
                    ArrayList<Tile> path4;
                    Module m = this.boardingShip.modules.get(mi);
                    if (m.type.getCommand(this.boardingShip.currentBonuses) <= 0 || m.hp <= 0 || (path4 = this.boardingShip.getPath(this.currentTile, m)) == null || this.target != null && best <= path4.size()) continue;
                    this.target = m;
                    best = path4.size();
                }
                this.targetTile = null;
                if (this.target != null && this.currentTile.module != this.target) {
                    ArrayList<Tile> path5 = this.boardingShip.getPath(this.currentTile, this.target);
                    if (path5 == null) {
                        this.targetTile = null;
                        this.meleeTargetTile = null;
                    } else {
                        this.targetTile = path5.get(0);
                        this.meleeTargetTile = path5.get(path5.size() - 1);
                    }
                }
                this.target = null;
            } else if (this.currentTile != this.meleeTargetTile && this.currentTile == this.targetTile && (path = this.boardingShip.getPath(this.currentTile, this.meleeTargetTile)) != null && !path.isEmpty()) {
                this.targetTile = path.get(0);
            }
            if (this.targetTile == null && !this.type.doesWork) {
                this.planBoardingShipExit(c, shipSide);
            }
        } else {
            Module m;
            Crewman cm;
            int ci;
            int best;
            int csz;
            ArrayList<Tile> path;
            Module m2;
            int mi;
            int msz;
            int best2;
            if (this.interesting(this.currentTile.module)) {
                this.target = null;
            } else if (!this.interesting(this.target)) {
                this.target = null;
                best2 = 0;
                msz = this.boardingShip.modules.size();
                for (mi = 0; mi < msz; ++mi) {
                    m2 = this.boardingShip.modules.get(mi);
                    if (!this.interesting(m2) || (path = this.boardingShip.getPath(this.currentTile, m2)) == null) continue;
                    int dist = path.size();
                    int bsz = this.boardingShip.boarders.size();
                    for (int bi = 0; bi < bsz; ++bi) {
                        Crewman b = this.boardingShip.boarders.get(bi);
                        if (b == this || b.target != m2) continue;
                        dist *= 2;
                        break;
                    }
                    if (this.target != null && best2 <= dist) continue;
                    this.target = m2;
                    best2 = dist;
                }
            }
            if (this.target == null && this.type.doesWork) {
                best2 = 0;
                msz = this.boardingShip.modules.size();
                for (mi = 0; mi < msz; ++mi) {
                    m2 = this.boardingShip.modules.get(mi);
                    if (m2.type.getCommand(this.boardingShip.currentBonuses) <= 0 || m2.hp <= 0 || (path = this.boardingShip.getPath(this.currentTile, m2)) == null || this.target != null && best2 <= path.size()) continue;
                    this.target = m2;
                    best2 = path.size();
                }
            }
            if (this.target == null) {
                csz = this.boardingShip.crew.size();
                best = 0;
                for (ci = 0; ci < csz; ++ci) {
                    ArrayList<Tile> path6;
                    cm = this.boardingShip.crew.get(ci);
                    if (!cm.type.canBoard && !cm.type.doesGuard || !cm.active() || (path6 = this.boardingShip.getPath(this.currentTile, m = cm.currentTile.module)) == null || this.target != null && best <= path6.size()) continue;
                    this.target = m;
                    best = path6.size();
                }
            }
            if (this.target == null) {
                csz = this.boardingShip.crew.size();
                best = 0;
                for (ci = 0; ci < csz; ++ci) {
                    ArrayList<Tile> path7;
                    cm = this.boardingShip.crew.get(ci);
                    if (!cm.active() || (path7 = this.boardingShip.getPath(this.currentTile, m = cm.currentTile.module)) == null || this.target != null && best <= path7.size()) continue;
                    this.target = m;
                    best = path7.size();
                }
            }
            this.targetTile = null;
            if (this.target != null && this.currentTile.module != this.target) {
                ArrayList<Tile> path8 = this.boardingShip.getPath(this.currentTile, this.target);
                if (path8 == null) {
                    this.target = null;
                    this.targetTile = null;
                } else {
                    this.targetTile = path8.get(0);
                }
            }
            if (this.targetTile == null && !this.type.doesWork) {
                this.planBoardingShipExit(c, shipSide);
            }
        }
        if (this.weaponReload > 0) {
            ms = (int)((double)ms * this.type.reloadSlowdown);
        }
        if (this.movingTowards != null && !this.boardingShip.tiles.contains(this.movingTowards)) {
            this.movingTowards = null;
        }
        if (this.targetTile == this.currentTile) {
            this.movingTowards = null;
        } else {
            if (this.targetTile != this.movingTowards) {
                this.msSinceMoved -= 2 * ms;
                if (this.msSinceMoved <= 0) {
                    this.msSinceMoved *= -1;
                    this.movingTowards = this.targetTile;
                }
            } else if (this.shootAccumulator == 0) {
                this.msSinceMoved += ms;
            }
            if (this.movingTowards != null && (double)this.msSinceMoved >= (double)this.currentTile.getMoveDelay() / this.speed(this.movingTowards)) {
                this.msSinceMoved = (int)((double)this.msSinceMoved - (double)this.currentTile.getMoveDelay() / this.speed(this.movingTowards));
                this.currentTile = this.movingTowards;
            }
        }
        return false;
    }

    public boolean crewTick(int ms, Combat c, Combat.Side mySide, boolean won, boolean lost, boolean onViewingSide, boolean canDoPathing) {
        ArrayList<Tile> path;
        if (this.injuredCarried != null) {
            this.injuredCarried.currentTile = this.currentTile;
        }
        double gameX = this.ship.getIntX() + this.ship.gridXToWorldX(this.currentTile.x, 1) * 16 + 8;
        double gameY = this.ship.getIntY() + this.currentTile.y * 16 + 8;
        this.shout(ms, c, won, lost);
        if (this.currentTile.module.fire > 0 && c.r.nextDouble() < (double)this.currentTile.module.fire * this.type.fireHarmPMs * (double)ms && this.hp > 0) {
            this.hp = StrictMath.max(0, this.hp - 1);
            if (this.type.coughSnd != null) {
                c.play(this.type.coughSnd, gameX, gameY, 0.0, 0.0, onViewingSide);
            }
        }
        if ((this.currentTile.module.type.necromancy(this.currentTile.module.ship.currentBonuses) || this.alive()) && this.hp < this.type.maxHP) {
            this.hp = StrictMath.max(0, this.hp);
            this.repairMs += ms;
            if (this.currentTile.module.fullyStaffed() && this.currentTile.module.type.getSickbay(this.currentTile.module.ship.currentBonuses) > 0 && c.r.nextDouble() < (double)(this.currentTile.module.type.getSickbay(this.currentTile.module.ship.currentBonuses) * ms) * this.type.sickbayHealPMs || this.type.msPerHPRepaired > 0 && this.repairMs >= this.type.msPerHPRepaired) {
                this.repairMs = 0;
                ParticleType pt = ParticleType.ofName(this.hp == 0 ? "necromancy" : "healing");
                ++this.hp;
                for (int i = 0; i < 5; ++i) {
                    c.particles.add(new Particle(pt, gameX, gameY));
                }
            }
        }
        if (this.alive() && this.type.ammoCapacity > 0 && this.ammo < this.type.ammoCapacity) {
            this.rearmAccumulator += ms;
            if (this.rearmAccumulator >= this.type.rearmTime) {
                this.ammo = this.type.ammoCapacity;
                this.rearmAccumulator = 0;
            }
        }
        this.giveResourceWait -= ms;
        if (this.giveResourceWait > 0) {
            return false;
        }
        if (this.job != null) {
            if (!this.ship.containsModule(this.job.module()) || !this.active() || !this.job.active() || this.headingFor != null && !this.headingFor.alive()) {
                this.abandonJob("module " + this.ship.containsModule(this.job.module()) + " active " + this.active() + " jobactive " + this.job.active() + " headingForDead " + (this.headingFor != null && !this.headingFor.alive()));
                return false;
            }
            if (this.job.resource() != null || this.currentTile.module != this.job.module()) {
                this.msSinceMoved += ms;
            }
            if (this.job.resource() != null && this.job.resource() != this.carrying && this.job.resource() != Resource.INJURED) {
                int closest = 0;
                Module best = null;
                int msz = this.ship.modules.size();
                for (int mi = 0; mi < msz; ++mi) {
                    ArrayList<Tile> modulePath;
                    Module m = this.ship.modules.get(mi);
                    if (m.getResource(this.job.resource()) <= 0 || !this.ship.hasPath(this.currentTile, m) && !canDoPathing || (path = this.ship.getPath(this.currentTile, m)) == null || !this.ship.hasPath(path.isEmpty() ? this.currentTile : path.get(path.size() - 1), this.job.module()) && !canDoPathing || (modulePath = this.ship.getPath(path.isEmpty() ? this.currentTile : path.get(path.size() - 1), this.job.module())) == null) continue;
                    int d = path.size() + modulePath.size();
                    if (best != null && d >= closest) continue;
                    best = m;
                    closest = d;
                }
                this.target = best;
                if (this.target == null && !canDoPathing) {
                    return false;
                }
            } else {
                this.target = null;
            }
            if (this.job.resource() == null || this.job.resource() == this.carrying) {
                this.target = this.job.module();
            }
        }
        if (this.job == null) {
            this.abandonJob("no job");
        }
        if (this.target != null && !this.ship.containsModule(this.target) || this.headingFor != null && !this.ship.containsTile(this.headingFor.currentTile)) {
            this.abandonJob("target not in ship");
        }
        Tile targetTile = null;
        if (this.ultimateBoardTarget != null && this.ultimateBoardTarget != this.ship || (this.type.shootsShips || this.type.interceptTroops) && (this.hp == this.type.maxHP || this.type.msPerHPRepaired == 0) && this.ammo == this.type.ammoCapacity) {
            ArrayList<Tile> path2;
            if (this.currentTile.enterable() || !this.type.canWalk) {
                if (this.canPopOut()) {
                    this.popOut(mySide, c);
                    return true;
                }
                return false;
            }
            if (!(this.boardExitTarget == null || this.boardExitTarget.enterable() && this.ship.containsTile(this.boardExitTarget))) {
                if (this.boardExitTarget == this.ship.boardExitTargetCache) {
                    this.ship.boardExitTargetCache = null;
                }
                this.boardExitTarget = null;
            }
            if (this.boardExitTarget == null && this.ship.boardExitTargetCache != null) {
                if (this.ship.boardExitTargetCache.enterable() && this.ship.containsTile(this.ship.boardExitTargetCache)) {
                    this.boardExitTarget = this.ship.boardExitTargetCache;
                } else {
                    this.ship.boardExitTargetCache = null;
                }
            }
            if (this.boardExitTarget == null) {
                int tsz = this.ship.tiles.size();
                int closestDist = 0;
                for (int ti = 0; ti < tsz; ++ti) {
                    Tile t = this.ship.tiles.get(ti);
                    if (!t.enterable() || !canDoPathing && !this.ship.hasPath(this.currentTile, t) || (path = this.ship.getPath(this.currentTile, t)) == null || this.boardExitTarget != null && path.size() >= closestDist) continue;
                    this.boardExitTarget = t;
                    this.ship.boardExitTargetCache = t;
                    closestDist = path.size();
                }
            }
            if (this.boardExitTarget != null && (canDoPathing || this.ship.hasPath(this.currentTile, this.boardExitTarget)) && (path2 = this.ship.getPath(this.currentTile, this.boardExitTarget)) != null) {
                targetTile = path2.get(0);
                this.msSinceMoved += ms;
            }
        } else if (this.target != null && this.currentTile.module != this.target) {
            if (!canDoPathing && !this.ship.hasPath(this.currentTile, this.target)) {
                return false;
            }
            ArrayList<Tile> path3 = this.ship.getPath(this.currentTile, this.target);
            if (path3 == null) {
                this.abandonJob("no path to target");
            } else if (path3.isEmpty()) {
                String shipJSON = null;
                try {
                    shipJSON = this.ship.toJSON(null).toString(4);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                AirshipGame.instance.reportError("empty path: tile in " + this.currentTile.module.type.name + "#" + this.ship.modules.indexOf(this.currentTile.module) + " at " + this.currentTile.x + " " + this.currentTile.y + " pathing to " + this.target.type.name + "#" + this.ship.modules.indexOf(this.target) + " at " + this.target.x + " " + this.target.y, null, shipJSON, false, true);
                this.abandonJob("pathing to target broken");
            } else {
                targetTile = path3.get(0);
            }
        }
        if (this.headingFor != null && this.currentTile != this.headingFor.currentTile) {
            if (!canDoPathing && !this.ship.hasPath(this.currentTile, this.headingFor.currentTile)) {
                return false;
            }
            ArrayList<Tile> pathTo = this.ship.getPath(this.currentTile, this.headingFor.currentTile);
            if (pathTo == null) {
                this.abandonJob("no path to crewman");
            } else {
                targetTile = pathTo.get(0);
            }
        }
        if (this.weaponReload > 0) {
            ms = (int)((double)ms * this.type.reloadSlowdown);
        }
        if (this.movingTowards != null && !this.ship.tiles.contains(this.movingTowards)) {
            this.movingTowards = null;
        }
        if (this.type.canWalk) {
            if (targetTile != this.movingTowards && this.shootAccumulator == 0) {
                this.msSinceMoved -= 2 * ms;
                if (this.msSinceMoved <= 0) {
                    this.msSinceMoved *= -1;
                    this.movingTowards = targetTile;
                }
            }
            if (this.movingTowards != null && (double)this.msSinceMoved >= (double)this.currentTile.getMoveDelay() / this.speed(this.movingTowards)) {
                this.msSinceMoved = (int)((double)this.msSinceMoved - (double)this.currentTile.getMoveDelay() / this.speed(this.movingTowards));
                this.currentTile = this.movingTowards;
            }
        }
        if (this.job != null) {
            if (this.job.resource() != null && this.carrying != this.job.resource() && this.currentTile.module.getResource(this.job.resource()) > 0 && this.msSinceMoved >= this.pickupCost()) {
                this.msSinceMoved -= this.pickupCost();
                this.currentTile.module.takeResource(this.job.resource());
                int cap = this.ship.getTotalResourceCapacity(this.job.resource());
                int left = this.ship.getTotalResource(this.job.resource());
                if (left == 0) {
                    this.doShout(this.pickShout("outOf" + this.job.resource().name()));
                } else if ((double)left < 0.05 * (double)cap) {
                    this.doShout(this.pickShout("veryLow" + this.job.resource().name()));
                } else if ((double)left < 0.2 * (double)cap) {
                    this.doShout(this.pickShout("low" + this.job.resource().name()));
                }
                this.dropCarried();
                this.carrying = this.job.resource();
            }
            if (this.job.resource() == Resource.INJURED && this.headingFor != null && this.headingFor.currentTile == this.currentTile && this.msSinceMoved >= this.pickupCost()) {
                this.dropCarried();
                this.msSinceMoved -= this.pickupCost();
                this.carrying = Resource.INJURED;
                this.injuredCarried = this.headingFor;
                this.injuredCarried.abandonJob("picked up");
                this.headingFor = null;
            }
            if (this.job.resource() != null && this.job.resource() == this.carrying && this.currentTile.module == this.job.module()) {
                boolean repairing = this.carrying == Resource.REPAIR && this.currentTile.module.hp <= 0 && this.currentTile.module.type != ModuleType.ofName("CORRIDOR");
                this.currentTile.module.giveResource(this.carrying, c, onViewingSide);
                if (repairing && this.currentTile.module.hp > 0) {
                    this.shout("repaired");
                }
                this.giveResourceWait = this.giveCost();
                if (this.carrying == Resource.REPAIR) {
                    this.anim.animate(AnimationType.REPAIR, null);
                } else {
                    this.anim.animate(this.anim.lastFlipped ? AnimationType.GIVE_LEFT : AnimationType.GIVE_RIGHT, this.injuredCarried == null ? this.carrying : Resource.INJURED);
                }
                if (this.carrying == Resource.WATER) {
                    double mx = this.ship.getX() + (double)(this.ship.gridXToWorldX(this.currentTile.module.x, this.currentTile.module.type.getW()) * 16) + (double)(this.currentTile.module.type.getW() * 16 / 2);
                    double my = this.ship.getY() + (double)(this.currentTile.module.y * 16) + (double)(this.currentTile.module.type.getH() * 16 / 2);
                    for (int i = 0; i < 16; ++i) {
                        c.particles.add(new Particle(ParticleType.ofName("water"), mx, my));
                    }
                }
                this.abandonJob("drop off injured crewman");
            }
        }
        this.sanityCheck(c);
        return false;
    }

    private int giveCost() {
        if (this.carrying == Resource.REPAIR) {
            return this.type.repairTime;
        }
        return 500;
    }

    private int pickupCost() {
        int c = this.type.pickupMs;
        if (this.currentTile.module.fire > 0) {
            c = (int)((double)c * this.type.pickupFireMult);
        }
        c = (int)((double)c * (1.0 + (double)(this.currentTile.module.getMaxHP() - this.currentTile.module.hp) * this.type.pickupDmgMaxMalus / (double)this.currentTile.module.getMaxHP()));
        return c;
    }

    public void simpleDraw(Draw d, double tx, double ty, int ms, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientTint, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, float[][] coaColors) {
        if (this.beingCarried()) {
            return;
        }
        float[] srcA = this.type.recolorOriginalA;
        float[] srcB = this.type.recolorOriginalB;
        float[] trgA = coaColors == null ? srcA : coaColors[this.type.recolorReplacementA.armsColorIndex];
        float[] trgB = coaColors == null ? srcB : coaColors[this.type.recolorReplacementB.armsColorIndex];
        Img img = this.type.simpleLook;
        if (ssb != null && !img.src.equals(ssb.name)) {
            if (additionalSSBs != null && Loadable.hasOfName(SpritesheetBundle.class, img.src)) {
                additionalSSBs.add(SpritesheetBundle.ofName(img.src));
            }
            return;
        }
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        Tile t2 = this.movingTowards;
        if (t2 != null) {
            tx = sh.flipped ? (tx -= (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0) : (tx += (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0);
            ty += (double)(t2.y - this.currentTile.y) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0;
        }
        RotatingColoringShader.draw(SpritesheetBundle.ofName(img.src), img, d, tx += (double)(8 - img.srcWidth / 2), ty += (double)(16 - img.srcHeight), 0.0, 1.0, false, light, lightStrength, ambient, ambientSaturation, ambientTint, srcA, trgA, srcB, trgB);
    }

    public void draw(Draw d, double tx, double ty, int ms, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientTint, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, float[][] coaColors) {
        if (this.beingCarried()) {
            return;
        }
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        Tile t2 = this.movingTowards;
        if (t2 != null) {
            tx = sh.flipped ? (tx -= (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0) : (tx += (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0);
            ty += (double)(t2.y - this.currentTile.y) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0;
        }
        this.anim.draw(d, tx + 8.0 - this.getBBWidth() / 2.0, ty + 16.0 - 1.0 - this.getBBHeight(), sh.flipped, light, lightStrength, ambient, ambientSaturation, ambientTint, ssb, additionalSSBs, coaColors);
    }

    public boolean isOutside() {
        return this.ship == null && this.boardingShip == null;
    }

    public boolean canPopOut() {
        return (this.currentTile.enterable() || !this.type.canWalk) && (this.ship != null && this.ship.popOutCooldown <= 0 || this.boardingShip != null && this.boardingShip.popOutCooldown <= 0);
    }

    public void popOut(Combat.Side mySide, Combat c) {
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        Tile t2 = this.movingTowards;
        this.setX(sh.getX() + (double)(sh.gridXToWorldX(this.currentTile.x, 1) * 16) + 8.0);
        this.setY(sh.getY() + (double)(this.currentTile.y * 16) + 16.0 - this.getBBHeight());
        if (t2 != null) {
            int moveDelay = this.currentTile.getMoveDelay();
            double speed = this.speed(t2);
            double shift = (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)moveDelay * speed * 16.0;
            if (moveDelay == 0 || Double.isInfinite(speed) || Double.isNaN(speed) || Double.isInfinite(shift) || Double.isNaN(shift)) {
                AirshipGame.instance.reportError("Bad popOut: speed " + speed + ", moveDelay " + moveDelay + ", shift " + shift + ", type " + this.type.name + ", currentTileIndex" + sh.tiles.indexOf(this.currentTile) + ", currentTileMT " + this.currentTile.module.type.name + ", t2Index" + sh.tiles.indexOf(t2) + ", t2MT " + t2.module.type.name, null, this.ship.toJSON(null).toString(), false, true);
            } else {
                if (sh.flipped) {
                    this.setX(this.getX() - shift);
                } else {
                    this.setX(this.getX() + shift);
                }
                this.setY(this.getY() + (double)(t2.y - this.currentTile.y) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0);
            }
        }
        int delay = this.type.popOutDelayMin;
        if (this.type.popOutDelayRange > 0) {
            delay += c.r.nextInt(this.type.popOutDelayRange);
        }
        sh.popOutCooldown = delay;
        sh.crew.remove(this);
        sh.boarders.remove(this);
        this.homeTile = this.currentTile;
        this.currentTile = null;
        this.movingTowards = null;
        this.attachedTo = sh;
        this.ship = null;
        this.boardingShip = null;
        mySide.troops.add(this);
        this.msUntilRecalcJumpPoint = c.r.nextInt(300);
        if (this.type.canFly) {
            this.attachedTo = null;
            this.mvDx = 0.0;
            this.mvDy = 0.0;
            this.trackingDx = 0.0;
            this.trackingDx = this.dx = (this.type.launchMinXSpeed + c.r.nextDouble() * (this.type.launchMaxXSpeed - this.type.launchMinXSpeed)) * (double)(sh.flipped ? -1 : 1);
            this.dy = this.type.launchMinYSpeed + c.r.nextDouble() * (this.type.launchMaxYSpeed - this.type.launchMinYSpeed);
            this.timeSinceLaunch = 0;
            if (this.type.launchSnd != null) {
                c.play(this.type.launchSnd, this.getX(), this.getY(), this.dx, this.dy, false);
            }
        }
    }

    public boolean canPopIn(Airship target) {
        return this.popInTile(target) != null;
    }

    public Tile popInTile(Airship target) {
        if (!Rect2D.intersects(this.getX(), this.getY(), this.getBBWidth(), this.getBBHeight(), target.getX(), target.getY(), target.getBBWidth(), target.getBBHeight())) {
            return null;
        }
        for (int yOffset = 0; yOffset < 2; ++yOffset) {
            for (int xOffset = 0; xOffset < 2; ++xOffset) {
                double ox = this.getX() + this.getBBWidth() * (double)xOffset - target.getX();
                double oy = this.getY() + this.getBBHeight() * (double)yOffset - target.getY();
                int tgx = target.flipped ? (int)(target.getBBWidth() - ox) / 16 : (int)(ox / 16.0);
                tgx = StrictMath.min(target.getWidth() - 1, StrictMath.max(0, tgx));
                int tgy = StrictMath.min(target.getHeight() - 1, StrictMath.max(0, (int)(oy / 16.0)));
                Tile t = target.tileAt(tgx, tgy);
                if (!(this.type.canWalk ? t != null && t.canOccupy && t.enterable() : t != null && t == this.homeTile)) continue;
                return t;
            }
        }
        return null;
    }

    public boolean popIn(Airship target, boolean asBoarder, Combat c) {
        Tile t = this.popInTile(target);
        if (t == null) {
            return false;
        }
        if (asBoarder) {
            this.boardingShip = target;
            if (target.boarders.isEmpty()) {
                c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("boardingWith " + this.type.name, c.otherSide(c.sideOf(target)), this.getX(), this.getY(), this.type, this.boardingShip));
                c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("boardedBy " + this.type.name, c.sideOf(target), this.getX(), this.getY(), this.type, this.boardingShip));
            }
            target.boarders.add(this);
        } else {
            this.ship = target;
            target.crew.add(this);
        }
        this.currentTile = t;
        this.attachedTo = null;
        this.ignoring = null;
        this.ultimateBoardTarget = null;
        this.proximateBoardTarget = null;
        return true;
    }

    public void drop() {
        this.ignoring = this.attachedTo;
        this.attachedTo = null;
    }

    public void jump(double angle, double speed) {
        this.drop();
        this.dx += StrictMath.cos(angle) * speed;
        this.dy -= StrictMath.sin(angle) * speed;
        this.mvDx = 0.0;
        this.mvDy = 0.0;
    }

    public GridRef findJumpPoint(Combat.Side side, boolean jumpDownOnly) {
        double angle;
        double ty;
        double tx;
        if (!(this.attachedTo instanceof GridBody)) {
            return null;
        }
        GridBody att = (GridBody)this.attachedTo;
        if (att instanceof LandFormation && att.isImmobile()) {
            return null;
        }
        double[] angleAndStrengthRef = new double[2];
        if (jumpDownOnly) {
            if (att.fallPointCacheTarget == this.proximateBoardTarget && att.fallPointCache != null && att.fallPointCache.solid()) {
                tx = att.getX() + (double)(att.fallPointCache.gridX * 16);
                ty = att.getY() + (double)(att.fallPointCache.gridY * 16) - this.getBBHeight() + 0.5;
                this.findJumpAngleAndStrength(tx, ty, null, angleAndStrengthRef);
                angle = angleAndStrengthRef[0];
                if (angle == 128.0) {
                    return att.fallPointCache;
                }
            }
        } else if (att.jumpPointCacheTarget == this.proximateBoardTarget && att.jumpPointCache != null && att.jumpPointCache.solid()) {
            tx = att.getX() + (double)(att.jumpPointCache.gridX * 16);
            ty = att.getY() + (double)(att.jumpPointCache.gridY * 16) - this.getBBHeight() + 0.5;
            this.findJumpAngleAndStrength(tx, ty, null, angleAndStrengthRef);
            angle = angleAndStrengthRef[0];
            if (!Double.isNaN(angle)) {
                return att.jumpPointCache;
            }
        }
        GridRef best = null;
        double shortestDsq = 0.0;
        for (int tgy = 0; tgy < att.getGridHeight(); ++tgy) {
            for (int tgx = 0; tgx < att.getGridWidth(); ++tgx) {
                if (!att.solidAt(tgx, tgy)) continue;
                double tx2 = att.getX() + (double)(tgx * 16);
                double ty2 = att.getY() + (double)(tgy * 16) - this.getBBHeight() + 0.5;
                this.findJumpAngleAndStrength(tx2, ty2, null, angleAndStrengthRef);
                double angle2 = angleAndStrengthRef[0];
                if (!(jumpDownOnly ? angle2 == 128.0 : !Double.isNaN(angle2))) continue;
                double dsq = (tx2 - this.getX()) * (tx2 - this.getX()) + (ty2 - this.getY()) * (ty2 - this.getY());
                if (best != null && !(dsq < shortestDsq)) continue;
                best = new GridRef(tgx, tgy, att);
                shortestDsq = dsq;
            }
        }
        if (jumpDownOnly) {
            att.fallPointCache = best;
            att.fallPointCacheTarget = this.proximateBoardTarget;
        } else {
            att.jumpPointCache = best;
            att.jumpPointCacheTarget = this.proximateBoardTarget;
        }
        return best;
    }

    public void findJumpAngleAndStrength(double sourceX, double sourceY, GridRef[] tt, double[] angleAndStrengthRef) {
        angleAndStrengthRef[0] = Double.NaN;
        int jsi = 0;
        while ((double)jsi < StrictMath.ceil(this.type.jumpStrength / 0.1)) {
            double jumpStrength;
            angleAndStrengthRef[1] = jumpStrength = StrictMath.min(this.type.jumpStrength, 0.1 + (double)jsi * 0.1);
            angleAndStrengthRef[0] = this.findJumpAngle(sourceX, sourceY, tt, jumpStrength);
            if (!Double.isNaN(angleAndStrengthRef[0])) {
                return;
            }
            ++jsi;
        }
    }

    public double findJumpAngle(double sourceX, double sourceY, GridRef[] tt, double jumpStrength) {
        int bw = this.proximateBoardTarget.getGridWidth();
        int bh = this.proximateBoardTarget.getGridHeight();
        double bestAngle = Double.NaN;
        for (int borderIndex = 0; borderIndex < bw + bh; ++borderIndex) {
            double angle;
            int tgy;
            int tgx;
            int n = borderIndex < bw ? borderIndex : (tgx = sourceX < this.proximateBoardTarget.getX() ? 0 : bw - 1);
            int n2 = borderIndex < bw ? (sourceY < this.proximateBoardTarget.getY() + this.proximateBoardTarget.getBBHeight() ? this.proximateBoardTarget.firstSolidBlockYAt(tgx) : bh - 1) : (tgy = borderIndex - bw);
            if (!this.proximateBoardTarget.solidAt(tgx, tgy) || Double.isNaN(angle = Crewman.findJumpAngle(sourceX, sourceY, this.proximateBoardTarget.getX() + (double)(tgx * 16), this.proximateBoardTarget.getY() + (double)(tgy * 16) - this.getBBHeight() + 0.5, jumpStrength))) continue;
            if (tt != null) {
                tt[0] = new GridRef(tgx, tgy, this.proximateBoardTarget);
            }
            bestAngle = angle;
            if (angle != 128.0) continue;
            return angle;
        }
        return bestAngle;
    }

    public GridRef findHookPoint(Combat.Side side) {
        if (!(this.attachedTo instanceof GridBody)) {
            return null;
        }
        GridBody att = (GridBody)this.attachedTo;
        GridRef best = null;
        double shortestDsq = 0.0;
        for (int tgy = 0; tgy < att.getGridHeight(); ++tgy) {
            block1: for (int tgx = 0; tgx < att.getGridWidth(); ++tgx) {
                double ty;
                double tx;
                int quality;
                if (!att.solidAt(tgx, tgy) || (quality = this.canHookFrom(tx = this.attachedTo.getX() + (double)(tgx * 16), ty = this.attachedTo.getY() + (double)(tgy * 16) - this.getBBHeight() + 0.5)) <= 0) continue;
                int csz = side.troops.size();
                for (int ci = 0; ci < csz; ++ci) {
                    GridRef jsgr = side.troops.get((int)ci).jumpSourceGR;
                    if (jsgr != null && jsgr.gridX == tgx && jsgr.gridY == tgy) continue block1;
                }
                double dsq = (tx - this.getX()) * (tx - this.getX()) + (ty - this.getY()) * (ty - this.getY());
                dsq /= (double)(quality * quality);
                if (best != null && !(dsq < shortestDsq)) continue;
                best = new GridRef(tgx, tgy, att);
                shortestDsq = dsq;
            }
        }
        return best;
    }

    public Utils.Pair<Pt, GridRef> findHookTarget(double sourceX, double sourceY, Combat.Side side) {
        int bw = this.proximateBoardTarget.getGridWidth();
        int bh = this.proximateBoardTarget.getGridHeight();
        boolean bestEnterable = false;
        Pt bestPt = null;
        GridRef targetGR = null;
        double bestDsq = 0.0;
        block0: for (int borderIndex = 0; borderIndex < bw + bh; ++borderIndex) {
            Tile t;
            GridLocation gl;
            int tgy;
            int tgx;
            int n = borderIndex < bw ? borderIndex : (tgx = sourceX < this.proximateBoardTarget.getX() ? 0 : bw - 1);
            int n2 = borderIndex < bw ? (sourceY < this.proximateBoardTarget.getY() + this.proximateBoardTarget.getBBHeight() ? 0 : bh - 1) : (tgy = borderIndex - bw);
            if (!this.proximateBoardTarget.solidAt(tgx, tgy) || (gl = this.proximateBoardTarget.locationAt(tgx, tgy)) instanceof Tile && !(t = (Tile)gl).full()) continue;
            double tx = this.proximateBoardTarget.getX() + (double)(tgx * 16);
            double ty = this.proximateBoardTarget.getY() + (double)(tgy * 16);
            if (this.attachedTo.isImmobile() && StrictMath.abs(sourceX - tx) > 32.0) continue;
            double dsq = (sourceX - tx) * (sourceX - tx) + (sourceY - ty) * (sourceY - ty);
            boolean enterable = this.proximateBoardTarget.enterableAt(tgx, tgy);
            if (!(dsq < (double)(this.type.hookRopeLength * this.type.hookRopeLength)) || bestPt != null && !(dsq < bestDsq) && (!enterable || bestEnterable)) continue;
            int csz = side.troops.size();
            for (int ci = 0; ci < csz; ++ci) {
                GridRef jsgr = side.troops.get((int)ci).jumpSourceGR;
                if (jsgr != null && jsgr.gridX == tgx && jsgr.gridY == tgy) continue block0;
            }
            bestPt = new Pt(tx + 8.0, ty + 2.0);
            targetGR = new GridRef(tgx, tgy, this.proximateBoardTarget);
            bestEnterable = enterable;
            bestDsq = dsq;
        }
        return bestPt == null ? null : new Utils.Pair(bestPt, targetGR);
    }

    public int canHookFrom(double sourceX, double sourceY) {
        int bw = this.proximateBoardTarget.getGridWidth();
        int bh = this.proximateBoardTarget.getGridHeight();
        boolean found = false;
        for (int borderIndex = 0; borderIndex < bw + bh; ++borderIndex) {
            double dsq;
            Tile t;
            GridLocation gl;
            int tgy;
            int tgx;
            int n = borderIndex < bw ? borderIndex : (tgx = sourceX < this.proximateBoardTarget.getX() ? 0 : bw - 1);
            int n2 = borderIndex < bw ? (sourceY < this.proximateBoardTarget.getY() ? 0 : bh - 1) : (tgy = borderIndex - bw);
            if (!this.proximateBoardTarget.solidAt(tgx, tgy) || (gl = this.proximateBoardTarget.locationAt(tgx, tgy)) instanceof Tile && !(t = (Tile)gl).full()) continue;
            double tx = this.proximateBoardTarget.getX() + (double)(tgx * 16);
            double ty = this.proximateBoardTarget.getY() + (double)(tgy * 16);
            if (this.attachedTo.isImmobile() && StrictMath.abs(sourceX - tx) > 32.0 || !((dsq = (sourceX - tx) * (sourceX - tx) + (sourceY - ty) * (sourceY - ty)) < (double)(this.type.hookRopeLength * this.type.hookRopeLength))) continue;
            if (this.proximateBoardTarget.enterableAt(tgx, tgy)) {
                return 2;
            }
            found = true;
        }
        return found ? 1 : 0;
    }

    public static double findJumpAngle(double sourceX, double sourceY, double targetX, double targetY, double v) {
        double angle;
        double y = sourceY - targetY;
        if (y < -120.0) {
            return Double.NaN;
        }
        double x = StrictMath.abs(targetX - sourceX);
        if (y <= 0.0 && x < 16.0) {
            return 128.0;
        }
        double g = 0.001;
        double a = StrictMath.atan((v * v + StrictMath.sqrt(v * v * v * v - g * (g * x * x + 2.0 * y * v * v))) / (g * x));
        double b = StrictMath.atan((v * v - StrictMath.sqrt(v * v * v * v - g * (g * x * x + 2.0 * y * v * v))) / (g * x));
        double d = angle = Double.isNaN(a) ? b : a;
        if (Double.isNaN(angle)) {
            return angle;
        }
        return targetX < sourceX ? Direction.flipHorizontal(angle) : angle;
    }

    public GridRef findEntryPoint() {
        GridRef best = null;
        double bestDsq = 0.0;
        for (int tgy = 0; tgy < this.ultimateBoardTarget.getGridHeight(); ++tgy) {
            for (int tgx = 0; tgx < this.ultimateBoardTarget.getGridWidth(); ++tgx) {
                if (!this.ultimateBoardTarget.enterableAt(tgx, tgy)) continue;
                double tx = this.ultimateBoardTarget.getX() + (double)(tgx * 16);
                double ty = this.ultimateBoardTarget.getY() + (double)(tgy * 16) - this.getBBHeight() + 0.5;
                double dsq = (this.getX() - tx) * (this.getX() - tx) + (this.getY() - ty) * (this.getY() - ty);
                if (best != null && !(dsq < bestDsq)) continue;
                best = new GridRef(tgx, tgy, this.ultimateBoardTarget);
                bestDsq = dsq;
            }
        }
        return best;
    }

    private GridRef findWalkTo() {
        if (!(this.attachedTo instanceof GridBody)) {
            return null;
        }
        GridBody att = (GridBody)this.attachedTo;
        int attW = att.getGridWidth();
        for (int gx = 0; gx < attW; ++gx) {
            int gy = att.firstSolidBlockYAt(gx);
            if (!this.canBoardFromGridPos(gx, gy)) continue;
            return new GridRef(gx, gy, att);
        }
        return null;
    }

    private boolean walkToIsValidForBoarding() {
        return this.walkToTargetGR != null && this.canBoardFromGridPos(this.walkToTargetGR.gridX, this.walkToTargetGR.gridY);
    }

    private boolean canBoardFromGridPos(int gx, int gy) {
        if (this.proximateBoardTarget == null) {
            return false;
        }
        double crewWorldX = this.attachedTo.getX() + (double)(gx * 16) + this.getBBWidth() / 2.0;
        double crewWorldY = this.attachedTo.getY() + (double)(gy * 16) - this.getBBHeight() / 2.0 + 0.5;
        return this.canSwitchToBoardTarget(crewWorldX, crewWorldY);
    }

    private GridRef disperse(Combat c, GridBody att) {
        int newGridY;
        int currentGridX = (int)StrictMath.floor((this.getX() - att.getX()) / 16.0);
        int newGridX = currentGridX + c.r.nextInt(7) - 4;
        if (att.solidAt(newGridX, newGridY = att.firstSolidBlockYAt(newGridX))) {
            return new GridRef(newGridX, newGridY, att);
        }
        return null;
    }

    private boolean canSwitchToBoardTarget(double wx, double wy) {
        if (this.attachedTo == this.proximateBoardTarget) {
            return false;
        }
        int btGx = (int)StrictMath.floor((wx - this.proximateBoardTarget.getX()) / 16.0);
        int btGy = (int)StrictMath.floor((wy - this.proximateBoardTarget.getY()) / 16.0);
        return this.proximateBoardTarget.solidAt(btGx, btGy);
    }

    private void switchToBoardTarget() {
        this.ignoring = this.attachedTo;
        this.attachedTo = this.proximateBoardTarget;
        this.walkToTargetGR = null;
    }

    public boolean exists(Crewman cm, Combat c) {
        int ssz = c.sides.size();
        for (int si = 0; si < ssz; ++si) {
            if (!c.sides.get((int)si).troops.contains(cm)) continue;
            return true;
        }
        return false;
    }

    public boolean exists(Body b, Combat c) {
        return b != null && (c.physics == null || c.physics.bodies.contains(b));
    }

    public boolean solidAndExists(GridRef gr, Combat c) {
        return gr != null && gr.solid() && this.exists(gr.body, c);
    }

    public void outsideShootingTick(int ms, Combat c, Combat.Side side, boolean onViewingSide) {
        this.weaponReload -= ms;
        if (this.attackTarget == null || c.sideOf(this.attackTarget) == null || this.attackTarget.dangerCache <= 0.0) {
            this.attackTarget = null;
        }
        if (this.interceptTarget == null || !this.exists(this.interceptTarget, c)) {
            this.interceptTarget = null;
        }
        if (!this.active() || this.weaponReload > 0) {
            return;
        }
        if (this.type.shootsShips && this.homeTile != null && this.homeTile.ship.containsTile(this.homeTile) && this.exists(this.homeTile.ship, c) && this.homeTile.ship.fireAt != null && this.exists(this.homeTile.ship.fireAt, c) && c.sideOf(this.homeTile.ship.fireAt) != side && this.homeTile.ship.fireAt.dangerCache > 0.0) {
            this.attackTarget = this.homeTile.ship.fireAt;
        }
        if (this.attackTarget == null && this.type.shootsShips) {
            Combat.Side otherS = c.otherSide(side);
            if (this.ultimateBoardTarget instanceof Airship) {
                this.attackTarget = (Airship)this.ultimateBoardTarget;
            } else {
                double minDist = 0.0;
                int esz = otherS.ships.size();
                for (int ei = 0; ei < esz; ++ei) {
                    Airship e = otherS.ships.get(ei);
                    if (e.dangerCache <= 0.0) continue;
                    double dSq = (e.getX() + e.getBBWidth() / 2.0 - this.getX()) * (e.getX() + e.getBBWidth() / 2.0 - this.getX()) + (e.getY() + e.getBBHeight() / 2.0 - this.getY()) * (e.getY() + e.getBBHeight() / 2.0 - this.getY());
                    if (this.attackTarget != null && !(dSq < minDist)) continue;
                    this.attackTarget = e;
                    minDist = dSq;
                }
            }
        }
        if (this.type.shootTroopsRange > 0 && !this.type.bombs) {
            PhysicsRect troopTarget = null;
            Crewman myInterceptTarget = null;
            double minDistSq = this.type.shootTroopsRange * this.type.shootTroopsRange;
            double minInterceptDistSq = 0.0;
            ArrayList<Crewman> enemyTroops = c.otherSide((Combat.Side)side).troops;
            int tsz = enemyTroops.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Crewman t;
                if (this.dx > 0.0 != (t = enemyTroops.get(ti)).getX() > this.getX() && (this.interceptTarget != null || !this.type.interceptTroops)) continue;
                double dSq = (this.getX() - t.getX()) * (this.getX() - t.getX()) + (this.getY() - t.getY()) * (this.getY() - t.getY());
                if (myInterceptTarget == null || dSq < minInterceptDistSq) {
                    myInterceptTarget = t;
                    minInterceptDistSq = dSq;
                }
                if (this.dx > 0.0 != t.getX() > this.getX() || !(dSq < minDistSq)) continue;
                troopTarget = t;
                minDistSq = dSq;
            }
            if (this.type.interceptTroops) {
                this.interceptTarget = myInterceptTarget;
            }
            if (troopTarget != null) {
                double srcX = this.getX();
                double srcY = this.getY() + (double)this.type.barrelY;
                double targetX = troopTarget.getX() + ((Crewman)troopTarget).getBBWidth() / 2.0;
                double targetY = troopTarget.getY() + ((Crewman)troopTarget).getBBHeight() / 2.0;
                srcX = targetX > srcX ? (srcX += (double)this.type.barrelX) : (srcX += this.getBBWidth() - (double)this.type.barrelX);
                double dist = StrictMath.sqrt((srcX - targetX) * (srcX - targetX) + (srcY - targetY) * (srcY - targetY)) + 1.0;
                double travelTime = dist / this.type.shotSpeed;
                targetX += ((Crewman)troopTarget).dx * travelTime + dist * this.type.inaccuracy * c.getInaccuracyMultiplier() * 16.0 * c.r.nextGaussian();
                targetY += ((Crewman)troopTarget).dy * travelTime + dist * this.type.inaccuracy * c.getInaccuracyMultiplier() * 16.0 * c.r.nextGaussian();
                if (!side.outsideCrewWeaponFiredVsCrew.contains(this.type)) {
                    side.outsideCrewWeaponFiredVsCrew.add(this.type);
                    c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("outsideCrewWeaponFired " + this.type.name + " " + ((Crewman)troopTarget).type.name, side, this.getX(), this.getY(), ((Crewman)troopTarget).type, null));
                    c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("attackedByOutsideCrew " + ((Crewman)troopTarget).type.name + " " + this.type.name, c.otherSide(side), this.getX(), this.getY(), this.type, null));
                }
                if (this.type.ammoCapacity > 0) {
                    --this.ammo;
                }
                Shot shot = new Shot((Crewman)troopTarget, targetX, targetY, this.type, srcX, srcY);
                c.shots.add(shot);
                if (this.type.shotSpeed >= 0.5 && this.type.shot != null) {
                    c.trails.add(new Trail(shot, (double)this.type.shot.srcHeight * 0.5 + 1.0));
                }
                this.weaponReload = this.weaponReload(c);
                if (this.type.attackParticle != null) {
                    c.particles.add(new Particle(this.type.attackParticle, srcX, srcY));
                }
                if (this.type.attackSnd != null) {
                    c.play(this.type.attackSnd, srcX, srcY, 0.0, 0.0, onViewingSide);
                }
                return;
            }
        }
        if (this.attackTarget != null) {
            boolean targetFound;
            double targetY;
            double targetX;
            double srcY;
            double srcX;
            block55: {
                srcX = this.getX();
                srcY = this.getY() + (double)this.type.barrelY;
                targetX = this.attackTarget.getX() + this.attackTarget.getBBWidth() / 2.0;
                targetY = this.attackTarget.getY() + this.attackTarget.getBBHeight() / 2.0;
                targetFound = false;
                if (this.type.bombs) {
                    targetX = this.getX();
                    targetY = StrictMath.min(this.attackTarget.getY() + this.attackTarget.getBBHeight() - 8.0, this.attackTarget.yBoundaryAt(targetX) + 32.0);
                    targetFound = srcX > this.attackTarget.getX() + this.attackTarget.getBBWidth() * 0.2 && srcX < this.attackTarget.getX() + this.attackTarget.getBBWidth() * 0.8 && targetY > srcY;
                } else if (this.type.aimForCenter) {
                    for (int targetGridSize = 5; targetGridSize > 0; --targetGridSize) {
                        boolean loopHeightBumped;
                        boolean loopWidthBumped;
                        boolean anchorYBumped;
                        boolean anchorXBumped;
                        int anchorX = this.attackTarget.getWidth() / 2;
                        int anchorY = this.attackTarget.getHeight() / 2;
                        int loopWidth = 0;
                        int loopHeight = 0;
                        do {
                            int gx = anchorX;
                            int gy = anchorY;
                            for (int i = 0; i < loopWidth * 2 + loopHeight * 2 + 1; ++i) {
                                boolean solid = true;
                                block5: for (int yOff = 0; yOff < targetGridSize; ++yOff) {
                                    for (int xOff = 0; xOff < targetGridSize; ++xOff) {
                                        Tile t = this.attackTarget.tileAt(gx + xOff - targetGridSize / 2, gy + yOff - targetGridSize / 2);
                                        if (t != null && t.solid()) continue;
                                        solid = false;
                                        break block5;
                                    }
                                }
                                if (solid) {
                                    targetX = this.attackTarget.getX() + (double)(this.attackTarget.gridXToWorldX(gx + targetGridSize / 2, 1) * 16);
                                    targetY = this.attackTarget.getY() + (double)((gy + targetGridSize / 2) * 16);
                                    double d = Math.sqrt((srcX - targetX) * (srcX - targetX) + (srcY - targetY) * (srcY - targetY));
                                    double travelTime = d / this.type.shotSpeed;
                                    boolean bl = (this.dx > 0.0 ? targetX > srcX : (targetX += this.attackTarget.getxSpeed() * travelTime * 0.95) < srcX) && (targetY += this.attackTarget.getySpeed() * travelTime * 0.3) > srcY && Math.abs(targetX - srcX) <= this.type.maxRange ? true : (targetFound = false);
                                    if (targetFound) break block55;
                                }
                                if (i < loopWidth) {
                                    ++gx;
                                    continue;
                                }
                                if (i < loopWidth + loopHeight) {
                                    ++gy;
                                    continue;
                                }
                                if (i < loopWidth * 2 + loopHeight) {
                                    --gx;
                                    continue;
                                }
                                --gy;
                            }
                            anchorXBumped = false;
                            anchorYBumped = false;
                            loopWidthBumped = false;
                            loopHeightBumped = false;
                            if (anchorX <= 0) {
                                anchorXBumped = true;
                            } else {
                                --anchorX;
                            }
                            if (anchorY <= 0) {
                                anchorYBumped = true;
                            } else {
                                --anchorY;
                            }
                            if (anchorX + loopWidth + 2 + targetGridSize > this.attackTarget.getWidth()) {
                                loopWidthBumped = true;
                            } else {
                                loopWidth += 2;
                            }
                            if (anchorY + loopHeight + 2 + targetGridSize > this.attackTarget.getHeight()) {
                                loopHeightBumped = true;
                                continue;
                            }
                            loopHeight += 2;
                        } while (!anchorXBumped || !anchorYBumped || !loopWidthBumped || !loopHeightBumped);
                    }
                } else {
                    int direction;
                    if (srcY > this.attackTarget.getY() && srcY < this.attackTarget.getY() + this.attackTarget.getBBHeight()) {
                        targetY = srcY;
                    } else if (srcY < this.attackTarget.getY()) {
                        targetY = this.attackTarget.getY() + 8.0;
                    } else if (srcY > this.attackTarget.getY() + this.attackTarget.getBBHeight()) {
                        targetY = this.attackTarget.getY() + this.attackTarget.getBBHeight() - 8.0;
                    }
                    if (targetX > srcX) {
                        targetX = srcX + (double)(this.type.strafeOvershoot / 2);
                        srcX += (double)this.type.barrelX;
                        direction = 1;
                    } else {
                        targetX = srcX - (double)(this.type.strafeOvershoot / 2);
                        srcX += this.getBBWidth() - (double)this.type.barrelX;
                        direction = -1;
                    }
                    double strafeRangeStart = srcX + (double)(this.type.strafeOvershoot / 4 * direction);
                    double strafeRangeEnd = srcX + this.type.maxRange;
                    double strafeRangeMin = StrictMath.min(strafeRangeStart, strafeRangeEnd);
                    double strafeRangeMax = StrictMath.max(strafeRangeStart, strafeRangeEnd);
                    strafeRangeMin = StrictMath.max(strafeRangeMin, this.attackTarget.getX());
                    strafeRangeMax = StrictMath.min(strafeRangeMax, this.attackTarget.getX() + this.attackTarget.getBBWidth());
                    if (strafeRangeMax > strafeRangeMin) {
                        double strafeRangeCenter = strafeRangeMax / 2.0 + strafeRangeMin / 2.0;
                        int targetCenterOfMassDirection = this.attackTarget.getX() + this.attackTarget.getBBWidth() / 2.0 > strafeRangeCenter ? 1 : -1;
                        int gy = (int)((targetY - this.attackTarget.getY()) / 16.0);
                        for (targetX = strafeRangeCenter; targetX > strafeRangeMin && targetX < strafeRangeMax; targetX += (double)(16 * targetCenterOfMassDirection)) {
                            int gx = (int)((targetX - this.attackTarget.getX()) / 16.0);
                            if (!this.attackTarget.solidAt(gx, gy)) continue;
                            targetFound = true;
                            break;
                        }
                    }
                }
            }
            if (!targetFound) {
                return;
            }
            if (!side.outsideCrewWeaponFiredVsShip.contains(this.type)) {
                side.outsideCrewWeaponFiredVsShip.add(this.type);
                c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("outsideCrewWeaponFiredVsShip " + this.type.name, side, this.getX(), this.getY(), null, null));
            }
            double dist = StrictMath.sqrt((targetX - srcX) * (targetX - srcX) + (targetY - srcY) * (targetY - srcY));
            if (this.type.ammoCapacity > 0) {
                --this.ammo;
            }
            double travelTime = dist / this.type.shotSpeed;
            Shot shot = new Shot(this.attackTarget, (targetX += this.attackTarget.getxSpeed() * travelTime) + dist * this.type.inaccuracy * c.getInaccuracyMultiplier() * 16.0 * c.r.nextGaussian(), targetY + dist * this.type.inaccuracy * c.getInaccuracyMultiplier() * 16.0 * c.r.nextGaussian(), this.type, srcX, srcY, false, false);
            c.shots.add(shot);
            if (this.type.shotSpeed >= 0.5 && this.type.shot != null) {
                c.trails.add(new Trail(shot, (double)this.type.shot.srcHeight * 0.5 + 1.0));
            }
            this.weaponReload = this.weaponReload(c);
            if (this.type.attackParticle != null) {
                c.particles.add(new Particle(this.type.attackParticle, srcX, srcY));
            }
            if (this.type.attackSnd != null) {
                c.play(this.type.attackSnd, srcX, srcY, 0.0, 0.0, onViewingSide);
            }
        }
    }

    public boolean outsideFlyingTick(int ms, Combat c, Combat.Side side, boolean onViewingSide) {
        if (!this.exists(this.ultimateBoardTarget, c)) {
            this.ultimateBoardTarget = null;
        }
        this.timeSinceLaunch += ms;
        if (this.active()) {
            if (this.timeSinceLaunch >= this.type.launchLength && (this.type.shootsShips || this.type.interceptTroops) && (this.type.ammoCapacity == 0 || this.ammo > 0)) {
                this.outsideShootingTick(ms, c, side, onViewingSide);
            }
            if (!this.solidAndExists(this.entryPoint, c) || !this.entryPoint.enterable()) {
                this.entryPoint = null;
            }
            if (this.entryPoint != null && this.entryPoint.body != this.ultimateBoardTarget) {
                this.entryPoint = null;
            }
            if (this.entryPoint == null && this.ultimateBoardTarget != null && this.ultimateBoardTarget instanceof Airship) {
                this.entryPoint = this.findEntryPoint();
            }
            double targetX = this.getX();
            double targetY = this.getY();
            boolean doMove = false;
            boolean landing = false;
            if ((this.hp <= this.type.returnToRepairHP || this.type.ammoCapacity > 0 && this.ammo <= 0) && this.homeTile != null && this.homeTile.ship.containsTile(this.homeTile) && this.exists(this.homeTile.ship, c)) {
                if (this.popIn(this.homeTile.ship, false, c)) {
                    return true;
                }
                targetX = this.homeTile.worldX();
                targetY = this.homeTile.worldY();
                doMove = true;
                landing = true;
            } else if (this.entryPoint != null) {
                boolean asBoarder;
                Airship boardTargetShip = (Airship)this.ultimateBoardTarget;
                boolean bl = asBoarder = side != c.sideOf(boardTargetShip);
                if (this.popIn(boardTargetShip, asBoarder, c)) {
                    return true;
                }
                targetX = this.entryPoint.worldX();
                targetY = this.entryPoint.worldY();
                doMove = true;
            } else if (this.type.interceptTroops && this.interceptTarget != null) {
                doMove = true;
                targetX = this.interceptTarget.getX() + this.interceptTarget.getBBWidth() / 2.0;
                targetY = this.interceptTarget.getY() + this.interceptTarget.getBBHeight() / 2.0;
            } else if (this.type.shootsShips && this.attackTarget != null) {
                if (this.strafeTo != null && ((this.strafeTo.x - this.getX()) * (this.strafeTo.x - this.getX()) + (this.strafeTo.y - this.getY()) * (this.strafeTo.y - this.getY()) < 2304.0 || this.strafeTo.x < this.attackTarget.getX() - (double)(this.type.strafeOvershoot * 2) || this.strafeTo.x > this.attackTarget.getX() + this.attackTarget.getBBWidth() + (double)(this.type.strafeOvershoot * 2) || this.strafeTo.y > this.attackTarget.getY() + this.attackTarget.getBBHeight())) {
                    this.strafeTo = null;
                }
                if (this.strafeTo == null) {
                    double strafeMax;
                    double strafePos;
                    double strafeX = this.getX() + this.getBBWidth() / 2.0 < this.attackTarget.getX() + this.attackTarget.getBBWidth() / 2.0 ? this.attackTarget.getX() + this.attackTarget.getBBWidth() + (double)this.type.strafeOvershoot : this.attackTarget.getX() - (double)this.type.strafeOvershoot;
                    double highestLandscapePoint = 10000.0;
                    LandFormation ground = c.landFormations.get(0);
                    if (strafeX > this.getX()) {
                        for (strafePos = this.getX(); strafePos < strafeX; strafePos += 16.0) {
                            highestLandscapePoint = StrictMath.min(highestLandscapePoint, ground.solidYBoundaryAt(strafePos));
                        }
                    } else {
                        for (strafePos = this.getX(); strafePos > strafeX; strafePos -= 16.0) {
                            highestLandscapePoint = StrictMath.min(highestLandscapePoint, ground.solidYBoundaryAt(strafePos));
                        }
                    }
                    double strafeMin = this.type.bombs ? this.attackTarget.getY() - this.type.maxRange + 16.0 : this.attackTarget.getY() - 32.0;
                    double strafeY = strafeMax = this.type.bombs ? StrictMath.min(StrictMath.min(this.attackTarget.getY() - this.type.maxRange / 3.0, highestLandscapePoint - 48.0), this.attackTarget.getY() - 48.0) : StrictMath.min(highestLandscapePoint - 48.0, this.attackTarget.getY() + this.attackTarget.getBBHeight() - 16.0);
                    if (strafeMax > strafeMin) {
                        strafeY = strafeMin + c.r.nextDouble() * (strafeMax - strafeMin);
                    }
                    this.strafeTo = new Pt(strafeX, strafeY);
                }
                if (this.strafeTo != null) {
                    doMove = true;
                    targetX = this.strafeTo.x;
                    targetY = this.strafeTo.y;
                }
            } else if (this.timeSinceLaunch > this.type.launchLength) {
                if (this.strafeTo != null && (this.strafeTo.x - this.getX()) * (this.strafeTo.x - this.getX()) + (this.strafeTo.y - this.getY()) * (this.strafeTo.y - this.getY()) < 2304.0) {
                    this.strafeTo = null;
                }
                if (this.strafeTo == null) {
                    double strafePos;
                    double strafeX;
                    Airship mom = null;
                    double d = strafeX = this.dx > 0.0 ? this.getX() - (double)(this.type.strafeOvershoot * 2) : this.getX() + (double)(this.type.strafeOvershoot * 2);
                    if (this.homeTile != null && this.homeTile.ship.containsTile(this.homeTile) && this.exists(this.homeTile.ship, c)) {
                        mom = this.homeTile.ship;
                        strafeX = mom.getX() + mom.getBBWidth() / 2.0 > this.getX() ? mom.getX() + mom.getBBWidth() + (double)this.type.strafeOvershoot : mom.getX() - (double)this.type.strafeOvershoot;
                    }
                    double highestLandscapePoint = 10000.0;
                    LandFormation ground = c.landFormations.get(0);
                    if (strafeX > this.getX()) {
                        for (strafePos = this.getX(); strafePos < strafeX; strafePos += 16.0) {
                            highestLandscapePoint = StrictMath.min(highestLandscapePoint, ground.solidYBoundaryAt(strafePos));
                        }
                    } else {
                        for (strafePos = this.getX(); strafePos > strafeX; strafePos -= 16.0) {
                            highestLandscapePoint = StrictMath.min(highestLandscapePoint, ground.solidYBoundaryAt(strafePos));
                        }
                    }
                    double strafeY = (mom == null ? highestLandscapePoint : StrictMath.min(mom.getY(), highestLandscapePoint)) - 48.0;
                    this.strafeTo = new Pt(strafeX, strafeY);
                }
                if (this.strafeTo != null) {
                    doMove = true;
                    targetX = this.strafeTo.x;
                    targetY = this.strafeTo.y;
                }
            }
            if (doMove) {
                boolean noDown;
                double trackingDxPrev = this.trackingDx;
                double rx = this.getX() + this.dx * StrictMath.abs(this.dx) / this.type.airXAcceleration * (1.0 - this.type.airOvershoot);
                double ry = this.getY() + this.dy * StrictMath.abs(this.dy) / (this.dy > 0.0 ? this.type.airUpAcceleration : this.type.airDownAcceleration) * (1.0 - this.type.airOvershoot);
                double accelStrength = this.type.launchLength <= 0 ? 1.0 : StrictMath.min(1.0, 1.0 * (double)this.timeSinceLaunch / (double)this.type.launchLength);
                LandFormation ground = c.landFormations.get(0);
                double rGroundBoundary = ground.solidYBoundaryAt(rx);
                double groundBoundary = ground.solidYBoundaryAt(this.getX());
                double bbH = this.getBBHeight();
                boolean hardStop = !landing && this.getY() > groundBoundary - bbH;
                boolean pullUp = !landing && (ry > rGroundBoundary - bbH - 32.0 || this.getY() > groundBoundary - bbH - 32.0);
                boolean bl = noDown = ry > rGroundBoundary - bbH - 48.0 || this.getY() > groundBoundary - bbH - 48.0;
                if (StrictMath.abs(this.getX() - targetX) / this.type.airXTopSpeed < StrictMath.abs(this.getY() - targetY) / this.type.airDownTopSpeed) {
                    pullUp = false;
                    noDown = false;
                    if (StrictMath.abs(this.getX() - targetX) < 16.0) {
                        hardStop = false;
                    }
                }
                if (targetX > rx) {
                    this.trackingDx += this.type.airXAcceleration * (double)ms * accelStrength;
                } else if (targetX < rx) {
                    this.trackingDx -= this.type.airXAcceleration * (double)ms * accelStrength;
                }
                if (pullUp) {
                    this.dy -= this.type.airUpAcceleration * (double)ms * accelStrength;
                } else if (targetY < ry) {
                    this.dy -= this.type.airUpAcceleration * (double)ms * accelStrength;
                } else if (targetY > ry && !noDown) {
                    this.dy += this.type.airDownAcceleration * (double)ms * accelStrength;
                }
                if (hardStop) {
                    this.dy = StrictMath.min(0.0, this.dy);
                }
                if (this.trackingDx > 0.0 && trackingDxPrev <= 0.0) {
                    this.trackingDx = StrictMath.max(this.trackingDx, this.type.airXMinSpeed);
                }
                if (this.trackingDx < 0.0 && trackingDxPrev >= 0.0) {
                    this.trackingDx = StrictMath.min(this.trackingDx, -this.type.airXMinSpeed);
                }
            }
            if (this.trackingDx > this.type.airXTopSpeed) {
                this.trackingDx = this.type.airXTopSpeed;
            }
            if (this.trackingDx < -this.type.airXTopSpeed) {
                this.trackingDx = -this.type.airXTopSpeed;
            }
            this.dx = this.trackingDx;
            if (this.dx < 0.0 && this.dx > -this.type.airXMinSpeed) {
                this.dx = -this.type.airXMinSpeed;
            }
            if (this.dx > 0.0 && this.dx < this.type.airXMinSpeed) {
                this.dx = this.type.airXMinSpeed;
            }
            if (this.dy > this.type.airDownTopSpeed) {
                this.dy = this.type.airDownTopSpeed;
            }
            if (this.dy < -this.type.airUpTopSpeed) {
                this.dy = -this.type.airUpTopSpeed;
            }
        } else {
            if (this.type.crashesOnDeath) {
                if (!side.outsideCrewCrashing.contains(this.type)) {
                    side.outsideCrewCrashing.add(this.type);
                    c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("outsideCrewCrashing " + this.type.name, side, this.getX(), this.getY(), this.type, null));
                }
                this.dy += c.physics.gravity * (double)ms;
                this.dx += (this.dx < 0.0 ? -0.3 : 0.3) * c.physics.gravity * (double)ms;
                if (this.getY() + this.getBBHeight() / 2.0 > c.landFormations.get(0).yBoundaryAt(this.getX() + this.getBBWidth() / 2.0)) {
                    this.explode(c, this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0, onViewingSide);
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean outsideTick(int ms, Combat c, Combat.Side side, boolean onViewingSide) {
        GridRef dis;
        if (this.type.canFly) {
            this.animTick(ms, c);
            return this.outsideFlyingTick(ms, c, side, onViewingSide);
        }
        if (this.type.shootsShips || this.type.interceptTroops) {
            this.outsideShootingTick(ms, c, side, onViewingSide);
        }
        if (this.mvXOffset == 0.0) {
            this.mvXOffset = c.r.nextDouble() * 16.0 / 2.0 - 4.0;
        }
        if (!this.exists(this.ultimateBoardTarget, c)) {
            this.ultimateBoardTarget = null;
            this.proximateBoardTarget = null;
        }
        this.msUntilRecalcJumpPoint -= ms;
        if (this.msUntilRecalcJumpPoint < -100) {
            this.msUntilRecalcJumpPoint = 300;
        }
        this.msUntilRecalcWalkPoint -= ms;
        if (this.msUntilRecalcWalkPoint < -100) {
            this.msUntilRecalcWalkPoint = 300;
        }
        this.animTick(ms, c);
        this.shoutCooldown -= ms;
        this.initialShoutCooldown -= ms;
        this.shoutMs -= ms;
        if (this.shoutMs <= 0) {
            this.shout = null;
        }
        this.mvDx = 0.0;
        this.mvDy = 0.0;
        if (this.grabbed) {
            return !this.active();
        }
        if (this.attachedTo != null && this.attachedTo == this.proximateBoardTarget) {
            this.proximateBoardTarget = null;
            this.hookLaunched = false;
        }
        if (this.ultimateBoardTarget != null && this.attachedTo instanceof GridBody) {
            if (!c.bodyPathing.connected((GridBody)this.attachedTo, this.proximateBoardTarget, this.type.assumedJumpDist, this.type.hasHook ? this.type.hookRopeLength : -1, c)) {
                this.proximateBoardTarget = null;
            }
            if (this.proximateBoardTarget == null) {
                this.proximateBoardTarget = c.bodyPathing.getNextInPath((GridBody)this.attachedTo, this.ultimateBoardTarget, this.type.assumedJumpDist, this.type.hasHook ? this.type.hookRopeLength : -1, c);
            }
        } else {
            this.proximateBoardTarget = null;
        }
        if (this.attachedTo == this.ultimateBoardTarget && this.ultimateBoardTarget != null) {
            this.hookLaunched = false;
            if (this.ultimateBoardTarget instanceof Airship) {
                boolean asBoarder;
                Airship boardTargetShip = (Airship)this.ultimateBoardTarget;
                boolean bl = asBoarder = side != c.sideOf(boardTargetShip);
                if (this.canPopIn(boardTargetShip) && this.popIn(boardTargetShip, asBoarder, c)) {
                    return true;
                }
                if (!this.solidAndExists(this.entryPoint, c) || !this.entryPoint.enterable()) {
                    this.entryPoint = null;
                }
                if (this.entryPoint != null && this.entryPoint.body != this.ultimateBoardTarget) {
                    this.entryPoint = null;
                }
                if (this.entryPoint == null) {
                    this.entryPoint = this.findEntryPoint();
                }
                if (this.entryPoint != null) {
                    this.moveTowardsOutside(this.entryPoint);
                }
            } else {
                this.ultimateBoardTarget = null;
            }
        } else if (this.hookLaunched) {
            if (this.hookedGR != null) {
                if (!this.solidAndExists(this.hookedGR, c)) {
                    this.hookLaunched = false;
                    this.ignoring = null;
                    this.hookedGR = null;
                } else if (!this.winching) {
                    this.drop();
                    this.winching = true;
                } else {
                    this.hookProgress -= this.type.winchSpeed * (double)ms;
                    if (this.hookProgress < 0.0) {
                        this.hookProgress = 0.0;
                        this.hookLaunched = false;
                        this.ignoring = null;
                    }
                }
            } else {
                this.hookProgress += this.type.hookSpeed * (double)ms;
                if (this.hookProgress >= this.hookDist) {
                    int tileY;
                    int tileX = (int)((this.hookTarget.x - this.hookTargetBody.getX()) / 16.0);
                    GridRef hitGR = new GridRef(tileX, tileY = (int)((this.hookTarget.y - this.hookTargetBody.getY()) / 16.0), this.hookTargetBody);
                    if (this.solidAndExists(hitGR, c)) {
                        if (this.type.hookHitSnd != null) {
                            c.play(this.type.hookHitSnd, this.hookTarget.x, this.hookTarget.y, 0.0, 0.0, onViewingSide);
                        }
                        double tx = this.hookTargetBody.getX() + (double)(hitGR.gridX * 16);
                        double ty = this.hookTargetBody.getY() + (double)(hitGR.gridY * 16);
                        this.hookedGR = hitGR;
                        this.hookDist = this.hookProgress = StrictMath.sqrt((this.getX() - this.hookTarget.x) * (this.getX() - this.hookTarget.x) + (this.getY() - this.hookTarget.y) * (this.getY() - this.hookTarget.y));
                        this.hookTarget = new Pt(this.hookTarget.x - tx, this.hookTarget.y - ty);
                    } else {
                        this.hookLaunched = false;
                        this.newThrowWait = 3000;
                    }
                }
            }
        } else if (this.proximateBoardTarget != null && this.attachedTo != null) {
            GridBody att;
            GridRef[] tt = new GridRef[1];
            double[] angleAndStrengthRef = new double[2];
            if (this.isSmart) {
                this.findJumpAngleAndStrength(this.getX(), this.getY(), tt, angleAndStrengthRef);
            }
            boolean walking = false;
            if (this.attachedTo instanceof GridBody) {
                att = (GridBody)this.attachedTo;
                if (!this.solidAndExists(this.walkToTargetGR, c)) {
                    this.walkToTargetGR = null;
                }
                if (this.isSmart && this.jumpSourceGR == null && this.walkToTargetGR == null && this.msUntilRecalcWalkPoint <= 0) {
                    this.walkToTargetGR = this.findWalkTo();
                    this.msUntilRecalcWalkPoint = 300;
                }
                if (this.walkToTargetGR != null && this.walkToIsValidForBoarding()) {
                    this.moveTowardsOutside(this.walkToTargetGR);
                    walking = true;
                } else {
                    this.walkToTargetGR = null;
                }
                if (this.canSwitchToBoardTarget(this.getX(), this.getY())) {
                    this.switchToBoardTarget();
                    this.walkToTargetGR = null;
                    walking = true;
                }
            }
            if (!walking) {
                if (this.type.hasHook) {
                    if (this.isSmart && angleAndStrengthRef[0] == 128.0) {
                        this.drop();
                    } else if (this.newThrowWait > 0) {
                        this.newThrowWait -= ms;
                    } else if (this.canHookFrom(this.getX(), this.getY()) > 0) {
                        Utils.Pair<Pt, GridRef> ht = this.findHookTarget(this.getX(), this.getY(), side);
                        if (ht != null) {
                            this.hookTarget = (Pt)ht.a;
                            this.hookLaunched = true;
                            this.hookedGR = null;
                            this.hookSource = new Pt(this.getX(), this.getY());
                            this.hookDist = 1.0 + StrictMath.sqrt((this.hookSource.x - this.hookTarget.x) * (this.hookSource.x - this.hookTarget.x) + (this.hookSource.y - this.hookTarget.y) * (this.hookSource.y - this.hookTarget.y));
                            this.hookTargetBody = this.proximateBoardTarget;
                            this.hookProgress = 0.0;
                            if (this.type.hookLaunchSnd != null) {
                                c.play(this.type.hookLaunchSnd, this.getX(), this.getY(), 0.0, 0.0, onViewingSide);
                            }
                        }
                    } else if (this.attachedTo instanceof GridBody) {
                        att = (GridBody)this.attachedTo;
                        if (this.solidAndExists(this.jumpSourceGR, c)) {
                            double tx = att.getX() + (double)(this.jumpSourceGR.gridX * 16);
                            double ty = att.getY() + (double)(this.jumpSourceGR.gridY * 16);
                            this.findJumpAngleAndStrength(tx, ty, null, angleAndStrengthRef);
                            if (Double.isNaN(angleAndStrengthRef[0]) && this.canHookFrom(tx, ty) == 0) {
                                this.jumpSourceGR = null;
                            }
                        } else {
                            this.jumpSourceGR = null;
                        }
                        if (this.jumpSourceGR == null && this.msUntilRecalcJumpPoint <= 0) {
                            this.jumpSourceGR = this.findHookPoint(side);
                            if (this.jumpSourceGR == null) {
                                this.jumpSourceGR = this.isSmart ? this.findJumpPoint(side, true) : null;
                            }
                            this.msUntilRecalcJumpPoint = 300;
                        }
                        if (this.jumpSourceGR != null) {
                            this.moveTowardsOutside(this.jumpSourceGR);
                        }
                    }
                } else if (this.isSmart && !Double.isNaN(angleAndStrengthRef[0])) {
                    if (angleAndStrengthRef[0] == 128.0) {
                        this.drop();
                    } else {
                        this.jump(angleAndStrengthRef[0], angleAndStrengthRef[1]);
                    }
                } else if (this.attachedTo instanceof GridBody) {
                    att = (GridBody)this.attachedTo;
                    if (this.isSmart) {
                        if (this.solidAndExists(this.jumpSourceGR, c)) {
                            this.findJumpAngleAndStrength(this.jumpSourceGR.worldX(), this.jumpSourceGR.worldY(), null, angleAndStrengthRef);
                            if (Double.isNaN(angleAndStrengthRef[0])) {
                                this.jumpSourceGR = null;
                            }
                        } else {
                            this.jumpSourceGR = null;
                        }
                        if (this.jumpSourceGR == null && this.msUntilRecalcJumpPoint <= 0) {
                            this.jumpSourceGR = this.findJumpPoint(side, false);
                            this.msUntilRecalcJumpPoint = 300;
                        }
                    }
                    if (this.jumpSourceGR != null) {
                        this.moveTowardsOutside(this.jumpSourceGR);
                    }
                }
            }
        }
        if (!this.solidAndExists(this.walkToGR, c)) {
            this.walkToGR = null;
        }
        if (this.attachedTo instanceof GridBody && this.dispersed != this.attachedTo && this.jumpSourceGR == null && this.walkToTargetGR == null && this.proximateBoardTarget == null && this.attachedTo != this.ultimateBoardTarget && (dis = this.disperse(c, (GridBody)this.attachedTo)) != null) {
            this.walkToGR = dis;
            this.dispersed = this.attachedTo;
        }
        if (this.attachedTo instanceof GridBody && this.walkToTargetGR == null && this.jumpSourceGR == null && this.attachedTo != this.ultimateBoardTarget) {
            GridBody att = (GridBody)this.attachedTo;
            if (this.walkToGR == null && this.msUntilRecalcWalkPoint <= 0) {
                int gx = (int)StrictMath.floor((this.getX() - this.attachedTo.getX()) / 16.0);
                this.walkToGR = new GridRef(gx, att.firstSolidBlockYAt(gx), att);
                this.msUntilRecalcWalkPoint = 300;
            }
            if (this.walkToGR != null && this.walkToGR.body == this.attachedTo) {
                this.moveTowardsOutside(this.walkToGR);
            }
        }
        return !this.active();
    }

    private void moveTowardsOutside(GridRef gr) {
        double tx = gr.worldX() + this.mvXOffset + 8.0 - this.getBBWidth() / 2.0;
        double ty = gr.worldY() - this.getBBHeight() + 0.5;
        double d = StrictMath.abs(this.getX() - tx) + StrictMath.abs(this.getY() - ty);
        if (this.attachedTo != null && this.attachedTo.isImmobile() && this.attachedTo instanceof LandFormation) {
            LandFormation lf = (LandFormation)this.attachedTo;
            if (this.getX() - tx < -1.0) {
                double leadingY = lf.yBoundaryAt(this.getX() + this.getBBWidth() * 0.9) - this.getBBHeight() + 0.5;
                if (leadingY < this.getY() - 0.1) {
                    this.mvDx = 0.0;
                    this.mvDy = -this.type.outsideSpeed;
                } else {
                    this.mvDx = this.type.outsideSpeed;
                    this.mvDy = 0.0;
                }
            } else if (this.getX() - tx > 1.0) {
                double leadingY = lf.yBoundaryAt(this.getX() + this.getBBWidth() * 0.1) - this.getBBHeight() + 0.5;
                if (leadingY < this.getY() - 0.1) {
                    this.mvDx = 0.0;
                    this.mvDy = -this.type.outsideSpeed;
                } else {
                    this.mvDx = -this.type.outsideSpeed;
                    this.mvDy = 0.0;
                }
            } else {
                this.mvDx = 0.0;
                this.mvDy = 0.0;
            }
        } else if (this.attachedTo instanceof GridBody) {
            GridBody att = (GridBody)this.attachedTo;
            GridLocation src = att.locationAtWorldCoords(this.getX() + this.getBBWidth() / 2.0, this.getY() + this.getBBHeight() / 2.0);
            if (src == null) {
                src = att.locationAtWorldCoords(this.getX(), this.getY() + this.getBBHeight());
                if (src == null) {
                    src = att.locationAtWorldCoords(this.getX() + this.getBBWidth(), this.getY() + this.getBBHeight());
                }
                if (src == null) {
                    src = att.locationAtWorldCoords(this.getX(), this.getY());
                }
                if (src == null) {
                    src = att.locationAtWorldCoords(this.getX() + this.getBBWidth(), this.getY());
                }
            }
            if (src != null && src.reachable() != null) {
                if (this.outsideBodyPath == null || !this.outsideBodyPath.endsAt(gr)) {
                    this.outsideBodyPath = att.getPath(src, gr);
                }
                if (this.outsideBodyPath != null) {
                    double xDist = this.outsideBodyPath.nextWaypoint().worldX() + 8.0 - (this.getX() + this.getBBWidth() / 2.0);
                    double yDist = this.outsideBodyPath.nextWaypoint().worldY() + 8.0 - (this.getY() + this.getBBHeight() / 2.0);
                    if (StrictMath.abs(xDist) > 1.0) {
                        if (StrictMath.abs(yDist) > 1.0) {
                            this.mvDx = xDist > 0.0 ? this.type.outsideSpeed / 1.41 : -this.type.outsideSpeed / 1.41;
                            this.mvDy = yDist > 0.0 ? this.type.outsideSpeed / 1.41 : -this.type.outsideSpeed / 1.41;
                        } else {
                            this.mvDx = xDist > 0.0 ? this.type.outsideSpeed : -this.type.outsideSpeed;
                            this.mvDy = 0.0;
                        }
                    } else {
                        this.mvDx = 0.0;
                        if (StrictMath.abs(yDist) > 1.0) {
                            this.mvDy = yDist > 0.0 ? this.type.outsideSpeed : -this.type.outsideSpeed;
                        } else {
                            ++this.outsideBodyPath.nextWaypointIndex;
                        }
                    }
                }
            }
        } else if (d < 0.5) {
            this.mvDx = 0.0;
            this.mvDy = 0.0;
        } else {
            this.mvDx = this.type.outsideSpeed * (tx - this.getX()) / d;
            this.mvDy = this.type.outsideSpeed * (ty - this.getY()) / d;
        }
    }

    @Override
    public double getBBWidth() {
        return this.type.animLooks[0].bundle == null ? (double)this.type.animLooks[0].frameAnimationBoundingBoxWidth : this.type.animLooks[0].bundle.width;
    }

    @Override
    public double getBBHeight() {
        return this.type.animLooks[0].bundle == null ? (double)this.type.animLooks[0].frameAnimationBoundingBoxHeight : this.type.animLooks[0].bundle.height;
    }

    public String pickShout(String shoutType) {
        ArrayList<String> l = this.type.shouts.get(shoutType);
        return l == null || l.isEmpty() ? null : l.get(AGame.ANIM_R.nextInt(l.size()));
    }

    public void shout(String type) {
        if (this.shoutCooldown <= 0) {
            this.doShout(this.pickShout(type));
        }
    }

    public void doShout(String sh) {
        if (sh == null) {
            return;
        }
        this.doShoutExplicitString(Lang._t(sh, new Object[0]));
    }

    public void doShoutExplicitString(String sh) {
        Airship myShip;
        if (sh == null) {
            return;
        }
        if (this.initialShoutCooldown > 0) {
            return;
        }
        if (this.ship == null && this.boardingShip == null) {
            return;
        }
        this.bigShout = false;
        this.shout = sh;
        this.shoutCooldown = AGame.ANIM_R.nextInt(5000) + 4000;
        this.shoutMs = 1800;
        Airship airship = myShip = this.ship == null ? this.boardingShip : this.ship;
        if (myShip != null) {
            this.shoutOriginX = (int)(myShip.getX() + (double)(myShip.gridXToWorldX(this.currentTile.x, 1) * 16) + 8.0);
            this.shoutOriginY = (int)(myShip.getY() + (double)(this.currentTile.y * 16) + 8.0);
        } else {
            this.shoutOriginX = (int)this.getX();
            this.shoutOriginY = (int)this.getY();
        }
        this.shoutW = 0;
    }

    private void bigShout(String sh) {
        Airship myShip;
        if (sh == null) {
            return;
        }
        if (this.initialShoutCooldown > 0) {
            return;
        }
        this.shout = Lang._t(sh, new Object[0]).toUpperCase(Locale.ENGLISH);
        this.bigShout = true;
        this.shoutCooldown = AGame.ANIM_R.nextInt(5000) + 4000;
        this.shoutMs = 1800;
        Airship airship = myShip = this.ship == null ? this.boardingShip : this.ship;
        if (myShip != null) {
            this.shoutOriginX = (int)(myShip.getX() + (double)(this.ship.gridXToWorldX(this.currentTile.x, 1) * 16) + 8.0);
            this.shoutOriginY = (int)(myShip.getY() + (double)(this.currentTile.y * 16) + 8.0);
        } else {
            this.shoutOriginX = (int)this.getX();
            this.shoutOriginY = (int)this.getY();
        }
        this.shoutW = 0;
    }

    private void boarderShout(int ms, Combat c) {
        this.shoutCooldown -= ms;
        this.shoutMs -= ms;
        if (this.shoutMs <= 0) {
            this.shout = null;
            if (this.active()) {
                if (this.currentTile.module.type.getCommand(this.boardingShip.currentBonuses) > 0) {
                    this.doShout(this.pickShout("boarderReachedBridge"));
                } else {
                    this.doShout(this.pickShout("boarder"));
                }
            } else if (this.hp > 0) {
                this.doShout(this.pickShout("injured"));
            }
        }
    }

    private void shout(int ms, Combat c, boolean won, boolean lost) {
        this.shoutCooldown -= ms;
        this.initialShoutCooldown -= ms;
        this.shoutMs -= ms;
        this.fallingTime = this.ship.getySpeed() > 0.3 ? (this.fallingTime += ms) : 0;
        if (this.shoutMs <= 0) {
            boolean isCaptain;
            this.shout = null;
            this.shoutMs = 160;
            Module jobM = this.job == null ? null : this.job.module();
            boolean bl = isCaptain = this.job != null && this.job.isCaptain();
            if (this.ship.braking > 0 && isCaptain) {
                this.doShout(this.pickShout("braking"));
            } else if (this.currentTile.module == jobM && this.currentTile.module.type.hasLift() && this.currentTile.module.type.getCoalReload(BonusSet.empty()) > 0 && this.currentTile.module.msUntilCoal <= 0) {
                this.bigShout(this.pickShout("suspOffline"));
            } else if (this.currentTile.module == jobM && this.currentTile.module.type.getCoalReload(BonusSet.empty()) > 0 && this.currentTile.module.msUntilCoal > 0 && this.currentTile.module.msUntilCoal <= StrictMath.max(500, this.currentTile.module.type.getCoalReload(BonusSet.empty()) / 20)) {
                this.bigShout(this.pickShout("needCoal"));
            } else if (isCaptain && !this.ship.footingLossReported && this.ship.reportFootingLoss && this.initialShoutCooldown <= 0) {
                this.ship.footingLossReported = true;
                this.doShout(this.pickShout("footingLoss"));
            } else if (this.shoutCooldown <= 0) {
                if (this.hp < this.type.minWorkingHP && this.hp > 0) {
                    this.doShout(this.pickShout("injured"));
                } else if (this.currentTile.module.fire > 0) {
                    if (this.currentTile.module.type.getExplodeHP(this.currentTile.module.ship.currentBonuses) > 0 && this.currentTile.module.hp < this.currentTile.module.type.getExplodeHP(this.currentTile.module.ship.currentBonuses) * this.currentTile.module.maxHP / this.currentTile.module.type.getHp(this.currentTile.module.ship.currentBonuses)) {
                        this.bigShout(this.pickShout("aboutToExplode"));
                    } else {
                        this.doShout(this.pickShout("fire"));
                    }
                } else if (isCaptain && this.ship.ramming && !this.ship.ramOrderSpoken) {
                    this.ship.ramOrderSpoken = true;
                    this.doShout(this.pickShout("ramming"));
                } else if (isCaptain && this.ship.fireMode == FireMode.HOLD && !this.ship.fireOrderSpoken) {
                    this.ship.fireOrderSpoken = true;
                    this.doShout(this.pickShout("holdFire"));
                } else if (isCaptain && this.ship.fireMode == FireMode.AIMED && !this.ship.fireOrderSpoken) {
                    this.ship.fireOrderSpoken = true;
                    this.doShout(this.pickShout("aimedFire"));
                } else if (isCaptain && this.ship.fireMode == FireMode.RAPID && !this.ship.fireOrderSpoken) {
                    this.ship.fireOrderSpoken = true;
                    this.doShout(this.pickShout("rapidFire"));
                } else if (this.currentTile.module == jobM && this.currentTile.module.type.getClip(this.currentTile.module.ship.currentBonuses) > 1 && this.currentTile.module.ammoLeft == 0 && this.ship.getTotalResource(Resource.AMMO) > 0) {
                    this.doShout(this.pickShout("needAmmo"));
                } else if (this.currentTile.module.hp < this.currentTile.module.maxHP / 2 && !this.currentTile.module.damageReported) {
                    this.currentTile.module.damageReported = true;
                    this.doShout(this.pickShout("damageReport"));
                } else if (this.currentTile.armour.hp <= 0 && !this.currentTile.armour.window && this.currentTile.armour.type != ArmourType.ofName("NONE") && !this.currentTile.module.armourDamageReported && this.currentTile.module.type != ModuleType.ofName("CORRIDOR")) {
                    this.currentTile.module.armourDamageReported = true;
                    this.doShout(this.pickShout("hullBreach"));
                } else if (this.fallingTime > 500) {
                    this.doShout(this.pickShout("falling"));
                } else if (!this.occupied && won && AGame.ANIM_R.nextInt(80) == 0) {
                    this.doShout(this.pickShout("victory"));
                } else if (!this.occupied && lost && AGame.ANIM_R.nextInt(80) == 0) {
                    this.doShout(this.pickShout("defeat"));
                } else if (!this.ship.boarders.isEmpty()) {
                    int bsz = this.ship.boarders.size();
                    for (int bi = 0; bi < bsz; ++bi) {
                        if (!this.ship.boarders.get(bi).active() || this.ship.boarders.get((int)bi).currentTile.module != this.currentTile.module) continue;
                        this.doShout(this.pickShout("boarders"));
                        break;
                    }
                }
            }
        }
    }

    public void hurt(Shot shot, int harm, Combat c, boolean onViewingSide) {
        int cy;
        int cx;
        boolean alive = this.alive();
        this.hp = StrictMath.max(0, this.hp - harm);
        if (shot != null && shot.sX < shot.tX) {
            this.anim.animate(AnimationType.SHOT_FROM_LEFT, null);
        } else {
            this.anim.animate(AnimationType.SHOT_FROM_RIGHT, null);
        }
        if (this.ship != null && this.currentTile != null) {
            cx = this.ship.getIntX() + this.ship.gridXToWorldX(this.currentTile.x, 1) * 16 + 8;
            cy = this.ship.getIntY() + this.currentTile.y * 16 + 8;
        } else if (this.boardingShip != null && this.currentTile != null) {
            cx = this.boardingShip.getIntX() + this.boardingShip.gridXToWorldX(this.currentTile.x, 1) * 16 + 8;
            cy = this.boardingShip.getIntY() + this.currentTile.y * 16 + 8;
        } else {
            cx = (int)(this.getX() + this.getBBWidth() / 2.0);
            cy = (int)(this.getY() + this.getBBHeight() / 2.0);
        }
        if (alive && !this.alive() && this.type.deathSnd != null) {
            if (this.ship != null) {
                c.play(this.type.deathSnd, cx, cy, this.ship.getxSpeed(), this.ship.getySpeed(), onViewingSide);
            } else if (this.boardingShip != null) {
                c.play(this.type.deathSnd, cx, cy, this.boardingShip.getxSpeed(), this.boardingShip.getySpeed(), onViewingSide);
            } else {
                c.play(this.type.deathSnd, cx, cy, this.dx, this.dy, onViewingSide);
            }
        }
        if (alive && !this.alive() && shot != null && shot.shooterType != null && (this.ship != null || this.boardingShip != null)) {
            c.exceptionalCombatEvents.add(new ExceptionalCombatEvent("killedBy " + shot.shooterType.name, this.boardingShip != null ? c.otherSide(c.sideOf(this.boardingShip)) : c.sideOf(this.ship), cx, cy, this.type, this.boardingShip != null ? this.boardingShip : this.ship));
        }
        if (this.alive() && harm > 0) {
            this.shout("hit");
        }
        if ((this.ship != null || this.boardingShip != null) && this.type.bloodParticle != null) {
            int parts = StrictMath.min(10, harm * 4);
            for (int i = 0; i < parts; ++i) {
                c.particles.add(new Particle(this.type.bloodParticle, cx, cy));
            }
        } else if (this.type.bloodParticleExternal != null) {
            int parts = StrictMath.min(10, harm * 4);
            for (int i = 0; i < parts; ++i) {
                c.particles.add(new Particle(this.type.bloodParticleExternal, cx, cy));
            }
        }
        if (alive && !this.alive() && this.type.explosionSize > 0.0 && !this.type.crashesOnDeath) {
            this.explode(c, cx, cy, onViewingSide);
        }
    }

    public void explode(Combat c, double explodeX, double explodeY, boolean onViewingSide) {
        int i;
        int n = (int)(12.0 * this.type.explosionSize);
        c.blasts.add(new Blast(explodeX, explodeY, this.type.explosionSize * 15.0, this.type.explosionSize * 10.0));
        int parts = 8;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("explode_backs"), explodeX, explodeY, this.type.explosionSize));
        }
        parts = this.type.explosionSize > 0.5 ? 1 : 0;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("shockwave"), explodeX, explodeY, this.type.explosionSize));
        }
        parts = n;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("small_soot"), explodeX, explodeY));
            c.particles.add(new Particle(ParticleType.ofName("large_soot"), explodeX, explodeY));
        }
        if (!SimplePref.REDUCED_FLASHING.get()) {
            parts = 1;
            for (i = 0; i < parts; ++i) {
                c.particles.add(new Particle(ParticleType.ofName("explode"), explodeX, explodeY, this.type.explosionSize));
            }
        }
        parts = 12;
        for (i = 0; i < parts; ++i) {
            c.particles.add(new Particle(ParticleType.ofName("explode_bits"), explodeX, explodeY, this.type.explosionSize));
        }
        if (this.type.explosionSize <= 0.5) {
            c.play(MiscCombatSound.SMALL_SHOT_EXPLOSION, explodeX, explodeY, 0.0, 0.0, onViewingSide);
        } else {
            c.play(MiscCombatSound.SHOT_EXPLOSION, explodeX, explodeY, 0.0, 0.0, onViewingSide);
        }
    }

    public Crewman hit(Shot shot, Combat c, boolean onViewingSide) {
        if (shot.tX < this.getX() || shot.tY < this.getY() || shot.tX > this.getX() + this.getBBWidth() || shot.tY > this.getY() + this.getBBHeight()) {
            return null;
        }
        this.hurt(shot, shot.getPenDmg() + shot.getBlastDmg() + shot.getDirectDmg(), c, onViewingSide);
        return this;
    }
}

