/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.catengine.Img;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class CrewFrameAnimation {
    public final Img[] frames;
    public final int interval;
    public final int dx;
    public final int dy;
    public final boolean loop;

    public CrewFrameAnimation(JSONObject o) {
        this.interval = o.optInt("interval", 160);
        this.dx = o.optInt("dx", 0);
        this.dy = o.optInt("dy", 0);
        this.loop = o.optBoolean("loop", true);
        JSONArray framesA = o.getJSONArray("frames");
        this.frames = new Img[framesA.length()];
        String src = o.getString("src");
        for (int i = 0; i < this.frames.length; ++i) {
            JSONObject fo = framesA.getJSONObject(i);
            this.frames[i] = new Img(src, fo.getInt("x"), fo.getInt("y"), fo.getInt("w"), fo.getInt("h"), fo.optBoolean("flipped", false));
        }
    }

    public int getLengthOr0IfLooping() {
        return this.loop ? 0 : this.interval * this.frames.length;
    }
}

