/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AnimationAppearance;
import com.zarkonnen.airships.AnimationBundle;
import com.zarkonnen.airships.AnimationType;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CrewFrameAnimation;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Loadable;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.RotatingColoringShader;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import java.util.HashSet;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;

public strictfp class CrewAnimator {
    public Crewman cm;
    public int time;
    public int ticksSinceClimb;
    public int ticksFalling = 0;
    public AnimationType prevAnimation = AnimationType.STANDING;
    public int variant = -1;
    public AnimationType specialAnim;
    public int specialDuration;
    public Resource specialResource;
    public boolean lastFlipped;
    public transient int animOffset = AGame.ANIM_R.nextInt(20000);
    private final AnimationType[] r_anim = new AnimationType[1];
    private final Resource[] r_carrying = new Resource[1];

    public CrewAnimator(Crewman cm) {
        this.cm = cm;
    }

    public void tick(int ms, Combat c, double x, double y, boolean flipped) {
        if (this.variant == -1) {
            this.variant = AGame.ANIM_R.nextInt(this.cm.type.animLooks.length);
        }
        this.time += ms;
        this.specialDuration -= ms;
        ++this.ticksSinceClimb;
        if (c != null) {
            if (this.cm.alive()) {
                this.determineAnimation(this.r_anim, this.r_carrying, flipped);
            }
            AnimationAppearance look = this.cm.type.animLooks[this.variant];
            if (look.bundle != null) {
                AnimationBundle.Animation anim = this.cm.type.animLooks[this.variant].bundle.animations.get((Object)this.r_anim[0]);
                if (anim == null) {
                    anim = this.cm.type.animLooks[this.variant].bundle.animations.get((Object)AnimationType.STANDING);
                }
                if (anim == null && (this.r_anim[0] == AnimationType.FLY_DEAD_LEFT || this.r_anim[0] == AnimationType.FLY_INJURED_LEFT)) {
                    anim = this.cm.type.animLooks[this.variant].bundle.animations.get((Object)AnimationType.FLY_LEFT);
                }
                if (anim == null && (this.r_anim[0] == AnimationType.FLY_DEAD_RIGHT || this.r_anim[0] == AnimationType.FLY_INJURED_RIGHT)) {
                    anim = this.cm.type.animLooks[this.variant].bundle.animations.get((Object)AnimationType.FLY_RIGHT);
                }
                if (anim == null) {
                    anim = this.cm.type.animLooks[this.variant].bundle.animations.get((Object)AnimationType.STANDING);
                }
                if (anim == null) {
                    System.err.println("Unable to find animation " + (Object)((Object)this.r_anim[0]) + " for crewType " + this.cm.type.name + ".");
                    return;
                }
                for (int bodyPartIndex = 0; bodyPartIndex < anim.parts.length; ++bodyPartIndex) {
                    ArrayList<AnimationAppearance.BodyPartEmitter> ems = (this.cm.alive() ? look.emitters : look.deadEmitters).get((Object)anim.side)[bodyPartIndex];
                    if (ems == null) continue;
                    for (int emI = 0; emI < ems.size(); ++emI) {
                        AnimationBundle.Animation.Part p;
                        AnimationAppearance.BodyPartEmitter em = ems.get(emI);
                        if (!(AGame.ANIM_R.nextDouble() < em.freq * (double)ms) || (p = anim.parts[bodyPartIndex]) == null) continue;
                        double px = x + p.x + StrictMath.cos(Math.PI * 2 * ((double)this.time + p.rotationOffset) / p.rotationPeriod) * p.rotationWidth;
                        double py = y + p.y + StrictMath.sin(Math.PI * 2 * ((double)this.time + p.rotationOffset) / p.rotationPeriod) * p.rotationHeight;
                        double angle = p.waveStartAngle + (p.waveEndAngle - p.waveStartAngle) * (0.5 - 0.5 * StrictMath.cos(((double)this.time + p.waveOffset) * 2.0 * Math.PI / p.wavePeriod));
                        c.particles.add(new Particle(em.type, px += StrictMath.cos(angle) * em.x - StrictMath.sin(angle) * em.y, py += StrictMath.sin(angle) * em.x + StrictMath.cos(angle) * em.y, em.scale));
                    }
                }
            }
        }
    }

    public void animate(AnimationType anim, Resource res) {
        if (this.variant == -1) {
            this.variant = AGame.ANIM_R.nextInt(this.cm.type.animLooks.length);
        }
        if (this.cm.type.animLooks[this.variant].bundle == null) {
            if (this.cm.type.animLooks[this.variant].frameAnimations.containsKey((Object)anim)) {
                this.time = 0;
                this.specialDuration = this.cm.type.animLooks[this.variant].frameAnimations.get((Object)anim).getLengthOr0IfLooping();
                this.specialAnim = anim;
                this.specialResource = res;
            }
        } else if (this.cm.type.animLooks[this.variant].bundle.animations.containsKey((Object)anim)) {
            this.time = 0;
            this.specialDuration = this.cm.type.animLooks[this.variant].bundle.animations.get((Object)((Object)anim)).length;
            this.specialAnim = anim;
            this.specialResource = res;
        }
    }

    public void continueAnimating(AnimationType anim, Resource res) {
        if (this.specialAnim != anim) {
            this.animate(anim, res);
        }
    }

    public void stopAnimating() {
        this.specialDuration = 0;
        this.specialAnim = null;
        this.specialResource = null;
    }

    private void determineAnimation(AnimationType[] r_anim, Resource[] r_carrying, boolean flipped) {
        AnimationType anim = AnimationType.STANDING;
        Resource carrying = this.cm.carrying;
        if (this.cm.type.canFly && (this.cm.ship == null && this.cm.boardingShip == null || !this.cm.type.canWalk)) {
            anim = this.cm.active() ? (this.cm.ship == null && this.cm.boardingShip == null || !this.cm.type.canWalk ? (this.cm.hp <= this.cm.type.maxHP / 2 ? (this.cm.dx < 0.0 ? AnimationType.FLY_INJURED_LEFT : AnimationType.FLY_INJURED_RIGHT) : (this.cm.dx < 0.0 ? AnimationType.FLY_LEFT : AnimationType.FLY_RIGHT)) : (this.cm.mvDx > 0.001 ? AnimationType.WALK_RIGHT : (this.cm.mvDx < -0.001 ? AnimationType.WALK_LEFT : AnimationType.STANDING))) : (!this.cm.alive() ? (this.cm.dx > 0.001 ? AnimationType.FLY_DEAD_RIGHT : AnimationType.FLY_DEAD_LEFT) : (this.cm.dx > 0.001 ? AnimationType.FLY_INJURED_RIGHT : AnimationType.FLY_INJURED_LEFT));
            r_anim[0] = anim;
            r_carrying[0] = carrying;
            this.prevAnimation = anim;
            return;
        }
        if (this.cm.grabbed) {
            anim = AnimationType.FALL;
        } else if (this.specialDuration > 0) {
            anim = this.specialAnim;
            carrying = this.specialResource;
        } else if (!this.cm.active()) {
            anim = !this.cm.alive() ? AnimationType.DEAD : AnimationType.INJURED;
        } else {
            if (this.cm.injuredCarried != null) {
                carrying = Resource.INJURED;
            }
            if (this.cm.ship == null && this.cm.boardingShip == null) {
                if (this.cm.attachedTo == null) {
                    if (this.cm.dy > 0.4 || this.cm.dy >= 0.0 && StrictMath.abs(this.cm.dx) < 0.01) {
                        ++this.ticksFalling;
                        anim = this.ticksFalling > 5 ? AnimationType.FALL : this.prevAnimation;
                    } else {
                        anim = this.cm.dx < 0.0 ? AnimationType.JUMP_LEFT : AnimationType.JUMP_RIGHT;
                    }
                } else {
                    anim = this.cm.standing ? (this.cm.mvDx > 0.001 ? AnimationType.WALK_RIGHT : (this.cm.mvDx < -0.001 ? AnimationType.WALK_LEFT : AnimationType.STANDING)) : (this.cm.mvDx == 0.0 && this.cm.mvDy == 0.0 ? AnimationType.HANG_IN_THERE : (StrictMath.abs(this.cm.mvDx) > StrictMath.abs(this.cm.mvDy) ? AnimationType.CLIMB_SIDEWAYS : AnimationType.CLIMB));
                }
            } else {
                boolean armed;
                boolean bl = armed = this.cm.boardingShip != null || this.cm.job instanceof Module.FixedGuardJob || this.cm.job instanceof Module.GuardJob || (this.cm.type.canBoard || this.cm.type.doesGuard) && !this.cm.ship.boarders.isEmpty();
                if (this.cm.movingTowards != null) {
                    if (this.cm.movingTowards.y != this.cm.currentTile.y) {
                        anim = AnimationType.CLIMB;
                        this.ticksSinceClimb = 0;
                    } else if (this.ticksSinceClimb < 2) {
                        anim = AnimationType.CLIMB;
                    } else {
                        boolean bl2 = this.lastFlipped = this.cm.movingTowards.x > this.cm.currentTile.x == flipped;
                        anim = armed ? (this.lastFlipped ? AnimationType.WALK_LEFT_ARMED : AnimationType.WALK_RIGHT_ARMED) : (this.lastFlipped ? AnimationType.WALK_LEFT : AnimationType.WALK_RIGHT);
                    }
                } else {
                    anim = this.cm.job != null && this.cm.job instanceof Module.StaffJob ? (flipped ? AnimationType.STANDING_LEFT : AnimationType.STANDING_RIGHT) : (armed ? AnimationType.STANDING_ARMED : AnimationType.STANDING);
                }
            }
        }
        r_anim[0] = anim;
        r_carrying[0] = carrying;
        this.prevAnimation = anim;
    }

    public void draw(Draw d, double x, double y, boolean flipped, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientTint, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, float[][] coaColors) {
        if (this.variant == -1) {
            this.variant = AGame.ANIM_R.nextInt(this.cm.type.animLooks.length);
        }
        this.determineAnimation(this.r_anim, this.r_carrying, flipped);
        CrewAnimator.draw(d, x, y, this.cm.type, this.r_anim[0], this.cm.type.animLooks[this.variant], this.time, this.animOffset, this.r_carrying[0], light, lightStrength, ambient, ambientSaturation, ambientTint, ssb, additionalSSBs, coaColors);
    }

    public static void draw(Draw d, double x, double y, CrewType crewType, AnimationType type, AnimationAppearance animLook, int time, int animOffset, Resource carrying, Image[] light, float lightStrength, Color ambient, float ambientSaturation, Clr ambientTint, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs, float[][] coaColors) {
        Object anim;
        boolean resDrawn = false;
        if (animLook.bundle == null) {
            anim = animLook.frameAnimations.get((Object)type);
            if (anim == null && (type == AnimationType.FLY_DEAD_LEFT || type == AnimationType.FLY_INJURED_LEFT)) {
                anim = animLook.frameAnimations.get((Object)AnimationType.FLY_LEFT);
            }
            if (anim == null && (type == AnimationType.FLY_DEAD_RIGHT || type == AnimationType.FLY_INJURED_RIGHT)) {
                anim = animLook.frameAnimations.get((Object)AnimationType.FLY_RIGHT);
            }
            if (anim == null) {
                anim = animLook.frameAnimations.get((Object)AnimationType.STANDING);
            }
            if (anim == null) {
                System.err.println("Unable to find frame animation " + (Object)((Object)type) + " for crewType " + crewType.name + ".");
                return;
            }
            float[] srcA = crewType == null ? CrewType.NO_COLOUR : crewType.recolorOriginalA;
            float[] srcB = crewType == null ? CrewType.NO_COLOUR : crewType.recolorOriginalB;
            float[] trgA = crewType == null ? srcA : coaColors[crewType.recolorReplacementA.armsColorIndex];
            float[] trgB = crewType == null ? srcB : coaColors[crewType.recolorReplacementB.armsColorIndex];
            int frameIndex = ((CrewFrameAnimation)anim).loop ? (time + animOffset) % (((CrewFrameAnimation)anim).interval * ((CrewFrameAnimation)anim).frames.length) / ((CrewFrameAnimation)anim).interval : StrictMath.min(((CrewFrameAnimation)anim).frames.length - 1, time / ((CrewFrameAnimation)anim).interval);
            Img img = ((CrewFrameAnimation)anim).frames[frameIndex];
            if (ssb != null && !img.src.equals(ssb.name)) {
                if (additionalSSBs != null && Loadable.hasOfName(SpritesheetBundle.class, img.src)) {
                    additionalSSBs.add(SpritesheetBundle.ofName(img.src));
                }
                return;
            }
            double px = x + (double)((CrewFrameAnimation)anim).dx;
            double py = y + (double)((CrewFrameAnimation)anim).dy;
            double angle = 0.0;
            if (img.machineImgCache != null) {
                ((Image)img.machineImgCache).setFilter(9728);
            }
            RotatingColoringShader.draw(SpritesheetBundle.ofName(img.src), img, d, px, py, angle, 1.0, false, light, lightStrength, ambient, ambientSaturation, ambientTint, srcA, trgA, srcB, trgB);
        } else {
            anim = animLook.bundle.animations.get((Object)type);
            if (anim == null && (type == AnimationType.FLY_DEAD_LEFT || type == AnimationType.FLY_INJURED_LEFT)) {
                anim = animLook.bundle.animations.get((Object)AnimationType.FLY_LEFT);
            }
            if (anim == null && (type == AnimationType.FLY_DEAD_RIGHT || type == AnimationType.FLY_INJURED_RIGHT)) {
                anim = animLook.bundle.animations.get((Object)AnimationType.FLY_RIGHT);
            }
            if (anim == null) {
                anim = animLook.bundle.animations.get((Object)AnimationType.STANDING);
            }
            if (anim == null) {
                System.err.println("Unable to find animation " + (Object)((Object)type) + " for crewType " + crewType.name + ".");
                return;
            }
            float[] srcA = crewType == null ? CrewType.NO_COLOUR : crewType.recolorOriginalA;
            float[] srcB = crewType == null ? CrewType.NO_COLOUR : crewType.recolorOriginalB;
            float[] trgA = crewType == null ? srcA : coaColors[crewType.recolorReplacementA.armsColorIndex];
            float[] trgB = crewType == null ? srcB : coaColors[crewType.recolorReplacementB.armsColorIndex];
            for (int i = 0; i < ((AnimationBundle.Animation)anim).parts.length; ++i) {
                AnimationBundle.Animation.Part p = ((AnimationBundle.Animation)anim).parts[i];
                if (p == null || animLook.images.get((Object)((AnimationBundle.Animation)anim).side)[i] == null) continue;
                Img img = animLook.images.get((Object)((AnimationBundle.Animation)anim).side)[i];
                double px = x + p.x + StrictMath.cos(Math.PI * 2 * ((double)time + p.rotationOffset) / p.rotationPeriod) * p.rotationWidth;
                double py = y + p.y + StrictMath.sin(Math.PI * 2 * ((double)time + p.rotationOffset) / p.rotationPeriod) * p.rotationHeight;
                double angle = p.waveStartAngle + (p.waveEndAngle - p.waveStartAngle) * (0.5 - 0.5 * StrictMath.cos(((double)time + p.waveOffset) * 2.0 * Math.PI / p.wavePeriod));
                if (ssb != null && !img.src.equals(ssb.name)) {
                    if (additionalSSBs != null && Loadable.hasOfName(SpritesheetBundle.class, img.src)) {
                        additionalSSBs.add(SpritesheetBundle.ofName(img.src));
                    }
                } else {
                    if (img.machineImgCache != null) {
                        ((Image)img.machineImgCache).setFilter(9728);
                    }
                    RotatingColoringShader.draw(SpritesheetBundle.ofName(img.src), img, d, px, py, angle, 1.0, false, light, lightStrength, ambient, ambientSaturation, ambientTint, srcA, trgA, srcB, trgB);
                }
                if (carrying == null || !p.holdsResource) continue;
                if (ssb != null && carrying.carryApp.spritesheetBundle != ssb) {
                    if (additionalSSBs != null) {
                        additionalSSBs.add(carrying.carryApp.spritesheetBundle);
                    }
                } else {
                    double endX = px + (double)(img.srcWidth / 2) - StrictMath.sin(angle) * (double)img.srcHeight / 2.0;
                    double endY = py + (double)(img.srcHeight / 2) + StrictMath.cos(angle) * (double)img.srcHeight / 2.0;
                    RotatingColoringShader.draw(SpritesheetBundle.ofName(carrying.carryApp.frames.get((int)0).src), carrying.carryApp.frames.get(0), d, endX - 12.0, endY - 9.0, 0.0, 1.0, false, light, lightStrength, ambient, ambientSaturation, ambientTint, CrewType.NO_COLOUR, CrewType.NO_COLOUR, CrewType.NO_COLOUR, CrewType.NO_COLOUR);
                }
                resDrawn = true;
            }
        }
        if (!resDrawn && carrying != null) {
            if (ssb != null && carrying.carryApp.spritesheetBundle != ssb) {
                if (additionalSSBs != null) {
                    additionalSSBs.add(carrying.carryApp.spritesheetBundle);
                }
            } else {
                Img img = carrying.carryApp.frames.get(0);
                RotatingColoringShader.draw(SpritesheetBundle.ofName(img.src), img, d, x - 10.0, y - 5.0, 0.0, 1.0, false, light, lightStrength, ambient, ambientSaturation, ambientTint, CrewType.NO_COLOUR, CrewType.NO_COLOUR, CrewType.NO_COLOUR, CrewType.NO_COLOUR);
            }
        }
    }
}

