/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Compression {
    public static void main(String[] args) throws IOException {
        String s = Compression.decompressFromString(FileUtils.readFileToString((File)new File(args[0])));
        if (s.startsWith("[")) {
            FileUtils.write((File)new File(args[1]), (CharSequence)new JSONArray(s).toString(4));
        } else if (s.startsWith("{")) {
            FileUtils.write((File)new File(args[1]), (CharSequence)new JSONObject(s).toString(4));
        } else {
            FileUtils.write((File)new File(args[1]), (CharSequence)s);
        }
    }

    public static String compressToString(String s) {
        try {
            return Base64.encodeBase64String(Compression.compress(s.getBytes("UTF-8"))).replace("\n", "");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decompressFromString(String s) {
        try {
            return new String(Compression.decompress(Base64.decodeBase64(s)), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] compress(byte[] data) {
        try {
            Deflater deflater = new Deflater();
            deflater.setInput(data);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
            deflater.finish();
            byte[] buffer = new byte[1024];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
            byte[] output = outputStream.toByteArray();
            return output;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decompress(byte[] data) {
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(data);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
            byte[] buffer = new byte[1024];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
            byte[] output = outputStream.toByteArray();
            return output;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

