/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.BoardCommandTool;
import com.zarkonnen.airships.ChallengeCombatIntent;
import com.zarkonnen.airships.ChallengeInfoFloat;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.FireMode;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Keys;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MoveCommandTool;
import com.zarkonnen.airships.MoveTroopsTool;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaybackIntent;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.TargetCommandTool;
import com.zarkonnen.airships.TetherCommandTool;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public strictfp class CommandButtonsPanel
implements UniScreen.InfoPanel {
    public String commandTooltip = null;
    public String nextTooltip = null;
    public int panelW;
    public int panelH;
    public int panelX;
    private static final Clr COA_BORDER = Clr.fromHex((String)"f5edb5");
    private final Img TOP = new Img("ui", 125, 915, 54, 30, false);
    private int moveInH = 100000;
    private int time = 0;
    public static final Clr COOLDOWN = new Clr(255, 255, 255, 80);
    private final Img MOVE = new Img("ui", 0, 416, 16, 16, false);
    private final Img RAM = new Img("ui", 368, 416, 16, 16, false);
    private final Img GROUND = new Img("ui", 16, 416, 16, 16, false);
    private final Img FIREFIGHT = new Img("ui", 32, 416, 16, 16, false);
    private final Img REPAIR = new Img("ui", 48, 416, 16, 16, false);
    private final Img MOVEFOCUS = new Img("ui", 224, 416, 16, 16, false);
    private final Img SHOOT = new Img("ui", 64, 416, 16, 16, false);
    private final Img HOLD_F = new Img("ui", 96, 512, 16, 16, false);
    private final Img AIMED_F = new Img("ui", 80, 416, 16, 16, false);
    private final Img NORMAL_F = new Img("ui", 96, 416, 16, 16, false);
    private final Img RAPID_F = new Img("ui", 112, 416, 16, 16, false);
    private final Img TARGET = new Img("ui", 128, 416, 16, 16, false);
    private final Img BOARD = new Img("ui", 240, 416, 16, 16, false);
    private final Img MOVE_TROOPS = new Img("ui", 384, 416, 16, 16, false);
    private final Img ABANDON = new Img("ui", 400, 416, 16, 16, false);
    private final Img TETHER = new Img("ui", 448, 416, 16, 16, false);
    private final Img CUT_TETHER = new Img("ui", 464, 416, 16, 16, false);

    private void tooltipHook(MyDraw d, int x, int y, final String key, final String shortcut) {
        d.hook(x, y, MyDraw.ICON_BUTTON_SZ, MyDraw.ICON_BUTTON_SZ, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

            public void run(Input in, Pt p, Hook.Type type) {
                CommandButtonsPanel.this.nextTooltip = CommandButtonsPanel.cmdTooltip(key, shortcut);
            }
        });
    }

    private void shortcutHint(MyDraw d, int x, int y, String s) {
        if (this.commandTooltip == null) {
            d.text(MyDraw.SELECTED_C + s, AGame.FOUNT, x + MyDraw.BUTTON_H / 2 - (int)d.textSize((String)s, (Fount)AGame.FOUNT).x / 2 - 1, y + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING);
        }
    }

    public static String cmdTooltip(String key, String shortcut) {
        String v = Lang._t(key, new Object[0]);
        v = shortcut != null ? (v.contains(shortcut) ? "[ffffff]" + v.substring(0, v.indexOf(shortcut)) + "[ba872f]" + shortcut + "[ffffff]" + v.substring(v.indexOf(shortcut) + 1) : (v.contains(shortcut.toLowerCase(Locale.ENGLISH)) ? "[ffffff]" + v.substring(0, v.indexOf(shortcut.toLowerCase(Locale.ENGLISH))) + "[ba872f]" + shortcut.toLowerCase(Locale.ENGLISH) + "[ffffff]" + v.substring(v.indexOf(shortcut.toLowerCase(Locale.ENGLISH)) + 1) : "[ffffff]" + v + " ([ba872f]" + shortcut + "[ffffff])")) : "[ffffff]" + v;
        return v;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, final UniScreen us) {
        if (!(us.intent instanceof CombatIntent) || us.intent instanceof PlaybackIntent) {
            return;
        }
        if (us.intent instanceof CombatIntent && ((CombatIntent)us.intent).spectate()) {
            return;
        }
        if (us.hideUI) {
            return;
        }
        if (us.combat.startCountdown > 0) {
            return;
        }
        ChallengeInfoFloat cif = us.findFloat(ChallengeInfoFloat.class);
        cif.moveButtonRect.x = -100;
        cif.moveButtonRect.y = -100;
        cif.boardButtonRect.x = -100;
        cif.boardButtonRect.y = -100;
        final List<Airship> ships = us.selectedShip != null ? Collections.singletonList(us.selectedShip) : us.selectedShips;
        ShipType shipType = null;
        boolean anyShipsUnderCommand = false;
        boolean anyShipsReady = false;
        boolean allShipsReady = true;
        boolean anyShipsMobile = false;
        boolean allShipsOnGround = true;
        boolean canAbandonAnyShips = false;
        boolean anyShipsCanBoard = false;
        boolean anyShipsCoolingDown = false;
        boolean allShipsCoolingDown = true;
        boolean anyShipsCanShoot = false;
        boolean allFocusOnFirefighting = true;
        boolean allFocusOnRepair = true;
        boolean allFocusOnMoving = true;
        boolean allFocusOnShooting = true;
        boolean allFireModeHold = true;
        boolean allFireModeAimed = true;
        boolean allFireModeNormal = true;
        boolean allFireModeRapid = true;
        boolean anyCanFirefight = false;
        boolean anyCanRepair = false;
        boolean anyCanMove = false;
        boolean anyCanTether = false;
        boolean anyCanCutTether = false;
        int cooldown = 0;
        for (Airship s : ships) {
            int i;
            int msz;
            if (s.type.mobile) {
                anyShipsMobile = true;
            }
            if (!s.type.onGround) {
                allShipsOnGround = false;
            }
            if (s.commandPointsGenerated() <= 0) continue;
            anyShipsUnderCommand = true;
            allFocusOnFirefighting &= s.focusOnFirefighting;
            allFocusOnRepair &= s.focusOnRepair;
            allFocusOnMoving &= s.focusOnMoving;
            allFocusOnShooting &= s.focusOnShooting;
            allFireModeHold &= s.fireMode == FireMode.HOLD;
            allFireModeAimed &= s.fireMode == FireMode.AIMED;
            allFireModeNormal &= s.fireMode == FireMode.NORMAL;
            allFireModeRapid &= s.fireMode == FireMode.RAPID;
            anyCanFirefight |= s.canFirefight();
            anyCanRepair |= s.canRepair();
            anyCanMove |= s.getPropulsion() > 0.0;
            if (shipType == null) {
                shipType = s.type;
            } else if (shipType != s.type) {
                shipType = ShipType.AIRSHIP;
            }
            if (us.combat.canAbandonShip(s)) {
                canAbandonAnyShips = true;
            }
            if (BoardCommandTool.canBoard(s, us.mySide)) {
                anyShipsCanBoard = true;
            }
            if (!anyCanTether) {
                msz = s.modules.size();
                for (i = 0; i < msz; ++i) {
                    if (s.modules.get((int)i).type.getTetherSpec(s.currentBonuses) == null) continue;
                    anyCanTether = true;
                    break;
                }
            }
            if (!anyCanCutTether) {
                msz = s.modules.size();
                for (i = 0; i < msz; ++i) {
                    if (s.modules.get((int)i).tether == null) continue;
                    anyCanCutTether = true;
                    break;
                }
            }
            if (s.canShoot()) {
                anyShipsCanShoot = true;
            }
            if (s.readyForCommand()) {
                anyShipsReady = true;
                allShipsCoolingDown = false;
                continue;
            }
            allShipsReady = false;
            if (s.commandPointsGenerated() <= 0) continue;
            anyShipsCoolingDown = true;
            cooldown = StrictMath.max(cooldown, MyDraw.BUTTON_H - MyDraw.BUTTON_H * s.commandPoints / s.commandPointsRequired());
        }
        allShipsReady &= anyShipsReady;
        int w = 72 + MyDraw.UI_SPACING + 17 * MyDraw.BUTTON_H + 13 * MyDraw.BUTTON_SPACING + 2 * MyDraw.UI_SPACING + 2 * MyDraw.WINDOW_INSET;
        int x = sm.width / 2 - w / 2;
        int h = StrictMath.max(82, AGame.BIG_FOUNT.height * 2 + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING + AGame.FOUNT.height + MyDraw.BUTTON_SPACING) + MyDraw.WINDOW_INSET + MyDraw.UI_SPACING;
        int y = this.moveInH;
        this.panelW = w;
        this.panelH = h;
        this.panelX = x;
        d.drawWindow(x, y, w, h + MyDraw.WINDOW_INSET + 5);
        d.blit(this.TOP, x + w / 2 - this.TOP.srcWidth / 2, y - this.TOP.srcHeight);
        us.mySide.arms.layout.drawShield(us.mySide.arms, d, x += MyDraw.WINDOW_INSET, y += MyDraw.WINDOW_INSET, 2.0, COA_BORDER);
        x += 72 + MyDraw.UI_SPACING;
        if (us.selectedLF != null || !anyShipsUnderCommand) {
            if (us.selectedLF != null) {
                d.text(us.selectedLF.isImmobile() ? Lang._t("Ground", new Object[0]) : Lang._t("Floating_rock", new Object[0]), AGame.BIG_FOUNT, x, y);
            } else if (us.selectedShip != null) {
                d.text(us.selectedShip.getName(), AGame.BIG_FOUNT, x, y);
            }
            y += AGame.BIG_FOUNT.height;
            if (us.tool instanceof MoveTroopsTool) {
                d.button(x, y, d.bw(Lang._t("Cancel", new Object[0])), Lang._t("Cancel", new Object[0]), Keys.get("cancel_move_troops", "C"), new Runnable(){

                    @Override
                    public void run() {
                        us.tool = UniScreen.NAVIGATE;
                    }
                });
            }
            int nco = 0;
            for (Crewman cm : us.mySide.troops) {
                if (cm.attachedTo != us.selectedLF) continue;
                ++nco;
            }
            if (this.commandTooltip != null) {
                d.text(this.commandTooltip, AGame.BIG_FOUNT, x, y + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING);
            } else if (nco == 0) {
                d.text(Lang._t("Not_under_command", new Object[0]), AGame.FOUNT, x, y + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING * 2 + AGame.FOUNT.height);
            } else {
                d.text(Lang._t("Crew_", new Object[0]) + nco, AGame.FOUNT, x, y + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING * 2 + AGame.FOUNT.height);
            }
            if (us.tool == UniScreen.NAVIGATE) {
                d.iconButton(x, y, this.MOVE_TROOPS, new Runnable(){

                    @Override
                    public void run() {
                        us.tool = new MoveTroopsTool();
                    }
                }, nco > 0);
                this.tooltipHook(d, x, y, "Move_troops_", Keys.get("move_troops", "M"));
                x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            }
        }
        if (anyShipsUnderCommand) {
            if (ships.size() == 1) {
                d.text(us.selectedShip.getName(), AGame.BIG_FOUNT, x, y);
            } else {
                d.text(Lang._t("x_units", ships.size()), AGame.BIG_FOUNT, x, y);
            }
            y += AGame.BIG_FOUNT.height;
            if (us.tool != UniScreen.NAVIGATE) {
                d.text(us.tool.getLabel(), AGame.BIG_FOUNT, x, y);
                d.button(x, y += AGame.BIG_FOUNT.height, d.bw(Lang._t("Cancel", new Object[0]), "ESCAPE"), Lang._t("Cancel", new Object[0]), "ESCAPE", new Runnable(){

                    @Override
                    public void run() {
                        us.tool = UniScreen.NAVIGATE;
                    }
                });
            }
            if (us.tool instanceof MoveCommandTool) {
                int mx = x + d.bw(Lang._t("Cancel", new Object[0]), "ESCAPE") + MyDraw.BUTTON_SPACING;
                final MoveCommandTool mct = (MoveCommandTool)us.tool;
                int bw = d.bw(Lang._t("Flip", new Object[0]));
                d.button(mx, y, bw, Lang._t("Flip", new Object[0]), Keys.get("move_tool_flip", "F"), new Runnable(){

                    @Override
                    public void run() {
                        mct.flipFromCurrent = !mct.flipFromCurrent;
                    }
                });
                if (!(us.intent instanceof ChallengeCombatIntent) && mct.flipFromCurrent) {
                    bw = d.tw(Lang._t("movemode_" + Airship.MoveMode.FLIP_THEN_MOVE.name(), new Object[0]));
                    d.toggle(mx, y += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, bw, Lang._t("movemode_" + Airship.MoveMode.FLIP_THEN_MOVE.name(), new Object[0]), Keys.get("move_tool_flip_then_move", "G"), new InputRunnable(){

                        @Override
                        public void run(Input in) {
                            mct.mode = mct.mode == Airship.MoveMode.FLIP_THEN_MOVE ? Airship.MoveMode.DEFAULT : Airship.MoveMode.FLIP_THEN_MOVE;
                        }
                    }, mct.mode == Airship.MoveMode.FLIP_THEN_MOVE, true);
                    mx += bw + MyDraw.BUTTON_SPACING;
                    bw = d.tw(Lang._t("movemode_" + Airship.MoveMode.MOVE_THEN_FLIP.name(), new Object[0]));
                    d.toggle(mx, y, bw, Lang._t("movemode_" + Airship.MoveMode.MOVE_THEN_FLIP.name(), new Object[0]), Keys.get("move_tool_move_then_flip", "H"), new InputRunnable(){

                        @Override
                        public void run(Input in) {
                            mct.mode = mct.mode == Airship.MoveMode.MOVE_THEN_FLIP ? Airship.MoveMode.DEFAULT : Airship.MoveMode.MOVE_THEN_FLIP;
                        }
                    }, mct.mode == Airship.MoveMode.MOVE_THEN_FLIP, true);
                }
            }
            if (us.tool != UniScreen.NAVIGATE) {
                return;
            }
            if (this.commandTooltip != null) {
                d.text(this.commandTooltip, AGame.BIG_FOUNT, x, y + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING);
            } else if (ships.size() == 1) {
                boolean showWater;
                boolean showCoal;
                boolean showAmmo;
                Airship ship = ships.get(0);
                int availableW = w - 72 - MyDraw.UI_SPACING - MyDraw.WINDOW_INSET * 2;
                int colW = (availableW - MyDraw.UI_SPACING) / 2;
                boolean repairPlaced = false;
                String crew = Lang._t("Crew_", new Object[0]);
                String crewInfo = ship.getActiveCrewCount() + "/" + ship.getOriginalAllQuartered();
                int crewValue = ship.getActiveCrewCount();
                int crewMax = ship.getOriginalAllQuartered();
                Clr crewClr = new Clr(110, 149, 17);
                String ammo = Lang._t("Ammo_", new Object[0]);
                String ammoInfo = ship.getTotalResource(Resource.AMMO) + "/" + ship.getOriginalAmmoCapacity();
                int ammoValue = ship.getTotalResource(Resource.AMMO);
                int ammoMax = ship.getOriginalAmmoCapacity();
                Clr ammoClr = Airship.AMMO_FG;
                double ammoAmt = 1.0 * (double)ship.getTotalResource(Resource.AMMO) / (double)Math.max(1, ship.getOriginalAmmoCapacity());
                boolean bl = showAmmo = ship.getOriginalAmmoCapacity() > 0;
                if (!repairPlaced && ship.getOriginalAmmoCapacity() == 0 && ship.getRepairCapacity() > 0) {
                    ammo = Lang._t("Repair_supplies_", new Object[0]);
                    ammoInfo = ship.getTotalResource(Resource.REPAIR) + "/" + ship.getOriginalRepairCapacity();
                    ammoValue = ship.getTotalResource(Resource.REPAIR);
                    ammoMax = ship.getOriginalRepairCapacity();
                    ammoAmt = 1.0 * (double)ship.getTotalResource(Resource.REPAIR) / (double)Math.max(1, ship.getOriginalRepairCapacity());
                    ammoClr = Airship.REPAIR_FG;
                    repairPlaced = true;
                    showAmmo = true;
                }
                String coal = Lang._t("Coal_", new Object[0]);
                String coalInfo = ship.getTotalResource(Resource.COAL) + "/" + ship.getOriginalCoalCapacity();
                double coalAmt = 1.0 * (double)ship.getTotalResource(Resource.COAL) / (double)Math.max(1, ship.getOriginalCoalCapacity());
                int coalValue = ship.getTotalResource(Resource.COAL);
                int coalMax = ship.getOriginalCoalCapacity();
                Clr coalClr = Airship.COAL_REAL_FG;
                boolean bl2 = showCoal = ship.getOriginalCoalCapacity() > 0;
                if (!repairPlaced && ship.getOriginalCoalCapacity() == 0 && ship.getOriginalRepairCapacity() > 0) {
                    coal = Lang._t("Repair_supplies_", new Object[0]);
                    coalInfo = ship.getTotalResource(Resource.REPAIR) + "/" + ship.getOriginalRepairCapacity();
                    coalAmt = 1.0 * (double)ship.getTotalResource(Resource.REPAIR) / (double)Math.max(1, ship.getOriginalRepairCapacity());
                    coalValue = ship.getTotalResource(Resource.REPAIR);
                    coalMax = ship.getOriginalRepairCapacity();
                    coalClr = Airship.REPAIR_FG;
                    repairPlaced = true;
                    showCoal = true;
                }
                String water = Lang._t("Water_", new Object[0]);
                String waterInfo = ship.getTotalResource(Resource.WATER) + "/" + ship.getOriginalWaterCapacity();
                double waterAmt = 1.0 * (double)ship.getTotalResource(Resource.WATER) / (double)Math.max(1, ship.getOriginalWaterCapacity());
                int waterValue = ship.getTotalResource(Resource.WATER);
                int waterMax = ship.getOriginalWaterCapacity();
                Clr waterClr = Airship.WATER_FG;
                boolean bl3 = showWater = ship.getOriginalWaterCapacity() > 0;
                if (!repairPlaced && ship.getOriginalWaterCapacity() == 0 && ship.getOriginalRepairCapacity() > 0) {
                    water = Lang._t("Repair_supplies_", new Object[0]);
                    waterInfo = ship.getTotalResource(Resource.REPAIR) + "/" + ship.getOriginalRepairCapacity();
                    waterAmt = 1.0 * (double)ship.getTotalResource(Resource.REPAIR) / (double)Math.max(1, ship.getOriginalRepairCapacity());
                    waterValue = ship.getTotalResource(Resource.REPAIR);
                    waterMax = ship.getOriginalRepairCapacity();
                    waterClr = Airship.REPAIR_FG;
                    showWater = true;
                }
                int textW = (int)Math.max(Math.max(d.textSize((String)crew, (Fount)AGame.FOUNT).x, d.textSize((String)coal, (Fount)AGame.FOUNT).x), Math.max(d.textSize((String)ammo, (Fount)AGame.FOUNT).x, d.textSize((String)water, (Fount)AGame.FOUNT).x));
                int valueW = (int)Math.max(Math.max(d.textSize((String)new StringBuilder().append((String)"").append((int)crewValue).toString(), (Fount)AGame.FOUNT).x, d.textSize((String)new StringBuilder().append((String)"").append((int)coalValue).toString(), (Fount)AGame.FOUNT).x), Math.max(d.textSize((String)new StringBuilder().append((String)"").append((int)ammoValue).toString(), (Fount)AGame.FOUNT).x, d.textSize((String)new StringBuilder().append((String)"").append((int)waterValue).toString(), (Fount)AGame.FOUNT).x));
                int maxW = (int)Math.max(Math.max(d.textSize((String)new StringBuilder().append((String)"").append((int)crewMax).toString(), (Fount)AGame.FOUNT).x, d.textSize((String)new StringBuilder().append((String)"").append((int)coalMax).toString(), (Fount)AGame.FOUNT).x), Math.max(d.textSize((String)new StringBuilder().append((String)"").append((int)ammoMax).toString(), (Fount)AGame.FOUNT).x, d.textSize((String)new StringBuilder().append((String)"").append((int)waterMax).toString(), (Fount)AGame.FOUNT).x));
                int slashW = (int)d.textSize((String)"/", (Fount)AGame.FOUNT).x;
                int barW = colW - textW - valueW - slashW - maxW - MyDraw.BUTTON_SPACING;
                int yy = y + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING * 2 + AGame.FOUNT.height;
                d.text(crew, AGame.FOUNT, x, yy);
                d.text("" + crewValue, AGame.FOUNT, x + textW + valueW - (int)d.textSize((String)new StringBuilder().append((String)"").append((int)crewValue).toString(), (Fount)AGame.FOUNT).x, yy);
                d.text("/", AGame.FOUNT, x + textW + valueW, yy);
                d.text("" + crewMax, AGame.FOUNT, x + textW + valueW + slashW, yy);
                d.progressBar(x + textW + valueW + slashW + maxW + MyDraw.BUTTON_SPACING, yy + MyDraw.BUTTON_SPACING / 2 + 1, barW, AGame.FOUNT.height - MyDraw.BUTTON_SPACING, 1.0 * (double)ship.getActiveCrewCount() / (double)Math.max(1, ship.getOriginalAllQuartered()), crewClr);
                d.tooltip((double)x, (double)yy, (double)colW, (double)AGame.FOUNT.lineHeight, crewInfo);
                if (showAmmo) {
                    d.text(ammo, AGame.FOUNT, x + colW + MyDraw.UI_SPACING, yy);
                    d.text("" + ammoValue, AGame.FOUNT, x + colW + MyDraw.UI_SPACING + textW + valueW - (int)d.textSize((String)new StringBuilder().append((String)"").append((int)ammoValue).toString(), (Fount)AGame.FOUNT).x, yy);
                    d.text("/", AGame.FOUNT, x + colW + MyDraw.UI_SPACING + textW + valueW, yy);
                    d.text("" + ammoMax, AGame.FOUNT, x + colW + MyDraw.UI_SPACING + textW + valueW + slashW, yy);
                    d.progressBar(x + colW + MyDraw.UI_SPACING + textW + valueW + slashW + maxW + MyDraw.BUTTON_SPACING, yy + MyDraw.BUTTON_SPACING / 2 + 1, barW, AGame.FOUNT.height - MyDraw.BUTTON_SPACING, ammoAmt, ammoClr);
                    d.tooltip((double)(x + colW + MyDraw.UI_SPACING), (double)yy, (double)colW, (double)AGame.FOUNT.lineHeight, ammoInfo);
                }
                yy += AGame.FOUNT.lineHeight;
                if (showCoal) {
                    d.text(coal, AGame.FOUNT, x, yy);
                    d.text("" + coalValue, AGame.FOUNT, x + textW + valueW - (int)d.textSize((String)new StringBuilder().append((String)"").append((int)coalValue).toString(), (Fount)AGame.FOUNT).x, yy);
                    d.text("/", AGame.FOUNT, x + textW + valueW, yy);
                    d.text("" + coalMax, AGame.FOUNT, x + textW + valueW + slashW, yy);
                    d.progressBar(x + textW + valueW + slashW + maxW + MyDraw.BUTTON_SPACING, yy + MyDraw.BUTTON_SPACING / 2 + 1, barW, AGame.FOUNT.height - MyDraw.BUTTON_SPACING, coalAmt, coalClr);
                    d.tooltip((double)x, (double)yy, (double)colW, (double)AGame.FOUNT.lineHeight, coalInfo);
                }
                if (showWater) {
                    d.text(water, AGame.FOUNT, x + colW + MyDraw.UI_SPACING, yy);
                    d.text("" + waterValue, AGame.FOUNT, x + colW + MyDraw.UI_SPACING + textW + valueW - (int)d.textSize((String)new StringBuilder().append((String)"").append((int)waterValue).toString(), (Fount)AGame.FOUNT).x, yy);
                    d.text("/", AGame.FOUNT, x + colW + MyDraw.UI_SPACING + textW + valueW, yy);
                    d.text("" + waterMax, AGame.FOUNT, x + colW + MyDraw.UI_SPACING + textW + valueW + slashW, yy);
                    d.progressBar(x + colW + valueW + slashW + maxW + MyDraw.UI_SPACING + textW + MyDraw.BUTTON_SPACING, yy + MyDraw.BUTTON_SPACING / 2 + 1, barW, AGame.FOUNT.height - MyDraw.BUTTON_SPACING, waterAmt, waterClr);
                    d.tooltip((double)(x + colW + MyDraw.UI_SPACING), (double)yy, (double)colW, (double)AGame.FOUNT.lineHeight, waterInfo);
                }
            }
            if (anyShipsMobile) {
                d.iconButton(x, y, this.MOVE, new Runnable(){

                    @Override
                    public void run() {
                        us.tool = new MoveCommandTool(us, false);
                    }
                }, anyShipsReady);
                cif.moveButtonRect.x = x;
                cif.moveButtonRect.y = y;
                cif.moveButtonRect.w = MyDraw.ICON_BUTTON_SZ;
                cif.moveButtonRect.h = MyDraw.ICON_BUTTON_SZ;
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Move_", Keys.get("move_ship", "M"));
                this.shortcutHint(d, x, y, Keys.get("move_ship", "M"));
                x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
                if (!(us.intent instanceof ChallengeCombatIntent)) {
                    d.iconButton(x, y, this.RAM, new Runnable(){

                        @Override
                        public void run() {
                            us.tool = new MoveCommandTool(us, true);
                        }
                    }, anyShipsReady);
                    d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                    this.tooltipHook(d, x, y, "Ram_", Keys.get("ram", "R"));
                    this.shortcutHint(d, x, y, Keys.get("ram", "R"));
                    x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
                    if (!allShipsOnGround) {
                        d.iconButton(x, y, this.GROUND, new Runnable(){

                            @Override
                            public void run() {
                                CommandButtonsPanel.this.groundShip(us.combat, ships);
                            }
                        }, anyShipsReady);
                        d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                        this.tooltipHook(d, x, y, "Ground_ship_", Keys.get("ground_ship", "G"));
                        this.shortcutHint(d, x, y, Keys.get("ground_ship", "G"));
                        x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
                    }
                }
            }
            if (!(us.intent instanceof ChallengeCombatIntent)) {
                if (canAbandonAnyShips) {
                    d.iconButton(x, y, this.ABANDON, new Runnable(){

                        @Override
                        public void run() {
                            CommandButtonsPanel.this.abandonShip(us.combat, ships);
                        }
                    }, anyShipsReady);
                    d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                    this.tooltipHook(d, x, y, "Abandon_" + shipType.name(), null);
                    x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
                }
                d.iconButton(x, y, this.MOVE_TROOPS, new Runnable(){

                    @Override
                    public void run() {
                        us.tool = new BoardCommandTool(true);
                    }
                }, anyShipsReady && canAbandonAnyShips);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Transfer_crew_", Keys.get("transfer_crew", "C"));
                this.shortcutHint(d, x, y, Keys.get("transfer_crew", "C"));
                x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            }
            if (!(us.intent instanceof ChallengeCombatIntent) || ((ChallengeCombatIntent)us.intent).challenge.boardEnabled) {
                d.iconButton(x, y, this.BOARD, new Runnable(){

                    @Override
                    public void run() {
                        us.tool = new BoardCommandTool(false);
                    }
                }, anyShipsReady && anyShipsCanBoard);
                cif.boardButtonRect.x = x;
                cif.boardButtonRect.y = y;
                cif.boardButtonRect.w = MyDraw.ICON_BUTTON_SZ;
                cif.boardButtonRect.h = MyDraw.ICON_BUTTON_SZ;
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Board_ship_", Keys.get("board_ship", "B"));
                this.shortcutHint(d, x, y, Keys.get("board_ship", "B"));
                x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING;
            }
            if (!(us.intent instanceof ChallengeCombatIntent)) {
                d.iconButton(x, y, this.TARGET, new Runnable(){

                    @Override
                    public void run() {
                        us.tool = new TargetCommandTool();
                    }
                }, anyShipsReady && anyShipsCanShoot);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Target_ship_", Keys.get("target_ship", "T"));
                this.shortcutHint(d, x, y, Keys.get("target_ship", "T"));
                d.iconButton(x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, y, this.TETHER, new Runnable(){

                    @Override
                    public void run() {
                        us.tool = new TetherCommandTool();
                    }
                }, anyShipsReady && anyCanTether);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Launch_tether_at_", Keys.get("tether_ship", "J"));
                this.shortcutHint(d, x, y, Keys.get("tether_ship", "J"));
                d.iconButton(x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, y, this.CUT_TETHER, new Runnable(){

                    @Override
                    public void run() {
                        CommandButtonsPanel.this.cutTether(us.combat, ships);
                    }
                }, anyShipsReady && anyCanCutTether);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Cut_tethers", Keys.get("cut_tethers", "K"));
                this.shortcutHint(d, x, y, Keys.get("cut_tethers", "K"));
                d.iconToggle(x += MyDraw.BUTTON_H + MyDraw.UI_SPACING, y, this.FIREFIGHT, new Runnable(){

                    @Override
                    public void run() {
                        CommandButtonsPanel.this.focusOnFirefighting(us.combat, ships);
                    }
                }, allFocusOnFirefighting, anyShipsReady && anyCanFirefight);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Focus_on_firefighting", Keys.get("focus_on_firefighting", "F"));
                this.shortcutHint(d, x, y, Keys.get("focus_on_firefighting", "F"));
                d.iconToggle(x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, y, this.REPAIR, new Runnable(){

                    @Override
                    public void run() {
                        CommandButtonsPanel.this.focusOnRepair(us.combat, ships);
                    }
                }, allFocusOnRepair, anyShipsReady && anyCanRepair);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Focus_on_repair", Keys.get("focus_on_repair", "E"));
                this.shortcutHint(d, x, y, Keys.get("focus_on_repair", "E"));
                d.iconToggle(x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, y, this.MOVEFOCUS, new Runnable(){

                    @Override
                    public void run() {
                        CommandButtonsPanel.this.focusOnMoving(us.combat, ships);
                    }
                }, allFocusOnMoving, anyShipsReady && anyCanMove);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Focus_on_moving", Keys.get("focus_on_moving", "V"));
                this.shortcutHint(d, x, y, Keys.get("focus_on_moving", "V"));
                d.iconToggle(x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, y, this.SHOOT, new Runnable(){

                    @Override
                    public void run() {
                        CommandButtonsPanel.this.focusOnShooting(us.combat, ships);
                    }
                }, allFocusOnShooting, anyShipsReady && anyShipsCanShoot);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Focus_on_shooting", Keys.get("focus_on_shooting", "O"));
                this.shortcutHint(d, x, y, Keys.get("focus_on_shooting", "O"));
                d.iconToggle(x += MyDraw.BUTTON_H + MyDraw.UI_SPACING, y, this.HOLD_F, new Runnable(){

                    @Override
                    public void run() {
                        CommandButtonsPanel.this.fireMode(us.combat, ships, FireMode.HOLD);
                    }
                }, allFireModeHold, anyShipsReady && anyShipsCanShoot);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Hold_fire", Keys.get("hold_fire", "H"));
                this.shortcutHint(d, x, y, Keys.get("hold_fire", "H"));
                d.iconToggle(x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, y, this.AIMED_F, new Runnable(){

                    @Override
                    public void run() {
                        CommandButtonsPanel.this.fireMode(us.combat, ships, FireMode.AIMED);
                    }
                }, allFireModeAimed, anyShipsReady && anyShipsCanShoot);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Aimed_fire", Keys.get("aimed_fire", "I"));
                this.shortcutHint(d, x, y, Keys.get("aimed_fire", "I"));
                d.iconToggle(x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, y, this.NORMAL_F, new Runnable(){

                    @Override
                    public void run() {
                        CommandButtonsPanel.this.fireMode(us.combat, ships, FireMode.NORMAL);
                    }
                }, allFireModeNormal, anyShipsReady && anyShipsCanShoot);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Normal_fire", Keys.get("normal_fire", "N"));
                this.shortcutHint(d, x, y, Keys.get("normal_fire", "N"));
                d.iconToggle(x += MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING, y, this.RAPID_F, new Runnable(){

                    @Override
                    public void run() {
                        CommandButtonsPanel.this.fireMode(us.combat, ships, FireMode.RAPID);
                    }
                }, allFireModeRapid, anyShipsReady && anyShipsCanShoot);
                d.rect(COOLDOWN, x, y + MyDraw.BUTTON_H - cooldown, allShipsCoolingDown ? (double)MyDraw.BUTTON_H : (double)(MyDraw.BUTTON_H / 2), cooldown);
                this.tooltipHook(d, x, y, "Rapid_fire", Keys.get("rapid_fire", "P"));
                this.shortcutHint(d, x, y, Keys.get("rapid_fire", "P"));
            }
        }
    }

    private void focusOnShooting(Combat combat, List<Airship> ships) {
        for (Airship s : ships) {
            if (s.focusOnShooting || !s.readyForCommand()) continue;
            combat.giveCommand(Client.msg("focusOnShooting").put("id", combat.getShipID(s)));
        }
    }

    private void focusOnRepair(Combat combat, List<Airship> ships) {
        for (Airship s : ships) {
            if (s.focusOnRepair || !s.readyForCommand()) continue;
            combat.giveCommand(Client.msg("focusOnRepair").put("id", combat.getShipID(s)));
        }
    }

    private void focusOnFirefighting(Combat combat, List<Airship> ships) {
        for (Airship s : ships) {
            if (s.focusOnFirefighting || !s.readyForCommand()) continue;
            combat.giveCommand(Client.msg("focusOnFirefighting").put("id", combat.getShipID(s)));
        }
    }

    private void focusOnMoving(Combat combat, List<Airship> ships) {
        for (Airship s : ships) {
            if (s.focusOnMoving || !s.readyForCommand()) continue;
            combat.giveCommand(Client.msg("focusOnMoving").put("id", combat.getShipID(s)));
        }
    }

    private void groundShip(Combat combat, List<Airship> ships) {
        for (Airship s : ships) {
            if (s.type.onGround || s.grounding || !s.readyForCommand()) continue;
            combat.giveCommand(Client.msg("ground").put("id", combat.getShipID(s)));
        }
    }

    private void abandonShip(Combat combat, List<Airship> ships) {
        for (Airship s : ships) {
            if (!s.readyForCommand() || !combat.canAbandonShip(s)) continue;
            combat.giveCommand(Client.msg("abandon").put("id", combat.getShipID(s)));
        }
    }

    private void cutTether(Combat combat, List<Airship> ships) {
        block0: for (Airship s : ships) {
            if (!s.readyForCommand()) continue;
            int msz = s.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                if (s.modules.get((int)mi).tether == null) continue;
                combat.giveCommand(Client.msg("cutOwnTethers").put("id", combat.getShipID(s)));
                continue block0;
            }
        }
    }

    private void fireMode(Combat combat, List<Airship> ships, FireMode m) {
        for (Airship s : ships) {
            if (s.fireMode == m || !s.readyForCommand()) continue;
            combat.giveCommand(Client.msg("fireMode").put("id", combat.getShipID(s)).put("value", m.name()));
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        this.commandTooltip = this.nextTooltip;
        this.nextTooltip = null;
        if (!(us.intent instanceof CombatIntent) || us.intent instanceof PlaybackIntent) {
            return;
        }
        if (us.intent instanceof CombatIntent && ((CombatIntent)us.intent).spectate()) {
            return;
        }
        if (us.combat.startCountdown > 0) {
            return;
        }
        if (this.time == 0) {
            in.play("drawer", 1.0, 0.25 * us.g.volume, 0.0, 0.0);
        }
        this.time += ms;
        int h = StrictMath.max(82, AGame.BIG_FOUNT.height * 2 + MyDraw.BUTTON_H + MyDraw.BUTTON_SPACING + AGame.FOUNT.height + MyDraw.BUTTON_SPACING) + MyDraw.WINDOW_INSET + MyDraw.UI_SPACING;
        this.moveInH = in.mode().height - StrictMath.min(h, this.time * 2 / 3);
        List<Airship> ships = us.selectedShip != null ? Collections.singletonList(us.selectedShip) : us.selectedShips;
        boolean anyShipsUnderCommand = false;
        boolean anyShipsMobile = false;
        boolean allShipsOnGround = true;
        boolean canAbandonAnyShips = false;
        boolean anyShipsCanBoard = false;
        boolean anyCanTether = false;
        boolean anyCanCutTether = false;
        block0: for (Airship s : ships) {
            int i;
            int msz;
            if (s.commandPointsGenerated() > 0) {
                anyShipsUnderCommand = true;
            }
            if (!s.readyForCommand()) continue;
            if (s.type.mobile) {
                anyShipsMobile = true;
            }
            if (!s.type.onGround) {
                allShipsOnGround = false;
            }
            if (us.combat.canAbandonShip(s)) {
                canAbandonAnyShips = true;
            }
            if (BoardCommandTool.canBoard(s, us.mySide)) {
                anyShipsCanBoard = true;
            }
            if (!anyCanTether) {
                msz = s.modules.size();
                for (i = 0; i < msz; ++i) {
                    if (s.modules.get((int)i).type.getTetherSpec(s.currentBonuses) == null) continue;
                    anyCanTether = true;
                    break;
                }
            }
            if (anyCanCutTether) continue;
            msz = s.modules.size();
            for (i = 0; i < msz; ++i) {
                if (s.modules.get((int)i).tether == null) continue;
                anyCanCutTether = true;
                continue block0;
            }
        }
        if (us.selectedLF != null || !anyShipsUnderCommand) {
            int nco = 0;
            for (Crewman cm : us.mySide.troops) {
                if (cm.attachedTo != us.selectedLF && cm.attachedTo != us.selectedShip) continue;
                ++nco;
            }
            if (us.tool instanceof MoveTroopsTool) {
                if (in.keyPressed(Keys.get("cancel_move_troops", "C")) || in.keyPressed("ESCAPE")) {
                    us.tool = UniScreen.NAVIGATE;
                }
            } else if (nco > 0 && in.keyPressed(Keys.get("move_troops", "M"))) {
                us.tool = new MoveTroopsTool();
            }
        }
        if (anyShipsUnderCommand) {
            if (us.tool instanceof MoveCommandTool && !us.textInputOccurring()) {
                MoveCommandTool mct = (MoveCommandTool)us.tool;
                if (!(us.intent instanceof ChallengeCombatIntent) && mct.flipFromCurrent) {
                    if (in.keyPressed(Keys.get("move_tool_flip_then_move", "G"))) {
                        mct.mode = Airship.MoveMode.FLIP_THEN_MOVE;
                    }
                    if (in.keyPressed(Keys.get("move_tool_move_then_flip", "H"))) {
                        mct.mode = Airship.MoveMode.MOVE_THEN_FLIP;
                    }
                }
            }
            if (us.tool == UniScreen.NAVIGATE && !us.textInputOccurring()) {
                if (anyShipsMobile) {
                    if (in.keyPressed(Keys.get("move_ship", "M"))) {
                        us.tool = new MoveCommandTool(us, false);
                    }
                    if (!(us.intent instanceof ChallengeCombatIntent)) {
                        if (in.keyPressed(Keys.get("ram", "R"))) {
                            us.tool = new MoveCommandTool(us, true);
                        }
                        if (!allShipsOnGround && in.keyPressed(Keys.get("ground_ship", "G"))) {
                            this.groundShip(us.combat, ships);
                        }
                    }
                }
                if (!(us.intent instanceof ChallengeCombatIntent)) {
                    if (in.keyPressed(Keys.get("target_ship", "T"))) {
                        us.tool = new TargetCommandTool();
                    }
                    if (in.keyPressed(Keys.get("tether_ship", "J")) && anyCanTether) {
                        us.tool = new TetherCommandTool();
                    }
                    if (in.keyPressed(Keys.get("cut_tethers", "K")) && anyCanCutTether) {
                        this.cutTether(us.combat, ships);
                    }
                }
                if ((!(us.intent instanceof ChallengeCombatIntent) || ((ChallengeCombatIntent)us.intent).challenge.boardEnabled) && in.keyPressed(Keys.get("board_ship", "B")) && anyShipsCanBoard) {
                    us.tool = new BoardCommandTool(false);
                }
                if (!(us.intent instanceof ChallengeCombatIntent)) {
                    if (in.keyPressed(Keys.get("transfer_crew", "C"))) {
                        us.tool = new BoardCommandTool(true);
                    }
                    if (in.keyPressed(Keys.get("focus_on_repair", "E"))) {
                        this.focusOnRepair(us.combat, ships);
                    }
                    if (in.keyPressed(Keys.get("focus_on_firefighting", "F"))) {
                        this.focusOnFirefighting(us.combat, ships);
                    }
                    if (in.keyPressed(Keys.get("focus_on_moving", "V"))) {
                        this.focusOnMoving(us.combat, ships);
                    }
                    if (in.keyPressed(Keys.get("focus_on_shooting", "O"))) {
                        this.focusOnShooting(us.combat, ships);
                    }
                    if (in.keyPressed(Keys.get("hold_fire", "H"))) {
                        this.fireMode(us.combat, ships, FireMode.HOLD);
                    }
                    if (in.keyPressed(Keys.get("aimed_fire", "I"))) {
                        this.fireMode(us.combat, ships, FireMode.AIMED);
                    }
                    if (in.keyPressed(Keys.get("normal_fire", "N"))) {
                        this.fireMode(us.combat, ships, FireMode.NORMAL);
                    }
                    if (in.keyPressed(Keys.get("rapid_fire", "P"))) {
                        this.fireMode(us.combat, ships, FireMode.RAPID);
                    }
                }
            }
        }
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

