/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.CombatSound;
import com.zarkonnen.airships.MiscCombatSound;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.SoundEffect;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.Loop;
import com.zarkonnen.catengine.SlickEngine;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.newdawn.slick.openal.SoundStore2;

public strictfp class CombatSoundEffects
implements UniScreen.InfoPanel {
    public ArrayList<SoundEffect.Sound> sounds = new ArrayList();
    public LinkedList<String> soundLog = new LinkedList();
    public HashMap<String, LoopEntry> loops = new HashMap();
    private final ArrayList<SoundEffect.Sound> loopSnd = new ArrayList();
    private final HashSet<String> usedLoopKeys = new HashSet();
    public HashMap<String, ConcreteLoop> concreteLoops = new HashMap();
    private boolean overlayActive = false;
    public static double PAN_STRENGTH = 1.0;
    public static double LISTENER_Z_DIST_RELATIVE_TO_SCREEN_WIDTH = 0.5;
    public static double LOOP_SUM_EXPONENT = 0.5;
    public static double ZOOM_VOLUME_EXPONENT = 2.0;
    private static CombatSoundEffects instance;

    public static void alwaysTick(AirshipGame g, Input in) {
        ((SlickEngine.MyInput)in).setSoundZ((float)LISTENER_Z_DIST_RELATIVE_TO_SCREEN_WIDTH);
        if (instance == null) {
            return;
        }
        if (!(g.s instanceof UniScreen) || ((UniScreen)g.s).overlay(CombatSoundEffects.class) != instance) {
            for (ConcreteLoop l : CombatSoundEffects.instance.concreteLoops.values()) {
                if (l.loop == null) continue;
                l.loop.stop();
                l.loop = null;
            }
            CombatSoundEffects.instance.concreteLoops.clear();
            CombatSoundEffects.instance.loops.clear();
            instance = null;
        }
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, Hooks hs, UniScreen us) {
        if (!this.overlayActive) {
            return;
        }
        int y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        int x = MyDraw.SIDE_CLEARANCE;
        String header = CombatSoundEffects.rPad("Name", 20) + CombatSoundEffects.rPad("Pitch", 6) + CombatSoundEffects.rPad("Vol", 6) + CombatSoundEffects.rPad("Dist", 6) + CombatSoundEffects.rPad("dx", 6) + CombatSoundEffects.rPad("dy", 6) + CombatSoundEffects.rPad("MySide", 8) + CombatSoundEffects.rPad("Str", 6);
        int w = (int)d.textSize((String)header, (Fount)AGame.DEBUG_FOUNT).x + MyDraw.UI_SPACING * 2;
        int h = MyDraw.UI_SPACING * 2 + (this.soundLog.size() + 3) * AGame.DEBUG_FOUNT.height;
        d.rect(new Clr(0, 0, 0, 128), x, y, w, h);
        d.text(SoundStore2.get().getUsedSources() + " / " + SoundStore2.get().getSourceCount() + " sources used", AGame.DEBUG_FOUNT, x += MyDraw.UI_SPACING, y += MyDraw.UI_SPACING);
        d.text(header, AGame.DEBUG_FOUNT, x, y += AGame.DEBUG_FOUNT.height);
        y += AGame.DEBUG_FOUNT.height * 2;
        for (String s : this.soundLog) {
            d.text(s, AGame.DEBUG_FOUNT, x, y);
            y += AGame.DEBUG_FOUNT.height;
        }
        x += w + MyDraw.UI_SPACING;
        y = MyDraw.TOP_BAR_H + MyDraw.UI_SPACING;
        ArrayList<String> keys = new ArrayList<String>(this.loops.keySet());
        Collections.sort(keys);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Merged Loops");
        lines.add(CombatSoundEffects.rPad("Name", 20) + CombatSoundEffects.rPad("x", 6) + CombatSoundEffects.rPad("y", 6) + CombatSoundEffects.rPad("Pitch", 6) + CombatSoundEffects.rPad("Volume", 6));
        for (Map.Entry<String, ConcreteLoop> e : this.concreteLoops.entrySet()) {
            lines.add(CombatSoundEffects.rPad(e.getKey(), 20) + CombatSoundEffects.rPad(e.getValue().x, 6) + CombatSoundEffects.rPad(e.getValue().y, 6) + CombatSoundEffects.rPad(e.getValue().pitch, 6) + CombatSoundEffects.rPad(e.getValue().volume, 6));
        }
        lines.add("");
        lines.add("Individual Loops");
        lines.add(header);
        for (String k : keys) {
            LoopEntry le = this.loops.get(k);
            lines.add(CombatSoundEffects.rPad(k, 20) + CombatSoundEffects.lPad((int)(le.volume() * 100.0) + "%", 5));
            for (int i = 0; i < le.loops.length; ++i) {
                if (le.loops[i] == null) continue;
                lines.add("  " + CombatSoundEffects.rPad(le.soundNames[i], 18) + CombatSoundEffects.rPad(le.lastPitches[i], 6) + CombatSoundEffects.rPad(le.lastVolumes[i], 6) + CombatSoundEffects.rPad((int)le.lastDists[i], 6) + CombatSoundEffects.rPad(le.lastXSpeeds[i], 6) + CombatSoundEffects.rPad(le.lastYSpeeds[i], 6) + CombatSoundEffects.rPad("" + le.lastOnViewingSide[i], 8) + CombatSoundEffects.rPad(le.lastRelativeStrength[i], 6));
            }
        }
        h = MyDraw.UI_SPACING * 2 + lines.size() * AGame.DEBUG_FOUNT.height;
        d.rect(new Clr(0, 0, 0, 128), x, y, w, h);
        x += MyDraw.UI_SPACING;
        y += MyDraw.UI_SPACING;
        for (String s : lines) {
            d.text(s, AGame.DEBUG_FOUNT, x, y);
            y += AGame.DEBUG_FOUNT.height;
        }
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (in.keyPressed("F10")) {
            this.overlayActive = !this.overlayActive;
        }
        CombatSoundEffects.alwaysTick(us.g, in);
        instance = this;
        this.usedLoopKeys.clear();
        if (us.combat != null) {
            Map.Entry<String, Object> e;
            double relativeStrength = 1.0;
            if (us.mySide != null) {
                relativeStrength = (double)(us.mySide.getCachedDanger() + 1) * 1.0 / (double)(us.combat.otherSide(us.mySide).getCachedDanger() + 1);
            }
            ScreenMode sm = in.mode();
            Combat combat = us.combat;
            if (us.mySide != null) {
                int al = us.mySide.ships.size();
                for (int ai = 0; ai < al; ++ai) {
                    Airship as = us.mySide.ships.get(ai);
                    if (!as.readyForCommand() || as.wasReadyForCommand || as.ai != null) continue;
                    combat.play(MiscCombatSound.BELL, (double)as.getIntX() + as.getBBWidth() / 2.0, (double)as.getIntY() + as.getBBHeight() / 2.0, as.getxSpeed(), as.getySpeed(), true);
                    as.wasReadyForCommand = true;
                }
            }
            int csl = combat.sounds.size();
            double listenerX = us.screenToWorldX(sm.width / 2);
            double listenerY = us.screenToWorldY(sm.height / 2);
            double listenerZ = (double)sm.width / us.zoom * LISTENER_Z_DIST_RELATIVE_TO_SCREEN_WIDTH;
            for (int csi = 0; csi < csl; ++csi) {
                ConcreteLoop cl;
                SoundEffect.Sound s;
                int i;
                LoopEntry le;
                CombatSound cs = combat.sounds.get(csi);
                double volume = StrictMath.max(0.5, StrictMath.pow(us.zoom, ZOOM_VOLUME_EXPONENT)) * cs.volume;
                if (volume < 0.01) continue;
                double sx = ((cs.x + (double)us.adjScrollX) * us.zoom / (double)sm.width - 0.5) * PAN_STRENGTH;
                double sy = ((cs.y + (double)us.adjScrollY) * us.zoom / (double)sm.height - 0.5) * PAN_STRENGTH;
                double dist = StrictMath.sqrt((cs.x - listenerX) * (cs.x - listenerX) + (cs.y - listenerY) * (cs.y - listenerY) + listenerZ * listenerZ);
                if (cs.loopKey == null) {
                    cs.effect.emit(this.sounds, sx, sy, volume, dist, cs.xSpeed, cs.ySpeed, cs.own, cs.own ? relativeStrength : 1.0 / relativeStrength);
                    continue;
                }
                if (this.loops.containsKey(cs.loopKey)) {
                    le = this.loops.get(cs.loopKey);
                    le.fadeInMs = cs.effect.loopFadeInMs;
                    le.fadeOutMs = cs.effect.loopFadeOutMs;
                    for (i = 0; i < cs.effect.layers.size(); ++i) {
                        this.loopSnd.clear();
                        cs.effect.layers.get(i).emit(this.loopSnd, sx, sy, volume, dist, cs.xSpeed, cs.ySpeed, cs.own, cs.own ? relativeStrength : 1.0 / relativeStrength);
                        if (this.loopSnd.isEmpty()) {
                            if (le.loops[i] == null) continue;
                            le.loops[i] = null;
                            le.lastVolumes[i] = 0.0;
                            le.lastPitches[i] = 0.0;
                            le.soundNames[i] = null;
                            continue;
                        }
                        s = this.loopSnd.get(0);
                        if (le.loops[i] == null) {
                            if (this.concreteLoops.containsKey(s.name)) {
                                le.loops[i] = this.concreteLoops.get(s.name);
                            } else {
                                cl = new ConcreteLoop();
                                this.concreteLoops.put(s.name, cl);
                                le.loops[i] = cl;
                            }
                            le.soundNames[i] = s.name;
                        }
                        le.lastXs[i] = s.x;
                        le.lastYs[i] = s.y;
                        le.lastVolumes[i] = s.volume;
                        le.lastPitches[i] = s.pitch;
                        le.lastDists[i] = s.dist;
                        le.lastXSpeeds[i] = s.xSpeed;
                        le.lastYSpeeds[i] = s.ySpeed;
                        le.lastOnViewingSide[i] = s.onViewingSide;
                        le.lastRelativeStrength[i] = s.relativeStrength;
                    }
                } else {
                    le = new LoopEntry(cs.effect.layers.size());
                    le.fadeInMs = cs.effect.loopFadeInMs;
                    le.fadeOutMs = cs.effect.loopFadeOutMs;
                    for (i = 0; i < cs.effect.layers.size(); ++i) {
                        this.loopSnd.clear();
                        cs.effect.layers.get(i).emit(this.loopSnd, sx, sy, volume, dist, cs.xSpeed, cs.ySpeed, cs.own, cs.own ? relativeStrength : 1.0 / relativeStrength);
                        if (this.loopSnd.isEmpty()) continue;
                        s = this.loopSnd.get(0);
                        if (this.concreteLoops.containsKey(s.name)) {
                            le.loops[i] = this.concreteLoops.get(s.name);
                        } else {
                            cl = new ConcreteLoop();
                            this.concreteLoops.put(s.name, cl);
                            le.loops[i] = cl;
                        }
                        le.lastXs[i] = s.x;
                        le.lastYs[i] = s.y;
                        le.lastVolumes[i] = s.volume;
                        le.lastPitches[i] = s.pitch;
                        le.soundNames[i] = s.name;
                        le.lastDists[i] = s.dist;
                        le.lastXSpeeds[i] = s.xSpeed;
                        le.lastYSpeeds[i] = s.ySpeed;
                        le.lastOnViewingSide[i] = s.onViewingSide;
                        le.lastRelativeStrength[i] = s.relativeStrength;
                    }
                    this.loops.put(cs.loopKey, le);
                }
                this.usedLoopKeys.add(cs.loopKey);
            }
            combat.sounds.clear();
            if (!(us.intent instanceof CombatIntent) || us.combat.speed.mult > 0) {
                Iterator<Map.Entry<String, LoopEntry>> it = this.loops.entrySet().iterator();
                while (it.hasNext()) {
                    e = it.next();
                    LoopEntry le = e.getValue();
                    if (this.usedLoopKeys.contains(e.getKey())) {
                        le.fadeAmount = StrictMath.max(0.0, le.fadeAmount - (double)ms * 1.0 / (double)le.fadeInMs);
                        continue;
                    }
                    le.fadeAmount += (double)ms * 1.0 / (double)le.fadeOutMs;
                    if (!(le.fadeAmount >= 1.0)) continue;
                    it.remove();
                }
            }
            for (ConcreteLoop cl : this.concreteLoops.values()) {
                cl.angleAccum = 0.0;
                cl.xyDistAccum = 0.0;
                cl.maxVolume = 0.0;
                cl.nAccum = 0;
                cl.pitchAccum = 0.0;
                cl.volumeAccum = 0.0;
            }
            for (LoopEntry le : this.loops.values()) {
                for (int i = 0; i < le.loops.length; ++i) {
                    ConcreteLoop cl = le.loops[i];
                    if (cl == null) continue;
                    double angle = StrictMath.atan2(le.lastYs[0], le.lastXs[0]);
                    double xyDist = StrictMath.sqrt(le.lastXs[i] * le.lastXs[i] + le.lastYs[i] * le.lastYs[i]);
                    double volume = le.lastVolumes[i] * le.volume();
                    cl.angleAccum += angle * volume;
                    cl.xyDistAccum += xyDist * volume;
                    cl.maxVolume = StrictMath.max(cl.maxVolume, volume);
                    ++cl.nAccum;
                    cl.pitchAccum += le.lastPitches[i] * volume;
                    cl.volumeAccum += volume;
                }
            }
            Iterator<Map.Entry<String, ConcreteLoop>> it = this.concreteLoops.entrySet().iterator();
            while (it.hasNext()) {
                e = it.next();
                ConcreteLoop cl = (ConcreteLoop)e.getValue();
                if (cl.nAccum == 0) {
                    if (cl.loop != null) {
                        cl.loop.stop();
                    }
                    it.remove();
                    continue;
                }
                double angle = cl.angleAccum / cl.volumeAccum;
                double xyDist = cl.xyDistAccum / cl.volumeAccum;
                double pitch = cl.pitchAccum / cl.volumeAccum;
                double volume = StrictMath.pow(cl.volumeAccum / cl.maxVolume, LOOP_SUM_EXPONENT) * cl.maxVolume;
                double x = StrictMath.cos(angle) * xyDist;
                double y = StrictMath.sin(angle) * xyDist;
                if (cl.loop == null) {
                    cl.loop = in.loop(e.getKey(), pitch, volume * us.g.volume, x, y);
                } else {
                    cl.loop.setLocation((float)x, (float)y);
                    cl.loop.setPitch((float)pitch);
                    cl.loop.setVolume((float)(volume * us.g.volume));
                }
                cl.x = x;
                cl.y = y;
                cl.pitch = pitch;
                cl.volume = volume;
            }
            for (int si = 0; si < this.sounds.size(); ++si) {
                SoundEffect.Sound s = this.sounds.get(si);
                this.soundLog.add(0, CombatSoundEffects.rPad(s.name, 20) + CombatSoundEffects.rPad(s.pitch, 6) + CombatSoundEffects.rPad(s.volume, 6) + CombatSoundEffects.rPad((int)s.dist, 6) + CombatSoundEffects.rPad(s.xSpeed, 6) + CombatSoundEffects.rPad(s.ySpeed, 6) + CombatSoundEffects.rPad("" + s.onViewingSide, 8) + CombatSoundEffects.rPad(s.relativeStrength, 6));
                in.play(s.name, s.pitch, s.volume * us.g.volume, s.x, s.y);
            }
            this.sounds.clear();
            while (this.soundLog.size() > 20) {
                this.soundLog.remove(this.soundLog.size() - 1);
            }
        }
    }

    private static String rPad(String s, int l) {
        while (s.length() < l) {
            s = s + " ";
        }
        return s;
    }

    private static String lPad(String s, int l) {
        while (s.length() < l) {
            s = " " + s;
        }
        return s;
    }

    private static String rPad(int i, int l) {
        return CombatSoundEffects.rPad("" + i, l);
    }

    private static String rPad(double d, int l) {
        String s;
        if (d > 99.0) {
            d = 99.0;
        }
        if ((s = "" + d).indexOf(".") != 2) {
            s = " " + s;
        }
        s = s.substring(0, StrictMath.min(s.length(), 5));
        while (s.length() < l) {
            s = s + " ";
        }
        return s;
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }

    public strictfp static class LoopEntry {
        public ConcreteLoop[] loops;
        public double[] lastXs;
        public double[] lastYs;
        public double[] lastVolumes;
        public double[] lastPitches;
        public String[] soundNames;
        public double[] lastDists;
        public double[] lastXSpeeds;
        public double[] lastYSpeeds;
        public boolean[] lastOnViewingSide;
        public double[] lastRelativeStrength;
        public double fadeAmount = 1.0;
        public int fadeInMs = 200;
        public int fadeOutMs = 200;

        public LoopEntry(int size) {
            this.loops = new ConcreteLoop[size];
            this.lastXs = new double[size];
            this.lastYs = new double[size];
            this.lastVolumes = new double[size];
            this.lastPitches = new double[size];
            this.soundNames = new String[size];
            this.lastDists = new double[size];
            this.lastXSpeeds = new double[size];
            this.lastYSpeeds = new double[size];
            this.lastOnViewingSide = new boolean[size];
            this.lastRelativeStrength = new double[size];
        }

        public double volume() {
            return 1.0 - this.fadeAmount;
        }
    }

    public strictfp static class ConcreteLoop {
        public Loop loop;
        public double angleAccum;
        public double xyDistAccum;
        public double pitchAccum;
        public double volumeAccum;
        public double maxVolume;
        public int nAccum;
        public double x;
        public double y;
        public double pitch;
        public double volume;
    }
}

