/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class CombatLayoutPrinter {
    public static void main(String[] args) throws IOException {
        JSONObject co = new JSONObject(FileUtils.readFileToString((File)new File(args[0])));
        BufferedImage img = new BufferedImage(6400, 1600, 1);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.translate(3200, 400);
        JSONArray sides = co.getJSONArray("sides");
        for (int i = 0; i < sides.length(); ++i) {
            JSONObject side = sides.getJSONObject(i);
            Color sideC = (new Color[]{new Color(0, 255, 0, 128), new Color(255, 0, 0, 128), Color.RED})[i];
            JSONArray ships = side.getJSONArray("ships");
            for (int j = 0; j < ships.length(); ++j) {
                int tx;
                JSONObject tile;
                int k;
                JSONObject ship = ships.getJSONObject(j);
                double sx = ship.getDouble("x");
                double sy = ship.getDouble("y");
                boolean flipped = ship.getBoolean("flipped");
                JSONArray tiles = ship.getJSONArray("tiles");
                int shipTileW = 0;
                for (k = 0; k < tiles.length(); ++k) {
                    tile = tiles.getJSONObject(k);
                    tx = tile.getInt("x");
                    shipTileW = StrictMath.max(tx, shipTileW);
                }
                for (k = 0; k < tiles.length(); ++k) {
                    tile = tiles.getJSONObject(k);
                    tx = tile.getInt("x");
                    int ty = tile.getInt("y");
                    double x = flipped ? sx + (double)((shipTileW - tx) * 16) : sx + (double)(tx * 16);
                    double y = sy + (double)(ty * 16);
                    g.setColor(sideC);
                    g.fillRect((int)x, (int)y, 16, 16);
                }
                g.setColor(Color.BLACK);
                g.drawString(ship.getString("name") + " " + ship.getString("networkID"), (int)sx, (int)sy);
            }
        }
        ImageIO.write((RenderedImage)img, "PNG", new File(args[1]));
    }
}

