/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AIQuality;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.FleetOwner;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.MonsterNest;
import com.zarkonnen.airships.WorldMap;
import org.json.JSONObject;

public strictfp class CombatInfo {
    public int attackerAIValue;
    public int defenderAIValue;
    public Combat combat;
    public Fleet attackingFleet;
    public Fleet defendingFleet;
    public MapLocation defendingLoc;
    public boolean setupComplete;
    public AIQuality aiQuality;

    public CombatInfo(Combat combat, Fleet attackingFleet, Fleet defendingFleet, MapLocation defendingLoc, int playerCombatSideIndex, boolean setupComplete, AIQuality aiQuality) {
        this.combat = combat;
        this.attackingFleet = attackingFleet;
        this.defendingFleet = defendingFleet;
        this.defendingLoc = defendingLoc;
        this.setupComplete = setupComplete;
        this.aiQuality = aiQuality;
        this.attackerAIValue = 100;
        for (Airship s : attackingFleet.getAllShips()) {
            this.attackerAIValue += s.getCost();
        }
        this.defenderAIValue = 100;
        if (defendingFleet != null) {
            for (Airship s : defendingFleet.getAllShips()) {
                this.defenderAIValue += s.getCost();
            }
        }
        if (defendingLoc != null) {
            for (Airship b : defendingLoc.getDefences()) {
                this.defenderAIValue = (int)((double)this.defenderAIValue + (double)b.getCost() * 0.6);
            }
        }
    }

    public FleetOwner attacker(WorldMap map) {
        return map.owner(this.attackingFleet);
    }

    public FleetOwner defender(WorldMap map) {
        return this.defendingLoc == null ? map.owner(this.defendingFleet) : map.defender(this.defendingLoc);
    }

    public int playerCombatSideIndex(CampaignWorld cw) {
        if (cw.player == this.attacker(cw.map)) {
            return 0;
        }
        if (cw.player == this.defender(cw.map)) {
            return 1;
        }
        return -1;
    }

    public JSONObject toJSON(CampaignWorld w) {
        JSONObject o = new JSONObject().put("combat", this.combat.toJSON()).put("setupComplete", this.setupComplete);
        o.put("attackingFleetOwnerIndex", w.map.empires.indexOf(w.map.owner(this.attackingFleet)));
        o.put("attackingFleetIndex", w.map.owner(this.attackingFleet).getFleets().indexOf(this.attackingFleet));
        if (this.defendingFleet != null) {
            if (w.map.owner(this.defendingFleet) instanceof Empire) {
                o.put("defendingFleetOwnerIndex", w.map.empires.indexOf(w.map.owner(this.defendingFleet)));
            } else if (w.map.owner(this.defendingFleet) instanceof MonsterNest) {
                o.put("defendingFleetNestIndex", w.map.nests.indexOf(w.map.owner(this.defendingFleet)));
            }
            o.put("defendingFleetIndex", w.map.owner(this.defendingFleet).getFleets().indexOf(this.defendingFleet));
        }
        if (this.defendingLoc != null) {
            if (this.defendingLoc instanceof City) {
                City defendingCity = (City)this.defendingLoc;
                o.put("defendingCityOwnerIndex", w.map.empires.indexOf(w.map.owner(defendingCity)));
                o.put("defendingCityIndex", w.map.owner((City)defendingCity).cities.indexOf(defendingCity));
            } else if (this.defendingLoc instanceof MonsterNest) {
                o.put("defendingNestIndex", w.map.nests.indexOf(this.defendingLoc));
            }
        }
        return o;
    }

    public CombatInfo(JSONObject o, CampaignWorld w, AirshipGame g) {
        this.combat = new Combat(g, o.getJSONObject("combat"));
        this.setupComplete = o.getBoolean("setupComplete");
    }

    public void finish(JSONObject o, CampaignWorld w) {
        this.attackingFleet = w.map.empires.get(o.getInt("attackingFleetOwnerIndex")).getFleets().get(o.getInt("attackingFleetIndex"));
        if (o.has("defendingFleetOwnerIndex")) {
            this.defendingFleet = w.map.empires.get(o.getInt("defendingFleetOwnerIndex")).getFleets().get(o.getInt("defendingFleetIndex"));
        }
        if (o.has("defendingFleetNestIndex")) {
            this.defendingFleet = w.map.nests.get(o.getInt("defendingFleetNestIndex")).getFleets().get(o.getInt("defendingFleetIndex"));
        }
        if (o.has("defendingCityOwnerIndex")) {
            this.defendingLoc = w.map.empires.get((int)o.getInt((String)"defendingCityOwnerIndex")).cities.get(o.getInt("defendingCityIndex"));
        }
        if (o.has("defendingNestIndex")) {
            this.defendingLoc = w.map.nests.get(o.getInt("defendingNestIndex"));
        }
    }

    public boolean isUncontested() {
        boolean noDefenses;
        if (this.attackingFleet.getAllShips().isEmpty()) {
            return true;
        }
        boolean noDefendingFleet = this.defendingFleet == null || this.defendingFleet.getAllShips().isEmpty();
        boolean bl = noDefenses = this.defendingLoc == null || this.defendingLoc.getDefences().isEmpty();
        return noDefendingFleet && noDefenses;
    }
}

