/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Charge;
import com.zarkonnen.airships.HeraldicStyle;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.SpritesheetBundle;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.Tincture;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import org.json.JSONObject;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;

public strictfp class CoatOfArms
implements JSONAble {
    public static final int MAX_PARTS = 4;
    public Layout layout = Layout.CHARGE;
    public final Charge[] charge = new Charge[]{Charge.ofName("RAT"), Charge.ofName("RAT"), Charge.ofName("RAT"), Charge.ofName("RAT")};
    public final String[] specialCharge = new String[]{null, null, null, null};
    public final Tincture[] tincture = new Tincture[]{Tincture.valueOf("ARGENT"), Tincture.valueOf("ARGENT"), Tincture.valueOf("ARGENT"), Tincture.valueOf("ARGENT")};
    public final Tincture[] chargeT = new Tincture[]{Tincture.valueOf("SABLE"), Tincture.valueOf("SABLE"), Tincture.valueOf("SABLE"), Tincture.valueOf("SABLE")};
    public boolean ruleOfTincture = true;
    private transient Color mixedColor;
    private static Appearance FLAG = null;
    private static Appearance FESS_DETAIL = null;
    private static Appearance PARTY_PER_PALE_DETAIL = null;
    private static Appearance BEND_SINISTER_DETAIL = null;
    private static Appearance BORDURE_DETAIL = null;
    private static Appearance PARTY_PER_BEND_SINISTER_DETAIL = null;
    private static Appearance PALE_DETAIL = null;
    private static Appearance PARTY_PER_CHEVRON_DETAIL = null;
    private static Appearance ON_BEND_DETAIL = null;
    private static Appearance ON_BEND_SINISTER_DETAIL = null;
    private static Appearance ON_CROSS_DETAIL = null;
    private static Appearance PALY_DETAIL = null;
    private static Appearance BARRY_DETAIL = null;
    private static Appearance SALTIRE_DETAIL = null;
    private static Appearance UL_FLAG = null;
    private static Appearance UL_FESS_DETAIL = null;
    private static Appearance UL_PARTY_PER_PALE_DETAIL = null;
    private static Appearance UL_BEND_SINISTER_DETAIL = null;
    private static Appearance UL_BORDURE_DETAIL = null;
    private static Appearance UL_PARTY_PER_BEND_SINISTER_DETAIL = null;
    private static Appearance UL_PALE_DETAIL = null;
    private static Appearance UL_PARTY_PER_CHEVRON_DETAIL = null;
    private static Appearance UL_ON_BEND_DETAIL = null;
    private static Appearance UL_ON_BEND_SINISTER_DETAIL = null;
    private static Appearance UL_ON_CROSS_DETAIL = null;
    private static Appearance UL_PALY_DETAIL = null;
    private static Appearance UL_BARRY_DETAIL = null;
    private static Appearance UL_SALTIRE_DETAIL = null;
    public static final int SHIELD_W = 36;
    public static final int SHIELD_H = 41;
    public static final Img SHIELD_OUTLINE = new Img("ui", 0, 544, 36, 41, false);
    private static final Img SHIELD_CONTENT = new Img("ui", 481, 544, 36, 41, false);
    private static final Img SHIELD_CHEVRON = new Img("ui", 37, 544, 36, 41, false);
    private static final Img SHIELD_FESS = new Img("ui", 74, 544, 36, 41, false);
    private static final Img SHIELD_PARTY_PER_PALE = new Img("ui", 111, 544, 36, 41, false);
    private static final Img SHIELD_BEND_SINISTER = new Img("ui", 185, 544, 36, 41, false);
    private static final Img SHIELD_BORDURE = new Img("ui", 222, 544, 36, 41, false);
    private static final Img SHIELD_PARTY_PER_BEND_SINISTER = new Img("ui", 259, 544, 36, 41, false);
    private static final Img SHIELD_PALE = new Img("ui", 296, 544, 36, 41, false);
    private static final Img SHIELD_Q_TL = new Img("ui", 333, 544, 36, 41, false);
    private static final Img SHIELD_Q_BL = new Img("ui", 370, 544, 36, 41, false);
    private static final Img SHIELD_Q_BR = new Img("ui", 407, 544, 36, 41, false);
    private static final Img SHIELD_Q_TR = new Img("ui", 444, 544, 36, 41, false);
    private static final Img SHIELD_ON_BEND = new Img("ui", 518, 544, 36, 41, false);
    private static final Img SHIELD_ON_BEND_SINISTER = new Img("ui", 555, 544, 36, 41, false);
    private static final Img SHIELD_SALTIRE = new Img("ui", 592, 544, 36, 41, false);
    private static final Img SHIELD_ON_CROSS = new Img("ui", 629, 544, 36, 41, false);
    private static final Img SHIELD_PALY = new Img("ui", 666, 544, 36, 41, false);
    private static final Img SHIELD_BARRY = new Img("ui", 703, 544, 36, 41, false);

    private void cleanupCharges() {
        for (int i = 0; i < this.charge.length; ++i) {
            if (i < this.layout.charges) {
                if (this.charge[i] == null) {
                    if (this.specialCharge[i] != null) continue;
                    this.charge[i] = Charge.ofName("RAT");
                    continue;
                }
                if (this.specialCharge[i] == null) continue;
                this.specialCharge[i] = null;
                continue;
            }
            this.charge[i] = null;
            this.specialCharge[i] = null;
        }
    }

    public Bonus getBonus() {
        this.cleanupCharges();
        for (int i = 0; i < this.layout.charges; ++i) {
            if (this.charge[i] == null || this.charge[i].bonus == Bonus.ofName("NO_BONUS") && this.charge[i].tech == null) continue;
            return this.charge[i].bonus;
        }
        return Bonus.ofName("NO_BONUS");
    }

    public Tech.Choice getTech() {
        this.cleanupCharges();
        for (int i = 0; i < this.layout.charges; ++i) {
            if (this.charge[i] == null || this.charge[i].bonus == Bonus.ofName("NO_BONUS") && this.charge[i].tech == null) continue;
            return this.charge[i].tech;
        }
        return null;
    }

    public Charge getActiveCharge() {
        this.cleanupCharges();
        for (int i = 0; i < this.layout.charges; ++i) {
            if (this.charge[i] == null || this.charge[i].bonus == Bonus.ofName("NO_BONUS") && this.charge[i].tech == null) continue;
            return this.charge[i];
        }
        return null;
    }

    public Tincture[] getRoundelTinctures() {
        return new Tincture[]{this.getTincture(0), this.getTincture(1), this.getTincture(2)};
    }

    public Color getMixedColor() {
        if (this.mixedColor == null) {
            Tincture t1 = this.tincture[0];
            Tincture t2 = this.layout.charges > 0 ? this.chargeT[0] : (this.layout.tinctures > 1 ? this.tincture[1] : this.tincture[0]);
            Tincture t3 = this.layout.charges > 0 && this.layout.tinctures > 1 ? this.tincture[1] : this.tincture[0];
            this.mixedColor = new Color(t1.tint.r / 2 + t2.tint.r / 4 + t3.tint.r / 4, t1.tint.g / 2 + t2.tint.g / 4 + t3.tint.g / 4, t1.tint.b / 2 + t2.tint.b / 4 + t3.tint.b / 4);
        }
        return this.mixedColor;
    }

    public Tincture getFirstColour() {
        for (int i = 0; i < 4; ++i) {
            if (i < this.layout.tinctures && !this.tincture[i].metal) {
                return this.tincture[i];
            }
            if (i >= this.layout.charges || this.chargeT[i].metal) continue;
            return this.chargeT[i];
        }
        return Tincture.valueOf("GULES");
    }

    public Tincture getFirstMetal() {
        for (int i = 0; i < 4; ++i) {
            if (i < this.layout.tinctures && this.tincture[i].metal) {
                return this.tincture[i];
            }
            if (i >= this.layout.charges || !this.chargeT[i].metal) continue;
            return this.chargeT[i];
        }
        return Tincture.valueOf("OR");
    }

    public Tincture getTincture(int index) {
        if (this.layout.charges == 0) {
            return this.tincture[index % this.layout.tinctures];
        }
        if (this.ruleOfTincture) {
            switch (index) {
                case 0: {
                    return this.chargeT[0];
                }
                case 1: {
                    for (int i = 0; i < this.layout.tinctures; ++i) {
                        if (this.tincture[i].metal == this.chargeT[0].metal) continue;
                        return this.tincture[i];
                    }
                    return this.tincture[0];
                }
                case 2: {
                    for (int i = 0; i < this.layout.tinctures; ++i) {
                        if (this.tincture[i].metal != this.chargeT[0].metal) continue;
                        return this.tincture[i];
                    }
                    return this.chargeT[0];
                }
            }
        } else {
            switch (index) {
                case 0: {
                    return this.chargeT[0];
                }
                case 1: {
                    int i;
                    for (i = 0; i < this.layout.tinctures; ++i) {
                        if (this.tincture[i].metal == this.chargeT[0].metal) continue;
                        return this.tincture[i];
                    }
                    for (i = 0; i < this.layout.tinctures; ++i) {
                        if (this.tincture[i] == this.chargeT[0]) continue;
                        return this.tincture[i];
                    }
                    return this.tincture[0];
                }
                case 2: {
                    for (int i = 0; i < this.layout.tinctures; ++i) {
                        if (this.tincture[i] == this.getTincture(1) || this.tincture[i] == this.chargeT[0]) continue;
                        return this.tincture[i];
                    }
                    return this.chargeT[0];
                }
            }
        }
        return null;
    }

    @Override
    public JSONObject toJSON() {
        int i;
        this.cleanupCharges();
        JSONObject o = new JSONObject().put("layout", this.layout.name()).put("fieldT", this.tincture[0].name()).put("chargeT", this.chargeT[0].name()).put("ruleOfTincture", this.ruleOfTincture);
        if (this.charge[0] == null) {
            o.put("specialCharge", this.specialCharge[0]);
        } else {
            o.put("charge", this.charge[0].name);
        }
        if (this.layout.tinctures > 1) {
            o.put("secondT", this.tincture[1].name());
        }
        for (i = 1; i < this.layout.charges; ++i) {
            if (this.charge[i] == null) {
                o.put("specialCharge" + i, this.specialCharge[i]);
            } else {
                o.put("charge" + i, this.charge[i].name);
            }
            o.put("chargeT" + i, this.chargeT[i].name());
        }
        for (i = 2; i < this.layout.tinctures; ++i) {
            o.put("tincture" + i, this.tincture[i].name());
        }
        return o;
    }

    public int hashCode() {
        int i;
        this.cleanupCharges();
        int code = this.layout.ordinal();
        for (i = 0; i < this.layout.charges; ++i) {
            code *= 37;
            code += this.charge[i] == null ? this.specialCharge[i].hashCode() : this.charge[i].name.hashCode();
        }
        for (i = 0; i < this.layout.tinctures; ++i) {
            code *= 37;
            code += this.tincture[i].ordinal();
        }
        return code;
    }

    public boolean equals(Object o) {
        int i;
        this.cleanupCharges();
        if (!(o instanceof CoatOfArms)) {
            return false;
        }
        CoatOfArms coa2 = (CoatOfArms)o;
        coa2.cleanupCharges();
        if (this.layout != coa2.layout) {
            return false;
        }
        for (i = 0; i < this.layout.charges; ++i) {
            if (this.charge[i] != coa2.charge[i]) {
                return false;
            }
            if (this.chargeT[i] != coa2.chargeT[i]) {
                return false;
            }
            if (this.specialCharge[i] == null || this.specialCharge[i].equals(coa2.specialCharge[i])) continue;
            return false;
        }
        for (i = 0; i < this.layout.tinctures; ++i) {
            if (this.tincture[i] == coa2.tincture[i]) continue;
            return false;
        }
        return true;
    }

    public CoatOfArms copy() {
        this.cleanupCharges();
        CoatOfArms coa = new CoatOfArms();
        coa.layout = this.layout;
        coa.ruleOfTincture = this.ruleOfTincture;
        for (int i = 0; i < 4; ++i) {
            coa.charge[i] = this.charge[i];
            coa.specialCharge[i] = this.specialCharge[i];
            coa.chargeT[i] = this.chargeT[i];
            coa.tincture[i] = this.tincture[i];
        }
        return coa;
    }

    public CoatOfArms() {
    }

    public String toString() {
        return this.toJSON().toString(4);
    }

    public CoatOfArms(JSONObject o) {
        try {
            this.layout = Layout.valueOf(o.getString("layout"));
            this.ruleOfTincture = o.optBoolean("ruleOfTincture", true);
            if (this.layout.charges > 0) {
                if (o.has("charge")) {
                    this.charge[0] = Charge.ofName(o.getString("charge"));
                } else {
                    this.charge[0] = null;
                    this.specialCharge[0] = o.getString("specialCharge");
                }
            } else {
                this.charge[0] = null;
                this.specialCharge[0] = null;
            }
            this.tincture[0] = Tincture.valueOf(o.getString("fieldT"));
            this.chargeT[0] = Tincture.valueOf(o.getString("chargeT"));
            if (this.layout.tinctures > 1) {
                this.tincture[1] = Tincture.valueOf(o.getString("secondT"));
            }
            for (int i = 1; i < this.layout.charges; ++i) {
                if (o.has("charge" + i)) {
                    this.charge[i] = Charge.ofName(o.getString("charge" + i));
                    this.chargeT[i] = Tincture.valueOf(o.getString("chargeT" + i));
                    continue;
                }
                if (o.has("specialCharge" + i)) {
                    this.charge[i] = null;
                    this.specialCharge[i] = o.getString("specialCharge" + i);
                    this.chargeT[i] = Tincture.valueOf(o.getString("chargeT" + i));
                    continue;
                }
                this.charge[i] = this.charge[0];
                this.specialCharge[i] = this.specialCharge[0];
                this.chargeT[i] = this.chargeT[0];
            }
            if (this.layout.tinctures > 2) {
                this.tincture[2] = o.has("tincture2") ? Tincture.valueOf(o.getString("tincture2")) : this.tincture[0];
            }
            if (this.layout.tinctures > 3) {
                this.tincture[3] = o.has("tincture3") ? Tincture.valueOf(o.getString("tincture3")) : this.tincture[1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.layout = Layout.SALTIRE;
            this.tincture[0] = Tincture.valueOf("SABLE");
            this.tincture[1] = Tincture.valueOf("OR");
        }
    }

    public void setCharge(Charge c, int index) {
        this.charge[index] = c;
        this.specialCharge[index] = null;
        this.cleanupCharges();
    }

    public void setSpecialCharge(String specialCharge, int index) {
        this.specialCharge[index] = specialCharge;
        this.charge[index] = null;
        this.cleanupCharges();
    }

    public void draw(MyDraw d, double x, double y) {
        this.layout.draw(this, d, x, y, 16.0, null);
    }

    public void draw(MyDraw d, double x, double y, int size) {
        this.layout.draw(this, d, x, y, size, null);
    }

    public void draw(MyDraw d, double x, double y, int size, TinctureSlot highlight) {
        this.layout.draw(this, d, x, y, size, highlight);
    }

    public void drawBase(MyDraw d, double x, double y, int size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
        this.layout.drawBase(this, d, x, y, size, light, lightStrength, ambient, ambientSaturation);
    }

    public void drawCharges(MyDraw d, double x, double y, int size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
        this.layout.drawCharges(this, d, x, y, size, light, lightStrength, ambient, ambientSaturation, ssb, additionalSSBs);
    }

    public void drawUnlitCharges(MyDraw d, double x, double y, int size) {
        this.layout.drawUnlitCharges(this, d, x, y, size);
    }

    public String blazon() {
        return this.layout.blazon(this);
    }

    public String getBonusOrTechDesc() {
        Charge c = this.getActiveCharge();
        if (c == null) {
            return Bonus.ofName("NO_BONUS").getDesc();
        }
        return c.getBonusOrTechDesc();
    }

    public void setLayout(Layout newLayout) {
        Tincture t;
        int i;
        ArrayList<Tincture> metals = new ArrayList<Tincture>();
        ArrayList<Tincture> nonMetals = new ArrayList<Tincture>();
        ArrayList<Tincture> tinctures = new ArrayList<Tincture>();
        ArrayList<Charge> charges = new ArrayList<Charge>();
        String theSpecialCharge = null;
        for (i = 0; i < this.layout.tinctures; ++i) {
            t = this.tincture[i];
            (t.metal ? metals : nonMetals).add(t);
            tinctures.add(t);
        }
        for (i = 0; i < this.layout.charges; ++i) {
            t = this.chargeT[i];
            (t.metal ? metals : nonMetals).add(t);
            tinctures.add(t);
            if (this.charge[i] != null) {
                charges.add(this.charge[i]);
                continue;
            }
            theSpecialCharge = this.specialCharge[i];
        }
        if (metals.isEmpty()) {
            metals.add(Tincture.valueOf("OR"));
        }
        if (nonMetals.isEmpty()) {
            nonMetals.add(Tincture.valueOf("SABLE"));
        }
        for (i = this.layout.tinctures; i < newLayout.tinctures; ++i) {
            this.tincture[i] = (Tincture)tinctures.get(i % tinctures.size());
        }
        for (i = this.layout.charges; i < newLayout.charges; ++i) {
            this.chargeT[i] = (Tincture)tinctures.get((i + this.layout.tinctures) % tinctures.size());
            if (charges.isEmpty()) {
                this.charge[i] = null;
                this.specialCharge[i] = theSpecialCharge;
                continue;
            }
            this.charge[i] = (Charge)charges.get(i % charges.size());
            this.specialCharge[i] = null;
        }
        this.layout = newLayout;
        while (!this.legal()) {
            for (TinctureSlot tsA : TinctureSlot.values()) {
                if (!this.layout.adjacency.containsKey((Object)tsA)) continue;
                for (TinctureSlot tsB : this.layout.adjacency.get((Object)tsA)) {
                    if (this.getTincture(tsA) != this.getTincture(tsB)) continue;
                    this.setTinctureOnly((Tincture)(this.getTincture((TinctureSlot)tsB).metal ? nonMetals : metals).get(0), tsB);
                }
            }
            for (TinctureSlot tsA : TinctureSlot.values()) {
                if (!this.layout.onTop.containsKey((Object)tsA)) continue;
                for (TinctureSlot tsB : this.layout.onTop.get((Object)tsA)) {
                    if (this.ruleOfTincture) {
                        if (this.getTincture((TinctureSlot)tsA).metal != this.getTincture((TinctureSlot)tsB).metal) continue;
                        this.setTinctureOnly((Tincture)(this.getTincture((TinctureSlot)tsB).metal ? nonMetals : metals).get(0), tsB);
                        continue;
                    }
                    if (this.getTincture(tsA) != this.getTincture(tsB)) continue;
                    this.setTinctureOnly((Tincture)(this.getTincture((TinctureSlot)tsB).metal ? nonMetals : metals).get(0), tsB);
                }
            }
        }
        this.cleanupCharges();
    }

    public void setTincture(Tincture t, TinctureSlot slot) {
        EnumSet<TinctureSlot> visited = EnumSet.of(slot);
        this.setTincture(t, slot, visited);
    }

    public Tincture getTincture(TinctureSlot slot) {
        if (slot.tinctureIndex > -1) {
            return this.tincture[slot.tinctureIndex];
        }
        return this.chargeT[slot.chargeIndex];
    }

    private Tincture setTinctureOnly(Tincture t, TinctureSlot slot) {
        Tincture old;
        if (slot.tinctureIndex > -1) {
            old = this.tincture[slot.tinctureIndex];
            this.tincture[slot.tinctureIndex] = t;
        } else {
            old = this.chargeT[slot.chargeIndex];
            this.chargeT[slot.chargeIndex] = t;
        }
        return old;
    }

    public void setTincture(Tincture t, TinctureSlot slot, EnumSet<TinctureSlot> visited) {
        Tincture old = this.setTinctureOnly(t, slot);
        if (this.layout.adjacency.containsKey((Object)slot)) {
            for (TinctureSlot ts : this.layout.adjacency.get((Object)slot)) {
                if (visited.contains((Object)ts) || this.getTincture(ts) != t) continue;
                visited.add(ts);
                this.setTincture(old, ts, visited);
            }
        }
        if (this.layout.onTop.containsKey((Object)slot)) {
            for (TinctureSlot ts : this.layout.onTop.get((Object)slot)) {
                if (visited.contains((Object)ts) || this.getTincture((TinctureSlot)ts).metal != t.metal) continue;
                visited.add(ts);
                this.setTincture(old, ts, visited);
            }
        }
    }

    public boolean legal() {
        for (TinctureSlot tsA : this.layout.adjacency.keySet()) {
            for (TinctureSlot tsB : this.layout.adjacency.get((Object)tsA)) {
                if (this.getTincture(tsA) != this.getTincture(tsB)) continue;
                return false;
            }
        }
        if (this.ruleOfTincture) {
            for (TinctureSlot tsA : this.layout.onTop.keySet()) {
                for (TinctureSlot tsB : this.layout.onTop.get((Object)tsA)) {
                    if (this.getTincture((TinctureSlot)tsA).metal != this.getTincture((TinctureSlot)tsB).metal) continue;
                    return false;
                }
            }
        } else {
            for (TinctureSlot tsA : this.layout.onTop.keySet()) {
                for (TinctureSlot tsB : this.layout.onTop.get((Object)tsA)) {
                    if (this.getTincture(tsA) != this.getTincture(tsB)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static CoatOfArms getConsistentAndSafe() {
        int i;
        CoatOfArms coa = new CoatOfArms();
        coa.ruleOfTincture = false;
        HeraldicStyle style = HeraldicStyle.ofName("player");
        coa.layout = style.layouts.get(0);
        for (i = 0; i < coa.layout.charges; ++i) {
            coa.charge[i] = style.charges.get(0);
            coa.chargeT[i] = style.chargeTinctures.get(0);
        }
        for (i = 0; i < coa.layout.tinctures; ++i) {
            coa.tincture[i] = style.layoutTinctures.get(0);
        }
        return coa;
    }

    public static CoatOfArms spectatorArms() {
        try {
            CoatOfArms coa = new CoatOfArms();
            coa.layout = Layout.CHARGE;
            coa.tincture[0] = Tincture.valueOf("CENDREE");
            coa.charge[0] = Charge.ofName("EYE");
            coa.chargeT[0] = Tincture.valueOf("SABLE");
            return coa;
        }
        catch (Exception e) {
            return CoatOfArms.getConsistentAndSafe();
        }
    }

    public static CoatOfArms getRandom(Random r, HeraldicStyle style) {
        CoatOfArms coa = new CoatOfArms();
        coa.ruleOfTincture = style.ruleOfTincture;
        coa.layout = style.layouts.get(r.nextInt(style.layouts.size()));
        do {
            int i;
            if (r.nextInt(10) == 1) {
                coa.layout = style.layouts.get(r.nextInt(style.layouts.size()));
            }
            for (i = 0; i < coa.layout.charges; ++i) {
                coa.charge[i] = style.firstChargeShouldHaveBonus && i == 0 ? style.chargesWithBonusOrTech.get(r.nextInt(style.chargesWithBonusOrTech.size())) : style.charges.get(r.nextInt(style.charges.size()));
                coa.chargeT[i] = style.chargeTinctures.get(r.nextInt(style.chargeTinctures.size()));
            }
            for (i = 0; i < coa.layout.tinctures; ++i) {
                coa.tincture[i] = style.layoutTinctures.get(r.nextInt(style.layoutTinctures.size()));
            }
        } while (!coa.legal() || coa.getBonus() == null && coa.getTech() == null);
        coa.cleanupCharges();
        return coa;
    }

    public static void updateAppearances() {
        FLAG = new Appearance(SpritesheetBundle.ofName("spritesheet"), 0, 25);
        FESS_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 1, 25);
        PARTY_PER_PALE_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 3, 25);
        BEND_SINISTER_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 6, 25);
        BORDURE_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 7, 25);
        PARTY_PER_BEND_SINISTER_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 8, 25);
        PALE_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 9, 25);
        PARTY_PER_CHEVRON_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 10, 25);
        ON_BEND_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 11, 25);
        ON_BEND_SINISTER_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 12, 25);
        ON_CROSS_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 13, 25);
        PALY_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 14, 25);
        BARRY_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 15, 25);
        SALTIRE_DETAIL = new Appearance(SpritesheetBundle.ofName("spritesheet"), 16, 25);
        UL_FLAG = new Appearance(SpritesheetBundle.ofName("ui"), 0, 25);
        UL_FESS_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 1, 25);
        UL_PARTY_PER_PALE_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 3, 25);
        UL_BEND_SINISTER_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 6, 25);
        UL_BORDURE_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 7, 25);
        UL_PARTY_PER_BEND_SINISTER_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 8, 25);
        UL_PALE_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 9, 25);
        UL_PARTY_PER_CHEVRON_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 10, 25);
        UL_ON_BEND_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 11, 25);
        UL_ON_BEND_SINISTER_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 12, 25);
        UL_ON_CROSS_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 13, 25);
        UL_PALY_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 14, 25);
        UL_BARRY_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 15, 25);
        UL_SALTIRE_DETAIL = new Appearance(SpritesheetBundle.ofName("ui"), 16, 25);
    }

    private String chargeName(int i) {
        if (this.charge[i] == null) {
            if (this.specialCharge[i] == null) {
                return "?";
            }
            return this.specialCharge[i].split("_")[0];
        }
        return this.charge[i].getName();
    }

    private String chargesName(int i) {
        if (this.charge[i] == null) {
            if (this.specialCharge[i] == null) {
                return "?";
            }
            return this.specialCharge[i].split("_")[1];
        }
        return this.charge[i].getPlural();
    }

    private static void d(MyDraw d, Img img, Clr tint, double x, double y, double w, double h) {
        if (img.machineImgCache != null) {
            ((Image)img.machineImgCache).setFilter(9728);
        }
        d.blit(img, tint, x, y, w, h);
    }

    static float li(CoatOfArms coa, TinctureSlot slot, float lightIntensity) {
        return slot.get((CoatOfArms)coa).metal ? lightIntensity * 6.0f : lightIntensity;
    }

    static Clr tinc(MyDraw d, CoatOfArms coa, TinctureSlot slot, TinctureSlot highlight) {
        Tincture t = slot.get(coa);
        if (slot == highlight) {
            if (t.metal) {
                return d.darkPulse(t.tint);
            }
            return d.pulse(t.tint);
        }
        return t.tint;
    }

    public strictfp static enum Layout {
        CHARGE(1, 1, null, new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x, y, size, size);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x, y, size, size);
                } else {
                    coa.charge[0].unlitApp.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.rect(Clr.BLACK, x + 2.0, y + 2.0, 12.0, 12.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 32.0 * scale, 32.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 2.0 * scale, y + 2.0 * scale, 32.0 * scale, 32.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        FESS(1, 2, "fess_", new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE0}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                FESS_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_FESS_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.rect(Clr.GREY, x, y + 3.0, 16.0, 10.0);
                d.rect(Clr.BLACK, x + 5.0, y + 5.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_FESS, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        PALE(1, 2, "pale_", new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE0}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                PALE_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_PALE_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.rect(Clr.GREY, x + 3.0, y, 10.0, 16.0);
                d.rect(Clr.BLACK, x + 5.0, y + 5.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_PALE, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        QUARTERLY(4, 4, null, new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE1, TinctureSlot.TINCTURE2, TinctureSlot.CHARGE2, TinctureSlot.TINCTURE3, TinctureSlot.CHARGE3}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                for (int i = 0; i < 4; ++i) {
                    double x2 = x + size / 2.0 * (double)(i % 2);
                    double y2 = y + size / 2.0 * (double)(i / 2);
                    FLAG.drawSub(d, x2, y2, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.values()[i], null), false, light, CoatOfArms.li(coa, TinctureSlot.values()[i], lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                }
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                for (int i = 0; i < 4; ++i) {
                    double x2 = x + size / 2.0 * (double)(i % 2);
                    double y2 = y + size / 2.0 * (double)(i / 2);
                    if (coa.charge[i] == null) continue;
                    if (coa.charge[i].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[i].app.draw(d, x2, y2, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.values()[i + 4], null), false, light, CoatOfArms.li(coa, TinctureSlot.values()[i + 4], lightStrength), ambient, ambientSaturation);
                        continue;
                    }
                    if (additionalSSBs == null) continue;
                    additionalSSBs.add(coa.charge[i].app.spritesheetBundle);
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                for (int i = 0; i < 4; ++i) {
                    double x2 = x + size / 2.0 * (double)(i % 2);
                    double y2 = y + size / 2.0 * (double)(i / 2);
                    if (coa.charge[i] != null) continue;
                    d.drawSpecialCharge(coa.specialCharge[i], CoatOfArms.tinc(d, coa, TinctureSlot.values()[i + 4], null), x2, y2, size / 2.0, size / 2.0);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                for (int i = 0; i < 4; ++i) {
                    double x2 = x + size / 2.0 * (double)(i % 2);
                    double y2 = y + size / 2.0 * (double)(i / 2);
                    UL_FLAG.draw(d, x2, y2, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.values()[i], highlight), false);
                    if (coa.charge[i] == null) {
                        d.drawSpecialCharge(coa.specialCharge[i], CoatOfArms.tinc(d, coa, TinctureSlot.values()[i + 4], highlight), x2, y2, size / 2.0, size / 2.0);
                        continue;
                    }
                    coa.charge[i].unlitApp.draw(d, x2, y2, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.values()[i + 4], highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.rect(Clr.GREY, x + 8.0, y, 8.0, 8.0);
                d.rect(Clr.GREY, x, y + 8.0, 8.0, 8.0);
                d.rect(Clr.BLACK, x + 1.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.WHITE, x + 9.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.WHITE, x + 1.0, y + 9.0, 6.0, 6.0);
                d.rect(Clr.BLACK, x + 9.0, y + 9.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_Q_TL, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_Q_TR, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_Q_BL, coa.tincture[2].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_Q_BR, coa.tincture[3].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], coa.chargeT[1].tint, x + 18.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[1].unlitApp.draw(d, x + 18.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[1].tint, false);
                }
                if (coa.charge[2] == null) {
                    d.drawSpecialCharge(coa.specialCharge[2], coa.chargeT[2].tint, x + 2.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[2].unlitApp.draw(d, x + 2.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[2].tint, false);
                }
                if (coa.charge[3] == null) {
                    d.drawSpecialCharge(coa.specialCharge[3], coa.chargeT[3].tint, x + 18.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[3].unlitApp.draw(d, x + 18.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[3].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        PARTY_PER_PALE(2, 2, null, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1}, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE1}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                PARTY_PER_PALE_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
                if (coa.charge[1] != null) {
                    if (coa.charge[1].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[1].app.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE1, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[1].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x, y, size, size);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, null), x, y, size, size);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_PARTY_PER_PALE_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].unlitApp.draw(d, x, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight), x + size / 2.0, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[1].unlitApp.draw(d, x + size / 2.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                PARTY_PER_PALE_DETAIL.draw(d, x, y, 0, Clr.GREY, false);
                d.rect(Clr.BLACK, x + 1.0, y + 5.0, 6.0, 6.0);
                d.rect(Clr.WHITE, x + 9.0, y + 5.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_PARTY_PER_PALE, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 2.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], coa.chargeT[1].tint, x + 18.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[1].unlitApp.draw(d, x + 18.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[1].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        BORDURE(1, 2, "bordure_", new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1}, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                BORDURE_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_BORDURE_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.GREY, x, y, 16.0, 16.0);
                d.rect(Clr.WHITE, x + 2.0, y + 2.0, 12.0, 12.0);
                d.rect(Clr.BLACK, x + 5.0, y + 5.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_BORDURE, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        PARTY_PER_CHEVRON(2, 2, null, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1}, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE1}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                PARTY_PER_CHEVRON_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                double offset;
                double d2 = offset = coa.charge[0] != null && coa.charge[0].name.equals("WAVES") ? 0.0 : -size / 32.0;
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x + size / 4.0, y + offset, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
                double d3 = offset = coa.charge[1] != null && coa.charge[1].name.equals("WAVES") ? 0.0 : size / 32.0;
                if (coa.charge[1] != null) {
                    if (coa.charge[1].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[1].app.draw(d, x + size / 4.0, y + size / 2.0 + offset, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE1, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[1].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                double offset;
                double d2 = offset = coa.charge[0] != null && coa.charge[0].name.equals("WAVES") ? 0.0 : -size / 32.0;
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x + size / 4.0, y + offset, size / 2.0, size / 2.0);
                }
                double d3 = offset = coa.charge[1] != null && coa.charge[1].name.equals("WAVES") ? 0.0 : size / 32.0;
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, null), x + size / 4.0, y + size / 2.0 + offset, size / 2.0, size / 2.0);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                double offset;
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_PARTY_PER_CHEVRON_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
                double d2 = offset = coa.charge[0] != null && coa.charge[0].name.equals("WAVES") ? 0.0 : -size / 32.0;
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x + size / 4.0, y + offset, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + size / 4.0, y + offset, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
                double d3 = offset = coa.charge[1] != null && coa.charge[1].name.equals("WAVES") ? 0.0 : size / 32.0;
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight), x + size / 4.0, y + size / 2.0 + offset, size / 2.0, size / 2.0);
                } else {
                    coa.charge[1].unlitApp.draw(d, x + size / 4.0, y + size / 2.0 + offset, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                PARTY_PER_CHEVRON_DETAIL.draw(d, x, y, 0, Clr.GREY, false);
                d.rect(Clr.BLACK, x + 5.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.WHITE, x + 5.0, y + 9.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_CHEVRON, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 10.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], coa.chargeT[1].tint, x + 10.0 * scale, y + 22.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[1].unlitApp.draw(d, x + 10.0 * scale, y + 22.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[1].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        PARTY_PER_BEND_SINISTER(2, 2, null, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1}, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE1}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                PARTY_PER_BEND_SINISTER_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
                if (coa.charge[1] != null) {
                    if (coa.charge[1].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[1].app.draw(d, x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE1, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[1].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x, y, size / 2.0, size / 2.0);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, null), x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_PARTY_PER_BEND_SINISTER_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x, y, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].unlitApp.draw(d, x, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight), x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[1].unlitApp.draw(d, x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                PARTY_PER_BEND_SINISTER_DETAIL.draw(d, x, y, 0, Clr.GREY, false);
                d.rect(Clr.BLACK, x + 1.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.WHITE, x + 9.0, y + 9.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_PARTY_PER_BEND_SINISTER, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], coa.chargeT[1].tint, x + 10.0 * scale, y + 19.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[1].unlitApp.draw(d, x + 18.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[1].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        SCARPE(2, 2, "scarpe_", new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE0, TinctureSlot.CHARGE1}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                BEND_SINISTER_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
                if (coa.charge[1] != null) {
                    if (coa.charge[1].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[1].app.draw(d, x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE1, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[1].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x, y, size / 2.0, size / 2.0);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, null), x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_BEND_SINISTER_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x, y, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].unlitApp.draw(d, x, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight), x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[1].unlitApp.draw(d, x + size / 2.0, y + size / 2.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                BEND_SINISTER_DETAIL.draw(d, x, y, 0, Clr.GREY, false);
                d.rect(Clr.BLACK, x + 1.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.BLACK, x + 9.0, y + 9.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_BEND_SINISTER, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialCharge(coa.specialCharge[1], coa.chargeT[1].tint, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[1].unlitApp.draw(d, x + 18.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[1].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        THREE(1, 1, null, new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x + size / 4.0, y + size / 2.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                        coa.charge[0].app.draw(d, x, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                        coa.charge[0].app.draw(d, x + size / 2.0, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x + size / 4.0, y + size / 2.0, size / 2.0, size / 2.0);
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x, y, size / 2.0, size / 2.0);
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x + size / 2.0, y, size / 2.0, size / 2.0);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x + size / 4.0, y + size / 2.0, size / 2.0, size / 2.0);
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x, y, size / 2.0, size / 2.0);
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x + size / 2.0, y, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + size / 4.0, y + size / 2.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                    coa.charge[0].unlitApp.draw(d, x, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                    coa.charge[0].unlitApp.draw(d, x + size / 2.0, y, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.rect(Clr.BLACK, x + 1.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.BLACK, x + 9.0, y + 1.0, 6.0, 6.0);
                d.rect(Clr.BLACK, x + 5.0, y + 9.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale);
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 5.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                    coa.charge[0].unlitApp.draw(d, x + 18.0 * scale, y + 2.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                    coa.charge[0].unlitApp.draw(d, x + 10.0 * scale, y + 18.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        COUNTERCHARGED(1, 1, null, new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                PARTY_PER_PALE_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].leftApp.draw(d, x, y, size / 2.0, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                        coa.charge[0].rightApp.draw(d, x + size / 2.0, y, size / 2.0, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialChargeLeft(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x, y, size / 2.0, size);
                    d.drawSpecialChargeRight(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), x + size / 2.0, y, size / 2.0, size);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_PARTY_PER_PALE_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialChargeLeft(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x, y, size / 2.0, size);
                    d.drawSpecialChargeRight(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), x + size / 2.0, y, size / 2.0, size);
                } else {
                    coa.charge[0].unlitLeftApp.draw(d, x, y, size / 2.0, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                    coa.charge[0].unlitRightApp.draw(d, x + size / 2.0, y, size / 2.0, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 8.0, 16.0);
                d.rect(Clr.BLACK, x + 8.0, y, 8.0, 16.0);
                d.rect(Clr.BLACK, x + 2.0, y + 2.0, 6.0, 12.0);
                d.rect(Clr.WHITE, x + 8.0, y + 2.0, 6.0, 12.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_PARTY_PER_PALE, coa.chargeT[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialChargeLeft(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale);
                    d.drawSpecialChargeRight(coa.specialCharge[0], coa.tincture[0].tint, x + 10.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale);
                } else {
                    coa.charge[0].unlitLeftApp.draw(d, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale, 0, coa.chargeT[0].tint, false);
                    coa.charge[0].unlitRightApp.draw(d, x + 18.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale, 0, coa.tincture[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        ON_BEND(1, 2, "on_bend_", new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE0}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                ON_BEND_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_ON_BEND_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.blit(ON_BEND_DETAIL.frames.get(0), Clr.GREY, x, y);
                d.rect(Clr.BLACK, x + 5.0, y + 5.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_ON_BEND, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        ON_BEND_SINISTER(1, 2, "on_bend_sinister_", new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE0}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                ON_BEND_SINISTER_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_ON_BEND_SINISTER_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.blit(ON_BEND_SINISTER_DETAIL.frames.get(0), Clr.GREY, x, y);
                d.rect(Clr.BLACK, x + 5.0, y + 5.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_ON_BEND_SINISTER, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        ON_CROSS(1, 2, "on_cross_", new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE0}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                ON_CROSS_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].app.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_ON_CROSS_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + size / 4.0, y + size / 4.0, size / 2.0, size / 2.0, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.blit(ON_CROSS_DETAIL.frames.get(0), Clr.GREY, x, y);
                d.rect(Clr.BLACK, x + 5.0, y + 5.0, 6.0, 6.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_ON_CROSS, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialCharge(coa.specialCharge[0], coa.chargeT[0].tint, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale);
                } else {
                    coa.charge[0].unlitApp.draw(d, x + 10.0 * scale, y + 10.0 * scale, 16.0 * scale, 16.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        SALTIRE(0, 2, "saltire_", new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                SALTIRE_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_SALTIRE_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.blit(SALTIRE_DETAIL.frames.get(0), Clr.GREY, x, y);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_SALTIRE, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        PALY(0, 2, "paly_", new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                PALY_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_PALY_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.blit(PALY_DETAIL.frames.get(0), Clr.GREY, x, y);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_PALY, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        BARRY(0, 2, "barry_", new TinctureSlot[0], new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                BARRY_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_BARRY_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 16.0, 16.0);
                d.blit(BARRY_DETAIL.frames.get(0), Clr.GREY, x, y);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_BARRY, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        }
        ,
        DIMIDIATED(2, 2, null, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.TINCTURE1}, new TinctureSlot[]{TinctureSlot.TINCTURE0, TinctureSlot.CHARGE0, TinctureSlot.TINCTURE1, TinctureSlot.CHARGE1}){

            @Override
            public void drawBase(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation) {
                FLAG.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE0, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
                PARTY_PER_PALE_DETAIL.drawSub(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.TINCTURE1, lightStrength), ambient, ambientSaturation, null, null, 0.0f);
            }

            @Override
            public void drawCharges(CoatOfArms coa, MyDraw d, double x, double y, double size, Image[] light, float lightStrength, Color ambient, float ambientSaturation, SpritesheetBundle ssb, HashSet<SpritesheetBundle> additionalSSBs) {
                if (coa.charge[0] != null) {
                    if (coa.charge[0].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[0].leftApp.draw(d, x, y, size / 2.0, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE0, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[0].app.spritesheetBundle);
                    }
                }
                if (coa.charge[1] != null) {
                    if (coa.charge[1].app.spritesheetBundle == ssb || ssb == null) {
                        coa.charge[1].rightApp.draw(d, x + size / 2.0, y, size / 2.0, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, null), false, light, CoatOfArms.li(coa, TinctureSlot.CHARGE1, lightStrength), ambient, ambientSaturation);
                    } else if (additionalSSBs != null) {
                        additionalSSBs.add(coa.charge[1].app.spritesheetBundle);
                    }
                }
            }

            @Override
            public void drawUnlitCharges(CoatOfArms coa, MyDraw d, double x, double y, double size) {
                if (coa.charge[0] == null) {
                    d.drawSpecialChargeLeft(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, null), x, y, size / 2.0, size);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialChargeRight(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, null), x + size / 2.0, y, size / 2.0, size);
                }
            }

            @Override
            public void drawUnlit(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
                UL_FLAG.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE0, highlight), false);
                UL_PARTY_PER_PALE_DETAIL.draw(d, x, y, size, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.TINCTURE1, highlight), false);
                if (coa.charge[0] == null) {
                    d.drawSpecialChargeLeft(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), x, y, size / 2.0, size);
                } else {
                    coa.charge[0].unlitLeftApp.draw(d, x, y, size / 2.0, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE0, highlight), false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialChargeRight(coa.specialCharge[0], CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight), x + size / 2.0, y, size / 2.0, size);
                } else {
                    coa.charge[1].unlitRightApp.draw(d, x + size / 2.0, y, size / 2.0, size, 0, CoatOfArms.tinc(d, coa, TinctureSlot.CHARGE1, highlight), false);
                }
            }

            @Override
            public void drawLayout(MyDraw d, double x, double y) {
                d.rect(Clr.WHITE, x, y, 8.0, 16.0);
                d.rect(Clr.BLACK, x + 8.0, y, 8.0, 16.0);
                d.rect(Clr.BLACK, x + 2.0, y + 2.0, 6.0, 12.0);
                d.rect(Clr.WHITE, x + 8.0, y + 2.0, 6.0, 12.0);
            }

            @Override
            public void drawShield(CoatOfArms coa, MyDraw d, double x, double y, double scale, Clr outlineTint) {
                CoatOfArms.d(d, SHIELD_CONTENT, coa.tincture[0].tint, x, y, 36.0 * scale, 41.0 * scale);
                CoatOfArms.d(d, SHIELD_PARTY_PER_PALE, coa.tincture[1].tint, x, y, 36.0 * scale, 41.0 * scale);
                if (coa.charge[0] == null) {
                    d.drawSpecialChargeLeft(coa.specialCharge[0], coa.chargeT[0].tint, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale);
                } else {
                    coa.charge[0].unlitLeftApp.draw(d, x + 2.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale, 0, coa.chargeT[0].tint, false);
                }
                if (coa.charge[1] == null) {
                    d.drawSpecialChargeRight(coa.specialCharge[1], coa.chargeT[1].tint, x + 10.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale);
                } else {
                    coa.charge[1].unlitRightApp.draw(d, x + 18.0 * scale, y + 2.0 * scale, 16.0 * scale, 32.0 * scale, 0, coa.chargeT[1].tint, false);
                }
                CoatOfArms.d(d, SHIELD_OUTLINE, outlineTint, x, y, 36.0 * scale, 41.0 * scale);
            }
        };

        public final int charges;
        public final int tinctures;
        public final String detailPrefix;
        public final EnumMap<TinctureSlot, EnumSet<TinctureSlot>> adjacency = new EnumMap(TinctureSlot.class);
        public final EnumMap<TinctureSlot, EnumSet<TinctureSlot>> onTop = new EnumMap(TinctureSlot.class);

        public void draw(CoatOfArms coa, MyDraw d, double x, double y, double size, TinctureSlot highlight) {
            this.drawUnlit(coa, d, x, y, size, highlight);
        }

        public abstract void drawBase(CoatOfArms var1, MyDraw var2, double var3, double var5, double var7, Image[] var9, float var10, Color var11, float var12);

        public abstract void drawCharges(CoatOfArms var1, MyDraw var2, double var3, double var5, double var7, Image[] var9, float var10, Color var11, float var12, SpritesheetBundle var13, HashSet<SpritesheetBundle> var14);

        public abstract void drawUnlitCharges(CoatOfArms var1, MyDraw var2, double var3, double var5, double var7);

        public abstract void drawUnlit(CoatOfArms var1, MyDraw var2, double var3, double var5, double var7, TinctureSlot var9);

        public abstract void drawLayout(MyDraw var1, double var2, double var4);

        public abstract void drawShield(CoatOfArms var1, MyDraw var2, double var3, double var5, double var7, Clr var9);

        private void adjacent(TinctureSlot a, TinctureSlot b) {
            if (!this.adjacency.containsKey((Object)a)) {
                this.adjacency.put(a, EnumSet.of(b));
            } else {
                this.adjacency.get((Object)a).add(b);
            }
            if (!this.adjacency.containsKey((Object)b)) {
                this.adjacency.put(b, EnumSet.of(a));
            } else {
                this.adjacency.get((Object)b).add(a);
            }
        }

        private void onTop(TinctureSlot a, TinctureSlot b) {
            if (!this.onTop.containsKey((Object)a)) {
                this.onTop.put(a, EnumSet.of(b));
            } else {
                this.onTop.get((Object)a).add(b);
            }
            if (!this.onTop.containsKey((Object)b)) {
                this.onTop.put(b, EnumSet.of(a));
            } else {
                this.onTop.get((Object)b).add(a);
            }
        }

        public String blazon(CoatOfArms coa) {
            return Lang._t("layout_" + this.name() + "_blazon", this.detailPrefix != null ? Lang._t(this.detailPrefix + coa.tincture[1].name(), new Object[0]) : "", coa.tincture[0].getName(), coa.tincture[1].getName(), coa.tincture[2].getName(), coa.tincture[3].getName(), coa.charge[0] == null ? coa.chargeName(0) + " " + coa.chargeT[0].getName() : Lang._t(coa.charge[0].name + "_" + coa.chargeT[0].name(), new Object[0]), coa.charge[1] == null ? coa.chargeName(1) + " " + coa.chargeT[1].getName() : Lang._t(coa.charge[1].name + "_" + coa.chargeT[1].name(), new Object[0]), coa.charge[2] == null ? coa.chargeName(2) + " " + coa.chargeT[2].getName() : Lang._t(coa.charge[2].name + "_" + coa.chargeT[2].name(), new Object[0]), coa.charge[3] == null ? coa.chargeName(3) + " " + coa.chargeT[3].getName() : Lang._t(coa.charge[3].name + "_" + coa.chargeT[3].name(), new Object[0]), coa.charge[0] == null ? coa.chargesName(0) + " " + coa.chargeT[0].getName() : Lang._t(coa.charge[0].name + "_" + coa.chargeT[0].name() + "_plural", new Object[0]), coa.charge[1] == null ? coa.chargesName(1) + " " + coa.chargeT[1].getName() : Lang._t(coa.charge[1].name + "_" + coa.chargeT[1].name() + "_plural", new Object[0]), coa.charge[2] == null ? coa.chargesName(2) + " " + coa.chargeT[2].getName() : Lang._t(coa.charge[2].name + "_" + coa.chargeT[2].name() + "_plural", new Object[0]), coa.charge[3] == null ? coa.chargesName(3) + " " + coa.chargeT[3].getName() : Lang._t(coa.charge[3].name + "_" + coa.chargeT[3].name() + "_plural", new Object[0]), coa.chargeT[0].getName(), coa.chargeName(0));
        }

        public String getName() {
            return Lang._t("layout_" + this.name(), new Object[0]);
        }

        private Layout(int charges, int tinctures, String detailPrefix, TinctureSlot[] adjacencies, TinctureSlot[] onTop) {
            int i;
            this.charges = charges;
            this.tinctures = tinctures;
            this.detailPrefix = detailPrefix;
            for (i = 0; i < adjacencies.length; i += 2) {
                this.adjacent(adjacencies[i], adjacencies[i + 1]);
            }
            for (i = 0; i < onTop.length; i += 2) {
                this.onTop(onTop[i], onTop[i + 1]);
            }
        }
    }

    public strictfp static enum TinctureSlot {
        TINCTURE0(0, -1),
        TINCTURE1(1, -1),
        TINCTURE2(2, -1),
        TINCTURE3(3, -1),
        CHARGE0(-1, 0),
        CHARGE1(-1, 1),
        CHARGE2(-1, 2),
        CHARGE3(-1, 3);

        public final int tinctureIndex;
        public final int chargeIndex;

        public static TinctureSlot tinctureOf(int index) {
            for (TinctureSlot ts : TinctureSlot.values()) {
                if (ts.tinctureIndex != index) continue;
                return ts;
            }
            return null;
        }

        public static TinctureSlot chargeTOf(int index) {
            for (TinctureSlot ts : TinctureSlot.values()) {
                if (ts.chargeIndex != index) continue;
                return ts;
            }
            return null;
        }

        private TinctureSlot(int tinctureIndex, int chargeIndex) {
            this.tinctureIndex = tinctureIndex;
            this.chargeIndex = chargeIndex;
        }

        public Tincture get(CoatOfArms coa) {
            return this.tinctureIndex == -1 ? coa.chargeT[this.chargeIndex] : coa.tincture[this.tinctureIndex];
        }
    }
}

