/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WeatherEffect;
import com.zarkonnen.catengine.Input;
import java.util.ArrayList;

public strictfp class CloudsVisualLayer
implements UniScreen.VisualLayer {
    public ArrayList<Cloud> clouds = new ArrayList();

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        TimeOfDay tod = us.getTimeOfDay();
        if (this.clouds.isEmpty()) {
            int nc = AGame.ANIM_R.nextInt(3) + 5;
            int globalY = 312 - AGame.ANIM_R.nextInt(1400);
            ArrayList<Appearance> cs = tod.clouds.clouds;
            block0: for (int i = 0; i < nc; ++i) {
                int x = AGame.ANIM_R.nextInt(6400) - 3200;
                int y = tod.cloudBottomsAligned ? globalY : 312 - AGame.ANIM_R.nextInt(1600);
                Appearance app = cs.get(AGame.ANIM_R.nextInt(cs.size()));
                for (Cloud c : this.clouds) {
                    if (!(c.x + (double)(c.app.width() * 16) > (double)x) || !((double)(x + app.width() * 16) > c.x)) continue;
                    continue block0;
                }
                this.clouds.add(new Cloud(app, x, y - app.height() * 16));
            }
        }
        WeatherEffect we = tod.effect;
        for (int i = 0; i < this.clouds.size(); ++i) {
            Cloud c = this.clouds.get(i);
            c.x += we.wind * (0.3 + (double)i * 0.05) * (double)ms;
            if (c.x + (double)(c.app.width() * 16) < -3200.0) {
                c.x = 3210.0;
            }
            if (!(c.x > 3200.0)) continue;
            c.x = -3200 - c.app.width() * 16 - 10;
        }
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.intent.drawAsBlueprint()) {
            return;
        }
        TimeOfDay tod = us.getTimeOfDay();
        int csz = this.clouds.size();
        for (int ci = 0; ci < csz; ++ci) {
            Cloud cloud = this.clouds.get(ci);
            if (!Rect2D.intersects(cropX, cropY, cropW, cropH, cloud.x, cloud.y, cloud.app.width() * 16, cloud.app.height() * 16)) continue;
            cloud.app.draw(d, (int)cloud.x, (int)cloud.y, 0, false, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientSaturation);
        }
    }

    public strictfp static class Cloud {
        public Appearance app;
        public double x;
        public double y;

        public Cloud(Appearance app, double x, double y) {
            this.app = app;
            this.x = x;
            this.y = y;
        }
    }
}

