/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.LaunchSettings;
import com.zarkonnen.catengine.util.Utils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.NotYetConnectedException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Future;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class Client {
    private final LinkedList<JSONObject> messagesIn = new LinkedList();
    private final LinkedList<Utils.Pair<Long, byte[]>> writeMessageQueue = new LinkedList();
    private final LinkedList<Utils.Pair<Long, byte[]>> unAcknowledgedMessages = new LinkedList();
    private Future<Void> connectFuture;
    private AsynchronousSocketChannel socketChannel;
    private ByteBuffer readBuffer = ByteBuffer.allocate(4096);
    private ByteBuffer writeBuffer = ByteBuffer.allocate(4096);
    private int nextMessageSize = -1;
    private Future<Integer> readFuture;
    private Future<Integer> writeFuture;
    private long readFutureStarted;
    private long writeFutureStarted;
    private boolean failed;
    private boolean attemptFullReconnect = false;
    private boolean sendingReconnectMessage = false;
    private boolean userRequestsClose = false;
    private boolean sendingBye = false;
    private long byeSent = 0L;
    private volatile boolean isClosed = false;
    private final String serverIP;
    private final AirshipGame g;
    private boolean messageTooLarge;
    private final LinkedList<Long> recentPings = new LinkedList();
    public static final double PING_FALLOFF_MULT = 0.7;
    public static final int RECENT_PING_WINDOW = 5;
    public long recentPing = 0L;
    private long mostRecentPingSentTime = 0L;
    private long mostRecentTickTime = 0L;
    private long longestTimeBetweenTicksSincePingSent = 0L;
    private long pingNonce = 0L;
    private boolean waitingForPing;
    private String uniqueID;
    private long messageIDCounter = 1L;
    private long mostRecentReceivedMessageID = -1L;
    private long reconnectTime;
    private int reconnectAttempt;
    private int unacknowledgedBytes;
    private long start;

    public long smoothedRecentPing() {
        double total = 0.0;
        double div = 0.0;
        double weight = 1.0;
        Iterator i$ = this.recentPings.iterator();
        while (i$.hasNext()) {
            long p = (Long)i$.next();
            total += (double)p * weight;
            div += weight;
            weight *= 0.7;
        }
        return (long)(total / div);
    }

    public boolean isMessageTooLarge() {
        return this.messageTooLarge;
    }

    public void clearMessageTooLarge() {
        this.messageTooLarge = false;
    }

    public int outQueueSize() {
        return this.writeMessageQueue.size();
    }

    public int inQueueSize() {
        return this.messagesIn.size();
    }

    public static JSONObject msg(String type) {
        return new JSONObject().put("type", type).put("t", DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
    }

    public static JSONObject gmsg(String type) {
        return new JSONObject().put("type", type).put("global", true).put("t", DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
    }

    public JSONObject pollMessageRaw() {
        this.tick();
        return this.messagesIn.pollFirst();
    }

    public final boolean sendMessageRawWithSizeCheck(JSONObject msg) {
        try {
            long mid = this.messageIDCounter++;
            msg.put("###", mid);
            byte[] msgData = msg.toString().getBytes("UTF-8");
            if (msgData.length > LaunchSettings.maxNetworkSendBytes) {
                return false;
            }
            this.writeMessageQueue.add((Utils.Pair<Long, byte[]>)new Utils.Pair((Object)mid, (Object)msgData));
            this.tick();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public final void sendMessageRaw(JSONObject msg) {
        try {
            long mid = this.messageIDCounter++;
            msg.put("###", mid);
            byte[] msgData = msg.toString().getBytes("UTF-8");
            if (msgData.length > LaunchSettings.maxNetworkSendBytes) {
                this.messageTooLarge = true;
            } else {
                this.writeMessageQueue.add((Utils.Pair<Long, byte[]>)new Utils.Pair((Object)mid, (Object)msgData));
                this.tick();
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    private void ack(long mid) {
        try {
            this.writeMessageQueue.add((Utils.Pair<Long, byte[]>)new Utils.Pair(null, (Object)new JSONObject().put("type", "ack").put("mid", mid).toString().getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isConnectedRaw() {
        return this.attemptFullReconnect || this.socketChannel != null && this.socketChannel.isOpen();
    }

    public boolean isDisconnected() {
        return this.isClosed;
    }

    public boolean connectionFailed() {
        return this.failed;
    }

    public boolean isConnecting() {
        return this.connectFuture != null;
    }

    public boolean isReconnecting() {
        return this.attemptFullReconnect;
    }

    public Client(String serverIP, AirshipGame g) {
        this.serverIP = serverIP;
        this.g = g;
        this.sendMessageRaw(Client.msg("retainMeIWillAckMessages").put("playerName", g.playerName()));
        this.start = System.currentTimeMillis();
    }

    private void reconnectFailure() {
        this.connectFuture = null;
        if (this.reconnectAttempt++ >= LaunchSettings.maxReconnectAttempts) {
            System.err.println("Reconnect failure. Giving up.@" + System.currentTimeMillis());
            this.failureClose();
        } else {
            System.err.println("Reconnect failure. Waiting.@" + System.currentTimeMillis());
            this.reconnectTime = System.currentTimeMillis() + (long)LaunchSettings.reconnectAttemptIntervalMilliseconds;
        }
    }

    private void failureClose() {
        this.g.showError(Lang._t("Connection_lost", new Object[0]));
        try {
            this.socketChannel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.isClosed = true;
        this.failed = true;
    }

    public void tick() {
        long currentTime = System.currentTimeMillis();
        if (this.mostRecentTickTime == 0L) {
            this.mostRecentTickTime = currentTime;
        }
        this.longestTimeBetweenTicksSincePingSent = Math.max(currentTime - this.mostRecentTickTime, this.longestTimeBetweenTicksSincePingSent);
        for (int i = 0; i < 4; ++i) {
            if (this.isClosed) {
                return;
            }
            if (this.userRequestsClose && (this.byeSent != 0L || this.attemptFullReconnect)) {
                if (this.attemptFullReconnect || currentTime > this.byeSent + 5000L) {
                    try {
                        this.socketChannel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.isClosed = true;
                    System.err.println("Closed on user behalf. afr=" + this.attemptFullReconnect + "@" + currentTime);
                }
                return;
            }
            if (this.attemptFullReconnect) {
                if (currentTime < this.reconnectTime) {
                    return;
                }
                if (this.connectFuture == null) {
                    System.err.println("Resetting for reconnect @ " + currentTime);
                    this.waitingForPing = false;
                    this.readFuture = null;
                    this.writeFuture = null;
                    this.connectFuture = null;
                    this.readBuffer = ByteBuffer.allocate(4096);
                    this.writeBuffer = ByteBuffer.allocate(4096);
                    this.nextMessageSize = -1;
                    this.writeMessageQueue.addAll(0, this.unAcknowledgedMessages);
                    this.unAcknowledgedMessages.clear();
                    this.unacknowledgedBytes = 0;
                    try {
                        this.socketChannel.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        this.socketChannel = AsynchronousSocketChannel.open();
                        this.connectFuture = this.socketChannel.connect(new InetSocketAddress(this.serverIP, 29143));
                        System.err.println("Created connect future@" + currentTime);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.reconnectFailure();
                        return;
                    }
                }
                if (this.connectFuture.isDone()) {
                    try {
                        this.connectFuture.get();
                    }
                    catch (Exception e) {
                        this.reconnectFailure();
                        return;
                    }
                    this.connectFuture = null;
                    if (!this.socketChannel.isOpen()) {
                        this.reconnectFailure();
                        return;
                    }
                    try {
                        this.writeMessageQueue.add(0, (Utils.Pair<Long, byte[]>)new Utils.Pair(null, (Object)Client.msg("fullReconnect").put("uniqueID", this.uniqueID).toString().getBytes("UTF-8")));
                        this.sendingReconnectMessage = true;
                        System.err.println("Sent fullReconnect message@" + currentTime);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    this.attemptFullReconnect = false;
                    this.reconnectAttempt = 0;
                    this.reconnectTime = currentTime;
                }
                return;
            }
            if (this.socketChannel == null) {
                try {
                    this.socketChannel = AsynchronousSocketChannel.open();
                    this.connectFuture = this.socketChannel.connect(new InetSocketAddress(this.serverIP, 29142));
                }
                catch (Exception e) {
                    System.err.println("socketChannel failureClose@" + currentTime);
                    e.printStackTrace();
                    this.failureClose();
                    return;
                }
            }
            if (this.connectFuture != null) {
                if (this.connectFuture.isDone()) {
                    try {
                        this.connectFuture.get();
                    }
                    catch (Exception e) {
                        this.failureClose();
                        return;
                    }
                    this.connectFuture = null;
                    if (!this.socketChannel.isOpen()) {
                        this.failureClose();
                        return;
                    }
                } else {
                    return;
                }
            }
            if (!(this.userRequestsClose || this.unacknowledgedBytes >= LaunchSettings.maxNetworkSendBytes || this.isConnecting() || this.waitingForPing || this.mostRecentPingSentTime + (long)LaunchSettings.measureNetworkDelayEveryMilliseconds >= currentTime || this.reconnectTime + (long)LaunchSettings.minimumLagReconnectInterval >= currentTime)) {
                this.pingNonce = AGame.ANIM_R.nextLong();
                try {
                    this.writeMessageQueue.add((Utils.Pair<Long, byte[]>)new Utils.Pair(null, (Object)Client.msg("ping").put("timestamp", currentTime).put("nonce", this.pingNonce).toString().getBytes("UTF-8")));
                    this.waitingForPing = true;
                    this.mostRecentPingSentTime = currentTime;
                    this.longestTimeBetweenTicksSincePingSent = 0L;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            if (this.writeFuture != null) {
                if (this.writeFuture.isDone()) {
                    try {
                        this.writeFuture.get();
                    }
                    catch (Exception e) {
                        if (this.userRequestsClose) {
                            System.err.println("writeFuture exception@" + currentTime);
                            e.printStackTrace();
                            System.err.println("Bye sent, effectively.@" + currentTime);
                            this.byeSent = currentTime;
                        } else {
                            System.err.println("writeFuture exception@" + currentTime);
                            e.printStackTrace();
                            System.err.println("Attempt full reconnect, please @" + currentTime);
                            this.attemptFullReconnect = true;
                        }
                        return;
                    }
                    this.writeFuture = null;
                    if (this.sendingBye) {
                        System.err.println("Bye sent.@" + currentTime);
                        this.byeSent = currentTime;
                        return;
                    }
                    if (this.sendingReconnectMessage) {
                        System.err.println("Reconnect message sent.@" + currentTime);
                        this.sendingReconnectMessage = false;
                    }
                    if (this.writeBuffer.hasRemaining()) {
                        this.writeFuture = this.socketChannel.write(this.writeBuffer);
                        this.writeFutureStarted = currentTime;
                    }
                } else if (this.writeFutureStarted + (long)LaunchSettings.tooMuchNetworkDelayMilliseconds < currentTime) {
                    System.err.println("Write timeout.");
                    System.err.println("Attempt full reconnect, please @" + currentTime);
                    this.attemptFullReconnect = true;
                    return;
                }
            }
            if (this.writeFuture == null && !this.writeMessageQueue.isEmpty() && this.unacknowledgedBytes < LaunchSettings.maxNetworkSendBytes) {
                try {
                    Utils.Pair<Long, byte[]> idAndMsg = this.writeMessageQueue.pollFirst();
                    byte[] msg = (byte[])idAndMsg.b;
                    if (idAndMsg.a != null) {
                        this.unAcknowledgedMessages.add(idAndMsg);
                        this.unacknowledgedBytes += msg.length;
                    }
                    if (this.writeBuffer.capacity() < msg.length + 4) {
                        this.writeBuffer = ByteBuffer.allocate(msg.length + 4 + 128);
                    }
                    this.writeBuffer.clear();
                    this.writeBuffer.putInt(msg.length);
                    this.writeBuffer.put(msg);
                    this.writeBuffer.flip();
                    this.writeFuture = this.socketChannel.write(this.writeBuffer);
                    this.writeFutureStarted = currentTime;
                    if (this.userRequestsClose) {
                        System.err.println("Sending bye.@" + currentTime);
                        this.sendingBye = true;
                    }
                }
                catch (NotYetConnectedException nyce) {
                    if (this.userRequestsClose) {
                        System.err.println("writeFuture nyce@" + currentTime);
                        this.byeSent = currentTime;
                    } else {
                        System.err.println("NotYetConnectedException when writing");
                        System.err.println("Attempt full reconnect, please @" + currentTime);
                        this.attemptFullReconnect = true;
                    }
                    return;
                }
            }
            if (this.readFuture == null) {
                try {
                    this.readFuture = this.socketChannel.read(this.readBuffer);
                    this.readFutureStarted = currentTime;
                }
                catch (NotYetConnectedException nyce) {
                    if (this.userRequestsClose) {
                        System.err.println("readFuture nyce@" + currentTime);
                        this.byeSent = currentTime;
                    } else {
                        System.err.println("NotYetConnectedException when reading");
                        System.err.println("Attempt full reconnect, please @" + currentTime);
                        this.attemptFullReconnect = true;
                    }
                    return;
                }
            }
            if (this.readFuture.isDone()) {
                try {
                    if (this.readFuture.get() == -1) {
                        this.attemptFullReconnect = true;
                        System.err.println("-1 when reading");
                        System.err.println("Attempt full reconnect, please @" + currentTime);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Attempt full reconnect, please @" + currentTime);
                    this.attemptFullReconnect = true;
                    return;
                }
                this.readBuffer.flip();
                boolean progress = true;
                while (progress) {
                    block76: {
                        progress = false;
                        if (this.nextMessageSize == -1 && this.readBuffer.remaining() >= 4) {
                            progress = true;
                            this.nextMessageSize = this.readBuffer.getInt();
                            if (this.nextMessageSize > this.readBuffer.capacity()) {
                                ByteBuffer rb2 = ByteBuffer.allocate(this.nextMessageSize + 1024);
                                rb2.put(this.readBuffer);
                                this.readBuffer = rb2;
                                this.readBuffer.flip();
                            }
                        }
                        if (this.nextMessageSize == -1 || this.readBuffer.remaining() < this.nextMessageSize) continue;
                        progress = true;
                        byte[] msgBytes = new byte[this.nextMessageSize];
                        this.readBuffer.get(msgBytes);
                        try {
                            long mid;
                            JSONObject inMsg = new JSONObject(new String(msgBytes, "UTF-8"));
                            boolean skip = false;
                            if (inMsg.has("###")) {
                                mid = inMsg.getLong("###");
                                boolean bl = skip = this.mostRecentReceivedMessageID >= mid;
                                if (!skip) {
                                    this.mostRecentReceivedMessageID = mid;
                                }
                                this.ack(mid);
                            }
                            if (skip) {
                                System.err.println("Skip@" + currentTime);
                                this.reconnectTime = currentTime;
                            }
                            if (skip) break block76;
                            this.messagesIn.add(inMsg);
                            if (inMsg.optString("type", "?").equals("ack")) {
                                mid = inMsg.getLong("mid");
                                for (int j = 0; j < this.unAcknowledgedMessages.size(); ++j) {
                                    if ((Long)this.unAcknowledgedMessages.get((int)j).a > mid) continue;
                                    this.unacknowledgedBytes -= ((byte[])this.unAcknowledgedMessages.get((int)j).b).length;
                                    this.unAcknowledgedMessages.remove(j);
                                }
                            }
                            if (inMsg.optString("type", "?").equals("assignID")) {
                                this.uniqueID = inMsg.optString("uniqueID", null);
                            }
                            if (!this.waitingForPing || !inMsg.optString("type", "?").equals("frame")) break block76;
                            JSONArray a = inMsg.getJSONArray("messages");
                            for (int j = 0; j < a.length(); ++j) {
                                JSONObject frameMsg = a.getJSONObject(j);
                                if (!frameMsg.optString("type", "?").equals("ping") || frameMsg.getLong("nonce") != this.pingNonce) continue;
                                this.recentPing = currentTime - frameMsg.getLong("timestamp") - this.longestTimeBetweenTicksSincePingSent;
                                this.recentPings.add(0, this.recentPing);
                                if (this.recentPings.size() > 5) {
                                    this.recentPings.remove(this.recentPings.size() - 1);
                                }
                                this.waitingForPing = false;
                                if (this.recentPing > (long)LaunchSettings.tooMuchNetworkDelayMilliseconds && this.reconnectTime + (long)LaunchSettings.minimumLagReconnectInterval < currentTime) {
                                    this.attemptFullReconnect = true;
                                    System.err.println("Bad ping " + this.recentPing);
                                    System.err.println("Attempt full reconnect, please @" + currentTime);
                                }
                                break;
                            }
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    }
                    this.nextMessageSize = -1;
                    if (this.readBuffer.remaining() < 4) continue;
                    this.nextMessageSize = this.readBuffer.getInt();
                    if (this.nextMessageSize <= this.readBuffer.capacity()) continue;
                    ByteBuffer rb2 = ByteBuffer.allocate(this.nextMessageSize + 1024);
                    rb2.put(this.readBuffer);
                    this.readBuffer = rb2;
                    this.readBuffer.flip();
                }
                this.readBuffer.compact();
                if (this.nextMessageSize != -1) {
                    this.readBuffer.limit(this.nextMessageSize);
                } else {
                    this.readBuffer.limit(4);
                }
                this.readFuture = this.socketChannel.read(this.readBuffer);
                this.readFutureStarted = currentTime;
                continue;
            }
            if (this.readFutureStarted + (long)LaunchSettings.tooMuchNetworkDelayMilliseconds >= currentTime || this.reconnectTime + (long)LaunchSettings.tooMuchNetworkDelayMillisecondsOnReconnect >= currentTime) continue;
            System.err.println("Read timeout @" + currentTime);
            this.attemptFullReconnect = true;
            return;
        }
        this.mostRecentTickTime = System.currentTimeMillis();
    }

    public void close() {
        try {
            this.writeMessageQueue.add(0, (Utils.Pair<Long, byte[]>)new Utils.Pair(null, (Object)Client.msg("bye").toString().getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        System.err.println("Bye enqueued.@" + System.currentTimeMillis());
        this.userRequestsClose = true;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Client.this.isClosed) {
                    Client.this.tick();
                }
                System.err.println("Client closed.@" + System.currentTimeMillis());
                AirshipGame.instance.delayExitForNetwork = 0;
            }
        });
        t.setDaemon(true);
        t.setName("Client closer thread");
        t.start();
        AirshipGame.instance.delayExitForNetwork = 6000;
    }
}

