/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.EmpireStat;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.HeraldicStyle;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.MonsterNest;
import com.zarkonnen.airships.ShapeUtils;
import com.zarkonnen.airships.ShipArrayList;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.TakeoverMethod;
import com.zarkonnen.airships.WorldMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.json.JSONObject;

public strictfp class City
extends MapLocation {
    public static final double ECON_DMG_MALUS = 0.2;
    public static final int MAX_ECON_DAMAGES = 4;
    public static final int ECON_DAMAGE_RECOVERY_TIME = 180000;
    public static final int LOOT_PER_ECON_DAMAGE = 650;
    public String name;
    public int income;
    public int economicDamage;
    public int econDmgRecovery;
    public int appearance;
    public int shipyardLevel;
    public int takeoverAmount;
    public boolean isTown;
    public TakeoverMethod takeoverMethod;
    public boolean takeoverNeeded = false;
    public boolean constructionTargetOutOfCostGamut;
    public boolean constructionTargetForcedToBeShip;
    public Empire originalEmpire;
    public int alertAmount = 0;
    public CoatOfArms originalArms;
    public transient ArrayList<MonsterNest> nestsInTerritory = null;
    public transient ShapeUtils.TrianglesArea territoryPolygon;
    public static final String[] SHIPYARD_SIZES = new String[]{"shipyard_no", "shipyard_tiny", "shipyard_small", "shipyard_medium", "shipyard_large", "shipyard_huge"};

    public City(int id, int x, int y, String name, boolean isTown, int income, int shipyardLevel, CoatOfArms originalArms, int appearance) {
        super(id, x, y);
        this.name = name;
        this.isTown = isTown;
        this.income = income;
        this.shipyardLevel = shipyardLevel;
        this.originalArms = originalArms;
        this.appearance = appearance;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    public City(JSONObject o, HashMap<Integer, LandBlockType>[] mappingRef) {
        super(o, mappingRef);
        this.name = o.getString("name");
        this.income = o.getInt("income");
        this.shipyardLevel = o.getInt("shipyardLevel");
        this.takeoverAmount = o.getInt("takeoverAmount");
        this.takeoverNeeded = o.getBoolean("takeoverNeeded");
        this.alertAmount = o.optInt("alertAmount", 0);
        this.economicDamage = o.optInt("economicDamage", 0);
        this.econDmgRecovery = o.optInt("econDmgRecovery", 0);
        this.appearance = o.optInt("appearance", AGame.ANIM_R.nextInt(10));
        this.isTown = o.optBoolean("isTown", false);
        if (o.has("takeoverMethod")) {
            this.takeoverMethod = TakeoverMethod.valueOf(o.getString("takeoverMethod"));
        }
        this.constructionTargetOutOfCostGamut = o.optBoolean("constructionTargetOutOfCostGamut", false);
        this.constructionTargetForcedToBeShip = o.optBoolean("constructionTargetForcedToBeShip", false);
        if (o.has("originalArms")) {
            try {
                this.originalArms = new CoatOfArms(o.getJSONObject("originalArms"));
            }
            catch (Exception e) {
                this.originalArms = CoatOfArms.getRandom(new Random(this.name.hashCode()), HeraldicStyle.ofName("city"));
            }
        } else {
            this.originalArms = CoatOfArms.getRandom(new Random(this.name.hashCode()), HeraldicStyle.ofName("city"));
        }
    }

    public void finish(JSONObject o, WorldMap wm) {
        if (o.has("originalEmpire") && o.getInt("originalEmpire") != -1) {
            this.originalEmpire = wm.empires.get(o.getInt("originalEmpire"));
        }
    }

    public JSONObject toJSON(WorldMap wm) {
        JSONObject o = super.toJSON().put("name", this.name).put("income", this.income).put("isTown", this.isTown).put("shipyardLevel", this.shipyardLevel).put("takeoverAmount", this.takeoverAmount).put("constructionTargetOutOfCostGamut", this.constructionTargetOutOfCostGamut).put("constructionTargetForcedToBeShip", this.constructionTargetForcedToBeShip).put("takeoverNeeded", this.takeoverNeeded).put("alertAmount", this.alertAmount).put("economicDamage", this.economicDamage).put("econDmgRecovery", this.econDmgRecovery).put("appearance", this.appearance);
        if (this.takeoverMethod != null) {
            o.put("takeoverMethod", this.takeoverMethod.name());
        }
        if (this.originalEmpire != null && wm.empires.contains(this.originalEmpire)) {
            o.put("originalEmpire", wm.empires.indexOf(this.originalEmpire));
        }
        o.put("originalArms", this.originalArms.toJSON());
        return o;
    }

    public int adjustedIncome(WorldMap wm) {
        return StrictMath.max(0, (int)((double)this.cityIncomeChangeFromNests(wm) + (double)this.income * (1.0 - (double)this.economicDamage * 0.2) * (double)(100 + this.cityIncomeChangePercent(wm)) * 0.01 * (double)(this.takeoverMethod == null ? 1 : this.takeoverMethod.lootingIncomeMultiplier)));
    }

    public ArrayList<MonsterNest> nestsInTerritory(WorldMap wm) {
        if (this.nestsInTerritory == null) {
            this.nestsInTerritory = new ArrayList();
            for (MonsterNest n : wm.nests) {
                if (wm.cityOwnership[n.y][n.x] != this.id) continue;
                this.nestsInTerritory.add(n);
            }
        }
        return this.nestsInTerritory;
    }

    public int cityIncomeChangePercent(WorldMap wm) {
        int p = EmpireStat.CITY_INCOME_PERCENTAGE_BONUS.get(wm.owner(this).bonuses());
        for (MonsterNest n : this.nestsInTerritory(wm)) {
            if (n.type == null) continue;
            p += n.type.incomeModifierPercentage;
        }
        return p;
    }

    public int cityIncomeChangeFromNests(WorldMap wm) {
        int p = 0;
        for (MonsterNest n : this.nestsInTerritory(wm)) {
            if (n.type == null) continue;
            p += n.type.incomeModifier;
        }
        return p;
    }

    public int defencesMaintenanceCost() {
        int c = 0;
        for (Airship b : this.defences) {
            c += b.maintenanceCost();
        }
        return c;
    }

    public int constructionTimeCost() {
        if (this.constructing.isEmpty()) {
            return 0;
        }
        return StrictMath.max(0, ((MapLocation.ConstructionEntry)this.constructing.get((int)0)).cost) * 70 + 3000;
    }

    public boolean canBuild(ShipType st) {
        return !this.takeoverNeeded && this.takeoverMethod == null && (!this.isTown || !st.mobile);
    }

    public void tick(int ms, Empire owner, WorldMap map) {
        this.tickMessages();
        this.alertAmount -= ms;
        if (this.alertAmount < 0) {
            this.alertAmount = 0;
        }
        if (this.economicDamage > 0) {
            this.econDmgRecovery += ms;
            if (this.econDmgRecovery > 180000) {
                --this.economicDamage;
                this.econDmgRecovery -= 180000;
                this.addMessage(MapLocation.MessageType.ECON_RECOVERY, Lang._t(this.economicDamage == 0 ? "x_has_fully_recovered_from_the_war" : "x_has_partly_recovered_from_the_war", this.name));
            }
        }
        if (this.takeoverMethod != null) {
            this.takeoverAmount += ms;
            if (this.takeoverAmount >= this.takeoverMethod.takeoverTime) {
                this.economicDamage = StrictMath.min(4, this.economicDamage + this.takeoverMethod.economicDamage);
                this.takeoverMethod = null;
            }
        }
        if (this.takeoverMethod == null && !this.constructing.isEmpty()) {
            Airship c = ((MapLocation.ConstructionEntry)this.constructing.get((int)0)).ship;
            this.constructionProgress = (int)((double)this.constructionProgress + (double)(ms * this.shipyardLevel) * (owner.playerControlled ? 1.0 : map.difficulty.aiProductionMultiplier));
            if (this.constructionProgress >= this.constructionTimeCost()) {
                this.constructing.remove(0);
                this.constructionProgress = 0;
                int oldCost = 0;
                try {
                    oldCost = c.getCost();
                    c.repair();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    c = null;
                    owner.money += oldCost;
                }
                if (c != null) {
                    if (c.type.mobile) {
                        owner.addShipAt(c, this, map);
                    } else {
                        this.defences.add(c);
                    }
                }
            }
        }
    }

    @Override
    public ShipList shipList(WorldMap wm) {
        ShipArrayList l = new ShipArrayList(this.defences);
        Fleet fl = wm.getGarrison(this);
        if (fl != null) {
            l.ships.addAll(fl.actives);
        }
        return l;
    }

    public int refund(MapLocation.ConstructionEntry ce) {
        if (this.constructing.isEmpty()) {
            return 0;
        }
        if (ce == this.constructing.get(0)) {
            double constructionProportion = (double)this.constructionProgress * 1.0 / (double)this.constructionTimeCost();
            return (int)StrictMath.floor((double)ce.cost * (constructionProportion * 0.25 + (1.0 - constructionProportion)));
        }
        return ce.cost;
    }
}

