/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.ShipType;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class ChannelInfo {
    public final String name;
    public final int id;
    public final JSONObject info;
    public final int players;
    public final boolean sealed;

    public ChannelInfo(int id, JSONObject info, int players, boolean sealed) {
        int i;
        this.id = id;
        this.info = info;
        this.sealed = sealed;
        String nm = info.optString("name", Lang._t("Nameless_Channel", new Object[0]));
        if (info.optString("mode", "combat").equals("combat")) {
            JSONArray a;
            String typeInfo = "";
            if (info.has("shipTypes") && (a = info.getJSONArray("shipTypes")).length() != ShipType.values().length) {
                for (i = 0; i < a.length(); ++i) {
                    typeInfo = typeInfo + ", ";
                    typeInfo = typeInfo + Lang._t(a.getString(i) + "_plural", new Object[0]);
                }
            }
            nm = nm + " " + Lang._t("mode_combat", new Object[0]) + ", $" + info.optInt("costLimit", 0) + (info.optBoolean("oneShipOnly", false) ? ", " + Lang._t("One_Ship_Only", new Object[0]) : "") + typeInfo;
        } else if (info.optString("mode", "combat").equals("conquest")) {
            nm = nm + " " + Lang._t("mode_conquest", new Object[0]);
        }
        nm = nm + "\n" + (info.optInt("version", 0) == 101301 ? "" : MyDraw.ERROR_C) + (info.has("version") ? "v" + info.getInt("version") + " " : "Unknown Version ") + "[ffffff]";
        if (info.has("mods") && info.getJSONArray("mods").length() > 0) {
            JSONArray mods = info.getJSONArray("mods");
            nm = nm + "\n[ffffff]Mods: ";
            boolean incompatible = false;
            for (i = 0; i < mods.length(); ++i) {
                JSONObject m = mods.getJSONObject(i);
                boolean available = Mod.isAvailable(m.getString("id"), m.getLong("checksum"));
                if (available) {
                    nm = nm + ChannelInfo.getModName(m.getJSONObject("name"), m.getString("id"));
                } else if (Mod.getById(m.getString("id")) != null) {
                    incompatible = true;
                    nm = nm + MyDraw.ERROR_C + ChannelInfo.getModName(m.getJSONObject("name"), m.getString("id")) + "*[ffffff]";
                } else {
                    nm = nm + MyDraw.ERROR_C + ChannelInfo.getModName(m.getJSONObject("name"), m.getString("id")) + "[ffffff]";
                }
                if (i >= mods.length() - 1) continue;
                nm = nm + ", ";
            }
            if (incompatible) {
                nm = nm + "\n[ff3333]*" + Lang._t("incompatible_mod_message", new Object[0]);
            }
        }
        this.name = nm.replace("{", "").replace("}", "");
        this.players = players;
    }

    public boolean canJoin() {
        if (this.info.has("mods")) {
            JSONArray mods = this.info.getJSONArray("mods");
            for (int i = 0; i < mods.length(); ++i) {
                JSONObject m = mods.getJSONObject(i);
                if (Mod.isAvailable(m.getString("id"), m.getLong("checksum"))) continue;
                return false;
            }
        }
        return !this.sealed && (this.info.optString("mode", "combat").equals("combat") ? this.players == 1 : this.players > 0) && this.info.optInt("version", 0) == 101301;
    }

    public static String getModName(JSONObject o, String id) {
        return o.has(Lang.currentLocale.toLanguageTag()) ? o.getString(Lang.currentLocale.toLanguageTag()) : (o.has(Locale.ENGLISH.toLanguageTag()) ? o.getString(Locale.ENGLISH.toLanguageTag()) : id);
    }
}

