/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatInfo;
import com.zarkonnen.airships.CombatOutcome;
import com.zarkonnen.airships.Compression;
import com.zarkonnen.airships.DifficultyLevel;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.EmpireStat;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.FleetOwner;
import com.zarkonnen.airships.GenericChatMsg;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MapLocation;
import com.zarkonnen.airships.MapSize;
import com.zarkonnen.airships.Mod;
import com.zarkonnen.airships.MonsterNest;
import com.zarkonnen.airships.MonsterSetting;
import com.zarkonnen.airships.MultiplayerCampaignCombatIntent;
import com.zarkonnen.airships.MultiplayerCampaignCombatSetupIntent;
import com.zarkonnen.airships.PhysicsRect;
import com.zarkonnen.airships.ResearchSpeed;
import com.zarkonnen.airships.SeaLevelSetting;
import com.zarkonnen.airships.SecretPoliceLevel;
import com.zarkonnen.airships.Server;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.StrategicAI;
import com.zarkonnen.airships.StrategicChatMsg;
import com.zarkonnen.airships.StrategicHelp;
import com.zarkonnen.airships.StrategicPlayerInfo;
import com.zarkonnen.airships.StrategicSetupInfo;
import com.zarkonnen.airships.TakeoverMethod;
import com.zarkonnen.airships.Tech;
import com.zarkonnen.airships.TechSpeedSetting;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONObject;

public strictfp class CampaignWorld
implements JSONAble {
    public static boolean MAGIC_WIN_ENABLED = false;
    public static final int SPEED_DIV = 8;
    public final WorldMap map;
    public Empire player;
    public CombatInfo combatInfo;
    public transient Speed speed = Speed.NORMAL;
    public transient HashMap<Integer, Speed> speedVoters;
    public final AirshipGame g;
    public StrategicHelp help = new StrategicHelp();
    private transient int accumulatedMs;
    public transient int frameAccumulatedMs;
    public Combat currentCombat;
    public boolean waitingForCombatSetup;
    public transient MultiplayerCampaignCombatSetupIntent multiplayerCampaignCombatSetupIntent;
    public transient MultiplayerCampaignCombatIntent multiplayerCampaignCombatIntent;
    private final LinkedList<JSONObject> frameQueue = new LinkedList();
    public transient ArrayList<GenericChatMsg> chatMessages = new ArrayList();
    public transient HashMap<Integer, StrategicPlayerInfo> channelPlayers;
    public transient ArrayList<StrategicPlayerInfo> disconnectedPlayers = new ArrayList();
    public transient ArrayList<StrategicPlayerInfo> defeatedPlayers = new ArrayList();
    public transient int defeatedPlayersSeenIndex = 0;
    public static final boolean CHECKSUM = true;
    public static final int SYNC_CHECK_EVERY = 10000;
    private transient boolean desyncDetected = false;
    private transient int desyncDetectedAt = -1;
    private final transient JSONArray consumedFrames = new JSONArray();
    private final transient ArrayList<StoredState> storedStates = new ArrayList();
    private final transient HashMap<Utils.Pair<Integer, Integer>, ArrayList<JSONObject>> futureChecksums = new HashMap();
    public transient int playerEmpireIndex;
    public Client mpClient;
    public Server mpServer;
    public static final HashMap<String, CommandExecutor> EXECS = new HashMap();
    public static final int SAVE_VERSION = 10620;
    public static final ArrayList<Integer> READABLE_VERSIONS;

    private boolean combatStarted() {
        return this.combatInfo != null && !this.waitingForCombatSetup && this.multiplayerCampaignCombatSetupIntent == null;
    }

    private boolean inCombatSetup() {
        return this.combatInfo != null && (this.waitingForCombatSetup || this.multiplayerCampaignCombatSetupIntent != null);
    }

    public boolean desyncPubliclyDetected() {
        return this.desyncDetected && this.map.age > this.desyncDetectedAt + 13000;
    }

    public int frameQueueSize() {
        return this.frameQueue.size();
    }

    public boolean isMultiplayer() {
        return this.mpClient != null;
    }

    public boolean isHost() {
        return this.mpServer != null;
    }

    public JSONObject shipMsg(String type, Airship ship) {
        return Client.msg(type).put("networkID", ship.networkID);
    }

    public void giveCommand(JSONObject cmd) {
        if (this.mpClient != null) {
            this.g.sendMessage(cmd);
        } else {
            this.execCommand(cmd);
        }
    }

    public boolean giveCommandWithSizeCheck(JSONObject cmd) {
        if (this.mpClient != null) {
            return this.g.sendMessageWithSizeCheck(cmd);
        }
        this.execCommand(cmd);
        return true;
    }

    private void execCommand(JSONObject cmd) {
        String type = cmd.getString("type");
        if (!EXECS.containsKey(type)) {
            if (!Combat.EXECS.containsKey(type)) {
                this.g.reportError("Unknown command: " + type, null, cmd.toString(), false, true);
            }
            return;
        }
        EXECS.get(cmd.getString("type")).run(cmd, this.map, this);
    }

    private static Airship getShip(JSONObject cmd, WorldMap m) {
        return m.getShip(cmd.getString("networkID"));
    }

    static void checkStrategicChecksum(JSONObject cmd, StoredState state, CampaignWorld w) {
        int hash = cmd.getInt("hash");
        int playerID = cmd.getInt("playerID");
        if (state.hash == hash) {
            state.confirmedPlayerIDs.add(playerID);
            if (state.confirmedPlayerIDs.containsAll(w.channelPlayers.keySet()) && w.storedStates.indexOf(state) == 1) {
                w.storedStates.remove(0);
            }
        } else if (!w.desyncDetected) {
            w.desyncDetected = true;
            w.desyncDetectedAt = w.map.age;
            int prevStateIndex = w.storedStates.indexOf(state);
            StoredState prevState = null;
            if (prevStateIndex > 0) {
                prevState = w.storedStates.get(prevStateIndex - 1);
            }
            w.storedStates.clear();
            String errorMessage = "Desync @ " + cmd.getInt("age") + " ct " + cmd.getInt("combatTime") + " myID " + w.g.playerID() + " " + state.hash + " vs " + playerID + " " + hash;
            System.out.println(errorMessage);
            errorMessage = errorMessage + "\nFrames\n" + Compression.compressToString(w.consumedFrames.toString(4));
            errorMessage = errorMessage + "\nDesyncState\n" + state.state;
            if (prevState != null) {
                errorMessage = errorMessage + "\nPrevState\n" + prevState.state;
            }
            w.g.reportError(errorMessage, null, null, false, true);
        }
    }

    public boolean hasVoteForSpeed(Speed s) {
        for (Map.Entry<Integer, Speed> kv : this.speedVoters.entrySet()) {
            Speed sv;
            if (!this.channelPlayers.containsKey(kv.getKey()) || !this.map.empires.contains(this.channelPlayers.get((Object)kv.getKey()).empire) || s != (sv = kv.getValue())) continue;
            return true;
        }
        return false;
    }

    public void updateSpeedVote() {
        this.speed = Speed.CHEETAH;
        boolean allStop = true;
        ArrayList<Integer> keys = new ArrayList<Integer>(this.speedVoters.keySet());
        Collections.sort(keys);
        for (int id : keys) {
            if (!this.channelPlayers.containsKey(id) || !this.map.empires.contains(this.channelPlayers.get((Object)Integer.valueOf((int)id)).empire)) continue;
            Speed sv = this.speedVoters.get(id);
            if (sv == Speed.STOP) {
                sv = Speed.NORMAL;
            } else {
                allStop = false;
            }
            if (sv.msMult >= this.speed.msMult) continue;
            this.speed = sv;
        }
        if (allStop) {
            this.speed = Speed.STOP;
        }
    }

    public boolean someoneWon() {
        return this.map.victor() != null;
    }

    public String winnerName() {
        Empire v = this.map.victor();
        return v == null ? "?" : v.getName();
    }

    public boolean victory() {
        return this.player != null && this.map.victor() == this.player;
    }

    public boolean defeat() {
        return this.player != null && this.player.cities.isEmpty();
    }

    public CampaignWorld(long seed, MapSize size, DifficultyLevel difficulty, AirshipGame g, List<StrategicSetupInfo> playerInfos, int playerEmpireIndex, Locale lang, SeaLevelSetting seaLevelSetting, MonsterSetting monsterity, TechSpeedSetting techSpeed, int startingTechTier, boolean strategicRapidCommands) {
        this(seed, size, difficulty, g, playerInfos, playerEmpireIndex, lang, seaLevelSetting, monsterity, techSpeed, startingTechTier, strategicRapidCommands, null, null, new HashMap<Integer, StrategicPlayerInfo>());
    }

    public CampaignWorld(long seed, MapSize size, DifficultyLevel difficulty, AirshipGame g, List<StrategicSetupInfo> setupInfos, int playerEmpireIndex, Locale lang, SeaLevelSetting seaLevelSetting, MonsterSetting monsterity, TechSpeedSetting techSpeed, int startingTechTier, boolean strategicRapidCommands, Client client, Server server, HashMap<Integer, StrategicPlayerInfo> channelPlayers) {
        this.map = new WorldMap(seed, size, difficulty, g, setupInfos, lang, seaLevelSetting, monsterity, techSpeed, startingTechTier, strategicRapidCommands);
        this.playerEmpireIndex = playerEmpireIndex;
        this.g = g;
        this.mpClient = client;
        this.mpServer = server;
        this.channelPlayers = channelPlayers;
        if (channelPlayers != null && !channelPlayers.isEmpty()) {
            this.speedVoters = new HashMap();
            for (int id : channelPlayers.keySet()) {
                this.speedVoters.put(id, Speed.NORMAL);
            }
        }
    }

    public void setupPlayer() {
        this.player = this.playerEmpireIndex == -1 ? null : this.map.empires.get(this.playerEmpireIndex);
    }

    public CampaignWorld(WorldMap map, Empire player, AirshipGame g) {
        this.map = map;
        this.player = player;
        this.g = g;
    }

    public CampaignWorld(JSONObject o, AirshipGame g, boolean multiplayer) {
        if (!READABLE_VERSIONS.contains(o.optInt("version", 0))) {
            throw new RuntimeException("Incompatible save version: " + o.optInt("version", 0));
        }
        this.map = new WorldMap(o.getJSONObject("map"), g);
        if (multiplayer) {
            this.player = o.getInt("player") == -1 ? null : this.map.empires.get(o.getInt("player"));
        } else {
            this.player = this.map.empires.get(0);
            for (Empire e : this.map.empires) {
                e.playerControlled = e == this.player;
            }
        }
        this.speed = Speed.NORMAL;
        this.g = g;
        if (o.has("helpCleared")) {
            JSONArray hc = o.getJSONArray("helpCleared");
            for (int i = 0; i < hc.length(); ++i) {
                this.help.cleared.add(StrategicHelp.Type.valueOf(hc.getString(i)));
            }
        } else {
            this.help.cleared.addAll(EnumSet.allOf(StrategicHelp.Type.class));
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = new JSONObject().put("version", 10620).put("map", this.map.toJSON()).put("player", this.map.empires.indexOf(this.player)).put("speed", this.speed.name()).put("combatSetup", this.waitingForCombatSetup || this.multiplayerCampaignCombatSetupIntent != null);
        JSONArray helpCleared = new JSONArray();
        o.put("helpCleared", helpCleared);
        for (StrategicHelp.Type t : this.help.cleared) {
            helpCleared.put(t.name());
        }
        JSONArray mods = new JSONArray();
        for (Mod m : Mod.getEnabledMods()) {
            mods.put(new JSONObject().put("id", m.id));
        }
        o.put("mods", mods);
        return o;
    }

    public void tick(int ms) {
        if (this.isMultiplayer()) {
            int fqsz;
            JSONObject msg = this.g.pollMessage();
            if (msg != null && msg.getString("type").equals("frame")) {
                this.frameQueue.add(msg);
            }
            if ((fqsz = this.frameQueue.size()) == 0) {
                return;
            }
            if (fqsz < 3) {
                ms /= 2;
            } else if (fqsz == 3) {
                ms = ms * 3 / 4;
            } else if (fqsz > 45) {
                ms *= 4;
            } else if (fqsz > 15) {
                ms *= 2;
            } else if (fqsz > 7) {
                ms = ms * 3 / 2;
            }
        }
        this.accumulatedMs += ms;
        while (this.accumulatedMs >= 16) {
            if (this.waitingForCombatSetup || this.isMultiplayer() && this.frameQueue.isEmpty()) {
                return;
            }
            this.accumulatedMs -= 16;
            this.doTick();
            if (this.combatInfo == null || !this.combatInfo.combat.isFinished()) continue;
            return;
        }
    }

    public void membershipUpdate(JSONObject frame) {
        JSONArray members = frame.getJSONArray("members");
        for (int i = 0; i < members.length(); ++i) {
            int id = members.getInt(i);
            boolean isInChannel = false;
            for (int inID : this.channelPlayers.keySet()) {
                if (id != inID) continue;
                isInChannel = true;
            }
            if (isInChannel) continue;
            this.g.sendMessage(new JSONObject().put("type", "goAway").put("id", id));
        }
        ArrayList<Integer> playerIDs = new ArrayList<Integer>(this.channelPlayers.keySet());
        Collections.sort(playerIDs);
        for (int playerID : playerIDs) {
            StrategicPlayerInfo disc;
            boolean isPresent = false;
            for (int i = 0; i < members.length(); ++i) {
                if (members.getInt(i) != playerID) continue;
                isPresent = true;
            }
            if (!isPresent) {
                disc = this.channelPlayers.get(playerID);
                if (disc.empire != null && this.map.empires.contains(disc.empire)) {
                    this.disconnectedPlayers.add(disc);
                    disc.empire.playerControlled = false;
                }
                this.channelPlayers.remove(playerID);
                continue;
            }
            disc = this.channelPlayers.get(playerID);
            if (disc.empire == null || !disc.empire.cities.isEmpty() || !disc.empire.playerControlled || this.defeatedPlayers.contains(disc) || disc.empire == this.player) continue;
            this.defeatedPlayers.add(disc);
        }
        this.updateSpeedVote();
    }

    public boolean isAboutToChecksum() {
        boolean isTickAge = (this.combatStarted() ? this.combatInfo.combat.time : this.map.age) % 10000 > 9000;
        return !this.inCombatSetup() && isTickAge && (!this.desyncDetected || this.map.age < this.desyncDetectedAt + 20000 + 1000);
    }

    private void doTick() {
        int quantum;
        int iters;
        if (this.isMultiplayer()) {
            boolean isTickAge;
            if (this.multiplayerCampaignCombatIntent != null && this.multiplayerCampaignCombatIntent.runInitProcess()) {
                return;
            }
            boolean bl = isTickAge = (this.combatStarted() ? this.combatInfo.combat.time : this.map.age) % 10000 == 0;
            if (!(this.inCombatSetup() || !isTickAge || this.desyncDetected && this.map.age >= this.desyncDetectedAt + 20000 + 1000)) {
                StoredState ss = new StoredState(this, this.g.playerID());
                this.g.sendMessage(Client.msg("strategicChecksum").put("age", ss.age).put("combatTime", ss.combatTime).put("hash", ss.hash).put("playerID", this.g.playerID()));
                if (!this.desyncDetected) {
                    this.storedStates.add(ss);
                    Utils.Pair k = new Utils.Pair((Object)ss.age, (Object)ss.combatTime);
                    if (this.futureChecksums.containsKey(k)) {
                        for (JSONObject cmd : this.futureChecksums.get(k)) {
                            CampaignWorld.checkStrategicChecksum(cmd, ss, this);
                        }
                        this.futureChecksums.remove(k);
                    }
                }
            }
            this.frameAccumulatedMs += 16;
            if (this.frameAccumulatedMs >= 64) {
                this.frameAccumulatedMs -= 64;
                JSONObject frame = this.frameQueue.pollFirst();
                frame.put("mapAge", this.map.age);
                frame.put("preSpeed", this.speed.name());
                this.consumedFrames.put(frame);
                JSONArray messages = frame.getJSONArray("messages");
                for (int i = 0; i < messages.length(); ++i) {
                    JSONObject msg = messages.getJSONObject(i);
                    if (this.combatInfo != null) {
                        if (EXECS.containsKey(msg.getString("type"))) {
                            this.execCommand(msg);
                            continue;
                        }
                        if (this.multiplayerCampaignCombatSetupIntent != null) {
                            this.multiplayerCampaignCombatSetupIntent.execCommand(msg);
                            continue;
                        }
                        this.combatInfo.combat.execCommand(msg);
                        continue;
                    }
                    this.execCommand(msg);
                }
                this.membershipUpdate(frame);
                frame.put("postSpeed", this.speed.name());
            }
        }
        if (this.combatInfo != null) {
            if (!this.waitingForCombatSetup) {
                if (this.multiplayerCampaignCombatSetupIntent == null) {
                    Combat.Side viewingSide = null;
                    if (this.combatInfo.attacker(this.map) == this.player) {
                        viewingSide = this.combatInfo.combat.sides.get(0);
                    } else if (this.combatInfo.defender(this.map) == this.player) {
                        viewingSide = this.combatInfo.combat.sides.get(1);
                    }
                    for (int n = 0; n < this.combatInfo.combat.speed.mult; ++n) {
                        this.combatInfo.combat.doGenericTick(16, viewingSide, this.combatInfo.combat.timeOfDay.effect.lightning);
                    }
                    this.multiplayerCampaignCombatIntent.update();
                } else {
                    this.multiplayerCampaignCombatSetupIntent.update(16);
                }
            }
            return;
        }
        if (this.isMultiplayer()) {
            iters = this.speed.msMult;
            quantum = 2;
        } else {
            iters = 1;
            quantum = 2 * this.speed.msMult;
        }
        for (int i = 0; i < iters; ++i) {
            ArrayList<Empire> empires = new ArrayList<Empire>(this.map.empires);
            this.map.smartEmpireIndex = (this.map.smartEmpireIndex + 1) % empires.size();
            for (Empire e : empires) {
                if (e.cities.isEmpty()) {
                    this.map.removeEmpire(e);
                    continue;
                }
                if (e.playerControlled || !this.map.empires.contains(e)) continue;
                StrategicAI.tick(this, this.map, e, empires.indexOf(e) == this.map.smartEmpireIndex ? quantum : 0);
            }
            this.map.tick(quantum, this.isMultiplayer());
            for (Empire e : new ArrayList<Empire>(this.map.empires)) {
                this.map.resolveUncontestedSeaIntercepts(e);
            }
            this.map.cleanupMissingInterceptFleets("post sea intercept");
            this.map.quickResolveCombats(this.map.r);
            this.map.cleanupMissingInterceptFleets("post quick resolve");
            this.combatInfo = this.map.getNextCombat(this.g, this);
            if (this.combatInfo == null) continue;
            this.waitingForCombatSetup = true;
            return;
        }
    }

    public CombatOutcome postCombat(boolean uncontested) {
        CombatOutcome co;
        CombatOutcome.CombatOutcomeType type;
        Fleet garrison;
        boolean isIntercept;
        FleetOwner attacker = this.map.owner(this.combatInfo.attackingFleet);
        FleetOwner defender = this.combatInfo.defendingLoc == null ? this.map.owner(this.combatInfo.defendingFleet) : this.map.defender(this.combatInfo.defendingLoc);
        boolean attackerWon = this.combatInfo.combat.won(this.combatInfo.combat.sides.get(0));
        if (!(attackerWon || attacker instanceof Empire && ((Empire)attacker).playerControlled || this.combatInfo.defendingLoc == null || !(attacker instanceof Empire))) {
            StrategicAI.attackFailed((Empire)attacker, this.combatInfo.defendingLoc, this.combatInfo.attackerAIValue, this.combatInfo.defenderAIValue);
        }
        boolean defenderWon = this.combatInfo.combat.won(this.combatInfo.combat.sides.get(1));
        boolean bl = isIntercept = this.combatInfo.attackingFleet.interceptTarget != null;
        if (attackerWon && !this.combatInfo.combat.sides.get((int)1).fledInSetup) {
            this.combatInfo.combat.pruneTrappedShips(1);
        }
        if (defenderWon && !this.combatInfo.combat.sides.get((int)0).fledInSetup) {
            this.combatInfo.combat.pruneTrappedShips(0);
        }
        this.combatInfo.combat.pruneUselessShips();
        this.combatInfo.combat.repairShips();
        ArrayList<Airship> originalShips = new ArrayList<Airship>(this.combatInfo.attackingFleet.actives);
        originalShips.addAll(this.combatInfo.attackingFleet.reserve);
        this.combatInfo.attackingFleet.actives.clear();
        for (Airship sh : this.combatInfo.combat.sides.get((int)0).ships) {
            if (!sh.type.mobile) continue;
            this.combatInfo.attackingFleet.actives.add(sh);
        }
        this.combatInfo.attackingFleet.reserve.clear();
        for (Airship sh : this.combatInfo.combat.sides.get((int)0).reserve) {
            if (!sh.type.mobile) continue;
            this.combatInfo.attackingFleet.reserve.add(sh);
        }
        if (attacker instanceof Empire && ((Empire)attacker).playerControlled && this.combatInfo.defendingLoc != null) {
            for (Airship orig : originalShips) {
                if (this.combatInfo.attackingFleet.actives.contains(orig) || this.combatInfo.attackingFleet.reserve.contains(orig)) continue;
                this.combatInfo.defendingLoc.addMessage(MapLocation.MessageType.LOST_SHIP, Lang._t("Lost_x", orig.getName()));
            }
        }
        if (this.combatInfo.attackingFleet.actives.isEmpty() && this.combatInfo.attackingFleet.reserve.isEmpty()) {
            attacker.getFleets().remove(this.combatInfo.attackingFleet);
            this.combatInfo.attackingFleet.broadcastDestroyed(this.map);
        } else if (attacker instanceof MonsterNest) {
            if (!this.combatInfo.attackingFleet.travelTo((MonsterNest)attacker, this.map)) {
                Iterator<Airship> it = this.combatInfo.attackingFleet.actives.iterator();
                while (it.hasNext()) {
                    if (!it.next().type.onGround) continue;
                    it.remove();
                }
                it = this.combatInfo.attackingFleet.reserve.iterator();
                while (it.hasNext()) {
                    if (!it.next().type.onGround) continue;
                    it.remove();
                }
                if (this.combatInfo.attackingFleet.actives.isEmpty() && this.combatInfo.attackingFleet.reserve.isEmpty()) {
                    attacker.getFleets().remove(this.combatInfo.attackingFleet);
                    this.combatInfo.attackingFleet.broadcastDestroyed(this.map);
                } else {
                    this.combatInfo.attackingFleet.travelTo((MonsterNest)attacker, this.map);
                }
            }
        } else if (!attackerWon || this.combatInfo.attackingFleet.interceptTarget != null) {
            this.combatInfo.attackingFleet.stopAndAskForHelp(this.map);
        }
        if (this.combatInfo.defendingFleet != null) {
            originalShips = new ArrayList<Airship>(this.combatInfo.defendingFleet.actives);
            originalShips.addAll(this.combatInfo.defendingFleet.reserve);
            this.combatInfo.defendingFleet.actives.clear();
            this.combatInfo.defendingFleet.reserve.clear();
            if (!attackerWon || !isIntercept) {
                for (Airship ship : this.combatInfo.combat.sides.get((int)1).ships) {
                    if (!ship.type.mobile) continue;
                    this.combatInfo.defendingFleet.actives.add(ship);
                }
                this.combatInfo.defendingFleet.reserve.addAll(this.combatInfo.combat.sides.get((int)1).reserve);
            }
            if (this.combatInfo.defendingFleet.actives.isEmpty() && this.combatInfo.defendingFleet.reserve.isEmpty()) {
                defender.getFleets().remove(this.combatInfo.defendingFleet);
                this.combatInfo.defendingFleet.broadcastDestroyed(this.map);
            } else if (attackerWon) {
                this.combatInfo.defendingFleet.stopAndAskForHelp(this.map);
            }
            if (defender instanceof Empire && ((Empire)defender).playerControlled && this.combatInfo.defendingLoc != null) {
                for (Airship orig : originalShips) {
                    if (this.combatInfo.defendingFleet.actives.contains(orig) || this.combatInfo.defendingFleet.reserve.contains(orig)) continue;
                    this.combatInfo.defendingLoc.addMessage(MapLocation.MessageType.LOST_SHIP, Lang._t("Lost_x", orig.getName()));
                }
            }
        }
        if (this.combatInfo.defendingLoc != null) {
            this.combatInfo.defendingLoc.clearDefences();
            for (Airship building : this.combatInfo.combat.sides.get((int)1).ships) {
                if (building.type.mobile) continue;
                this.combatInfo.defendingLoc.addDefence(building);
            }
            for (Airship building : this.combatInfo.combat.sides.get((int)0).ships) {
                if (building.type.mobile) continue;
                this.combatInfo.defendingLoc.addDefence(building);
            }
            if (attackerWon) {
                Empire winner;
                if (attacker instanceof Empire && defender instanceof Empire && this.combatInfo.defendingLoc instanceof City) {
                    winner = (Empire)attacker;
                    Empire loser = (Empire)defender;
                    City city = (City)this.combatInfo.defendingLoc;
                    loser.cities.remove(city);
                    if (loser.cities.isEmpty()) {
                        this.map.removeEmpire(loser);
                    }
                    winner.cities.add(city);
                    for (MapLocation.ConstructionEntry c : city.constructing) {
                        winner.money += c.cost / 10;
                    }
                    city.constructing.clear();
                    city.takeoverAmount = 0;
                    city.takeoverMethod = null;
                    city.constructionProgress = 0;
                    if (EmpireStat.TAKEOVER_NEEDED.get(winner.bonuses()).booleanValue() && city.originalEmpire != attacker) {
                        city.takeoverNeeded = true;
                    }
                }
                if (attacker instanceof Empire && defender instanceof MonsterNest && defender == this.combatInfo.defendingLoc) {
                    winner = (Empire)attacker;
                    MonsterNest nest = (MonsterNest)this.combatInfo.defendingLoc;
                    nest.type.giveRewardTo(winner, this.map);
                    HashMap<Empire, String> altTexts = new HashMap<Empire, String>();
                    for (Empire e : this.map.empires) {
                        String bs = nest.type.bonusSuffix(e);
                        if (bs.isEmpty()) continue;
                        altTexts.put(e, Lang._t("x_defeats_" + nest.type.name + bs, attacker.getName()));
                    }
                    nest.addMessage(MapLocation.MessageType.COMBAT, Lang._t("x_defeats_" + nest.type.name, attacker.getName()), altTexts);
                    nest.clear(this.map);
                }
            }
            this.combatInfo.defendingLoc.floaters.clear();
            if (this.combatInfo.combat.landFormations.size() > 1) {
                this.combatInfo.defendingLoc.floaters.addAll(this.combatInfo.combat.landFormations.subList(1, this.combatInfo.combat.landFormations.size()));
            }
            if (attacker instanceof MonsterNest && !this.combatInfo.attackingFleet.getAllShips().isEmpty() && this.combatInfo.defendingLoc instanceof City) {
                MonsterNest attackerNest = (MonsterNest)attacker;
                if (attackerWon) {
                    this.combatInfo.combat.lootAmount = StrictMath.min(3, 4 - ((City)this.combatInfo.defendingLoc).economicDamage);
                }
                attackerNest.money += 650 * this.combatInfo.combat.lootAmount;
                if (!attackerNest.upgrading) {
                    attackerNest.upgradeAccumulator += this.combatInfo.combat.lootAmount * attackerNest.type.upgradeMsPerRaidSuccess;
                }
                ((City)this.combatInfo.defendingLoc).economicDamage += this.combatInfo.combat.lootAmount;
                if (this.combatInfo.combat.lootAmount > 0) {
                    ((City)this.combatInfo.defendingLoc).addMessage(MapLocation.MessageType.COMBAT, Lang._t("raiding_looted_" + this.combatInfo.combat.lootAmount, new Object[0]));
                }
            }
        }
        if (this.combatInfo.defendingLoc != null && (garrison = this.map.getGarrison(this.combatInfo.defendingLoc)) != null) {
            this.combatInfo.defendingLoc.layoutGarrison(garrison);
        }
        if (this.combatInfo.defendingFleet != null && !this.combatInfo.attackingFleet.canFly() && this.combatInfo.attackingFleet.usingRoad == null && this.combatInfo.attackingFleet.location == null) {
            this.combatInfo.attackingFleet.usingRoad = this.combatInfo.defendingFleet.usingRoad;
            this.combatInfo.attackingFleet.destination = this.combatInfo.defendingFleet.destination;
            this.combatInfo.attackingFleet.progress = this.combatInfo.defendingFleet.progress;
            this.combatInfo.attackingFleet.stopAndAskForHelp(this.map);
        }
        if (this.combatInfo.defendingFleet != null && this.combatInfo.defendingFleet.location == null && !this.combatInfo.defendingFleet.canFly() && this.combatInfo.defendingFleet.usingRoad == null) {
            this.combatInfo.defendingFleet.usingRoad = this.combatInfo.attackingFleet.usingRoad;
            this.combatInfo.defendingFleet.destination = this.combatInfo.attackingFleet.destination;
            this.combatInfo.defendingFleet.progress = this.combatInfo.attackingFleet.progress;
            this.combatInfo.defendingFleet.stopAndAskForHelp(this.map);
        }
        this.map.cleanupMissingInterceptFleets("post combat");
        if (attacker instanceof MonsterNest) {
            ((MonsterNest)attacker).repairAll(this.map);
        }
        if (defender instanceof MonsterNest) {
            ((MonsterNest)defender).repairAll(this.map);
        }
        CombatOutcome.CombatOutcomeType combatOutcomeType = type = attacker == this.player || defender == this.player ? CombatOutcome.CombatOutcomeType.DRAW : null;
        if (uncontested) {
            if (attackerWon) {
                type = attacker == this.player ? CombatOutcome.CombatOutcomeType.UNCONTESTED_VICTORY : (defender == this.player ? CombatOutcome.CombatOutcomeType.UNCONTESTED_DEFEAT : null);
            } else if (defenderWon) {
                type = attacker == this.player ? CombatOutcome.CombatOutcomeType.UNCONTESTED_DEFEAT : (defender == this.player ? CombatOutcome.CombatOutcomeType.UNCONTESTED_VICTORY : null);
            }
        } else if (attackerWon) {
            type = attacker == this.player ? CombatOutcome.CombatOutcomeType.VICTORY : (defender == this.player ? CombatOutcome.CombatOutcomeType.DEFEAT : null);
        } else if (defenderWon) {
            CombatOutcome.CombatOutcomeType combatOutcomeType2 = attacker == this.player ? CombatOutcome.CombatOutcomeType.DEFEAT : (type = defender == this.player ? CombatOutcome.CombatOutcomeType.VICTORY : null);
        }
        CombatOutcome combatOutcome = type == null ? null : (co = new CombatOutcome(type, (int)this.combatInfo.attackingFleet.realX(), (int)this.combatInfo.attackingFleet.realY(), this.combatInfo.defendingLoc, attacker == this.player ? defender.getName() : attacker.getName()));
        if (co == null && this.combatInfo.defendingLoc != null) {
            if (attackerWon) {
                this.combatInfo.defendingLoc.addMessage(MapLocation.MessageType.COMBAT, Lang._t("x_conquers_y", attacker.getName(), this.combatInfo.defendingLoc.getDisplayName()));
            } else if (defenderWon) {
                this.combatInfo.defendingLoc.addMessage(MapLocation.MessageType.COMBAT, Lang._t("x_repels_y", this.combatInfo.defendingLoc.getDisplayName(), attacker.getName()));
            }
        }
        this.combatInfo = null;
        return co;
    }

    static {
        EXECS.put("ping", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap map, CampaignWorld cw) {
            }
        });
        EXECS.put("goAway", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap map, CampaignWorld cw) {
            }
        });
        EXECS.put("strategicChecksum", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                if (w.desyncDetected) {
                    return;
                }
                int age = cmd.getInt("age");
                int combatTime = cmd.getInt("combatTime");
                StoredState state = null;
                for (StoredState ss : w.storedStates) {
                    if (ss.age != age || ss.combatTime != combatTime) continue;
                    state = ss;
                    break;
                }
                if (state == null) {
                    Utils.Pair k = new Utils.Pair((Object)age, (Object)combatTime);
                    if (!w.futureChecksums.containsKey(k)) {
                        w.futureChecksums.put(k, new ArrayList());
                    }
                    ((ArrayList)w.futureChecksums.get(k)).add(cmd);
                } else {
                    CampaignWorld.checkStrategicChecksum(cmd, state, w);
                }
            }
        });
        EXECS.put("buildShip", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Airship ship = new Airship(new JSONObject(Compression.decompressFromString(cmd.getString("ship"))));
                City c = m.getCity(cmd.getInt("city"));
                ship.networkID = m.owner(c).getNextShipID();
                if (ship.type.onGround && !ship.type.mobile && cmd.has("landscapeGY")) {
                    c.ground.doLandscapingForBuilding(ship, ship.getX(), cmd.getInt("landscapeGY"), ship.flipped);
                    m.owner((City)c).money -= cmd.getInt("landscapeCost");
                }
                c.constructing.add(new MapLocation.ConstructionEntry(ship, ship.getCost(), c.constructionEntryIDCounter++));
                m.owner((City)c).money -= ship.getCost();
            }
        });
        EXECS.put("cancelShipConstruction", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                City c = m.getCity(cmd.getInt("city"));
                int id = cmd.getInt("id");
                MapLocation.ConstructionEntry ce = null;
                for (MapLocation.ConstructionEntry e : c.constructing) {
                    if (e.id != id) continue;
                    ce = e;
                }
                if (ce == null) {
                    return;
                }
                m.owner((City)c).money += c.refund(ce);
                if (c.constructing.get(0) == ce) {
                    c.constructionProgress = 0;
                }
                if (ce.original != null) {
                    if (ce.original.type == ShipType.BUILDING) {
                        c.defences.add(ce.original);
                    } else {
                        m.owner(c).addShipAt(ce.original, c, m);
                    }
                }
                c.constructing.remove(ce);
            }
        });
        EXECS.put("rebuildShip", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Airship newShip = new Airship(new JSONObject(Compression.decompressFromString(cmd.getString("newShip"))));
                City c = m.getCity(cmd.getInt("city"));
                Empire e = m.owner(c);
                Airship original = CampaignWorld.getShip(cmd, m);
                if (original == null) {
                    return;
                }
                e.remove(original, m);
                int cost = newShip.getRefitCostFrom(original);
                newShip.networkID = original.networkID;
                newShip.setX(original.getX());
                newShip.setY(original.getY());
                newShip.setName(original.getName());
                newShip.updateOriginalDesign();
                e.money -= cost;
                c.constructing.add(new MapLocation.ConstructionEntry(newShip, original, cost, MapLocation.ConstructionEntry.Type.valueOf(cmd.getString("constructionType")), c.constructionEntryIDCounter++));
            }
        });
        EXECS.put("placeDefencesShip", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Airship ship = CampaignWorld.getShip(cmd, m);
                if (ship == null) {
                    return;
                }
                City c = m.getCity(cmd.getInt("city"));
                Fleet garrison = m.getGarrison(c);
                if (ship.type.mobile && garrison != null && garrison.reserve.contains(ship)) {
                    garrison.reserve.remove(ship);
                    garrison.actives.add(ship);
                }
                ship.setX(cmd.getDouble("x"));
                ship.setY(cmd.getDouble("y"));
                ship.moveTo = new Pt(ship.getX(), ship.getY());
                ship.setFlipped(cmd.getBoolean("flipped"), null);
                ship.flipTo = cmd.getBoolean("flipped");
                ship.lastPlaced = new Pt(ship.getX(), ship.getY());
                ship.lastPlacedFlipped = ship.flipped;
                ship.resetWeaponBarrels();
                ship.resetTentaclesForFlipped();
                if (ship.type.onGround && !ship.type.mobile && cmd.has("landscapeGY")) {
                    c.ground.doLandscapingForBuilding(ship, ship.getX(), cmd.getInt("landscapeGY"), ship.flipped);
                    m.owner((City)c).money -= cmd.getInt("landscapeCost");
                }
            }
        });
        EXECS.put("placeConstructionShip", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                City c = m.getCity(cmd.getInt("city"));
                PhysicsRect ship = null;
                for (MapLocation.ConstructionEntry ce : c.constructing) {
                    if (!ce.ship.networkID.equals(cmd.getString("networkID"))) continue;
                    ship = ce.ship;
                }
                if (ship == null) {
                    return;
                }
                ship.setX(cmd.getDouble("x"));
                ship.setY(cmd.getDouble("y"));
                ((Airship)ship).moveTo = new Pt(ship.getX(), ship.getY());
                ((Airship)ship).setFlipped(cmd.getBoolean("flipped"), null);
                ((Airship)ship).flipTo = cmd.getBoolean("flipped");
                ((Airship)ship).lastPlaced = new Pt(ship.getX(), ship.getY());
                ((Airship)ship).lastPlacedFlipped = ((Airship)ship).flipped;
                ((Airship)ship).resetWeaponBarrels();
                ((Airship)ship).resetTentaclesForFlipped();
                if (((Airship)ship).type.onGround && !((Airship)ship).type.mobile && cmd.has("landscapeGY")) {
                    c.ground.doLandscapingForBuilding((Airship)ship, ship.getX(), cmd.getInt("landscapeGY"), ((Airship)ship).flipped);
                    m.owner((City)c).money -= cmd.getInt("landscapeCost");
                }
            }
        });
        EXECS.put("reserveDefencesShip", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Airship ship = CampaignWorld.getShip(cmd, m);
                if (ship == null) {
                    return;
                }
                Fleet garrison = m.getGarrison(m.getCity(cmd.getInt("city")));
                if (ship.type.mobile && garrison != null && garrison.actives.contains(ship)) {
                    garrison.actives.remove(ship);
                    garrison.reserve.add(ship);
                }
            }
        });
        EXECS.put("scrapShip", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Airship ship = CampaignWorld.getShip(cmd, m);
                if (ship == null) {
                    return;
                }
                Empire e = m.getEmpire(cmd.getInt("empire"));
                if (e == null) {
                    return;
                }
                e.scrap(ship, m);
            }
        });
        EXECS.put("scuttleShip", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Airship ship = CampaignWorld.getShip(cmd, m);
                if (ship == null) {
                    return;
                }
                Empire e = m.getEmpire(cmd.getInt("empire"));
                if (e == null) {
                    return;
                }
                e.remove(ship, m);
            }
        });
        EXECS.put("renameShip", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Airship ship = CampaignWorld.getShip(cmd, m);
                if (ship == null) {
                    return;
                }
                ship.setName(cmd.getString("newName"));
            }
        });
        EXECS.put("sendFleet", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Fleet f = m.getFleet(cmd.getInt("id"));
                if (f == null) {
                    return;
                }
                ArrayList<Airship> ships = new ArrayList<Airship>();
                JSONArray s = cmd.getJSONArray("ships");
                for (int i = 0; i < s.length(); ++i) {
                    Airship ship = f.getShip(s.getString(i));
                    if (ship == null) continue;
                    ships.add(ship);
                }
                if (ships.isEmpty()) {
                    return;
                }
                m.travelTo(f, ships, m.getMapLocation(cmd.getInt("destination")));
            }
        });
        EXECS.put("intercept", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Fleet f = m.getFleet(cmd.getInt("fleet"));
                if (f == null) {
                    return;
                }
                FleetOwner owner = m.owner(f);
                ArrayList<Airship> ships = new ArrayList<Airship>();
                JSONArray s = cmd.getJSONArray("ships");
                for (int i = 0; i < s.length(); ++i) {
                    Airship ship = f.getShip(s.getString(i));
                    if (ship == null) continue;
                    ships.add(ship);
                }
                if (ships.isEmpty()) {
                    return;
                }
                Fleet target = m.getFleet(cmd.getInt("target"));
                if (target == null) {
                    return;
                }
                if (ships.containsAll(f.actives) && ships.containsAll(f.reserve)) {
                    if (f.doIntercept(target, m)) {
                        f.broadcastChangedDirection(m);
                    }
                } else {
                    Fleet newFleet = new Fleet(f, m);
                    newFleet.actives.retainAll(ships);
                    newFleet.reserve.retainAll(ships);
                    if (newFleet.doIntercept(target, m)) {
                        owner.getFleets().add(newFleet);
                        f.actives.removeAll(ships);
                        f.reserve.removeAll(ships);
                        if (f.location != null && m.defender(f.location) == owner) {
                            f.location.layoutGarrison(f);
                        }
                        newFleet.broadcastChangedDirection(m);
                    }
                }
            }
        });
        EXECS.put("sendSpy", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Empire e = m.getEmpire(cmd.getInt("empire"));
                if (e == null) {
                    return;
                }
                e.spies.add(new Spy(m.getCity(cmd.getInt("city"))));
                e.money -= 100;
            }
        });
        EXECS.put("recallSpy", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Empire e = m.getEmpire(cmd.getInt("empire"));
                if (e == null) {
                    return;
                }
                e.spies.remove(e.getSpyFor(m.getCity(cmd.getInt("city"))));
            }
        });
        EXECS.put("citySpyAction", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Spy.CitySpyAction a = Spy.CitySpyAction.valueOf(cmd.getString("action"));
                Empire e = m.getEmpire(cmd.getInt("empire"));
                if (e == null) {
                    return;
                }
                City c = m.getCity(cmd.getInt("city"));
                m.doCitySpyAction(a, e, c);
            }
        });
        EXECS.put("shipSpyAction", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Spy.ShipSpyAction a = Spy.ShipSpyAction.valueOf(cmd.getString("action"));
                Empire e = m.getEmpire(cmd.getInt("empire"));
                if (e == null) {
                    return;
                }
                City c = m.getCity(cmd.getInt("city"));
                Airship ship = CampaignWorld.getShip(cmd, m);
                if (ship == null) {
                    return;
                }
                m.doShipSpyAction(a, e, c, ship);
            }
        });
        EXECS.put("setSecretPoliceLevel", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Empire e = m.getEmpire(cmd.getInt("empire"));
                if (e == null) {
                    return;
                }
                e.policeLevel = SecretPoliceLevel.valueOf(cmd.getString("level"));
            }
        });
        EXECS.put("setResearch", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Empire e = m.getEmpire(cmd.getInt("empire"));
                if (e == null) {
                    return;
                }
                e.researchPoints = 0;
                e.research = Tech.ofName(cmd.getString("tech")).getChoice(cmd.getString("choice"));
            }
        });
        EXECS.put("setResearchSpeed", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Empire e = m.getEmpire(cmd.getInt("empire"));
                if (e == null) {
                    return;
                }
                e.researchSpeed = ResearchSpeed.ofName(cmd.getString("speed"));
            }
        });
        EXECS.put("chooseTakeoverMethod", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                City c = m.getCity(cmd.getInt("city"));
                c.takeoverMethod = TakeoverMethod.valueOf(cmd.getString("method"));
                c.takeoverNeeded = false;
            }
        });
        EXECS.put("surrenderStrategic", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                if (m.empires.size() < 2) {
                    return;
                }
                Empire e = m.getEmpire(cmd.getInt("empire"));
                if (e == null) {
                    return;
                }
                HashMap<City, Empire> newOwners = new HashMap<City, Empire>();
                for (City c : e.cities) {
                    City closest = null;
                    int closestD2 = 0;
                    for (City c2 : m.cities()) {
                        if (e.cities.contains(c2)) continue;
                        int d2 = (c.x - c2.x) * (c.x - c2.x) + (c.y - c2.y) * (c.y - c2.y);
                        if (closest != null && d2 >= closestD2) continue;
                        closest = c2;
                        closestD2 = d2;
                    }
                    newOwners.put(c, m.owner(closest));
                }
                for (City c : e.cities) {
                    ((Empire)newOwners.get((Object)c)).cities.add(c);
                }
                for (Fleet f : e.getFleets()) {
                    f.broadcastDestroyed(m);
                }
                m.empires.remove(e);
                e.cities.clear();
                e.getFleets().clear();
            }
        });
        EXECS.put("magicWinStrategic", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap map, CampaignWorld cw) {
                if (!MAGIC_WIN_ENABLED) {
                    return;
                }
                Empire e = map.getEmpire(cmd.getInt("empire"));
                if (e == null) {
                    return;
                }
                for (Empire e2 : map.empires) {
                    if (e2 == e) continue;
                    for (Fleet f : e2.getFleets()) {
                        f.broadcastDestroyed(map);
                    }
                    e2.getFleets().clear();
                    e.cities.addAll(e2.cities);
                    e2.cities.clear();
                }
                map.empires.clear();
                map.empires.add(e);
            }
        });
        EXECS.put("chat", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                StrategicPlayerInfo pi = w.channelPlayers.get(cmd.getInt("id"));
                if (pi != null) {
                    w.chatMessages.add(new StrategicChatMsg(pi, pi.name + ": " + cmd.getString("text"), DateTime.now()));
                }
            }
        });
        EXECS.put("setCampaignSpeed", new CommandExecutor(){

            @Override
            public void run(JSONObject cmd, WorldMap m, CampaignWorld w) {
                Speed s = Speed.valueOf(cmd.getString("speed"));
                if (w.speedVoters != null) {
                    w.speedVoters.put(cmd.getInt("voterID"), s);
                    w.updateSpeedVote();
                } else {
                    w.speed = s;
                }
            }
        });
        READABLE_VERSIONS = new ArrayList<Integer>(Arrays.asList(10000, 10620));
    }

    public strictfp static enum Speed {
        STOP(0, new Img("ui", 96, 512, 16, 16, false)),
        QUARTER(1, new Img("ui", 240, 512, 16, 16, false)),
        HALF(2, new Img("ui", 288, 512, 16, 16, false)),
        NORMAL(4, new Img("ui", 112, 512, 16, 16, false)),
        FAST(12, new Img("ui", 128, 512, 16, 16, false)),
        CHEETAH(36, new Img("ui", 144, 512, 16, 16, false));

        public final int msMult;
        public final Img icon;

        private Speed(int msMult, Img icon) {
            this.msMult = msMult;
            this.icon = icon;
        }
    }

    public static interface CommandExecutor {
        public void run(JSONObject var1, WorldMap var2, CampaignWorld var3);
    }

    private strictfp static class StoredState {
        public final int age;
        public final int combatTime;
        public final int hash;
        public final String state;
        public HashSet<Integer> confirmedPlayerIDs = new HashSet();

        StoredState(CampaignWorld w, int myID) {
            this.age = w.map.age;
            if (w.combatInfo != null && w.combatStarted()) {
                this.state = Compression.compressToString(w.combatInfo.combat.toJSON().toString());
                this.combatTime = w.combatInfo.combat.time;
            } else {
                this.state = Compression.compressToString(w.map.toJSON().toString());
                this.combatTime = -1;
            }
            this.hash = this.state.hashCode();
            this.confirmedPlayerIDs.add(myID);
        }
    }
}

